/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.NPMPackageGenerator;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.SQLiteINpmPackageIndexBuilderDBImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DicomPackageBuilder {
    private String version;
    private String dest;
    private String source;
    private String pattern = "fhir.dicom#{version}.tgz";

    public static void main(String[] args) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        if (args.length == 0 || args[0].equals("-help")) {
            System.out.println("Dicom Package Builder");
            System.out.println("");
            System.out.println("Before running, use FTP get the latest copy of ftp://medical.nema.org/MEDICAL/Dicom/Resources");
            System.out.println("Then run with the following parameters (in order):");
            System.out.println("1. the local folder that contains the copy of the FTP folder");
            System.out.println("2. the local folder to put the package when it's created");
            System.out.println("");
            System.out.println("For help, see ");
            return;
        }
        String source = args[0];
        String dest = args[1];
        NpmPackageIndexBuilder.setExtensionFactory((NpmPackageIndexBuilder.INpmPackageIndexBuilderDBImplFactory)new SQLiteINpmPackageIndexBuilderDBImpl.SQLiteINpmPackageIndexBuilderDBImplFactory());
        DicomPackageBuilder self = new DicomPackageBuilder();
        self.setSource(source);
        self.setDest(dest);
        self.setPattern("{version}/package.tgz");
        self.execute();
    }

    public void execute() throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        System.out.println("DICOM: " + this.source + " -> " + this.dest);
        CodeSystem cs = this.buildCodeSystem();
        String fn = Utilities.path((String[])new String[]{this.dest, this.pattern.replace("{version}", this.version)});
        FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fn));
        NPMPackageGenerator gen = new NPMPackageGenerator(fn, this.buildPackage());
        int i = 2;
        gen.addFile(NPMPackageGenerator.Category.RESOURCE, "CodeSystem-" + cs.getId() + ".json", new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).composeBytes((Resource)cs));
        ValueSet vs = this.buildAllValueSet();
        gen.addFile(NPMPackageGenerator.Category.RESOURCE, "ValueSet-" + vs.getId() + ".json", new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).composeBytes((Resource)vs));
        HashSet<String> ids = new HashSet<String>();
        ids.add(vs.getId());
        for (File f : ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.source, "valuesets", "fhir", "json"})).listFiles()) {
            vs = (ValueSet)JsonParser.loadFile((InputStream)ManagedFileAccess.inStream((File)f));
            vs.setVersion(this.version);
            if (vs.getId().length() > 64) {
                vs.setId(vs.getId().substring(0, 64));
            }
            if (ids.contains(vs.getId())) {
                throw new Error("Duplicate Id (note Ids cut off at 64 char): " + vs.getId());
            }
            ids.add(vs.getId());
            gen.addFile(NPMPackageGenerator.Category.RESOURCE, "ValueSet-" + vs.getId() + ".json", new JsonParser().setOutputStyle(IParser.OutputStyle.NORMAL).composeBytes((Resource)vs));
            ++i;
        }
        gen.finish();
        System.out.println("Finished - " + i + " resources");
    }

    private ValueSet buildAllValueSet() {
        ValueSet vs = new ValueSet();
        vs.setId("all");
        vs.setUrl("http://dicom.nema.org/resources/ValueSet/all");
        vs.setVersion(this.version);
        vs.setName("AllDICOMTerminologyDefinitions");
        vs.setTitle("All DICOM Controlled Terminology Definitions");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setExperimental(false);
        vs.setPublisher("FHIR Project on behalf of DICOM");
        vs.setDate(new Date());
        vs.setDescription("All DICOM Code Definitions (Coding Scheme Designator \"DCM\" Coding Scheme Version " + this.version);
        vs.setPurpose("This value set is published as part of FHIR in order to make the codes available to FHIR terminology services and so implementers can easily leverage the codes");
        vs.setCopyright("These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright \u00c2\u00a9 2011 by the National Electrical Manufacturers Association.");
        vs.getCompose().getIncludeFirstRep().setSystem("http://dicom.nema.org/resources/ontology/DCM");
        return vs;
    }

    private JsonObject buildPackage() {
        JsonObject npm = new JsonObject();
        npm.add("tools-version", 3);
        npm.add("type", "Conformance");
        npm.add("license", "free");
        npm.add("author", "FHIR Project for DICOM");
        npm.add("name", "fhir.dicom");
        npm.add("url", "http://fhir.org/packages/fhir.dicom");
        npm.add("canonical", "http://fhir.org/packages/fhir.dicom");
        npm.add("version", this.version);
        JsonArray fv = new JsonArray();
        npm.add("fhirVersions", (JsonElement)fv);
        fv.add("4.0.1");
        JsonObject dep = new JsonObject();
        npm.add("dependencies", (JsonElement)dep);
        dep.add("hl7.fhir.r4.core", "4.0.1");
        return npm;
    }

    private CodeSystem buildCodeSystem() throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{this.source, "Ontology", "DCM", "dcm.owl"})));
        Element rdf = doc.getDocumentElement();
        Element d = XMLUtil.getFirstChild((Element)rdf);
        this.version = this.processVersion(XMLUtil.getNamedChildText((Element)d, (String)"versionInfo"));
        CodeSystem cs = new CodeSystem();
        cs.setId("DCM");
        cs.setUrl("http://dicom.nema.org/resources/ontology/DCM");
        cs.setVersion(this.version);
        cs.setName("DICOMTerminologyDefinitions");
        cs.setTitle("DICOM Controlled Terminology Definitions");
        cs.getIdentifier().add(new Identifier().setSystem("urn:ietf:rfc:3986").setValue("urn:oid:1.2.840.10008.2.16.4"));
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setExperimental(false);
        cs.setPublisher("FHIR Project on behalf of DICOM");
        cs.setDate(new Date());
        cs.setDescription("DICOM Code Definitions (Coding Scheme Designator \"DCM\" Coding Scheme Version " + this.version);
        cs.setPurpose("This code system is published as part of FHIR in order to make the codes available to FHIR terminology services and so implementers can easily leverage the codes");
        cs.setCopyright("These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright \u00c2\u00a9 2011 by the National Electrical Manufacturers Association.");
        cs.setCaseSensitive(true);
        cs.setValueSet("http://dicom.nema.org/resources/ValueSet/all");
        cs.setContent(Enumerations.CodeSystemContentMode.COMPLETE);
        d = XMLUtil.getNextSibling((Element)d);
        while (d != null) {
            String code = XMLUtil.getNamedChildText((Element)d, (String)"notation");
            String display = XMLUtil.getNamedChildText((Element)d, (String)"prefLabel");
            String definition = XMLUtil.getNamedChildText((Element)d, (String)"definition");
            CodeSystem.ConceptDefinitionComponent cc = new CodeSystem.ConceptDefinitionComponent();
            cs.getConcept().add(cc);
            cc.setCode(code);
            cc.setDisplay(display);
            cc.setDefinition(definition);
            d = XMLUtil.getNextSibling((Element)d);
        }
        return cs;
    }

    private String processVersion(String s) {
        String[] p = s.split("\\_");
        return p[0].substring(0, 4) + "." + (1 + (p[0].charAt(4) - 97)) + "." + p[1];
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

