/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.convertors.loaders.loaderR5.BaseLoaderR5;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor5;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4b.context.SimpleWorkerContext;
import org.hl7.fhir.r4b.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.turtle.Turtle;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.ResourceChecker;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.service.utils.Common;
import org.hl7.fhir.validation.service.utils.VersionSourceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgLoader
implements ValidationEngine.IValidationEngineLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IgLoader.class);
    private static final String[] IGNORED_EXTENSIONS = new String[]{"md", "css", "js", "png", "gif", "jpg", "html", "tgz", "pack", "zip"};
    private static final String[] EXEMPT_FILES = new String[]{"spec.internals", "version.info", "schematron.zip", "package.json"};
    private static final int SCAN_HEADER_SIZE = 2048;
    private final FilesystemPackageCacheManager packageCacheManager;
    private final org.hl7.fhir.r5.context.SimpleWorkerContext context;
    private final String version;
    private final boolean isDebug;
    private IDirectPackageProvider directProvider;

    public IgLoader(FilesystemPackageCacheManager packageCacheManager, org.hl7.fhir.r5.context.SimpleWorkerContext context, String theVersion) {
        this(packageCacheManager, context, theVersion, false);
    }

    public IgLoader(FilesystemPackageCacheManager packageCacheManager, org.hl7.fhir.r5.context.SimpleWorkerContext context, String theVersion, boolean isDebug) {
        this.packageCacheManager = packageCacheManager;
        this.context = context;
        this.version = theVersion;
        this.isDebug = isDebug;
    }

    public void loadIg(List<ImplementationGuide> igs, Map<String, ByteProvider> binaries, String src, boolean recursive) throws IOException, FHIRException {
        NpmPackage npm;
        String srcPackage;
        String explicitFhirVersion;
        if (src.startsWith("[") && src.indexOf(93, 1) > 1) {
            explicitFhirVersion = src.substring(1, src.indexOf(93, 1));
            srcPackage = src.substring(src.indexOf(93, 1) + 1);
            if (!VersionUtilities.isSupportedVersion((String)explicitFhirVersion)) {
                throw new FHIRException("Unsupported FHIR Version: " + explicitFhirVersion + " valid versions are " + VersionUtilities.listSupportedVersions());
            }
        } else {
            explicitFhirVersion = null;
            srcPackage = src;
        }
        NpmPackage npmPackage = npm = srcPackage.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+(\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*)?$") && !ManagedFileAccess.file((String)srcPackage).exists() ? this.getPackageCacheManager().loadPackage(srcPackage, null) : null;
        if (npm == null && ManagedFileAccess.file((String)srcPackage).exists()) {
            try {
                npm = NpmPackage.fromPackage((InputStream)ManagedFileAccess.inStream((String)srcPackage));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (npm != null) {
            for (String s : npm.dependencies()) {
                if (this.getContext().getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
                this.loadIg(igs, binaries, s, false);
            }
            StringBuilder packageLoadLine = new StringBuilder();
            packageLoadLine.append("  Load " + srcPackage);
            if (!srcPackage.contains("#")) {
                packageLoadLine.append("#" + npm.version());
            }
            BaseLoaderR5 loader = ValidatorUtils.loaderForVersion(npm.fhirVersion());
            loader.setPatchUrls(VersionUtilities.isCorePackage((String)npm.id()));
            int count = this.getContext().loadFromPackage(npm, (IContextResourceLoader)loader);
            log.info(String.valueOf(packageLoadLine) + " - " + count + " resources (" + this.getContext().clock().milestone() + ")");
        } else {
            StringBuilder packageLoadLine = new StringBuilder();
            packageLoadLine.append("  Load " + srcPackage);
            String canonical = null;
            int count = 0;
            Map<String, ByteProvider> source = this.loadIgSource(srcPackage, recursive, true);
            String version = "5.0.0";
            if (this.getVersion() != null) {
                version = this.getVersion();
            }
            if (source.containsKey("version.info")) {
                version = this.readInfoVersion(source.get("version.info"));
            }
            if (explicitFhirVersion != null) {
                version = explicitFhirVersion;
            }
            for (Map.Entry<String, ByteProvider> t : source.entrySet()) {
                Resource r;
                String fn = t.getKey();
                if (this.exemptFile(fn) || (r = this.loadFileWithErrorChecking(version, t, fn)) == null) continue;
                ++count;
                this.getContext().cacheResource(r);
                if (!(r instanceof ImplementationGuide)) continue;
                canonical = ((ImplementationGuide)r).getUrl();
                igs.add((ImplementationGuide)r);
                if (!canonical.contains("/ImplementationGuide/")) continue;
                Resource r2 = r.copy();
                ((ImplementationGuide)r2).setUrl(canonical.substring(0, canonical.indexOf("/ImplementationGuide/")));
                this.getContext().cacheResource(r2);
            }
            if (canonical != null) {
                ValidatorUtils.grabNatives(binaries, source, canonical);
            }
            log.info(String.valueOf(packageLoadLine) + " - " + count + " resources (" + this.getContext().clock().milestone() + ")");
        }
    }

    public Content loadContent(String source, String opName, boolean asIg, boolean mustLoad) throws FHIRException, IOException {
        Map<String, ByteProvider> s = this.loadIgSource(source, false, asIg);
        Content res = new Content();
        if (!mustLoad && s.size() == 0) {
            return null;
        }
        if (s.size() != 1) {
            throw new FHIRException("Unable to find resource " + source + " to " + opName);
        }
        for (Map.Entry<String, ByteProvider> t : s.entrySet()) {
            res.setFocus(t.getValue());
            if (t.getKey().endsWith(".json")) {
                res.setCntType(Manager.FhirFormat.JSON);
                continue;
            }
            if (t.getKey().endsWith(".ndjson")) {
                res.setCntType(Manager.FhirFormat.NDJSON);
                continue;
            }
            if (t.getKey().endsWith(".xml")) {
                res.setCntType(Manager.FhirFormat.XML);
                continue;
            }
            if (t.getKey().endsWith(".ttl")) {
                res.setCntType(Manager.FhirFormat.TURTLE);
                continue;
            }
            if (t.getKey().endsWith(".shc")) {
                res.setCntType(Manager.FhirFormat.SHC);
                continue;
            }
            if (t.getKey().endsWith(".txt")) {
                res.setCntType(Manager.FhirFormat.TEXT);
                continue;
            }
            if (t.getKey().endsWith(".fml") || t.getKey().endsWith(".map")) {
                res.setCntType(Manager.FhirFormat.FML);
                continue;
            }
            throw new FHIRException("Todo: Determining resource type is not yet done");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteProvider> loadIgSource(String src, boolean recursive, boolean explore) throws FHIRException, IOException {
        if (Common.isNetworkPath(src)) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            String string = pid = explore ? this.getPackageCacheManager().getPackageId(src) : null;
            if (!Utilities.noString((String)pid)) {
                return this.fetchByPackage(pid + (String)(v == null ? "" : "#" + v), false);
            }
            return this.fetchFromUrl(src + (String)(v == null ? "" : "|" + v), explore);
        }
        File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                try (FileInputStream stream = ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "package.tgz"}));){
                    Map<String, ByteProvider> map = this.loadPackage(stream, Utilities.path((String[])new String[]{src, "package.tgz"}), false);
                    return map;
                }
            }
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                try (FileInputStream stream = ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "igpack.zip"}));){
                    Map<String, ByteProvider> map = this.readZip(stream);
                    return map;
                }
            }
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                try (FileInputStream stream = ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "validator.pack"}));){
                    Map<String, ByteProvider> map = this.readZip(stream);
                    return map;
                }
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            try (FileInputStream stream = ManagedFileAccess.inStream((String)src);){
                if (src.endsWith(".tgz")) {
                    Map<String, ByteProvider> res;
                    Map<String, ByteProvider> map = res = this.loadPackage(stream, src, false);
                    return map;
                }
                if (src.endsWith(".pack")) {
                    Map<String, ByteProvider> res = this.readZip(stream);
                    return res;
                }
                if (src.endsWith("igpack.zip")) {
                    Map<String, ByteProvider> res = this.readZip(stream);
                    return res;
                }
            }
            Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), FileUtilities.fileToBytes((File)f), src, true);
            if (fmt != null) {
                HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
                res.put(FileUtilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), ByteProvider.forFile((String)src));
                return res;
            }
        } else if ((src.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$") || src.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            return this.fetchByPackage(src, false);
        }
        throw new FHIRException("Unable to find/resolve/read " + (explore ? "-ig " : "") + src);
    }

    public void scanForIgVersion(String src, boolean recursive, VersionSourceInformation versions) throws IOException {
        Map<String, ByteProvider> source = this.loadIgSourceForVersion(src, recursive, true, versions);
        if (source != null) {
            if (source.containsKey("version.info")) {
                versions.see(this.readInfoVersion(source.get("version.info")), "version.info in " + src);
            } else if (source.size() == 1) {
                for (ByteProvider v : source.values()) {
                    this.scanForFhirVersion(versions, src, v);
                }
            }
        }
    }

    public void scanForVersions(List<String> sources, VersionSourceInformation versions) throws FHIRException, IOException {
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        ValidatorUtils.parseSources(sources, refs, this.context);
        for (ValidatorUtils.SourceFile ref : refs) {
            Content cnt = this.loadContent(ref.getRef(), "validate", false, true);
            this.scanForFhirVersion(versions, ref.getRef(), cnt.getFocus());
        }
    }

    private void scanForFhirVersion(VersionSourceInformation versions, String ref, ByteProvider bp) throws IOException {
        byte[] cnt = bp.getBytes();
        String s = FileUtilities.bytesToString((byte[])(cnt.length > 2048 ? Arrays.copyOfRange(cnt, 0, 2048) : cnt)).trim();
        try {
            int i = s.indexOf("fhirVersion");
            if (i > 1) {
                String v;
                int j;
                boolean xml = s.charAt(i) == '<';
                i = this.find(s, i, '\"');
                if (!xml) {
                    i = this.find(s, i + 1, '\"');
                }
                if (i > 0 && (j = this.find(s, i + 1, '\"')) > 0 && VersionUtilities.isSemVer((String)(v = s.substring(i + 1, j)))) {
                    versions.see(VersionUtilities.getMajMin((String)v), "fhirVersion in " + ref);
                    return;
                }
                i = this.find(s, i, '\'');
                if (!xml) {
                    i = this.find(s, i + 1, '\'');
                }
                if (i > 0 && (j = this.find(s, i + 1, '\'')) > 0 && VersionUtilities.isSemVer((String)(v = s.substring(i, j)))) {
                    versions.see(VersionUtilities.getMajMin((String)v), "fhirVersion in " + ref);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s.contains("http://hl7.org/fhir/3.0")) {
            versions.see("3.0", "Profile in " + ref);
            return;
        }
        if (s.contains("http://hl7.org/fhir/1.0")) {
            versions.see("1.0", "Profile in " + ref);
            return;
        }
        if (s.contains("http://hl7.org/fhir/4.0")) {
            versions.see("4.0", "Profile in " + ref);
            return;
        }
        if (s.contains("http://hl7.org/fhir/1.4")) {
            versions.see("1.4", "Profile in " + ref);
            return;
        }
    }

    private int find(String s, int i, char c) {
        while (i < s.length() && s.charAt(i) != c) {
            ++i;
        }
        return i == s.length() ? -1 : i;
    }

    protected Map<String, ByteProvider> readZip(InputStream stream) throws IOException {
        ZipEntry zipEntry;
        HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
        ZipInputStream zip = new ZipInputStream(stream);
        while ((zipEntry = zip.getNextEntry()) != null) {
            int n;
            String entryName = zipEntry.getName();
            if (entryName.contains("..") || Path.of(entryName, new String[0]).isAbsolute()) {
                throw new RuntimeException("Entry with an illegal path: " + entryName);
            }
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((n = ((InputStream)zip).read(buf, 0, 1024)) > -1) {
                b.write(buf, 0, n);
            }
            res.put(entryName, ByteProvider.forBytes((byte[])b.toByteArray()));
            zip.closeEntry();
        }
        zip.close();
        return res;
    }

    private String loadPackageForVersion(InputStream stream) throws FHIRException, IOException {
        return NpmPackage.fromPackage((InputStream)stream).fhirVersion();
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException, IOException {
        try {
            HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), (String)(source + "?nocache=" + System.currentTimeMillis()));
            res.checkThrowException();
            return new ByteArrayInputStream(res.getContent());
        }
        catch (IOException e) {
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, ByteProvider> loadIgSourceForVersion(String src, boolean recursive, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        if (Common.isNetworkPath(src)) {
            String pid;
            String v = null;
            if (src.contains("|")) {
                v = src.substring(src.indexOf("|") + 1);
                src = src.substring(0, src.indexOf("|"));
            }
            if (!Utilities.noString((String)(pid = this.getPackageCacheManager().getPackageId(src)))) {
                versions.see(this.fetchVersionByPackage(pid + (String)(v == null ? "" : "#" + v)), "Package " + src);
                return null;
            }
            return this.fetchVersionFromUrl(src + (String)(v == null ? "" : "|" + v), explore, versions);
        }
        File f = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src}));
        if (f.exists()) {
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "package.tgz"})).exists()) {
                versions.see(this.loadPackageForVersion(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "package.tgz"}))), "Package " + src);
                return null;
            }
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "igpack.zip"})).exists()) {
                return this.readZip(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "igpack.zip"})));
            }
            if (f.isDirectory() && ManagedFileAccess.file((String)Utilities.path((String[])new String[]{src, "validator.pack"})).exists()) {
                return this.readZip(ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{src, "validator.pack"})));
            }
            if (f.isDirectory()) {
                return this.scanDirectory(f, recursive);
            }
            if (src.endsWith(".tgz")) {
                versions.see(this.loadPackageForVersion(ManagedFileAccess.inStream((String)src)), "Package " + src);
                return null;
            }
            if (src.endsWith(".pack")) {
                return this.readZip(ManagedFileAccess.inStream((String)src));
            }
            if (src.endsWith("igpack.zip")) {
                return this.readZip(ManagedFileAccess.inStream((String)src));
            }
            Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), FileUtilities.fileToBytes((File)f), src, true);
            if (fmt != null) {
                HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
                res.put(FileUtilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), ByteProvider.forFile((String)src));
                return res;
            }
        } else if ((src.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$") || src.matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$")) && !src.endsWith(".zip") && !src.endsWith(".tgz")) {
            versions.see(this.fetchVersionByPackage(src), "Package " + src);
            return null;
        }
        throw new FHIRException("Unable to find/resolve/read -ig " + src);
    }

    private Map<String, ByteProvider> fetchByPackage(String src, boolean loadInContext) throws FHIRException, IOException {
        NpmPackage pi;
        InputStream stream;
        if (this.directProvider != null && (stream = this.directProvider.fetchByPackage(src)) != null) {
            NpmPackage pi2 = NpmPackage.fromPackage((InputStream)stream);
            return this.loadPackage(pi2, loadInContext);
        }
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (version == null) {
            version = this.getPackageCacheManager().getLatestVersion(id, false);
        }
        if (version == null) {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id);
            if (pi != null) {
                log.info("   ... Using version " + pi.version());
            }
        } else {
            pi = this.getPackageCacheManager().loadPackage(id, version);
        }
        if (pi == null) {
            throw new FHIRException("Unable to find package " + src);
        }
        return this.loadPackage(pi, loadInContext);
    }

    private Map<String, ByteProvider> loadPackage(InputStream stream, String name, boolean loadInContext) throws FHIRException, IOException {
        return this.loadPackage(NpmPackage.fromPackage((InputStream)stream), loadInContext);
    }

    public Map<String, ByteProvider> loadPackage(NpmPackage pi, boolean loadInContext) throws FHIRException, IOException {
        HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
        for (String s : pi.dependencies()) {
            if (s.endsWith(".x") && s.length() > 2) {
                String packageMajorMinor = s.substring(0, s.length() - 2);
                boolean found = false;
                for (int i = 0; i < this.getContext().getLoadedPackages().size() && !found; ++i) {
                    String loadedPackage = (String)this.getContext().getLoadedPackages().get(i);
                    if (!loadedPackage.startsWith(packageMajorMinor)) continue;
                    found = true;
                }
                if (found) continue;
            }
            if (this.getContext().getLoadedPackages().contains(s) || VersionUtilities.isCorePackage((String)s)) continue;
            log.info("+  .. load IG from " + s);
            res.putAll(this.fetchByPackage(s, loadInContext));
        }
        if (!pi.isCoreExamples()) {
            if (loadInContext) {
                this.getContext().loadFromPackage(pi, (IContextResourceLoader)ValidatorUtils.loaderForVersion(pi.fhirVersion()));
            }
            for (String s : pi.listResources(new String[]{"CodeSystem", "ConceptMap", "ImplementationGuide", "CapabilityStatement", "SearchParameter", "Conformance", "StructureMap", "ValueSet", "StructureDefinition"})) {
                res.put(s, pi.getProvider("package", s));
            }
        }
        String ini = "[FHIR]\r\nversion=" + pi.fhirVersion() + "\r\n";
        res.put("version.info", ByteProvider.forBytes((byte[])ini.getBytes()));
        return res;
    }

    private Map<String, ByteProvider> resolvePackage(String id, String v, boolean loadInContext) throws FHIRException, IOException {
        NpmPackage pi = this.getPackageCacheManager().loadPackage(id, v);
        if (pi != null && v == null) {
            log.info("   ... Using version " + pi.version());
        }
        return this.loadPackage(pi, loadInContext);
    }

    private String readInfoVersion(ByteProvider bs) throws IOException {
        String is = FileUtilities.bytesToString((byte[])bs.getBytes());
        is = is.trim();
        IniFile ini = new IniFile((InputStream)new ByteArrayInputStream(FileUtilities.stringToBytes((String)is)));
        return ini.getStringProperty("FHIR", "version");
    }

    private byte[] fetchFromUrlSpecific(String source, String contentType, boolean optional, List<String> errors) throws FHIRException, IOException {
        try {
            try {
                HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), (String)(source + "?nocache=" + System.currentTimeMillis()), (String)contentType);
                res.checkThrowException();
                return res.getContent();
            }
            catch (Exception e) {
                HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), (String)source, (String)contentType);
                res.checkThrowException();
                return res.getContent();
            }
        }
        catch (IOException e) {
            if (errors != null) {
                errors.add("Error accessing " + source + ": " + e.getMessage());
            }
            if (optional) {
                return null;
            }
            throw e;
        }
    }

    private Map<String, ByteProvider> fetchVersionFromUrl(String src, boolean explore, VersionSourceInformation versions) throws FHIRException, IOException {
        if (src.endsWith(".tgz")) {
            versions.see(this.loadPackageForVersion(this.fetchFromUrlSpecific(src, false)), "From Package " + src);
            return null;
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore) {
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true);
            if (stream != null) {
                versions.see(this.loadPackageForVersion(stream), "From Package at " + src);
                return null;
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "igpack.zip"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
            if (stream != null) {
                return this.readZip(stream);
            }
            stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "validator.pack"}), true);
        }
        byte[] cnt = stream == null ? this.fetchFromUrlSpecific(src, "application/json", true, null) : FileUtilities.streamToBytes(stream);
        Manager.FhirFormat fmt = ResourceChecker.checkIsResource(this.getContext(), cnt, src, true);
        if (fmt != null) {
            HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
            res.put(FileUtilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), ByteProvider.forBytes((byte[])cnt));
            return res;
        }
        String fn = Utilities.path((String[])new String[]{"[tmp]", "fetch-resource-error-content.bin"});
        FileUtilities.bytesToFile((byte[])cnt, (String)fn);
        log.error("Error Fetching " + src);
        log.error("Some content was found, saved to " + fn);
        log.error("1st 100 bytes = " + this.presentForDebugging(cnt));
        throw new FHIRException("Unable to find/resolve/read " + (explore ? "-ig " : "") + src);
    }

    private String fetchVersionByPackage(String src) throws FHIRException, IOException {
        String id = src;
        String version = null;
        if (src.contains("#")) {
            id = src.substring(0, src.indexOf("#"));
            version = src.substring(src.indexOf("#") + 1);
        }
        if (version == null) {
            version = this.getPackageCacheManager().getLatestVersion(id, false);
        }
        NpmPackage pi = null;
        if (version == null) {
            pi = this.getPackageCacheManager().loadPackageFromCacheOnly(id);
            if (pi != null) {
                log.info("   ... Using version " + pi.version());
            }
        } else {
            pi = this.getPackageCacheManager().loadPackage(id, version);
        }
        if (pi == null) {
            throw new FHIRException("Unable to resolve package " + src);
        }
        return pi.fhirVersion();
    }

    private Map<String, ByteProvider> fetchFromUrl(String src, boolean explore) throws FHIRException, IOException {
        ArrayList<String> errors;
        byte[] cnt;
        if (src.endsWith(".tgz")) {
            return this.loadPackage(this.fetchFromUrlSpecific(src, false), src, false);
        }
        if (src.endsWith(".pack")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        if (src.endsWith("igpack.zip")) {
            return this.readZip(this.fetchFromUrlSpecific(src, false));
        }
        InputStream stream = null;
        if (explore && (stream = this.fetchFromUrlSpecific(Utilities.pathURL((String[])new String[]{src, "package.tgz"}), true)) != null) {
            try {
                return this.loadPackage(stream, Utilities.pathURL((String[])new String[]{src, "package.tgz"}), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((cnt = this.fetchFromUrlSpecific(src, "application/json", true, errors = new ArrayList<String>())) == null) {
            cnt = this.fetchFromUrlSpecific(src, "application/xml", true, errors);
        }
        if (cnt == null) {
            throw new FHIRException("Unable to fetch content from " + src + " (" + ((Object)errors).toString() + ")");
        }
        Manager.FhirFormat fmt = this.checkFormat(cnt, src);
        if (fmt != null) {
            HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
            res.put(FileUtilities.changeFileExt((String)src, (String)("." + fmt.getExtension())), ByteProvider.forBytes((byte[])cnt));
            return res;
        }
        throw new FHIRException("Unable to read content from " + src + ": cannot determine format");
    }

    private boolean isIgnoreFile(File ff) {
        if (ff.getName().startsWith(".") || ff.getAbsolutePath().contains(".git")) {
            return true;
        }
        return Utilities.existsInList((String)Utilities.getFileExtension((String)ff.getName()).toLowerCase(), (String[])IGNORED_EXTENSIONS);
    }

    private Map<String, ByteProvider> scanDirectory(File f, boolean recursive) throws IOException {
        HashMap<String, ByteProvider> res = new HashMap<String, ByteProvider>();
        for (File ff : f.listFiles()) {
            Manager.FhirFormat fmt;
            if (ff.isDirectory() && recursive) {
                res.putAll(this.scanDirectory(ff, true));
                continue;
            }
            if (ff.isDirectory() || this.isIgnoreFile(ff) || (fmt = ResourceChecker.checkIsResource(this.getContext(), FileUtilities.fileToBytes((File)ff), ff.getAbsolutePath(), true)) == null) continue;
            res.put(FileUtilities.changeFileExt((String)ff.getName(), (String)("." + fmt.getExtension())), ByteProvider.forFile((File)ff));
        }
        return res;
    }

    private String resolvePackageForVersion(String id, String v) throws FHIRException, IOException {
        NpmPackage pi = this.getPackageCacheManager().loadPackage(id, v);
        return pi.fhirVersion();
    }

    private String presentForDebugging(byte[] cnt) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < Integer.min(cnt.length, 50); ++i) {
            b.append(Integer.toHexString(cnt[i]));
        }
        return b.toString();
    }

    private Manager.FhirFormat checkFormat(byte[] cnt, String filename) throws IOException {
        String text = FileUtilities.bytesToString((byte[])cnt);
        log.info("   ..Detect format for " + filename);
        try {
            org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((byte[])cnt);
            return Manager.FhirFormat.JSON;
        }
        catch (Exception e) {
            log.debug("Not JSON: " + e.getMessage());
            try {
                ValidatorUtils.parseXml(cnt);
                return Manager.FhirFormat.XML;
            }
            catch (Exception e2) {
                log.debug("Not XML: " + e2.getMessage());
                try {
                    new Turtle().parse(FileUtilities.bytesToString((byte[])cnt));
                    return Manager.FhirFormat.TURTLE;
                }
                catch (Exception e3) {
                    log.debug("Not Turtle: " + e3.getMessage());
                    try {
                        new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((org.hl7.fhir.r5.context.IWorkerContext)this.getContext(), null, null).parse(FileUtilities.bytesToString((byte[])cnt), null);
                        return Manager.FhirFormat.TEXT;
                    }
                    catch (Exception e4) {
                        log.debug("Not Text: " + e4.getMessage());
                        log.debug("     .. not a resource: " + filename);
                        return null;
                    }
                }
            }
        }
    }

    private boolean exemptFile(String fn) {
        return Utilities.existsInList((String)fn, (String[])EXEMPT_FILES);
    }

    protected Resource loadFileWithErrorChecking(String version, Map.Entry<String, ByteProvider> t, String fn) {
        Resource r;
        block2: {
            log.debug("* load file: " + fn);
            r = null;
            try {
                r = this.loadResourceByVersion(version, t.getValue().getBytes(), fn);
                log.debug(" .. success");
            }
            catch (Exception e) {
                log.error("* load file: " + fn + " - ignored due to error: " + (e.getMessage() == null ? " (null - NPE)" : e.getMessage()));
                if (!this.isDebug() && (e.getMessage() == null || !e.getMessage().contains("cannot be cast"))) break block2;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource loadResourceByVersion(String fhirVersion, byte[] content, String fn) throws IOException, FHIRException {
        if (fhirVersion.startsWith("3.0")) {
            org.hl7.fhir.dstu3.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu3.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res);
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu3.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)res);
        }
        if (fhirVersion.startsWith("4.0")) {
            org.hl7.fhir.r4.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.r4.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map")) {
                    if (!fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new org.hl7.fhir.r4.utils.StructureMapUtilities((IWorkerContext)org.hl7.fhir.r4.context.SimpleWorkerContext.fromNothing()).parse(new String(content), fn);
            }
            return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)res);
        }
        if (fhirVersion.startsWith("4.3")) {
            org.hl7.fhir.r4b.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.r4b.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                res = new org.hl7.fhir.r4b.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map")) {
                    if (!fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                }
                res = new StructureMapUtilities((org.hl7.fhir.r4b.context.IWorkerContext)SimpleWorkerContext.fromNothing()).parse(new String(content), fn);
            }
            return VersionConvertorFactory_43_50.convertResource((org.hl7.fhir.r4b.model.Resource)res);
        }
        if (fhirVersion.startsWith("1.4")) {
            org.hl7.fhir.dstu2016may.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2016may.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)res);
        }
        if (fhirVersion.startsWith("1.0")) {
            org.hl7.fhir.dstu2.model.Resource res;
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
                return VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)res, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
            } else {
                if (!fn.endsWith(".json")) throw new FHIRException("Unsupported format for " + fn);
                if (fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                res = new org.hl7.fhir.dstu2.formats.JsonParser().parse((InputStream)new ByteArrayInputStream(content));
            }
            return VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)res, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
        }
        if (!fhirVersion.startsWith("5.0")) throw new FHIRException("Unsupported version " + fhirVersion);
        if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
            return new org.hl7.fhir.r5.formats.XmlParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
            return new JsonParser().parse((InputStream)new ByteArrayInputStream(content));
        }
        if (fn.endsWith(".txt")) {
            return new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((org.hl7.fhir.r5.context.IWorkerContext)this.getContext(), null, null).parse(FileUtilities.bytesToString((byte[])content), fn);
        }
        if (fn.endsWith(".map")) return new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((org.hl7.fhir.r5.context.IWorkerContext)this.context).parse(new String(content), fn);
        if (!fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
        return new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((org.hl7.fhir.r5.context.IWorkerContext)this.context).parse(new String(content), fn);
    }

    @Override
    public void load(Content cnt) throws FHIRException, IOException {
        Resource res = this.loadResourceByVersion(this.version, cnt.getFocus().getBytes(), cnt.getExampleFileName());
        this.context.cacheResource(res);
    }

    @Generated
    public FilesystemPackageCacheManager getPackageCacheManager() {
        return this.packageCacheManager;
    }

    @Generated
    public org.hl7.fhir.r5.context.SimpleWorkerContext getContext() {
        return this.context;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isDebug() {
        return this.isDebug;
    }

    @Generated
    public IDirectPackageProvider getDirectProvider() {
        return this.directProvider;
    }

    @Generated
    public void setDirectProvider(IDirectPackageProvider directProvider) {
        this.directProvider = directProvider;
    }

    public static interface IDirectPackageProvider {
        public InputStream fetchByPackage(String var1) throws IOException;
    }
}

