/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.NPMPackageGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.ZipGenerator;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.IgLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageReGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PackageReGenerator.class);
    private List<String> packages = new ArrayList<String>();
    private Parameters expansionParameters = new Parameters();
    private ExpansionPackageGeneratorScope scope = ExpansionPackageGeneratorScope.EVERYTHING;
    private String output;
    private ExpansionPackageGeneratorOutputType outputType;
    private boolean hierarchical;
    private boolean json;
    private IWorkerContext context;
    private String npmId;
    private ContextUtilities cu;
    private Set<String> sourcePackages = new HashSet<String>();
    private Map<String, TerminologyResourceEntry> entries = new HashMap<String, TerminologyResourceEntry>();
    private Set<String> modeParams;
    private List<CanonicalResource> resources = new ArrayList<CanonicalResource>();
    private Set<String> set = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        new PackageReGenerator().addPackage("hl7.fhir.us.davinci-alerts").setJson(true).setOutputType(ExpansionPackageGeneratorOutputType.TGZ).setOutput("/Users/grahamegrieve/temp/vs-output.tgz").generateExpansionPackage();
    }

    public PackageReGenerator addPackage(String packageId) {
        this.packages.add(packageId);
        return this;
    }

    public Parameters getExpansionParameters() {
        return this.expansionParameters;
    }

    public PackageReGenerator setExpansionParameters(Parameters expansionParameters) {
        this.expansionParameters = expansionParameters;
        return this;
    }

    public ExpansionPackageGeneratorScope getScope() {
        return this.scope;
    }

    public PackageReGenerator setScope(ExpansionPackageGeneratorScope scope) {
        this.scope = scope;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public PackageReGenerator setOutput(String output) {
        this.output = output;
        return this;
    }

    public ExpansionPackageGeneratorOutputType getOutputType() {
        return this.outputType;
    }

    public PackageReGenerator setOutputType(ExpansionPackageGeneratorOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public PackageReGenerator setHierarchical(boolean hierarchical) {
        this.hierarchical = hierarchical;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public PackageReGenerator setJson(boolean json) {
        this.json = json;
        return this;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public PackageReGenerator setContext(IWorkerContext context) {
        this.context = context;
        return this;
    }

    public String getNpmId() {
        return this.npmId;
    }

    public void setNpmId(String npmId) {
        this.npmId = npmId;
    }

    public void generateExpansionPackage() throws IOException {
        if (this.output == null) {
            throw new Error("No output");
        }
        List<NpmPackage> list = this.load();
        for (NpmPackage npm : list) {
            StructureDefinition sd;
            CapabilityStatement cs;
            if (this.modeParams.contains("api")) {
                log.info("Processing CapabilityStatements");
                for (String res : npm.listResources(new String[]{"CapabilityStatement"})) {
                    cs = (CapabilityStatement)new JsonParser().parse(npm.loadResource(res));
                    cs.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)cs);
                }
                log.info("Processing OperationDefinitions");
                for (String res : npm.listResources(new String[]{"OperationDefinition"})) {
                    OperationDefinition op = (OperationDefinition)new JsonParser().parse(npm.loadResource(res));
                    op.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)op);
                }
                log.info("Processing SearchParameters");
                for (String res : npm.listResources(new String[]{"SearchParameter"})) {
                    SearchParameter sp = (SearchParameter)new JsonParser().parse(npm.loadResource(res));
                    sp.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)sp);
                }
            }
            if (this.modeParams.contains("tx")) {
                log.info("Processing CodeSystems");
                for (String res : npm.listResources(new String[]{"CodeSystem"})) {
                    cs = (CodeSystem)new JsonParser().parse(npm.loadResource(res));
                    cs.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)cs);
                }
                log.info("Processing ValueSets");
                for (String res : npm.listResources(new String[]{"ValueSet"})) {
                    ValueSet vs = (ValueSet)new JsonParser().parse(npm.loadResource(res));
                    vs.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)vs);
                }
                log.info("Processing NamingSystems");
                for (String res : npm.listResources(new String[]{"NamingSystem"})) {
                    NamingSystem ns = (NamingSystem)new JsonParser().parse(npm.loadResource(res));
                    ns.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)ns);
                }
            }
            if (this.modeParams.contains("cnt")) {
                log.info("Processing StructureDefinitions");
                for (String res : npm.listResources(new String[]{"StructureDefinition"})) {
                    sd = (StructureDefinition)new JsonParser().parse(npm.loadResource(res));
                    sd.setSourcePackage(new PackageInformation(npm));
                    this.processResource((CanonicalResource)sd);
                }
            }
            log.info("Processing Bindings");
            for (String res : npm.listResources(new String[]{"StructureDefinition"})) {
                sd = (StructureDefinition)new JsonParser().parse(npm.loadResource(res));
                this.processSD(sd, npm.id());
            }
            if (!this.modeParams.contains("expansions")) continue;
            log.info("Generating Expansions");
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                try {
                    log.info("Generating Expansion for " + n + " ... ");
                    ValueSetExpansionOutcome exp = this.context.expandVS(e.valueSet, true, this.hierarchical);
                    if (exp.isOk()) {
                        e.valueSet.setExpansion(exp.getValueset().getExpansion());
                        log.info("Generated Expansion for " + n);
                        continue;
                    }
                    e.valueSet.setExpansion(null);
                    e.error = exp.getError();
                    log.warn(exp.getError());
                }
                catch (Exception ex) {
                    log.warn("Error= " + ex.getMessage());
                    e.error = ex.getMessage();
                }
            }
        }
        switch (this.outputType) {
            case FOLDER: {
                this.produceFolder();
                break;
            }
            case TGZ: {
                this.producePackage();
                break;
            }
            case ZIP: {
                this.produceZip();
                break;
            }
        }
        log.info("Done");
    }

    private void processResource(CanonicalResource res) {
        if (res == null) {
            return;
        }
        if (this.set.contains(res.getVersionedUrl())) {
            return;
        }
        this.set.add(res.getVersionedUrl());
        if (this.scope == ExpansionPackageGeneratorScope.EVERYTHING || !this.isCore(res.getSourcePackage())) {
            this.resources.add(res);
            if (res.hasSourcePackage()) {
                this.sourcePackages.add(res.getSourcePackage().getVID());
            }
            if (this.modeParams.contains("pin")) {
                this.processBase(res, (Base)res, res.fhirType());
            }
            if (this.scope != ExpansionPackageGeneratorScope.IG_ONLY) {
                this.chaseDependencies(res);
            }
        }
    }

    private boolean isCore(PackageInformation spi) {
        if (spi == null) {
            return true;
        }
        String pi = spi.getId();
        if (VersionUtilities.isCorePackage((String)pi)) {
            return true;
        }
        return Utilities.existsInList((String)pi, (String[])new String[]{"hl7.terminology"});
    }

    private void chaseDependencies(CanonicalResource res) {
        if (res instanceof CodeSystem) {
            this.chaseDependenciesCS((CodeSystem)res);
        }
        if (res instanceof ValueSet) {
            this.chaseDependenciesVS((ValueSet)res);
        }
        if (res instanceof StructureDefinition) {
            this.chaseDependenciesSD((StructureDefinition)res);
        }
        if (res instanceof CapabilityStatement) {
            this.chaseDependenciesCS((CapabilityStatement)res);
        }
        if (res instanceof OperationDefinition) {
            this.chaseDependenciesOD((OperationDefinition)res);
        }
        if (res instanceof SearchParameter) {
            this.chaseDependenciesSP((SearchParameter)res);
        }
    }

    private void chaseDependenciesCS(CodeSystem cs) {
        if (cs.hasSupplements()) {
            this.processResource((CanonicalResource)this.context.fetchResource(CodeSystem.class, cs.getSupplements()));
        }
        for (CodeSystem css : this.context.fetchResourcesByType(CodeSystem.class)) {
            if (!css.supplements(cs)) continue;
            this.processResource((CanonicalResource)css);
        }
    }

    private void chaseDependenciesVS(ValueSet vs) {
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.chaseDependenciesVS(inc);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.chaseDependenciesVS(inc);
        }
    }

    private void chaseDependenciesVS(ValueSet.ConceptSetComponent inc) {
        for (CanonicalType c : inc.getValueSet()) {
            this.processResource((CanonicalResource)this.context.fetchResource(ValueSet.class, c.primitiveValue()));
        }
        this.processResource((CanonicalResource)this.context.fetchResource(CodeSystem.class, inc.getSystem(), inc.getVersion()));
    }

    private void chaseDependenciesSD(StructureDefinition sd) {
        if (sd.hasBaseDefinition()) {
            this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition()));
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (ed.getBinding().hasValueSet()) {
                this.processResource((CanonicalResource)this.context.fetchResource(ValueSet.class, ed.getBinding().getValueSet()));
                for (ElementDefinition.ElementDefinitionBindingAdditionalComponent adb : ed.getBinding().getAdditional()) {
                    this.processResource((CanonicalResource)this.context.fetchResource(ValueSet.class, adb.getValueSet()));
                }
            }
            for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                if (Utilities.isAbsoluteUrl((String)tr.getCode())) {
                    this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, tr.getCode()));
                }
                for (CanonicalType c : tr.getProfile()) {
                    this.processResource((CanonicalResource)this.context.fetchResource(Resource.class, c.primitiveValue()));
                }
                for (CanonicalType c : tr.getTargetProfile()) {
                    this.processResource((CanonicalResource)this.context.fetchResource(Resource.class, c.primitiveValue()));
                }
            }
        }
    }

    private void chaseDependenciesCS(CapabilityStatement cs) {
        for (CanonicalType c : cs.getInstantiates()) {
            this.processResource((CanonicalResource)this.context.fetchResource(CapabilityStatement.class, c.primitiveValue()));
        }
        for (CanonicalType c : cs.getImports()) {
            this.processResource((CanonicalResource)this.context.fetchResource(CapabilityStatement.class, c.primitiveValue()));
        }
        for (CanonicalType c : cs.getImplementationGuide()) {
            this.processResource((CanonicalResource)this.context.fetchResource(CapabilityStatement.class, c.primitiveValue()));
        }
        for (CapabilityStatement.CapabilityStatementRestComponent r : cs.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : r.getResource()) {
                if (rr.hasProfile()) {
                    this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, rr.getProfile()));
                }
                for (CanonicalType c : rr.getSupportedProfile()) {
                    this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, c.primitiveValue()));
                }
                for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent sp : rr.getSearchParam()) {
                    if (!sp.hasDefinition()) continue;
                    this.processResource((CanonicalResource)this.context.fetchResource(SearchParameter.class, sp.getDefinition()));
                }
                for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent od : rr.getOperation()) {
                    if (!od.hasDefinition()) continue;
                    this.processResource((CanonicalResource)this.context.fetchResource(OperationDefinition.class, od.getDefinition()));
                }
            }
            for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent sp : r.getSearchParam()) {
                if (!sp.hasDefinition()) continue;
                this.processResource((CanonicalResource)this.context.fetchResource(SearchParameter.class, sp.getDefinition()));
            }
            for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent od : r.getOperation()) {
                if (!od.hasDefinition()) continue;
                this.processResource((CanonicalResource)this.context.fetchResource(OperationDefinition.class, od.getDefinition()));
            }
        }
        for (CapabilityStatement.CapabilityStatementDocumentComponent doc : cs.getDocument()) {
            if (!doc.hasProfile()) continue;
            this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, doc.getProfile()));
        }
    }

    private void chaseDependenciesOD(OperationDefinition od) {
        if (od.hasBase()) {
            this.processResource((CanonicalResource)this.context.fetchResource(SearchParameter.class, od.getBase()));
        }
        if (od.hasInputProfile()) {
            this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, od.getInputProfile()));
        }
        if (od.hasOutputProfile()) {
            this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, od.getOutputProfile()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent p : od.getParameter()) {
            for (CanonicalType c : p.getTargetProfile()) {
                this.processResource((CanonicalResource)this.context.fetchResource(StructureDefinition.class, c.primitiveValue()));
            }
            if (!p.getBinding().hasValueSet()) continue;
            this.processResource((CanonicalResource)this.context.fetchResource(ValueSet.class, p.getBinding().getValueSet()));
        }
    }

    private void chaseDependenciesSP(SearchParameter sp) {
        if (sp.hasDerivedFrom()) {
            this.processResource((CanonicalResource)this.context.fetchResource(SearchParameter.class, sp.getDerivedFrom()));
        }
        for (SearchParameter.SearchParameterComponentComponent c : sp.getComponent()) {
            if (!c.hasDefinition()) continue;
            this.processResource((CanonicalResource)this.context.fetchResource(SearchParameter.class, c.getDefinition()));
        }
    }

    private void processBase(CanonicalResource src, Base b, String path) {
        ValueSet.ConceptSetComponent cs;
        CanonicalResource cr;
        Resource res;
        CanonicalType ct;
        for (Property p : b.children()) {
            for (Base v : p.getValues()) {
                this.processBase(src, v, path + "." + p.getName());
            }
        }
        if (b instanceof CanonicalType && !(ct = (CanonicalType)b).hasVersion() && (res = this.context.fetchResource(Resource.class, (String)ct.getValue(), (Resource)src)) != null && res instanceof CanonicalResource) {
            cr = (CanonicalResource)res;
            ct.addVersion(cr.getVersion());
        }
        if (b instanceof ValueSet.ConceptSetComponent && !(cs = (ValueSet.ConceptSetComponent)b).hasVersion() && (res = this.context.fetchResource(Resource.class, cs.getSystem(), (Resource)src)) != null && res instanceof CanonicalResource) {
            cr = (CanonicalResource)res;
            cs.setVersion(cr.getVersion());
        }
    }

    private void produceZip() throws IOException {
        log.info("Producing Output in Zip " + this.output);
        ZipGenerator zip = new ZipGenerator(this.output);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            zip.addBytes("manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        } else {
            zip.addBytes("manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        }
        for (CanonicalResource cr : this.resources) {
            zip.addBytes(cr.fhirType() + "-" + cr.getIdBase() + (String)(cr.hasVersion() ? "-" + this.tokenise(cr.getVersion()) : "") + (this.json ? ".json" : ".xml"), this.composeResource(cr), false);
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                Object name = e.valueSet.getIdBase();
                int i = 0;
                while (names.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                names.add((String)name);
                if (e.error == null) {
                    b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                zip.addBytes((String)name + ".json", this.composeResource((CanonicalResource)e.valueSet), false);
            }
            zip.addBytes("valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8), false);
        }
        zip.close();
    }

    private void producePackage() throws FHIRException, IOException {
        log.info("Producing Output Package in " + this.output);
        JsonObject j = new JsonObject();
        String id = this.npmId == null ? "custom.generated" : (this.npmId.contains("#") ? this.npmId.substring(0, this.npmId.indexOf("#")) : this.npmId);
        String ver = this.npmId != null && this.npmId.contains("#") ? this.npmId.substring(this.npmId.indexOf("#") + 1) : "0.1.0";
        j.add("name", id);
        j.add("version", ver);
        j.add("tools-version", 3);
        j.add("type", "Conformance");
        j.forceArray("fhirVersions").add(this.context.getVersion());
        for (String string : this.sourcePackages) {
            j.forceArray("sourcePackages").add(string);
        }
        j.forceObject("dependencies").add(VersionUtilities.packageForVersion((String)this.context.getVersion()), this.context.getVersion());
        NPMPackageGenerator gen = new NPMPackageGenerator(this.output, j, new Date(), true);
        for (CanonicalResource cr : this.resources) {
            gen.addFile("package", cr.fhirType() + "-" + cr.getIdBase() + (String)(cr.hasVersion() ? "-" + this.tokenise(cr.getVersion()) : "") + ".json", this.composeResource(cr));
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("manifest");
        if (this.json) {
            gen.addFile("package", "manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        } else {
            gen.addFile("package", "manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                Object name = e.valueSet.getIdBase();
                int i = 0;
                while (hashSet.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                hashSet.add((String)name);
                if (e.error == null) {
                    b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                gen.addFile("package", (String)name + ".json", this.composeResource((CanonicalResource)e.valueSet));
            }
            gen.addFile("other", "valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8));
        }
        gen.finish();
    }

    private String tokenise(String version) {
        if (version == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.') && c != '-') continue;
            b.append(c);
        }
        return b.toString();
    }

    private void produceFolder() throws IOException {
        log.info("Producing Output in folder " + this.output);
        FileUtilities.createDirectory((String)this.output);
        FileUtilities.clearDirectory((String)this.output, (String[])new String[0]);
        HashSet<Object> names = new HashSet<Object>();
        names.add("manifest");
        if (this.json) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.json"})), (Resource)this.expansionParameters);
        } else {
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.xml"})), (Resource)this.expansionParameters);
        }
        for (CanonicalResource cr : this.resources) {
            FileUtilities.bytesToFile((byte[])this.composeResource(cr), (String)Utilities.path((String[])new String[]{this.output, cr.fhirType() + "-" + cr.getIdBase() + (String)(cr.hasVersion() ? "-" + this.tokenise(cr.getVersion()) : "") + (this.json ? ".json" : ".xml")}));
        }
        if (this.modeParams.contains("expansions")) {
            StringBuilder b = new StringBuilder();
            for (String n : Utilities.sorted(this.entries.keySet())) {
                TerminologyResourceEntry e = this.entries.get(n);
                String name = "ValueSet-" + e.valueSet.getIdBase() + "-expansion";
                int i = 0;
                while (names.contains(name)) {
                    name = e.valueSet.getIdBase() + ++i;
                }
                names.add(name);
                if (e.error == null) {
                    b.append(name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                } else {
                    b.append(name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
                }
                FileUtilities.bytesToFile((byte[])this.composeResource((CanonicalResource)e.valueSet), (String)Utilities.path((String[])new String[]{this.output, name + (this.json ? ".json" : ".xml")}));
            }
            FileUtilities.stringToFile((String)b.toString(), (String)Utilities.path((String[])new String[]{this.output, "expansions.csv"}));
        }
    }

    private byte[] composeResource(CanonicalResource cr) throws IOException {
        if (this.json) {
            return new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)cr);
        }
        return new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)cr);
    }

    private void processSD(StructureDefinition sd, String packageId) {
        StructureDefinition bsd;
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet()) continue;
            this.processValueSet(ed.getBinding().getValueSet(), packageId + ":" + sd.getVersionedUrl() + "#" + ed.getId());
        }
        if (!(this.scope == ExpansionPackageGeneratorScope.IG_ONLY || sd.getBaseDefinition() == null || (bsd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), (Resource)sd)) == null || bsd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition") && this.scope != ExpansionPackageGeneratorScope.EVERYTHING)) {
            this.processSD(bsd, bsd.getSourcePackage().getVID());
        }
    }

    private void processValueSet(String valueSet, String source) {
        String url = this.cu.pinValueSet(valueSet);
        ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, url);
        if (vs != null) {
            TerminologyResourceEntry e = this.entries.get(vs.getVersionedUrl());
            if (e == null) {
                e = new TerminologyResourceEntry();
                e.sources.add((String)source);
                e.valueSet = vs;
                this.entries.put(vs.getVersionedUrl(), e);
                source = vs.getSourcePackage().getVID() + ":" + vs.getVersionedUrl();
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
            } else {
                e.sources.add((String)source);
            }
        } else {
            log.info("Unable to resolve value set " + valueSet);
        }
    }

    private List<NpmPackage> load() throws IOException {
        ArrayList<NpmPackage> list = new ArrayList<NpmPackage>();
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        for (String packageId : this.packages) {
            NpmPackage npm = pcm.loadPackage(packageId);
            if (this.context == null) {
                String v = npm.fhirVersion();
                NpmPackage core = pcm.loadPackage(VersionUtilities.packageForVersion((String)v));
                NpmPackage tho = pcm.loadPackage("hl7.terminology");
                log.info("Load FHIR from " + core.name() + "#" + core.version());
                SimpleWorkerContext ctxt = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(core);
                TerminologyClientFactory factory = new TerminologyClientFactory(ctxt.getVersion());
                ctxt.connectToTSServer((TerminologyClientManager.ITerminologyClientFactory)factory, "http://tx.fhir.org", ctxt.getUserAgent(), null, true);
                IgLoader loader = new IgLoader(pcm, ctxt, ctxt.getVersion());
                loader.loadPackage(tho, true);
                loader.loadPackage(npm, true);
                this.context = ctxt;
                this.context.setExpansionParameters(this.expansionParameters);
                loader.loadPackage(npm, true);
            } else {
                IgLoader loader = new IgLoader(pcm, (SimpleWorkerContext)this.context, this.context.getVersion());
                loader.loadPackage(npm, true);
            }
            list.add(npm);
        }
        if (this.cu == null) {
            this.cu = new ContextUtilities(this.context);
        }
        return list;
    }

    public void setModes(Set<String> modeParams) {
        this.modeParams = modeParams;
    }

    public static enum ExpansionPackageGeneratorScope {
        IG_ONLY,
        ALL_IGS,
        EVERYTHING;

    }

    public static enum ExpansionPackageGeneratorOutputType {
        FOLDER,
        ZIP,
        TGZ;

    }

    public static class TerminologyResourceEntry {
        public ValueSet valueSet;
        public Set<String> sources = new HashSet<String>();
        public String error;
    }
}

