/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodingsObserver
extends BaseValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodingsObserver.class);
    private IWorkerContext context;
    private List<CodingUsage> list = new ArrayList<CodingUsage>();
    private boolean checkIPSCodes;

    public CodingsObserver(@Nonnull IWorkerContext context, @Nonnull ValidatorSettings settings, @Nonnull XVerExtensionManager xverManager, ValidatorSession session) {
        super(context, settings, xverManager, session);
        this.context = context;
    }

    public void seeCode(NodeStack stack, String system, String version, String code, String display) {
        this.seeCode(stack, new Coding().setSystem(system).setCode(code).setVersion(version).setDisplay(display));
    }

    public boolean isCheckIPSCodes() {
        return this.checkIPSCodes;
    }

    public void setCheckIPSCodes(boolean checkIPSCodes) {
        this.checkIPSCodes = checkIPSCodes;
    }

    public void seeCode(NodeStack stack, CodeableConcept cc) {
        for (Coding c : cc.getCoding()) {
            this.seeCode(stack, c);
        }
    }

    public void seeCode(NodeStack stack, Coding c) {
        this.list.add(new CodingUsage(stack, c));
    }

    public void finish(List<ValidationMessage> errors, NodeStack rootStack) {
        if (this.checkIPSCodes) {
            Map<String, String> nonIPSCodes;
            log.info("");
            log.info("Checking SCT codes for IPS");
            HashSet<String> snomedCTCodes = new HashSet<String>();
            for (CodingUsage c : this.list) {
                if (!"http://snomed.info/sct".equals(c.c.getSystem()) || c.c.getCode() == null) continue;
                snomedCTCodes.add(c.c.getCode());
            }
            if (!snomedCTCodes.isEmpty() && !(nonIPSCodes = this.checkSCTCodes(snomedCTCodes)).isEmpty()) {
                for (String s : nonIPSCodes.keySet()) {
                    this.hint(errors, "2023-07-25", ValidationMessage.IssueType.BUSINESSRULE, rootStack, false, "CS_SCT_IPS_NOT_IPS", s, nonIPSCodes.get(s));
                }
            }
            log.info("Done Checking SCT codes for IPS");
        }
    }

    private Map<String, String> checkSCTCodes(Set<String> codes) {
        ArrayList<CodingValidationRequest> serverList = new ArrayList<CodingValidationRequest>();
        for (String s : codes) {
            serverList.add(new CodingValidationRequest(new Coding("http://snomed.info/sct", s, null)));
        }
        ValueSet vsTemp = new ValueSet();
        vsTemp.setUrl("http://terminology.hl7.org/ValueSet/snomed-intl-ips");
        this.context.validateCodeBatch(null, serverList, vsTemp, false);
        HashMap<String, String> results = new HashMap<String, String>();
        for (CodingValidationRequest vr : serverList) {
            if (vr.getResult().isOk()) continue;
            results.put(vr.getCoding().getCode(), vr.getResult().getDisplay() != null ? vr.getResult().getDisplay() : vr.getCoding().getDisplay());
        }
        return results;
    }

    private class CodingUsage {
        private NodeStack stack;
        private Coding c;

        public CodingUsage(NodeStack stack, Coding c) {
            this.stack = stack;
            this.c = c;
        }
    }
}

