/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public class Scanner {
    private Set<String> combos = new HashSet<String>();
    private Map<String, CodeSystem> codesystems = new HashMap<String, CodeSystem>();
    private SimpleWorkerContext ctxt;

    public static void main(String[] args) throws IOException {
        new Scanner().execute("/Users/grahamegrieve/web/www.hl7.org.fhir/us", "/Users/grahamegrieve/web/www.hl7.org.fhir/uv", "/Users/grahamegrieve/web/www.hl7.org.fhir/R4");
    }

    private void execute(String ... paths) throws IOException {
        System.out.println("loading");
        NpmPackage npm = new FilesystemPackageCacheManager.Builder().build().loadPackage("hl7.fhir.r5.core");
        this.ctxt = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(npm);
        for (String p : paths) {
            this.execute(new File(p));
        }
        System.out.println("saving");
        JsonObject j = new JsonObject();
        for (String s : Utilities.sorted(this.combos)) {
            JsonObject o = this.processCombo(s);
            if (o == null) continue;
            j.forceArray("cases").add((JsonElement)o);
        }
        org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)j, (File)new File("/Users/grahamegrieve/temp/code-text-cases.json"), (boolean)true);
        System.out.println("done. see [tmp]/code-text-cases.json");
    }

    private JsonObject processCombo(String s) {
        String code;
        String path = s.substring(0, s.indexOf("`") + 2).trim();
        s = s.substring(s.indexOf("`") + 1).trim();
        String text = s.substring(s.indexOf("::") + 2).trim();
        String uri = s.substring(0, s.indexOf("::")).trim();
        String system = uri.substring(0, uri.indexOf("#")).trim();
        String display = this.getFromCodeSystem(system, code = uri.substring(uri.indexOf("#") + 1).trim());
        if (display != null && !display.toLowerCase().equals(text.toLowerCase())) {
            JsonObject object = new JsonObject();
            object.add("path", path);
            object.add("system", system);
            object.add("code", code);
            object.add("display", display);
            object.add("lang", "en");
            object.add("text", text);
            object.add("goal", "valid");
            return object;
        }
        return null;
    }

    private String getFromCodeSystem(String system, String code) {
        CodeSystem.ConceptDefinitionComponent cd;
        CodeSystem cs = this.codesystems.get(system);
        if (cs != null && (cd = CodeSystemUtilities.findCode((List)cs.getConcept(), (String)code)) != null) {
            return cd.getDisplay();
        }
        ValidationResult vr = this.ctxt.validateCode(ValidationOptions.defaults(), system, null, code, null);
        if (vr.isOk()) {
            return vr.getDisplay();
        }
        return null;
    }

    private void execute(File folder) {
        System.out.println(folder.getAbsolutePath());
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.execute(f);
                continue;
            }
            if (!f.getName().endsWith(".json")) continue;
            try {
                Resource r = new JsonParser().parse((InputStream)new FileInputStream(f));
                if (r == null) continue;
                if (r instanceof CodeSystem) {
                    CodeSystem cs = (CodeSystem)r;
                    this.codesystems.put(cs.getUrl(), cs);
                }
                this.scan(r.fhirType(), (Base)r);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private void scan(String path, Base b) {
        for (Property p : b.children()) {
            for (Base v : p.getValues()) {
                if (v.isResource() || Utilities.existsInList((String)v.fhirType(), (String[])new String[]{"Element", "BackboneElement"})) {
                    this.scan(path + "." + p.getName(), v);
                    continue;
                }
                if (!(v instanceof CodeableConcept)) continue;
                this.see(path + "." + p.getName(), (CodeableConcept)v);
            }
        }
    }

    private void see(String path, CodeableConcept cc) {
        if (cc.hasText()) {
            for (Coding c : cc.getCoding()) {
                if (c.hasDisplay() && c.getDisplay().toLowerCase().equals(cc.getText().toLowerCase())) continue;
                this.see(path, c.getSystem(), c.getCode(), cc.getText());
            }
        }
    }

    private void see(String path, String system, String code, String text) {
        if (!system.contains("acme") && !system.contains("example")) {
            this.combos.add(path + "`" + system + "#" + code + " :: " + text);
        }
    }
}

