/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.IHostApplicationServices;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.utils.sql.Column;
import org.hl7.fhir.r5.utils.sql.ColumnKind;
import org.hl7.fhir.r5.utils.sql.Runner;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ViewDefinitionValidator
extends BaseValidator {
    public ViewDefinitionValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateViewDefinition(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, NodeStack stack) throws FHIRException {
        boolean ok = true;
        if (this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, vd.hasChild("name"), "VIEWDEFINITION_SHOULD_HAVE_NAME", new Object[0])) {
            this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, this.isValidName(vd.getNamedChildValue("name")), "VIEWDEFINITION_NAME_INVALID", "view", vd.getNamedChildValue("name"));
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        vd.setUserData("columns", columns);
        ArrayList<VersionEvaluationContext> versions = new ArrayList<VersionEvaluationContext>();
        if (vd.hasChildren("fhirVersion")) {
            for (Element v : vd.getChildren("fhirVersion")) {
                String ver = v.primitiveValue();
                if (ver.equals(this.context.getVersion())) {
                    this.makeDefaultContext(versions);
                    continue;
                }
                try {
                    this.makeVersionSpecificContext(versions, ver);
                }
                catch (IOException e) {
                    throw new FHIRException((Throwable)e);
                }
            }
        } else {
            this.makeDefaultContext(versions);
        }
        boolean first = true;
        for (VersionEvaluationContext vec : versions) {
            String vdesc = versions.size() == 1 ? "" : " for version " + VersionUtilities.getNameForVersion((String)vec.context.getVersion());
            String resourceName = vd.getNamedChildValue("resource");
            if (resourceName != null) {
                if (this.rule(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, this.context.getResourceNamesAsSet().contains(resourceName), "VIEWDEFINITION_UNKNOWN_RESOURCE", resourceName)) {
                    int i = 0;
                    if (first) {
                        for (Element constant : vd.getChildren("constant")) {
                            ok = this.checkConstant(hostContext, errors, stack.push(constant, i, null, null), constant) && ok;
                            ++i;
                        }
                    }
                    i = 0;
                    for (Element where : vd.getChildren("where")) {
                        ok = this.checkWhere(hostContext, errors, vd, stack.push(where, i, null, null), where, resourceName, vec, vdesc, first) && ok;
                        ++i;
                    }
                    TypeDetails t = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{resourceName});
                    i = 0;
                    for (Element select : vd.getChildren("select")) {
                        ok = this.checkSelect(hostContext, errors, vd, vd, stack.push(select, i, null, null), select, resourceName, t, columns, vec, vdesc, first) && ok;
                        ++i;
                    }
                }
            } else {
                ok = false;
            }
            first = false;
        }
        return ok;
    }

    private void makeVersionSpecificContext(List<VersionEvaluationContext> versions, String ver) throws FHIRException, IOException {
        if (this.session.getObjects().containsKey("VIEW_DEFINITION_CONTEXT." + ver)) {
            versions.add((VersionEvaluationContext)this.session.getObjects().get("VIEW_DEFINITION_CONTEXT." + ver));
        } else {
            FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
            NpmPackage npm = pcm.loadPackage(VersionUtilities.packageForVersion((String)ver));
            SimpleWorkerContext context = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(npm);
            VersionEvaluationContext vec = new VersionEvaluationContext((IWorkerContext)context);
            this.session.getObjects().put("VIEW_DEFINITION_CONTEXT." + context.getVersion(), vec);
            versions.add(vec);
        }
    }

    private void makeDefaultContext(List<VersionEvaluationContext> versions) {
        if (this.session.getObjects().containsKey("VIEW_DEFINITION_CONTEXT." + this.context.getVersion())) {
            versions.add((VersionEvaluationContext)this.session.getObjects().get("VIEW_DEFINITION_CONTEXT." + this.context.getVersion()));
        } else {
            VersionEvaluationContext vec = new VersionEvaluationContext(this.context);
            this.session.getObjects().put("VIEW_DEFINITION_CONTEXT." + this.context.getVersion(), vec);
            versions.add(vec);
        }
    }

    private boolean checkSelect(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, Element parent, NodeStack stack, Element select, String resourceName, TypeDetails t, List<Column> columns, VersionEvaluationContext vec, String vdesc, boolean first) {
        Element e;
        select.setUserData("columns", columns);
        boolean ok = true;
        if (select.hasChild("forEach")) {
            e = select.getNamedChild("forEach");
            t = this.checkForEach(hostContext, errors, vd, select, stack.push(e, -1, null, null), e, resourceName, t, vec, vdesc, first);
        } else if (select.hasChild("forEachOrNull")) {
            e = select.getNamedChild("forEachOrNull");
            t = this.checkForEachOrNull(hostContext, errors, vd, select, stack.push(e, -1, null, null), e, resourceName, t, vec, vdesc, first);
        }
        if (t == null) {
            ok = false;
        } else {
            if (select.hasChildren("column")) {
                int i = 0;
                for (Element e2 : select.getChildren("column")) {
                    ok = this.checkColumn(hostContext, errors, vd, select, stack.push(e2, i, null, null), e2, resourceName, t, columns, vec, vdesc, first) && ok;
                    ++i;
                }
            }
            if (select.hasChildren("select")) {
                int i = 0;
                for (Element e2 : select.getChildren("select")) {
                    ok = this.checkSelect(hostContext, errors, vd, select, stack.push(e2, i, null, null), e2, resourceName, t, columns, vec, vdesc, first) && ok;
                    ++i;
                }
            }
            if (select.hasChildren("unionAll")) {
                int i = 0;
                for (Element e2 : select.getChildren("unionAll")) {
                    ok = this.checkUnion(hostContext, errors, vd, parent, stack.push(e2, i, null, null), e2, resourceName, t, columns, vec, vdesc, first) && ok;
                    ++i;
                }
            }
            this.checkColumnNamesUnique(errors, stack, columns);
        }
        return ok;
    }

    private void checkColumnNamesUnique(List<ValidationMessage> errors, NodeStack stack, List<Column> columns) {
        HashSet<String> names = new HashSet<String>();
        for (Column col : columns) {
            if (col == null) continue;
            String name = col.getName();
            if (!names.contains(name)) {
                names.add(name);
                continue;
            }
            if (col.isDuplicateReported()) continue;
            col.setDuplicateReported(true);
            this.rule(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_DUPL_COL_NAME", name);
        }
    }

    private boolean checkUnion(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, Element parent, NodeStack stack, Element unionAll, String resourceName, TypeDetails t, List<Column> columns, VersionEvaluationContext vec, String vdesc, boolean first) {
        return false;
    }

    private String columnDiffs(List<Column> list1, List<Column> list2) {
        if (list1.size() == list2.size()) {
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i) == null || list2.get(i) == null) {
                    return null;
                }
                String diff = list1.get(i).diff(list2.get(i));
                if (diff == null) continue;
                return diff + " at #" + i;
            }
            return null;
        }
        return "Column counts differ: " + list1.size() + " vs " + list2.size();
    }

    private boolean checkColumn(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, Element parent, NodeStack stack, Element column, String resourceName, TypeDetails t, List<Column> columns, VersionEvaluationContext vec, String vdesc, boolean first) {
        ExpressionNode n;
        boolean ok = false;
        String expr = column.getNamedChildValue("path");
        if (expr != null && (n = this.getParsedExpression(column, vec.fpe, expr, errors, stack, "path")) != null) {
            ok = true;
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("; ");
            ArrayList warnings = new ArrayList();
            TypeDetails td = null;
            try {
                td = vec.fpe.checkOnTypes((Object)vd, "Resource", resourceName, t, n, warnings);
            }
            catch (Exception e) {
                this.rule(errors, "2024-11-14", ValidationMessage.IssueType.EXCEPTION, stack, false, "VIEWDEFINITION_PATH_ERROR", e.getMessage(), vdesc);
                ok = false;
            }
            if (td != null) {
                for (FHIRPathEngine.IssueMessage s : warnings) {
                    this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_PATH_WARNING", s.getMessage(), vdesc);
                }
                String columnName = column.getNamedChildValue("name");
                if (columnName == null) {
                    List names = n.getDistalNames();
                    if (names.size() == 1 && names.get(0) != null) {
                        columnName = (String)names.get(0);
                        ok = this.rule(errors, "2024-11-14", ValidationMessage.IssueType.INVALID, stack, this.isValidName(columnName), "VIEWDEFINITION_NAME_REQUIRED_HINT", columnName) && ok;
                    } else {
                        ok = false;
                        this.rule(errors, "2024-11-14", ValidationMessage.IssueType.INVALID, stack, false, "VIEWDEFINITION_NAME_REQUIRED", new Object[0]);
                    }
                }
                if (columnName != null) {
                    String type;
                    column.setUserData("name", (Object)columnName);
                    Boolean isColl = null;
                    if (column.hasChild("collection")) {
                        isColl = "true".equals(column.getNamedChildValue("collection"));
                    }
                    if (isColl != null && isColl.booleanValue()) {
                        if (td.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON && !this.hint(errors, "2024-11-14", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "VIEWDEFINITION_COLLECTION_NOT_NEEDED", expr, columnName)) {
                            b.append(this.context.formatMessage("VIEWDEFINITION_COLLECTION_NOT_NEEDED", new Object[]{expr, columnName}));
                        }
                        if (!this.hint(errors, "2024-11-14", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "VIEWDEFINITION_COLLECTION_NOT_ALWAYS", new Object[0])) {
                            b.append(this.context.formatMessage("VIEWDEFINITION_COLLECTION_NOT_ALWAYS", new Object[0]));
                        }
                    } else if (isColl == null) {
                        if (!this.hint(errors, "2024-11-14", ValidationMessage.IssueType.INFORMATIONAL, stack, td.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON, "VIEWDEFINITION_COLLECTION_NEEDED1", expr, columnName, vdesc)) {
                            b.append(this.context.formatMessage("VIEWDEFINITION_COLLECTION_NEEDED1", new Object[]{expr, columnName, vdesc}));
                        }
                    } else if (!this.hint(errors, "2024-11-14", ValidationMessage.IssueType.INFORMATIONAL, stack, td.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON, "VIEWDEFINITION_COLLECTION_NEEDED1", expr, columnName, vdesc)) {
                        b.append(this.context.formatMessage("VIEWDEFINITION_COLLECTION_NEEDED2", new Object[]{expr, columnName, vdesc}));
                    }
                    HashSet<String> types = new HashSet<String>();
                    if (n.isNullSet()) {
                        types.add("null");
                    } else {
                        for (String type2 : td.getTypes()) {
                            types.add(this.simpleType(type2));
                        }
                        type = column.getNamedChildValue("type");
                        if (type != null) {
                            if (td.hasType(type)) {
                                types.clear();
                                types.add(this.simpleType(type));
                            } else {
                                boolean bl = ok = this.rule(errors, "2024-11-14", ValidationMessage.IssueType.INVALID, stack, false, "VIEWDEFINITION_TYPE_MISMATCH", expr, type, td.describe(), vdesc) && ok;
                            }
                        }
                    }
                    if (types.size() != 1) {
                        ok = this.rule(errors, "2024-11-14", ValidationMessage.IssueType.INVALID, stack, false, "VIEWDEFINITION_UNABLE_TO_TYPE", td.describe(), vdesc) && ok;
                    } else {
                        type = (String)types.iterator().next();
                        boolean tok = false;
                        if (!this.isSimpleType(type) && !"null".equals(type)) {
                            this.hint(errors, "2024-11-14", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "VIEWDEFINITION_COMPLEX_TYPE", expr, type, vdesc);
                        } else {
                            tok = true;
                        }
                        if (tok) {
                            if (first) {
                                Column col = new Column(columnName, isColl, type, this.kindForType(type));
                                column.setUserData("column", (Object)col);
                                col.setNotes(b.toString());
                                columns.add(col);
                            } else if (b.count() > 0) {
                                Column col = null;
                                for (Column c : columns) {
                                    if (!c.getName().equals(columnName)) continue;
                                    col = c;
                                }
                                if (col != null) {
                                    col.addNote(b.toString());
                                }
                            }
                        } else {
                            ok = false;
                        }
                    }
                }
            }
        }
        return ok;
    }

    private ColumnKind kindForType(String type) {
        switch (type) {
            case "null": {
                return ColumnKind.Null;
            }
            case "dateTime": {
                return ColumnKind.DateTime;
            }
            case "boolean": {
                return ColumnKind.Boolean;
            }
            case "integer": {
                return ColumnKind.Integer;
            }
            case "decimal": {
                return ColumnKind.Decimal;
            }
            case "string": {
                return ColumnKind.String;
            }
            case "canonical": {
                return ColumnKind.String;
            }
            case "url": {
                return ColumnKind.String;
            }
            case "uri": {
                return ColumnKind.String;
            }
            case "oid": {
                return ColumnKind.String;
            }
            case "uuid": {
                return ColumnKind.String;
            }
            case "id": {
                return ColumnKind.String;
            }
            case "code": {
                return ColumnKind.String;
            }
            case "base64Binary": {
                return ColumnKind.Binary;
            }
            case "time": {
                return ColumnKind.Time;
            }
        }
        return ColumnKind.Complex;
    }

    private boolean isSimpleType(String type) {
        return Utilities.existsInList((String)type, (String[])new String[]{"dateTime", "boolean", "integer", "decimal", "string", "base64Binary", "id", "code", "date", "time", "canonical", "uri", "url"});
    }

    private String simpleType(String type) {
        type = type.replace("http://hl7.org/fhirpath/System.", "").replace("http://hl7.org/fhir/StructureDefinition/", "");
        if (Utilities.existsInList((String)type, (String[])new String[]{"date", "dateTime", "instant"})) {
            return "dateTime";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Boolean", "boolean"})) {
            return "boolean";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Integer", "integer", "integer64"})) {
            return "integer";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Decimal", "decimal"})) {
            return "decimal";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"String", "string", "code"})) {
            return "string";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"Time", "time"})) {
            return "time";
        }
        if (Utilities.existsInList((String)type, (String[])new String[]{"base64Binary"})) {
            return "base64Binary";
        }
        return type;
    }

    private TypeDetails checkForEach(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, Element parent, NodeStack stack, Element expression, String resourceName, TypeDetails t, VersionEvaluationContext vec, String vdesc, boolean first) {
        ExpressionNode n;
        String expr = expression.primitiveValue();
        if (expr != null && (n = this.getParsedExpression(parent, vec.fpe, expr, errors, stack, "forEach")) != null) {
            ArrayList warnings = new ArrayList();
            TypeDetails td = null;
            try {
                td = vec.fpe.checkOnTypes((Object)vd, "Resource", resourceName, t, n, warnings);
            }
            catch (Exception e) {
                this.rule(errors, "2024-11-14", ValidationMessage.IssueType.EXCEPTION, stack, false, "VIEWDEFINITION_PATH_ERROR", e.getMessage(), vdesc);
                return null;
            }
            if (td != null) {
                for (FHIRPathEngine.IssueMessage s : warnings) {
                    this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_PATH_WARNING", s.getMessage(), vdesc);
                }
            }
            return td;
        }
        return null;
    }

    private TypeDetails checkForEachOrNull(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, Element parent, NodeStack stack, Element expression, String resourceName, TypeDetails t, VersionEvaluationContext vec, String vdesc, boolean first) {
        ExpressionNode n;
        String expr = expression.primitiveValue();
        if (expr != null && (n = this.getParsedExpression(parent, vec.fpe, expr, errors, stack, "forEachOrNull")) != null) {
            ArrayList warnings = new ArrayList();
            TypeDetails td = null;
            try {
                td = vec.fpe.checkOnTypes((Object)vd, "Resource", resourceName, t, n, warnings);
            }
            catch (Exception e) {
                this.rule(errors, "2024-11-14", ValidationMessage.IssueType.EXCEPTION, stack, false, "VIEWDEFINITION_PATH_ERROR", e.getMessage(), vdesc);
                return null;
            }
            if (td != null) {
                for (FHIRPathEngine.IssueMessage s : warnings) {
                    this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_PATH_WARNING", s.getMessage(), vdesc);
                }
            }
            return td;
        }
        return null;
    }

    private boolean checkConstant(ValidationContext hostContext, List<ValidationMessage> errors, NodeStack stack, Element constant) {
        String name = constant.getNamedChildValue("name");
        this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, this.isValidName(name), "VIEWDEFINITION_NAME_INVALID", "constant", name);
        return true;
    }

    private boolean checkWhere(ValidationContext hostContext, List<ValidationMessage> errors, Element vd, NodeStack stack, Element where, String resourceName, VersionEvaluationContext vec, String vdesc, boolean first) {
        ExpressionNode n;
        boolean ok = true;
        String expr = where.getNamedChildValue("path");
        if (expr != null && (n = this.getParsedExpression(where, vec.fpe, expr, errors, stack, "path")) != null) {
            ArrayList<String> types = new ArrayList<String>();
            ArrayList warnings = new ArrayList();
            types.add(resourceName);
            TypeDetails td = null;
            try {
                td = vec.fpe.checkOnTypes((Object)vd, "Resource", resourceName, types, n, warnings);
            }
            catch (Exception e) {
                this.rule(errors, "2024-11-14", ValidationMessage.IssueType.EXCEPTION, stack, false, "VIEWDEFINITION_PATH_ERROR", e.getMessage(), vdesc);
                ok = false;
            }
            if (td != null) {
                if (td.getCollectionStatus() != ExpressionNode.CollectionStatus.SINGLETON || td.getTypes().size() != 1 || !td.hasType("boolean")) {
                    this.rule(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_PATH_WRONG_RETURN", expr, td.describe(), vdesc);
                    ok = false;
                } else {
                    for (FHIRPathEngine.IssueMessage s : warnings) {
                        this.warning(errors, "2024-11-14", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VIEWDEFINITION_PATH_WARNING", s.getMessage(), vdesc);
                    }
                }
            }
        }
        return ok;
    }

    private ExpressionNode getParsedExpression(Element focus, FHIRPathEngine fpe, String expr, List<ValidationMessage> errors, NodeStack stack, String udName) {
        if (focus.hasUserData("path")) {
            return (ExpressionNode)focus.getUserData(udName);
        }
        ExpressionNode n = null;
        try {
            n = fpe.parse(expr);
        }
        catch (Exception e) {
            this.rule(errors, "2024-11-14", ValidationMessage.IssueType.EXCEPTION, stack, false, "VIEWDEFINITION_PATH_ERROR", e.getMessage(), "");
        }
        focus.setUserData(udName, (Object)n);
        return n;
    }

    private boolean isValidName(String name) {
        boolean first = true;
        for (char c : name.toCharArray()) {
            if (!(Character.isAlphabetic(c) || Character.isDigit(c) || !first && c == '_')) {
                return false;
            }
            first = false;
        }
        return true;
    }

    private static class VersionEvaluationContext {
        private IWorkerContext context;
        private Runner runner;
        private FHIRPathEngine fpe;

        public VersionEvaluationContext(IWorkerContext context) {
            this.context = context;
            this.runner = new Runner();
            this.runner.setContext(context);
            this.fpe = new FHIRPathEngine(context);
            this.fpe.setHostServices((IHostApplicationServices)this.runner);
            this.fpe.setEmitSQLonFHIRWarning(true);
        }
    }
}

