/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ImplementationGuideValidator
extends BaseValidator {
    public ImplementationGuideValidator(IWorkerContext context, XVerExtensionManager xverManager, boolean debug, ValidatorSession session) {
        super(context, xverManager, debug, session);
    }

    public boolean validateImplementationGuide(ValidationContext valContext, List<ValidationMessage> errors, Element ig, NodeStack stack) {
        boolean ok = true;
        List el = ig.getChildren("fhirVersion");
        ArrayList<String> fvl = new ArrayList<String>();
        for (Element e : el) {
            String fver = e.primitiveValue();
            fvl.add(fver);
        }
        this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), !fvl.isEmpty(), "IG_NO_VERSION", new Object[0]);
        List dependencies = ig.getChildrenByName("dependsOn");
        int i = 0;
        for (Element dependency : dependencies) {
            ok = this.checkDependency(errors, ig, stack.push(dependency, i, null, null), dependency, fvl) && ok;
            ++i;
        }
        if (this.isHL7(ig)) {
            ok = this.rule(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"}), "IG_HL7_STANDARDS_STATUS_REQUIRED", new Object[0]) && ok;
            ok = this.rule(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"}), "IG_HL7_WG_REQUIRED", new Object[0]) && ok;
            this.warning(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"}), "IG_HL7_FMM_SHOULD", new Object[0]);
        }
        return ok;
    }

    private boolean checkDependency(List<ValidationMessage> errors, Element ig, NodeStack stack, Element dependency, List<String> fvl) {
        boolean ok = true;
        String url = dependency.getNamedChildValue("url");
        String packageId = dependency.getNamedChildValue("packageId");
        String version = dependency.getNamedChildValue("version");
        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), url == null || url.contains("/ImplementationGuide/"), "IG_DEPENDENCY_DIRECT", url) && ok;
        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId == null || packageId.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$"), "IG_DEPENDENCY_INVALID_PACKAGEID", packageId) && ok;
        try {
            FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
            if (url != null && packageId != null) {
                String pid = pcm.getPackageId(url);
                String canonical = pcm.getPackageUrl(packageId);
                ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), pid == null || pid.equals(packageId), "IG_DEPENDENCY_CLASH_PACKAGEID", url, pid, packageId) && ok;
                boolean bl = ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), canonical == null || canonical.equals(url), "IG_DEPENDENCY_CLASH_CANONICAL", packageId, canonical, url) && ok;
            }
            if (packageId == null && ok) {
                packageId = pcm.getPackageId(url);
            }
            if (ok && this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId != null, "IG_DEPENDENCY_NO_PACKAGE", new Object[0]) && this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_NO_VERSION", new Object[0])) {
                String pver;
                ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), (packageId + "#" + version).matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$"), "IG_DEPENDENCY_INVALID_PACKAGE_VERSION", version) && ok;
                NpmPackage npm = pcm.loadPackage(packageId, version);
                if (this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), npm != null, "IG_DEPENDENCY_PACKAGE_UNKNOWN", packageId + "#" + version) && fvl.isEmpty() && !VersionUtilities.versionsMatch((String)(pver = npm.fhirVersion()), fvl)) {
                    if ("hl7.fhir.uv.extensions".equals(packageId)) {
                        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_ERROR", CommaSeparatedStringBuilder.join((String)",", fvl), packageId + "#" + version, pver, "hl7.fhir.uv.extensions." + VersionUtilities.getNameForVersion((String)fvl.get(0)).toLowerCase()) && ok;
                    } else {
                        this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_WARNING", CommaSeparatedStringBuilder.join((String)",", fvl), packageId + "#" + version, pver);
                    }
                }
            }
        }
        catch (Exception e) {
            this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_EXCEPTION", e.getMessage());
        }
        return ok;
    }
}

