/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.PrintStream;
import org.hl7.fhir.utilities.SystemExitManager;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.validation.ai.AITests;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.tasks.StandaloneTask;
import org.hl7.fhir.validation.cli.utils.Params;

public class AiTestsTask
extends StandaloneTask {
    @Override
    public String getName() {
        return "aiTests";
    }

    @Override
    public String getDisplayName() {
        return "AI Tests";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return Params.hasParam(args, "-aiTests");
    }

    @Override
    public void printHelp(PrintStream out) {
    }

    @Override
    public void executeTask(CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        String source = Params.getParam(args, "-source");
        String config = Params.getParam(args, "-config");
        boolean runTests = Params.hasParam(args, "-run-tests");
        AITests ai = new AITests();
        ai.execute(source, config, runTests);
        SystemExitManager.finish();
    }
}

