/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.validation.ai.ChatGPTAPI;
import org.hl7.fhir.validation.ai.ClaudeAPI;
import org.hl7.fhir.validation.ai.CodeAndTextValidationRequest;
import org.hl7.fhir.validation.ai.CodeAndTextValidationResult;
import org.hl7.fhir.validation.ai.Ollama;

public class CodeAndTextValidator {
    private String aiService;
    private Connection db;
    private PreparedStatement select;
    private PreparedStatement insert;

    public CodeAndTextValidator(String cacheFolder, String aiService) throws FHIRException {
        this.aiService = aiService;
        try {
            String filename = Utilities.path((String[])new String[]{cacheFolder, "ai-" + aiService + ".db"});
            this.db = DriverManager.getConnection("jdbc:sqlite:" + filename);
            DatabaseMetaData meta = this.db.getMetaData();
            ResultSet rs = meta.getTables(null, null, "CodeAndText", new String[]{"TABLE"});
            boolean exists = rs.next();
            if (!exists) {
                Statement stmt = this.db.createStatement();
                stmt.execute("CREATE TABLE CodeAndText (\r\nSystem    nvarchar NOT NULL,\r\nCode   nvarchar NOT NULL,\r\nLang   nvarchar NOT NULL,\r\nText  nvarchar NOT NULL,\r\nValid  integer NOT NULL,\r\nExplanation  nvarchar NOT NULL,\r\nConfidence  nvarchar NOT NULL,\r\nPRIMARY KEY (System,Code,Text))\r\n");
            }
            this.select = this.db.prepareStatement("Select Valid, Explanation, Confidence from CodeAndText where System = ? and Code = ? and Lang = ? and Text = ?");
            this.insert = this.db.prepareStatement("Insert into CodeAndText (System, Code, Lang, Text, Valid , Explanation, Confidence) values (?, ?, ?, ?, ?, ?, ?)");
        }
        catch (Exception e) {
            throw new FHIRException("Exception opening AI Cache: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<CodeAndTextValidationResult> validateCodings(List<CodeAndTextValidationRequest> requests) throws IOException {
        try {
            ArrayList<CodeAndTextValidationResult> results = new ArrayList<CodeAndTextValidationResult>();
            ArrayList<CodeAndTextValidationRequest> query = new ArrayList<CodeAndTextValidationRequest>();
            for (CodeAndTextValidationRequest req : requests) {
                CodeAndTextValidationResult cached = this.findExistingResult(req);
                if (cached != null) {
                    results.add(cached);
                    continue;
                }
                query.add(req);
            }
            ClassLoader classLoader = HierarchicalTableGenerator.class.getClassLoader();
            InputStream cfg = classLoader.getResourceAsStream("ai-prompts.json");
            JsonObject jcfg = JsonParser.parseObject((InputStream)cfg);
            List<CodeAndTextValidationResult> outcomes = null;
            if (query.size() > 0) {
                switch (this.aiService.toLowerCase()) {
                    case "claude": {
                        System.out.println("Consulting Claude about " + query.size() + " code/text combinations");
                        outcomes = new ClaudeAPI(jcfg.forceObject("claude")).validateCodings(query);
                        break;
                    }
                    case "chatgpt": {
                        System.out.println("Consulting ChatGPT about " + query.size() + " code/text combinations");
                        outcomes = new ChatGPTAPI(jcfg.forceObject("chatGPT")).validateCodings(query);
                        break;
                    }
                    case "ollama": {
                        System.out.println("Consulting Ollama about " + query.size() + " code/text combinations");
                        outcomes = new Ollama(jcfg.forceObject("ollama"), null).validateCodings(query);
                        break;
                    }
                    default: {
                        if (this.aiService.toLowerCase().startsWith("ollama:")) {
                            Ollama ollama = new Ollama(jcfg.forceObject("ollama"), this.aiService.substring(7));
                            System.out.println("Consulting Ollama at " + ollama.details() + " " + query.size() + " code/text combinations");
                            outcomes = ollama.validateCodings(query);
                            break;
                        }
                        throw new FHIRException("Unknown AI Service " + this.aiService);
                    }
                }
                for (CodeAndTextValidationResult o : outcomes) {
                    results.add(o);
                    this.storeResult(o);
                }
            }
            return results;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private CodeAndTextValidationResult findExistingResult(CodeAndTextValidationRequest req) throws SQLException {
        this.select.setString(1, req.getSystem());
        this.select.setString(2, req.getCode());
        this.select.setString(3, req.getLang());
        this.select.setString(4, req.getText());
        ResultSet rs = this.select.executeQuery();
        if (rs.next()) {
            return new CodeAndTextValidationResult(req, rs.getInt(1) == 1, rs.getString(2), rs.getString(3));
        }
        return null;
    }

    private void storeResult(CodeAndTextValidationResult o) throws SQLException {
        this.insert.setString(1, o.getRequest().getSystem());
        this.insert.setString(2, o.getRequest().getCode());
        this.insert.setString(3, o.getRequest().getLang());
        this.insert.setString(4, o.getRequest().getText());
        this.insert.setInt(5, o.isValid() ? 1 : 0);
        this.insert.setString(6, o.getExplanation());
        this.insert.setString(7, o.getConfidence());
        this.insert.execute();
    }
}

