/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.NPMPackageGenerator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.ZipGenerator;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.IgLoader;

public class ExpansionPackageGenerator {
    private String packageId;
    private Parameters expansionParameters = new Parameters();
    private ExpansionPackageGeneratorScope scope = ExpansionPackageGeneratorScope.EVERYTHING;
    private boolean expansions;
    private String output;
    private ExpansionPackageGeneratorOutputType outputType;
    private boolean hierarchical;
    private boolean json;
    private IWorkerContext context;
    private ContextUtilities cu;
    private Map<String, TerminologyResourceEntry> entries = new HashMap<String, TerminologyResourceEntry>();

    public static void main(String[] args) throws Exception {
        new ExpansionPackageGenerator().setPackageId("hl7.fhir.us.davinci-alerts").setJson(true).setOutputType(ExpansionPackageGeneratorOutputType.TGZ).setOutput("/Users/grahamegrieve/temp/vs-output.tgz").generateExpansionPackage();
    }

    public String getPackageId() {
        return this.packageId;
    }

    public ExpansionPackageGenerator setPackageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    public Parameters getExpansionParameters() {
        return this.expansionParameters;
    }

    public ExpansionPackageGenerator setExpansionParameters(Parameters expansionParameters) {
        this.expansionParameters = expansionParameters;
        return this;
    }

    public ExpansionPackageGeneratorScope getScope() {
        return this.scope;
    }

    public ExpansionPackageGenerator setScope(ExpansionPackageGeneratorScope scope) {
        this.scope = scope;
        return this;
    }

    public boolean isExpansions() {
        return this.expansions;
    }

    public ExpansionPackageGenerator setExpansions(boolean expansions) {
        this.expansions = expansions;
        return this;
    }

    public String getOutput() {
        return this.output;
    }

    public ExpansionPackageGenerator setOutput(String output) {
        this.output = output;
        return this;
    }

    public ExpansionPackageGeneratorOutputType getOutputType() {
        return this.outputType;
    }

    public ExpansionPackageGenerator setOutputType(ExpansionPackageGeneratorOutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    public ExpansionPackageGenerator setHierarchical(boolean hierarchical) {
        this.hierarchical = hierarchical;
        return this;
    }

    public boolean isJson() {
        return this.json;
    }

    public ExpansionPackageGenerator setJson(boolean json) {
        this.json = json;
        return this;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public ExpansionPackageGenerator setContext(IWorkerContext context) {
        this.context = context;
        return this;
    }

    public void generateExpansionPackage() throws IOException {
        if (this.output == null) {
            throw new Error("No output");
        }
        NpmPackage npm = this.load();
        System.out.println("Finding ValueSets");
        for (String res : npm.listResources(new String[]{"StructureDefinition"})) {
            StructureDefinition sd = (StructureDefinition)new JsonParser().parse(npm.loadResource(res));
            this.processSD(sd, npm.id());
        }
        System.out.println("Generating Expansions");
        for (String n : Utilities.sorted(this.entries.keySet())) {
            TerminologyResourceEntry e = this.entries.get(n);
            try {
                System.out.print("Generate Expansion for " + n + " ... ");
                ValueSetExpansionOutcome exp = this.context.expandVS(e.valueSet, true, this.hierarchical);
                if (exp.isOk()) {
                    e.valueSet.setExpansion(exp.getValueset().getExpansion());
                    System.out.println("OK");
                    continue;
                }
                e.valueSet.setExpansion(null);
                e.error = exp.getError();
                System.out.println(exp.getError());
            }
            catch (Exception ex) {
                System.out.println("Error= " + ex.getMessage());
                e.error = ex.getMessage();
            }
        }
        System.out.println("Producing Output");
        switch (this.outputType) {
            case FOLDER: {
                this.produceFolder();
                break;
            }
            case TGZ: {
                this.producePackage(npm);
                break;
            }
            case ZIP: {
                this.produceZip();
                break;
            }
        }
        System.out.println("Done");
    }

    private void produceZip() throws IOException {
        ZipGenerator zip = new ZipGenerator(this.output);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            zip.addBytes("manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        } else {
            zip.addBytes("manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters), false);
        }
        StringBuilder b = new StringBuilder();
        for (String n : Utilities.sorted(this.entries.keySet())) {
            TerminologyResourceEntry e = this.entries.get(n);
            Object name = e.valueSet.getIdBase();
            int i = 0;
            while (names.contains(name)) {
                name = e.valueSet.getIdBase() + ++i;
            }
            names.add((String)name);
            if (e.error == null) {
                b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            } else {
                b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            }
            if (this.json) {
                zip.addBytes((String)name + ".json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)e.valueSet), false);
                continue;
            }
            zip.addBytes((String)name + ".xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)e.valueSet), false);
        }
        zip.addBytes("valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8), false);
        zip.close();
    }

    private void producePackage(NpmPackage npm) throws FHIRException, IOException {
        JsonObject j = new JsonObject();
        j.add("name", npm.id() + ".custom.extensions");
        j.add("version", npm.version());
        j.add("tools-version", 3);
        j.add("type", "Conformance");
        j.forceArray("fhirVersions").add(npm.fhirVersion());
        j.forceObject("dependencies").add(VersionUtilities.packageForVersion((String)npm.fhirVersion()), npm.fhirVersion());
        NPMPackageGenerator gen = new NPMPackageGenerator(this.output, j, new Date(), true);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            gen.addFile("package", "manifest.json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        } else {
            gen.addFile("package", "manifest.xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)this.expansionParameters));
        }
        StringBuilder b = new StringBuilder();
        for (String n : Utilities.sorted(this.entries.keySet())) {
            TerminologyResourceEntry e = this.entries.get(n);
            Object name = e.valueSet.getIdBase();
            int i = 0;
            while (names.contains(name)) {
                name = e.valueSet.getIdBase() + ++i;
            }
            names.add((String)name);
            if (e.error == null) {
                b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            } else {
                b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            }
            if (this.json) {
                gen.addFile("package", (String)name + ".json", new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)e.valueSet));
                continue;
            }
            gen.addFile("package", (String)name + ".xml", new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeBytes((Resource)e.valueSet));
        }
        gen.addFile("other", "valuesets.csv", b.toString().getBytes(StandardCharsets.UTF_8));
        gen.finish();
    }

    private void produceFolder() throws IOException {
        Utilities.createDirectory((String)this.output);
        Utilities.clearDirectory((String)this.output, (String[])new String[0]);
        HashSet<String> names = new HashSet<String>();
        names.add("manifest");
        if (this.json) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.json"})), (Resource)this.expansionParameters);
        } else {
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, "manifest.xml"})), (Resource)this.expansionParameters);
        }
        StringBuilder b = new StringBuilder();
        for (String n : Utilities.sorted(this.entries.keySet())) {
            TerminologyResourceEntry e = this.entries.get(n);
            Object name = e.valueSet.getIdBase();
            int i = 0;
            while (names.contains(name)) {
                name = e.valueSet.getIdBase() + ++i;
            }
            names.add((String)name);
            if (e.error == null) {
                b.append((String)name + "," + n + ", , " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            } else {
                b.append((String)name + "," + n + ", \"" + Utilities.escapeCSV((String)e.error) + "\", " + CommaSeparatedStringBuilder.join((String)";", e.sources) + "\r\n");
            }
            if (this.json) {
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, (String)name + ".json"})), (Resource)e.valueSet);
                continue;
            }
            new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(Utilities.path((String[])new String[]{this.output, (String)name + ".xml"})), (Resource)e.valueSet);
        }
        TextFile.stringToFile((String)b.toString(), (String)Utilities.path((String[])new String[]{this.output, "valuesets.csv"}));
    }

    private void processSD(StructureDefinition sd, String packageId) {
        StructureDefinition bsd;
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (!ed.hasBinding() || !ed.getBinding().hasValueSet()) continue;
            this.processValueSet(ed.getBinding().getValueSet(), packageId + ":" + sd.getVersionedUrl() + "#" + ed.getId());
        }
        if (!(this.scope == ExpansionPackageGeneratorScope.IG_ONLY || sd.getBaseDefinition() == null || (bsd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition())).getUrl().startsWith("http://hl7.org/fhir/StructureDefinition") && this.scope != ExpansionPackageGeneratorScope.EVERYTHING)) {
            this.processSD(bsd, bsd.getSourcePackage().getVID());
        }
    }

    private void processValueSet(String valueSet, String source) {
        String url = this.cu.pinValueSet(valueSet);
        ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, url);
        if (vs != null) {
            TerminologyResourceEntry e = this.entries.get(vs.getVersionedUrl());
            if (e == null) {
                e = new TerminologyResourceEntry();
                e.sources.add((String)source);
                e.valueSet = vs;
                this.entries.put(vs.getVersionedUrl(), e);
                source = vs.getSourcePackage().getVID() + ":" + vs.getVersionedUrl();
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
                for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                    for (CanonicalType v : inc.getValueSet()) {
                        if (!v.hasValue()) continue;
                        this.processValueSet(v.primitiveValue(), (String)source);
                    }
                }
            } else {
                e.sources.add((String)source);
            }
        } else {
            System.out.println("Unable to resolve value set " + valueSet);
        }
    }

    private NpmPackage load() throws IOException {
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        NpmPackage npm = pcm.loadPackage(this.packageId);
        if (this.context == null) {
            String v = npm.fhirVersion();
            NpmPackage core = pcm.loadPackage(VersionUtilities.packageForVersion((String)v));
            NpmPackage tho = pcm.loadPackage("hl7.terminology");
            System.out.println("Load FHIR from " + core.name() + "#" + core.version());
            SimpleWorkerContext ctxt = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(core);
            TerminologyClientFactory factory = new TerminologyClientFactory(ctxt.getVersion());
            ctxt.connectToTSServer((TerminologyClientManager.ITerminologyClientFactory)factory, "http://tx.fhir.org", ctxt.getUserAgent(), null, true);
            IgLoader loader = new IgLoader(pcm, ctxt, ctxt.getVersion());
            loader.loadPackage(tho, true);
            loader.loadPackage(npm, true);
            this.context = ctxt;
        } else {
            IgLoader loader = new IgLoader(pcm, (SimpleWorkerContext)this.context, this.context.getVersion());
            loader.loadPackage(npm, true);
        }
        this.context.setExpansionParameters(this.expansionParameters);
        this.cu = new ContextUtilities(this.context);
        return npm;
    }

    public static enum ExpansionPackageGeneratorScope {
        IG_ONLY,
        ALL_IGS,
        EVERYTHING;

    }

    public static enum ExpansionPackageGeneratorOutputType {
        FOLDER,
        ZIP,
        TGZ;

    }

    public static class TerminologyResourceEntry {
        public ValueSet valueSet;
        public Set<String> sources = new HashSet<String>();
        public String error;
    }
}

