/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;
    private boolean wantCheckSnapshotUnchanged;

    public StructureDefinitionValidator(BaseValidator parent, FHIRPathEngine fpe, boolean wantCheckSnapshotUnchanged) {
        super(parent);
        this.fpe = fpe;
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
    }

    public boolean validateStructureDefinition(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element src, NodeStack stack) {
        boolean ok = true;
        StructureDefinition sd = null;
        String typeName = null;
        try {
            String baseD;
            org.hl7.fhir.r5.elementmodel.Element ext;
            org.hl7.fhir.r5.elementmodel.Element value;
            String burl;
            String abstractV;
            String url = src.getNamedChildValue("url", false);
            sd = this.loadAsSD(src);
            ok = this.checkExtensionContext(errors, src, stack) && ok;
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            typeName = sd.getTypeName();
            boolean experimental = "true".equals(src.getNamedChildValue("experimental", false));
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential")) {
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasDerivation(), "SD_MUST_HAVE_DERIVATION", sd.getUrl())) {
                    this.checkTypeParameters(errors, stack, base, sd);
                    boolean bok = base.getAbstract() || sd.hasKind() && sd.getKind() == base.getKind();
                    boolean bl = ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), bok, "SD_CONSTRAINED_KIND_NO_MATCH", sd.getKind().toCode(), base.getKind().toCode(), base.getType(), base.getUrl()) && ok;
                    if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                        boolean bl2 = ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasType() && sd.getType().equals(base.getType()), "SD_CONSTRAINED_TYPE_NO_MATCH", sd.getType(), base.getType()) && ok;
                        if (!src.hasUserData("profileutils.snapshot.errors")) {
                            ArrayList msgs = new ArrayList();
                            ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                            pu.setForPublication(this.forPublication);
                            pu.setXver(this.xverManager);
                            pu.setNewSlicingProcessing(!sd.hasFhirVersion() || VersionUtilities.isR4Plus((String)sd.getFhirVersion().toCode()));
                            pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir/R4/", sd.getName());
                            if (msgs.size() > 0) {
                                for (ValidationMessage msg : msgs) {
                                    String loc = msg.getLocation();
                                    if (loc.startsWith("StructureDefinition.")) {
                                        msg.setLocation(stack.getLiteralPath() + loc.substring(loc.indexOf(".")));
                                    } else {
                                        msg.setLocation(stack.getLiteralPath());
                                    }
                                    errors.add(msg);
                                    ok = !msg.isError() && ok;
                                }
                            }
                            if (!snapshot.isEmpty() && this.wantCheckSnapshotUnchanged) {
                                int was = snapshot.size();
                                int is = sd.getSnapshot().getElement().size();
                                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), was == is, "SNAPSHOT_EXISTING_PROBLEM", was, is) && ok;
                            }
                        }
                    } else {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasType() && !sd.getType().equals(base.getType()), "SD_SPECIALIZED_TYPE_MATCHES", sd.getType(), base.getType()) && ok;
                    }
                } else {
                    ok = false;
                }
                if ("constraint".equals(src.getChildValue("derivation"))) {
                    ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base.getKindElement().primitiveValue().equals(src.getChildValue("kind")), "SD_DERIVATION_KIND_MISMATCH", base.getKindElement().primitiveValue(), src.getChildValue("kind")) && ok;
                }
                this.warning(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !base.getExperimental() || experimental, "SD_BASE_EXPERIMENTAL", sd.getBaseDefinition());
            }
            if ("true".equals(abstractV = src.getNamedChildValue("abstract")) && (burl = src.getNamedChildValue("url")) != null) {
                boolean bok = false;
                for (StructureDefinition sdb : this.context.fetchResourcesByType(StructureDefinition.class)) {
                    if (!burl.equals(sdb.getBaseDefinition())) continue;
                    bok = true;
                }
                this.warning(errors, "2024-12-31", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), bok, "SD_DERIVATION_NO_CONCRETE", typeName);
            }
            List differentials = src.getChildrenByName("differential");
            List snapshots = src.getChildrenByName("snapshot");
            boolean logical = "logical".equals(src.getNamedChildValue("kind", false));
            boolean constraint = "constraint".equals(src.getNamedChildValue("derivation", false));
            for (org.hl7.fhir.r5.elementmodel.Element differential : differentials) {
                ok = this.validateElementList(errors, differential, stack.push(differential, -1, null, null), false, snapshots.size() > 0, sd, typeName, logical, constraint, src.getNamedChildValue("type", false), src.getNamedChildValue("url", false), src.getNamedChildValue("type", false), base, experimental) && ok;
            }
            for (org.hl7.fhir.r5.elementmodel.Element snapshotE : snapshots) {
                ok = this.validateElementList(errors, snapshotE, stack.push(snapshotE, -1, null, null), true, true, sd, typeName, logical, constraint, src.getNamedChildValue("type", false), src.getNamedChildValue("url", false), src.getNamedChildValue("type", false), base, experimental) && ok;
            }
            if (src.hasExtension(new String[]{"http://hl7.org/fhir/tools/StructureDefinition/obligation-profile"}) && (value = (ext = src.getExtension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile")).getNamedChild("value", false)) != null && "true".equals(value.primitiveValue())) {
                if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), "constraint".equals(src.getNamedChildValue("derivation", false)), "SD_OBGLIGATION_PROFILE_DERIVATION", new Object[0])) {
                    if (this.warning(errors, "2023-05-27", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "SD_OBGLIGATION_PROFILE_UKNOWN", src.getNamedChildValue("baseDefinition", false))) {
                        for (org.hl7.fhir.r5.elementmodel.Element differential : differentials) {
                            ok = this.validateObligationProfile(errors, differential, stack.push(differential, -1, null, null), base) && ok;
                        }
                    }
                } else {
                    ok = false;
                }
            }
            List extensions = src.getChildren("extension");
            int c = 0;
            for (Object extension : extensions) {
                if ("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations".equals(extension.getNamedChildValue("url", false))) {
                    ok = this.validateInheritsObligationProfile(errors, (org.hl7.fhir.r5.elementmodel.Element)extension, stack.push((org.hl7.fhir.r5.elementmodel.Element)extension, c, null, null), src) && ok;
                }
                ++c;
            }
            List contextInvariants = src.getChildren("contextInvariant");
            c = 0;
            for (org.hl7.fhir.r5.elementmodel.Element contextInvariant : contextInvariants) {
                ok = this.validateContextInvariant(errors, contextInvariant, src, stack.push(contextInvariant, c, null, null)) && ok;
                ++c;
            }
            String type = src.getNamedChildValue("type", false);
            if ("Extension".equals(type) && "http://hl7.org/fhir/StructureDefinition/Extension".equals(baseD = src.getNamedChildValue("baseDefinition", false)) && url != null) {
                String fixedUrl = this.getFixedValue(src);
                ok = this.rule(errors, "2023-08-05", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), fixedUrl != null, "SD_EXTENSION_URL_MISSING", url) ? this.rule(errors, "2023-08-05", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), url.equals(fixedUrl), "SD_EXTENSION_URL_MISMATCH", url, fixedUrl) && ok : false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
            ok = false;
        }
        return ok;
    }

    private boolean checkTypeParameters(List<ValidationMessage> errors, NodeStack stack, StructureDefinition base, StructureDefinition derived) {
        String bt = ToolingExtensions.readStringExtension((DomainResource)base, (String)"http://hl7.org/fhir/tools/StructureDefinition/type-parameter");
        if (bt == null) {
            return true;
        }
        if (this.rule(errors, "2024-05-29", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), derived.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-parameter"), "SD_TYPE_PARAMETER_MISSING", base.getVersionedUrl(), bt, derived.getVersionedUrl())) {
            String dt = ToolingExtensions.readStringExtension((DomainResource)derived, (String)"http://hl7.org/fhir/tools/StructureDefinition/type-parameter");
            StructureDefinition bsd = this.context.fetchTypeDefinition(bt);
            StructureDefinition dsd = this.context.fetchTypeDefinition(dt);
            if (this.rule(errors, "2024-05-29", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), bsd != null, "SD_TYPE_PARAMETER_UNKNOWN", base.getVersionedUrl(), bt) && this.rule(errors, "2024-05-29", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), dsd != null, "SD_TYPE_PARAMETER_UNKNOWN", derived.getVersionedUrl(), dt)) {
                StructureDefinition t = dsd;
                while (t != bsd && t != null) {
                    t = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, t.getBaseDefinition());
                }
                return this.rule(errors, "2024-05-29", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), t != null, "SD_TYPE_PARAMETER_INVALID", base.getVersionedUrl(), bt, derived.getVersionedUrl(), dt);
            }
        }
        return false;
    }

    private String getFixedValue(org.hl7.fhir.r5.elementmodel.Element src) {
        org.hl7.fhir.r5.elementmodel.Element diff = src.getNamedChild("differential", false);
        if (diff != null) {
            for (org.hl7.fhir.r5.elementmodel.Element ed : diff.getChildrenByName("element")) {
                String path = ed.getNamedChildValue("path", false);
                if (!"Extension.url".equals(path)) continue;
                return ed.getNamedChildValue("fixed", false);
            }
        }
        return null;
    }

    private boolean validateInheritsObligationProfile(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element extension, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element src) {
        String tgt = extension.getNamedChildValue("value", false);
        if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), tgt != null, "SD_OBGLIGATION_INHERITS_PROFILE_NO_TARGET", new Object[0])) {
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, tgt);
            if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), src != null, "SD_OBGLIGATION_INHERITS_PROFILE_TARGET_NOT_FOUND", tgt) && this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), ToolingExtensions.readBoolExtension((DomainResource)sd, (String)"http://hl7.org/fhir/tools/StructureDefinition/obligation-profile"), "SD_OBGLIGATION_INHERITS_PROFILE_NOT_RIGHT_TYPE", tgt)) {
                String base = src.getNamedChildValue("baseDefinition", false);
                if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), base != null && base.equals(sd.getBaseDefinition()), "SD_OBGLIGATION_INHERITS_PROFILE_NOT_RIGHT_BASE", tgt, sd.getBaseDefinition(), base)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean validateObligationProfile(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element elementList, NodeStack stack, StructureDefinition base) {
        boolean ok = true;
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (org.hl7.fhir.r5.elementmodel.Element element : elements) {
            ok = this.validateObligationProfileElement(errors, element, stack.push(element, cc, null, null), base) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateObligationProfileElement(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack push, StructureDefinition base) {
        String id = element.getNamedChildValue("id", false);
        ElementDefinition bd = base.getSnapshot().getElementById(id);
        if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, push.getLiteralPath(), bd != null, "SD_OBGLIGATION_PROFILE_UNMATCHED", id, base.getVersionedUrl())) {
            boolean ok = true;
            String name = null;
            int c = 0;
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                if (child.getName().equals(name)) {
                    ++c;
                } else {
                    name = child.getName();
                    c = 0;
                }
                NodeStack stack = push.push(child, c, null, null);
                if (child.getName().equals("extension")) {
                    String url = child.getNamedChildValue("url", false);
                    if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/obligation", "http://hl7.org/fhir/tools/StructureDefinition/obligation"})) continue;
                    ok = false;
                    this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName() + "#" + url);
                    continue;
                }
                if (child.getName().equals("mustSupport") || child.getName().equals("id")) continue;
                if (child.getName().equals("binding")) {
                    if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), bd.hasBinding(), "SD_OBGLIGATION_PROFILE_ILLEGAL_BINDING", id)) {
                        ok = this.validateObligationProfileElementBinding(errors, child, stack, id, bd) && ok;
                        continue;
                    }
                    ok = false;
                    continue;
                }
                if (child.getName().equals("path")) {
                    ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), child.primitiveValue().equals(bd.getPath()), "SD_OBGLIGATION_PROFILE_PATH_WRONG", id, child.primitiveValue(), bd.getPath()) && ok;
                    continue;
                }
                ok = false;
                this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName());
            }
            return ok;
        }
        return false;
    }

    private boolean validateObligationProfileElementBinding(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack nstack, String id, ElementDefinition bd) {
        boolean ok = true;
        String name = null;
        int c = 0;
        for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
            if (child.getName().equals(name)) {
                ++c;
            } else {
                name = child.getName();
                c = 0;
            }
            NodeStack stack = nstack.push(child, c, null, null);
            if (child.getName().equals("extension")) {
                String url = child.getNamedChildValue("url", false);
                if ("http://hl7.org/fhir/tools/StructureDefinition/additional-binding".equals(url) && !VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                    org.hl7.fhir.r5.elementmodel.Element purpose = child.getExtension("purpose");
                    if (purpose == null) continue;
                    String code = purpose.getNamedChildValue("value", false);
                    ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !Utilities.existsInList((String)code, (String[])new String[]{"maximum", "required", "extensible"}), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_CODE", id, code) && ok;
                    continue;
                }
                ok = false;
                this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName() + "#" + url);
                continue;
            }
            if (child.getName().equals("additional") && VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                String code = child.getNamedChildValue("purpose", false);
                ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !Utilities.existsInList((String)code, (String[])new String[]{"maximum", "required", "extensible"}), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_CODE", id, code) && ok;
                continue;
            }
            if (child.getName().equals("strength")) {
                String strengthBase = bd.getBinding().getStrengthElement().asStringValue();
                String strengthDerived = child.primitiveValue();
                ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), strengthBase != null && strengthBase.equals(strengthDerived), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_STRENGTH", id, strengthDerived, strengthBase) && ok;
                continue;
            }
            ok = false;
            this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL_ON_BINDING", id, child.getName());
        }
        return ok;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element src, NodeStack stack) {
        NodeStack n;
        boolean ok = true;
        String type = src.getNamedChildValue("type", false);
        List eclist = src.getChildren("context");
        List cilist = src.getChildren("contextInvariant");
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element ec : eclist) {
            n = stack.push(ec, i, null, null);
            if ("Extension".equals(type)) {
                String ct = null;
                String cv = null;
                if (VersionUtilities.isR4Plus((String)this.context.getVersion())) {
                    ct = ec.getNamedChildValue("type", false);
                    cv = ec.getNamedChildValue("expression", false);
                } else {
                    ct = src.getNamedChildValue("contextType", false);
                    cv = ec.primitiveValue();
                }
                if ("element".equals(ct) && "Element".equals(cv)) {
                    this.warning(errors, "2023-04-23", ValidationMessage.IssueType.BUSINESSRULE, n.getLiteralPath(), false, "SD_CONTEXT_SHOULD_NOT_BE_ELEMENT", cv, src.getNamedChildValue("id", false));
                    continue;
                }
                if (!"fhirpath".equals(ct)) continue;
                this.warning(errors, "2023-12-05", ValidationMessage.IssueType.BUSINESSRULE, n.getLiteralPath(), !this.isElement(cv), "SD_CONTEXT_SHOULD_NOT_BE_FHIRPATH", cv, src.getNamedChildValue("id", false));
                continue;
            }
            ok = this.rule(errors, "2023-04-23", ValidationMessage.IssueType.INVALID, n.getLiteralPath(), false, "SD_NO_CONTEXT_WHEN_NOT_EXTENSION", type) && ok;
        }
        i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element ci : cilist) {
            n = stack.push(ci, i, null, null);
            if ("Extension".equals(type)) continue;
            ok = this.rule(errors, "2023-04-23", ValidationMessage.IssueType.INVALID, n.getLiteralPath(), false, "SD_NO_CONTEXT_INV_WHEN_NOT_EXTENSION", type) && ok;
        }
        return ok;
    }

    private boolean isElement(String cv) {
        String tn = cv.contains(".") ? cv.substring(0, cv.indexOf(".")) : cv;
        StructureDefinition sd = this.context.fetchTypeDefinition(tn);
        if (sd != null) {
            return sd.getSnapshot().getElementByPath(cv) != null;
        }
        return false;
    }

    private boolean validateElementList(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element elementList, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd, String typeName, boolean logical, boolean constraint, String rootPath, String profileUrl, String profileType, StructureDefinition base, boolean experimental) {
        HashMap<String, SourcedInvariant> invariantMap = new HashMap<String, SourcedInvariant>();
        boolean ok = true;
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (org.hl7.fhir.r5.elementmodel.Element element : elements) {
            ok = this.validateElementDefinition(errors, elements, element, stack.push(element, cc, null, null), snapshot, hasSnapshot, sd, typeName, logical, constraint, invariantMap, rootPath, profileUrl, profileType, base, experimental) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateElementDefinition(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> elements, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd, String typeName, boolean logical, boolean constraint, Map<String, SourcedInvariant> invariantMap, String rootPath, String profileUrl, String profileType, StructureDefinition base, boolean experimental) {
        ElementDefinition ed;
        boolean ok = true;
        boolean typeMustSupport = false;
        String path = element.getNamedChildValue("path", false);
        boolean bl = ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), typeName == null || path == null || path.equals(typeName) || path.startsWith(typeName + "."), "SD_PATH_TYPE_MISMATCH", typeName, path) && ok;
        if (!snapshot) {
            ok = this.rule(errors, "2023-01-17", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), path.contains(".") || !element.hasChild("slicing", false), "SD_NO_SLICING_ON_ROOT", path) && ok;
        }
        ok = this.rule(errors, "2023-05-22", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), snapshot || !constraint || !element.hasChild("meaningWhenMissing", false) || this.meaningWhenMissingAllowed(element), "SD_ELEMENT_NOT_IN_CONSTRAINT", "meaningWhenMissing", path) && ok;
        List types = element.getChildrenByName("type");
        HashSet<String> typeCodes = new HashSet<String>();
        HashSet<String> characteristics = new HashSet<String>();
        boolean characteristicsValid = false;
        if (!path.contains(".")) {
            typeCodes.add(path);
            this.addCharacteristics(characteristics, path);
            characteristicsValid = true;
        }
        if (element.hasChild("slicing")) {
            org.hl7.fhir.r5.elementmodel.Element slicing = element.getNamedChild("slicing");
            NodeStack sStack = stack.push(slicing, -1, null, null);
            String tn = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
            StructureDefinition tsd = this.context.fetchTypeDefinition(tn);
            ElementDefinition ted = null;
            if (tsd != null && (ted = tsd.getSnapshot().getElementByPath(path)) != null) {
                ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, sStack, this.canSlice(ted), "SD_PATH_NO_SLICING", path) && ok;
            }
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element discriminator : slicing.getChildren("discriminator")) {
                TypeDetails td;
                NodeStack dStack = sStack.push(discriminator, i, null, null);
                String type = discriminator.getNamedChildValue("type");
                if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                    this.warning(errors, "2024-11-06", ValidationMessage.IssueType.BUSINESSRULE, dStack, !"pattern".equals(type), "SD_PATH_SLICING_DEPRECATED_R5", type);
                } else {
                    this.hint(errors, "2024-11-06", ValidationMessage.IssueType.BUSINESSRULE, dStack, !"pattern".equals(type), "SD_PATH_SLICING_DEPRECATED", type);
                }
                String pathExp = discriminator.getNamedChildValue("path");
                if (ted == null || (td = this.getTypesForElement(elements, element, tn, tsd.getUrl())).isEmpty()) continue;
                ArrayList warnings = new ArrayList();
                try {
                    TypeDetails eval = this.fpe.checkOnTypes((Object)this, "Resource", tn, td, this.fpe.parse(pathExp), warnings, true);
                    if (!eval.isEmpty()) continue;
                    ok = this.rule(errors, "2024-11-06", ValidationMessage.IssueType.INVALID, dStack, false, "SD_PATH_NOT_VALID", pathExp, path) && ok;
                }
                catch (Exception e) {
                    ok = this.rule(errors, "2024-11-06", ValidationMessage.IssueType.INVALID, dStack, false, "SD_PATH_ERROR", pathExp, path, e.getMessage()) && ok;
                }
            }
        }
        if (!snapshot && (element.hasChild("fixed") || element.hasChild("pattern")) && base != null && (ed = this.getDefinitionFromBase(base, element.getNamedChildValue("id"), element.getNamedChildValue("path"))) != null && (ed.hasFixed() || ed.hasPattern())) {
            NodeStack fn;
            if (ed.hasFixed()) {
                org.hl7.fhir.r5.elementmodel.Element fixed = element.getNamedChild("fixed");
                if (fixed != null) {
                    fn = stack.push(fixed, 0, null, null);
                    ok = this.rule(errors, "2024-03-26", ValidationMessage.IssueType.INVALID, fn, fixed.fhirType().equals(ed.getFixed().fhirType()), "SD_ELEMENT_FIXED_WRONG_TYPE", fixed.fhirType(), ed.getFixed().fhirType()) ? ((InstanceValidator)this.parent).checkFixedValue(errors, path, fixed, (Element)ed.getFixed(), base.getVersionedUrl(), "fixed", element, false, this.context.formatMessage("SD_ELEMENT_REASON_DERIVED", new Object[]{base.getVersionedUrl()})) && ok : false;
                }
            } else {
                org.hl7.fhir.r5.elementmodel.Element pattern = element.getNamedChild("pattern");
                if (pattern != null) {
                    fn = stack.push(pattern, 0, null, null);
                    ok = this.rule(errors, "2024-03-26", ValidationMessage.IssueType.INVALID, fn, ed.hasFixed(), "SD_ELEMENT_PATTERN_NO_FIXED", pattern.fhirType()) ? (this.rule(errors, "2024-03-26", ValidationMessage.IssueType.INVALID, fn, pattern.fhirType().equals(ed.getFixed().fhirType()), "SD_ELEMENT_PATTERN_WRONG_TYPE", pattern.fhirType(), ed.getFixed().fhirType()) ? ((InstanceValidator)this.parent).checkFixedValue(errors, path, pattern, (Element)ed.getFixed(), base.getVersionedUrl(), "pattern", element, true, this.context.formatMessage("SD_ELEMENT_REASON_DERIVED", new Object[]{base.getVersionedUrl()})) && ok : false) : false;
                }
            }
        }
        for (org.hl7.fhir.r5.elementmodel.Element type : types) {
            Base tcv;
            if (this.hasMustSupportExtension(type)) {
                typeMustSupport = true;
            }
            String tc = type.getChildValue("code");
            if (type.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type"}) && (tcv = type.getExtensionValue(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type"})) != null) {
                tc = tcv.primitiveValue();
            }
            if (Utilities.noString((String)tc) && type.hasChild("code", false) && VersionUtilities.isR4Plus((String)this.context.getVersion())) {
                boolean bl2 = ok = this.rule(errors, "2023-03-16", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_NO_TYPE_CODE_ON_CODE", path, sd.getId()) && ok;
            }
            if (Utilities.noString((String)tc)) continue;
            typeCodes.add(tc);
            HashSet<String> tcharacteristics = new HashSet<String>();
            StructureDefinition tsd = this.context.fetchTypeDefinition(tc);
            if (tsd != null) {
                this.checkTypeParameters(errors, stack, type, tc, tsd, path, sd);
                characteristicsValid = true;
                if (tsd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                    for (Extension ext : tsd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                        tcharacteristics.add(ext.getValue().primitiveValue());
                    }
                } else {
                    this.addCharacteristics(tcharacteristics, tc);
                }
                characteristics.addAll(tcharacteristics);
                if (type.hasChildren("targetProfile")) {
                    boolean bl3 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), tcharacteristics.contains("has-target"), "SD_ILLEGAL_CHARACTERISTICS", "targetProfile", tc) && ok;
                }
            }
            if (!snapshot && sd == null) continue;
            ok = this.validateElementType(errors, type, stack.push(type, -1, null, null), sd, path, logical) && ok;
        }
        if (typeMustSupport) {
            if (snapshot) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_SNAPSHOT", path);
            } else {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), hasSnapshot || "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_DIFF", path);
            }
        }
        if (element.hasChild("binding", false)) {
            org.hl7.fhir.r5.elementmodel.Element binding;
            if (!typeCodes.isEmpty() && characteristicsValid) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("can-bind"), "SD_ILLEGAL_CHARACTERISTICS", "Binding", typeCodes) && ok;
            }
            boolean bl4 = ok = this.validateBinding(errors, binding = element.getNamedChild("binding", false), stack.push(binding, -1, null, null), typeCodes, snapshot, path, experimental, sd) && ok;
        }
        if (!typeCodes.isEmpty() && characteristicsValid) {
            if (element.hasChild("maxLength", false)) {
                boolean bl5 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MaxLength", typeCodes) && ok;
            }
            if (element.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/minLength"})) {
                boolean bl6 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MinLength Extension", typeCodes) && ok;
            }
            if (element.hasChild("minValue", false)) {
                boolean bl7 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MinValue", typeCodes) && ok;
            }
            if (element.hasChild("maxValue", false)) {
                boolean bl8 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MaxValue", typeCodes) && ok;
            }
            if (element.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"})) {
                boolean bl9 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("is-continuous"), "SD_ILLEGAL_CHARACTERISTICS", "Max Decimal Places Extension", typeCodes) && ok;
            }
            if (element.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/maxSize"})) {
                boolean bl10 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-size"), "SD_ILLEGAL_CHARACTERISTICS", "Max Size", typeCodes) && ok;
            }
        }
        if (snapshot && element.getIdBase() != null && element.getIdBase().contains(".")) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !typeCodes.isEmpty() || element.hasChild("contentReference", false), "SD_NO_TYPES_OR_CONTENTREF", element.getIdBase())) {
                boolean repeating = !Utilities.existsInList((String)element.getChildValue("max"), (String[])new String[]{"0", "1"});
                org.hl7.fhir.r5.elementmodel.Element v = element.getNamedChild("defaultValue", false);
                if (v != null) {
                    boolean bl11 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "defaultValue", v.fhirType(), typeCodes) && ok;
                }
                if ((v = element.getNamedChild("fixed", false)) != null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "fixed", v.fhirType(), typeCodes) && ok;
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "fixed");
                    if (this.context.isPrimitiveType(v.fhirType())) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "fixed");
                    } else {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), false, "SD_VALUE_COMPLEX_FIXED", v.fhirType());
                    }
                }
                if ((v = element.getNamedChild("pattern", false)) != null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "pattern", v.fhirType(), typeCodes) && ok;
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "pattern");
                    if (this.context.isPrimitiveType(v.fhirType())) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "pattern");
                    }
                }
            } else {
                ok = false;
            }
        }
        List constraints = element.getChildrenByName("constraint");
        int cc = 0;
        for (org.hl7.fhir.r5.elementmodel.Element invariant : constraints) {
            ok = this.validateElementDefinitionInvariant(errors, invariant, stack.push(invariant, cc, null, null), invariantMap, elements, element, element.getNamedChildValue("path", false), rootPath, profileUrl, profileType, snapshot, base) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean canSlice(ElementDefinition ted) {
        return !"1".equals(ted.getMax()) || ted.getPath().contains("[x]");
    }

    private boolean checkTypeParameters(List<ValidationMessage> errors, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element typeE, String tc, StructureDefinition tsd, String path, StructureDefinition sd) {
        boolean ok = true;
        if (tsd.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-parameter")) {
            List extensions = typeE.getChildrenByName("extension");
            for (Extension ext : tsd.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-parameter")) {
                String name = ext.getExtensionString("name");
                String type = ext.getExtensionString("type");
                StructureDefinition psd = this.context.fetchTypeDefinition(type);
                if (psd == null || name == null) continue;
                boolean found = false;
                for (org.hl7.fhir.r5.elementmodel.Element e : extensions) {
                    if (!"http://hl7.org/fhir/tools/StructureDefinition/type-parameter".equals(e.getNamedChildValue("url"))) continue;
                    if (!e.hasExtension(new String[]{"name"})) {
                        this.rule(errors, "2024-12-31", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "SD_TYPE_PARAMETER_UNKNOWN", tc, "no name");
                        continue;
                    }
                    String ename = e.getExtensionValue(new String[]{"name"}).primitiveValue();
                    if (!name.equals(ename)) continue;
                    found = true;
                    String etype = e.getExtensionValue(new String[]{"type"}).primitiveValue();
                    for (Extension ex : sd.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-parameter")) {
                        String tn = ex.getExtensionString("name");
                        if (tn == null || !tn.equals(etype)) continue;
                        etype = ex.getExtensionString("type");
                        break;
                    }
                    StructureDefinition esd = this.context.fetchTypeDefinition(etype);
                    if (this.rule(errors, "2024-05-29", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), esd != null, "SD_TYPE_PARAMETER_UNKNOWN", tc, etype)) {
                        StructureDefinition t = esd;
                        while (t != null && t != psd) {
                            t = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, t.getBaseDefinition());
                        }
                        ok = this.rule(errors, "2024-05-29", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), t != null, "SD_TYPE_PARAMETER_INVALID_REF", tc, etype, tsd.getVersionedUrl(), name, type) & ok;
                        if (t == null || sd.getAbstract() || !esd.getAbstract()) continue;
                        this.warning(errors, "2024-05-29", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), t != null, "SD_TYPE_PARAMETER_ABSTRACT_WARNING", tc, etype, tsd.getVersionedUrl(), name, type);
                        continue;
                    }
                    ok = false;
                }
                ok = this.rule(errors, "2024-05-29", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), found, "SD_TYPE_PARAM_NOT_SPECIFIED", tc, tsd.getVersionedUrl(), name, path) && ok;
            }
        }
        return ok;
    }

    private ElementDefinition getDefinitionFromBase(StructureDefinition base, String id, String path) {
        ElementDefinition ed = null;
        if (id != null) {
            ed = base.getSnapshot().getElementById(id);
        }
        if (path != null) {
            ed = base.getSnapshot().getElementById(path);
        }
        return ed;
    }

    private boolean validateElementDefinitionInvariant(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element invariant, NodeStack stack, Map<String, SourcedInvariant> invariantMap, List<org.hl7.fhir.r5.elementmodel.Element> elements, org.hl7.fhir.r5.elementmodel.Element element, String path, String rootPath, String profileUrl, String profileType, boolean snapshot, StructureDefinition base) {
        boolean ok = true;
        String key = invariant.getNamedChildValue("key", false);
        String expression = invariant.getNamedChildValue("expression", false);
        String source = invariant.getNamedChildValue("source", false);
        if (this.warning(errors, "2023-06-19", ValidationMessage.IssueType.INFORMATIONAL, stack, !Utilities.noString((String)key), "ED_INVARIANT_NO_KEY", new Object[0]) && this.hint(errors, "2023-06-19", ValidationMessage.IssueType.INFORMATIONAL, stack, !Utilities.noString((String)expression) || VersionUtilities.isR5Plus((String)this.context.getVersion()), "ED_INVARIANT_NO_EXPRESSION", key)) {
            if (snapshot) {
                if (!Utilities.noString((String)expression)) {
                    if (invariantMap.containsKey(key)) {
                        ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, expression.equals(invariantMap.get(key).getInv()) || "ele-1".equals(key), "ED_INVARIANT_EXPRESSION_CONFLICT", key, expression, invariantMap.get(key).getInv());
                    } else {
                        invariantMap.put(key, new SourcedInvariant(profileUrl, path, expression));
                    }
                    if (Utilities.noString((String)source) || source.equals(profileUrl)) {
                        try {
                            Object exp = expression;
                            org.hl7.fhir.r5.elementmodel.Element te = element;
                            TypeDetails types = this.getTypesForElement(elements, te, profileType, profileUrl);
                            while (types.isEmpty() && te != null) {
                                org.hl7.fhir.r5.elementmodel.Element oldte = te;
                                if ((te = this.getParent(elements, te)) == null) continue;
                                exp = this.tail(oldte, te) + ".all(" + (String)exp + ")";
                                types = this.getTypesForElement(elements, te, profileType, profileUrl);
                            }
                            if (types.isEmpty()) {
                                types.addType(elements.get(0).getNamedChildValue("path", false));
                            }
                            ArrayList warnings = new ArrayList();
                            ValidationContext vc = new ValidationContext(invariant);
                            if (Utilities.existsInList((String)rootPath, (List)this.context.getResourceNames())) {
                                this.fpe.checkOnTypes((Object)vc, "Resource", rootPath, types, this.fpe.parse((String)exp), warnings);
                            } else {
                                StructureDefinition sd = this.context.fetchTypeDefinition(rootPath);
                                if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                                    this.fpe.checkOnTypes((Object)vc, "Resource", rootPath, types, this.fpe.parse((String)exp), warnings);
                                } else if (sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
                                    String tn = ToolingExtensions.readStringExtension((DomainResource)sd, (String)"http://hl7.org/fhir/tools/StructureDefinition/logical-container");
                                    this.fpe.checkOnTypes((Object)vc, "Resource", tn == null ? rootPath : tn, types, this.fpe.parse((String)exp), warnings);
                                } else {
                                    this.fpe.checkOnTypes((Object)vc, "Resource", "DomainResource", types, this.fpe.parse((String)exp), warnings);
                                }
                            }
                            for (FHIRPathEngine.IssueMessage s : warnings) {
                                this.warning(errors, "2023-07-27", ValidationMessage.IssueType.BUSINESSRULE, stack, s.getId(), false, key + ": " + s.getMessage(), new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (this.debug) {
                                e.printStackTrace();
                            }
                            ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, false, "ED_INVARIANT_EXPRESSION_ERROR", key, expression, e.getMessage()) && ok;
                        }
                    }
                }
            } else if (this.rule(errors, "2023-07-27", ValidationMessage.IssueType.INVALID, stack, source == null || source.equals(profileUrl), "ED_INVARIANT_DIFF_NO_SOURCE", key, source)) {
                SourcedInvariant inv;
                Object[] objectArray = new Object[3];
                objectArray[0] = key;
                objectArray[1] = inv == null ? "??" : inv.getSd();
                Object object = objectArray[2] = inv == null ? "??" : inv.getInv();
                inv = this.findInvariantInBase(base, key);
                if (this.rule(errors, "2023-07-27", ValidationMessage.IssueType.INVALID, stack, inv == null || inv.getInv().equals(expression), "ED_INVARIANT_KEY_ALREADY_USED", objectArray)) {
                    if (invariantMap.containsKey(key)) {
                        SourcedInvariant src = invariantMap.get(key);
                        ok = this.rule(errors, "2023-07-27", ValidationMessage.IssueType.INVALID, stack, expression.equals(src.getInv()), "ED_INVARIANT_KEY_ALREADY_USED", key, src.getEd(), src.getInv()) && ok;
                    } else {
                        invariantMap.put(key, new SourcedInvariant(profileUrl, path, expression));
                    }
                } else {
                    ok = false;
                }
            } else {
                ok = false;
            }
        }
        return ok;
    }

    private boolean validateContextInvariant(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element invariant, org.hl7.fhir.r5.elementmodel.Element sd, NodeStack stack) {
        boolean ok = true;
        String expression = invariant.getValue();
        if (!Utilities.noString((String)expression)) {
            String exp = expression;
            List<String> types = this.listTypeContexts(sd);
            if (types.size() == 0) {
                this.hint(errors, "2023-10-31", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "UNABLE_TO_DETERMINE_TYPE_CONTEXT_INV", this.listContexts(sd));
            } else {
                try {
                    ArrayList warnings = new ArrayList();
                    ValidationContext vc = new ValidationContext(invariant);
                    this.fpe.checkOnTypes((Object)vc, "Resource", "DomainResource", types, this.fpe.parse(exp), warnings);
                    for (FHIRPathEngine.IssueMessage s : warnings) {
                        this.warning(errors, "2023-07-27", ValidationMessage.IssueType.BUSINESSRULE, stack, s.getId(), false, s.getMessage(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, false, "ED_CONTEXT_INVARIANT_EXPRESSION_ERROR", expression, e.getMessage()) && ok;
                }
            }
        }
        return ok;
    }

    private Object listContexts(org.hl7.fhir.r5.elementmodel.Element sd) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (org.hl7.fhir.r5.elementmodel.Element e : sd.getChildren("context")) {
            b.append(e.getNamedChildValue("type", false) + "=" + e.getNamedChildValue("expression", false));
        }
        return b.toString();
    }

    private List<String> listTypeContexts(org.hl7.fhir.r5.elementmodel.Element sd) {
        ArrayList<String> types = new ArrayList<String>();
        for (org.hl7.fhir.r5.elementmodel.Element e : sd.getChildren("context")) {
            switch (e.getNamedChildValue("type", false)) {
                case "fhirpath": {
                    break;
                }
                case "element": {
                    types.add(e.getNamedChildValue("expression", false));
                    break;
                }
                case "extension": {
                    types.add(e.getNamedChildValue("Extension", false));
                    types.add(e.getNamedChildValue("Extension.value", false));
                    break;
                }
            }
        }
        return types;
    }

    private SourcedInvariant findInvariantInBase(StructureDefinition base, String key) {
        for (ElementDefinition ed : base.getSnapshot().getElement()) {
            for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                if (!key.equals(inv.getKey())) continue;
                return new SourcedInvariant(base.getVersionedUrl(), ed.getPath(), inv.getExpression());
            }
        }
        for (StructureDefinition sd : this.cu.allBaseStructures()) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!key.equals(inv.getKey())) continue;
                    return new SourcedInvariant(sd.getVersionedUrl(), ed.getPath(), inv.getExpression());
                }
            }
        }
        return null;
    }

    private boolean typesHaveInvariant(Map<String, String> invMap, String key, String expression) {
        if (invMap.containsKey(key)) {
            return !expression.equals(invMap.get(key));
        }
        return false;
    }

    private String tail(org.hl7.fhir.r5.elementmodel.Element te, org.hl7.fhir.r5.elementmodel.Element newte) {
        String p = te.getNamedChildValue("path", false);
        String pn = newte.getNamedChildValue("path", false);
        return p.substring(pn.length() + 1);
    }

    private org.hl7.fhir.r5.elementmodel.Element getParent(List<org.hl7.fhir.r5.elementmodel.Element> elements, org.hl7.fhir.r5.elementmodel.Element te) {
        String path = te.getNamedChildValue("path", false);
        for (int i = elements.indexOf(te) - 1; i >= 0; --i) {
            String p = elements.get(i).getNamedChildValue("path", false);
            if (!path.startsWith(p + ".")) continue;
            return elements.get(i);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeDetails getTypesForElement(List<org.hl7.fhir.r5.elementmodel.Element> elements, org.hl7.fhir.r5.elementmodel.Element element, String profileType, String profileUrl) {
        TypeDetails types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
        if (element.hasChild("path", false) && !element.getNamedChildValue("path", false).contains(".")) {
            String t = element.getNamedChildValue("path", false);
            if (profileType.equals(t)) {
                types.addType(profileType, profileUrl);
                return types;
            } else {
                if (!profileType.endsWith("/" + t)) throw new Error("Error: this should not happen: '" + t + "' vs '" + profileType + "'?");
                types.addType(profileType, profileUrl);
            }
            return types;
        } else {
            for (org.hl7.fhir.r5.elementmodel.Element tr : element.getChildrenByName("type")) {
                String t = tr.getNamedChildValue("code", false);
                if (t.startsWith("http://hl7.org/fhirpath")) {
                    t = tr.getExtensionValue(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type"}).primitiveValue();
                }
                if (t == null) continue;
                if (this.isAbstractType(t) && this.hasChildren(element, elements)) {
                    if (!Utilities.isAbsoluteUrl((String)profileType)) {
                        types.addType(profileUrl + "#" + element.getNamedChildValue("path", false));
                        continue;
                    }
                    types.addType(profileType + "#" + element.getNamedChildValue("path", false));
                    continue;
                }
                types.addType(t);
            }
        }
        return types;
    }

    private boolean hasChildren(org.hl7.fhir.r5.elementmodel.Element element, List<org.hl7.fhir.r5.elementmodel.Element> elements) {
        int i = elements.indexOf(element);
        String path = element.getNamedChildValue("path", false) + ".";
        while (i < elements.size()) {
            String p = elements.get(i).getNamedChildValue("path", false) + ".";
            if (!p.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isAbstractType(String t) {
        StructureDefinition sd = this.context.fetchTypeDefinition(t);
        return sd != null && sd.getAbstract();
    }

    private boolean meaningWhenMissingAllowed(org.hl7.fhir.r5.elementmodel.Element element) {
        String path = element.getNamedChildValue("path", false);
        return path != null && ("Extension".equals(path) || path.endsWith(".extension"));
    }

    private boolean addCharacteristics(Set<String> set, String tc) {
        switch (tc) {
            case "boolean": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "integer": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "integer64": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "decimal": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "base64Binary": {
                return this.addCharacteristicsForType(set, "has-size");
            }
            case "instant": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "string": {
                return this.addCharacteristicsForType(set, "has-length", "do-translations", "can-bind");
            }
            case "uri": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "date": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "dateTime": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "time": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "canonical": {
                return this.addCharacteristicsForType(set, "has-target", "has-length");
            }
            case "code": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "id": {
                return this.addCharacteristicsForType(set, "has-length");
            }
            case "markdown": {
                return this.addCharacteristicsForType(set, "do-translations", "has-length");
            }
            case "oid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "positiveInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "unsignedInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "url": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "uuid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "xhtml": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Address": {
                return this.addCharacteristicsForType(set, "do-translations");
            }
            case "Age": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Annotation": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Attachment": {
                return this.addCharacteristicsForType(set, "has-size", "do-translations");
            }
            case "CodeableConcept": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "CodeableReference": {
                return this.addCharacteristicsForType(set, "has-target", "can-bind", "do-translations");
            }
            case "Coding": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "ContactPoint": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Count": {
                return this.addCharacteristicsForType(set, "has-range");
            }
            case "Distance": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Duration": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "HumanName": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Identifier": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Money": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "Period": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Quantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Range": {
                return this.addCharacteristicsForType(set, "has-units", "can-bind", "has-units");
            }
            case "Ratio": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "RatioRange": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "Reference": {
                return this.addCharacteristicsForType(set, "has-target");
            }
            case "SampledData": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Signature": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Timing": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ContactDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Contributor": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "DataRequirement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Expression": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ParameterDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "RelatedArtifact": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "TriggerDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "UsageContext": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Dosage": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Meta": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Resource": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Extension": {
                return this.addCharacteristicsForType(set, "can-bind");
            }
            case "Narrative": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "MoneyQuantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "SimpleQuantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "MarketingStatus": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ExtendedContactDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "VirtualServiceDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Availability": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "MonetaryComponent": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ElementDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "BackboneElement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Element": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Base": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
        }
        return this.addCharacteristicsForType(set, new String[0]);
    }

    private boolean addCharacteristicsForType(Set<String> set, String ... cl) {
        for (String c : cl) {
            set.add(c);
        }
        return true;
    }

    private String boundType(Set<String> typeCodes) {
        for (String tc : typeCodes) {
            if (!Utilities.existsInList((String)tc, (String[])new String[]{"code", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            return tc;
        }
        return null;
    }

    private String bindableType(Set<String> typeCodes) {
        String ret = this.boundType(typeCodes);
        if (ret != null) {
            return ret;
        }
        for (String tc : typeCodes) {
            if (Utilities.existsInList((String)tc, (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) {
                return tc;
            }
            StructureDefinition sd = this.context.fetchTypeDefinition(tc);
            while (sd != null) {
                if (sd.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) {
                    return tc;
                }
                for (Extension ext : sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                    if (!"can-bind".equals(ext.getValue().primitiveValue())) continue;
                    return tc;
                }
                if (Utilities.existsInList((String)sd.getType(), (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) {
                    return tc;
                }
                sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
        }
        return null;
    }

    private boolean validateBinding(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element binding, NodeStack stack, Set<String> typeCodes, boolean snapshot, String path, boolean experimental, StructureDefinition profile) {
        boolean ok = true;
        if (this.bindableType(typeCodes) == null) {
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot, "SD_ED_BIND_NO_BINDABLE", path, typeCodes.toString()) && ok;
        }
        if (!snapshot) {
            Set<String> bindables = this.getListofBindableTypes(typeCodes);
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), bindables.size() <= 1, "SD_ED_BIND_MULTIPLE_TYPES", path, typeCodes.toString());
        }
        if (binding.hasChild("valueSet", false)) {
            org.hl7.fhir.r5.elementmodel.Element valueSet = binding.getNamedChild("valueSet", false);
            String ref = valueSet.hasPrimitiveValue() ? valueSet.primitiveValue() : valueSet.getNamedChildValue("reference", false);
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null || this.serverSupportsValueSet(ref), "SD_ED_BIND_UNKNOWN_VS", path, ref) && vs != null) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType())) {
                        ValueSet vsr = (ValueSet)vs;
                        if (!"example".equals(binding.getNamedChildValue("strength"))) {
                            this.warning(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !vsr.getExperimental() || experimental, "SD_ED_EXPERIMENTAL_BINDING", path, ref);
                        }
                    } else {
                        ok = false;
                    }
                }
            }
        }
        if (binding.hasChildren("additional")) {
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ab : binding.getChildren("additional")) {
                ok = this.validateAdditionalBinding(errors, ab, stack.push(ab, i, null, null), snapshot, path, experimental) && ok;
                ++i;
            }
        }
        if (binding.hasExtension(new String[]{"http://hl7.org/fhir/tools/StructureDefinition/additional-binding"})) {
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ab : binding.getChildren("extension")) {
                String url = ab.getNamedChildValue("url");
                if ("http://hl7.org/fhir/tools/StructureDefinition/additional-binding".equals(url)) {
                    ok = this.validateAdditionalBindingExtension(errors, ab, stack.push(ab, i, null, null), snapshot, path, experimental, profile) && ok;
                }
                ++i;
            }
        }
        return ok;
    }

    private boolean validateAdditionalBinding(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element binding, NodeStack stack, boolean snapshot, String path, boolean experimental) {
        boolean ok = true;
        if (binding.hasChild("valueSet", false)) {
            org.hl7.fhir.r5.elementmodel.Element valueSet = binding.getNamedChild("valueSet", false);
            String ref = valueSet.hasPrimitiveValue() ? valueSet.primitiveValue() : valueSet.getNamedChildValue("reference", false);
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null || this.serverSupportsValueSet(ref), "SD_ED_BIND_UNKNOWN_VS", path, ref) && vs != null) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType())) {
                        ValueSet vsr = (ValueSet)vs;
                        this.warning(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !vsr.getExperimental() || experimental, "SD_ED_EXPERIMENTAL_BINDING", path, ref);
                    } else {
                        ok = false;
                    }
                }
            }
        }
        if (binding.hasChildren("usage")) {
            for (org.hl7.fhir.r5.elementmodel.Element usage : binding.getChildren("usage")) {
                this.warning(errors, "2024-09-20", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "test", new Object[0]);
            }
        }
        return ok;
    }

    private boolean validateAdditionalBindingExtension(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element binding, NodeStack stack, boolean snapshot, String path, boolean experimental, StructureDefinition profile) {
        boolean ok = true;
        if (binding.hasExtension(new String[]{"valueSet"})) {
            org.hl7.fhir.r5.elementmodel.Element valueSet = binding.getExtension("valueSet");
            org.hl7.fhir.r5.elementmodel.Element vv = valueSet.getNamedChild("value");
            String ref = vv.hasPrimitiveValue() ? vv.primitiveValue() : vv.getNamedChildValue("reference", false);
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null || this.serverSupportsValueSet(ref), "SD_ED_BIND_UNKNOWN_VS", path, ref) && vs != null) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType())) {
                        ValueSet vsr = (ValueSet)vs;
                        this.warning(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !vsr.getExperimental() || experimental, "SD_ED_EXPERIMENTAL_BINDING", path, ref);
                    } else {
                        ok = false;
                    }
                }
            }
        }
        if (binding.hasExtension(new String[]{"usage"})) {
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element usage : binding.getChildren("extension")) {
                String url = usage.getNamedChildValue("url");
                if ("usage".equals(url)) {
                    org.hl7.fhir.r5.elementmodel.Element uv = usage.getNamedChild("value");
                    ok = this.validateAdditionalBindingUsage(errors, uv, stack.push(uv, -1, null, null), path, profile) && ok;
                }
                ++i;
            }
        }
        return ok;
    }

    private boolean validateAdditionalBindingUsage(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element usage, NodeStack stack, String path, StructureDefinition profile) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element cc = usage.getNamedChild("code");
        if (cc != null) {
            String system = cc.getNamedChildValue("system");
            String code = cc.getNamedChildValue("code");
            if (system != null && system.equals(profile.getUrl())) {
                ElementDefinition ed = profile.getDifferential().getElementByPath(code);
                if (ed == null) {
                    ed = profile.getSnapshot().getElementByPath(code);
                }
                if (ed == null) {
                    ok = false;
                    this.rule(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "SD_ED_ADDITIONAL_BINDING_USAGE_INVALID_ELEMENT", system, code);
                } else if (usage.hasChild("value")) {
                    String t = usage.getNamedChild("value").fhirType();
                    ok = this.rule(errors, "2024-09-20", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "CodeableConcept".equals(t), "SD_ED_ADDITIONAL_BINDING_USAGE_INVALID_TYPE", t, "CodeableConcept") && ok;
                }
            } else {
                this.hint(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "SD_ED_ADDITIONAL_BINDING_USAGE_UNKNOWN", system, code);
            }
        }
        return ok;
    }

    private Set<String> getListofBindableTypes(Set<String> types) {
        HashSet<String> res = new HashSet<String>();
        for (String s : types) {
            if (!Utilities.existsInList((String)s, (String[])new String[]{"code", "string", "url", "uri", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            res.add(s);
        }
        return res;
    }

    private boolean serverSupportsValueSet(String ref) {
        ValidationResult vr = this.context.validateCode(new ValidationOptions(FhirPublication.R5).withCheckValueSetOnly().withNoClient(), new Coding("http://loinc.org", "5792-7", null), new ValueSet().setUrl(ref));
        return vr.getErrorClass() == null || vr.getErrorClass() == TerminologyServiceErrorClass.UNKNOWN;
    }

    private boolean validateElementType(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element type, NodeStack stack, StructureDefinition sd, String path, boolean logical) {
        boolean ok;
        block7: {
            ok = true;
            String code = type.getNamedChildValue("code", false);
            if (code == null && path != null) {
                code = this.getTypeCodeFromSD(sd, path);
            } else {
                Set<String> types = this.getTypeCodesFromSD(sd, path);
                ok = this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), types.isEmpty() || types.contains(code), types.size(), "SD_ED_TYPE_PROFILE_WRONG_TYPE", code, types.toString(), sd.getVersionedUrl());
            }
            if (code == null) break block7;
            List profiles = type.getChildrenByName("profile");
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion())) {
                for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                    ok = this.validateProfileTypeOrTarget(errors, profile, code, stack.push(profile, -1, null, null), path) && ok;
                }
            } else {
                for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                    ok = this.validateTypeProfile(errors, profile, code, stack.push(profile, -1, null, null), path, sd) && ok;
                }
                profiles = type.getChildrenByName("targetProfile");
                for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                    ok = this.validateTargetProfile(errors, profile, code, stack.push(profile, -1, null, null), path, logical) && ok;
                }
            }
        }
        return ok;
    }

    private boolean validateProfileTypeOrTarget(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element profile, String code, NodeStack stack, String path) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
            }
        } else {
            if (sd == null) {
                sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
            }
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok;
                } else {
                    boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), this.isInstanceOf(t, code), "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
                    if (t.getType().equals("Extension")) {
                        boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                        boolean isModifierContext = path.endsWith(".modifierExtension");
                        ok = isModifierDefinition ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path) && ok;
                    }
                }
            }
        }
        return ok;
    }

    private String getTypeCodeFromSD(StructureDefinition sd, String path) {
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.hasPath() || !t.getPath().equals(path)) continue;
            if (ed == null) {
                ed = t;
                continue;
            }
            return null;
        }
        return ed != null && ed.getType().size() == 1 ? ed.getTypeFirstRep().getCode() : null;
    }

    private Set<String> getTypeCodesFromSD(StructureDefinition sd, String path) {
        HashSet<String> codes = new HashSet<String>();
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.hasPath() || !t.getPath().equals(path)) continue;
            for (ElementDefinition.TypeRefComponent tr : t.getType()) {
                codes.add(tr.getCode());
            }
        }
        return codes;
    }

    private boolean validateTypeProfile(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element profile, String code, NodeStack stack, String path, StructureDefinition source) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (sd == null) {
            sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
        }
        if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
            StructureDefinition t = this.determineBaseType(sd);
            if (t == null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok;
            } else if (!this.isInstanceOf(t, code)) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
            } else if (t.getType().equals("Extension")) {
                this.checkDefinitionStatus(errors, profile, path, sd, (CanonicalResource)source, this.context.formatMessage("MSG_DEPENDS_ON_EXTENSION", new Object[0]));
                boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                boolean isModifierContext = path.endsWith(".modifierExtension");
                ok = isModifierDefinition ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path) && ok;
            } else {
                this.checkDefinitionStatus(errors, profile, path, sd, (CanonicalResource)source, this.context.formatMessage("MSG_DEPENDS_ON_PROFILE", new Object[0]));
            }
        }
        return ok;
    }

    private boolean checkIsModifierExtension(StructureDefinition t) {
        return t.getSnapshot().getElementFirstRep().getIsModifier();
    }

    private boolean validateTargetProfile(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element profile, String code, NodeStack stack, String path, boolean logical) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference") || code.equals("CodeableReference")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE || logical && this.isReferenceableTarget(t), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Resource") && ok;
            }
        } else if (code.equals("canonical")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : (!VersionUtilities.isR5Plus((String)this.context.getVersion()) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()) || "Resource".equals(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource") && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), Utilities.existsInList((String)t.getType(), (String[])new String[]{"Resource", "CanonicalResource"}) || VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource") && ok);
            }
        } else {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_NO_TARGET_PROFILE", code) && ok;
        }
        return ok;
    }

    private boolean isReferenceableTarget(StructureDefinition t) {
        for (Extension ext : t.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
            String c;
            if (!ext.hasValue() || !"can-be-target".equals(c = ext.getValue().primitiveValue())) continue;
            return true;
        }
        return ToolingExtensions.readBoolExtension((DomainResource)t, (String)"http://hl7.org/fhir/tools/StructureDefinition/logical-target");
    }

    private boolean isInstanceOf(StructureDefinition sd, String code) {
        while (sd != null) {
            if (sd.getType().equals(code)) {
                return true;
            }
            if (sd.getUrl().equals(code)) {
                return true;
            }
            StructureDefinition structureDefinition = sd = sd.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition()) : null;
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion()) || sd == null || sd.getAbstract() || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) continue;
            sd = null;
        }
        return false;
    }

    private StructureDefinition determineBaseType(StructureDefinition sd) {
        while (sd != null && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return sd;
    }

    private boolean hasMustSupportExtension(org.hl7.fhir.r5.elementmodel.Element type) {
        if ("true".equals(this.getExtensionValue(type, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        List profiles = type.getChildrenByName("profile");
        for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        profiles = type.getChildrenByName("targetProfile");
        for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        return false;
    }

    private String getExtensionValue(org.hl7.fhir.r5.elementmodel.Element element, String url) {
        List extensions = element.getChildrenByName("extension");
        for (org.hl7.fhir.r5.elementmodel.Element extension : extensions) {
            if (!url.equals(extension.getNamedChildValue("url", false))) continue;
            return extension.getNamedChildValue("value", false);
        }
        return null;
    }

    private StructureDefinition loadAsSD(org.hl7.fhir.r5.elementmodel.Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (org.hl7.fhir.r5.elementmodel.Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }

    public class SourcedInvariant {
        private String sd;
        private String ed;
        private String inv;

        protected SourcedInvariant(String sd, String ed, String inv) {
            this.sd = sd;
            this.ed = ed;
            this.inv = inv;
        }

        public String getSd() {
            return this.sd;
        }

        public String getEd() {
            return this.ed;
        }

        public String getInv() {
            return this.inv;
        }
    }
}

