/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.model.FileInfo;

public class ValidationRequest {
    @JsonProperty(value="cliContext")
    @SerializedName(value="cliContext")
    private CliContext cliContext;
    @JsonProperty(value="filesToValidate")
    @SerializedName(value="filesToValidate")
    private List<FileInfo> filesToValidate = new ArrayList<FileInfo>();
    @JsonProperty(value="sessionId")
    @SerializedName(value="sessionId")
    public String sessionId;

    @SerializedName(value="cliContext")
    @JsonProperty(value="cliContext")
    public CliContext getCliContext() {
        return this.cliContext;
    }

    public ValidationRequest() {
    }

    public ValidationRequest(CliContext cliContext, List<FileInfo> filesToValidate) {
        this(cliContext, filesToValidate, null);
    }

    public ValidationRequest(CliContext cliContext, List<FileInfo> filesToValidate, String sessionToken) {
        this.cliContext = cliContext;
        this.filesToValidate = filesToValidate;
        this.sessionId = sessionToken;
    }

    @SerializedName(value="cliContext")
    @JsonProperty(value="cliContext")
    public ValidationRequest setCliContext(CliContext cliContext) {
        this.cliContext = cliContext;
        return this;
    }

    @SerializedName(value="filesToValidate")
    @JsonProperty(value="filesToValidate")
    public List<FileInfo> getFilesToValidate() {
        return this.filesToValidate;
    }

    @SerializedName(value="filesToValidate")
    @JsonProperty(value="filesToValidate")
    public ValidationRequest setFilesToValidate(List<FileInfo> filesToValidate) {
        this.filesToValidate = filesToValidate;
        return this;
    }

    @SerializedName(value="sessionId")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @SerializedName(value="sessionId")
    @JsonProperty(value="sessionId")
    public ValidationRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String listSourceFiles() {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FileInfo fp : this.filesToValidate) {
            fileNames.add(fp.getFileName());
        }
        return String.join((CharSequence)", ", fileNames);
    }
}

