/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import org.hl7.fhir.r5.elementmodel.Element;
import org.slf4j.Logger;

public class ResourcePercentageLogger {
    private final Logger logger;
    private final int total;
    private final String fhirType;
    private int last;
    private int current;
    private final boolean log;
    private final String url;
    private static int instance;

    public ResourcePercentageLogger(Logger logger, int total, String fhirType, String url, boolean log) {
        this.logger = logger;
        this.total = total;
        this.fhirType = fhirType;
        ++instance;
        this.last = 0;
        this.log = log;
        this.url = url;
        if (log) {
            String startString = "Validate " + fhirType + " against " + url;
            System.out.print(startString);
            this.logger.debug(startString);
        }
    }

    public void done() {
        if (this.log) {
            System.out.println("|");
            this.logger.debug("Done validating " + this.fhirType + " against " + this.url);
        }
    }

    public void seeElement(Element e) {
        if (e.getInstanceId() != instance) {
            int pct;
            e.setInstanceId(instance);
            ++this.current;
            int n = pct = this.total == 0 ? 0 : this.current * 100 / this.total;
            if (pct > this.last + 2) {
                while (this.last + 2 < pct) {
                    if (this.log) {
                        System.out.print(".");
                    }
                    this.last += 2;
                    if (this.last % 20 != 0 || !this.log) continue;
                    System.out.print("" + this.last);
                    this.logger.debug(this.last + "% complete");
                }
            }
        }
    }

    public String getUrl() {
        return this.url;
    }
}

