/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.validation.codegen.AnalysisElementInfo;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaExtensionsConstantsGenerator;
import org.hl7.fhir.validation.codegen.JavaExtensionsFactoryGenerator;

public class JavaExtensionsGenerator {
    private String path;
    private Definitions master;
    private Configuration config;
    private String date;
    private String version;
    private String packageName;
    private Map<String, AnalysisElementInfo> elementInfo;
    private Set<String> genClassList;

    public JavaExtensionsGenerator(String path, Definitions master, Configuration config, String date, String version, String packageName, Map<String, AnalysisElementInfo> elementInfo, Set<String> genClassList) {
        this.path = path;
        this.master = master;
        this.config = config;
        this.date = date;
        this.version = version;
        this.packageName = packageName;
        this.elementInfo = elementInfo;
        this.genClassList = genClassList;
    }

    public void generate(Map<String, StructureDefinition> extensions) throws Exception {
        List urls = Utilities.sorted(extensions.keySet());
        HashSet<String> names = new HashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        for (StructureDefinition sd : extensions.values()) {
            if (names.contains(sd.getName())) {
                dups.add(sd.getName());
                continue;
            }
            names.add(sd.getName());
        }
        for (StructureDefinition sd : extensions.values()) {
            if (this.config.getIni().hasProperty("ExtensionNames", sd.getUrl())) {
                sd.setUserData("name", (Object)this.config.getIni().getStringProperty("ExtensionNames", sd.getUrl()));
                continue;
            }
            if (dups.contains(sd.getName())) {
                sd.setUserData("name", (Object)(this.sanitiseName(sd.getName()) + Utilities.capitalize((String)sd.getUserString("source"))));
                continue;
            }
            sd.setUserData("name", (Object)this.sanitiseName(sd.getName()));
        }
        JavaExtensionsFactoryGenerator gen = new JavaExtensionsFactoryGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.path, "Extensions.java"})), this.master, this.config, this.version, this.date, this.packageName, this.elementInfo, this.genClassList);
        gen.start();
        JavaExtensionsConstantsGenerator cgen = new JavaExtensionsConstantsGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{this.path, "ExtensionConstants.java"})), this.master, this.config, this.version, this.date, this.packageName);
        cgen.start();
        for (String url : urls) {
            StructureDefinition sd = extensions.get(url);
            String name = sd.getUserString("name");
            String nConst = this.genConstantName(name);
            cgen.generate(sd, name, nConst);
            if (ProfileUtilities.isModifierExtension((StructureDefinition)sd)) {
                cgen.seeModifier(sd);
            }
            if (!ProfileUtilities.isSimpleExtension((StructureDefinition)sd)) continue;
            gen.generateSimple(sd, name, nConst);
        }
        cgen.finish();
        gen.finish();
    }

    private String sanitiseName(String name) {
        return Utilities.capitalize((String)name.replace("-", "").replace(" ", ""));
    }

    private String genConstantName(String name) {
        StringBuilder b = new StringBuilder();
        boolean hasLower = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Utilities.existsInList((int)ch, (int[])new int[]{32, 45})) continue;
            if (hasLower && Character.isUpperCase(ch)) {
                b.append("_");
            }
            if (Character.isLowerCase(ch)) {
                hasLower = true;
            }
            b.append(Character.toUpperCase(ch));
        }
        return b.toString();
    }
}

