/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccessor;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.ai.AIAPI;
import org.hl7.fhir.validation.ai.CodeAndTextValidationRequest;
import org.hl7.fhir.validation.ai.CodeAndTextValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ollama
extends AIAPI {
    private static final Logger log = LoggerFactory.getLogger(Ollama.class);
    private static final String MODEL = "llama3.2";
    private String url;
    private String model;

    protected Ollama(JsonObject config, String details) throws MalformedURLException {
        super(config);
        String string = this.model = config.has("model") ? config.asString("model") : MODEL;
        if (details == null) {
            this.url = "http://localhost:11434/api/generate";
        } else {
            if (details.contains("#")) {
                this.model = details.substring(details.indexOf("#") + 1);
                details = details.substring(0, details.indexOf("#"));
            }
            this.url = Utilities.noString((String)details) ? "http://localhost:11434/api/generate" : (Utilities.isInteger((String)details) ? "http://localhost:" + details + "/api/generate" : details);
        }
    }

    public String details() {
        return this.url + " using model " + this.model;
    }

    @Override
    public List<CodeAndTextValidationResult> validateCodings(List<CodeAndTextValidationRequest> requests) throws IOException {
        ArrayList<CodeAndTextValidationResult> res = new ArrayList<CodeAndTextValidationResult>();
        for (CodeAndTextValidationRequest req : requests) {
            StringBuilder prompt = new StringBuilder();
            for (String s : this.config.forceArray("prompt").asStrings()) {
                prompt.append(String.format(s, Integer.toString(1), req.getText(), this.getSystemName(req.getSystem()), req.getCode(), req.getDisplay(), req.getContext(), req.getLang()));
                prompt.append("\n");
            }
            System.out.print(".");
            log.debug("  processed request");
            JsonObject json = this.getResponse(prompt.toString());
            res.add(this.parseValidationResponse(json, req));
        }
        return res;
    }

    public JsonObject getResponse(String prompt) throws IOException {
        JsonObject j = new JsonObject();
        j.add("model", this.model);
        j.add("format", "json");
        j.add("stream", false);
        j.add("prompt", prompt);
        ManagedWebAccessor web = ManagedWebAccess.accessor((Iterable)Utilities.strings((String[])new String[]{"web"}));
        HTTPResult response = web.post(this.url, JsonParser.composeBytes((JsonElement)j), "application/json", "application/json");
        response.checkThrowException();
        JsonObject json = JsonParser.parseObject((String)response.getContentAsString());
        String text = json.asString("response");
        FileUtilities.stringToFile((String)text, (String)Utilities.path((String[])new String[]{"[tmp]", "fhir-validator-ollama-response.json"}));
        return JsonParser.parseObject((String)text);
    }

    private CodeAndTextValidationResult parseValidationResponse(JsonObject json, CodeAndTextValidationRequest request) throws IOException {
        if (json.has("explanation") && json.has("isCompatible")) {
            return this.parseItem(request, json);
        }
        throw new FHIRException("Unable to understand ollama's response json: see " + Utilities.path((String[])new String[]{"[tmp]", "fhir-validator-ollama-response.json"}));
    }

    public CodeAndTextValidationResult parseItem(CodeAndTextValidationRequest request, JsonObject o) {
        return new CodeAndTextValidationResult(request, o.asBoolean("isCompatible"), o.asString("explanation"), o.asString("confidence"));
    }
}

