/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.service.utils.ValidationLevel;

public class ValidatorSettings
extends ValidationOptions {
    private ValidationMessage.Source source;
    private ValidationLevel level = ValidationLevel.HINTS;
    private Coding jurisdiction;
    private boolean allowExamples;
    private boolean forPublication;
    private boolean debug;
    private boolean warnOnDraftOrExperimental;
    private BestPracticeWarningLevel bpWarnings = BestPracticeWarningLevel.Warning;
    private List<UsageContext> usageContexts = new ArrayList<UsageContext>();
    private boolean assumeValidRestReferences;

    public ValidationMessage.Source getSource() {
        return this.source;
    }

    public void setSource(ValidationMessage.Source source) {
        this.source = source;
    }

    public ValidationLevel getLevel() {
        return this.level;
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public Coding getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(Coding jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public boolean isAllowExamples() {
        return this.allowExamples;
    }

    public void setAllowExamples(boolean allowExamples) {
        this.allowExamples = allowExamples;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public void setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        if (forPublication) {
            this.warnOnDraftOrExperimental = true;
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isWarnOnDraftOrExperimental() {
        return this.warnOnDraftOrExperimental;
    }

    public void setWarnOnDraftOrExperimental(boolean warnOnDraftOrExperimental) {
        this.warnOnDraftOrExperimental = warnOnDraftOrExperimental;
    }

    public BestPracticeWarningLevel getBpWarnings() {
        return this.bpWarnings;
    }

    public void setBpWarnings(BestPracticeWarningLevel value) {
        this.bpWarnings = value == null ? BestPracticeWarningLevel.Warning : value;
    }

    public List<UsageContext> getUsageContexts() {
        return this.usageContexts;
    }
}

