/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.test.utils.CompareUtilities;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.network.ClientHeaders;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtil;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.validation.special.TxTestData;
import org.hl7.fhir.validation.special.TxTesterScrubbers;
import org.hl7.fhir.validation.special.TxTesterSorters;

public class TxTester {
    private String server;
    private List<ITxTesterLoader> loaders = new ArrayList<ITxTesterLoader>();
    private String error;
    private String outputDir;
    private ITerminologyClient terminologyClient;
    private boolean tight;
    private JsonObject externals;
    private String software;
    private List<String> fails = new ArrayList<String>();
    private CapabilityStatement cstmt;
    private TerminologyCapabilities tc;
    private TxTesterConversionLogger conversionLogger;
    private TestReport testReport;

    public TxTester(ITxTesterLoader loader, String server, boolean tight, JsonObject externals) {
        this.server = server;
        this.loaders.add(loader);
        this.tight = tight;
        this.externals = externals;
        this.conversionLogger = new TxTesterConversionLogger();
        this.testReport = new TestReport();
    }

    public static void main(String[] args) throws Exception {
        new TxTester(new InternalTxLoader(args[0]), args[1], "true".equals(args[2]), args.length == 5 ? org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromFile((String)args[4]) : null).execute(new HashSet<String>(), args[3]);
    }

    public void addLoader(ITxTesterLoader loader) {
        this.loaders.add(loader);
    }

    public boolean execute(Set<String> modes, String filter) throws IOException, URISyntaxException {
        if (this.outputDir == null) {
            this.outputDir = Utilities.path((String[])new String[]{"[tmp]", this.serverId()});
        }
        System.out.println("Run terminology service Tests");
        System.out.println("  Source for tests: " + this.loaders.get(0).describe());
        for (ITxTesterLoader loader : this.loaders) {
            if (loader == this.loaders.get(0)) continue;
            System.out.println("  Additional Tests: " + loader.describe());
        }
        System.out.println("  Output Directory: " + this.outputDir);
        if (!ManagedFileAccess.file((String)this.outputDir).exists()) {
            FileUtilities.createDirectory((String)this.outputDir);
        }
        if (!ManagedFileAccess.file((String)this.outputDir).exists()) {
            throw new IOException("Unable to create output directory " + this.outputDir);
        }
        System.out.println("  Term Service Url: " + this.server);
        this.testReport.addParticipant().setType(TestReport.TestReportParticipantType.SERVER).setUri(this.server);
        System.out.println("  External Strings: " + (this.externals != null));
        System.out.println("  Test  Exec Modes: " + modes.toString());
        if (filter != null) {
            System.out.println("  Filter Parameter: " + filter);
        }
        IntHolder counter = new IntHolder();
        IntHolder errCount = new IntHolder();
        JsonObject json = new JsonObject();
        ArrayList<StringPair> versions = new ArrayList<StringPair>();
        json.add("date", new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(Calendar.getInstance().getTime()) + this.timezone());
        try {
            this.terminologyClient = this.connectToServer(modes);
            boolean ok = this.checkClient();
            for (ITxTesterLoader loader : this.loaders) {
                JsonObject tests = this.loadTests(loader);
                this.readTests(tests, loader.version());
                versions.add(new StringPair(loader.code(), loader.version()));
                for (JsonObject suite : tests.getJsonObjects("suites")) {
                    if (suite.has("mode") && !modes.contains(suite.asString("mode")) || suite.asBoolean("disabled")) continue;
                    ok = this.runSuite(loader, suite, modes, filter, json.forceArray("suites"), counter, errCount) && ok;
                }
            }
            FileUtilities.stringToFile((String)org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)json, (boolean)true), (String)Utilities.path((String[])new String[]{this.outputDir, "test-results.json"}));
            int c = counter.total() * 100;
            int e = errCount.total() * 100;
            double s = counter.total() == 0 ? 0.0 : (double)((c - e) / counter.total());
            this.testReport.setScore(s / 100.0);
            this.testReport.setResult(errCount.total() == 0 ? TestReport.TestReportResult.PASS : TestReport.TestReportResult.FAIL);
            if (filter == null) {
                String m;
                String string = m = modes.isEmpty() ? "[none]" : CommaSeparatedStringBuilder.join((String)"+", modes);
                if (ok) {
                    System.out.println(this.software + " passed all " + counter.total() + " HL7 terminology service tests (" + Utilities.pluralize((String)"mode", (int)modes.size()) + " " + m + ", tests v" + this.vString(versions) + ", runner v" + VersionUtil.getBaseVersion() + ")");
                    return true;
                }
                System.out.println(this.software + " failed " + errCount.total() + " of " + counter.total() + " HL7 terminology service tests (" + Utilities.pluralize((String)"mode", (int)modes.size()) + " " + m + ", tests v" + this.vString(versions) + ", runner v" + VersionUtil.getBaseVersion() + ")");
                System.out.println("Failed Tests: " + CommaSeparatedStringBuilder.join((String)",", this.fails));
                return false;
            }
            System.out.println(this.software + " " + (ok ? "Passed the tests" : "did not pass the tests") + " '" + filter + "'");
            return ok;
        }
        catch (Exception e) {
            System.out.println("Exception running Terminology Service Tests: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void readTests(JsonObject tests, String version) {
        this.testReport.setName("TxEcosystemTests");
        this.testReport.setTestScript("http://hl7.org/fhir/uv/tx-ecosystem/TestCases/tx-ecosystem-test-cases|" + version);
        this.testReport.setTester("HL7 Ecosystem Test Runner v" + VersionUtil.getBaseVersion());
        this.testReport.setStatus(TestReport.TestReportStatus.COMPLETED);
    }

    private TestReport.TestReportTestComponent getTestReportTest(JsonObject suite, JsonObject test) {
        TestReport.TestReportTestComponent t = this.testReport.addTest();
        t.setName(suite.asString("name") + "/" + test.asString("name"));
        t.getActionFirstRep().getOperation().setResult(TestReport.TestReportActionResult.SKIP);
        return t;
    }

    private String vString(List<StringPair> versions) {
        StringBuilder b = new StringBuilder();
        b.append(versions.get(0).getValue());
        if (versions.size() > 1) {
            b.append("[");
            for (int i = 1; i < versions.size(); ++i) {
                if (i > 1) {
                    b.append(",");
                }
                b.append(versions.get(i).getName());
                b.append(":");
                b.append(versions.get(i).getValue());
            }
            b.append("]");
        }
        return b.toString();
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        Object offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + (String)offset;
        return offset;
    }

    private boolean checkClient() {
        this.conversionLogger.suiteName = "connect";
        this.conversionLogger.testName = "checkClient";
        this.cstmt = this.terminologyClient.getCapabilitiesStatement();
        if (this.cstmt.hasSoftware()) {
            this.software = this.cstmt.getSoftware().getName() + " v" + this.cstmt.getSoftware().getVersion();
            this.testReport.getParticipantFirstRep().setDisplay(this.software);
        }
        this.tc = this.terminologyClient.getTerminologyCapabilities();
        return true;
    }

    private JsonObject loadTests(ITxTesterLoader loader) throws JsonException, IOException {
        System.out.println("Load Tests from " + loader.describe());
        return org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((byte[])loader.loadContent(loader.testFileName()));
    }

    private ITerminologyClient connectToServer(Set<String> modes) throws URISyntaxException, IOException {
        System.out.println("Connect to " + this.server);
        this.software = this.server;
        if (this.outputDir == null) {
            this.outputDir = Utilities.path((String[])new String[]{"[tmp]", this.serverId()});
        }
        String fhirVersion = null;
        try {
            JsonObject vl = org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromUrl((String)Utilities.pathURL((String[])new String[]{this.server, "$versions", "?_format=json"}));
            if ("Parameters".equals(vl.asString("resourceType"))) {
                for (JsonObject v : vl.forceArray("parameter").asJsonObjects()) {
                    if (!"default".equals(v.asString("name"))) continue;
                    fhirVersion = v.asString("valueString");
                }
            } else if (vl.has("default")) {
                fhirVersion = vl.asString("default");
            } else {
                System.out.println("Unable to interpret response from $versions: " + vl.toString());
            }
            if (fhirVersion != null) {
                System.out.println("Server version " + fhirVersion + " from $versions");
            }
        }
        catch (Exception e) {
            System.out.println("Server does not support $versions: " + e.getMessage());
        }
        if (fhirVersion == null) {
            try {
                JsonObject cs = org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromUrl((String)Utilities.pathURL((String[])new String[]{this.server, "metadata", "?_format=json"}));
                fhirVersion = cs.asString("fhirVersion");
                System.out.println("Server version " + fhirVersion + " from /metadata");
            }
            catch (Exception e) {
                System.out.println("Error checking server version: " + e.getMessage());
                System.out.println("Defaulting to FHIR R4");
                fhirVersion = "4.0";
            }
        }
        ITerminologyClient client = null;
        if (VersionUtilities.isR5Plus(fhirVersion)) {
            client = new TerminologyClientFactory(FhirPublication.R5).makeClient("Test-Server", this.server, "Tools/Java", null);
        } else if (VersionUtilities.isR4Plus(fhirVersion)) {
            FileUtilities.createDirectory((String)Utilities.path((String[])new String[]{this.outputDir, "conversions", "r4"}));
            FileUtilities.createDirectory((String)Utilities.path((String[])new String[]{this.outputDir, "conversions", "r5"}));
            client = new TerminologyClientFactory(FhirPublication.R4).makeClient("Test-Server", this.server, "Tools/Java", null);
            client.setConversionLogger((ITerminologyClient.ITerminologyConversionLogger)this.conversionLogger);
        } else {
            throw new FHIRException("unsupported FHIR Version for terminology tests: " + fhirVersion);
        }
        return client;
    }

    public String executeTest(ITxTesterLoader loader, JsonObject suite, JsonObject test, Set<String> modes) throws URISyntaxException, FHIRFormatError, FileNotFoundException, IOException {
        TestReport.TestReportTestComponent tr;
        List<Resource> setup;
        this.error = null;
        if (this.terminologyClient == null) {
            this.terminologyClient = this.connectToServer(modes);
            this.checkClient();
        }
        if (this.runTest(loader, suite, test, setup = this.loadSetupResources(loader, suite), modes, "*", null, new IntHolder(), tr = this.getTestReportTest(suite, test))) {
            return null;
        }
        return this.error;
    }

    private boolean runSuite(ITxTesterLoader loader, JsonObject suite, Set<String> modes, String filter, JsonArray output, IntHolder counter, IntHolder errCount) throws FHIRFormatError, FileNotFoundException, IOException {
        System.out.println("Group " + suite.asString("name"));
        JsonObject outputS = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputS);
        }
        outputS.add("name", suite.asString("name"));
        List<Resource> setup = this.loadSetupResources(loader, suite);
        boolean ok = true;
        for (JsonObject test : suite.getJsonObjects("tests")) {
            TestReport.TestReportTestComponent tr = this.getTestReportTest(suite, test);
            if (test.has("mode") && !modes.contains(test.asString("mode"))) continue;
            if (test.asBoolean("disabled")) {
                ok = true;
                continue;
            }
            boolean tok = this.runTest(loader, suite, test, setup, modes, filter, outputS.forceArray("tests"), counter, tr);
            if (!tok) {
                errCount.count();
            }
            ok = tok && ok;
        }
        return ok;
    }

    private boolean runTest(ITxTesterLoader loader, JsonObject suite, JsonObject test, List<Resource> setup, Set<String> modes, String filter, JsonArray output, IntHolder counter, TestReport.TestReportTestComponent tr) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        JsonObject outputT = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputT);
        }
        long start = System.currentTimeMillis();
        Parameters profile = this.loadProfile(loader, test);
        outputT.add("name", test.asString("name"));
        if (Utilities.noString((String)filter) || filter.equals("*") || test.asString("name").contains(filter)) {
            System.out.print("  Test " + test.asString("name") + ": ");
            HTTPHeader header = null;
            try {
                JsonObject hdr;
                counter.count();
                if (test.has("header") && (hdr = test.getJsonObject("header")).has("mode") && modes.contains(hdr.asString("mode"))) {
                    header = new HTTPHeader(hdr.asString("name"), hdr.asString("value"));
                    this.terminologyClient.setClientHeaders(new ClientHeaders(List.of(header)));
                }
                this.conversionLogger.suiteName = suite.asString("name");
                this.conversionLogger.testName = test.asString("name");
                String reqFile = this.chooseParam(test, "request", modes);
                Parameters req = reqFile == null ? null : (Parameters)loader.loadResource(reqFile);
                String fn = this.chooseParam(test, "response", modes);
                String resp = FileUtilities.bytesToString((byte[])loader.loadContent(fn));
                String fp = this.outputDir == null ? Utilities.path((String[])new String[]{"[tmp]", this.serverId(), fn}) : Utilities.path((String[])new String[]{this.outputDir, fn});
                File fo = ManagedFileAccess.file((String)fp);
                if (fo.exists()) {
                    fo.delete();
                }
                JsonObject ext = this.externals == null ? null : this.externals.getJsonObject(fn);
                String lang = test.asString("Accept-Language");
                String msg = null;
                if (test.asString("operation").equals("metadata")) {
                    msg = this.metadata(test.str("name"), setup, resp, fp, lang, profile, ext, modes);
                } else if (test.asString("operation").equals("term-caps")) {
                    msg = this.termcaps(test.str("name"), setup, resp, fp, lang, profile, ext, modes);
                } else if (test.asString("operation").equals("expand")) {
                    msg = this.expand(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test), modes);
                } else if (test.asString("operation").equals("validate-code")) {
                    msg = this.validate(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test), modes);
                } else if (test.asString("operation").equals("cs-validate-code")) {
                    msg = this.validateCS(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test), modes);
                } else if (test.asString("operation").equals("lookup")) {
                    msg = this.lookup(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test), modes);
                } else if (test.asString("operation").equals("translate")) {
                    msg = this.translate(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test), modes);
                } else {
                    throw new Exception("Unknown Operation " + test.asString("operation"));
                }
                System.out.println((msg == null ? "Pass" : "Fail") + " (" + Utilities.describeDuration((long)(System.currentTimeMillis() - start)) + ")");
                if (msg != null) {
                    System.out.println("    " + msg);
                    this.error = msg;
                    this.fails.add(suite.asString("name") + "/" + test.asString("name"));
                }
                outputT.add("status", msg == null ? "pass" : "fail");
                if (msg != null) {
                    outputT.add("message", msg);
                }
                if (header != null) {
                    this.terminologyClient.setClientHeaders(new ClientHeaders());
                }
                tr.getActionFirstRep().getOperation().setResult(msg == null ? TestReport.TestReportActionResult.PASS : TestReport.TestReportActionResult.FAIL).setMessage(msg);
                return msg == null;
            }
            catch (Exception e) {
                System.out.println("  ... Exception: " + e.getMessage());
                System.out.print("    ");
                this.fails.add(suite.asString("name") + "/" + test.asString("name"));
                this.error = e.getMessage();
                e.printStackTrace();
                if (header != null) {
                    this.terminologyClient.setClientHeaders(new ClientHeaders());
                }
                tr.getActionFirstRep().getOperation().setResult(TestReport.TestReportActionResult.ERROR).setMessage(e.getMessage());
                return false;
            }
        }
        outputT.add("status", "ignored");
        tr.getActionFirstRep().getOperation().setResult(TestReport.TestReportActionResult.SKIP);
        return true;
    }

    private String metadata(String id, List<Resource> setup, String resp, String fp, String lang, Parameters profile, JsonObject ext, Set<String> modes) throws IOException {
        CapabilityStatement cs = this.cstmt.copy();
        TxTesterScrubbers.scrubCapStmt(cs, this.tight);
        TxTesterSorters.sortCapStmt(cs);
        String csj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)cs);
        String diff = new CompareUtilities(modes, ext, this.vars()).setPatternMode(true).checkJsonSrcIsSame(id, resp, csj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)csj, (String)fp);
        }
        return diff;
    }

    private String termcaps(String id, List<Resource> setup, String resp, String fp, String lang, Parameters profile, JsonObject ext, Set<String> modes) throws IOException {
        TerminologyCapabilities cs = this.tc.copy();
        TxTesterScrubbers.scrubTermCaps(cs, this.tight);
        TxTesterSorters.sortTermCaps(cs);
        String csj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)cs);
        String diff = new CompareUtilities(modes, ext, this.vars()).setPatternMode(true).checkJsonSrcIsSame(id, resp, csj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)csj, (String)fp);
        }
        return diff;
    }

    private String getResponseCode(JsonObject test) {
        if (test.has("http-code")) {
            return test.asString("http-code");
        }
        return "2xx";
    }

    private String chooseParam(JsonObject test, String name, Set<String> modes) {
        for (String mode : modes) {
            if (!test.has(name + ":" + mode)) continue;
            return test.asString(name + ":" + mode);
        }
        return test.asString(name);
    }

    private Parameters loadProfile(ITxTesterLoader loader, JsonObject test) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        if (test.has("profile")) {
            return (Parameters)loader.loadResource(test.asString("profile"));
        }
        return (Parameters)loader.loadResource("parameters-default.json");
    }

    private String serverId() throws URISyntaxException {
        return new URI(this.server).getHost();
    }

    private String lookup(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode, Set<String> modes) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setAcceptLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            Parameters po = this.terminologyClient.lookupCode(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(modes, ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String translate(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode, Set<String> modes) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setAcceptLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            Parameters po = this.terminologyClient.translate(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(modes, ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String expand(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode, Set<String> modes) throws IOException {
        String vsj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setAcceptLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            ValueSet vs = this.terminologyClient.expandValueset(null, p);
            TxTesterScrubbers.scrubVS(vs, this.tight);
            TxTesterSorters.sortValueSet(vs);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)vs);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(modes, ext, this.vars()).checkJsonSrcIsSame(id, resp, vsj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)vsj, (String)fp);
        }
        return diff;
    }

    private boolean httpCodeOk(String tcode, int code) {
        switch (tcode) {
            case "2xx": {
                return code >= 200 && code < 300;
            }
            case "3xx": {
                return code >= 300 && code < 400;
            }
            case "4xx": {
                return code >= 400 && code < 500;
            }
            case "5xx": {
                return code >= 500 && code < 600;
            }
        }
        throw new Error("unknown code string " + tcode);
    }

    private String validate(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode, Set<String> modes) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        this.terminologyClient.setAcceptLanguage(lang);
        int code = 0;
        try {
            Parameters po = this.terminologyClient.validateVS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(modes, ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String validateCS(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode, Set<String> modes) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        this.terminologyClient.setAcceptLanguage(lang);
        int code = 0;
        try {
            Parameters po = this.terminologyClient.validateCS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(modes, ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            FileUtilities.createDirectory((String)FileUtilities.getDirectoryForFile((String)fp));
            FileUtilities.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private Map<String, String> vars() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("version", this.terminologyClient.getActualVersion().toCode());
        return vars;
    }

    private List<Resource> loadSetupResources(ITxTesterLoader loader, JsonObject suite) throws FHIRFormatError, FileNotFoundException, IOException {
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (String s : suite.getStrings("setup")) {
            res.add(loader.loadResource(s));
        }
        return res;
    }

    public String getOutput() {
        return this.outputDir;
    }

    public TxTester setOutput(String output) {
        this.outputDir = output;
        return this;
    }

    public TestReport getTestReport() {
        return this.testReport;
    }

    private class TxTesterConversionLogger
    implements ITerminologyClient.ITerminologyConversionLogger {
        public String suiteName;
        public String testName;

        private TxTesterConversionLogger() {
        }

        public void log(String name, String resourceType, String version, byte[] cnt) {
            if (!"expandValueset.response".equals(name)) {
                return;
            }
            try {
                String base = Utilities.path((String[])new String[]{TxTester.this.outputDir, "conversions"});
                if (ManagedFileAccess.file((String)base).exists()) {
                    String dir = Utilities.path((String[])new String[]{base, version, this.suiteName});
                    FileUtilities.createDirectory((String)dir);
                    String filename = Utilities.path((String[])new String[]{dir, this.testName + "." + resourceType + ".json"});
                    FileUtilities.bytesToFile((byte[])cnt, (String)filename);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class InternalTxLoader
    implements ITxTesterLoader {
        private TxTestData txtests;
        private boolean additional;

        public InternalTxLoader(String version) throws IOException {
            File f = ManagedFileAccess.file((String)version);
            if (f.exists() && f.isDirectory()) {
                this.txtests = TxTestData.loadTestDataFromFolder(f, "test-cases.json");
            } else {
                this.load(version);
            }
        }

        public InternalTxLoader(String source, boolean additional) throws IOException {
            this.additional = additional;
            File f = ManagedFileAccess.file((String)source);
            if (f.exists() && f.isDirectory()) {
                this.txtests = TxTestData.loadTestDataFromFolder(f, "test-cases.json");
            } else if (f.exists()) {
                this.txtests = TxTestData.loadTestDataFromFolder(ManagedFileAccess.file((String)FileUtilities.getDirectoryForFile((String)source)), f.getName());
            } else {
                this.load(source);
            }
        }

        private void load(String version) throws IOException {
            this.txtests = TxTestData.loadTestDataFromPackage("hl7.fhir.uv.tx-ecosystem#" + version);
        }

        @Override
        public String describe() {
            return this.txtests.describe();
        }

        @Override
        public Resource loadResource(String filename) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException {
            Resource res = new JsonParser().parse(this.txtests.load(filename));
            return res;
        }

        @Override
        public byte[] loadContent(String filename) throws FileNotFoundException, IOException {
            return this.txtests.loadBytes(filename);
        }

        @Override
        public boolean hasContent(String filename) throws IOException {
            return this.txtests.hasFile(filename);
        }

        @Override
        public String code() {
            return this.txtests.code();
        }

        @Override
        public String version() throws JsonException, IOException {
            return this.txtests.loadVersion();
        }

        @Override
        public String testFileName() {
            return this.txtests.testFileName();
        }
    }

    public static interface ITxTesterLoader {
        public String describe();

        public Resource loadResource(String var1) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException;

        public byte[] loadContent(String var1) throws FileNotFoundException, IOException;

        public boolean hasContent(String var1) throws IOException;

        public String code();

        public String version() throws JsonException, IOException;

        public String testFileName();
    }

    public class IntHolder {
        private int count;

        public void count() {
            ++this.count;
        }

        public int total() {
            return this.count;
        }
    }
}

