/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hl7.fhir.convertors.loaders.loaderR5.BaseLoaderR5;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceFactory;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.utils.structuremap.ResolvedGroup;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.instance.InstanceValidator;

public class R4R5MapTester
implements IValidatorResourceFetcher {
    private boolean saveProcess = true;
    private SimpleWorkerContext context;
    private FilesystemPackageCacheManager pcm;
    private StructureMapUtilities utils;
    private List<StructureMap> allMaps;
    private InstanceValidator validator;
    private StringBuilder log;

    public static void main(String[] args) throws JsonException, IOException {
        new R4R5MapTester().testMaps(args[0], args[1], args[2]);
    }

    public void testMaps(String src, String maps, String filter) throws JsonException, IOException {
        this.log = new StringBuilder();
        this.log("Load Test Outcomes");
        JsonObject json = org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromFile((String)Utilities.path((String[])new String[]{src, "input", "_data", "conversions.json"}));
        this.log("Load R5");
        this.pcm = new FilesystemPackageCacheManager.Builder().build();
        this.context = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(this.pcm.loadPackage("hl7.fhir.r5.core#current"));
        this.log("Load Maps");
        this.loadPackage("hl7.terminology.r5#5.0.0", false);
        this.utils = new StructureMapUtilities((IWorkerContext)this.context);
        this.utils.setDebug(false);
        this.loadPackage("hl7.fhir.uv.extensions#dev", maps == null);
        if (maps != null) {
            this.loadFromFolder(Utilities.path((String[])new String[]{maps, "r4-2-r5"}));
            this.loadFromFolder(Utilities.path((String[])new String[]{maps, "r4b-2-r5"}));
            this.loadFromFolder(Utilities.path((String[])new String[]{maps, "r5-2-r4"}));
            this.loadFromFolder(Utilities.path((String[])new String[]{maps, "r5-2-r4b"}));
        }
        this.loadPackage("hl7.fhir.r4.core#4.0.1", false);
        this.loadPackage("hl7.fhir.r4b.core#4.3.0", false);
        this.validator = new InstanceValidator((IWorkerContext)this.context, null, null, null, new ValidatorSettings());
        this.validator.setSuppressLoincSnomedMessages(true);
        this.validator.setResourceIdRule(IdStatus.REQUIRED);
        this.validator.setBestPracticeWarningLevel(BestPracticeWarningLevel.Warning);
        this.validator.getExtensionDomains().add("http://hl7.org/fhir/us");
        this.validator.setFetcher(this);
        this.validator.setAllowExamples(true);
        this.validator.getSettings().setDebug(false);
        this.validator.setForPublication(true);
        this.validator.setNoTerminologyChecks(true);
        this.context.setExpansionParameters(new Parameters());
        this.log("Load R4 Examples");
        NpmPackage r4Examples = this.pcm.loadPackage("hl7.fhir.r4.examples");
        this.log("Load R4B Examples");
        NpmPackage r4bExamples = this.pcm.loadPackage("hl7.fhir.r4b.examples");
        this.allMaps = this.context.fetchResourcesByType(StructureMap.class);
        this.log("Go. " + this.context.getResourceNames().size() + " types of resources");
        this.log("Map Count = " + this.allMaps.size());
        boolean changed = false;
        for (JsonProperty jp : json.getProperties()) {
            String rn = jp.getName();
            if (!"*".equals(filter) && !rn.equals(filter)) continue;
            this.log("  " + rn);
            JsonObject o = json.getJsonObject(rn);
            StructureDefinition sd = this.context.fetchTypeDefinition(rn);
            if (sd != null) {
                List mapSrc = this.utils.getMapsForUrl(this.allMaps, sd.getUrl(), StructureMap.StructureMapInputMode.SOURCE);
                List mapTgt = this.utils.getMapsForUrl(this.allMaps, sd.getUrl(), StructureMap.StructureMapInputMode.TARGET);
                changed = this.checkMaps(sd, o.getJsonObject("r4"), "r4", "http://hl7.org/fhir/4.0", mapSrc, mapTgt, r4Examples) || changed;
                changed = this.checkMaps(sd, o.getJsonObject("r4b"), "r4b", "http://hl7.org/fhir/4.3", mapSrc, mapTgt, r4bExamples) || changed;
                org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)json, (OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{src, "input", "_data", "conversions.json"})), (boolean)true);
            }
            System.out.println("   .. done");
        }
        FileUtilities.stringToFile((String)this.log.toString(), (String)Utilities.path((String[])new String[]{src, "input", "_data", "validation.log"}));
        this.log("Done!");
    }

    private void loadFromFolder(String path) throws FHIRFormatError, FHIRException, FileNotFoundException, IOException {
        this.log("Load " + path);
        for (File f : ManagedFileAccess.file((String)path).listFiles()) {
            if (f.getName().endsWith(".json")) {
                this.context.cacheResource(new JsonParser().parse((InputStream)ManagedFileAccess.inStream((File)f)));
            }
            if (!f.getName().endsWith(".fml")) continue;
            this.context.cacheResource((Resource)this.utils.parse(FileUtilities.fileToString((File)f), f.getName()));
        }
    }

    private void loadPackage(String pid, boolean loadMaps) throws FHIRException, IOException {
        this.log("Load " + pid);
        NpmPackage npm = this.pcm.loadPackage(pid);
        BaseLoaderR5 loader = ValidatorUtils.loaderForVersion(npm.fhirVersion());
        if (!loadMaps && loader.getTypes().contains("StructureMap")) {
            loader.getTypes().remove("StructureMap");
        }
        loader.setPatchUrls(VersionUtilities.isCorePackage((String)npm.id()));
        this.context.loadFromPackage(npm, (IContextResourceLoader)loader);
    }

    private boolean checkMaps(StructureDefinition sd, JsonObject json, String code, String ns, List<StructureMap> mapSrc, List<StructureMap> mapTgt, NpmPackage examples) throws IOException {
        List src = this.utils.getMapsForUrlPrefix(mapSrc, ns, StructureMap.StructureMapInputMode.TARGET);
        List tgt = this.utils.getMapsForUrlPrefix(mapTgt, ns, StructureMap.StructureMapInputMode.SOURCE);
        if (src.size() + tgt.size() == 0) {
            json.set("status", "No Maps Defined");
            json.set("testColor", "#dddddd");
            json.set("testMessage", "--");
        } else {
            boolean isDraft = false;
            for (StructureMap map : src) {
                isDraft = map.getStatus() == Enumerations.PublicationStatus.DRAFT || isDraft;
            }
            for (StructureMap map : tgt) {
                isDraft = map.getStatus() == Enumerations.PublicationStatus.DRAFT || isDraft;
            }
            json.set("status", src.size() + tgt.size() + " Maps Defined" + (isDraft ? " (draft)" : ""));
            json.set("testColor", "#ffcccc");
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                if (tgt.size() == 1 && src.size() == 1) {
                    StructureMap tgtM = (StructureMap)tgt.get(0);
                    ResolvedGroup tgtG = this.utils.getGroupForUrl(tgtM, sd.getUrl(), StructureMap.StructureMapInputMode.TARGET);
                    String tgtU = this.utils.getInputType(tgtG, StructureMap.StructureMapInputMode.SOURCE);
                    assert (tgtU.startsWith(ns));
                    StructureMap srcM = (StructureMap)src.get(0);
                    ResolvedGroup srcG = this.utils.getGroupForUrl(srcM, sd.getUrl(), StructureMap.StructureMapInputMode.SOURCE);
                    String srcU = this.utils.getInputType(srcG, StructureMap.StructureMapInputMode.TARGET);
                    assert (srcU.startsWith(ns));
                    if (!srcU.equals(tgtU)) {
                        json.set("testMessage", "Maps do not round trip to same resource (" + Utilities.tail((String)srcU) + " -> " + Utilities.tail((String)tgtU) + ") - can't test");
                    } else {
                        StructureDefinition tsd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, srcU);
                        if (tsd == null) {
                            json.set("testMessage", "Undefined type " + srcU);
                        } else {
                            this.testRoundTrips(sd, json, tgtG, srcG, tsd, examples, code);
                        }
                    }
                } else {
                    json.set("testMessage", "Multiple matching maps (" + src.size() + "/" + tgt.size() + ") - no tests performed");
                }
            } else {
                json.set("testColor", "#eeeeee");
                json.set("testMessage", "n/a");
            }
        }
        return true;
    }

    private void testRoundTrips(StructureDefinition sd, JsonObject json, ResolvedGroup tgtG, ResolvedGroup srcG, StructureDefinition tsd, NpmPackage examples, String code) throws IOException {
        Stats stats = new Stats();
        for (String s : examples.listResources(new String[]{tsd.getType()})) {
            this.log("  Test " + examples.id() + "::" + s, false);
            try {
                this.log("  " + this.testRoundTrip(json, sd, tsd, tgtG, srcG, stats, examples.load("package", s), code) + "%");
            }
            catch (Exception e) {
                this.log("error: " + e.getMessage());
                e.printStackTrace();
                stats.error("Error: " + e.getMessage());
            }
        }
        json.set("totalInstances", stats.totalCount());
        json.set("parsedOk", stats.parseCount());
        json.set("convertToR5OK", stats.forwardCount());
        json.set("testMessage", stats.summary());
        json.set("r5validated", stats.validatedCount());
        json.set("r5InError", stats.errorCount());
        json.remove("r5validatedOK");
        json.set("convertToR4OK", stats.backCount());
        json.set("elementsConverted", stats.elementsCount());
        if (stats.elementsCount() > 0) {
            json.set("elementsLost", stats.lostCount() * 100 / stats.elementsCount());
        } else {
            json.set("elementsLost", 0);
        }
        if (stats.ok()) {
            json.set("testColor", "#d4ffdf");
        }
    }

    private int testRoundTrip(JsonObject json, StructureDefinition sd, StructureDefinition tsd, ResolvedGroup tgtG, ResolvedGroup srcG, Stats stats, InputStream stream, String code) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        stats.example();
        Element r4 = new org.hl7.fhir.r5.elementmodel.JsonParser((IWorkerContext)this.context).setLogical(tsd).parseSingle(stream, null);
        stats.parsed();
        int elementCountBefore = r4.countDescendents() + 1;
        String id = r4.getIdBase();
        json.remove(id);
        this.checkSave(id + "." + code, "loaded", r4);
        Resource r5 = null;
        try {
            r5 = ResourceFactory.createResource((String)sd.getType());
            this.utils.transform((Object)this.context, (Base)r4, tgtG.getTargetMap(), (Base)r5);
            stats.forward();
            this.checkSave(id + "." + code, "converted", r5);
        }
        catch (Exception e) {
            json.forceObject(id).set("conversion-error", e.getMessage());
            throw e;
        }
        try {
            ArrayList<ValidationMessage> r5validationErrors = new ArrayList<ValidationMessage>();
            this.validator.validate(null, r5validationErrors, r5);
            boolean valid = true;
            for (ValidationMessage vm : r5validationErrors) {
                if (!vm.isError()) continue;
                this.log.append(vm.summary());
                this.log.append("\r\n");
                valid = false;
            }
            if (valid) {
                this.log.append("All OK\r\n");
            }
            this.log.append("\r\n");
            stats.valid(valid);
        }
        catch (Exception e) {
            json.forceObject(id).set("validation-error", e.getMessage());
            throw e;
        }
        Element rt4 = null;
        try {
            rt4 = Manager.build((IWorkerContext)this.context, (StructureDefinition)tsd);
            this.utils.transform((Object)this.context, (Base)r5, srcG.getTargetMap(), (Base)rt4);
            stats.back();
            this.checkSave(id + "." + code, "returned", r4);
        }
        catch (Exception e) {
            json.forceObject(id).set("return-error", e.getMessage());
            throw e;
        }
        int elementCountAfter = rt4.countDescendents() + 1;
        stats.elements(elementCountBefore);
        stats.lost(elementCountBefore - elementCountAfter);
        return elementCountAfter * 100 / elementCountBefore;
    }

    private void checkSave(String id, String state, Element e) throws FHIRException, FileNotFoundException, IOException {
        if (this.saveProcess) {
            new org.hl7.fhir.r5.elementmodel.JsonParser((IWorkerContext)this.context).compose(e, (OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{"[tmp]", "r4r5", e.fhirType() + "-" + id + "-" + state + ".json"})), IParser.OutputStyle.PRETTY, id);
        }
    }

    private void checkSave(String id, String state, Resource r) throws FHIRException, FileNotFoundException, IOException {
        if (this.saveProcess) {
            new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{"[tmp]", "r4r5", r.fhirType() + "-" + id + "-" + state + ".json"})), r);
        }
    }

    private void log(String msg) {
        this.log(msg, true);
    }

    private void log(String msg, boolean ln) {
        this.log.append(msg + "\r\n");
        if (ln) {
            System.out.println(msg);
        } else {
            System.out.print(msg + " ");
        }
    }

    public Element fetch(IResourceValidator validator, Object appContext, String url) throws FHIRException, IOException {
        return null;
    }

    public boolean resolveURL(IResourceValidator validator, Object appContext, String path, String url, String type, boolean canonical, List<CanonicalType> targets) throws IOException, FHIRException {
        return true;
    }

    public byte[] fetchRaw(IResourceValidator validator, String url) throws IOException {
        throw new Error("Not done yet");
    }

    public IValidatorResourceFetcher setLocale(Locale locale) {
        throw new Error("Not done yet");
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator validator, Object appContext, String url) throws URISyntaxException {
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return false;
    }

    public Set<String> fetchCanonicalResourceVersions(IResourceValidator validator, Object appContext, String url) {
        return new HashSet<String>();
    }

    public class Stats {
        private Set<String> errors = new HashSet<String>();
        private int total;
        private int parsed;
        private int forward;
        private int validated;
        private int error;
        private int back;
        private int elements;
        private int lostElements;

        public void example() {
            ++this.total;
        }

        public void parsed() {
            ++this.parsed;
        }

        public void error(String s) {
            this.errors.add(s);
        }

        public void forward() {
            ++this.forward;
        }

        public int totalCount() {
            return this.total;
        }

        public int parseCount() {
            return this.parsed;
        }

        public int forwardCount() {
            return this.forward;
        }

        public int validatedCount() {
            return this.validated;
        }

        public int errorCount() {
            return this.error;
        }

        public int backCount() {
            return this.back;
        }

        public String summary() {
            if (this.errors.size() == 0) {
                return "All OK (~" + String.valueOf(this.elements == 0 ? "n/a" : Integer.valueOf(this.lostElements * 100 / this.elements)) + "% lost in " + this.total + " examples)";
            }
            return String.join((CharSequence)", ", this.errors);
        }

        public boolean ok() {
            return this.errors.size() == 0;
        }

        public void valid(boolean valid) {
            ++this.validated;
            if (!valid) {
                ++this.error;
            }
        }

        public void back() {
            ++this.back;
        }

        public void elements(int i) {
            this.elements += i;
        }

        public void lost(int i) {
            this.lostElements += i;
        }

        public int elementsCount() {
            return this.elements;
        }

        public int lostCount() {
            return this.lostElements;
        }
    }
}

