/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.renderers;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.validation.service.renderers.ValidationOutputRenderer;

public class CompactRenderer
extends ValidationOutputRenderer {
    private boolean split;
    private File dir;

    public CompactRenderer(boolean split) {
        this.split = split;
    }

    @Override
    public void render(OperationOutcome op) throws IOException {
        if (this.split) {
            File file = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{this.dir.getAbsolutePath(), FileUtilities.changeFileExt((String)this.tail(ToolingExtensions.readStringExtension((DomainResource)op, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file")), (String)".txt")}));
            if (op.isSuccess()) {
                if (file.exists()) {
                    file.delete();
                }
            } else {
                PrintStream dstF = new PrintStream(ManagedFileAccess.outStream((File)file));
                this.render(dstF, op);
                dstF.close();
            }
        } else {
            this.render(this.dst, op);
        }
    }

    private void render(PrintStream d, OperationOutcome op) throws IOException {
        if (this.split) {
            d.println(ManagedFileAccess.file((String)ToolingExtensions.readStringExtension((DomainResource)op, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file")).getName() + " " + this.getRunDate() + ":");
        } else {
            d.println();
            d.println("----------------------------------------------------------------------------------");
            d.println(ToolingExtensions.readStringExtension((DomainResource)op, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file") + " " + this.getRunDate());
        }
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : op.getIssue()) {
            String path = operationOutcomeIssueComponent.hasExpression() ? ((StringType)operationOutcomeIssueComponent.getExpression().get(0)).asStringValue() : "n/a";
            int line = ToolingExtensions.readIntegerExtension((Element)operationOutcomeIssueComponent, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)operationOutcomeIssueComponent, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            lines.add((CallSite)((Object)(Utilities.padLeft((String)Integer.toString(line), (char)'0', (int)8) + ":" + Utilities.padLeft((String)Integer.toString(col), (char)'0', (int)8) + ":" + path + "|[" + Integer.toString(line) + ", " + Integer.toString(col) + "] " + path + ": " + operationOutcomeIssueComponent.getSeverity().getDisplay() + " - " + operationOutcomeIssueComponent.getDetails().getText() + this.renderMessageId(operationOutcomeIssueComponent))));
        }
        Collections.sort(lines);
        for (String string : lines) {
            d.println(string.substring(string.indexOf("|") + 1));
        }
        if (!this.split) {
            d.println();
        }
    }

    private String tail(String n) {
        return n.contains(File.separator) ? n.substring(n.lastIndexOf(File.separator) + 1) : n;
    }

    @Override
    public boolean isSingleFile() {
        return !this.split;
    }

    @Override
    public String getStyleCode() {
        return this.split ? "compact-split" : "compact";
    }

    @Override
    public void setFolder(File dir) {
        this.dir = dir;
    }
}

