/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.instance.InstanceValidator;

public class ChildIterator {
    private final InstanceValidator instanceValidator;
    private String basePath;
    private Element parent;
    private int cursor;
    private int lastCount;

    public ChildIterator(InstanceValidator instanceValidator, String path, Element element) {
        this.instanceValidator = instanceValidator;
        this.parent = element;
        this.basePath = path;
        this.cursor = -1;
    }

    public InstanceValidator getInstanceValidator() {
        return this.instanceValidator;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ChildIterator setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Element getParent() {
        return this.parent;
    }

    public ChildIterator setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public int getCursor() {
        return this.cursor;
    }

    public ChildIterator setCursor(int cursor) {
        this.cursor = cursor;
        return this;
    }

    public int getLastCount() {
        return this.lastCount;
    }

    public ChildIterator setLastCount(int lastCount) {
        this.lastCount = lastCount;
        return this;
    }

    public Element element() {
        return (Element)this.parent.getChildren().get(this.cursor);
    }

    public String name() {
        return this.element().getName();
    }

    public int count() {
        String na;
        String nb = this.cursor == 0 ? "--" : ((Element)this.parent.getChildren().get(this.cursor - 1)).getName();
        String string = na = this.cursor >= this.parent.getChildren().size() - 1 ? "--" : ((Element)this.parent.getChildren().get(this.cursor + 1)).getName();
        if (this.name().equals(nb) || this.name().equals(na)) {
            return this.lastCount;
        }
        if (this.element().isBaseList()) {
            return 0;
        }
        return -1;
    }

    public boolean next() {
        if (this.cursor == -1) {
            ++this.cursor;
            this.lastCount = 0;
        } else {
            String lastName = this.name();
            ++this.cursor;
            this.lastCount = this.cursor < this.parent.getChildren().size() && this.name().equals(lastName) ? ++this.lastCount : 0;
        }
        return this.cursor < this.parent.getChildren().size();
    }

    public String path() {
        int i = this.count();
        Object sfx = "";
        String n = this.name();
        Object fn = "";
        if (this.element().getProperty().isChoice() && this.element().getProperty().getName().endsWith("[x]")) {
            String en = this.element().getProperty().getName();
            String t = n.substring((en = en.substring(0, en.length() - 3)).length());
            if (this.instanceValidator.isPrimitiveType(Utilities.uncapitalize((String)t))) {
                t = Utilities.uncapitalize((String)t);
            }
            n = en;
            fn = ".ofType(" + t + ")";
        }
        if (i > -1 || this.element().getSpecial() == null && this.element().isList()) {
            sfx = "[" + Integer.toString(this.lastCount) + "]";
        }
        return this.basePath + "." + n + (String)sfx + (String)fn;
    }
}

