/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageInfo;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ImplementationGuideValidator
extends BaseValidator {
    private static final int DATE_WARNING_CUTOFF = 3;

    public ImplementationGuideValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateImplementationGuide(ValidationContext valContext, List<ValidationMessage> errors, Element ig, NodeStack stack) {
        boolean ok = true;
        List el = ig.getChildren("fhirVersion");
        ArrayList<String> fvl = new ArrayList<String>();
        for (Element e : el) {
            String fver = e.primitiveValue();
            fvl.add(fver);
        }
        this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), !fvl.isEmpty(), "IG_NO_VERSION", new Object[0]);
        List dependencies = ig.getChildrenByName("dependsOn");
        int i = 0;
        for (Element dependency : dependencies) {
            ok = this.checkDependency(errors, ig, stack.push(dependency, i, null, null), dependency, fvl) && ok;
            ++i;
        }
        if (this.isHL7Org(ig)) {
            ok = this.rule(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"}), "IG_HL7_STANDARDS_STATUS_REQUIRED", new Object[0]) && ok;
            ok = this.rule(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"}), "IG_HL7_WG_REQUIRED", new Object[0]) && ok;
            this.warning(errors, "2025-02-13", ValidationMessage.IssueType.BUSINESSRULE, ig.line(), ig.col(), stack.getLiteralPath(), ig.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"}), "IG_HL7_FMM_SHOULD", new Object[0]);
        }
        return ok;
    }

    private boolean checkDependency(List<ValidationMessage> errors, Element ig, NodeStack stack, Element dependency, List<String> fvl) {
        boolean ok;
        block17: {
            ok = true;
            String url = dependency.getNamedChildValue("uri");
            String packageId = dependency.getNamedChildValue("packageId");
            String version = dependency.getNamedChildValue("version");
            if (url != null && url.contains("|")) {
                String uver = url.substring(url.indexOf("|") + 1);
                url = url.substring(0, url.indexOf("|"));
                if (Utilities.noString((String)uver)) {
                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_CAN_VERSION_NONE", uver) && ok;
                } else if (version == null) {
                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_CAN_VERSION_ALONE", uver) && ok;
                } else if (!uver.equals(version)) {
                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), url == null || url.contains("/ImplementationGuide/"), "IG_DEPENDENCY_CAN_VERSION_ERROR", uver, version) && ok;
                }
            }
            ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), url == null || url.contains("/ImplementationGuide/"), "IG_DEPENDENCY_DIRECT", url) && ok;
            ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId == null || packageId.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$"), "IG_DEPENDENCY_INVALID_PACKAGEID", packageId) && ok;
            try {
                String pver;
                ImplementationGuide fetchedIgDependency = (ImplementationGuide)this.context.fetchResource(ImplementationGuide.class, url);
                this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), fetchedIgDependency != null, "IG_DEPENDENCY_INVALID_URL", url);
                FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
                if (!(url == null || packageId == null || fetchedIgDependency != null && fetchedIgDependency.hasUserData("IG_FAKE"))) {
                    String pid = pcm.getPackageId(url);
                    String canonical = pcm.getPackageUrl(packageId);
                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), pid == null || pid.equals(packageId) || packageId.startsWith(pid + "." + VersionUtilities.getNameForVersion((String)this.context.getVersion()).toLowerCase()), "IG_DEPENDENCY_CLASH_PACKAGEID", url, pid, packageId) && ok;
                    boolean bl = ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), canonical == null || canonical.equals(url) || url.startsWith(Utilities.pathURL((String[])new String[]{canonical, "ImplementationGuide"})), "IG_DEPENDENCY_CLASH_CANONICAL", packageId, canonical, url) && ok;
                }
                if (packageId == null && ok) {
                    packageId = pcm.getPackageId(url);
                }
                if (!ok || !this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId != null, "IG_DEPENDENCY_NO_PACKAGE", new Object[0]) || !this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_NO_VERSION", new Object[0])) break block17;
                ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), (packageId + "#" + version).matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$"), "IG_DEPENDENCY_INVALID_PACKAGE_VERSION", version) && ok;
                NpmPackage npm = pcm.loadPackage(packageId, version);
                if (this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), npm != null, "IG_DEPENDENCY_PACKAGE_UNKNOWN", packageId + "#" + version) && !fvl.isEmpty() && !VersionUtilities.versionsMatch((String)(pver = npm.fhirVersion()), fvl)) {
                    if (Utilities.existsInList((String)packageId, (String[])new String[]{"hl7.fhir.uv.extensions", "hl7.fhir.uv.tools", "hl7.terminology"})) {
                        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_ERROR", CommaSeparatedStringBuilder.join((String)",", fvl), packageId + "#" + version, pver, packageId + "." + VersionUtilities.getNameForVersion((String)fvl.get(0)).toLowerCase()) && ok;
                    } else {
                        this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_WARNING", CommaSeparatedStringBuilder.join((String)",", fvl), packageId + "#" + version, pver);
                    }
                }
                if (!this.settings.isForPublication()) break block17;
                try {
                    PackageClient pc = new PackageClient(PackageServer.primaryServer());
                    List list = pc.getVersions(packageId);
                    String lver = pcm.getLatestVersion(packageId);
                    for (PackageInfo t : list) {
                        if (t.getVersion().contains("-")) continue;
                        lver = t.getVersion();
                    }
                    if (lver != null && !VersionUtilities.versionsMatch((String)version, (String)lver) && ImplementationGuideValidator.isMoreThanXMonthsAgo(npm.dateAsLocalDate(), 3)) {
                        this.warning(errors, "2025-03-06", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_WARNING_OLD", packageId + "#" + version, lver, npm.dateAsLocalDate().toString());
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_EXCEPTION", e.getMessage());
            }
        }
        return ok;
    }

    public static boolean isMoreThanXMonthsAgo(LocalDate date, int months) {
        LocalDate today = LocalDate.now();
        LocalDate thresholdDate = today.minusMonths(months);
        return date.isBefore(thresholdDate);
    }
}

