/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ConceptMapValidator
extends BaseValidator {
    private static final int TOO_MANY_CODES_TO_VALIDATE = 500;
    private final List<CMCodingValidationRequest> batch = new ArrayList<CMCodingValidationRequest>();

    public ConceptMapValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateConceptMap(ValidationContext valContext, List<ValidationMessage> errors, Element cm, NodeStack stack, ValidationOptions options) {
        boolean ok = true;
        HashMap<String, PropertyDefinition> props = new HashMap<String, PropertyDefinition>();
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
            List properties = cm.getChildrenByName("property");
            int ci = 0;
            for (Object property : properties) {
                String code = property.getChildValue("code");
                String type = property.getChildValue("type");
                String system = property.getChildValue("system");
                CodeSystem cs = system != null ? this.context.fetchCodeSystem(system) : null;
                ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, property.line(), property.col(), stack.push((Element)property, ci, null, null).getLiteralPath(), !"code".equals(type) || system != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_NO_SYSTEM", new Object[0]) && ok;
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, property.line(), property.col(), stack.push((Element)property, ci, null, null).getLiteralPath(), system == null || cs != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_UNKNOWN_SYSTEM", system);
                if (code != null) {
                    props.put(code, new PropertyDefinition(type, system, cs));
                }
                ++ci;
            }
            List attributes = cm.getChildrenByName("additionalAttribute");
            for (Element attribute : attributes) {
                String code = attribute.getChildValue("code");
                String type = attribute.getChildValue("type");
                if (code == null) continue;
                attribs.put(code, type);
            }
        }
        BaseValidator.BooleanHolder bh = new BaseValidator.BooleanHolder();
        VSReference sourceScope = this.readVSReference(errors, stack, bh, cm, "sourceScope", "source");
        VSReference targetScope = this.readVSReference(errors, stack, bh, cm, "targetScope", "target");
        ok = ok && bh.ok();
        List groups = cm.getChildrenByName("group");
        int ci = 0;
        for (Element group : groups) {
            ok = this.validateGroup(valContext, errors, group, stack.push(group, ci, null, null), props, attribs, options, sourceScope, targetScope) && ok;
            ++ci;
        }
        if (!stack.isContained()) {
            boolean bl = ok = this.checkShareableConceptMap(errors, cm, stack) && ok;
        }
        if (!this.batch.isEmpty()) {
            if (this.batch.size() > 500) {
                ok = this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "CONCEPTMAP_VS_TOO_MANY_CODES", this.batch.size()) && ok;
            } else if (!this.noTerminologyChecks) {
                try {
                    long t = System.currentTimeMillis();
                    this.context.validateCodeBatch(ValidationOptions.defaults(), this.batch, null);
                    if (this.settings.isDebug()) {
                        System.out.println("  :   .. " + (System.currentTimeMillis() - t) + "ms");
                    }
                    for (CMCodingValidationRequest cv : this.batch) {
                        if (cv.getResult().getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                            this.warning(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "CONCEPTMAP_VS_CONCEPT_CODE_UNKNOWN_SYSTEM", cv.getCoding().getSystem(), cv.getCoding().getCode(), cv.getVsObj().getUrl());
                            continue;
                        }
                        if (cv.getResult().getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED_VERSION) {
                            this.warning(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "CONCEPTMAP_VS_CONCEPT_CODE_UNKNOWN_SYSTEM_VERSION", cv.getCoding().getSystem(), cv.getCoding().getCode(), cv.getVsObj().getUrl(), cv.getResult().getVersion());
                            continue;
                        }
                        if (cv.getCoding().getVersion() == null) {
                            ok = this.rule(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "CONCEPTMAP_VS_INVALID_CONCEPT_CODE", cv.getCoding().getSystem(), cv.getCoding().getCode(), cv.getVsObj().getUrl()) && ok;
                            continue;
                        }
                        ok = this.rule(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "CONCEPTMAP_VS_INVALID_CONCEPT_CODE_VER", cv.getCoding().getSystem(), cv.getCoding().getVersion(), cv.getCoding().getCode(), cv.getVsObj().getUrl()) && ok;
                    }
                }
                catch (Exception e) {
                    ok = false;
                    CMCodingValidationRequest cv = this.batch.get(0);
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, cv.getStack().getLiteralPath(), false, e.getMessage(), new Object[0]);
                }
            }
        }
        return ok;
    }

    private VSReference readVSReference(List<ValidationMessage> errors, NodeStack stack, BaseValidator.BooleanHolder bok, Element cm, String ... names) {
        for (String n : names) {
            if (!cm.hasChild(n, false)) continue;
            Element e = cm.getNamedChild(n, false);
            String ref = null;
            if (e.isPrimitive()) {
                ref = e.primitiveValue();
            } else if (e.hasChild("reference", false)) {
                ref = e.getNamedChildValue("reference", false);
            }
            if (ref == null) continue;
            VSReference res = new VSReference();
            if (ref.contains("|")) {
                res.url = ref.substring(0, ref.indexOf("|"));
                res.version = ref.substring(ref.indexOf("|") + 1);
                Resource r = this.context.fetchResource(Resource.class, res.url, res.version);
                if (r != null) {
                    if (r instanceof ValueSet) {
                        res.vs = (ValueSet)r;
                    } else {
                        bok.fail();
                        this.rule(errors, "2025-12-31", ValidationMessage.IssueType.INVALID, stack.getLiteralPath() + "." + n, false, "CONCEPTMAP_VS_NOT_A_VS", r.fhirType());
                    }
                }
                if (res.vs == null) {
                    res.vs = (ValueSet)this.context.findTxResource(ValueSet.class, res.url, res.version);
                }
            } else {
                res.url = ref;
                Resource r = this.context.fetchResource(Resource.class, res.url);
                if (r != null) {
                    if (r instanceof ValueSet) {
                        res.vs = (ValueSet)r;
                    } else {
                        bok.fail();
                        this.rule(errors, "2025-12-31", ValidationMessage.IssueType.INVALID, stack.getLiteralPath() + "." + n, false, "CONCEPTMAP_VS_NOT_A_VS", r.fhirType());
                    }
                }
                if (res.vs == null) {
                    res.vs = (ValueSet)this.context.findTxResource(ValueSet.class, res.url);
                }
            }
            return res;
        }
        return null;
    }

    private boolean validateGroup(ValidationContext valContext, List<ValidationMessage> errors, Element grp, NodeStack stack, Map<String, PropertyDefinition> props, Map<String, String> attribs, ValidationOptions options, VSReference sourceScope, VSReference targetScope) {
        Set possibleVersions;
        boolean ok = true;
        GroupContext ctxt = new GroupContext();
        ctxt.sourceScope = sourceScope;
        ctxt.targetScope = targetScope;
        Element e = grp.getNamedChild("source", false);
        if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, grp.line(), grp.col(), stack.getLiteralPath(), e != null, "CONCEPTMAP_GROUP_SOURCE_MISSING", new Object[0])) {
            ctxt.source = this.readCSReference(e, grp.getNamedChild("sourceVersion", false), ctxt.getSourceVS());
            if (ctxt.source.cs != null) {
                if (this.isServerSideOnly(ctxt.source.cs)) {
                    this.hint(errors, "2024-03-25", ValidationMessage.IssueType.BUSINESSRULE, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), false, "CONCEPTMAP_GROUP_SOURCE_SERVER_SIDE", e.getValue());
                    ctxt.source.cs = null;
                } else if (!this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), this.isOkCodeSystem(ctxt.source.cs), "CONCEPTMAP_GROUP_SOURCE_INCOMPLETE", e.getValue(), ctxt.source.cs.getContent().toCode())) {
                    ctxt.source.cs = null;
                }
            } else {
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), sourceScope != null, "CONCEPTMAP_GROUP_SOURCE_UNKNOWN", e.getValue());
            }
            if (this.fetcher != null && ctxt.source.version == null && ctxt.source.cs != null && !CodeSystemUtilities.isExemptFromMultipleVersionChecking((String)ctxt.source.url) && this.fetcher != null) {
                possibleVersions = this.fetcher.fetchCanonicalResourceVersions(null, valContext.getAppContext(), ctxt.source.url);
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, grp.line(), grp.col(), stack.getLiteralPath(), possibleVersions.size() <= 1, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_MULTIPLE_POSSIBLE_VERSIONS", ctxt.source.url, ctxt.source.cs.getVersion(), CommaSeparatedStringBuilder.join((String)", ", (Collection)Utilities.sorted((Collection)possibleVersions)));
            }
        }
        e = grp.getNamedChild("target", false);
        if (this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, grp.line(), grp.col(), stack.getLiteralPath(), e != null, "CONCEPTMAP_GROUP_TARGET_MISSING", new Object[0])) {
            ctxt.target = this.readCSReference(e, grp.getNamedChild("targetVersion", false), ctxt.getTargetVS());
            if (ctxt.target.cs != null) {
                if (this.isServerSideOnly(ctxt.target.cs)) {
                    this.hint(errors, "2024-03-25", ValidationMessage.IssueType.BUSINESSRULE, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), false, "CONCEPTMAP_GROUP_TARGET_SERVER_SIDE", e.getValue());
                    ctxt.target.cs = null;
                } else if (!this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), this.isOkCodeSystem(ctxt.target.cs), "CONCEPTMAP_GROUP_TARGET_INCOMPLETE", e.getValue(), ctxt.target.cs.getContent().toCode())) {
                    ctxt.target.cs = null;
                }
            } else {
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.NOTFOUND, grp.line(), grp.col(), stack.push(e, -1, null, null).getLiteralPath(), targetScope != null, "CONCEPTMAP_GROUP_TARGET_UNKNOWN", e.getValue());
            }
            if (this.fetcher != null && ctxt.target.version == null && ctxt.target.cs != null && !CodeSystemUtilities.isExemptFromMultipleVersionChecking((String)ctxt.target.url)) {
                possibleVersions = this.fetcher.fetchCanonicalResourceVersions(null, valContext.getAppContext(), ctxt.target.url);
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, grp.line(), grp.col(), stack.getLiteralPath(), possibleVersions.size() <= 1, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_MULTIPLE_POSSIBLE_VERSIONS", ctxt.target.url, ctxt.target.cs.getVersion(), CommaSeparatedStringBuilder.join((String)", ", (Collection)Utilities.sorted((Collection)possibleVersions)));
            }
        }
        RelationshipTracker relationships = new RelationshipTracker();
        List elements = grp.getChildrenByName("element");
        int ci = 0;
        for (Element element : elements) {
            ok = this.validateGroupElement(errors, element, stack.push(element, ci, null, null), props, attribs, options, ctxt, relationships) && ok;
            ++ci;
        }
        return ok;
    }

    private boolean isServerSideOnly(CodeSystem cs) {
        return Utilities.existsInList((String)cs.getUrl(), (String[])new String[]{"http://snomed.info/sct", "http://loinc.org"});
    }

    private CSReference readCSReference(Element ref, Element version, ValueSet vs) {
        CSReference res = new CSReference();
        res.url = ref.primitiveValue();
        if (version != null) {
            res.version = version.primitiveValue();
        } else if (res.url.contains("|")) {
            res.version = res.url.substring(res.url.indexOf("|") + 1);
            res.url = res.url.substring(0, res.url.indexOf("|"));
        } else if (vs != null && res.url != null) {
            for (ValueSet.ConceptSetComponent vsi : vs.getCompose().getInclude()) {
                if (!res.url.equals(vsi.getSystem()) || !vsi.hasVersion()) continue;
                res.version = vsi.getVersion();
            }
        }
        res.cs = this.context.fetchCodeSystem(res.url, res.version);
        return res;
    }

    private boolean isOkCodeSystem(CodeSystem tgtCS) {
        return tgtCS.getContent() != Enumerations.CodeSystemContentMode.NOTPRESENT && tgtCS.getContent() != Enumerations.CodeSystemContentMode.EXAMPLE && tgtCS.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT;
    }

    private boolean validateGroupElement(List<ValidationMessage> errors, Element src, NodeStack stack, Map<String, PropertyDefinition> props, Map<String, String> attribs, ValidationOptions options, GroupContext ctxt, RelationshipTracker relationships) {
        String source;
        boolean ok = true;
        Element code = src.getNamedChild("code", false);
        String string = source = code != null ? code.primitiveValue() : null;
        if (code != null) {
            NodeStack cstack = stack.push(code, -1, null, null);
            if (ctxt.hasSourceCS()) {
                String c = code.getValue();
                CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode((CodeSystem)ctxt.source.cs, (String)c);
                if (this.warningOrError(ctxt.source.cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE, errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), cd != null, "CONCEPTMAP_GROUP_SOURCE_CODE_INVALID", c, ctxt.source.cs.getVersionedUrl())) {
                    Element display = src.getNamedChild("display", false);
                    if (display != null) {
                        this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), CodeSystemUtilities.checkDisplay((CodeSystem)ctxt.source.cs, (CodeSystem.ConceptDefinitionComponent)cd, (String)display.getValue()), "CONCEPTMAP_GROUP_SOURCE_DISPLAY_INVALID", display.getValue(), CommaSeparatedStringBuilder.joinWrapped((String)", ", (String)"'", (String)"'", (Collection)CodeSystemUtilities.getDisplays((CodeSystem)ctxt.source.cs, (CodeSystem.ConceptDefinitionComponent)cd)), ctxt.source.cs.getVersionedUrl() + "#" + cd.getCode());
                    }
                    if (!this.noTerminologyChecks && ctxt.hasSourceVS() && ctxt.source != null) {
                        ValidationResult vr = this.context.validateCode(options.withCheckValueSetOnly().withNoServer(), ctxt.source.url, ctxt.source.version, c, null, ctxt.sourceScope.vs);
                        if (!this.warningOrError(ctxt.source.cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE, errors, "2023-09-06", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), vr.isOk(), "CONCEPTMAP_GROUP_SOURCE_CODE_INVALID_VS", c, ctxt.sourceScope.vs.getVersionedUrl())) {
                            ok = ctxt.source.cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE & ok;
                        }
                    }
                } else {
                    ok = ctxt.source.cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE & ok;
                }
            } else {
                this.addToBatch(code, cstack, ctxt.source, ctxt.sourceScope);
            }
        }
        List targets = src.getChildrenByName("target");
        int ci = 0;
        for (Element target : targets) {
            ok = this.validateGroupElementTarget(errors, target, stack.push(target, ci, null, null), props, attribs, options, ctxt, relationships, source) && ok;
            ++ci;
        }
        boolean noMap = "true".equals(src.getNamedChildValue("noMap"));
        if (noMap) {
            if (!relationships.has(source)) {
                relationships.see(source, "unmapped");
            } else if (!relationships.get(source).equals("unmapped")) {
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION_DIFFERENT", source, code.primitiveValue());
            } else {
                this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION", source, code.primitiveValue());
            }
        }
        return ok;
    }

    private boolean validateGroupElementTarget(List<ValidationMessage> errors, Element tgt, NodeStack stack, Map<String, PropertyDefinition> props, Map<String, String> attribs, ValidationOptions options, GroupContext ctxt, RelationshipTracker relationships, String source) {
        boolean ok = true;
        Element code = tgt.getNamedChild("code", false);
        if (code != null) {
            NodeStack cstack = stack.push(code, -1, null, null);
            if (ctxt.hasTargetCS()) {
                String c = code.getValue();
                CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.getCode((CodeSystem)ctxt.target.cs, (String)c);
                if (this.warningOrError(ctxt.target.cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE, errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), cd != null, "CONCEPTMAP_GROUP_TARGET_CODE_INVALID", c, ctxt.target.cs.getVersionedUrl())) {
                    Element display = tgt.getNamedChild("display", false);
                    if (display != null) {
                        this.warning(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), CodeSystemUtilities.checkDisplay((CodeSystem)ctxt.target.cs, (CodeSystem.ConceptDefinitionComponent)cd, (String)display.getValue()), "CONCEPTMAP_GROUP_TARGET_DISPLAY_INVALID", display.getValue(), CommaSeparatedStringBuilder.joinWrapped((String)", ", (String)"'", (String)"'", (Collection)CodeSystemUtilities.getDisplays((CodeSystem)ctxt.target.cs, (CodeSystem.ConceptDefinitionComponent)cd)), ctxt.target.cs.getVersionedUrl() + "#" + cd.getCode());
                    }
                    if (!this.noTerminologyChecks && ctxt.hasTargetVS() && ctxt.target != null) {
                        ValidationResult vr = this.context.validateCode(options.withCheckValueSetOnly().withNoServer(), ctxt.target.url, ctxt.target.version, c, null, ctxt.targetScope.vs);
                        if (!this.warningOrError(ctxt.target.cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE, errors, "2023-09-06", ValidationMessage.IssueType.REQUIRED, code.line(), code.col(), cstack.getLiteralPath(), vr.isOk(), "CONCEPTMAP_GROUP_TARGET_CODE_INVALID_VS", c, ctxt.targetScope.vs.getVersionedUrl())) {
                            ok = ctxt.target.cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && ok;
                        }
                    }
                } else {
                    ok = ctxt.target.cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE & ok;
                }
            } else {
                this.addToBatch(code, cstack, ctxt.target, ctxt.targetScope);
            }
        }
        String target = tgt.getNamedChildValue("code");
        String reln = tgt.getNamedChildValue(VersionUtilities.isR5Plus((String)this.context.getVersion()) ? "relationship" : "equivalence");
        if (source != null && reln != null) {
            if (target == null) {
                if (!relationships.has(source)) {
                    relationships.see(source, reln);
                } else if (relationships.get(source).equals(reln)) {
                    this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION", source, code.primitiveValue());
                } else {
                    this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION_DIFFERENT", source, code.primitiveValue(), reln, relationships.get(source));
                }
            } else {
                if (relationships.has(source)) {
                    this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION_DIFFERENT", source, code.primitiveValue(), reln, relationships.get(source));
                }
                if (relationships.has(source, target)) {
                    if (relationships.get(source, target).equals(reln)) {
                        this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION_DIFFERENT", source, code.primitiveValue(), reln, relationships.get(source, target));
                    } else {
                        this.warning(errors, "2023-03-05", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "CONCEPTMAP_GROUP_TARGET_DUPLICATION", source, code.primitiveValue());
                    }
                } else {
                    relationships.see(source, target, reln);
                }
            }
        }
        if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
            List properties = tgt.getChildrenByName("property");
            int ci = 0;
            for (Element property : properties) {
                ok = this.validateGroupElementTargetProperty(errors, property, stack.push(property, ci, null, null), props) && ok;
                ++ci;
            }
            List attributes = tgt.getChildrenByName("dependsOn");
            ci = 0;
            for (Element attribute : attributes) {
                ok = this.validateGroupElementTargetAttribute(errors, attribute, stack.push(attribute, ci, null, null), attribs) && ok;
                ++ci;
            }
            attributes = tgt.getChildrenByName("product");
            ci = 0;
            for (Element attribute : attributes) {
                ok = this.validateGroupElementTargetAttribute(errors, attribute, stack.push(attribute, ci, null, null), attribs) && ok;
                ++ci;
            }
        }
        return ok;
    }

    private boolean validateGroupElementTargetProperty(List<ValidationMessage> errors, Element property, NodeStack stack, Map<String, PropertyDefinition> props) {
        boolean ok = true;
        Element codeE = property.getNamedChild("code", false);
        Element valueE = property.getNamedChild("value", false);
        String code = codeE.getValue();
        if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stack.push(codeE, -1, null, null).getLiteralPath(), props.containsKey(code), "CONCEPTMAP_GROUP_TARGET_PROPERTY_INVALID", code, props.keySet())) {
            PropertyDefinition defn = props.get(code);
            NodeStack stackV = stack.push(valueE, -1, null, null);
            if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), valueE.fhirType().equals(defn.getType()), "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_MISMATCH", valueE.fhirType(), defn.getType())) {
                if (valueE.fhirType().equals("code")) {
                    ok = defn.getCs() != null ? this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), CodeSystemUtilities.findCode((List)defn.getCs().getConcept(), (String)valueE.getValue()) != null, "CONCEPTMAP_GROUP_TARGET_PROPERTY_CODE_INVALID", valueE.getValue(), defn.getCs().getVersionedUrl()) && ok : false;
                }
            } else {
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean validateGroupElementTargetAttribute(List<ValidationMessage> errors, Element attribute, NodeStack stack, Map<String, String> attribs) {
        boolean ok = true;
        Element codeE = attribute.getNamedChild("attribute", false);
        Element valueE = attribute.getNamedChild("value", false);
        String code = codeE.getValue();
        if (this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stack.push(codeE, -1, null, null).getLiteralPath(), attribs.containsKey(code), "CONCEPTMAP_GROUP_TARGET_PROPERTY_INVALID", code, attribs.keySet())) {
            NodeStack stackV = stack.push(valueE, -1, null, null);
            ok = this.rule(errors, "2023-03-05", ValidationMessage.IssueType.REQUIRED, codeE.line(), codeE.col(), stackV.getLiteralPath(), valueE.fhirType().equals(attribs.get(code)), "CONCEPTMAP_GROUP_TARGET_PROPERTY_TYPE_MISMATCH", valueE.fhirType(), attribs.get(code)) && ok;
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean checkShareableConceptMap(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        if (this.settings.isForPublication()) {
            if (this.isHL7(cs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CONCEPTMAP_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CONCEPTMAP_SHAREABLE_MISSING_HL7", "description") && ok;
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CONCEPTMAP_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CONCEPTMAP_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CONCEPTMAP_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CONCEPTMAP_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CONCEPTMAP_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CONCEPTMAP_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CONCEPTMAP_SHAREABLE_MISSING", "description");
        }
        return true;
    }

    private void addToBatch(Element code, NodeStack stack, CSReference system, VSReference scope) {
        if (scope != null && scope.vs != null && system != null) {
            Coding c = new Coding(system.url, code.primitiveValue(), null).setVersion(system.version);
            this.batch.add(new CMCodingValidationRequest(stack, c, scope.vs));
        }
    }

    public static class PropertyDefinition {
        private final String type;
        private final String system;
        private final CodeSystem cs;

        protected PropertyDefinition(String type, String system, CodeSystem cs) {
            this.type = type;
            this.system = system;
            this.cs = cs;
        }

        public String getType() {
            return this.type;
        }

        public String getSystem() {
            return this.system;
        }

        public CodeSystem getCs() {
            return this.cs;
        }
    }

    public static class VSReference {
        private String url;
        private String version;
        private ValueSet vs;
    }

    public class CMCodingValidationRequest
    extends CodingValidationRequest {
        private final NodeStack stack;

        public CMCodingValidationRequest(NodeStack stack, Coding code, ValueSet vs) {
            super(code, vs);
            this.stack = stack;
        }

        public NodeStack getStack() {
            return this.stack;
        }
    }

    public static class GroupContext {
        private VSReference sourceScope;
        private VSReference targetScope;
        private CSReference source;
        private CSReference target;

        public boolean hasSourceCS() {
            return this.source != null && this.source.cs != null;
        }

        public boolean hasSourceVS() {
            return this.sourceScope != null && this.sourceScope.vs != null;
        }

        public boolean hasTargetCS() {
            return this.target != null && this.target.cs != null;
        }

        public boolean hasTargetVS() {
            return this.targetScope != null && this.targetScope.vs != null;
        }

        public ValueSet getSourceVS() {
            return this.hasSourceVS() ? this.sourceScope.vs : null;
        }

        public ValueSet getTargetVS() {
            return this.hasTargetVS() ? this.targetScope.vs : null;
        }
    }

    public static class CSReference {
        private String url;
        private String version;
        private CodeSystem cs;
    }

    public class RelationshipTracker {
        Map<String, String> map = new HashMap<String, String>();

        public boolean has(String source) {
            return this.map.containsKey(source);
        }

        public void see(String source, String reln) {
            this.map.put(source, reln);
        }

        public String get(String source) {
            return this.map.get(source);
        }

        public boolean has(String source, String target) {
            return this.map.containsKey(this.key(source, target));
        }

        public Object get(String source, String target) {
            return this.map.get(this.key(source, target));
        }

        public void see(String source, String target, String reln) {
            this.map.put(this.key(source, target), reln);
        }

        private String key(String source, String target) {
            return "|" + source + "|" + target + "|";
        }
    }
}

