/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaEnumerationsGenerator
extends JavaBaseGenerator {
    public JavaEnumerationsGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void generate() throws Exception {
        ValueSet vs;
        this.write("package " + this.packageName + ";\r\n");
        this.startMark(this.version, this.genDate);
        this.write("\r\n");
        this.write("import org.hl7.fhir.instance.model.api.*;\r\n");
        this.write("import org.hl7.fhir.exceptions.FHIRException;\r\n");
        this.write("\r\n");
        this.write("public class Enumerations {\r\n");
        this.write("\r\n");
        this.write("// In here: \r\n");
        Map<String, ValueSet> enums = this.scanForEnums();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(enums.keySet());
        Collections.sort(names);
        for (String n : names) {
            vs = enums.get(n);
            this.write("//   " + n + ": " + vs.getDescription());
            if (vs.hasUserData("usages")) {
                this.write(vs.getUserData("usages").toString());
            } else {
                this.write("?null?");
            }
            this.write("\r\n");
        }
        this.write("\r\n");
        this.write("\r\n");
        for (String n : names) {
            vs = enums.get(n);
            this.generateEnum(n, (ValueSet)vs.getUserData("expansion"));
        }
        this.write("\r\n");
        this.write("}\r\n");
        this.write("\r\n");
        this.flush();
    }

    private Map<String, ValueSet> scanForEnums() {
        HashMap<String, ValueSet> res = new HashMap<String, ValueSet>();
        for (ValueSet vs : this.definitions.getValuesets().getSortedList()) {
            if (!vs.hasUserData("shared") || !vs.hasUserData("expansion")) continue;
            res.put(this.getCodeListType(vs.getName()), vs);
        }
        return res;
    }

    private void generateEnum(String name, ValueSet vs) throws Exception {
        String cc;
        String url = vs.getUrl();
        CommaSeparatedStringBuilder el = new CommaSeparatedStringBuilder();
        this.write("    public enum " + name + " {\r\n");
        int l = vs.getExpansion().getContains().size();
        int i = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            ++i;
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            el.append(cc);
            this.write("        /**\r\n");
            this.write("         * " + this.definitions.getCodeDefinition(c.getSystem(), c.getCode()) + "\r\n");
            this.write("         */\r\n");
            this.write("        " + cc.toUpperCase() + ", \r\n");
        }
        this.write("        /**\r\n");
        this.write("         * added to help the parsers\r\n");
        this.write("         */\r\n");
        this.write("        NULL;\r\n");
        el.append("NULL");
        this.write("        public static " + name + " fromCode(String codeString) throws FHIRException {\r\n");
        this.write("            if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("                return null;\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return " + cc + ";\r\n");
        }
        this.write("        throw new FHIRException(\"Unknown " + name + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("        public static boolean isValidCode(String codeString) {\r\n");
        this.write("            if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("                return false;\r\n");
        this.write("          return Utilities.existsInList(codeString");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.write(", \"" + c.getCode() + "\"");
        }
        this.write(");\r\n");
        this.write("        }\r\n");
        this.write("        public String toCode() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + c.getCode() + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getSystem() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + c.getSystem() + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getDefinition() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + Utilities.escapeJava((String)this.definitions.getCodeDefinition(c.getSystem(), c.getCode())) + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getDisplay() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + Utilities.escapeJava((String)(Utilities.noString((String)c.getDisplay()) ? c.getCode() : c.getDisplay())) + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        if (this.config.getAdornments().containsKey(name)) {
            this.write("// manual code from configuration.txt:\r\n");
            this.write(this.config.getAdornments().get(name) + "\r\n");
            this.write("// end addition\r\n");
        }
        this.write("    }\r\n");
        this.write("\r\n");
        this.write("  public static class " + name + "EnumFactory implements EnumFactory<" + name + "> {\r\n");
        this.write("    public " + name + " fromCode(String codeString) throws IllegalArgumentException {\r\n");
        this.write("      if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("            if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("                return null;\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return " + name + "." + cc + ";\r\n");
        }
        this.write("        throw new IllegalArgumentException(\"Unknown " + name + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("\r\n");
        this.write("        public Enumeration<" + name + "> fromType(PrimitiveType<?> code) throws FHIRException {\r\n");
        this.write("          if (code == null)\r\n");
        this.write("            return null;\r\n");
        this.write("          if (code.isEmpty())\r\n");
        this.write("            return new Enumeration<" + name + ">(this, " + name + ".NULL, code);\r\n");
        this.write("          String codeString = ((PrimitiveType) code).asStringValue();\r\n");
        this.write("          if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("            return new Enumeration<" + name + ">(this, " + name + ".NULL, code);\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return new Enumeration<" + name + ">(this, " + name + "." + cc + ", code);\r\n");
        }
        this.write("        throw new FHIRException(\"Unknown " + name + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("    public String toCode(" + name + " code) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("      if (code == " + name + "." + cc + ")\r\n        return \"" + c.getCode() + "\";\r\n");
        }
        this.write("      return \"?\";\r\n");
        this.write("      }\r\n");
        this.write("    public String toSystem(" + name + " code) {\r\n");
        this.write("      return code.getSystem();\r\n");
        this.write("      }\r\n");
        this.write("    }\r\n");
        this.write("\r\n");
    }
}

