/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.AnalysisElementInfo;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.EnumInfo;
import org.hl7.fhir.validation.codegen.TypeInfo;

public class Analyser {
    private Definitions definitions;
    private Configuration config;
    private String version;
    private IWorkerContext context;
    private ProfileUtilities pu;

    public Analyser(Definitions definitions, Configuration config, String version, IWorkerContext context) {
        this.definitions = definitions;
        this.config = config;
        this.version = version;
        this.context = context;
        this.pu = new ProfileUtilities(null, null, null);
    }

    public Analysis analyse(StructureDefinition sd, Map<String, AnalysisElementInfo> elementInfo) throws Exception {
        Analysis res = new Analysis(this.definitions, sd);
        StructureDefinition sdb = (StructureDefinition)this.definitions.getStructures().get(sd.getBaseDefinition());
        if (sdb == null && sd.hasBaseDefinition()) {
            sdb = this.definitions.getContext().fetchTypeDefinition(sd.getBaseDefinition());
        }
        res.setAncestor(sdb);
        res.setAbstract(sd.getAbstract());
        res.setClassName(sd.getName().equals("List") ? "ListResource" : sd.getName());
        TypeInfo type = new TypeInfo();
        type.setName(res.getClassName());
        if (res.getAncestor() != null) {
            type.setAncestorName(res.getAncestor().getName());
        }
        res.getTypes().put(type.getName(), type);
        res.setRootType(type);
        sd.setUserData("java.type.info", (Object)type);
        type.setDefn(sd.getSnapshot().getElementFirstRep());
        type.setChildren(this.filterChildren(this.pu.getChildList(sd, type.getDefn())));
        if (res.getAncestor() != null) {
            type.setInheritedChildren(this.getAbstractChildren(res.getAncestor()));
        }
        for (ElementDefinition e : type.getChildren()) {
            this.scanNestedTypes(res, type, type.getName(), e);
        }
        if (sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
            res.setSearchParams(this.getSearchParams(sd.getName()));
        }
        for (ElementDefinition e : type.getChildren()) {
            String nn = e.getUserString("java.type");
            if (nn.startsWith("@")) {
                ElementDefinition er = this.getElementForPath(sd, nn.substring(1));
                if (!er.hasUserData("java.type")) {
                    throw new Exception("not found: " + String.valueOf(er));
                }
                String nnn = er.getUserString("java.type");
                e.setUserData("java.type", (Object)nnn);
                e.setUserData("java.type.info", er.getUserData("java.type.info"));
            }
            elementInfo.put(e.getPath(), new AnalysisElementInfo(res.getClassName(), e.getUserString("java.type")));
        }
        return res;
    }

    private String getR4bAncestor(StructureDefinition sd) {
        switch (sd.getKind()) {
            case COMPLEXTYPE: {
                return "http://hl7.org/fhir/StructureDefinition/DataType";
            }
            case LOGICAL: {
                return "http://hl7.org/fhir/StructureDefinition/Element";
            }
            case PRIMITIVETYPE: {
                return "http://hl7.org/fhir/StructureDefinition/PrimitiveType";
            }
            case RESOURCE: {
                return sd.getBaseDefinition();
            }
        }
        return null;
    }

    protected List<ElementDefinition> filterChildren(List<ElementDefinition> childList) {
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        res.addAll(childList);
        ArrayList<ElementDefinition> r = new ArrayList<ElementDefinition>();
        for (ElementDefinition t : childList) {
            if (t.getPath().equals(t.getBase().getPath())) continue;
            r.add(t);
        }
        res.removeAll(r);
        return res;
    }

    private List<ElementDefinition> getAbstractChildren(StructureDefinition structure) {
        if (!structure.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-interface")) {
            return new ArrayList<ElementDefinition>();
        }
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        StructureDefinition sdb = (StructureDefinition)this.definitions.getStructures().get(structure.getBaseDefinition());
        if (sdb == null) {
            sdb = this.definitions.getContext().fetchTypeDefinition(structure.getBaseDefinition());
        }
        res.addAll(this.getAbstractChildren(sdb));
        res.addAll(this.filterChildren(new ProfileUtilities(null, null, null).getChildList(structure, structure.getSnapshot().getElementFirstRep())));
        return res;
    }

    private void scanNestedTypes(Analysis analysis, TypeInfo type, String path, ElementDefinition e) throws Exception {
        ValueSet vs;
        ElementDefinition.ElementDefinitionBindingComponent cd;
        Object tn = null;
        if (e.typeSummary().equals("code") && e.hasBinding() && this.isEnum(cd = e.getBinding()) && (vs = (ValueSet)this.definitions.getValuesets().get(cd.getValueSet())) != null) {
            tn = this.getCodeListType(vs.getName());
            EnumInfo ei = analysis.getEnums().get(tn);
            if (ei == null) {
                ei = new EnumInfo((String)tn);
                analysis.getEnums().put((String)tn, ei);
                ei.setValueSet(vs);
            }
            if (((String)tn).equals("SubscriptionStatus")) {
                tn = "org.hl7.fhir.r4b.model.Enumerations." + (String)tn;
            }
            e.setUserData("java.type", (Object)("Enumeration<" + (String)tn + ">"));
            e.setUserData("java.enum", (Object)ei);
        }
        if (tn == null) {
            if (e.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style") && "named-elements".equals(e.getExtensionString("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style"))) {
                tn = "NamedElementExtension";
                e.setUserData("java.type", tn);
            } else if (e.getType().size() > 0 && !e.hasContentReference() && this.pu.getChildList(analysis.getStructure(), e).isEmpty()) {
                tn = this.getTypeName(e);
                if (e.typeSummary().equals("xml:lang")) {
                    tn = "CodeType";
                }
                if (e.typeSummary().equals("xhtml")) {
                    tn = "XhtmlNode";
                } else if (e.getType().size() > 1) {
                    tn = "DataType";
                } else if (this.definitions.hasPrimitiveType((String)tn)) {
                    tn = this.upFirst((String)tn) + "Type";
                }
                if (((String)tn).contains("-")) {
                    tn = ((String)tn).replace("-", "_");
                }
                e.setUserData("java.type", tn);
            } else if (e.hasContentReference()) {
                ElementDefinition er = this.getElementForPath(analysis.getStructure(), e.getContentReference().substring(e.getContentReference().indexOf("#") + 1));
                tn = er.getUserString("java.type");
                if (Utilities.noString((String)tn)) {
                    e.setUserData("java.type", (Object)("@" + er.getPath()));
                } else {
                    e.setUserData("java.type", tn);
                }
            } else {
                Object cpath;
                if (e.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name")) {
                    tn = this.upFirst(e.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name")) + "Component";
                    cpath = e.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name");
                } else if (this.config.getIni().hasProperty("typenames", e.getPath())) {
                    tn = this.upFirst(this.config.getIni().getStringProperty("typenames", e.getPath())) + "Component";
                    cpath = this.config.getIni().getStringProperty("typenames", e.getPath());
                } else {
                    tn = path + this.upFirst(this.getTitle(e.getName())) + "Component";
                    cpath = path + this.getTitle(e.getName());
                }
                if (((String)tn).equals("Element")) {
                    tn = "Element_";
                }
                if (analysis.getTypes().containsKey(tn)) {
                    char i = 'A';
                    while (analysis.getTypes().containsKey((String)tn + i)) {
                        i = (char)(i + '\u0001');
                    }
                    tn = (String)tn + i;
                }
                e.setUserData("java.type", tn);
                tn = this.upFirst((String)tn);
                TypeInfo ctype = new TypeInfo();
                ctype.setName((String)tn);
                analysis.getTypes().put(ctype.getName(), ctype);
                analysis.getTypeList().add(ctype);
                ctype.setDefn(e);
                ctype.setAncestorName(e.typeSummary());
                ctype.setChildren(this.filterChildren(new ProfileUtilities(null, null, null).getChildList(analysis.getStructure(), ctype.getDefn())));
                for (ElementDefinition c : ctype.getChildren()) {
                    this.scanNestedTypes(analysis, ctype, (String)cpath, c);
                }
            }
        }
    }

    private boolean isAbstractType(String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(code);
        if (sd != null && sd.getAbstract()) {
            return true;
        }
        return Utilities.existsInList((String)code, (String[])new String[]{"Element", "BackboneElement"});
    }

    protected boolean isEnum(ElementDefinition.ElementDefinitionBindingComponent cd) {
        boolean ok;
        boolean bl = ok = cd != null && cd.getStrength() == Enumerations.BindingStrength.REQUIRED;
        if (ok && cd.getValueSet() != null) {
            ValueSet.ConceptSetComponent inc;
            ValueSet vs = (ValueSet)this.definitions.getValuesets().get(cd.getValueSet());
            if (vs != null && vs.hasName() && vs.getName().contains("ColorCodesOrRGB")) {
                return false;
            }
            if (vs != null && vs.hasCompose() && vs.getCompose().getInclude().size() == 1 && (inc = vs.getCompose().getIncludeFirstRep()).hasSystem() && !inc.hasFilter() && !inc.hasConcept() && !inc.getSystem().startsWith("http://hl7.org/fhir") && !inc.getSystem().startsWith("http://terminology.hl7.org")) {
                ok = false;
            }
            if (vs == null) {
                ok = false;
            } else if (this.config.getIni().getBooleanProperty("no-enum", vs.getUrl()).booleanValue()) {
                ok = false;
            }
        }
        return ok;
    }

    protected String getCodeListType(String binding) {
        StringBuilder b = new StringBuilder();
        boolean up = true;
        for (char ch : binding.toCharArray()) {
            if (ch == '-' || ch == ' ' || ch == '.') {
                up = true;
                continue;
            }
            if (up) {
                b.append(Character.toUpperCase(ch));
                up = false;
                continue;
            }
            b.append(ch);
        }
        return "ResourceType".equals(b.toString()) ? "ResourceTypeEnum" : b.toString();
    }

    protected String getTypeName(ElementDefinition e) throws Exception {
        if (e.getType().size() > 1) {
            boolean allPrimitive = true;
            for (ElementDefinition.TypeRefComponent tr : e.getType()) {
                allPrimitive = allPrimitive && Utilities.existsInList((String)tr.getWorkingCode(), (String[])new String[]{"string", "boolean", "integer", "decimal"});
            }
            if (allPrimitive) {
                e.setUserData("JGEN_ALL_PRIMITIVE", (Object)true);
            }
            return "DataType";
        }
        if (e.getType().size() == 0) {
            throw new Exception("not supported");
        }
        ElementDefinition.TypeRefComponent tr = (ElementDefinition.TypeRefComponent)e.getType().get(0);
        if (tr.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) {
            return tr.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
        }
        String type = tr.getCode();
        if (Utilities.isAbsoluteUrl((String)type)) {
            return Utilities.urlTail((String)type);
        }
        return type;
    }

    protected String getTypeName(String tn) {
        if (tn.equals("string")) {
            return "StringType";
        }
        if (tn.equals("Any")) {
            return "Reference";
        }
        if (tn.equals("SimpleQuantity")) {
            return "Quantity";
        }
        if (this.isPrimitive(tn)) {
            return this.getTitle(tn) + "Type";
        }
        return this.getTitle(tn);
    }

    protected String getTitle(String name) {
        return Utilities.noString((String)name) ? "Value" : name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected boolean isPrimitive(String name) {
        return this.definitions.getStructures().has(this.typeNs(name)) && ((StructureDefinition)this.definitions.getStructures().get(this.typeNs(name))).getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String upFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String typeNs(String name) {
        return "http://hl7.org/fhir/StructureDefinition/" + name;
    }

    private ElementDefinition getElementForPath(StructureDefinition structure, String pathname) throws Exception {
        String[] path = pathname.split("\\.");
        if (!path[0].equals(structure.getName())) {
            throw new Exception("Element Path '" + pathname + "' is not legal in this context (" + structure.getName() + ")");
        }
        ElementDefinition res = null;
        for (ElementDefinition t : structure.getSnapshot().getElement()) {
            if (!t.getPath().equals(pathname)) continue;
            res = t;
        }
        if (res == null) {
            throw new Exception("unable to resolve " + pathname);
        }
        return res;
    }

    private List<SearchParameter> getSearchParams(String name) {
        ArrayList<SearchParameter> res = new ArrayList<SearchParameter>();
        if (!Utilities.existsInList((String)name, (String[])new String[]{"Resource"})) {
            for (SearchParameter sp : this.definitions.getSearchParams().getList()) {
                boolean relevant = false;
                for (Enumeration c : sp.getBase()) {
                    if (!c.getCode().equals(name)) continue;
                    relevant = true;
                    break;
                }
                if (!relevant) continue;
                res.add(sp);
            }
        }
        return res;
    }
}

