/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.DefinitionNavigator;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class OperationDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;

    public OperationDefinitionValidator(BaseValidator parent, FHIRPathEngine fpe) {
        super(parent);
        this.fpe = fpe;
    }

    public boolean validateOperationDefinition(ValidationContext valContext, List<ValidationMessage> errors, Element od, NodeStack stack) {
        boolean ok = true;
        if (od.hasChild("inputProfile")) {
            boolean bl = ok = this.validateProfile(errors, stack.push(od.getNamedChild("inputProfile"), -1, null, null), od, od.getNamedChildValue("inputProfile"), "in") && ok;
        }
        if (od.hasChild("outputProfile")) {
            ok = this.validateProfile(errors, stack.push(od.getNamedChild("outputProfile"), -1, null, null), od, od.getNamedChildValue("outputProfile"), "out") && ok;
        }
        return ok;
    }

    private boolean validateProfile(List<ValidationMessage> errors, NodeStack stack, Element od, String url, String use) {
        boolean ok = true;
        StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        if (this.rule(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, stack, sdt != null, "OPDEF_PROFILE_NOT_FOUND", use, url) && this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, stack, "Parameters".equals(sdt.getType()), "OPDEF_PROFILE_NOT_PARAMETERS", use, url)) {
            DefinitionNavigator profile = new DefinitionNavigator(this.context, sdt, false, true);
            List params = od.getChildren("parameter");
            ArrayList<Element> matched = new ArrayList<Element>();
            if (profile.childByName("parameter") != null && profile.childByName("parameter").hasSlices()) {
                for (DefinitionNavigator slice : profile.childByName("parameter").slices()) {
                    DefinitionNavigator nameSlice = slice.childByName("name");
                    if (this.rule(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, stack, sdt != null, "OPDEF_PROFILE_NO_SLICE", use, slice.current().getSliceName())) {
                        DataType name = nameSlice.current().hasFixed() ? nameSlice.current().getFixed() : nameSlice.current().getPattern();
                        if (this.rule(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, stack, sdt != null, "OPDEF_PROFILE_NO_FIXED", use, slice.current().getSliceName())) {
                            String paramName = name.primitiveValue();
                            Element param = this.getParamByName(params, paramName, use);
                            if (param == null) {
                                this.warning(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, stack, false, "OPDEF_PROFILE_NOT_IN_PARAM", use, paramName);
                                continue;
                            }
                            matched.add(param);
                            NodeStack nsp = stack.push(param, params.indexOf(param), null, null);
                            ok = this.compareParameterDefinitions(errors, nsp, use, paramName, slice, param) && ok;
                            continue;
                        }
                        ok = false;
                        continue;
                    }
                    ok = false;
                }
            }
            int i = 0;
            for (Element p : params) {
                if (!matched.contains(p) && use.equals(p.getNamedChildValue("use"))) {
                    NodeStack nsp = stack.push(p, i, null, null);
                    this.warning(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, nsp, false, "OPDEF_PROFILE_NOT_IN_PROFILE", use, p.getNamedChildValue("name"));
                }
                ++i;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean compareParameterDefinitions(List<ValidationMessage> errors, NodeStack nsp, String use, String paramName, DefinitionNavigator slice, Element param) {
        String t;
        boolean ok = true;
        int minParam = Utilities.parseInt((String)param.getNamedChildValue("min"), (int)-1);
        int minProfile = slice.current().getMin();
        if (minParam > -1) {
            ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, nsp, minParam == minProfile, "OPDEF_PROFILE_NOT_VALUE_MISMATCH", use, paramName, "min", param.getNamedChildValue("min"), slice.current().getMin()) && ok;
        }
        int maxParam = this.parseMax(param.getNamedChildValue("max"));
        int maxProfile = this.parseMax(slice.current().getMax());
        if (maxParam > -1 && maxProfile > -1) {
            ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.UNKNOWN, nsp, maxParam == maxProfile, "OPDEF_PROFILE_NOT_VALUE_MISMATCH", use, paramName, "max", param.getNamedChildValue("max"), slice.current().getMax()) && ok;
        }
        ArrayList<String> allowedTypes = new ArrayList<String>();
        if (param.hasExtension(new String[]{"http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type"})) {
            for (Element ex : param.getExtensions("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
                allowedTypes.add(ex.getNamedChildValue("value"));
            }
        } else if (param.hasChildren("allowedType")) {
            for (Object at : param.getChildren("allowedType")) {
                allowedTypes.add(at.primitiveValue());
            }
        } else {
            allowedTypes.add(param.getNamedChildValue("type"));
        }
        ArrayList<String> allowedTargets = new ArrayList<String>();
        for (Element at : param.getChildren("targetProfile")) {
            allowedTargets.add(at.primitiveValue());
        }
        ArrayList<String> profileTypes = new ArrayList<String>();
        ArrayList<String> profileTargets = new ArrayList<String>();
        DefinitionNavigator valueDefn = slice.childByName("value");
        DefinitionNavigator resDefn = slice.childByName("resource");
        DefinitionNavigator partDefn = slice.childByName("part");
        if (valueDefn != null && this.isUsed(valueDefn, resDefn, partDefn)) {
            for (ElementDefinition.TypeRefComponent tr : valueDefn.current().getType()) {
                t = tr.getWorkingCode();
                profileTypes.add(t);
                ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, nsp, allowedTypes.contains(t), "OPDEF_PROFILE_TYPE_NOT_IN_PARAMS", use, paramName, t, CommaSeparatedStringBuilder.join2((String)",", (String)" and ", allowedTypes)) && ok;
                for (CanonicalType ct : tr.getTargetProfile()) {
                    profileTargets.add(ct.asStringValue());
                }
            }
        }
        if (resDefn != null && this.isUsed(resDefn, valueDefn, partDefn)) {
            for (ElementDefinition.TypeRefComponent tr : resDefn.current().getType()) {
                t = tr.getWorkingCode();
                profileTypes.add(t);
                for (CanonicalType ct : tr.getProfile()) {
                    profileTargets.add(ct.asStringValue());
                }
                ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, nsp, allowedTypes.contains(t), "OPDEF_PROFILE_TYPE_NOT_IN_PARAMS", use, paramName, t, CommaSeparatedStringBuilder.join2((String)",", (String)" and ", allowedTypes)) && ok;
            }
        }
        for (String t2 : allowedTypes) {
            ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, nsp, profileTypes.contains(t2), "OPDEF_PROFILE_TYPE_NOT_IN_PROFILE", use, paramName, t2, CommaSeparatedStringBuilder.join2((String)",", (String)" and ", profileTypes)) && ok;
        }
        for (String t2 : allowedTargets) {
            ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, nsp, profileTargets.contains(t2), "OPDEF_PROFILE_PROFILE_NOT_IN_PARAMS", use, paramName, t2, CommaSeparatedStringBuilder.join2((String)",", (String)" and ", profileTargets)) && ok;
        }
        for (String t2 : profileTargets) {
            ok = this.rule(errors, "2025-04-08", ValidationMessage.IssueType.INVALID, nsp, allowedTargets.contains(t2), "OPDEF_PROFILE_PROFILE_NOT_IN_PROFILE", use, paramName, t2, CommaSeparatedStringBuilder.join2((String)",", (String)" and ", allowedTargets)) && ok;
        }
        return ok;
    }

    private boolean isUsed(DefinitionNavigator focus, DefinitionNavigator other1, DefinitionNavigator other2) {
        if ("0".equals(focus.current().getMax())) {
            return false;
        }
        if (other1.current().getMin() > 0) {
            return false;
        }
        return other2.current().getMin() <= 0;
    }

    private int parseMax(String max) {
        if ("*".equals(max)) {
            return Integer.MAX_VALUE;
        }
        return Utilities.parseInt((String)max, (int)-1);
    }

    private Element getParamByName(List<Element> params, String paramName, String use) {
        for (Element p : params) {
            if (!paramName.equals(p.getNamedChildValue("name")) || !use.equals(p.getNamedChildValue("use"))) continue;
            return p;
        }
        return null;
    }
}

