/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.utils.TypesUtilities;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.EnumInfo;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;
import org.hl7.fhir.validation.codegen.TypeInfo;

public class JavaResourceGenerator
extends JavaBaseGenerator {
    private JavaGenClass clss;
    private String allfields;
    private long hashSum;

    public JavaResourceGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void generate(Analysis analysis) throws Exception {
        String string;
        Object hierarchy;
        this.clss = analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE ? JavaGenClass.Resource : JavaGenClass.Type;
        this.write("package " + this.packageName + ";\r\n");
        this.startMark(this.version, this.genDate);
        boolean hl = true;
        boolean hh = this.hasXhtml(analysis.getStructure().getSnapshot().getElement());
        boolean hd = this.hasDecimal(analysis.getStructure().getSnapshot().getElement());
        boolean hs = this.hasString(analysis.getStructure().getSnapshot().getElement());
        boolean he = this.hasSharedEnums(analysis.getStructure().getSnapshot().getElement());
        boolean hn = this.hasNestedTypes(analysis.getStructure().getSnapshot().getElement());
        if (hl || hh || hd || he) {
            if (hl) {
                this.write("import java.util.ArrayList;\r\n");
                this.write("import java.util.Date;\r\n");
                this.write("import java.util.List;\r\n");
            } else {
                this.write("import java.util.Date;\r\n");
            }
            if (hh) {
                this.write("import org.hl7.fhir.utilities.xhtml.NodeType;\r\n");
                this.write("import org.hl7.fhir.utilities.xhtml.XhtmlNode;\r\n");
            }
            if (hd) {
                this.write("import java.math.*;\r\n");
            }
            if (hs) {
                this.write("import org.hl7.fhir.utilities.Utilities;\r\n");
            }
            if (he) {
                this.write("import " + this.packageName + ".Enumerations.*;\r\n");
            }
        }
        this.write("import org.hl7.fhir.exceptions.FHIRException;\r\n");
        this.write("import org.hl7.fhir.r5.model.*;\r\n");
        this.write("import org.hl7.fhir.instance.model.api.ICompositeType;\r\n");
        if (this.clss == JavaGenClass.Resource) {
            this.write("import ca.uhn.fhir.model.api.annotation.ResourceDef;\r\n");
            this.write("import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;\r\n");
        }
        if (this.clss == JavaGenClass.Resource || "BackboneElement".equals(analysis.getName()) || "BackboneType".equals(analysis.getName())) {
            this.write("import org.hl7.fhir.instance.model.api.IBaseBackboneElement;\r\n");
            this.write("import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;\r\n");
        }
        this.write("import ca.uhn.fhir.model.api.annotation.Child;\r\n");
        this.write("import ca.uhn.fhir.model.api.annotation.ChildOrder;\r\n");
        if (this.clss != JavaGenClass.Resource) {
            this.write("import ca.uhn.fhir.model.api.annotation.DatatypeDef;\r\n");
        }
        this.write("import ca.uhn.fhir.model.api.annotation.Description;\r\n");
        this.write("import ca.uhn.fhir.model.api.annotation.Block;\r\n");
        this.write("\r\n");
        if (this.config.getIni().hasProperty("imports", analysis.getName())) {
            for (String imp : this.config.getIni().getStringProperty("imports", analysis.getName()).split("\\,")) {
                this.write("import " + imp.replace("{{pid}}", this.packageName) + ";\r\n");
            }
        }
        this.jdoc("", this.replaceTitle(analysis.getName(), analysis.getStructure().getDescription()));
        TypeInfo ti = analysis.getRootType();
        boolean hasChildren = ti.getChildren().size() > 0;
        String superName = analysis.getAncestor() == null ? null : analysis.getAncestor().getName();
        Object object = hierarchy = analysis.getAncestor() != null ? "extends " + this.fixExtendsName(superName) : "extends LogicalBase";
        if (this.clss == JavaGenClass.Resource) {
            if (!analysis.isAbstract()) {
                this.write("@ResourceDef(name=\"" + this.upFirst(analysis.getName()).replace("ListResource", "List") + "\", profile=\"http://hl7.org/fhir/StructureDefinition/" + this.upFirst(analysis.getName()) + "\")\r\n");
            }
        } else {
            this.write("@DatatypeDef(name=\"" + this.upFirst(analysis.getName()) + "\")\r\n");
            hierarchy = (String)hierarchy + " implements ICompositeType";
        }
        if (this.config.getIni().hasProperty("hierarchy", analysis.getName())) {
            Iterator<TypeInfo> h = this.config.getIni().getStringProperty("hierarchy", analysis.getName());
            if (analysis.getAncestor() != null) {
                h = ((String)((Object)h)).replace("{{super}}", superName);
            }
            hierarchy = h;
        }
        this.write("public " + (analysis.isAbstract() ? "abstract " : "") + "class " + analysis.getClassName() + " " + ((String)hierarchy).trim() + " {\r\n");
        this.write("\r\n");
        for (String string2 : this.sorted(analysis.getEnums().keySet())) {
            EnumInfo enumInfo = analysis.getEnums().get(string2);
            this.generateEnum(enumInfo);
        }
        for (TypeInfo typeInfo : analysis.getTypeList()) {
            this.generateType(analysis, typeInfo);
        }
        this.allfields = "";
        int i = 0;
        for (ElementDefinition elementDefinition : ti.getChildren()) {
            if (analysis.isInterface()) continue;
            this.generateField(analysis, ti, elementDefinition, "    ", i++);
        }
        this.write("    private static final long serialVersionUID = " + Long.toString(this.allfields.hashCode()) + "L;\r\n\r\n");
        this.hashSum += (long)this.allfields.hashCode();
        ArrayList<ElementDefinition> arrayList = new ArrayList<ElementDefinition>();
        this.generateConstructor(analysis.getClassName(), arrayList, "  ");
        if (hasChildren) {
            for (ElementDefinition elementDefinition : ti.getChildren()) {
                if (elementDefinition.getMin() <= 0) continue;
                arrayList.add(elementDefinition);
            }
            if (arrayList.size() > 0) {
                this.generateConstructor(analysis.getClassName(), arrayList, "  ");
            }
            this.generateTypeSpecificConstructors(analysis.getClassName());
            for (ElementDefinition elementDefinition : ti.getChildren()) {
                if (analysis.isInterface()) {
                    this.generateAbstractAccessors(analysis, ti, elementDefinition, "    ");
                    continue;
                }
                this.generateAccessors(analysis, ti, elementDefinition, "    ", this.matchingInheritedElement(ti.getInheritedChildren(), elementDefinition, analysis.getName()));
            }
            if (!analysis.isInterface() && ti.getInheritedChildren() != null) {
                for (ElementDefinition elementDefinition : this.filterInherited(ti.getInheritedChildren(), ti.getChildren())) {
                    this.generateUnimplementedAccessors(analysis, ti, elementDefinition, "    ");
                }
            }
            this.generateChildrenRegister(analysis, ti, "    ");
            this.generatePropertyGetterId(analysis, ti, "    ");
            this.generatePropertySetterId(analysis, ti, "    ");
            this.generatePropertySetterName(analysis, ti, "    ");
            this.generatePropertyMaker(analysis, ti, "    ");
            this.generatePropertyTypeGetter(analysis, ti, "    ");
            this.generateChildAdder(analysis, ti, "    ");
        }
        this.generateFhirType(analysis.getName());
        this.generateCopy(analysis, ti, false);
        if (hasChildren) {
            this.generateEquals(analysis, ti, false);
            this.generateIsEmpty(analysis, ti, false);
        }
        if ((this.clss == JavaGenClass.Resource || Utilities.existsInList((String)superName, (String[])new String[]{"Resource", "DomainResource"})) && !analysis.isAbstract()) {
            this.write("  @Override\r\n");
            this.write("  public ResourceType getResourceType() {\r\n");
            this.write("    return ResourceType.Custom;\r\n");
            this.write("   }\r\n");
            this.write("\r\n");
            this.write("  public String getCustomResourceName() {\r\n");
            this.write("    return \"" + analysis.getName() + "\";\r\n");
            this.write("   }\r\n");
            this.write("\r\n");
        } else if (analysis.isAbstract() && analysis.getAncestor() != null && Utilities.noString((String)superName)) {
            this.write("\r\n");
            this.write("  @Override\r\n");
            this.write("  public String getIdBase() {\r\n");
            this.write("    return getId();\r\n");
            this.write("  }\r\n");
            this.write("  \r\n");
            this.write("  @Override\r\n");
            this.write("  public void setIdBase(String value) {\r\n");
            this.write("    setId(value);\r\n");
            this.write("  }\r\n");
            this.write("  public abstract ResourceType getResourceType();\r\n");
        } else if (analysis.isAbstract() && analysis.getAncestor() != null && Utilities.noString((String)superName)) {
            this.write("  @Override\r\n");
            this.write("  public String getIdBase() {\r\n");
            this.write("    return getId();\r\n");
            this.write("  }\r\n");
            this.write("  \r\n");
            this.write("  @Override\r\n");
            this.write("  public void setIdBase(String value) {\r\n");
            this.write("    setId(value);\r\n");
            this.write("  }\r\n");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (SearchParameter sp : analysis.getSearchParams()) {
            String code = sp.getCode();
            if (hashSet.contains(code)) continue;
            hashSet.add(code);
            if (sp.getType() == Enumerations.SearchParamType.COMPOSITE) {
                if (code.endsWith("-[x]")) {
                    String partialCode = code.substring(0, code.length() - 4);
                    partialCode = partialCode.substring(partialCode.lastIndexOf(45) + 1);
                    String rootCode = code.substring(0, code.indexOf("-" + partialCode));
                    for (SearchParameter nextCandidate : analysis.getSearchParams()) {
                        if (!nextCandidate.getCode().startsWith(partialCode)) continue;
                        String nextCompositeCode = rootCode + "-" + nextCandidate.getCode();
                        String[] compositeOf = new String[]{rootCode, nextCandidate.getCode()};
                        this.writeSearchParameterField(analysis.getName(), this.clss, analysis.isAbstract(), sp, nextCompositeCode, compositeOf, analysis.getSearchParams(), analysis.getName());
                    }
                    continue;
                }
                SearchParameter comp0 = (SearchParameter)this.definitions.getSearchParams().get(((SearchParameter.SearchParameterComponentComponent)sp.getComponent().get(0)).getDefinition());
                SearchParameter comp1 = (SearchParameter)this.definitions.getSearchParams().get(((SearchParameter.SearchParameterComponentComponent)sp.getComponent().get(1)).getDefinition());
                if (comp0 == null || comp1 == null) continue;
                String[] compositeOf = new String[]{comp0.getCode(), comp1.getCode()};
                this.writeSearchParameterField(analysis.getName(), this.clss, analysis.isAbstract(), sp, sp.getCode(), compositeOf, analysis.getSearchParams(), analysis.getName());
                continue;
            }
            if (code.contains("[x]")) {
                throw new Exception("Unable to generate constant for search parameter: " + code);
            }
            this.writeSearchParameterField(analysis.getName(), this.clss, analysis.isAbstract(), sp, code, null, analysis.getSearchParams(), analysis.getName());
        }
        if (VersionUtilities.isR4BVer((String)this.version) && !Utilities.noString((String)(string = this.config.getIni().getStringProperty("R4B.NullImplementation", analysis.getName())))) {
            for (String n : string.split("\\,")) {
                String t = n.substring(n.indexOf(":") + 1);
                if ((n = n.substring(0, n.indexOf(":"))).endsWith("[]")) {
                    n = Utilities.capitalize((String)n.substring(0, n.length() - 2));
                    this.write("      @Override\r\n");
                    this.write("      public List<" + t + "> get" + n + "() {\r\n");
                    this.write("        return new ArrayList<>();\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public CanonicalResource set" + n + "(List<" + t + "> the" + n + ") {\r\n");
                    this.write("        return this;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public boolean has" + n + "() {\r\n");
                    this.write("        return false;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public " + t + " add" + n + "() {\r\n");
                    this.write("\t        return null;\r\n");
                    this.write("\t      }\r\n");
                    this.write("\t      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public CanonicalResource add" + n + "(" + t + " t) {\r\n");
                    this.write("        return null;\r\n");
                    this.write("\t      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public " + t + " get" + n + "FirstRep() {\r\n");
                    this.write("        return new " + t + "();\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    continue;
                }
                if (t.contains("|")) {
                    n = Utilities.capitalize((String)n);
                    String t1 = t.substring(0, t.indexOf("|"));
                    String t2 = t.substring(t.indexOf("|") + 1);
                    this.write("      @Override\r\n");
                    this.write("      public " + t1 + " get" + n + "() {\r\n");
                    if ("boolean".equals(t1)) {
                        this.write("        return false;\r\n");
                    } else {
                        this.write("        return new " + t1 + "();\r\n");
                    }
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public " + t2 + " get" + n + "Element() {\r\n");
                    this.write("        return new " + t2 + "();\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public CanonicalResource set" + n + "(" + t1 + " the" + n + ") {\r\n");
                    this.write("        return this;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public CanonicalResource set" + n + "Element(" + t2 + " the" + n + ") {\r\n");
                    this.write("        return this;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public boolean has" + n + "() {\r\n");
                    this.write("        return false;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      @Override\r\n");
                    this.write("      public boolean has" + n + "Element() {\r\n");
                    this.write("        return false;\r\n");
                    this.write("      }\r\n");
                    this.write("      \r\n");
                    this.write("      \r\n");
                    continue;
                }
                n = Utilities.capitalize((String)n);
                this.write("      @Override\r\n");
                this.write("      public " + t + " get" + n + "() {\r\n");
                this.write("        return new " + t + "();\r\n");
                this.write("      }\r\n");
                this.write("      \r\n");
                this.write("      @Override\r\n");
                this.write("      public CanonicalResource set" + n + "(" + t + " the" + n + ") {\r\n");
                this.write("        return this;\r\n");
                this.write("      }\r\n");
                this.write("      \r\n");
                this.write("      @Override\r\n");
                this.write("      public boolean has" + n + "() {\r\n");
                this.write("        return false;\r\n");
                this.write("      }\r\n");
                this.write("      \r\n");
                this.write("      @Override\r\n");
                this.write("      public boolean has" + n + "Element() {\r\n");
                this.write("        return false;\r\n");
                this.write("      }\r\n");
                this.write("      \r\n");
                this.write("      \r\n");
            }
        }
        if (this.config.getAdornments().containsKey(analysis.getClassName())) {
            this.write("// Manual code (from Configuration.txt):\r\n");
            this.write(this.config.getAdornments().get(analysis.getClassName()) + "\r\n");
            this.write("// end addition\r\n");
        }
        this.write("\r\n");
        this.write("}\r\n");
        this.write("\r\n");
        this.flush();
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    private List<ElementDefinition> filterInherited(List<ElementDefinition> inherited, List<ElementDefinition> children) {
        ArrayList<ElementDefinition> res = new ArrayList<ElementDefinition>();
        for (ElementDefinition t : inherited) {
            if (this.hasMatchingChild(children, t)) continue;
            res.add(t);
        }
        return res;
    }

    private boolean hasMatchingChild(List<ElementDefinition> children, ElementDefinition m) {
        String mtail = m.getPath().substring(m.getPath().indexOf("."));
        for (ElementDefinition t : children) {
            String ttail = t.getPath().substring(t.getPath().indexOf("."));
            if (!ttail.equals(mtail)) continue;
            return true;
        }
        return false;
    }

    private void writeSearchParameterField(String name, JavaGenClass clss, boolean isAbstract, SearchParameter sp, String code, String[] theCompositeOf, List<SearchParameter> searchParams, String rn) throws IOException {
        String constName = this.cleanSpName(code).toUpperCase();
        this.write(" /**\r\n");
        this.write("   * Search parameter: <b>" + code + "</b>\r\n");
        this.write("   * <p>\r\n");
        this.write("   * Description: <b>" + sp.getDescription() + "</b><br>\r\n");
        this.write("   * Type: <b>" + sp.getType().toCode() + "</b><br>\r\n");
        this.write("   * Path: <b>" + sp.getExpression() + "</b><br>\r\n");
        this.write("   * </p>\r\n");
        this.write("   */\r\n");
        this.write("  @SearchParamDefinition(name=\"" + code + "\", path=\"" + this.defaultString(sp.getExpression()) + "\", description=\"" + Utilities.escapeJava((String)sp.getDescription()) + "\", type=\"" + sp.getType().toCode() + "\"");
        if (theCompositeOf != null && theCompositeOf.length > 0) {
            this.write(", compositeOf={");
            for (int i = 0; i < theCompositeOf.length; ++i) {
                if (i > 0) {
                    this.write(", ");
                }
                this.write("\"" + theCompositeOf[i] + "\"");
            }
            this.write("}");
        }
        TreeSet<String> providesMembershipIn = new TreeSet<String>();
        for (Object next : this.definitions.getCompartments().getList()) {
            for (CompartmentDefinition.CompartmentDefinitionResourceComponent nextEntry : next.getResource()) {
                if (!nextEntry.getCode().equals(this.upFirst(name))) continue;
                for (StringType nextPart : nextEntry.getParam()) {
                    if (!nextPart.toString().equals(code)) continue;
                    providesMembershipIn.add(next.getName());
                }
            }
        }
        if (providesMembershipIn.size() > 0) {
            this.write(", providesMembershipIn={ ");
            boolean first = true;
            for (String next : providesMembershipIn) {
                if (first) {
                    first = false;
                } else {
                    this.write(", ");
                }
                this.write("@ca.uhn.fhir.model.api.annotation.Compartment(name=\"" + this.upFirst(next) + "\")");
            }
            this.write(" }");
        }
        TreeSet<String> targets = new TreeSet<String>();
        for (Object c : sp.getTarget()) {
            targets.add(c.getCode());
        }
        if (targets != null && !targets.isEmpty() && !targets.contains("Any")) {
            this.write(", target={");
            boolean first = true;
            for (String nextTarget : targets) {
                if (first) {
                    first = false;
                } else {
                    this.write(", ");
                }
                this.write("List".equals(nextTarget) ? "ListResource" : nextTarget);
                this.write(".class");
            }
            this.write(" }");
        }
        this.write(" )\r\n");
        this.write("  public static final String SP_" + constName + " = \"" + code + "\";\r\n");
        Object genericTypes = "";
        if (theCompositeOf != null && theCompositeOf.length > 0) {
            SearchParameter typeDef0 = this.findSearchParam(searchParams, theCompositeOf[0]);
            SearchParameter typeDef1 = this.findSearchParam(searchParams, theCompositeOf[1]);
            genericTypes = "<ca.uhn.fhir.rest.gclient." + this.upFirst(typeDef0.getType().toCode()) + "ClientParam, ca.uhn.fhir.rest.gclient." + this.upFirst(typeDef1.getType().toCode()) + "ClientParam>";
        }
        this.write(" /**\r\n");
        this.write("   * <b>Fluent Client</b> search parameter constant for <b>" + code + "</b>\r\n");
        this.write("   * <p>\r\n");
        this.write("   * Description: <b>" + sp.getDescription() + "</b><br>\r\n");
        this.write("   * Type: <b>" + sp.getType().toCode() + "</b><br>\r\n");
        this.write("   * Path: <b>" + sp.getExpression() + "</b><br>\r\n");
        this.write("   * </p>\r\n");
        this.write("   */\r\n");
        this.write("  public static final ca.uhn.fhir.rest.gclient." + this.upFirst(sp.getType().toCode()) + "ClientParam" + (String)genericTypes + " " + constName + " = new ca.uhn.fhir.rest.gclient." + this.upFirst(sp.getType().toCode()) + "ClientParam" + (String)genericTypes + "(SP_" + constName + ");\r\n\r\n");
        if (sp.getType() == Enumerations.SearchParamType.REFERENCE && clss == JavaGenClass.Resource && !isAbstract) {
            String incName = this.upFirst(name) + ":" + code;
            this.write("/**\r\n");
            this.write("   * Constant for fluent queries to be used to add include statements. Specifies\r\n");
            this.write("   * the path value of \"<b>" + incName + "</b>\".\r\n");
            this.write("   */\r\n");
            this.write("  public static final ca.uhn.fhir.model.api.Include INCLUDE_" + this.cleanSpName(code).toUpperCase() + " = new ca.uhn.fhir.model.api.Include(\"" + incName + "\").toLocked();\r\n\r\n");
        }
    }

    private SearchParameter findSearchParam(List<SearchParameter> searchParams, String code) {
        for (SearchParameter sp : searchParams) {
            if (!sp.getCode().equals(code)) continue;
            return sp;
        }
        return null;
    }

    private String defaultString(String expression) {
        return expression == null ? "" : expression;
    }

    private void generateTypeSpecificConstructors(String theName) throws IOException {
        if ("Coding".equals(theName)) {
            this.write("    /**\r\n");
            this.write("     * Convenience constructor\r\n");
            this.write("     * \r\n");
            this.write("     * @param theSystem The {@link #setSystem(String) code system}\r\n");
            this.write("     * @param theCode The {@link #setCode(String) code}\r\n");
            this.write("     * @param theDisplay The {@link #setDisplay(String) human readable display}\r\n");
            this.write("     */\r\n");
            this.write("      public Coding(String theSystem, String theCode, String theDisplay) {\r\n");
            this.write("        setSystem(theSystem);\r\n");
            this.write("        setCode(theCode);\r\n");
            this.write("        setDisplay(theDisplay);\r\n");
            this.write("      }\r\n");
        }
        if ("Extension".equals(theName)) {
            this.write("    /**\r\n");
            this.write("     * Constructor\r\n");
            this.write("     */\r\n");
            this.write("    public Extension(String theUrl, IBaseDatatype theValue) {\r\n");
            this.write("      setUrl(theUrl);\r\n");
            this.write("      setValue(theValue);\r\n");
            this.write("    }\r\n");
            this.write("\r\n");
        } else if ("Reference".equals(theName)) {
            this.write("    /**\r\n");
            this.write("     * Constructor\r\n");
            this.write("     * \r\n");
            this.write("     * @param theReference The given reference string (e.g. \"Patient/123\" or \"http://example.com/Patient/123\")\r\n");
            this.write("     */\r\n");
            this.write("    public Reference(String theReference) {\r\n");
            this.write("      super(theReference);\r\n");
            this.write("    }\r\n");
            this.write("\r\n");
            this.write("    /**\r\n");
            this.write("     * Constructor\r\n");
            this.write("     * \r\n");
            this.write("     * @param theReference The given reference as an IdType (e.g. \"Patient/123\" or \"http://example.com/Patient/123\")\r\n");
            this.write("     */\r\n");
            this.write("    public Reference(IIdType theReference) {\r\n");
            this.write("      super(theReference);\r\n");
            this.write("    }\r\n");
            this.write("\r\n");
            this.write("    /**\r\n");
            this.write("     * Constructor\r\n");
            this.write("     * \r\n");
            this.write("     * @param theResource The resource represented by this reference\r\n");
            this.write("     */\r\n");
            this.write("    public Reference(IAnyResource theResource) {\r\n");
            this.write("      super(theResource);\r\n");
            this.write("    }\r\n");
            this.write("\r\n");
        } else if ("Quantity".equals(theName)) {
            this.write(" /**\r\n");
            this.write("   * Convenience constructor\r\n");
            this.write("   * \r\n");
            this.write("   * @param theValue The {@link #setValue(double) value}\r\n");
            this.write("   */\r\n");
            this.write("  public Quantity(double theValue) {\r\n");
            this.write("    setValue(theValue);\r\n");
            this.write("  }\r\n");
            this.write("\r\n");
            this.write("  /**\r\n");
            this.write("   * Convenience constructor\r\n");
            this.write("   * \r\n");
            this.write("   * @param theValue The {@link #setValue(long) value}\r\n");
            this.write("   */\r\n");
            this.write("  public Quantity(long theValue) {\r\n");
            this.write("    setValue(theValue);\r\n");
            this.write("  }\r\n");
            this.write("  \r\n");
            this.write("  /**\r\n");
            this.write("   * Convenience constructor\r\n");
            this.write("   * \r\n");
            this.write("   * @param theComparator The {@link #setComparator(QuantityComparator) comparator}\r\n");
            this.write("   * @param theValue The {@link #setValue(BigDecimal) value}\r\n");
            this.write("   * @param theSystem The {@link #setSystem(String)} (the code system for the units}\r\n");
            this.write("   * @param theCode The {@link #setCode(String)} (the code for the units}\r\n");
            this.write("   * @param theUnit The {@link #setUnit(String)} (the human readable display name for the units}\r\n");
            this.write("   */\r\n");
            this.write("  public Quantity(QuantityComparator theComparator, double theValue, String theSystem, String theCode, String theUnit) {\r\n");
            this.write("    setValue(theValue);\r\n");
            this.write("    setComparator(theComparator);\r\n");
            this.write("    setSystem(theSystem);\r\n");
            this.write("    setCode(theCode);\r\n");
            this.write("    setUnit(theUnit);\r\n");
            this.write("  }\r\n");
            this.write("\r\n");
            this.write("  /**\r\n");
            this.write("   * Convenience constructor\r\n");
            this.write("   * \r\n");
            this.write("   * @param theComparator The {@link #setComparator(QuantityComparator) comparator}\r\n");
            this.write("   * @param theValue The {@link #setValue(BigDecimal) value}\r\n");
            this.write("   * @param theSystem The {@link #setSystem(String)} (the code system for the units}\r\n");
            this.write("   * @param theCode The {@link #setCode(String)} (the code for the units}\r\n");
            this.write("   * @param theUnit The {@link #setUnit(String)} (the human readable display name for the units}\r\n");
            this.write("   */\r\n");
            this.write("  public Quantity(QuantityComparator theComparator, long theValue, String theSystem, String theCode, String theUnit) {\r\n");
            this.write("    setValue(theValue);\r\n");
            this.write("    setComparator(theComparator);\r\n");
            this.write("    setSystem(theSystem);\r\n");
            this.write("    setCode(theCode);\r\n");
            this.write("    setUnit(theUnit);\r\n");
            this.write("  }\r\n");
            this.write("");
        }
    }

    private void generateFhirType(String path) throws IOException {
        this.write("  public String fhirType() {\r\n");
        this.write("    return \"" + path + "\";\r\n\r\n");
        this.write("  }\r\n\r\n");
    }

    private String cleanSpName(String code) {
        StringBuilder b = new StringBuilder();
        for (char c : code.toCharArray()) {
            if (Character.isLetter(c)) {
                b.append(c);
                continue;
            }
            if (c != '-') continue;
            b.append('_');
        }
        return b.toString();
    }

    private String pipeSeparate(List<String> paths) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String p : paths) {
            if (first) {
                first = false;
            } else {
                b.append("|");
            }
            b.append(p);
        }
        return b.toString();
    }

    private void jdoc(String indent, String text) throws IOException {
        this.write(indent + "/**\r\n");
        this.write(indent + " * " + text + "\r\n");
        this.write(indent + " */\r\n");
    }

    private void generateChildrenRegister(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        String rn = analysis.getName();
        boolean isInterface = analysis.isInterface();
        List<ElementDefinition> children = ti.getChildren();
        this.write(indent + "  protected void listChildren(List<Property> children) {\r\n");
        this.write(indent + "    super.listChildren(children);\r\n");
        for (ElementDefinition e : children) {
            if (isInterface || e.typeSummary().equals("xhtml")) continue;
            this.write(indent + "    children.add(new Property(\"" + e.getName() + "\", \"" + this.resolvedTypeCode(e) + "\", \"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\", 0, " + (e.unbounded() ? "java.lang.Integer.MAX_VALUE" : e.getMax()) + ", " + this.getElementName(e.getName(), true) + "));\r\n");
        }
        this.write(indent + "  }\r\n\r\n");
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {\r\n");
        this.write(indent + "    switch (_hash) {\r\n");
        for (ElementDefinition e : children) {
            if (isInterface || e.typeSummary().equals("xhtml")) continue;
            this.write(indent + "    case " + this.propId(e.getName()) + ": /*" + e.getName() + "*/ ");
            this.write(" return new Property(\"" + e.getName() + "\", \"" + this.resolvedTypeCode(e) + "\", \"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\", 0, " + (e.unbounded() ? "java.lang.Integer.MAX_VALUE" : e.getMax()) + ", " + this.getElementName(e.getName(), true) + ");\r\n");
            if (!e.getName().endsWith("[x]")) continue;
            String n = e.getName().substring(0, e.getName().length() - 3);
            this.write(indent + "    case " + this.propId(n) + ": /*" + n + "*/ ");
            this.write(" return new Property(\"" + e.getName() + "\", \"" + this.resolvedTypeCode(e) + "\", \"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\", 0, " + (e.unbounded() ? "java.lang.Integer.MAX_VALUE" : e.getMax()) + ", " + this.getElementName(e.getName(), true) + ");\r\n");
            if (e.typeSummary().equals("*")) {
                for (String t : new String[]{"base64Binary", "boolean", "canonical", "code", "date", "dateTime", "decimal", "id", "instant", "integer", "integer64", "markdown", "oid", "positiveInt", "string", "time", "unsignedInt", "uri", "url", "uuid", "Address", "Annotation", "Attachment", "CodeableConcept", "Coding", "ContactPoint", "HumanName", "Identifier", "Period", "Quantity", "Range", "Ratio", "Reference", "SampledData", "Signature", "Timing", "Dosage"}) {
                    String tn = n + Utilities.capitalize((String)t);
                    this.write(indent + "    case " + this.propId(tn) + ": /*" + tn + "*/ ");
                    this.write(" return new Property(\"" + e.getName() + "\", \"" + this.resolvedTypeCode(e, t) + "\", \"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\", 0, " + (e.unbounded() ? "java.lang.Integer.MAX_VALUE" : e.getMax()) + ", " + this.getElementName(e.getName(), true) + ");\r\n");
                }
                continue;
            }
            for (ElementDefinition.TypeRefComponent tr : e.getType()) {
                String tn = n + Utilities.capitalize((String)this.checkConstraint(tr.getCode()));
                this.write(indent + "    case " + this.propId(tn) + ": /*" + tn + "*/ ");
                this.write(" return new Property(\"" + e.getName() + "\", \"" + this.resolvedTypeCode(e, tr.getCode()) + "\", \"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\", 0, " + (e.unbounded() ? "java.lang.Integer.MAX_VALUE" : e.getMax()) + ", " + this.getElementName(e.getName(), true) + ");\r\n");
            }
        }
        this.write(indent + "    default: return super.getNamedProperty(_hash, _name, _checkValid);\r\n");
        this.write(indent + "    }\r\n\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private String resolvedTypeCode(ElementDefinition e) {
        return this.resolvedTypeCode(e, null);
    }

    private String resolvedTypeCode(ElementDefinition e, String tf) {
        if (e.hasContentReference()) {
            return e.getContentReference().replace("#", "@");
        }
        StringBuilder tn = new StringBuilder();
        boolean first = true;
        for (ElementDefinition.TypeRefComponent t : e.getType()) {
            if (tf != null && !t.getWorkingCode().equals(tf) || Utilities.existsInList((String)t.getWorkingCode(), (String[])new String[]{"Element", "BackboneElement"})) continue;
            if (!first) {
                tn.append("|");
            }
            first = false;
            tn.append(t.getWorkingCode());
            if (!t.hasTargetProfile()) continue;
            tn.append("(");
            boolean f = true;
            for (CanonicalType s : t.getTargetProfile()) {
                if (!f) {
                    tn.append("|");
                }
                f = false;
                String stn = s.asStringValue().substring(40);
                tn.append("Resource".equals(stn) ? "Any" : stn);
            }
            tn.append(")");
        }
        return tn.toString();
    }

    private void generatePropertyMaker(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        List<ElementDefinition> inheritedChildren = ti.getInheritedChildren();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Base makeProperty(int hash, String name) throws FHIRException {\r\n");
        this.write(indent + "    switch (hash) {\r\n");
        for (ElementDefinition e : children) {
            if (isInterface) continue;
            ElementDefinition inh = inheritedChildren == null ? null : this.matchingInheritedElement(inheritedChildren, e, analysis.getName());
            String tn = e.getUserString("java.type");
            if (!e.typeSummary().equals("xhtml")) {
                this.genPropMaker(indent, e, tn, e.getName(), inh);
            } else {
                this.write(indent + "    case " + this.propId("div") + ": /*div*/\r\n");
                this.write("          if (div == null)\r\n");
                this.write("            div = new XhtmlNode(NodeType.Element, \"div\");\r\n");
                this.write("          return new StringType(new org.hl7.fhir.utilities.xhtml.XhtmlComposer(true).composeEx(this.div));\r\n");
            }
            if (!e.getName().endsWith("[x]")) continue;
            this.genPropMaker(indent, e, tn, e.getName().replace("[x]", ""), inh);
        }
        this.write(indent + "    default: return super.makeProperty(hash, name);\r\n");
        this.write(indent + "    }\r\n\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private void genPropMaker(String indent, ElementDefinition e, String tn, String elementname, ElementDefinition inh) throws IOException {
        this.write(indent + "    case " + this.propId(elementname) + ": ");
        String name = e.getName().replace("[x]", "");
        if (this.isPrimitive(e.typeSummary()) || e.getType().size() == 1 && e.typeSummary().startsWith("canonical(")) {
            if (e.unbounded()) {
                this.write(" return add" + this.upFirst(this.getElementName(name, false)) + "Element();\r\n");
            } else if ("Reference.reference".equals(e.getPath()) && "Reference".equals(this.upFirst(this.getElementName(name, false)))) {
                this.write(" return get" + this.upFirst(this.getElementName(name, false)) + "Element_();\r\n");
            } else {
                this.write(" return get" + this.upFirst(this.getElementName(name, false)) + "Element();\r\n");
            }
        } else if (e.typeSummary().equals("Resource") || e.typeSummary().equals("DomainResource")) {
            this.write("throw new FHIRException(\"Cannot make property " + e.getName() + " as it is not a complex type\"); // " + tn + "\r\n");
        } else if (e.unbounded()) {
            this.write(" return add" + this.upFirst(this.getElementName(name, false)) + "(); \r\n");
        } else if (inh != null && inh.unbounded()) {
            this.write(" return get" + this.upFirst(this.getElementName(name, false)) + "FirstRep();\r\n");
        } else {
            this.write(" return get" + this.upFirst(this.getElementName(name, false)) + "();\r\n");
        }
    }

    private void generatePropertySetterName(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Base setProperty(String name, Base value) throws FHIRException {\r\n");
        boolean first = true;
        for (ElementDefinition e : children) {
            if (isInterface) continue;
            String tn = e.getUserString("java.type");
            if (first) {
                this.write(indent + "    ");
            } else {
                this.write(indent + "    } else ");
            }
            first = false;
            this.write("if (name.equals(\"" + e.getName() + "\")) {\r\n");
            String name = e.getName().replace("[x]", "");
            Object cn = "(" + tn + ") value";
            if (!Utilities.existsInList((String)e.typeSummary(), (String[])new String[]{"Element", "BackboneElement"})) {
                if (e.typeSummary().equals("xhtml")) {
                    cn = "TypeConvertor.castToXhtml(value)";
                } else if (tn.contains("Enumeration<")) {
                    this.write(indent + "      value = new " + tn.substring(tn.indexOf("<") + 1, tn.length() - 1) + "EnumFactory().fromType(TypeConvertor.castToCode(value));\r\n");
                    cn = "(Enumeration) value";
                } else if (e.getType().size() == 1 && !e.typeSummary().equals("*") && !((ElementDefinition.TypeRefComponent)e.getType().get(0)).getCode().startsWith("@")) {
                    StructureDefinition sd = this.definitions.getContext().fetchTypeDefinition(e.getTypeFirstRep().getCode());
                    String tnn = this.checkConstraint(this.getTypeName(e));
                    if (!this.isCoreType(sd) || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
                        cn = "(" + this.upFirst(tn) + ") value";
                    } else if ("Base".equals(tnn)) {
                        cn = "(" + tn + ") value";
                    } else if (this.definitions.getContext().getResourceNames().contains(tnn)) {
                        cn = "(" + tn + ") value";
                    } else {
                        cn = "TypeConvertor.castTo" + this.upFirst(tnn) + "(value)";
                        if (((String)cn).contains("Type(")) {
                            cn = ((String)cn).replace("Type(", "(");
                        }
                    }
                } else if (e.getType().size() > 0 && !((ElementDefinition.TypeRefComponent)e.getType().get(0)).getCode().startsWith("@")) {
                    cn = "TypeConvertor.castToType(value)";
                }
            }
            if (e.unbounded()) {
                this.write(indent + "      this.get" + this.upFirst(this.getElementName(name, false)) + "().add(" + (String)cn + "); // " + tn + "\r\n");
                continue;
            }
            this.write(indent + "      this." + this.getElementName(name, true) + " = " + (String)cn + "; // " + tn + "\r\n");
        }
        if (!first) {
            this.write(indent + "    } else\r\n");
        }
        this.write(indent + "      return super.setProperty(name, value);\r\n");
        if (!first) {
            this.write(indent + "    return value;\r\n");
        }
        this.write(indent + "  }\r\n\r\n");
    }

    private void generatePropertySetterId(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Base setProperty(int hash, String name, Base value) throws FHIRException {\r\n");
        this.write(indent + "    switch (hash) {\r\n");
        for (ElementDefinition e : children) {
            if (isInterface) continue;
            String tn = e.getUserString("java.type");
            String name = e.getName().replace("[x]", "");
            this.write(indent + "    case " + this.propId(name) + ": // " + name + "\r\n");
            Object cn = "(" + tn + ") value";
            if (!Utilities.existsInList((String)e.typeSummary(), (String[])new String[]{"Element", "BackboneElement"})) {
                if (e.typeSummary().equals("xhtml")) {
                    cn = "TypeConvertor.castToXhtml(value)";
                }
                if (tn.contains("Enumeration<")) {
                    this.write(indent + "      value = new " + tn.substring(tn.indexOf("<") + 1, tn.length() - 1) + "EnumFactory().fromType(TypeConvertor.castToCode(value));\r\n");
                    cn = "(Enumeration) value";
                } else if (e.getType().size() == 1 && !e.typeSummary().equals("*") && !((ElementDefinition.TypeRefComponent)e.getType().get(0)).getName().startsWith("@")) {
                    StructureDefinition sd = this.definitions.getContext().fetchTypeDefinition(e.getTypeFirstRep().getCode());
                    String tnn = this.checkConstraint(this.getTypeName(e));
                    if (!this.isCoreType(sd) || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
                        cn = "(" + this.upFirst(tn) + ") value";
                    } else if ("Base".equals(tnn)) {
                        cn = "(" + tn + ") value";
                    } else if (this.definitions.getContext().getResourceNames().contains(tnn)) {
                        cn = "(" + tn + ") value";
                    } else {
                        if (tnn.endsWith("Type")) {
                            tnn = tnn.substring(0, tnn.length() - 4);
                        }
                        cn = "TypeConvertor.castTo" + this.upFirst(tnn) + "(value)";
                    }
                } else if (e.getType().size() > 0 && !((ElementDefinition.TypeRefComponent)e.getType().get(0)).getCode().startsWith("@")) {
                    cn = "TypeConvertor.castToType(value)";
                }
            }
            if (e.unbounded()) {
                this.write(indent + "      this.get" + this.upFirst(this.getElementName(name, false)) + "().add(" + (String)cn + "); // " + tn + "\r\n");
            } else {
                this.write(indent + "      this." + this.getElementName(name, true) + " = " + (String)cn + "; // " + tn + "\r\n");
            }
            this.write(indent + "      return value;\r\n");
        }
        this.write(indent + "    default: return super.setProperty(hash, name, value);\r\n");
        this.write(indent + "    }\r\n\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private void generatePropertyGetterId(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {\r\n");
        this.write(indent + "    switch (hash) {\r\n");
        for (ElementDefinition e : children) {
            if (isInterface) continue;
            String tn = e.getUserString("java.type");
            String name = e.getName().replace("[x]", "");
            this.write(indent + "    case " + this.propId(name) + ": /*" + name + "*/ ");
            if (e.unbounded()) {
                this.write("return this." + this.getElementName(name, true) + " == null ? new Base[0] : this." + this.getElementName(name, true) + ".toArray(new Base[this." + this.getElementName(name, true) + ".size()]); // " + tn + "\r\n");
                continue;
            }
            if (e.typeSummary().equals("xhtml")) {
                this.write("return this." + this.getElementName(name, true) + " == null ? new Base[0] : new Base[] {new StringType(new org.hl7.fhir.utilities.xhtml.XhtmlComposer(true).composeEx(this." + this.getElementName(name, true) + "))}; // " + tn + "\r\n");
                continue;
            }
            this.write("return this." + this.getElementName(name, true) + " == null ? new Base[0] : new Base[] {this." + this.getElementName(name, true) + "}; // " + tn + "\r\n");
        }
        this.write(indent + "    default: return super.getProperty(hash, name, checkValid);\r\n");
        this.write(indent + "    }\r\n\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private void generatePropertyTypeGetter(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public String[] getTypesForProperty(int hash, String name) throws FHIRException {\r\n");
        this.write(indent + "    switch (hash) {\r\n");
        for (ElementDefinition e : children) {
            if (isInterface) continue;
            String name = e.getName().replace("[x]", "");
            this.write(indent + "    case " + this.propId(name) + ": /*" + name + "*/ ");
            if (e.hasContentReference()) {
                this.write("return new String[] {\"" + e.getContentReference().replace("#", "@") + "\"};\r\n");
                continue;
            }
            this.write("return new String[] {" + this.asCommaText(e.getType()) + "};\r\n");
        }
        this.write(indent + "    default: return super.getTypesForProperty(hash, name);\r\n");
        this.write(indent + "    }\r\n\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private String asCommaText(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        HashSet<String> tset = new HashSet<String>();
        for (ElementDefinition.TypeRefComponent t : types) {
            if (Utilities.existsInList((String)t.getWorkingCode(), (String[])new String[]{"Element", "BackboneElement"}) || tset.contains(t.getName())) continue;
            b.append("\"" + t.getName() + "\"");
            tset.add(t.getName());
        }
        return b.toString();
    }

    private String propId(String name) {
        return Integer.toString(name.hashCode());
    }

    private void generateChildAdder(Analysis analysis, TypeInfo ti, String indent) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        boolean isInterface = analysis.isInterface();
        String parent = ti.getDefn().getPath();
        this.write(indent + "  @Override\r\n");
        this.write(indent + "  public Base addChild(String name) throws FHIRException {\r\n");
        boolean first = true;
        for (ElementDefinition e : children) {
            if (isInterface || e.typeSummary().equals("xhtml")) continue;
            if (e.getType().size() <= 1 && !e.typeSummary().equals("*")) {
                String tn = e.getUserString("java.type");
                String name = e.getName();
                String namet = e.getName();
                first = this.generateChildAddItem(indent, parent, first, e, tn, name, namet);
                continue;
            }
            for (ElementDefinition.TypeRefComponent t : this.getTypes(e.getType())) {
                if (this.isAbstract(e.typeSummary())) continue;
                String tn = this.getTypename(t);
                String name = e.getName().replace("[x]", "");
                String namet = e.getName().replace("[x]", this.upFirst(this.checkConstraint(t.getName())));
                first = this.generateChildAddItem(indent, parent, first, e, tn, name, namet);
            }
        }
        if (!first) {
            this.write(indent + "    else\r\n");
        }
        this.write(indent + "      return super.addChild(name);\r\n");
        this.write(indent + "  }\r\n\r\n");
    }

    private String checkConstraint(String name) {
        if ("SimpleQuantity".equals(name)) {
            return "Quantity";
        }
        return name;
    }

    private boolean generateChildAddItem(String indent, String parent, boolean first, ElementDefinition e, String tn, String name, String namet) throws IOException {
        if (first) {
            this.write(indent + "    ");
        } else {
            this.write(indent + "    else ");
        }
        first = false;
        this.write("if (name.equals(\"" + namet + "\")) {\r\n");
        if (this.isPrimitive(e.typeSummary()) || e.typeSummary().startsWith("canonical(")) {
            this.write(indent + "      throw new FHIRException(\"Cannot call addChild on a singleton property " + parent + "." + e.getName() + "\");\r\n");
        } else if (this.isAbstract(e.typeSummary())) {
            this.write(indent + "      throw new FHIRException(\"Cannot call addChild on an abstract type " + parent + "." + e.getName() + "\");\r\n");
        } else if (e.unbounded()) {
            this.write(indent + "      return add" + this.upFirst(this.getElementName(name, false)) + "();\r\n");
        } else {
            this.write(indent + "      this." + this.getElementName(name, true) + " = new " + tn + "();\r\n");
            this.write(indent + "      return this." + this.getElementName(name, true) + ";\r\n");
        }
        this.write(indent + "    }\r\n");
        return first;
    }

    private List<ElementDefinition.TypeRefComponent> getTypes(List<ElementDefinition.TypeRefComponent> types) {
        if (types.size() == 1 && types.get(0).getName().equals("*")) {
            ArrayList<ElementDefinition.TypeRefComponent> t = new ArrayList<ElementDefinition.TypeRefComponent>();
            for (String s : TypesUtilities.wildcardTypes((String)"5.0")) {
                t.add(new ElementDefinition.TypeRefComponent(s));
            }
            return t;
        }
        return types;
    }

    private boolean isAbstract(String code) {
        StructureDefinition sd = this.definitions.getContext().fetchTypeDefinition(code);
        if (sd != null && sd.getAbstract()) {
            return true;
        }
        return Utilities.existsInList((String)code, (String[])new String[]{"Resource", "Element", "BackboneElement"});
    }

    private void generateConstructor(String className, List<ElementDefinition> params, String indent) throws IOException {
        this.write(indent + "/**\r\n");
        this.write(indent + " * Constructor\r\n");
        this.write(indent + " */\r\n");
        this.write(indent + "  public " + className + "(");
        boolean first = true;
        for (ElementDefinition e : params) {
            if (!first) {
                this.write(", ");
            }
            first = false;
            String tn = e.getUserString("java.type");
            if (this.definitions.hasPrimitiveType(e.typeSummary()) && !e.hasUserData("java.enum")) {
                tn = "xhtml".equals(e.typeSummary()) ? "XhtmlNode" : this.getSimpleType(tn);
            } else if (tn.startsWith("Enumeration<")) {
                tn = tn.substring(12, tn.length() - 1);
            }
            String en = this.getElementName(e.getName(), true);
            this.write(tn + " " + en);
        }
        this.write(") {\r\n");
        this.write(indent + "    super();\r\n");
        for (ElementDefinition e : params) {
            String en = this.getElementName(e.getName(), true);
            if (e.unbounded()) {
                this.write(indent + "    this.add" + Utilities.capitalize((String)en) + "(" + en + ");\r\n");
                continue;
            }
            this.write(indent + "    this.set" + Utilities.capitalize((String)en).replace("Abstract_", "Abstract") + "(" + en + ");\r\n");
        }
        this.write(indent + "  }\r\n\r\n");
    }

    private String upFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private boolean hasList(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (e.getName().equals("text") || !e.unbounded()) continue;
            return true;
        }
        return false;
    }

    private boolean hasDecimal(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (!this.isDefinedInThisClass(e) || !e.typeSummary().equals("decimal")) continue;
            return true;
        }
        return false;
    }

    private boolean hasString(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (!this.isDefinedInThisClass(e) || !Utilities.existsInList((String)e.typeSummary(), (String[])new String[]{"string", "id", "code", "uri", "oid", "uuid", "url", "canonical"})) continue;
            return true;
        }
        return false;
    }

    private boolean hasNestedTypes(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (!this.isDefinedInThisClass(e)) continue;
            if (Utilities.charCount((String)e.getPath(), (char)'.') >= 2) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean hasSharedEnums(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (!this.isDefinedInThisClass(e)) continue;
            if (e.getBinding() == null || e.getBinding().hasUserData("shared")) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean hasXhtml(List<ElementDefinition> list) {
        for (ElementDefinition e : list) {
            if (!this.isDefinedInThisClass(e) || !e.typeSummary().contains("xhtml")) continue;
            return true;
        }
        return false;
    }

    private boolean isDefinedInThisClass(ElementDefinition e) {
        return e.getPath().equals(e.getBase().getPath());
    }

    private void generateEnum(EnumInfo e) throws Exception {
        String definition;
        String cc;
        ValueSetExpansionOutcome vsex;
        Object tn = e.getName();
        String tns = tn;
        if (((String)tn).startsWith("Enumeration<")) {
            tns = ((String)tn).substring(((String)tn).indexOf("<") + 1);
            tns = tns.substring(0, tns.length() - 1);
        } else {
            tn = "Enumeration<" + (String)tn + ">";
        }
        ValueSet vs = e.getValueSet();
        ValueSet vse = (ValueSet)vs.getUserData("expansion");
        if (vs.hasUserData("shared")) {
            return;
        }
        if (vse == null && (vsex = this.definitions.getContext().expandVS(vs, true, false)).isOk()) {
            vse = vsex.getValueset();
        }
        if (vse == null) {
            System.out.println("Unable to expand enum value set " + vs.getVersionedUrl());
            return;
        }
        List codes = vse.getExpansion().getContains();
        String url = vs.getUrl();
        CommaSeparatedStringBuilder el = new CommaSeparatedStringBuilder();
        this.write("    public enum " + tns + " {\r\n");
        int l = codes.size();
        int i = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            ++i;
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            el.append(cc);
            definition = this.definitions.getCodeDefinition(c.getSystem(), c.getCode());
            this.write("        /**\r\n");
            this.write("         * " + Utilities.escapeJava((String)definition) + "\r\n");
            this.write("         */\r\n");
            this.write("        " + cc.toUpperCase() + ", \r\n");
        }
        this.write("        /**\r\n");
        this.write("         * added to help the parsers with the generic types\r\n");
        this.write("         */\r\n");
        this.write("        NULL;\r\n");
        el.append("NULL");
        this.write("        public static " + tns + " fromCode(String codeString) throws FHIRException {\r\n");
        this.write("            if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("                return null;\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return " + cc + ";\r\n");
        }
        this.write("        if (Configuration.isAcceptInvalidEnums())\r\n");
        this.write("          return null;\r\n");
        this.write("        else\r\n");
        this.write("          throw new FHIRException(\"Unknown " + tns + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("        public String toCode() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + c.getCode() + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getSystem() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + c.getSystem() + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getDefinition() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            definition = this.definitions.getCodeDefinition(c.getSystem(), c.getCode());
            this.write("            case " + cc + ": return \"" + Utilities.escapeJava((String)definition) + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("        public String getDisplay() {\r\n");
        this.write("          switch (this) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("            case " + cc + ": return \"" + Utilities.escapeJava((String)(Utilities.noString((String)c.getDisplay()) ? c.getCode() : c.getDisplay())) + "\";\r\n");
        }
        this.write("            case NULL: return null;\r\n");
        this.write("            default: return \"?\";\r\n");
        this.write("          }\r\n");
        this.write("        }\r\n");
        this.write("    }\r\n");
        this.write("\r\n");
        this.write("  public static class " + tns + "EnumFactory implements EnumFactory<" + tns + "> {\r\n");
        this.write("    public " + tns + " fromCode(String codeString) throws IllegalArgumentException {\r\n");
        this.write("      if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("            if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("                return null;\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return " + tns + "." + cc + ";\r\n");
        }
        this.write("        throw new IllegalArgumentException(\"Unknown " + tns + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("        public Enumeration<" + tns + "> fromType(PrimitiveType<?> code) throws FHIRException {\r\n");
        this.write("          if (code == null)\r\n");
        this.write("            return null;\r\n");
        this.write("          if (code.isEmpty())\r\n");
        this.write("            return new Enumeration<" + tns + ">(this, " + tns + ".NULL, code);\r\n");
        this.write("          String codeString = ((PrimitiveType) code).asStringValue();\r\n");
        this.write("          if (codeString == null || \"\".equals(codeString))\r\n");
        this.write("            return new Enumeration<" + tns + ">(this, " + tns + ".NULL, code);\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("        if (\"" + c.getCode() + "\".equals(codeString))\r\n");
            this.write("          return new Enumeration<" + tns + ">(this, " + tns + "." + cc + ", code);\r\n");
        }
        this.write("        throw new FHIRException(\"Unknown " + tns + " code '\"+codeString+\"'\");\r\n");
        this.write("        }\r\n");
        this.write("    public String toCode(" + tns + " code) {\r\n");
        for (ValueSet.ValueSetExpansionContainsComponent c : codes) {
            cc = Utilities.camelCase((String)c.getCode());
            cc = this.makeConst(cc);
            this.write("      if (code == " + tns + "." + cc + ")\r\n        return \"" + c.getCode() + "\";\r\n");
        }
        this.write("      return \"?\";\r\n");
        this.write("      }\r\n");
        this.write("    public String toSystem(" + tns + " code) {\r\n");
        this.write("      return code.getSystem();\r\n");
        this.write("      }\r\n");
        this.write("    }\r\n");
        this.write("\r\n");
    }

    private void generateType(Analysis analysis, TypeInfo ti) throws Exception {
        String tn = ti.getName();
        ElementDefinition e = ti.getDefn();
        StructureDefinition sd = this.definitions.getType(e.typeSummary());
        List<ElementDefinition> children = ti.getChildren();
        this.write("    @Block()\r\n");
        this.write("    public static class " + tn + " extends " + this.fixExtendsName(sd.getName()) + " {\r\n");
        this.allfields = "";
        int i = 1;
        for (ElementDefinition c : children) {
            this.generateField(analysis, ti, c, "        ", i++);
        }
        this.write("        private static final long serialVersionUID = " + Long.toString(this.allfields.hashCode()) + "L;\r\n\r\n");
        this.hashSum += (long)this.allfields.hashCode();
        ArrayList<ElementDefinition> mandatory = new ArrayList<ElementDefinition>();
        this.generateConstructor(tn, mandatory, "    ");
        for (ElementDefinition c : children) {
            if (!c.isMandatory()) continue;
            mandatory.add(c);
        }
        if (mandatory.size() > 0) {
            this.generateConstructor(tn, mandatory, "    ");
        }
        for (ElementDefinition c : children) {
            this.generateAccessors(analysis, ti, c, "        ", null);
        }
        this.generateChildrenRegister(analysis, ti, "      ");
        this.generatePropertyGetterId(analysis, ti, "    ");
        this.generatePropertySetterId(analysis, ti, "    ");
        this.generatePropertySetterName(analysis, ti, "    ");
        this.generatePropertyMaker(analysis, ti, "    ");
        this.generatePropertyTypeGetter(analysis, ti, "    ");
        this.generateChildAdder(analysis, ti, "    ");
        this.generateCopy(analysis, ti, true);
        this.generateEquals(analysis, ti, true);
        this.generateIsEmpty(analysis, ti, true);
        this.generateFhirType(e.getPath());
        if (this.config.getAdornments().containsKey(tn)) {
            this.write("// added from java-adornments.txt:\r\n");
            this.write(this.config.getAdornments().get(tn) + "\r\n");
            this.write("// end addition\r\n");
        }
        this.write("  }\r\n");
        this.write("\r\n");
    }

    private String fixExtendsName(String name) {
        if ("Base".equals(name)) {
            return "LogicalBase";
        }
        return name;
    }

    private void generateEquals(Analysis analysis, TypeInfo ti, boolean owner) throws Exception {
        String name;
        List<ElementDefinition> children = ti.getChildren();
        String tn = ti.getName();
        boolean isAbstract = analysis.isAbstract();
        boolean isInterface = analysis.isInterface();
        this.write("      @Override\r\n");
        this.write("      public boolean equalsDeep(Base other_) {\r\n");
        this.write("        if (!super.equalsDeep(other_))\r\n");
        this.write("          return false;\r\n");
        this.write("        if (!(other_ instanceof " + tn + "))\r\n");
        this.write("          return false;\r\n");
        this.write("        " + tn + " o = (" + tn + ") other_;\r\n");
        this.write("        return ");
        boolean first = true;
        int col = 18;
        for (ElementDefinition c : children) {
            if (isInterface) continue;
            if (first) {
                first = false;
            } else {
                this.write(" && ");
                col += 4;
            }
            name = this.getElementName(c.getName(), true);
            if (name.endsWith("[x]")) {
                name = name.substring(0, name.length() - 3);
            }
            this.write("compareDeep(" + name + ", o." + name + ", true)");
            if ((col = col + 21 + name.length() * 2) <= 100) continue;
            col = 10;
            this.write("\r\n          ");
        }
        if (first) {
            this.write("true");
        }
        this.write(";\r\n");
        this.write("      }\r\n\r\n");
        this.write("      @Override\r\n");
        this.write("      public boolean equalsShallow(Base other_) {\r\n");
        this.write("        if (!super.equalsShallow(other_))\r\n");
        this.write("          return false;\r\n");
        this.write("        if (!(other_ instanceof " + tn + "))\r\n");
        this.write("          return false;\r\n");
        this.write("        " + tn + " o = (" + tn + ") other_;\r\n");
        this.write("        return ");
        first = true;
        col = 18;
        for (ElementDefinition c : children) {
            if (isInterface || !this.isJavaPrimitive(c) || "xhtml".equals(c.typeSummary())) continue;
            if (first) {
                first = false;
            } else {
                this.write(" && ");
                col += 4;
            }
            name = this.getElementName(c.getName(), true);
            if (name.endsWith("[x]")) {
                name = name.substring(0, name.length() - 3);
            }
            this.write("compareValues(" + name + ", o." + name + ", true)");
            if ((col = col + 21 + name.length() * 2) <= 100) continue;
            col = 10;
            this.write("\r\n          ");
        }
        if (first) {
            this.write("true");
        }
        this.write(";\r\n");
        this.write("      }\r\n\r\n");
    }

    private void generateCopy(Analysis analysis, TypeInfo ti, boolean owner) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        String tn = ti.getName();
        boolean isAbstract = analysis.isAbstract();
        boolean isInterface = analysis.isInterface();
        if (isAbstract) {
            this.write("      public abstract " + tn + " copy();\r\n\r\n");
            this.write("      public void copyValues(" + tn + " dst) {\r\n");
            this.write("        super.copyValues(dst);\r\n");
        } else {
            this.write("      public " + tn + " copy() {\r\n");
            this.write("        " + tn + " dst = new " + tn + "();\r\n");
            this.write("        copyValues(dst);\r\n");
            this.write("        return dst;\r\n");
            this.write("      }\r\n\r\n");
            this.write("      public void copyValues(" + tn + " dst) {\r\n");
            this.write("        super.copyValues(dst);\r\n");
        }
        for (ElementDefinition c : children) {
            if (isInterface) continue;
            String name = this.getElementName(c.getName(), true);
            if (c.unbounded()) {
                String ctn = c.getUserString("java.type");
                this.write("        if (" + name + " != null) {\r\n");
                this.write("          dst." + name + " = new ArrayList<" + ctn + ">();\r\n");
                this.write("          for (" + ctn + " i : " + name + ")\r\n");
                this.write("            dst." + name + ".add(i.copy());\r\n");
                this.write("        };\r\n");
                continue;
            }
            if (name.endsWith("[x]")) {
                name = name.substring(0, name.length() - 3);
            }
            this.write("        dst." + name + " = " + name + " == null ? null : " + name + ".copy();\r\n");
        }
        this.write("      }\r\n\r\n");
        if (!owner && !isAbstract) {
            this.write("      protected " + tn + " typedCopy() {\r\n");
            this.write("        return copy();\r\n");
            this.write("      }\r\n\r\n");
        }
    }

    private void generateIsEmpty(Analysis analysis, TypeInfo ti, boolean owner) throws Exception {
        List<ElementDefinition> children = ti.getChildren();
        String tn = ti.getName();
        boolean isAbstract = analysis.isAbstract();
        boolean isInterface = analysis.isInterface();
        this.write("      public boolean isEmpty() {\r\n");
        this.write("        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(");
        int col = 70;
        boolean first = true;
        for (ElementDefinition c : children) {
            if (isInterface) continue;
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            col += 2;
            String name = this.getElementName(c.getName(), true);
            if (name.endsWith("[x]")) {
                name = name.substring(0, name.length() - 3);
            }
            this.write(name);
            if ((col = col + name.length() + 2) <= 100) continue;
            col = 10;
            this.write("\r\n          ");
        }
        this.write(");\r\n");
        this.write("      }\r\n\r\n");
    }

    private ElementDefinition getElementForPath(StructureDefinition structure, String pathname) throws Exception {
        String[] path = pathname.split("\\.");
        if (!path[0].equals(structure.getName())) {
            throw new Exception("Element Path '" + pathname + "' is not legal in this context");
        }
        ElementDefinition res = null;
        for (ElementDefinition t : structure.getSnapshot().getElement()) {
            if (!t.getPath().equals(pathname)) continue;
            res = t;
        }
        if (res == null) {
            throw new Exception("unable to resolve " + pathname);
        }
        return res;
    }

    private void generateField(Analysis analysis, TypeInfo ti, ElementDefinition e, String indent, int order) throws Exception {
        String tn = e.getUserString("java.type");
        if (e.unbounded()) {
            this.jdoc(indent, this.replaceTitle(analysis.getName(), e.getDefinition()));
            this.writeAttributeAnnotation(indent, e, order, tn, analysis.getName(), analysis.getStructure());
            this.writeWithHash(indent + "protected List<" + tn + "> " + this.getElementName(e.getName(), true) + ";\r\n");
            this.write("\r\n");
        } else {
            this.jdoc(indent, this.replaceTitle(analysis.getName(), e.getDefinition()));
            this.writeAttributeAnnotation(indent, e, order, tn, analysis.getName(), analysis.getStructure());
            this.writeWithHash(indent + "protected " + tn + " " + this.getElementName(e.getName(), true) + ";\r\n");
            this.write("\r\n");
        }
    }

    public String getReferenceType(ElementDefinition e) {
        String rn = "Resource";
        if (e.getType().size() == 1 && e.typeSummary().startsWith("Reference(")) {
            List params = ((ElementDefinition.TypeRefComponent)e.getType().get(0)).getTargetProfile();
            String string = rn = params.size() == 1 ? (String)((CanonicalType)params.get(0)).getValue() : "Resource";
            if (rn.equals("Any")) {
                rn = "Resource";
            } else if (rn.equals("List")) {
                rn = "ListResource";
            }
        }
        return rn;
    }

    private void writeAttributeAnnotation(String indent, ElementDefinition e, int order, String tn, String rn, StructureDefinition structure) throws Exception {
        String elementName = this.getElementName(e.getName(), true);
        if (elementName.endsWith("_")) {
            elementName = elementName.substring(0, elementName.length() - 1);
        }
        StringBuilder childB = new StringBuilder();
        childB.append(indent);
        childB.append("@Child(name = \"");
        childB.append(elementName);
        childB.append("\", type = {");
        childB.append(this.getTypeClassList(e, tn, structure));
        childB.append("}, order=");
        childB.append(Integer.toString(order));
        childB.append(", min=");
        childB.append(Integer.toString(e.getMin()));
        childB.append(", max=");
        childB.append(e.getMax().equals("*") ? "Child.MAX_UNLIMITED" : e.getMax().toString());
        childB.append(", modifier=");
        childB.append(e.getIsModifier());
        childB.append(", summary=");
        childB.append(e.getIsSummary());
        childB.append(")\r\n");
        this.write(childB.toString());
        this.write(indent + "@Description(shortDefinition=\"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getShort())) + "\", formalDefinition=\"" + Utilities.escapeJava((String)this.replaceTitle(rn, e.getDefinition())) + "\" )\r\n");
        if (e.getBinding() != null && e.getBinding().getValueSet() != null && !Utilities.noString((String)e.getBinding().getValueSet())) {
            this.write(indent + "@ca.uhn.fhir.model.api.annotation.Binding(valueSet=\"" + this.noVer(e.getBinding().getValueSet()) + "\")\r\n");
        }
    }

    private String noVer(String url) {
        return url.contains("|") ? url.substring(0, url.indexOf("|")) : url;
    }

    private String replaceTitle(String rn, String cnt) {
        if (cnt == null) {
            return "";
        }
        String[] title = Utilities.splitByCamelCase((String)rn);
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" ");
        for (String s : title) {
            b.append(s);
        }
        return cnt.replace("{{title}}", b.toString());
    }

    private String getTypeClassList(ElementDefinition e, String tn, StructureDefinition structure) throws Exception {
        if (e.hasContentReference()) {
            ElementDefinition er = this.getElementForPath(structure, e.getContentReference().substring(e.getContentReference().indexOf("#") + 1));
            String s = er.getUserString("java.type");
            return s + ".class";
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent tr : e.getType()) {
            if (Utilities.existsInList((String)tr.getCode(), (String[])new String[]{"Element", "BackboneElement"})) continue;
            if (tr.isResourceReference()) {
                for (CanonicalType p : tr.getTargetProfile()) {
                    String s = ((String)p.getValue()).substring(40);
                    if (s.equalsIgnoreCase("Resource")) {
                        b.append("Reference.class");
                        continue;
                    }
                    if (s.equals("List")) {
                        b.append(s + "Resource.class");
                        continue;
                    }
                    b.append(s + ".class");
                }
                continue;
            }
            if (this.definitions.hasPrimitiveType(tr.getWorkingCode())) {
                b.append(this.upFirst(tr.getWorkingCode()) + "Type.class");
                continue;
            }
            if (tr.getName().equalsIgnoreCase("*") || tr.getName().equalsIgnoreCase("xhtml")) continue;
            b.append(this.getTypename(tr) + ".class");
        }
        return b.toString();
    }

    private void writeWithHash(String string) throws IOException {
        this.allfields = this.allfields + string;
        this.write(string);
    }

    private String getSimpleType(String n) {
        if (n.equals("StringType")) {
            return "String";
        }
        if (n.equals("CodeType")) {
            return "String";
        }
        if (n.equals("MarkdownType")) {
            return "String";
        }
        if (n.equals("Base64BinaryType")) {
            return "byte[]";
        }
        if (n.equals("UriType")) {
            return "String";
        }
        if (n.equals("UrlType")) {
            return "String";
        }
        if (n.equals("CanonicalType")) {
            return "String";
        }
        if (n.equals("OidType")) {
            return "String";
        }
        if (n.equals("IntegerType")) {
            return "int";
        }
        if (n.equals("Integer64Type")) {
            return "long";
        }
        if (n.equals("UnsignedIntType")) {
            return "int";
        }
        if (n.equals("PositiveIntType")) {
            return "int";
        }
        if (n.equals("BooleanType")) {
            return "boolean";
        }
        if (n.equals("DecimalType")) {
            return "BigDecimal";
        }
        if (n.equals("DateTimeType")) {
            return "Date";
        }
        if (n.equals("DateType")) {
            return "Date";
        }
        if (n.equals("IdType")) {
            return "String";
        }
        if (n.equals("InstantType")) {
            return "Date";
        }
        if (n.equals("TimeType")) {
            return "String";
        }
        if (n.equals("UuidType")) {
            return "String";
        }
        String tns = null;
        if (n.indexOf("<") > 0) {
            tns = n.substring(n.indexOf("<") + 1);
            tns = tns.substring(0, tns.length() - 1);
        }
        if (tns != null) {
            return tns;
        }
        return "??";
    }

    private void generateAccessors(Analysis analysis, TypeInfo ti, ElementDefinition e, String indent, ElementDefinition inh) throws Exception {
        String tn = e.getUserString("java.type");
        StructureDefinition sd = e.hasType() ? (StructureDefinition)this.definitions.getStructures().get(this.pfxType(e.getTypeFirstRep().getCode())) : null;
        boolean abstractTarget = sd != null && sd.getAbstract() && !sd.getUrl().equals("http://hl7.org/fhir/StructureDefinition/Element") && !sd.getUrl().equals("http://hl7.org/fhir/StructureDefinition/BackboneElement");
        String className = ti.getName();
        if (Utilities.noString((String)tn)) {
            throw new Error("??");
        }
        boolean isReferenceRefField = analysis.getName().equals("Reference") && e.getName().equals("reference");
        String simpleType = this.getSimpleType(tn);
        if (e.unbounded() || inh != null && inh.unbounded()) {
            if (!e.unbounded()) {
                this.jdoc(indent, "only one on this implementation");
                this.write(indent + "@Override\r\n");
                this.write(indent + "public int get" + this.getTitle(this.getElementName(e.getName(), false)) + "Max() { \r\n");
                this.write(indent + "  return 1;\r\n");
                this.write(indent + "}\r\n");
            }
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            String listGenericType = tn == null && e.hasContentReference() ? analysis.getName() : tn;
            this.write(indent + "public List<" + listGenericType + "> get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            if (!e.unbounded()) {
                this.write(indent + "  List<" + listGenericType + "> list = new ArrayList<" + listGenericType + ">();\r\n");
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null) {\r\n");
                this.write(indent + "    list.add(" + this.getElementName(e.getName(), true) + ");\r\n");
                this.write(indent + "  }\r\n");
                this.write(indent + "  return list;\r\n");
            } else {
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + listGenericType + ">();\r\n");
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
            }
            this.write(indent + "}\r\n\r\n");
            this.jdoc(indent, "@return Returns a reference to <code>this</code> for easy method chaining");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(List<" + listGenericType + "> the" + this.getTitle(this.getElementName(e.getName(), false)) + ") { \r\n");
            if (!e.unbounded()) {
                this.write(indent + "  if (the" + this.getTitle(this.getElementName(e.getName(), false)) + ".size() == 0) {\r\n");
                this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = null;\r\n");
                this.write(indent + "  } else if (the" + this.getTitle(this.getElementName(e.getName(), false)) + ".size() == 1) {\r\n");
                this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = the" + this.getTitle(this.getElementName(e.getName(), false)) + ".get(0);\r\n");
                this.write(indent + "  } else {\r\n");
                this.write(indent + "    throw new Error(\"Cannot have more than one " + e.getPath() + "\");\r\n");
                this.write(indent + "  }\r\n");
            } else {
                this.write(indent + "  this." + this.getElementName(e.getName(), true) + " = the" + this.getTitle(this.getElementName(e.getName(), false)) + ";\r\n");
            }
            this.write(indent + "  return this;\r\n");
            this.write(indent + "}\r\n\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            if (!e.unbounded()) {
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " != null && !this." + this.getElementName(e.getName(), true) + ".isEmpty();\r\n");
            } else {
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    return false;\r\n");
                this.write(indent + "  for (" + tn + " item : this." + this.getElementName(e.getName(), true) + ")\r\n");
                this.write(indent + "    if (!item.isEmpty())\r\n");
                this.write(indent + "      return true;\r\n");
                this.write(indent + "  return false;\r\n");
            }
            this.write(indent + "}\r\n");
            this.write("\r\n");
            if (e.getType().size() == 1 && (this.definitions.hasPrimitiveType(e.typeSummary()) || e.typeSummary().equals("xml:lang") || e.typeSummary().startsWith("canonical("))) {
                this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "Element() {//2 \r\n");
                if (!e.unbounded()) {
                    this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null) {\r\n");
                    this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new " + tn + "();\r\n");
                    this.write(indent + "  } else {\r\n");
                    this.write(indent + "    throw new Error(\"Cannot have more than one " + e.getPath() + "\");\r\n");
                    this.write(indent + "  }\r\n");
                    this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
                } else {
                    this.write(indent + "  " + tn + " t = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + ");\r\n");
                    this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                    this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + tn + ">();\r\n");
                    this.write(indent + "  this." + this.getElementName(e.getName(), true) + ".add(t);\r\n");
                    this.write(indent + "  return t;\r\n");
                }
                this.write(indent + "}\r\n");
                this.write("\r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value) { //1\r\n");
                this.write(indent + "  " + tn + " t = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + ");\r\n");
                this.write(indent + "  t.setValue(value);\r\n");
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + tn + ">();\r\n");
                this.write(indent + "  this." + this.getElementName(e.getName(), true) + ".add(t);\r\n");
                this.write(indent + "  return this;\r\n");
                this.write(indent + "}\r\n");
                this.write("\r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value) { \r\n");
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    return false;\r\n");
                this.write(indent + "  for (" + tn + " v : this." + this.getElementName(e.getName(), true) + ")\r\n");
                if (this.isJavaPrimitive(e) && !tn.startsWith("Enum")) {
                    this.write(indent + "    if (v.getValue().equals(value)) // " + e.typeSummary() + "\r\n");
                } else {
                    this.write(indent + "    if (v.getValue().equals(value)) // " + e.typeSummary() + "\r\n");
                }
                this.write(indent + "      return true;\r\n");
                this.write(indent + "  return false;\r\n");
                this.write(indent + "}\r\n");
                this.write("\r\n");
            } else {
                if (!this.definitions.hasResource(tn)) {
                    if (abstractTarget) {
                        System.out.println(e.getPath() + " is abstract");
                    } else {
                        this.write(indent + "public " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "() { //3\r\n");
                        if (!e.unbounded()) {
                            this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null) {\r\n");
                            this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new " + tn + "();\r\n");
                            this.write(indent + "  } else {\r\n");
                            this.write(indent + "    throw new Error(\"Cannot have more than one " + e.getPath() + "\");\r\n");
                            this.write(indent + "  }\r\n");
                            this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
                        } else {
                            this.write(indent + "  " + tn + " t = new " + tn + "();\r\n");
                            this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                            this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + tn + ">();\r\n");
                            this.write(indent + "  this." + this.getElementName(e.getName(), true) + ".add(t);\r\n");
                            this.write(indent + "  return t;\r\n");
                        }
                        this.write(indent + "}\r\n");
                        this.write("\r\n");
                    }
                    this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t) { //3\r\n");
                    if (!e.unbounded()) {
                        this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null) {\r\n");
                        this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = t;\r\n");
                        this.write(indent + "  } else {\r\n");
                        this.write(indent + "    throw new Error(\"Cannot have more than one " + e.getPath() + "\");\r\n");
                        this.write(indent + "  }\r\n");
                    } else {
                        this.write(indent + "  if (t == null)\r\n");
                        this.write(indent + "    return this;\r\n");
                        this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                        this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + tn + ">();\r\n");
                        this.write(indent + "  this." + this.getElementName(e.getName(), true) + ".add(t);\r\n");
                    }
                    this.write(indent + "  return this;\r\n");
                    this.write(indent + "}\r\n");
                    this.write("\r\n");
                } else {
                    this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t) { //3\r\n");
                    this.write(indent + "  if (t == null)\r\n");
                    this.write(indent + "    return this;\r\n");
                    this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                    this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new ArrayList<" + tn + ">();\r\n");
                    this.write(indent + "  this." + this.getElementName(e.getName(), true) + ".add(t);\r\n");
                    this.write(indent + "  return this;\r\n");
                    this.write(indent + "}\r\n");
                    this.write("\r\n");
                }
                if (!"DomainResource".equals(className)) {
                    this.jdoc(indent, "@return The first repetition of repeating field {@link #" + this.getElementName(e.getName(), true) + "}, creating it if it does not already exist {3}");
                    this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "FirstRep() { \r\n");
                    if (e.unbounded()) {
                        this.write(indent + "  if (get" + this.getTitle(this.getElementName(e.getName(), false)) + "().isEmpty()) {\r\n");
                    } else {
                        this.write(indent + "  if (" + this.getElementName(e.getName(), false) + " == null) {\r\n");
                    }
                    if (this.definitions.hasPrimitiveType(e.typeSummary())) {
                        this.write(indent + "    add" + this.getTitle(this.getElementName(e.getName(), false)) + "Element();\r\n");
                    } else {
                        this.write(indent + "    add" + this.getTitle(this.getElementName(e.getName(), false)) + "();\r\n");
                    }
                    this.write(indent + "  }\r\n");
                    if (e.unbounded()) {
                        this.write(indent + "  return get" + this.getTitle(this.getElementName(e.getName(), false)) + "().get(0);\r\n");
                    } else {
                        this.write(indent + "  return " + this.getElementName(e.getName(), false) + ";\r\n");
                    }
                    this.write(indent + "}\r\n\r\n");
                }
            }
        } else if (!"xhtml".equals(e.typeSummary()) && this.isJavaPrimitive(e) || e.getType().size() == 1 && e.typeSummary().startsWith("canonical(")) {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            if (isReferenceRefField) {
                this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element_() { \r\n");
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    if (Configuration.errorOnAutoCreate())\r\n");
                this.write(indent + "      throw new Error(\"Attempt to auto-create " + className + "." + this.getElementName(e.getName(), true) + "\");\r\n");
                this.write(indent + "    else if (Configuration.doAutoCreate())\r\n");
                this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + "); // bb\r\n");
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
                this.write(indent + "}\r\n");
            } else {
                this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element() { \r\n");
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    if (Configuration.errorOnAutoCreate())\r\n");
                this.write(indent + "      throw new Error(\"Attempt to auto-create " + className + "." + this.getElementName(e.getName(), true) + "\");\r\n");
                this.write(indent + "    else if (Configuration.doAutoCreate())\r\n");
                this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + "); // bb\r\n");
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
                this.write(indent + "}\r\n");
            }
            this.write("\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "Element() { \r\n");
            this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " != null && !this." + this.getElementName(e.getName(), true) + ".isEmpty();\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " != null && !this." + this.getElementName(e.getName(), true) + ".isEmpty();\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(" + tn + " value) { \r\n");
            this.write(indent + "  this." + this.getElementName(e.getName(), true) + " = value;\r\n");
            this.write(indent + "  return this;\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.jdoc(indent, "@return " + this.replaceTitle(analysis.getName(), e.getDefinition()));
            this.write(indent + "public " + simpleType + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            if (e.typeSummary().equals("boolean")) {
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " == null || this." + this.getElementName(e.getName(), true) + ".isEmpty() ? false : this." + this.getElementName(e.getName(), true) + ".getValue();\r\n");
            } else if (e.typeSummary().equals("integer") || e.typeSummary().equals("unsignedInt") || e.typeSummary().equals("positiveInt")) {
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " == null || this." + this.getElementName(e.getName(), true) + ".isEmpty() ? 0 : this." + this.getElementName(e.getName(), true) + ".getValue();\r\n");
            } else if (e.typeSummary().equals("integer64")) {
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " == null || this." + this.getElementName(e.getName(), true) + ".isEmpty() ? 0 : this." + this.getElementName(e.getName(), true) + ".getValue();\r\n");
            } else {
                this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " == null ? null : this." + this.getElementName(e.getName(), true) + ".getValue();\r\n");
            }
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.generateSetter(e, indent, className, tn, simpleType, analysis.getName());
            if (simpleType.equals("BigDecimal")) {
                this.generateSetter(e, indent, className, tn, "long", analysis.getName());
                this.generateSetter(e, indent, className, tn, "double", analysis.getName());
            }
        } else {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            if (!(tn.equals("Resource") || tn.equals("DataType") || tn.endsWith(".DataType") || this.isAbstract(e.getTypeFirstRep().getCode()))) {
                this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                this.write(indent + "    if (Configuration.errorOnAutoCreate())\r\n");
                this.write(indent + "      throw new Error(\"Attempt to auto-create " + className + "." + this.getElementName(e.getName(), true) + "\");\r\n");
                this.write(indent + "    else if (Configuration.doAutoCreate())\r\n");
                if ("XhtmlNode".equals(tn)) {
                    this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new XhtmlNode(NodeType.Element, \"div\"); // cc.1\r\n");
                } else {
                    this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new " + tn + "(); // cc\r\n");
                }
            }
            this.write(indent + "  return this." + this.getElementName(e.getName(), true) + ";\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            if (e.getType().size() > 1 && (tn.equals("DataType") || !tn.endsWith(".DataType"))) {
                for (ElementDefinition.TypeRefComponent t : e.getType()) {
                    this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                    String ttn = this.getTypename(t);
                    this.write(indent + "public " + ttn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "() throws FHIRException { \r\n");
                    this.write(indent + "  if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
                    this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = new " + ttn + "();\r\n");
                    this.write(indent + "  if (!(this." + this.getElementName(e.getName(), true) + " instanceof " + ttn + "))\r\n");
                    this.write(indent + "    throw new FHIRException(\"Type mismatch: the type " + ttn + " was expected, but \"+this." + this.getElementName(e.getName(), true) + ".getClass().getName()+\" was encountered\");\r\n");
                    this.write(indent + "  return (" + ttn + ") this." + this.getElementName(e.getName(), true) + ";\r\n");
                    this.write(indent + "}\r\n");
                    this.write("\r\n");
                    this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "() { \r\n");
                    this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " != null && this." + this.getElementName(e.getName(), true) + " instanceof " + ttn + ";\r\n");
                    this.write(indent + "}\r\n");
                    this.write("\r\n");
                }
            }
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  return this." + this.getElementName(e.getName(), true) + " != null && !this." + this.getElementName(e.getName(), true) + ".isEmpty();\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " value) { \r\n");
            if (e.getType().size() > 1 && (tn.equals("DataType") || !tn.endsWith(".DataType"))) {
                this.write(indent + "  if (value != null && !(");
                boolean first = true;
                for (ElementDefinition.TypeRefComponent t : e.getType()) {
                    if (first) {
                        first = false;
                    } else {
                        this.write(" || ");
                    }
                    this.write("value instanceof ");
                    this.write(this.getTypename(t));
                }
                this.write("))\r\n");
                this.write(indent + "    throw new FHIRException(\"Not the right type for " + e.getPath() + ": \"+value.fhirType());\r\n");
            }
            this.write(indent + "  this." + this.getElementName(e.getName(), true) + " = value;\r\n");
            this.write(indent + "  return this;\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
        }
    }

    private String pfxType(String code) {
        return "http://hl7.org/fhir/StructureDefinition/" + code;
    }

    private void generateAbstractAccessors(Analysis analysis, TypeInfo ti, ElementDefinition e, String indent) throws Exception {
        String tn = e.getUserString("java.type");
        if (Utilities.noString((String)tn)) {
            throw new Error("??");
        }
        boolean isReferenceRefField = ti.getDefn().getName().equals("Reference") && e.getName().equals("reference");
        this.jdoc(indent, "How many allowed for this property by the implementation");
        this.write(indent + "public int get" + this.getTitle(this.getElementName(e.getName(), false)) + "Max() { \r\n");
        this.write(indent + "  return " + (e.getMax().equals("*") ? "Integer.MAX_VALUE" : "1") + ";\r\n");
        this.write(indent + "}\r\n");
        String simpleType = this.getSimpleType(tn);
        if (e.unbounded()) {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            String listGenericType = tn;
            this.write(indent + "public abstract List<" + listGenericType + "> get" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            this.jdoc(indent, "@return Returns a reference to <code>this</code> for easy method chaining");
            this.write(indent + "public abstract " + ti.getName() + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(List<" + listGenericType + "> the" + this.getTitle(this.getElementName(e.getName(), false)) + "); \r\n");
            this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            this.write("\r\n");
            if (e.getType().size() == 1 && (this.definitions.hasPrimitiveType(e.typeSummary()) || e.typeSummary().equals("xml:lang") || e.typeSummary().startsWith("canonical("))) {
                this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public abstract " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "Element();//2 \r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public abstract " + ti.getName() + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value); //1\r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value); \r\n");
            } else {
                if (!this.definitions.hasResource(tn)) {
                    this.write(indent + "public abstract " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(); //3\r\n");
                    this.write(indent + "public abstract " + ti.getName() + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t); //3\r\n");
                } else {
                    this.write(indent + "public abstract " + ti.getName() + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t); //3\r\n");
                }
                if (!"DomainResource".equals(ti.getName())) {
                    this.jdoc(indent, "@return The first repetition of repeating field {@link #" + this.getElementName(e.getName(), true) + "}, creating it if it does not already exist {1}");
                    this.write(indent + "public abstract " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "FirstRep(); \r\n");
                }
            }
        } else if (!"xhtml".equals(e.typeSummary()) && this.isJavaPrimitive(e) || e.getType().size() == 1 && e.typeSummary().startsWith("canonical(")) {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            if (isReferenceRefField) {
                this.write(indent + "public abstract " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element_(); \r\n");
            } else {
                this.write(indent + "public abstract " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(); \r\n");
            }
            this.write("\r\n");
            this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(); \r\n");
            this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            this.write("\r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            this.write(indent + "public abstract " + ti.getName() + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(" + tn + " value); \r\n");
            this.jdoc(indent, "@return " + this.replaceTitle(analysis.getName(), e.getDefinition()));
            this.write(indent + "public abstract " + simpleType + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            this.generateAbstractSetter(e, indent, ti.getName(), tn, simpleType, analysis.getName());
            if (simpleType.equals("BigDecimal")) {
                this.generateAbstractSetter(e, indent, ti.getName(), tn, "long", analysis.getName());
                this.generateAbstractSetter(e, indent, ti.getName(), tn, "double", analysis.getName());
            }
        } else {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public abstract " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            if (e.getType().size() > 1 && (tn.equals("DataType") || !tn.endsWith(".DataType"))) {
                for (ElementDefinition.TypeRefComponent t : e.getType()) {
                    this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                    String ttn = this.getTypename(t);
                    this.write(indent + "public abstract " + ttn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "() throws FHIRException; \r\n");
                    this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "(); \r\n");
                }
            }
            this.write(indent + "public abstract boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(); \r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public abstract " + ti.getName() + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " value); \r\n");
            this.write("\r\n");
        }
    }

    private void generateSetter(ElementDefinition e, String indent, String className, String tn, String simpleType, String rn) throws IOException {
        this.jdoc(indent, "@param value " + this.replaceTitle(rn, e.getDefinition()));
        this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value) { \r\n");
        if ("long".equals(simpleType) || "double".equals(simpleType)) {
            this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + ");\r\n");
            this.write(indent + "    this." + this.getElementName(e.getName(), true) + ".setValue(value);\r\n");
        } else {
            if (!(e.getMin() != 0 || tn.equals("IntegerType") || tn.equals("PositiveIntType") || tn.equals("UnsignedIntType") || tn.equals("BooleanType"))) {
                if (this.isString(tn)) {
                    this.write(indent + "  if (Utilities.noString(value))\r\n");
                } else {
                    this.write(indent + "  if (value == null)\r\n");
                }
                this.write(indent + "    this." + this.getElementName(e.getName(), true) + " = null;\r\n");
                this.write(indent + "  else {\r\n");
            }
            this.write(indent + "    if (this." + this.getElementName(e.getName(), true) + " == null)\r\n");
            this.write(indent + "      this." + this.getElementName(e.getName(), true) + " = new " + tn + "(" + (String)(tn.startsWith("Enum") ? "new " + tn.substring(12, tn.length() - 1) + "EnumFactory()" : "") + ");\r\n");
            this.write(indent + "    this." + this.getElementName(e.getName(), true) + ".setValue(value);\r\n");
            if (!(e.getMin() != 0 || tn.equals("IntegerType") || tn.equals("PositiveIntType") || tn.equals("UnsignedIntType") || tn.equals("BooleanType"))) {
                this.write(indent + "  }\r\n");
            }
        }
        this.write(indent + "  return this;\r\n");
        this.write(indent + "}\r\n");
        this.write("\r\n");
    }

    private void generateAbstractSetter(ElementDefinition e, String indent, String className, String tn, String simpleType, String rn) throws IOException {
        this.jdoc(indent, "@param value " + this.replaceTitle(rn, e.getDefinition()));
        this.write(indent + "public abstract " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value); \r\n");
    }

    private boolean isString(String tn) {
        return tn.equals("StringType") || tn.equals("CodeType") || tn.equals("IdType") || tn.equals("UriType") || tn.equals("OidType") || tn.equals("CanonicalType") || tn.equals("UrlType") || tn.equals("UuidType") || tn.equals("MarkdownType");
    }

    public long getHashSum() {
        return this.hashSum;
    }

    private void generateUnimplementedAccessors(Analysis analysis, TypeInfo ti, ElementDefinition e, String indent) throws Exception {
        System.out.println("   .. unimplemented: " + e.getPath());
        String tn = e.getUserString("java.type");
        String className = ti.getName();
        if (Utilities.noString((String)tn) && Utilities.noString((String)(tn = e.getUserString("type")))) {
            throw new Error("??");
        }
        boolean isReferenceRefField = analysis.getName().equals("Reference") && e.getName().equals("reference");
        this.jdoc(indent, "not supported on this implementation");
        this.write(indent + "@Override\r\n");
        this.write(indent + "public int get" + this.getTitle(this.getElementName(e.getName(), false)) + "Max() { \r\n");
        this.write(indent + "  return 0;\r\n");
        this.write(indent + "}\r\n");
        String simpleType = this.getSimpleType(tn);
        if (e.unbounded()) {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            String listGenericType = tn == null && e.hasContentReference() ? analysis.getName() : tn;
            this.write(indent + "public List<" + listGenericType + "> get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  return new ArrayList<>();\r\n");
            this.write(indent + "}\r\n");
            this.jdoc(indent, "@return Returns a reference to <code>this</code> for easy method chaining");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(List<" + listGenericType + "> the" + this.getTitle(this.getElementName(e.getName(), false)) + ") { \r\n");
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
            this.write(indent + "}\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  return false;\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            if (e.getType().size() == 1 && (this.definitions.hasPrimitiveType(e.typeSummary()) || e.typeSummary().equals("xml:lang") || e.typeSummary().startsWith("canonical("))) {
                this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(){//2 \r\n");
                this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                this.write(indent + "}\r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value) { //1\r\n");
                this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                this.write(indent + "}\r\n");
                this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value); \r\n");
                this.write(indent + "  return false;\r\n");
                this.write(indent + "}\r\n");
            } else {
                if (!this.definitions.hasResource(tn)) {
                    this.write(indent + "public " + tn + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "() { //3\r\n");
                    this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                    this.write(indent + "}\r\n");
                    this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t) { //3\r\n");
                    this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                    this.write(indent + "}\r\n");
                } else {
                    this.write(indent + "public " + className + " add" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " t) { //3\r\n");
                    this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                    this.write(indent + "}\r\n");
                }
                if (!"DomainResource".equals(className)) {
                    this.jdoc(indent, "@return The first repetition of repeating field {@link #" + this.getElementName(e.getName(), true) + "}, creating it if it does not already exist {2}");
                    this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "FirstRep() { \r\n");
                    this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                    this.write(indent + "}\r\n");
                }
            }
        } else if (!"xhtml".equals(e.typeSummary()) && this.isJavaPrimitive(e) || e.getType().size() == 1 && e.typeSummary().startsWith("canonical(")) {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            if (isReferenceRefField) {
                this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element_() { \r\n");
            } else {
                this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "Element() { \r\n");
            }
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\");\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "Element() { \r\n");
            this.write(indent + "  return false;\r\n");
            this.write(indent + "}\r\n");
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() {\r\n");
            this.write(indent + "  return false;\r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + "). This is the underlying object with id, value and extensions. The accessor \"get" + this.getTitle(this.getElementName(e.getName(), false)) + "\" gives direct access to the value");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "Element(" + tn + " value) { \r\n");
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
            this.write(indent + "}\r\n");
            this.write(indent + "public " + simpleType + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
            this.write(indent + "}\r\n");
            this.generateUnimplementedSetter(analysis, e, indent, className, tn, simpleType, analysis.getName());
            if (simpleType.equals("BigDecimal")) {
                this.generateUnimplementedSetter(analysis, e, indent, className, tn, "long", analysis.getName());
                this.generateUnimplementedSetter(analysis, e, indent, className, tn, "double", analysis.getName());
            }
        } else {
            this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public " + tn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
            this.write(indent + "}\r\n");
            if (e.getType().size() > 1 && (tn.equals("DataType") || !tn.endsWith(".DataType"))) {
                for (ElementDefinition.TypeRefComponent t : e.getType()) {
                    this.jdoc(indent, "@return {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
                    String ttn = this.getTypename(t);
                    this.write(indent + "public " + ttn + " get" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "() { \r\n");
                    this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
                    this.write(indent + "}\r\n");
                    this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + ttn + "() { \r\n");
                    this.write(indent + "  return false;////K \r\n");
                    this.write(indent + "}\r\n");
                }
            }
            this.write(indent + "public boolean has" + this.getTitle(this.getElementName(e.getName(), false)) + "() { \r\n");
            this.write(indent + "  return false;\r\n");
            this.write(indent + "}\r\n");
            this.jdoc(indent, "@param value {@link #" + this.getElementName(e.getName(), true) + "} (" + this.replaceTitle(analysis.getName(), e.getDefinition()) + ")");
            this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + tn + " value) { \r\n");
            this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
            this.write(indent + "}\r\n");
            this.write("\r\n");
        }
    }

    private void generateUnimplementedSetter(Analysis analysis, ElementDefinition e, String indent, String className, String tn, String simpleType, String rn) throws IOException {
        this.jdoc(indent, "@param value " + this.replaceTitle(rn, e.getDefinition()));
        this.write(indent + "public " + className + " set" + this.getTitle(this.getElementName(e.getName(), false)) + "(" + simpleType + " value) { \r\n");
        this.write(indent + "  throw new Error(\"The resource type \\\"" + analysis.getName() + "\\\" does not implement the property \\\"" + e.getName() + "\\\"\"); \r\n");
        this.write(indent + "}\r\n");
    }

    public static enum JavaGenClass {
        Type,
        Resource,
        Constraint;

    }
}

