/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SearchParameterValidator
extends BaseValidator {
    private FHIRPathEngine fpe;

    public SearchParameterValidator(BaseValidator parent, FHIRPathEngine fpe) {
        super(parent);
        this.fpe = fpe;
    }

    public boolean validateSearchParameter(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        String master;
        boolean ok = true;
        if (cs.hasChild("expression", false)) {
            ArrayList<String> bases = new ArrayList<String>();
            for (Element b : cs.getChildrenByName("base")) {
                if (b.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/searchparameter-base-type")) {
                    bases.add(b.getExtensionValue("http://hl7.org/fhir/tools/StructureDefinition/searchparameter-base-type").primitiveValue());
                    continue;
                }
                bases.add(b.primitiveValue());
            }
            if (!bases.isEmpty()) {
                boolean bl = ok = this.checkExpression(errors, stack.push(cs.getNamedChild("expression", false), -1, null, null), cs.getNamedChildValue("expression", false), bases) && ok;
            }
        }
        if (!Utilities.noString((String)(master = cs.getNamedChildValue("derivedFrom", false)))) {
            SearchParameter sp = (SearchParameter)this.context.fetchResource(SearchParameter.class, master);
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp != null, "SEARCHPARAMETER_NOTFOUND", master)) {
                List bl = cs.getChildren("base");
                for (Object b : bl) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), sp.hasBase(b.primitiveValue()) || sp.hasBase("Resource"), "SEARCHPARAMETER_BASE_WRONG", master, b.primitiveValue()) && ok;
                }
                boolean bl2 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !cs.hasChild("type", false) || sp.getType().toCode().equals(cs.getNamedChildValue("type", false)), "SEARCHPARAMETER_TYPE_WRONG", master, sp.getType().toCode(), cs.getNamedChildValue("type", false)) && ok;
                if (sp.hasExpression() && cs.hasChild("expression", false) && !sp.getExpression().equals(cs.getNamedChildValue("expression", false))) {
                    ArrayList<String> bases = new ArrayList<String>();
                    for (Element b : cs.getChildren("base")) {
                        bases.add(b.primitiveValue());
                    }
                    String expThis = this.canonicalise(cs.getNamedChildValue("expression", false), bases);
                    String expOther = this.canonicalise(sp.getExpression(), bases);
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), expThis.equals(expOther), "SEARCHPARAMETER_EXP_WRONG", master, sp.getExpression(), cs.getNamedChildValue("expression", false));
                }
            }
        }
        if ("composite".equals(cs.getNamedChildValue("type", false))) {
            List components = cs.getChildren("component");
            if (!this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), components.size() > 1, "SEARCHPARAMETER_MISSING_COMPONENTS", new Object[0])) {
                ok = false;
            }
        }
        return ok;
    }

    private boolean checkExpression(List<ValidationMessage> errors, NodeStack stack, String expression, List<String> bases) {
        boolean ok = true;
        try {
            ArrayList warnings = new ArrayList();
            this.fpe.checkOnTypes(null, "Resource", bases.size() == 1 ? bases.get(0) : "Resource", bases, this.fpe.parse(expression), warnings);
            for (FHIRPathEngine.IssueMessage m : warnings) {
                this.warning(errors, "2023-07-27", ValidationMessage.IssueType.BUSINESSRULE, stack, m.getId(), false, m.getMessage(), new Object[0]);
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, false, "ED_SEARCH_EXPRESSION_ERROR", expression, e.getMessage()) && ok;
        }
        return ok;
    }

    private String canonicalise(String path, List<String> bases) {
        ExpressionNode exp = this.fpe.parse(path);
        ArrayList<ExpressionNode> pass = new ArrayList<ExpressionNode>();
        while (exp != null) {
            String name;
            if (exp.getKind() != ExpressionNode.Kind.Name && (exp.getKind() != ExpressionNode.Kind.Group || exp.getGroup().getKind() != ExpressionNode.Kind.Name)) {
                return path;
            }
            if (exp.getOperation() != null && exp.getOperation() != ExpressionNode.Operation.Union) {
                return path;
            }
            ExpressionNode nexp = exp.getOpNext();
            exp.setOperation(null);
            exp.setOpNext(null);
            String string = name = exp.getKind() == ExpressionNode.Kind.Name ? exp.getName() : exp.getGroup().getName();
            if (this.context.getResourceNames().contains(name)) {
                if (bases.contains(name)) {
                    pass.add(exp);
                }
            } else {
                pass.add(exp);
            }
            exp = nexp;
        }
        Collections.sort(pass, new FhirPathSorter());
        for (int i = 0; i < pass.size() - 1; ++i) {
            ((ExpressionNode)pass.get(i)).setOperation(ExpressionNode.Operation.Union);
            ((ExpressionNode)pass.get(i)).setOpNext((ExpressionNode)pass.get(i + 1));
        }
        return pass.size() > 0 ? ((ExpressionNode)pass.get(0)).toString() : null;
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

