/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.terminologies.JurisdictionUtilities;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.validation.cli.model.HtmlInMarkdownCheck;
import org.hl7.fhir.validation.cli.services.ValidatorWatchMode;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.cli.utils.ValidationLevel;

public class CliContext {
    @JsonProperty(value="baseEngine")
    @SerializedName(value="baseEngine")
    private String baseEngine = null;
    @JsonProperty(value="doNative")
    @SerializedName(value="doNative")
    private boolean doNative = false;
    @JsonProperty(value="hintAboutNonMustSupport")
    @SerializedName(value="hintAboutNonMustSupport")
    private boolean hintAboutNonMustSupport = false;
    @JsonProperty(value="recursive")
    @SerializedName(value="recursive")
    private boolean recursive = false;
    @JsonProperty(value="showMessagesFromReferences")
    @SerializedName(value="showMessagesFromReferences")
    private boolean showMessagesFromReferences = false;
    @JsonProperty(value="doDebug")
    @SerializedName(value="doDebug")
    private boolean doDebug = false;
    @JsonProperty(value="assumeValidRestReferences")
    @SerializedName(value="assumeValidRestReferences")
    private boolean assumeValidRestReferences = false;
    @JsonProperty(value="checkReferences")
    @SerializedName(value="checkReferences")
    private boolean checkReferences = false;
    @JsonProperty(value="resolutionContext")
    @SerializedName(value="resolutionContext")
    private String resolutionContext = null;
    @JsonProperty(value="canDoNative")
    @SerializedName(value="canDoNative")
    private boolean canDoNative = false;
    @JsonProperty(value="noInternalCaching")
    @SerializedName(value="noInternalCaching")
    private boolean noInternalCaching = false;
    @JsonProperty(value="noExtensibleBindingMessages")
    @SerializedName(value="noExtensibleBindingMessages")
    private boolean noExtensibleBindingMessages = false;
    @JsonProperty(value="noUnicodeBiDiControlChars")
    @SerializedName(value="noUnicodeBiDiControlChars")
    private boolean noUnicodeBiDiControlChars = false;
    @JsonProperty(value="noInvariants")
    @SerializedName(value="noInvariants")
    private boolean noInvariants = false;
    @JsonProperty(value="displayWarnings")
    @SerializedName(value="displayWarnings")
    private boolean displayWarnings = false;
    @JsonProperty(value="wantInvariantsInMessages")
    @SerializedName(value="wantInvariantsInMessages")
    private boolean wantInvariantsInMessages = false;
    @JsonProperty(value="doImplicitFHIRPathStringConversion")
    @SerializedName(value="doImplicitFHIRPathStringConversion")
    private boolean doImplicitFHIRPathStringConversion = false;
    @JsonProperty(value="htmlInMarkdownCheck")
    @SerializedName(value="htmlInMarkdownCheck")
    private HtmlInMarkdownCheck htmlInMarkdownCheck = HtmlInMarkdownCheck.WARNING;
    @JsonProperty(value="allowDoubleQuotesInFHIRPath")
    @SerializedName(value="allowDoubleQuotesInFHIRPath")
    private boolean allowDoubleQuotesInFHIRPath = false;
    @JsonProperty(value="disableDefaultResourceFetcher")
    @SerializedName(value="disableDefaultResourceFetcher")
    private boolean disableDefaultResourceFetcher = false;
    @JsonProperty(value="checkIPSCodes")
    @SerializedName(value="checkIPSCodes")
    private boolean checkIPSCodes;
    @JsonProperty(value="langTransform")
    @SerializedName(value="langTransform")
    private String langTransform = null;
    @JsonProperty(value="map")
    @SerializedName(value="map")
    private String map = null;
    @JsonProperty(value="source")
    @SerializedName(value="source")
    private String source = null;
    @JsonProperty(value="output")
    @SerializedName(value="output")
    private String output = null;
    @JsonProperty(value="outputSuffix")
    @SerializedName(value="outputSuffix")
    private String outputSuffix;
    @JsonProperty(value="htmlOutput")
    @SerializedName(value="htmlOutput")
    private String htmlOutput = null;
    @JsonProperty(value="txServer")
    @SerializedName(value="txServer")
    private String txServer = FhirSettings.getTxFhirProduction();
    @JsonProperty(value="sv")
    @SerializedName(value="sv")
    private String sv = null;
    @JsonProperty(value="txLog")
    @SerializedName(value="txLog")
    private String txLog = null;
    @JsonProperty(value="txCache")
    @SerializedName(value="txCache")
    private String txCache = null;
    @JsonProperty(value="mapLog")
    @SerializedName(value="mapLog")
    private String mapLog = null;
    @JsonProperty(value="lang")
    @SerializedName(value="lang")
    private String lang = null;
    @JsonProperty(value="fhirpath")
    @SerializedName(value="fhirpath")
    private String fhirpath = null;
    @JsonProperty(value="snomedCT")
    @SerializedName(value="snomedCT")
    private String snomedCT = "900000000000207008";
    @JsonProperty(value="targetVer")
    @SerializedName(value="targetVer")
    private String targetVer = null;
    @JsonProperty(value="packageName")
    @SerializedName(value="packageName")
    private String packageName = null;
    @JsonProperty(value="noEcosystem")
    @SerializedName(value="noEcosystem")
    private boolean noEcosystem = false;
    @JsonProperty(value="extensions")
    @SerializedName(value="extensions")
    private List<String> extensions = new ArrayList<String>();
    @JsonProperty(value="igs")
    @SerializedName(value="igs")
    private List<String> igs = new ArrayList<String>();
    @JsonProperty(value="questionnaire")
    @SerializedName(value="questionnaire")
    private QuestionnaireMode questionnaireMode = QuestionnaireMode.CHECK;
    @JsonProperty(value="level")
    @SerializedName(value="level")
    private ValidationLevel level = ValidationLevel.HINTS;
    @JsonProperty(value="options")
    @SerializedName(value="options")
    private List<String> options = new ArrayList<String>();
    @JsonProperty(value="profiles")
    @SerializedName(value="profiles")
    private List<String> profiles = new ArrayList<String>();
    @JsonProperty(value="sources")
    @SerializedName(value="sources")
    private List<String> sources = new ArrayList<String>();
    @JsonProperty(value="inputs")
    @SerializedName(value="inputs")
    private List<String> inputs = new ArrayList<String>();
    @JsonProperty(value="modeParams")
    @SerializedName(value="modeParams")
    private Set<String> modeParams = new HashSet<String>();
    @JsonProperty(value="mode")
    @SerializedName(value="mode")
    private EngineMode mode = EngineMode.VALIDATION;
    @JsonProperty(value="securityChecks")
    @SerializedName(value="securityChecks")
    private boolean securityChecks = false;
    @JsonProperty(value="crumbTrails")
    @SerializedName(value="crumbTrails")
    private boolean crumbTrails = false;
    @JsonProperty(value="showMessageIds")
    @SerializedName(value="showMessageIds")
    private boolean showMessageIds = false;
    @JsonProperty(value="forPublication")
    @SerializedName(value="forPublication")
    private boolean forPublication = false;
    @JsonProperty(value="aiService")
    @SerializedName(value="aiService")
    private String aiService;
    @JsonProperty(value="allowExampleUrls")
    @SerializedName(value="allowExampleUrls")
    private boolean allowExampleUrls = false;
    @JsonProperty(value="showTimes")
    @SerializedName(value="showTimes")
    private boolean showTimes = false;
    @JsonProperty(value="showTerminologyRouting")
    @SerializedName(value="showTerminologyRouting")
    private boolean showTerminologyRouting = false;
    @JsonProperty(value="clearTxCache")
    @SerializedName(value="clearTxCache")
    private boolean clearTxCache = false;
    @JsonProperty(value="locale")
    @SerializedName(value="locale")
    private String locale = Locale.ENGLISH.toLanguageTag();
    @JsonProperty(value="locations")
    @SerializedName(value="locations")
    private Map<String, String> locations = new HashMap<String, String>();
    @JsonProperty(value="outputStyle")
    @SerializedName(value="outputStyle")
    private String outputStyle = null;
    @JsonProperty(value="bundleValidationRules")
    @SerializedName(value="bundleValidationRules")
    private List<BundleValidationRule> bundleValidationRules = new ArrayList<BundleValidationRule>();
    @JsonProperty(value="jurisdiction")
    @SerializedName(value="jurisdiction")
    private String jurisdiction = JurisdictionUtilities.getJurisdictionFromLocale((String)Locale.getDefault().getCountry());
    @JsonProperty(value="srcLang")
    @SerializedName(value="srcLang")
    private String srcLang = null;
    @JsonProperty(value="tgtLang")
    @SerializedName(value="tgtLang")
    private String tgtLang = null;
    @JsonProperty(value="fhirSettingsFile")
    @SerializedName(value="fhirSettingsFile")
    private String fhirSettingsFile;
    @JsonProperty(value="watchMode")
    @SerializedName(value="watchMode")
    private ValidatorWatchMode watchMode = ValidatorWatchMode.NONE;
    @JsonProperty(value="watchScanDelay")
    @SerializedName(value="watchScanDelay")
    private int watchScanDelay = 1000;
    @JsonProperty(value="watchSettleTime")
    @SerializedName(value="watchSettleTime")
    private int watchSettleTime = 100;
    @JsonProperty(value="bestPracticeLevel")
    @SerializedName(value="bestPracticeLevel")
    private BestPracticeWarningLevel bestPracticeLevel = BestPracticeWarningLevel.Warning;
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    @SerializedName(value="unknownCodeSystemsCauseErrors")
    private boolean unknownCodeSystemsCauseErrors;
    @JsonProperty(value="noExperimentalContent")
    @SerializedName(value="noExperimentalContent")
    private boolean noExperimentalContent;
    @JsonProperty(value="advisorFile")
    @SerializedName(value="advisorFile")
    private String advisorFile;
    @JsonProperty(value="expansionParameters")
    @SerializedName(value="expansionParameters")
    private String expansionParameters;
    @JsonProperty(value="format")
    @SerializedName(value="format")
    private Manager.FhirFormat format;

    @SerializedName(value="baseEngine")
    @JsonProperty(value="baseEngine")
    public String getBaseEngine() {
        return this.baseEngine;
    }

    @SerializedName(value="baseEngine")
    @JsonProperty(value="baseEngine")
    public CliContext setBaseEngine(String baseEngine) {
        this.baseEngine = baseEngine;
        return this;
    }

    @SerializedName(value="map")
    @JsonProperty(value="map")
    public String getMap() {
        return this.map;
    }

    @SerializedName(value="map")
    @JsonProperty(value="map")
    public CliContext setMap(String map) {
        this.map = map;
        return this;
    }

    @SerializedName(value="source")
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @SerializedName(value="source")
    @JsonProperty(value="source")
    public CliContext setSource(String source) {
        this.source = source;
        return this;
    }

    @SerializedName(value="resolutionContext")
    @JsonProperty(value="resolutionContext")
    public String getResolutionContext() {
        return this.resolutionContext;
    }

    @SerializedName(value="resolutionContext")
    @JsonProperty(value="resolutionContext")
    public CliContext setResolutionContext(String resolutionContext) {
        this.resolutionContext = resolutionContext;
        return this;
    }

    @SerializedName(value="langTransform")
    @JsonProperty(value="langTransform")
    public String getLangTransform() {
        return this.langTransform;
    }

    @SerializedName(value="langTransform")
    @JsonProperty(value="langTransform")
    public CliContext setLangTransform(String langTransform) {
        this.langTransform = langTransform;
        return this;
    }

    @SerializedName(value="igs")
    @JsonProperty(value="igs")
    public List<String> getIgs() {
        return this.igs;
    }

    @SerializedName(value="igs")
    @JsonProperty(value="igs")
    public CliContext setIgs(List<String> igs) {
        this.igs = igs;
        return this;
    }

    @SerializedName(value="bundleValidationRules")
    @JsonProperty(value="bundleValidationRules")
    public List<BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    @SerializedName(value="bundleValidationRules")
    @JsonProperty(value="bundleValidationRules")
    public CliContext setBundleValidationRules(List<BundleValidationRule> bundleValidationRules) {
        this.bundleValidationRules = bundleValidationRules;
        return this;
    }

    public CliContext addIg(String ig) {
        if (this.igs == null) {
            this.igs = new ArrayList<String>();
        }
        this.igs.add(ig);
        return this;
    }

    @SerializedName(value="questionnaire")
    @JsonProperty(value="questionnaire")
    public QuestionnaireMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    @SerializedName(value="questionnaire")
    @JsonProperty(value="questionnaire")
    public CliContext setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    @SerializedName(value="level")
    @JsonProperty(value="level")
    public ValidationLevel getLevel() {
        return this.level;
    }

    @SerializedName(value="level")
    @JsonProperty(value="level")
    public CliContext setLevel(ValidationLevel level) {
        this.level = level;
        return this;
    }

    @SerializedName(value="txServer")
    @JsonProperty(value="txServer")
    public String getTxServer() {
        return this.txServer;
    }

    @SerializedName(value="txServer")
    @JsonProperty(value="txServer")
    public CliContext setTxServer(String txServer) {
        this.txServer = txServer;
        return this;
    }

    @SerializedName(value="noEcosystem")
    @JsonProperty(value="noEcosystem")
    public boolean getNoEcosystem() {
        return this.noEcosystem;
    }

    @SerializedName(value="noEcosystem")
    @JsonProperty(value="noEcosystem")
    public CliContext setNoEcosystem(boolean noEcosystem) {
        this.noEcosystem = noEcosystem;
        return this;
    }

    @SerializedName(value="doNative")
    @JsonProperty(value="doNative")
    public boolean isDoNative() {
        return this.doNative;
    }

    @SerializedName(value="doNative")
    @JsonProperty(value="doNative")
    public CliContext setDoNative(boolean doNative) {
        this.doNative = doNative;
        return this;
    }

    @SerializedName(value="extensions")
    @JsonProperty(value="extensions")
    public List<String> getExtensions() {
        return this.extensions;
    }

    @SerializedName(value="extensions")
    @JsonProperty(value="extensions")
    public CliContext setExtensions(List<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    @SerializedName(value="hintAboutNonMustSupport")
    @JsonProperty(value="hintAboutNonMustSupport")
    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    @SerializedName(value="hintAboutNonMustSupport")
    @JsonProperty(value="hintAboutNonMustSupport")
    public CliContext setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
        return this;
    }

    @SerializedName(value="recursive")
    @JsonProperty(value="recursive")
    public boolean isRecursive() {
        return this.recursive;
    }

    @SerializedName(value="recursive")
    @JsonProperty(value="recursive")
    public CliContext setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @SerializedName(value="showMessagesFromReferences")
    @JsonProperty(value="showMessagesFromReferences")
    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    @SerializedName(value="showMessagesFromReferences")
    @JsonProperty(value="showMessagesFromReferences")
    public CliContext setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
        return this;
    }

    @SerializedName(value="doImplicitFHIRPathStringConversion")
    @JsonProperty(value="doImplicitFHIRPathStringConversion")
    public boolean isDoImplicitFHIRPathStringConversion() {
        return this.doImplicitFHIRPathStringConversion;
    }

    @SerializedName(value="doImplicitFHIRPathStringConversion")
    @JsonProperty(value="doImplicitFHIRPathStringConversion")
    public void setDoImplicitFHIRPathStringConversion(boolean doImplicitFHIRPathStringConversion) {
        this.doImplicitFHIRPathStringConversion = doImplicitFHIRPathStringConversion;
    }

    @SerializedName(value="htmlInMarkdownCheck")
    @JsonProperty(value="htmlInMarkdownCheck")
    public HtmlInMarkdownCheck getHtmlInMarkdownCheck() {
        return this.htmlInMarkdownCheck;
    }

    @SerializedName(value="htmlInMarkdownCheck")
    @JsonProperty(value="htmlInMarkdownCheck")
    public void setHtmlInMarkdownCheck(HtmlInMarkdownCheck htmlInMarkdownCheck) {
        this.htmlInMarkdownCheck = htmlInMarkdownCheck;
    }

    @SerializedName(value="allowDoubleQuotesInFHIRPath")
    @JsonProperty(value="allowDoubleQuotesInFHIRPath")
    public boolean isAllowDoubleQuotesInFHIRPath() {
        return this.allowDoubleQuotesInFHIRPath;
    }

    @SerializedName(value="allowDoubleQuotesInFHIRPath")
    @JsonProperty(value="allowDoubleQuotesInFHIRPath")
    public void setAllowDoubleQuotesInFHIRPath(boolean allowDoubleQuotesInFHIRPath) {
        this.allowDoubleQuotesInFHIRPath = allowDoubleQuotesInFHIRPath;
    }

    @SerializedName(value="disableDefaultResourceFetcher")
    @JsonProperty(value="disableDefaultResourceFetcher")
    public boolean isDisableDefaultResourceFetcher() {
        return this.disableDefaultResourceFetcher;
    }

    @SerializedName(value="disableDefaultResourceFetcher")
    @JsonProperty(value="disableDefaultResourceFetcher")
    public CliContext setDisableDefaultResourceFetcher(boolean disableDefaultResourceFetcher) {
        this.disableDefaultResourceFetcher = disableDefaultResourceFetcher;
        return this;
    }

    @SerializedName(value="checkIPSCodes")
    @JsonProperty(value="checkIPSCodes")
    public boolean isCheckIPSCodes() {
        return this.checkIPSCodes;
    }

    @SerializedName(value="checkIPSCodes")
    @JsonProperty(value="checkIPSCodes")
    public CliContext setCheckIPSCodes(boolean checkIPSCodes) {
        this.checkIPSCodes = checkIPSCodes;
        return this;
    }

    @SerializedName(value="locale")
    @JsonProperty(value="locale")
    public String getLanguageCode() {
        return this.locale;
    }

    public Locale getLocale() {
        return Locale.forLanguageTag(this.locale);
    }

    @SerializedName(value="locale")
    @JsonProperty(value="locale")
    public CliContext setLocale(String languageString) {
        this.locale = languageString;
        return this;
    }

    public CliContext setLocale(Locale locale) {
        this.locale = locale.getLanguage();
        return this;
    }

    @SerializedName(value="profiles")
    @JsonProperty(value="profiles")
    public List<String> getProfiles() {
        return this.profiles;
    }

    @SerializedName(value="profiles")
    @JsonProperty(value="profiles")
    public CliContext setProfiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public CliContext addProfile(String profile) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profile);
        return this;
    }

    @SerializedName(value="options")
    @JsonProperty(value="options")
    public List<String> getOptions() {
        return this.options;
    }

    @SerializedName(value="options")
    @JsonProperty(value="options")
    public CliContext setOptions(List<String> options) {
        this.options = options;
        return this;
    }

    public CliContext addOption(String option) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(option);
        return this;
    }

    @SerializedName(value="mode")
    @JsonProperty(value="mode")
    public EngineMode getMode() {
        return this.mode;
    }

    @SerializedName(value="mode")
    @JsonProperty(value="mode")
    public CliContext setMode(EngineMode mode) {
        this.mode = mode;
        return this;
    }

    @SerializedName(value="output")
    @JsonProperty(value="output")
    public String getOutput() {
        return this.output;
    }

    @SerializedName(value="output")
    @JsonProperty(value="output")
    public CliContext setOutput(String output) {
        this.output = output;
        return this;
    }

    @SerializedName(value="outputSuffix")
    @JsonProperty(value="outputSuffix")
    public String getOutputSuffix() {
        return this.outputSuffix;
    }

    @SerializedName(value="outputSuffix")
    @JsonProperty(value="outputSuffix")
    public CliContext setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
        return this;
    }

    @SerializedName(value="htmlOutput")
    @JsonProperty(value="htmlOutput")
    public String getHtmlOutput() {
        return this.htmlOutput;
    }

    @SerializedName(value="htmlOutput")
    @JsonProperty(value="htmlOutput")
    public CliContext setHtmlOutput(String htmlOutput) {
        this.htmlOutput = htmlOutput;
        return this;
    }

    @SerializedName(value="canDoNative")
    @JsonProperty(value="canDoNative")
    public boolean getCanDoNative() {
        return this.canDoNative;
    }

    @SerializedName(value="canDoNative")
    @JsonProperty(value="canDoNative")
    public CliContext setCanDoNative(boolean canDoNative) {
        this.canDoNative = canDoNative;
        return this;
    }

    @SerializedName(value="sources")
    @JsonProperty(value="sources")
    public List<String> getSources() {
        return this.sources;
    }

    @SerializedName(value="inputs")
    @JsonProperty(value="inputs")
    public List<String> getInputs() {
        return this.inputs;
    }

    @SerializedName(value="modeParams")
    @JsonProperty(value="modeParams")
    public Set<String> getModeParams() {
        return this.modeParams;
    }

    @SerializedName(value="sources")
    @JsonProperty(value="sources")
    public CliContext setSources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public CliContext addSource(String source) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(source);
        return this;
    }

    @SerializedName(value="locations")
    @JsonProperty(value="locations")
    public Map<String, String> getLocations() {
        return this.locations;
    }

    @SerializedName(value="locations")
    @JsonProperty(value="locations")
    public CliContext setLocations(Map<String, String> locations) {
        this.locations = locations;
        return this;
    }

    public CliContext addLocation(String profile, String location) {
        this.locations.put(profile, location);
        return this;
    }

    @SerializedName(value="sv")
    @JsonProperty(value="sv")
    public String getSv() {
        return this.sv;
    }

    @SerializedName(value="sv")
    @JsonProperty(value="sv")
    public CliContext setSv(String sv) {
        this.sv = sv != null && (sv.startsWith("R") || sv.startsWith("r")) ? VersionUtilities.versionFromCode((String)sv.toLowerCase()) : sv;
        return this;
    }

    @SerializedName(value="txLog")
    @JsonProperty(value="txLog")
    public String getTxLog() {
        return this.txLog;
    }

    @SerializedName(value="txLog")
    @JsonProperty(value="txLog")
    public CliContext setTxLog(String txLog) {
        this.txLog = txLog;
        return this;
    }

    @SerializedName(value="txCache")
    @JsonProperty(value="txCache")
    public String getTxCache() {
        return this.txCache;
    }

    @SerializedName(value="txCache")
    @JsonProperty(value="txCache")
    public CliContext setTxCache(String txCache) {
        this.txCache = txCache;
        return this;
    }

    @SerializedName(value="mapLog")
    @JsonProperty(value="mapLog")
    public String getMapLog() {
        return this.mapLog;
    }

    @SerializedName(value="mapLog")
    @JsonProperty(value="mapLog")
    public CliContext setMapLog(String mapLog) {
        this.mapLog = mapLog;
        return this;
    }

    @SerializedName(value="lang")
    @JsonProperty(value="lang")
    public String getLang() {
        return this.lang;
    }

    @SerializedName(value="lang")
    @JsonProperty(value="lang")
    public CliContext setLang(String lang) {
        this.lang = lang;
        return this;
    }

    @SerializedName(value="fhirpath")
    @JsonProperty(value="fhirpath")
    public String getFhirpath() {
        return this.fhirpath;
    }

    @SerializedName(value="fhirpath")
    @JsonProperty(value="fhirpath")
    public CliContext setFhirpath(String fhirpath) {
        this.fhirpath = fhirpath;
        return this;
    }

    @SerializedName(value="snomedCT")
    @JsonProperty(value="snomedCT")
    public String getSnomedCTCode() {
        if ("intl".equals(this.snomedCT)) {
            return "900000000000207008";
        }
        if ("us".equals(this.snomedCT)) {
            return "731000124108";
        }
        if ("us+icd10cm".equals(this.snomedCT)) {
            return "5991000124107";
        }
        if ("uk/clinical".equals(this.snomedCT)) {
            return "999000021000000109";
        }
        if ("uk".equals(this.snomedCT)) {
            return "83821000000107";
        }
        if ("au".equals(this.snomedCT)) {
            return "32506021000036107";
        }
        if ("at".equals(this.snomedCT)) {
            return "11000234105";
        }
        if ("ca".equals(this.snomedCT)) {
            return "20621000087109";
        }
        if ("ca-en".equals(this.snomedCT)) {
            return "20621000087109";
        }
        if ("ca-fr".equals(this.snomedCT)) {
            return "20611000087101";
        }
        if ("nl".equals(this.snomedCT)) {
            return "11000146104";
        }
        if ("se".equals(this.snomedCT)) {
            return "45991000052106";
        }
        if ("es".equals(this.snomedCT)) {
            return "449081005";
        }
        if ("es-ES".equals(this.snomedCT)) {
            return "900000001000122104";
        }
        if ("ar".equals(this.snomedCT)) {
            return "11000221109";
        }
        if ("dk".equals(this.snomedCT)) {
            return "554471000005108";
        }
        if ("be".equals(this.snomedCT)) {
            return "11000172109";
        }
        if ("ee".equals(this.snomedCT)) {
            return "11000181102";
        }
        if ("fi".equals(this.snomedCT)) {
            return "11000229106";
        }
        if ("de".equals(this.snomedCT)) {
            return "11000274103";
        }
        if ("in".equals(this.snomedCT)) {
            return "1121000189102";
        }
        if ("ie".equals(this.snomedCT)) {
            return "11000220105";
        }
        if ("nl".equals(this.snomedCT)) {
            return "11000146104";
        }
        if ("nz".equals(this.snomedCT)) {
            return "21000210109";
        }
        if ("no".equals(this.snomedCT)) {
            return "51000202101";
        }
        if ("kr".equals(this.snomedCT)) {
            return "11000267109";
        }
        if ("se".equals(this.snomedCT)) {
            return "45991000052106";
        }
        if ("ch".equals(this.snomedCT)) {
            return "2011000195101";
        }
        if ("uy".equals(this.snomedCT)) {
            return "5631000179106";
        }
        return this.snomedCT;
    }

    @SerializedName(value="snomedCT")
    @JsonProperty(value="snomedCT")
    public CliContext setSnomedCT(String snomedCT) {
        this.snomedCT = snomedCT;
        return this;
    }

    @SerializedName(value="targetVer")
    @JsonProperty(value="targetVer")
    public String getTargetVer() {
        return this.targetVer;
    }

    @SerializedName(value="targetVer")
    @JsonProperty(value="targetVer")
    public CliContext setTargetVer(String targetVer) {
        this.targetVer = targetVer;
        return this;
    }

    @SerializedName(value="packageName")
    @JsonProperty(value="packageName")
    public String getPackageName() {
        return this.packageName;
    }

    @SerializedName(value="packageName")
    @JsonProperty(value="packageName")
    public CliContext setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @SerializedName(value="doDebug")
    @JsonProperty(value="doDebug")
    public boolean isDoDebug() {
        return this.doDebug;
    }

    @SerializedName(value="doDebug")
    @JsonProperty(value="doDebug")
    public CliContext setDoDebug(boolean doDebug) {
        this.doDebug = doDebug;
        return this;
    }

    @SerializedName(value="assumeValidRestReferences")
    @JsonProperty(value="assumeValidRestReferences")
    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    @SerializedName(value="assumeValidRestReferences")
    @JsonProperty(value="assumeValidRestReferences")
    public CliContext setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
        return this;
    }

    @SerializedName(value="checkReferences")
    @JsonProperty(value="checkReferences")
    public boolean isCheckReferences() {
        return this.checkReferences;
    }

    @SerializedName(value="checkReferences")
    @JsonProperty(value="checkReferences")
    public CliContext setCheckReferences(boolean checkReferences) {
        this.checkReferences = checkReferences;
        return this;
    }

    @SerializedName(value="noInternalCaching")
    @JsonProperty(value="noInternalCaching")
    public boolean isNoInternalCaching() {
        return this.noInternalCaching;
    }

    @SerializedName(value="noInternalCaching")
    @JsonProperty(value="noInternalCaching")
    public CliContext setNoInternalCaching(boolean noInternalCaching) {
        this.noInternalCaching = noInternalCaching;
        return this;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public CliContext setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    @SerializedName(value="noInvariants")
    @JsonProperty(value="noInvariants")
    public boolean isNoInvariants() {
        return this.noInvariants;
    }

    @SerializedName(value="noInvariants")
    @JsonProperty(value="noInvariants")
    public void setNoInvariants(boolean noInvariants) {
        this.noInvariants = noInvariants;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public void setDisplayWarnings(boolean displayWarnings) {
        this.displayWarnings = displayWarnings;
    }

    @SerializedName(value="wantInvariantsInMessages")
    @JsonProperty(value="wantInvariantsInMessages")
    public boolean isWantInvariantsInMessages() {
        return this.wantInvariantsInMessages;
    }

    @SerializedName(value="wantInvariantsInMessages")
    @JsonProperty(value="wantInvariantsInMessages")
    public void setWantInvariantsInMessages(boolean wantInvariantsInMessages) {
        this.wantInvariantsInMessages = wantInvariantsInMessages;
    }

    @SerializedName(value="securityChecks")
    @JsonProperty(value="securityChecks")
    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    @SerializedName(value="securityChecks")
    @JsonProperty(value="securityChecks")
    public CliContext setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
        return this;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    public boolean isShowMessageIds() {
        return this.showMessageIds;
    }

    public void setShowMessageIds(boolean showMessageIds) {
        this.showMessageIds = showMessageIds;
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public void setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
    }

    public String getAIService() {
        return this.aiService;
    }

    public void setAIService(String aiService) {
        this.aiService = aiService;
    }

    public boolean isAllowExampleUrls() {
        return this.allowExampleUrls;
    }

    public void setAllowExampleUrls(boolean allowExampleUrls) {
        this.allowExampleUrls = allowExampleUrls;
    }

    public boolean isShowTimes() {
        return this.showTimes;
    }

    public void setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
    }

    public boolean isShowTerminologyRouting() {
        return this.showTerminologyRouting;
    }

    public void setShowTerminologyRouting(boolean showTerminologyRouting) {
        this.showTerminologyRouting = showTerminologyRouting;
    }

    public boolean isClearTxCache() {
        return this.clearTxCache;
    }

    public void setClearTxCache(boolean clearTxCache) {
        this.clearTxCache = clearTxCache;
    }

    public String getOutputStyle() {
        return this.outputStyle;
    }

    public void setOutputStyle(String outputStyle) {
        this.outputStyle = outputStyle;
    }

    public boolean isNoUnicodeBiDiControlChars() {
        return this.noUnicodeBiDiControlChars;
    }

    public void setNoUnicodeBiDiControlChars(boolean noUnicodeBiDiControlChars) {
        this.noUnicodeBiDiControlChars = noUnicodeBiDiControlChars;
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public String getSrcLang() {
        return this.srcLang;
    }

    public void setSrcLang(String srcLang) {
        this.srcLang = srcLang;
    }

    public String getTgtLang() {
        return this.tgtLang;
    }

    public void setTgtLang(String tgtLang) {
        this.tgtLang = tgtLang;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CliContext that = (CliContext)o;
        return Objects.equals(this.baseEngine, that.baseEngine) && this.doNative == that.doNative && this.hintAboutNonMustSupport == that.hintAboutNonMustSupport && this.recursive == that.recursive && this.doDebug == that.doDebug && this.assumeValidRestReferences == that.assumeValidRestReferences && this.checkReferences == that.checkReferences && this.canDoNative == that.canDoNative && this.noInternalCaching == that.noInternalCaching && this.noExtensibleBindingMessages == that.noExtensibleBindingMessages && this.noUnicodeBiDiControlChars == that.noUnicodeBiDiControlChars && this.noInvariants == that.noInvariants && this.displayWarnings == that.displayWarnings && this.wantInvariantsInMessages == that.wantInvariantsInMessages && this.allowDoubleQuotesInFHIRPath == that.allowDoubleQuotesInFHIRPath && this.checkIPSCodes == that.checkIPSCodes && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.map, that.map) && Objects.equals(this.resolutionContext, that.resolutionContext) && Objects.equals((Object)this.htmlInMarkdownCheck, (Object)that.htmlInMarkdownCheck) && Objects.equals(this.output, that.output) && Objects.equals(this.outputSuffix, that.outputSuffix) && Objects.equals(this.htmlOutput, that.htmlOutput) && Objects.equals(this.txServer, that.txServer) && Objects.equals(this.sv, that.sv) && Objects.equals(this.txLog, that.txLog) && Objects.equals(this.txCache, that.txCache) && Objects.equals(this.mapLog, that.mapLog) && Objects.equals(this.lang, that.lang) && Objects.equals(this.srcLang, that.srcLang) && Objects.equals(this.tgtLang, that.tgtLang) && Objects.equals(this.fhirpath, that.fhirpath) && Objects.equals(this.snomedCT, that.snomedCT) && Objects.equals(this.targetVer, that.targetVer) && Objects.equals(this.packageName, that.packageName) && Objects.equals(this.igs, that.igs) && Objects.equals((Object)this.questionnaireMode, (Object)that.questionnaireMode) && Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.options, that.options) && Objects.equals(this.sources, that.sources) && Objects.equals(this.crumbTrails, that.crumbTrails) && Objects.equals(this.showMessageIds, that.showMessageIds) && Objects.equals(this.forPublication, that.forPublication) && Objects.equals(this.aiService, that.aiService) && Objects.equals(this.allowExampleUrls, that.allowExampleUrls) && Objects.equals(this.showTimes, that.showTimes) && this.mode == that.mode && Objects.equals(this.locale, that.locale) && Objects.equals(this.outputStyle, that.outputStyle) && Objects.equals(this.jurisdiction, that.jurisdiction) && Objects.equals(this.locations, that.locations) && Objects.equals((Object)this.watchMode, (Object)that.watchMode) && Objects.equals(this.bestPracticeLevel, that.bestPracticeLevel) && Objects.equals(this.watchScanDelay, that.watchScanDelay) && Objects.equals(this.unknownCodeSystemsCauseErrors, that.unknownCodeSystemsCauseErrors) && Objects.equals(this.noExperimentalContent, that.noExperimentalContent) && Objects.equals(this.advisorFile, that.advisorFile) && Objects.equals(this.expansionParameters, that.expansionParameters) && Objects.equals(this.format, that.format) && Objects.equals(this.watchSettleTime, that.watchSettleTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseEngine, this.doNative, this.extensions, this.hintAboutNonMustSupport, this.recursive, this.doDebug, this.assumeValidRestReferences, this.checkReferences, this.canDoNative, this.noInternalCaching, this.resolutionContext, this.aiService, this.noExtensibleBindingMessages, this.noInvariants, this.displayWarnings, this.wantInvariantsInMessages, this.map, this.output, this.outputSuffix, this.htmlOutput, this.txServer, this.sv, this.txLog, this.txCache, this.mapLog, this.lang, this.srcLang, this.tgtLang, this.fhirpath, this.snomedCT, this.targetVer, this.packageName, this.igs, this.questionnaireMode, this.level, this.profiles, this.options, this.sources, this.inputs, this.mode, this.locale, this.locations, this.crumbTrails, this.showMessageIds, this.forPublication, this.showTimes, this.allowExampleUrls, this.outputStyle, this.jurisdiction, this.noUnicodeBiDiControlChars, this.watchMode, this.watchScanDelay, this.watchSettleTime, this.bestPracticeLevel, this.unknownCodeSystemsCauseErrors, this.noExperimentalContent, this.advisorFile, this.expansionParameters, this.format, this.htmlInMarkdownCheck, this.allowDoubleQuotesInFHIRPath, this.checkIPSCodes});
    }

    public String toString() {
        return "CliContext{baseEngine=" + this.baseEngine + ", doNative=" + this.doNative + ", extensions=" + this.extensions + ", hintAboutNonMustSupport=" + this.hintAboutNonMustSupport + ", recursive=" + this.recursive + ", doDebug=" + this.doDebug + ", assumeValidRestReferences=" + this.assumeValidRestReferences + ", checkReferences=" + this.checkReferences + ", canDoNative=" + this.canDoNative + ", noInternalCaching=" + this.noInternalCaching + ", noExtensibleBindingMessages=" + this.noExtensibleBindingMessages + ", noUnicodeBiDiControlChars=" + this.noUnicodeBiDiControlChars + ", noInvariants=" + this.noInvariants + ", displayWarnings=" + this.displayWarnings + ", wantInvariantsInMessages=" + this.wantInvariantsInMessages + ", map='" + this.map + "', output='" + this.output + "', outputSuffix='" + this.output + "', htmlOutput='" + this.htmlOutput + "', txServer='" + this.txServer + "', sv='" + this.sv + "', txLog='" + this.txLog + "', txCache='" + this.txCache + "', mapLog='" + this.mapLog + "', resolutionContext='" + this.resolutionContext + "', lang='" + this.lang + "', srcLang='" + this.srcLang + "', tgtLang='" + this.tgtLang + "', fhirpath='" + this.fhirpath + "', snomedCT='" + this.snomedCT + "', targetVer='" + this.targetVer + "', packageName='" + this.packageName + "', igs=" + this.igs + ", questionnaireMode=" + this.questionnaireMode + ", level=" + this.level + ", profiles=" + this.profiles + ", options=" + this.options + ", sources=" + this.sources + ", inputs=" + this.inputs + ", mode=" + this.mode + ", securityChecks=" + this.securityChecks + ", crumbTrails=" + this.crumbTrails + ", showMessageIds=" + this.showMessageIds + ", forPublication=" + this.forPublication + ", aiService=" + this.aiService + ", outputStyle=" + this.outputStyle + ", jurisdiction=" + this.jurisdiction + ", allowExampleUrls=" + this.allowExampleUrls + ", showTimes=" + this.showTimes + ", locale='" + this.locale + "', locations=" + this.locations + ", bundleValidationRules=" + this.bundleValidationRules + ", htmlInMarkdownCheck=" + this.htmlInMarkdownCheck + ", allowDoubleQuotesInFHIRPath=" + this.allowDoubleQuotesInFHIRPath + ", checkIPSCodes=" + this.checkIPSCodes + ", watchMode=" + this.watchMode + ", bestPracticeLevel=" + this.bestPracticeLevel + ", watchSettleTime=" + this.watchSettleTime + ", watchScanDelay=" + this.watchScanDelay + ", unknownCodeSystemsCauseErrors=" + this.unknownCodeSystemsCauseErrors + ", noExperimentalContent=" + this.noExperimentalContent + ", advisorFile=" + this.advisorFile + ", expansionParameters=" + this.expansionParameters + ", format=" + this.format + "}";
    }

    @SerializedName(value="fhirSettingsFile")
    @JsonProperty(value="fhirSettingsFile")
    public CliContext setFhirSettingsFile(String fhirSettingsFile) {
        this.fhirSettingsFile = fhirSettingsFile;
        return this;
    }

    @SerializedName(value="fhirSettingsFile")
    @JsonProperty(value="fhirSettingsFile")
    public String getFhirSettingsFile() {
        return this.fhirSettingsFile;
    }

    @SerializedName(value="watchMode")
    @JsonProperty(value="watchMode")
    public ValidatorWatchMode getWatchMode() {
        return this.watchMode;
    }

    @SerializedName(value="watchMode")
    @JsonProperty(value="watchMode")
    public CliContext setWatchMode(ValidatorWatchMode watchMode) {
        this.watchMode = watchMode;
        return this;
    }

    @SerializedName(value="watchScanDelay")
    @JsonProperty(value="watchScanDelay")
    public int getWatchScanDelay() {
        return this.watchScanDelay;
    }

    @SerializedName(value="watchScanDelay")
    @JsonProperty(value="watchScanDelay")
    public void setWatchScanDelay(int watchScanDelay) {
        this.watchScanDelay = watchScanDelay;
    }

    @SerializedName(value="watchSettleTime")
    @JsonProperty(value="watchSettleTime")
    public int getWatchSettleTime() {
        return this.watchSettleTime;
    }

    @SerializedName(value="watchSettleTime")
    @JsonProperty(value="watchSettleTime")
    public void setWatchSettleTime(int watchSettleTime) {
        this.watchSettleTime = watchSettleTime;
    }

    @SerializedName(value="bestPracticeLevel")
    @JsonProperty(value="bestPracticeLevel")
    public BestPracticeWarningLevel getBestPracticeLevel() {
        return this.bestPracticeLevel;
    }

    @SerializedName(value="bestPracticeLevel")
    @JsonProperty(value="bestPracticeLevel")
    public CliContext setBestPracticeLevel(BestPracticeWarningLevel bestPracticeLevel) {
        this.bestPracticeLevel = bestPracticeLevel;
        return this;
    }

    @SerializedName(value="unknownCodeSystemsCauseErrors")
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    public boolean isUnknownCodeSystemsCauseErrors() {
        return this.unknownCodeSystemsCauseErrors;
    }

    @SerializedName(value="unknownCodeSystemsCauseErrors")
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    public void setUnknownCodeSystemsCauseErrors(boolean unknownCodeSystemsCauseErrors) {
        this.unknownCodeSystemsCauseErrors = unknownCodeSystemsCauseErrors;
    }

    @SerializedName(value="noExperimentalContent")
    @JsonProperty(value="noExperimentalContent")
    public boolean isNoExperimentalContent() {
        return this.noExperimentalContent;
    }

    @SerializedName(value="noExperimentalContent")
    @JsonProperty(value="noExperimentalContent")
    public void setNoExperimentalContent(boolean noExperimentalContent) {
        this.noExperimentalContent = noExperimentalContent;
    }

    @SerializedName(value="advisorFile")
    @JsonProperty(value="advisorFile")
    public String getAdvisorFile() {
        return this.advisorFile;
    }

    @SerializedName(value="advisorFile")
    @JsonProperty(value="advisorFile")
    public void setAdvisorFile(String advisorFile) {
        this.advisorFile = advisorFile;
    }

    @SerializedName(value="expansionParameters")
    @JsonProperty(value="expansionParameters")
    public String getExpansionParameters() {
        return this.expansionParameters;
    }

    @SerializedName(value="expansionParameters")
    @JsonProperty(value="expansionParameters")
    public void setExpansionParameters(String expansionParameters) {
        this.expansionParameters = expansionParameters;
    }

    @SerializedName(value="format")
    @JsonProperty(value="format")
    public Manager.FhirFormat getFormat() {
        return this.format;
    }

    @SerializedName(value="format")
    @JsonProperty(value="format")
    public void setFormat(Manager.FhirFormat format) {
        this.format = format;
    }
}

