/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.advisor;

import java.io.File;
import java.io.IOException;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.instance.advisor.RulesDrivenPolicyAdvisor;

public class JsonDrivenPolicyAdvisor
extends RulesDrivenPolicyAdvisor {
    public JsonDrivenPolicyAdvisor(IValidationPolicyAdvisor base, File source) throws JsonException, IOException {
        super(base);
        this.load(source);
    }

    public JsonDrivenPolicyAdvisor(ReferenceValidationPolicy refpol, File source) throws JsonException, IOException {
        super(refpol);
        this.load(source);
    }

    private void load(File source) throws JsonException, IOException {
        JsonObject json = JsonParser.parseObject((File)source);
        for (JsonElement e : json.forceArray("suppress").getItems()) {
            String s = e.asString();
            if (s.contains("@")) {
                String id = s.substring(0, s.indexOf("@"));
                String path = s.substring(s.indexOf("@") + 1);
                boolean regex = false;
                if (path.startsWith("^")) {
                    regex = true;
                    path = path.substring(1);
                }
                this.addSuppressMessageRule(id, path, regex);
                continue;
            }
            this.addSuppressMessageRule(s);
        }
    }
}

