/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.EnumSet;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;

public class CodeSystemBasedChecker
extends CodeSystemChecker {
    private CodeSystem cs;

    public CodeSystemBasedChecker(IWorkerContext context, XVerExtensionManager xverManager, boolean debug, List<ValidationMessage> errors, CodeSystem cs, ValidatorSession session) {
        super(context, xverManager, debug, errors, session);
        this.cs = cs;
    }

    @Override
    public void listPropertyNames(List<String> knownNames) {
        super.listPropertyNames(knownNames);
        if (this.cs.hasHierarchyMeaning()) {
            knownNames.add("parent");
            knownNames.add("child");
            knownNames.add("partOf");
        }
        for (CodeSystem.CodeSystemFilterComponent f : this.cs.getFilter()) {
            this.addName(knownNames, f.getCode());
        }
        for (CodeSystem.PropertyComponent p : this.cs.getProperty()) {
            this.addName(knownNames, p.getCode());
        }
    }

    @Override
    public ValueSetValidator.PropertyValidationRules rulesForFilter(String property, EnumSet<ValueSetValidator.PropertyOperation> ops) {
        for (CodeSystem.CodeSystemFilterComponent f : this.cs.getFilter()) {
            if (!property.equals(f.getCode())) continue;
            for (Enumeration op : f.getOperator()) {
                ops.add(this.toOp((Enumeration<Enumerations.FilterOperator>)op));
            }
        }
        for (CodeSystem.PropertyComponent p : this.cs.getProperty()) {
            if (!property.equals(p.getCode()) || p.getType() == null) continue;
            switch (p.getType()) {
                case BOOLEAN: {
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, ops);
                }
                case CODE: {
                    boolean external = !this.forPublication || this.cs.getWebPath() == null || Utilities.isAbsoluteUrl((String)this.cs.getWebPath());
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, external ? ValueSetValidator.CodeValidationRule.Warning : ValueSetValidator.CodeValidationRule.Error, ops);
                }
                case CODING: {
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Coding, null, ops);
                }
                case DATETIME: {
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.DateTime, null, ops);
                }
                case DECIMAL: {
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Decimal, null, ops);
                }
                case INTEGER: {
                    return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Integer, null, ops);
                }
                case STRING: {
                    return null;
                }
            }
        }
        return super.rulesForFilter(property, ops);
    }

    private ValueSetValidator.PropertyOperation toOp(Enumeration<Enumerations.FilterOperator> op) {
        switch ((Enumerations.FilterOperator)op.getValue()) {
            case CHILDOF: {
                return ValueSetValidator.PropertyOperation.ChildOf;
            }
            case DESCENDENTLEAF: {
                return ValueSetValidator.PropertyOperation.DescendentLeaf;
            }
            case DESCENDENTOF: {
                return ValueSetValidator.PropertyOperation.DescendentOf;
            }
            case EQUAL: {
                return ValueSetValidator.PropertyOperation.Equals;
            }
            case EXISTS: {
                return ValueSetValidator.PropertyOperation.Exists;
            }
            case GENERALIZES: {
                return ValueSetValidator.PropertyOperation.Generalizes;
            }
            case IN: {
                return ValueSetValidator.PropertyOperation.In;
            }
            case ISA: {
                return ValueSetValidator.PropertyOperation.IsA;
            }
            case ISNOTA: {
                return ValueSetValidator.PropertyOperation.IsNotA;
            }
            case NOTIN: {
                return ValueSetValidator.PropertyOperation.NotIn;
            }
            case REGEX: {
                return ValueSetValidator.PropertyOperation.RegEx;
            }
        }
        return null;
    }
}

