/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.testexecutor;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hl7.fhir.validation.testexecutor.TestModules;

public class TestExecutorParams {
    private static final String MODULE_DELIMITER = ",";

    public static boolean isValidModuleParam(String param) {
        String[] modules;
        if (param == null) {
            return true;
        }
        for (String module : modules = param.split(MODULE_DELIMITER)) {
            if (!Arrays.stream(TestModules.JUNIT5_MODULE_NAMES).noneMatch(i -> i.equals(module))) continue;
            return false;
        }
        return true;
    }

    public static String[] parseModuleParam(String param) {
        if (param == null) {
            return null;
        }
        return param.split(MODULE_DELIMITER);
    }

    public static boolean isValidClassnameFilterParam(String param) {
        if (param == null) {
            return true;
        }
        try {
            Pattern.compile(param);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

