/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.test.utils.CompareUtilities;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.network.ClientHeaders;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtil;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.validation.special.TxTesterScrubbers;
import org.hl7.fhir.validation.special.TxTesterSorters;

public class TxTester {
    private String server;
    private ITxTesterLoader loader;
    private String error;
    private String output;
    private ITerminologyClient terminologyClient;
    private boolean tight;
    private JsonObject externals;
    private String software;
    private List<String> fails = new ArrayList<String>();
    private CapabilityStatement cstmt;
    private TerminologyCapabilities tc;

    public TxTester(ITxTesterLoader loader, String server, boolean tight, JsonObject externals) {
        this.server = server;
        this.loader = loader;
        this.tight = tight;
        this.externals = externals;
    }

    public static void main(String[] args) throws Exception {
        new TxTester(new InternalTxLoader(args[0]), args[1], "true".equals(args[2]), args.length == 5 ? org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromFile((String)args[4]) : null).execute(args[2], new ArrayList<String>(), args[3]);
    }

    public boolean execute(String version, List<String> modes, String filter) throws IOException, URISyntaxException {
        if (this.output == null) {
            this.output = Utilities.path((String[])new String[]{"[tmp]", this.serverId()});
        }
        System.out.println("Run terminology service Tests");
        System.out.println("  Source for tests: " + this.loader.describe());
        System.out.println("  Output Directory: " + this.output);
        if (!new File(this.output).exists()) {
            Utilities.createDirectory((String)this.output);
        }
        if (!new File(this.output).exists()) {
            throw new IOException("Unable to create output directory " + this.output);
        }
        System.out.println("  Term Service Url: " + this.server);
        System.out.println("  External Strings: " + (this.externals != null));
        System.out.println("  Test  Exec Modes: " + modes.toString());
        if (version != null) {
            System.out.println("  Tx  FHIR Version: " + version);
        }
        if (filter != null) {
            System.out.println("  Filter Parameter: " + filter);
        }
        JsonObject json = new JsonObject();
        json.add("date", new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(Calendar.getInstance().getTime()) + this.timezone());
        try {
            JsonObject tests = this.loadTests();
            this.terminologyClient = this.connectToServer(modes);
            boolean ok = this.checkClient();
            for (JsonObject suite : tests.getJsonObjects("suites")) {
                if (suite.has("mode") && !modes.contains(suite.asString("mode")) || suite.asBoolean("disabled")) continue;
                ok = this.runSuite(suite, modes, filter, json.forceArray("suites")) && ok;
            }
            TextFile.stringToFile((String)org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)json, (boolean)true), (String)Utilities.path((String[])new String[]{this.output, "test-results.json"}));
            if (filter == null) {
                String m;
                String string = m = modes.isEmpty() ? "[none]" : CommaSeparatedStringBuilder.join((String)";", modes);
                if (ok) {
                    System.out.println(this.software + " passed all HL7 terminology service tests (" + Utilities.pluralize((String)"mode", (int)modes.size()) + " " + m + ", tests v" + this.loadVersion() + ", runner v" + VersionUtil.getBaseVersion() + ")");
                    return true;
                }
                System.out.println(this.software + " did not pass all HL7 terminology service tests (" + Utilities.pluralize((String)"mode", (int)modes.size()) + " " + m + ", tests v" + this.loadVersion() + ", runner v" + VersionUtil.getBaseVersion() + ")");
                System.out.println("Failed Tests: " + CommaSeparatedStringBuilder.join((String)",", this.fails));
                return false;
            }
            System.out.println(this.software + " " + (ok ? "Passed the tests" : "did not pass the tests") + " '" + filter + "'");
            return ok;
        }
        catch (Exception e) {
            System.out.println("Exception running Terminology Service Tests: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        Object offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + (String)offset;
        return offset;
    }

    private boolean checkClient() {
        this.cstmt = this.terminologyClient.getCapabilitiesStatement();
        if (this.cstmt.hasSoftware()) {
            this.software = this.cstmt.getSoftware().getName() + " v" + this.cstmt.getSoftware().getVersion();
        }
        this.tc = this.terminologyClient.getTerminologyCapabilities();
        return true;
    }

    private JsonObject loadTests() throws JsonException, IOException {
        System.out.println("Load Tests from " + this.loader.describe());
        return org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((byte[])this.loader.loadContent("test-cases.json"));
    }

    private String loadVersion() throws JsonException, IOException {
        return TxTester.processHistoryMarkdown(this.loader.loadContent("history.md"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processHistoryMarkdown(byte[] content) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(content));
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (!strLine.startsWith("## ")) continue;
                String string = strLine.substring(3).trim();
                return string;
            }
        }
        finally {
            br.close();
            in.close();
        }
        return "<1.6.0";
    }

    private ITerminologyClient connectToServer(List<String> modes) throws URISyntaxException, IOException {
        System.out.println("Connect to " + this.server);
        this.software = this.server;
        ITerminologyClient client = new TerminologyClientFactory(FhirPublication.R4).makeClient("Test-Server", this.server, "Tools/Java", null);
        return client;
    }

    public String executeTest(JsonObject suite, JsonObject test, List<String> modes) throws URISyntaxException, FHIRFormatError, FileNotFoundException, IOException {
        List<Resource> setup;
        this.error = null;
        if (this.terminologyClient == null) {
            this.terminologyClient = this.connectToServer(modes);
            this.checkClient();
        }
        if (this.runTest(suite, test, setup = this.loadSetupResources(suite), modes, "*", null)) {
            return null;
        }
        return this.error;
    }

    private boolean runSuite(JsonObject suite, List<String> modes, String filter, JsonArray output) throws FHIRFormatError, FileNotFoundException, IOException {
        System.out.println("Group " + suite.asString("name"));
        JsonObject outputS = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputS);
        }
        outputS.add("name", suite.asString("name"));
        List<Resource> setup = this.loadSetupResources(suite);
        boolean ok = true;
        for (JsonObject test : suite.getJsonObjects("tests")) {
            if (test.has("mode") && !modes.contains(test.asString("mode"))) continue;
            if (test.asBoolean("disabled")) {
                ok = true;
                continue;
            }
            ok = this.runTest(suite, test, setup, modes, filter, outputS.forceArray("tests")) && ok;
        }
        return ok;
    }

    private boolean runTest(JsonObject suite, JsonObject test, List<Resource> setup, List<String> modes, String filter, JsonArray output) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        JsonObject outputT = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputT);
        }
        long start = System.currentTimeMillis();
        Parameters profile = this.loadProfile(test);
        outputT.add("name", test.asString("name"));
        if (Utilities.noString((String)filter) || filter.equals("*") || test.asString("name").contains(filter)) {
            System.out.print("  Test " + test.asString("name") + ": ");
            HTTPHeader header = null;
            try {
                String reqFile;
                JsonObject hdr;
                if (test.has("header") && (hdr = test.getJsonObject("header")).has("mode") && modes.contains(hdr.asString("mode"))) {
                    header = new HTTPHeader(hdr.asString("name"), hdr.asString("value"));
                    this.terminologyClient.setClientHeaders(new ClientHeaders(List.of(header)));
                }
                Parameters req = (reqFile = this.chooseParam(test, "request", modes)) == null ? null : (Parameters)this.loader.loadResource(reqFile);
                String fn = this.chooseParam(test, "response", modes);
                String resp = TextFile.bytesToString((byte[])this.loader.loadContent(fn));
                String fp = this.output == null ? Utilities.path((String[])new String[]{"[tmp]", this.serverId(), fn}) : Utilities.path((String[])new String[]{this.output, fn});
                File fo = ManagedFileAccess.file((String)fp);
                if (fo.exists()) {
                    fo.delete();
                }
                JsonObject ext = this.externals == null ? null : this.externals.getJsonObject(fn);
                String lang = test.asString("Content-Language");
                String msg = null;
                if (test.asString("operation").equals("metadata")) {
                    msg = this.metadata(test.str("name"), setup, resp, fp, lang, profile, ext);
                } else if (test.asString("operation").equals("term-caps")) {
                    msg = this.termcaps(test.str("name"), setup, resp, fp, lang, profile, ext);
                } else if (test.asString("operation").equals("expand")) {
                    msg = this.expand(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test));
                } else if (test.asString("operation").equals("validate-code")) {
                    msg = this.validate(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test));
                } else if (test.asString("operation").equals("cs-validate-code")) {
                    msg = this.validateCS(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test));
                } else if (test.asString("operation").equals("lookup")) {
                    msg = this.lookup(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test));
                } else if (test.asString("operation").equals("translate")) {
                    msg = this.translate(test.str("name"), setup, req, resp, fp, lang, profile, ext, this.getResponseCode(test));
                } else {
                    throw new Exception("Unknown Operation " + test.asString("operation"));
                }
                System.out.println((msg == null ? "Pass" : "Fail") + " (" + Utilities.describeDuration((long)(System.currentTimeMillis() - start)) + ")");
                if (msg != null) {
                    System.out.println("    " + msg);
                    this.error = msg;
                    this.fails.add(suite.asString("name") + "/" + test.asString("name"));
                }
                outputT.add("status", msg == null ? "pass" : "fail");
                if (msg != null) {
                    outputT.add("message", msg);
                }
                if (header != null) {
                    this.terminologyClient.setClientHeaders(new ClientHeaders());
                }
                return msg == null;
            }
            catch (Exception e) {
                System.out.println("  ... Exception: " + e.getMessage());
                System.out.print("    ");
                this.fails.add(suite.asString("name") + "/" + test.asString("name"));
                this.error = e.getMessage();
                e.printStackTrace();
                if (header != null) {
                    this.terminologyClient.setClientHeaders(new ClientHeaders());
                }
                return false;
            }
        }
        outputT.add("status", "ignored");
        return true;
    }

    private String metadata(String id, List<Resource> setup, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        CapabilityStatement cs = this.cstmt.copy();
        TxTesterScrubbers.scrubCapStmt(cs, this.tight);
        TxTesterSorters.sortCapStmt(cs);
        String csj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)cs);
        String diff = new CompareUtilities(ext, this.vars()).setPatternMode(true).checkJsonSrcIsSame(id, resp, csj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)csj, (String)fp);
        }
        return diff;
    }

    private String termcaps(String id, List<Resource> setup, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        TerminologyCapabilities cs = this.tc.copy();
        TxTesterScrubbers.scrubTermCaps(cs, this.tight);
        TxTesterSorters.sortTermCaps(cs);
        String csj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)cs);
        String diff = new CompareUtilities(ext, this.vars()).setPatternMode(true).checkJsonSrcIsSame(id, resp, csj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)csj, (String)fp);
        }
        return diff;
    }

    private String getResponseCode(JsonObject test) {
        if (test.has("http-code")) {
            return test.asString("http-code");
        }
        return "2xx";
    }

    private String chooseParam(JsonObject test, String name, List<String> modes) {
        for (String mode : modes) {
            if (!test.has(name + ":" + mode)) continue;
            return test.asString(name + ":" + mode);
        }
        return test.asString(name);
    }

    private Parameters loadProfile(JsonObject test) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        if (test.has("profile")) {
            return (Parameters)this.loader.loadResource(test.asString("profile"));
        }
        return (Parameters)this.loader.loadResource("parameters-default.json");
    }

    private String serverId() throws URISyntaxException {
        return new URI(this.server).getHost();
    }

    private String lookup(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            Parameters po = this.terminologyClient.lookupCode(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String translate(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            Parameters po = this.terminologyClient.translate(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String expand(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode) throws IOException {
        String vsj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        this.terminologyClient.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        int code = 0;
        try {
            ValueSet vs = this.terminologyClient.expandValueset(null, p);
            TxTesterScrubbers.scrubVS(vs, this.tight);
            TxTesterSorters.sortValueSet(vs);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)vs);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(ext, this.vars()).checkJsonSrcIsSame(id, resp, vsj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)vsj, (String)fp);
        }
        return diff;
    }

    private boolean httpCodeOk(String tcode, int code) {
        switch (tcode) {
            case "2xx": {
                return code >= 200 && code < 300;
            }
            case "3xx": {
                return code >= 300 && code < 400;
            }
            case "4xx": {
                return code >= 400 && code < 500;
            }
            case "5xx": {
                return code >= 500 && code < 600;
            }
        }
        throw new Error("unknown code string " + tcode);
    }

    private String validate(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        this.terminologyClient.setContentLanguage(lang);
        int code = 0;
        try {
            Parameters po = this.terminologyClient.validateVS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String validateCS(String id, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext, String tcode) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        this.terminologyClient.setContentLanguage(lang);
        int code = 0;
        try {
            Parameters po = this.terminologyClient.validateCS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
            code = 200;
        }
        catch (EFhirClientException e) {
            code = e.getCode();
            OperationOutcome oo = e.getServerError();
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        if (tcode != null && !this.httpCodeOk(tcode, code)) {
            return "Response Code fail: should be '" + tcode + "' but is '" + code + "'";
        }
        String diff = new CompareUtilities(ext, this.vars()).checkJsonSrcIsSame(id, resp, pj, false);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private Map<String, String> vars() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("version", this.terminologyClient.getActualVersion().toCode());
        return vars;
    }

    private List<Resource> loadSetupResources(JsonObject suite) throws FHIRFormatError, FileNotFoundException, IOException {
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (String s : suite.getStrings("setup")) {
            res.add(this.loader.loadResource(s));
        }
        return res;
    }

    public String getOutput() {
        return this.output;
    }

    public TxTester setOutput(String output) {
        this.output = output;
        return this;
    }

    public static class InternalTxLoader
    implements ITxTesterLoader {
        private String folder;

        public InternalTxLoader(String folder) {
            this.folder = folder;
        }

        public InternalTxLoader(String source, String local) throws IOException {
            if (source.startsWith("http://") || source.startsWith("https://")) {
                this.folder = Utilities.path((String[])new String[]{local, "source"});
                URL url = new URL(this.zipUrl(source));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                InputStream zip = connection.getInputStream();
                this.unzip(zip);
            } else {
                this.folder = source;
            }
        }

        public void unzip(InputStream is) throws IOException {
            try (ZipInputStream zipIn = new ZipInputStream(is);){
                ZipEntry ze;
                while ((ze = zipIn.getNextEntry()) != null) {
                    if (!ze.getName().startsWith("fhir-test-cases-master/tx/")) continue;
                    Path path = Path.of(Utilities.path((String[])new String[]{this.folder, ze.getName().substring(26)}), new String[0]).normalize();
                    String pathString = ManagedFileAccess.fromPath((Path)path).getAbsolutePath();
                    if (!path.startsWith(Path.of(this.folder, new String[0]).normalize())) {
                        throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                    }
                    if (ze.isDirectory()) {
                        Utilities.createDirectory((String)pathString);
                        continue;
                    }
                    Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)pathString));
                    TextFile.streamToFileNoClose((InputStream)zipIn, (String)pathString);
                }
            }
        }

        private String zipUrl(String template) {
            if (!template.startsWith("https://github.")) {
                throw new FHIRException("Cannot refer to source by URL unless referring to a github repository: " + template);
            }
            if (Utilities.charCount((String)template, (char)'/') == 4) {
                return Utilities.pathURL((String[])new String[]{template, "archive", "master.zip"});
            }
            if (Utilities.charCount((String)template, (char)'/') == 6) {
                String[] p = template.split("\\/");
                return Utilities.pathURL((String[])new String[]{"https://" + p[2], p[3], p[4], "archive", p[6] + ".zip"});
            }
            throw new FHIRException("Source syntax in URL referring to a github repository was not understood: " + template);
        }

        @Override
        public String describe() {
            return this.folder;
        }

        @Override
        public Resource loadResource(String filename) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException {
            Resource res = new JsonParser().parse((InputStream)ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{this.folder, filename})));
            try {
                org.hl7.fhir.r4.model.Resource r4 = VersionConvertorFactory_40_50.convertResource((Resource)res);
                String p = Utilities.path((String[])new String[]{this.folder, "r4", filename});
                Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)p));
                new org.hl7.fhir.r4.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)ManagedFileAccess.outStream((String)p), r4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return res;
        }

        @Override
        public byte[] loadContent(String filename) throws FileNotFoundException, IOException {
            return TextFile.fileToBytes((String)Utilities.path((String[])new String[]{this.folder, filename}));
        }
    }

    public static interface ITxTesterLoader {
        public String describe();

        public Resource loadResource(String var1) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException;

        public byte[] loadContent(String var1) throws FileNotFoundException, IOException;
    }
}

