/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.test.utils.CompareUtilities;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.validation.special.TxTesterScrubbers;
import org.hl7.fhir.validation.special.TxTesterSorters;

public class TxTester {
    private String server;
    private ITxTesterLoader loader;
    private String error;
    private String output;
    private ITerminologyClient tx;
    private boolean tight;
    private JsonObject externals;

    public TxTester(ITxTesterLoader loader, String server, boolean tight, JsonObject externals) {
        this.server = server;
        this.loader = loader;
        this.tight = tight;
        this.externals = externals;
    }

    public static void main(String[] args) throws Exception {
        new TxTester(new InternalTxLoader(args[0]), args[1], "true".equals(args[2]), args.length == 5 ? org.hl7.fhir.utilities.json.parser.JsonParser.parseObjectFromFile((String)args[4]) : null).execute(args[2], new ArrayList<String>(), args[3]);
    }

    public boolean execute(String version, List<String> modes, String filter) throws IOException, URISyntaxException {
        if (this.output == null) {
            this.output = Utilities.path((String[])new String[]{"[tmp]", this.serverId()});
        }
        System.out.println("Run terminology service Tests");
        System.out.println("  Source for tests: " + this.loader.describe());
        System.out.println("  Output Directory: " + this.output);
        System.out.println("  Term Service Url: " + this.server);
        System.out.println("  External Strings: " + (this.externals != null));
        System.out.println("  Test  Exec Modes: " + modes.toString());
        if (version != null) {
            System.out.println("  Tx  FHIR Version: " + version);
        }
        if (filter != null) {
            System.out.println("  Filter Parameter: " + filter);
        }
        JsonObject json = new JsonObject();
        json.add("date", new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(Calendar.getInstance().getTime()) + this.timezone());
        try {
            JsonObject tests = this.loadTests();
            ITerminologyClient tx = this.connectToServer();
            boolean ok = this.checkClient(tx);
            for (JsonObject suite : tests.getJsonObjects("suites")) {
                if (suite.has("mode") && !modes.contains(suite.asString("mode"))) continue;
                if (suite.asBoolean("disabled")) {
                    ok = true;
                    continue;
                }
                ok = this.runSuite(suite, tx, modes, filter, json.forceArray("suites")) && ok;
            }
            TextFile.stringToFile((String)org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)json, (boolean)true), (String)Utilities.path((String[])new String[]{this.output, "test-results.json"}));
            if (ok) {
                System.out.println("Terminology Service Tests all passed");
                return true;
            }
            System.out.println("Terminology Service Tests did not all pass");
            return false;
        }
        catch (Exception e) {
            System.out.println("Exception running Terminology Service Tests: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        Object offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + (String)offset;
        return offset;
    }

    private boolean checkClient(ITerminologyClient tx) {
        tx.getCapabilitiesStatementQuick();
        tx.getTerminologyCapabilities();
        return true;
    }

    private JsonObject loadTests() throws JsonException, IOException {
        System.out.println("Load Tests from " + this.loader.describe());
        return org.hl7.fhir.utilities.json.parser.JsonParser.parseObject((byte[])this.loader.loadContent("test-cases.json"));
    }

    private ITerminologyClient connectToServer() throws URISyntaxException {
        System.out.println("Connect to " + this.server);
        return new TerminologyClientFactory(FhirPublication.R4).makeClient("Test-Server", this.server, "Tools/Java", null);
    }

    public String executeTest(JsonObject suite, JsonObject test, List<String> modes) throws URISyntaxException, FHIRFormatError, FileNotFoundException, IOException {
        List<Resource> setup;
        this.error = null;
        if (this.tx == null) {
            this.tx = this.connectToServer();
            this.checkClient(this.tx);
        }
        if (this.runTest(test, this.tx, setup = this.loadSetupResources(suite), modes, "*", null)) {
            return null;
        }
        return this.error;
    }

    private boolean runSuite(JsonObject suite, ITerminologyClient tx, List<String> modes, String filter, JsonArray output) throws FHIRFormatError, FileNotFoundException, IOException {
        System.out.println("Group " + suite.asString("name"));
        JsonObject outputS = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputS);
        }
        outputS.add("name", suite.asString("name"));
        List<Resource> setup = this.loadSetupResources(suite);
        boolean ok = true;
        for (JsonObject test : suite.getJsonObjects("tests")) {
            if (test.asBoolean("disabled")) {
                ok = true;
                continue;
            }
            ok = this.runTest(test, tx, setup, modes, filter, outputS.forceArray("tests")) && ok;
        }
        return ok;
    }

    private boolean runTest(JsonObject test, ITerminologyClient tx, List<Resource> setup, List<String> modes, String filter, JsonArray output) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        JsonObject outputT = new JsonObject();
        if (output != null) {
            output.add((JsonElement)outputT);
        }
        Parameters profile = this.loadProfile(test);
        outputT.add("name", test.asString("name"));
        if (Utilities.noString((String)filter) || filter.equals("*") || test.asString("name").contains(filter)) {
            System.out.print("  Test " + test.asString("name") + ": ");
            try {
                Parameters req = (Parameters)this.loader.loadResource(this.chooseParam(test, "request", modes));
                String fn = this.chooseParam(test, "response", modes);
                String resp = TextFile.bytesToString((byte[])this.loader.loadContent(fn));
                String fp = Utilities.path((String[])new String[]{"[tmp]", this.serverId(), fn});
                File fo = ManagedFileAccess.file((String)fp);
                if (fo.exists()) {
                    fo.delete();
                }
                JsonObject ext = this.externals == null ? null : this.externals.getJsonObject(fn);
                String lang = test.asString("Content-Language");
                String msg = null;
                if (test.asString("operation").equals("expand")) {
                    msg = this.expand(test.str("name"), tx, setup, req, resp, fp, lang, profile, ext);
                } else if (test.asString("operation").equals("validate-code")) {
                    msg = this.validate(test.str("name"), tx, setup, req, resp, fp, lang, profile, ext);
                } else if (test.asString("operation").equals("cs-validate-code")) {
                    msg = this.validateCS(test.str("name"), tx, setup, req, resp, fp, lang, profile, ext);
                } else if (test.asString("operation").equals("lookup")) {
                    msg = null;
                } else if (test.asString("operation").equals("translate")) {
                    msg = null;
                } else {
                    throw new Exception("Unknown Operation " + test.asString("operation"));
                }
                System.out.println(msg == null ? "Pass" : "Fail");
                if (msg != null) {
                    System.out.println("    " + msg);
                    this.error = msg;
                }
                outputT.add("status", msg == null ? "pass" : "fail");
                if (msg != null) {
                    outputT.add("message", msg);
                }
                return msg == null;
            }
            catch (Exception e) {
                System.out.println("  ... Exception: " + e.getMessage());
                System.out.print("    ");
                this.error = e.getMessage();
                e.printStackTrace();
                return false;
            }
        }
        outputT.add("status", "ignored");
        return true;
    }

    private String chooseParam(JsonObject test, String name, List<String> modes) {
        for (String mode : modes) {
            if (!test.has(name + ":" + mode)) continue;
            return test.asString(name + ":" + mode);
        }
        return test.asString(name);
    }

    private Parameters loadProfile(JsonObject test) throws FHIRFormatError, DefinitionException, FileNotFoundException, FHIRException, IOException {
        if (test.has("profile")) {
            return (Parameters)this.loader.loadResource(test.asString("profile"));
        }
        return (Parameters)this.loader.loadResource("parameters-default.json");
    }

    private String serverId() throws URISyntaxException {
        return new URI(this.server).getHost();
    }

    private String lookup(String id, ITerminologyClient tx, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        tx.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        try {
            Parameters po = tx.lookupCode(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
        }
        catch (EFhirClientException e) {
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        String diff = CompareUtilities.checkJsonSrcIsSame((String)id, (String)resp, (String)pj, (boolean)false, (JsonObject)ext);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String translate(String id, ITerminologyClient tx, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        tx.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        try {
            Parameters po = tx.translate(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
        }
        catch (EFhirClientException e) {
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        String diff = CompareUtilities.checkJsonSrcIsSame((String)id, (String)resp, (String)pj, (boolean)false, (JsonObject)ext);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String expand(String id, ITerminologyClient tx, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        String vsj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        tx.setContentLanguage(lang);
        p.getParameter().addAll(profile.getParameter());
        try {
            ValueSet vs = tx.expandValueset(null, p);
            TxTesterScrubbers.scrubVS(vs, this.tight);
            TxTesterSorters.sortValueSet(vs);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)vs);
        }
        catch (EFhirClientException e) {
            OperationOutcome oo = e.getServerError();
            TxTesterScrubbers.scrubOO(oo, this.tight);
            vsj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        String diff = CompareUtilities.checkJsonSrcIsSame((String)id, (String)resp, (String)vsj, (boolean)false, (JsonObject)ext);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)vsj, (String)fp);
        }
        return diff;
    }

    private String validate(String id, ITerminologyClient tx, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        tx.setContentLanguage(lang);
        try {
            Parameters po = tx.validateVS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
        }
        catch (EFhirClientException e) {
            OperationOutcome oo = e.getServerError();
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        String diff = CompareUtilities.checkJsonSrcIsSame((String)id, (String)resp, (String)pj, (boolean)false, (JsonObject)ext);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private String validateCS(String id, ITerminologyClient tx, List<Resource> setup, Parameters p, String resp, String fp, String lang, Parameters profile, JsonObject ext) throws IOException {
        String pj;
        for (Resource r : setup) {
            p.addParameter().setName("tx-resource").setResource(r);
        }
        p.getParameter().addAll(profile.getParameter());
        tx.setContentLanguage(lang);
        try {
            Parameters po = tx.validateCS(p);
            TxTesterScrubbers.scrubParams(po);
            TxTesterSorters.sortParameters(po);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)po);
        }
        catch (EFhirClientException e) {
            OperationOutcome oo = e.getServerError();
            oo.setText(null);
            pj = new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).composeString((Resource)oo);
        }
        String diff = CompareUtilities.checkJsonSrcIsSame((String)id, (String)resp, (String)pj, (boolean)false, (JsonObject)ext);
        if (diff != null) {
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)fp));
            TextFile.stringToFile((String)pj, (String)fp);
        }
        return diff;
    }

    private List<Resource> loadSetupResources(JsonObject suite) throws FHIRFormatError, FileNotFoundException, IOException {
        ArrayList<Resource> res = new ArrayList<Resource>();
        for (String s : suite.getStrings("setup")) {
            res.add(this.loader.loadResource(s));
        }
        return res;
    }

    public String getOutput() {
        return this.output;
    }

    public TxTester setOutput(String output) {
        this.output = output;
        return this;
    }

    public static class InternalTxLoader
    implements ITxTesterLoader {
        private String folder;

        public InternalTxLoader(String folder) {
            this.folder = folder;
        }

        public InternalTxLoader(String source, String local) throws IOException {
            if (source.startsWith("http://") || source.startsWith("https://")) {
                this.folder = Utilities.path((String[])new String[]{local, "source"});
                URL url = new URL(this.zipUrl(source));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                InputStream zip = connection.getInputStream();
                this.unzip(zip);
            } else {
                this.folder = source;
            }
        }

        public void unzip(InputStream is) throws IOException {
            try (ZipInputStream zipIn = new ZipInputStream(is);){
                ZipEntry ze;
                while ((ze = zipIn.getNextEntry()) != null) {
                    if (!ze.getName().startsWith("fhir-test-cases-master/tx/")) continue;
                    Path path = Path.of(Utilities.path((String[])new String[]{this.folder, ze.getName().substring(26)}), new String[0]).normalize();
                    String pathString = ManagedFileAccess.fromPath((Path)path).getAbsolutePath();
                    if (!path.startsWith(Path.of(this.folder, new String[0]).normalize())) {
                        throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                    }
                    if (ze.isDirectory()) {
                        Utilities.createDirectory((String)pathString);
                        continue;
                    }
                    Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)pathString));
                    TextFile.streamToFileNoClose((InputStream)zipIn, (String)pathString);
                }
            }
        }

        private String zipUrl(String template) {
            if (!template.startsWith("https://github.")) {
                throw new FHIRException("Cannot refer to source by URL unless referring to a github repository: " + template);
            }
            if (Utilities.charCount((String)template, (char)'/') == 4) {
                return Utilities.pathURL((String[])new String[]{template, "archive", "master.zip"});
            }
            if (Utilities.charCount((String)template, (char)'/') == 6) {
                String[] p = template.split("\\/");
                return Utilities.pathURL((String[])new String[]{"https://" + p[2], p[3], p[4], "archive", p[6] + ".zip"});
            }
            throw new FHIRException("Source syntax in URL referring to a github repository was not understood: " + template);
        }

        @Override
        public String describe() {
            return this.folder;
        }

        @Override
        public Resource loadResource(String filename) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException {
            Resource res = new JsonParser().parse((InputStream)ManagedFileAccess.inStream((String)Utilities.path((String[])new String[]{this.folder, filename})));
            org.hl7.fhir.r4.model.Resource r4 = VersionConvertorFactory_40_50.convertResource((Resource)res);
            String p = Utilities.path((String[])new String[]{this.folder, "r4", filename});
            Utilities.createDirectory((String)Utilities.getDirectoryForFile((String)p));
            new org.hl7.fhir.r4.formats.JsonParser().compose((OutputStream)ManagedFileAccess.outStream((String)p), r4);
            return res;
        }

        @Override
        public byte[] loadContent(String filename) throws FileNotFoundException, IOException {
            return TextFile.fileToBytes((String)Utilities.path((String[])new String[]{this.folder, filename}));
        }
    }

    public static interface ITxTesterLoader {
        public String describe();

        public Resource loadResource(String var1) throws IOException, FHIRFormatError, FileNotFoundException, FHIRException, DefinitionException;

        public byte[] loadContent(String var1) throws FileNotFoundException, IOException;
    }
}

