/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import ca.uhn.fhir.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.instance.utils.EnableWhenEvaluator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class QuestionnaireValidator
extends BaseValidator {
    private EnableWhenEvaluator myEnableWhenEvaluator;
    private FHIRPathEngine fpe;
    private QuestionnaireMode questionnaireMode;

    public QuestionnaireValidator(BaseValidator parent, EnableWhenEvaluator myEnableWhenEvaluator, FHIRPathEngine fpe, QuestionnaireMode questionnaireMode) {
        super(parent);
        this.myEnableWhenEvaluator = myEnableWhenEvaluator;
        this.fpe = fpe;
        this.questionnaireMode = questionnaireMode;
    }

    public boolean validateQuestionannaire(List<ValidationMessage> errors, Element element, Element element2, NodeStack stack) {
        ArrayList<Element> parents = new ArrayList<Element>();
        parents.add(element);
        ArrayList<QuestionnaireDerivation> derivations = new ArrayList<QuestionnaireDerivation>();
        boolean ok = this.checkDerivations(errors, element, element, stack, derivations);
        return this.validateQuestionannaireItem(errors, element, element, stack, parents, derivations) && ok;
    }

    private boolean checkDerivations(List<ValidationMessage> errors, Element element, Element questionnaire, NodeStack stack, List<QuestionnaireDerivation> derivations) {
        boolean ok = true;
        ArrayList list = new ArrayList();
        element.getNamedChildren("derivedFrom", list);
        for (int i = 0; i < list.size(); ++i) {
            Element v;
            NodeStack next;
            Element ext;
            String url;
            Questionnaire q;
            Element e = (Element)list.get(i);
            NodeStack ns = stack.push(e, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            if (!this.warning(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, (q = (Questionnaire)this.context.fetchResource(Questionnaire.class, url = e.primitiveValue())) != null, "QUESTIONNAIRE_Q_UNKNOWN_DERIVATION", url) || !this.warning(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, (ext = e.getExtension("http://hl7.org/fhir/StructureDefinition/questionnaire-derivationType")) != null, "QUESTIONNAIRE_Q_NO_DERIVATION_TYPE", url) || !this.warning(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, next = ns.push(ext, -1, ext.getProperty().getDefinition(), ext.getProperty().getDefinition()), (v = ext.getNamedChild("value", false)) != null, "QUESTIONNAIRE_Q_NO_DERIVATION_TYPE_VALUE", new Object[0])) continue;
            NodeStack nv = next.push(v, -1, v.getProperty().getDefinition(), v.getProperty().getDefinition());
            String s = v.getNamedChildValue("system", false);
            String c = v.getNamedChildValue("code", false);
            if ("http://hl7.org/fhir/questionnaire-derivationType".equals(s) && "extends".equals(c)) {
                derivations.add(new QuestionnaireDerivation(q, QuestionnaireDerivationMode.EXTENDS));
                continue;
            }
            if ("http://hl7.org/fhir/questionnaire-derivationType".equals(s) && "compliesWith".equals(c)) {
                derivations.add(new QuestionnaireDerivation(q, QuestionnaireDerivationMode.COMPLIES));
                continue;
            }
            if ("http://hl7.org/fhir/questionnaire-derivationType".equals(s) && "inspiredBy".equals(c)) {
                this.hint(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, nv, false, "QUESTIONNAIRE_Q_DERIVATION_TYPE_IGNORED", s + "#" + c);
                continue;
            }
            this.warning(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, nv, false, "QUESTIONNAIRE_Q_DERIVATION_TYPE_UNKNOWN", s + "#" + c);
        }
        return ok;
    }

    private boolean validateQuestionannaireItem(List<ValidationMessage> errors, Element element, Element questionnaire, NodeStack stack, List<Element> parents, List<QuestionnaireDerivation> derivations) {
        boolean ok = true;
        List<Element> list = this.getItems(element);
        for (int i = 0; i < list.size(); ++i) {
            Element e = list.get(i);
            NodeStack ns = stack.push(e, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            ok = this.validateQuestionnaireElement(errors, ns, questionnaire, e, parents, derivations) && ok;
            ArrayList<Element> np = new ArrayList<Element>();
            np.add(e);
            np.addAll(parents);
            ok = this.validateQuestionannaireItem(errors, e, questionnaire, ns, np, derivations) && ok;
        }
        return ok;
    }

    private boolean validateQuestionnaireElement(List<ValidationMessage> errors, NodeStack ns, Element questionnaire, Element item, List<Element> parents, List<QuestionnaireDerivation> derivations) {
        boolean ok = true;
        if (VersionUtilities.isR4Plus((String)this.context.getVersion()) && item.hasChildren("enableWhen")) {
            List ewl = item.getChildren("enableWhen");
            for (Element ew : ewl) {
                String ql = ew.getNamedChildValue("question", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns, ql != null, "Questionnaire_Q_EnableWhen_NoLink", new Object[0])) {
                    Element tgt = this.getQuestionById(item, ql);
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns, tgt == null, "Questionnaire_Q_EnableWhen_IsInner", new Object[0])) {
                        tgt = this.getQuestionById(questionnaire, ql);
                        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns, tgt != null, "Questionnaire_Q_EnableWhen_NoTarget", ql, item.getChildValue("linkId"))) {
                            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns, tgt != item, "Questionnaire_Q_EnableWhen_Self", new Object[0])) {
                                if (this.isBefore(item, tgt, parents)) continue;
                                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns, false, "Questionnaire_Q_EnableWhen_After", ql);
                                continue;
                            }
                            ok = false;
                            continue;
                        }
                        ok = false;
                        continue;
                    }
                    ok = false;
                    continue;
                }
                ok = false;
            }
        }
        for (QuestionnaireDerivation qd : derivations) {
            ok = this.validateQuestionnaireElementDerivation(errors, ns, questionnaire, item, qd) && ok;
        }
        return ok;
    }

    private boolean validateQuestionnaireElementDerivation(List<ValidationMessage> errors, NodeStack ns, Element questionnaire, Element item, QuestionnaireDerivation derivation) {
        boolean ok = true;
        String linkId = item.getNamedChildValue("linkId", false);
        Questionnaire.QuestionnaireItemComponent qi = derivation.questionnaire.getQuestion(linkId);
        if (qi == null) {
            ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.NOTFOUND, ns.getLiteralPath(), derivation.mode == QuestionnaireDerivationMode.EXTENDS, "QUESTIONNAIRE_Q_ITEM_NOT_DERIVED", derivation.questionnaire.getUrl(), linkId) && ok;
        } else {
            NodeStack ne;
            Element e;
            if (qi.hasType() && (e = item.getNamedChild("type", false)) != null) {
                ne = ns.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                boolean bl = ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ne, qi.getType().toCode().equals(e.primitiveValue()), "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_TYPE", derivation.questionnaire.getUrl(), linkId, qi.getType().toCode(), e.primitiveValue()) && ok;
            }
            if (!qi.getRepeats() && (e = item.getNamedChild("repeats", false)) != null) {
                ne = ns.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                boolean bl = ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ne, !"true".equals(e.primitiveValue()), "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_REPEATS", derivation.questionnaire.getUrl(), linkId) && ok;
            }
            if (qi.getRequired() && (e = item.getNamedChild("required", false)) != null) {
                ne = ns.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                boolean bl = ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ne, "true".equals(e.primitiveValue()), "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_REQUIRED", derivation.questionnaire.getUrl(), linkId) && ok;
            }
            if (qi.hasDefinition()) {
                e = item.getNamedChild("definition", false);
                if (e != null) {
                    ne = ns.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                    this.hint(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ne, "true".equals(e.primitiveValue()), "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_DEFINITION", derivation.questionnaire.getUrl(), linkId, qi.getDefinition());
                } else {
                    this.hint(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, false, "QUESTIONNAIRE_Q_ITEM_DERIVED_DEFINITION", derivation.questionnaire.getUrl(), linkId, qi.getDefinition());
                }
            }
            if (qi.hasMaxLength()) {
                e = item.getNamedChild("maxlength", false);
                if (e != null) {
                    ne = ns.push(e, -1, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                    int ml = Utilities.parseInt((String)e.primitiveValue(), (int)0);
                    ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ne, ml <= qi.getMaxLength(), "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_MAXLENGTH", derivation.questionnaire.getUrl(), linkId, qi.getMaxLength()) && ok;
                } else {
                    ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, false, "QUESTIONNAIRE_Q_ITEM_DERIVED_MAXLENGTH", derivation.questionnaire.getUrl(), linkId, qi.getMaxLength()) & ok;
                }
            }
            if (qi.hasAnswerOption()) {
                e = item.getNamedChild("answerValueSet", false);
                if (this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, e == null, "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_ANSWER_TYPE", derivation.questionnaire.getUrl(), linkId, "Option", "ValueSet")) {
                    ArrayList list = new ArrayList();
                    item.getNamedChildren("answerOption", list);
                    if (this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, !list.isEmpty(), "QUESTIONNAIRE_Q_ITEM_DERIVED_ANSWER_OPTIONS", derivation.questionnaire.getUrl(), linkId, qi.getAnswerOption().size())) {
                        for (int i = 0; i < list.size(); ++i) {
                            Element ao = (Element)list.get(i);
                            NodeStack nao = ns.push(ao, i, ao.getProperty().getDefinition(), ao.getProperty().getDefinition());
                            Element v = ao.getNamedChild("value", false);
                            if (v == null) continue;
                            boolean aok = false;
                            switch (v.fhirType()) {
                                case "integer": {
                                    aok = this.findAOPrimitive(qi.getAnswerOption(), "integer", v.primitiveValue());
                                    break;
                                }
                                case "date": {
                                    aok = this.findAOPrimitive(qi.getAnswerOption(), "date", v.primitiveValue());
                                    break;
                                }
                                case "time": {
                                    aok = this.findAOPrimitive(qi.getAnswerOption(), "time", v.primitiveValue());
                                    break;
                                }
                                case "string": {
                                    aok = this.findAOPrimitive(qi.getAnswerOption(), "string", v.primitiveValue());
                                    break;
                                }
                                case "Coding": {
                                    aok = this.findAOCoding(qi.getAnswerOption(), new Coding().setSystem(v.getNamedChildValue("system", false)).setVersion(v.getNamedChildValue("version", false)).setCode(v.getNamedChildValue("code", false)));
                                    break;
                                }
                                case "Reference": {
                                    aok = this.findAOReference(qi.getAnswerOption(), new Reference().setReference(v.getNamedChildValue("reference", false)));
                                }
                            }
                            ok = this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, nao, aok, "QUESTIONNAIRE_Q_ITEM_DERIVED_ANSWER_OPTIONS_NEW", derivation.questionnaire.getUrl(), linkId) && ok;
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            }
            if (qi.hasAnswerValueSet()) {
                e = item.getNamedChild("answerOption", false);
                if (this.rule(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, e == null, "QUESTIONNAIRE_Q_ITEM_DERIVED_NC_ANSWER_TYPE", derivation.questionnaire.getUrl(), linkId, "ValueSet", "Option")) {
                    this.warning(errors, "2023-06-15", ValidationMessage.IssueType.BUSINESSRULE, ns, e == null, "QUESTIONNAIRE_Q_ITEM_DERIVED_NI_ANSWER_VS", derivation.questionnaire.getUrl(), linkId);
                } else {
                    ok = false;
                }
            }
        }
        return ok;
    }

    private boolean findAOReference(List<Questionnaire.QuestionnaireItemAnswerOptionComponent> answerOptions, Reference value) {
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent ao : answerOptions) {
            Reference r;
            if (!ao.hasValue() || !(ao.getValue() instanceof Reference) || !(r = ao.getValueReference()).matches(value)) continue;
            return true;
        }
        return false;
    }

    private boolean findAOCoding(List<Questionnaire.QuestionnaireItemAnswerOptionComponent> answerOptions, Coding value) {
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent ao : answerOptions) {
            Coding c;
            if (!ao.hasValue() || !(ao.getValue() instanceof Coding) || !(c = ao.getValueCoding()).matches(value)) continue;
            return true;
        }
        return false;
    }

    private boolean findAOPrimitive(List<Questionnaire.QuestionnaireItemAnswerOptionComponent> answerOptions, String type, String v) {
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent ao : answerOptions) {
            if (!ao.hasValue() || !ao.getValue().isPrimitive() || !ao.getValue().fhirType().equals(type) || !ao.getValue().primitiveValue().equals(v)) continue;
            return true;
        }
        return false;
    }

    private boolean isBefore(Element item, Element tgt, List<Element> parents) {
        if (parents.contains(tgt)) {
            return true;
        }
        for (Element p : parents) {
            int i = this.findIndex(p, item);
            int t = this.findIndex(p, tgt);
            if (i <= -1 || t <= -1) continue;
            return i > t;
        }
        return false;
    }

    private int findIndex(Element parent, Element descendant) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            if (parent.getChildren().get(i) != descendant && !this.isChild((Element)parent.getChildren().get(i), descendant)) continue;
            return i;
        }
        return -1;
    }

    private boolean isChild(Element element, Element descendant) {
        for (Element e : element.getChildren()) {
            if (e == descendant) {
                return true;
            }
            if (!this.isChild(e, descendant)) continue;
            return true;
        }
        return false;
    }

    private Element getQuestionById(Element focus, String ql) {
        List<Element> list = this.getItems(focus);
        for (Element item : list) {
            String v = item.getNamedChildValue("linkId", false);
            if (ql.equals(v)) {
                return item;
            }
            Element tgt = this.getQuestionById(item, ql);
            if (tgt == null) continue;
            return tgt;
        }
        return null;
    }

    private List<Element> getItems(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        element.getNamedChildren("item", list);
        return list;
    }

    public boolean validateQuestionannaireResponse(ValidationContext hostContext, List<ValidationMessage> errors, Element element, NodeStack stack) throws FHIRException {
        boolean qok;
        if (this.questionnaireMode == QuestionnaireMode.NONE) {
            return true;
        }
        boolean ok = true;
        Element q = element.getNamedChild("questionnaire", false);
        String questionnaire = null;
        if (q != null) {
            if (StringUtils.isNotBlank((CharSequence)q.getValue())) {
                questionnaire = q.getValue();
            } else if (StringUtils.isNotBlank((CharSequence)q.getChildValue("reference"))) {
                questionnaire = q.getChildValue("reference");
            }
        }
        if (this.questionnaireMode == QuestionnaireMode.REQUIRED) {
            ok = qok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), questionnaire != null, "Questionnaire_QR_Q_None", new Object[0]);
        } else {
            qok = this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), questionnaire != null, "Questionnaire_QR_Q_None");
        }
        if (qok) {
            QuestionnaireWithContext qsrc = null;
            qsrc = questionnaire.startsWith("#") ? QuestionnaireWithContext.fromContainedResource(stack.getLiteralPath(), element, (Questionnaire)this.loadContainedResource(errors, stack.getLiteralPath(), element, questionnaire.substring(1), Questionnaire.class)) : QuestionnaireWithContext.fromQuestionnaire((Questionnaire)this.context.fetchResource(Questionnaire.class, questionnaire));
            if (this.questionnaireMode == QuestionnaireMode.REQUIRED) {
                qok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "Questionnaire_QR_Q_NotFound", questionnaire);
                ok = qok && ok;
            } else {
                qok = questionnaire.startsWith("http://example.org") || questionnaire.startsWith("https://example.org") ? this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "Questionnaire_QR_Q_NotFound", questionnaire) : this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "Questionnaire_QR_Q_NotFound", questionnaire);
            }
            if (qok) {
                boolean inProgress = "in-progress".equals(element.getNamedChildValue("status", false));
                ok = this.validateQuestionannaireResponseItems(hostContext, qsrc, qsrc.q().getItem(), errors, element, stack, inProgress, element, new EnableWhenEvaluator.QStack(qsrc, element)) && ok;
            }
        }
        return ok;
    }

    private boolean validateQuestionnaireResponseItem(ValidationContext hostContext, QuestionnaireWithContext qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        ArrayList items;
        BaseValidator.BooleanHolder ok = new BaseValidator.BooleanHolder();
        String text = element.getNamedChildValue("text", false);
        ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), Utilities.noString((String)text) || text.equals(qItem.getText()), "Questionnaire_QR_Item_Text", qItem.getLinkId()));
        ArrayList<Element> answers = new ArrayList<Element>();
        element.getNamedChildren("answer", answers);
        if (inProgress) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "Questionnaire_QR_Item_Missing", qItem.getLinkId());
        } else if (this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe)) {
            ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "Questionnaire_QR_Item_Missing", qItem.getLinkId()));
        } else if (!answers.isEmpty()) {
            // empty if block
        }
        if (answers.size() > 1) {
            ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ((Element)answers.get(1)).line(), ((Element)answers.get(1)).col(), stack.getLiteralPath(), qItem.getRepeats(), "Questionnaire_QR_Item_OnlyOneA", new Object[0]));
        }
        int i = 0;
        for (Element answer : answers) {
            NodeStack ns = stack.push(answer, i, null, null);
            if (qItem.getType() != null) {
                switch (qItem.getType()) {
                    case GROUP: {
                        ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, answer.line(), answer.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_Group", new Object[0]));
                        break;
                    }
                    case DISPLAY: {
                        break;
                    }
                    case BOOLEAN: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "boolean");
                        break;
                    }
                    case DECIMAL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "decimal");
                        break;
                    }
                    case INTEGER: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "integer");
                        break;
                    }
                    case DATE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "date");
                        break;
                    }
                    case DATETIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "dateTime");
                        break;
                    }
                    case TIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "time");
                        break;
                    }
                    case STRING: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "string");
                        break;
                    }
                    case TEXT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "text");
                        break;
                    }
                    case URL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "uri");
                        break;
                    }
                    case ATTACHMENT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "Attachment");
                        break;
                    }
                    case REFERENCE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "Reference");
                        break;
                    }
                    case QUANTITY: {
                        if (!"Quantity".equals(this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "Quantity")) || !qItem.hasExtension("???")) break;
                        this.validateQuestionnaireResponseItemQuantity(errors, answer, ns);
                        break;
                    }
                    case CODING: {
                        String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, ok, "Coding", "date", "time", "integer", "string");
                        if (itemType == null) break;
                        if (itemType.equals("Coding")) {
                            this.validateAnswerCode(errors, answer, ns, qsrc, qItem, false);
                            break;
                        }
                        if (itemType.equals("date")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                            break;
                        }
                        if (itemType.equals("time")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                            break;
                        }
                        if (itemType.equals("integer")) {
                            ok.see(this.checkOption(errors, answer, ns, qsrc, qItem, "integer"));
                            break;
                        }
                        if (!itemType.equals("string")) break;
                        this.checkOption(errors, answer, ns, qsrc, qItem, "string");
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    case QUESTION: {
                        throw new Error("Shouldn't get here?");
                    }
                }
            }
            if (qItem.getType() != Questionnaire.QuestionnaireItemType.GROUP) {
                ok.see(this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, answer, stack, inProgress, questionnaireResponseRoot, qstack));
            }
            ++i;
        }
        if (qItem.getType() == null) {
            ok.see(this.fail(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoType", qItem.getLinkId()));
        } else if (qItem.getType() == Questionnaire.QuestionnaireItemType.DISPLAY) {
            items = new ArrayList();
            element.getNamedChildren("item", items);
            ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), items.isEmpty(), "Questionnaire_QR_Item_Display", qItem.getLinkId()));
        } else if (qItem.getType() != Questionnaire.QuestionnaireItemType.GROUP) {
            items = new ArrayList();
            element.getNamedChildren("item", items);
            ok.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), items.isEmpty(), "Questionnaire_QR_Item_GroupAnswer", qItem.getLinkId()));
        } else {
            ok.see(this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, element, stack, inProgress, questionnaireResponseRoot, qstack));
        }
        return ok.ok();
    }

    private boolean isAnswerRequirementFulfilled(Questionnaire.QuestionnaireItemComponent qItem, List<Element> answers) {
        return !answers.isEmpty() || !qItem.getRequired() || qItem.getType() == Questionnaire.QuestionnaireItemType.GROUP;
    }

    private boolean validateQuestionnaireResponseItem(ValidationContext hostcontext, QuestionnaireWithContext qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, List<ElementWithIndex> elements, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        boolean ok = true;
        if (elements.size() > 1) {
            ok = this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, elements.get(1).getElement().line(), elements.get(1).getElement().col(), stack.getLiteralPath(), qItem.getRepeats(), elements.size(), "Questionnaire_QR_Item_OnlyOneI", qItem.getLinkId()) && ok;
        }
        for (ElementWithIndex element : elements) {
            NodeStack ns = stack.push(element.getElement(), element.getIndex(), null, null);
            ok = this.validateQuestionnaireResponseItem(hostcontext, qsrc, qItem, errors, element.getElement(), ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, element.getElement())) && ok;
        }
        return ok;
    }

    private int getLinkIdIndex(List<Questionnaire.QuestionnaireItemComponent> qItems, String linkId) {
        for (int i = 0; i < qItems.size(); ++i) {
            if (!linkId.equals(qItems.get(i).getLinkId())) continue;
            return i;
        }
        return -1;
    }

    private boolean validateQuestionannaireResponseItems(ValidationContext hostContext, QuestionnaireWithContext qsrc, List<Questionnaire.QuestionnaireItemComponent> qItems, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        boolean ok = true;
        ArrayList items = new ArrayList();
        element.getNamedChildren("item", items);
        HashMap<String, List> map = new HashMap<String, List>();
        int lastIndex = -1;
        int counter = 0;
        for (Element item : items) {
            String linkId = item.getNamedChildValue("linkId", false);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, item.line(), item.col(), stack.getLiteralPath(), !Utilities.noString((String)linkId), "Questionnaire_QR_Item_NoLinkId", new Object[0])) {
                int index = this.getLinkIdIndex(qItems, linkId);
                if (index == -1) {
                    Questionnaire.QuestionnaireItemComponent qItem = this.findQuestionnaireItem(qsrc, linkId);
                    if (qItem != null) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index > -1, this.misplacedItemError(qItem), new Object[0]) && ok;
                        NodeStack ns = stack.push(item, counter, null, null);
                        ok = this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, item, ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, item)) && ok;
                    } else {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, item.line(), item.col(), stack.getLiteralPath(), index > -1, "Questionnaire_QR_Item_NotFound", linkId) && ok;
                    }
                } else {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index >= lastIndex, "Questionnaire_QR_Item_Order", new Object[0]) && ok;
                    lastIndex = index;
                    if (item.hasChildren("answer") || item.hasChildren("item")) {
                        List mapItem = map.computeIfAbsent(linkId, key -> new ArrayList());
                        mapItem.add(new ElementWithIndex(item, counter));
                    }
                }
            } else {
                ok = false;
            }
            ++counter;
        }
        for (Questionnaire.QuestionnaireItemComponent qItem : qItems) {
            List mapItem;
            ok = this.validateQuestionnaireResponseItem(hostContext, qsrc, errors, element, stack, inProgress, questionnaireResponseRoot, qItem, mapItem = (List)map.get(qItem.getLinkId()), qstack) && ok;
        }
        return ok;
    }

    public boolean validateQuestionnaireResponseItem(ValidationContext hostContext, QuestionnaireWithContext qsrc, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, Questionnaire.QuestionnaireItemComponent qItem, List<ElementWithIndex> mapItem, EnableWhenEvaluator.QStack qstack) {
        boolean ok = true;
        boolean enabled = this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe);
        if (mapItem != null) {
            if (!enabled) {
                for (ElementWithIndex e : mapItem) {
                    NodeStack ns = stack.push(e.getElement(), e.getElement().getIndex(), e.getElement().getProperty().getDefinition(), e.getElement().getProperty().getDefinition());
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.getElement().line(), e.getElement().col(), ns.getLiteralPath(), enabled, "Questionnaire_QR_Item_NotEnabled2", qItem.getLinkId()) && ok;
                }
            }
            ok = this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, mapItem, stack, inProgress, questionnaireResponseRoot, qstack) && ok;
        } else if (enabled && qItem.getRequired()) {
            String message = this.context.formatMessage("Questionnaire_QR_Item_Missing", new Object[]{qItem.getLinkId()});
            if (inProgress) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]);
            } else {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]) && ok;
            }
        }
        return ok;
    }

    private String misplacedItemError(Questionnaire.QuestionnaireItemComponent qItem) {
        return qItem.hasLinkId() ? String.format("Structural Error: item with linkid %s is in the wrong place", qItem.getLinkId()) : "Structural Error: item is in the wrong place";
    }

    private void validateQuestionnaireResponseItemQuantity(List<ValidationMessage> errors, Element answer, NodeStack stack) {
    }

    private String validateQuestionnaireResponseItemType(List<ValidationMessage> errors, Element element, NodeStack stack, BaseValidator.BooleanHolder ok, String ... types) {
        ArrayList values = new ArrayList();
        element.getNamedChildrenWithWildcard("value[x]", values);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals("text")) continue;
            types[i] = "string";
        }
        if (values.size() > 0) {
            NodeStack ns = stack.push((Element)values.get(0), -1, null, null);
            CommaSeparatedStringBuilder l = new CommaSeparatedStringBuilder();
            for (String s : types) {
                l.append(s);
                if (!((Element)values.get(0)).getName().equals("value" + Utilities.capitalize((String)s))) continue;
                return s;
            }
            ok.see(this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ((Element)values.get(0)).line(), ((Element)values.get(0)).col(), ns.getLiteralPath(), false, types.length, "Questionnaire_QR_Item_WrongType", l.toString()));
        }
        return null;
    }

    private Questionnaire.QuestionnaireItemComponent findQuestionnaireItem(QuestionnaireWithContext qSrc, String linkId) {
        return this.findItem(qSrc.q.getItem(), linkId);
    }

    private Questionnaire.QuestionnaireItemComponent findItem(List<Questionnaire.QuestionnaireItemComponent> list, String linkId) {
        for (Questionnaire.QuestionnaireItemComponent item : list) {
            if (linkId.equals(item.getLinkId())) {
                return item;
            }
            Questionnaire.QuestionnaireItemComponent result = this.findItem(item.getItem(), linkId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean validateAnswerCode(List<ValidationMessage> errors, Element value, NodeStack stack, QuestionnaireWithContext qSrc, String ref, boolean theOpenChoice) {
        boolean ok = true;
        ValueSet vs = null;
        vs = ref.startsWith("#") && qSrc.container != null ? (ValueSet)this.loadContainedResource(errors, qSrc.containerPath, qSrc.container, ref.substring(1), ValueSet.class) : this.resolveBindingReference((DomainResource)qSrc.q(), ref, qSrc.q().getUrl(), (Resource)qSrc.q());
        if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), vs != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(ref))) {
            try {
                Coding c = ObjectConverter.readAsCoding((Element)value);
                if (StringUtils.isBlank((CharSequence)c.getCode()) && StringUtils.isBlank((CharSequence)c.getSystem()) && StringUtils.isNotBlank((CharSequence)c.getDisplay()) && theOpenChoice) {
                    return ok;
                }
                long t = System.nanoTime();
                ValidationContextCarrier vc = this.makeValidationContext(errors, qSrc);
                ValidationResult res = this.context.validateCode(new ValidationOptions(FhirPublication.R5, stack.getWorkingLang()), c, vs, vc);
                this.timeTracker.tx(t, "vc " + c.getSystem() + "#" + c.getCode() + " '" + c.getDisplay() + "'");
                if (!res.isOk()) {
                    if (res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                        this.txWarning(errors, NO_RULE_DATE, res.getTxLink(), ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "QUESTIONNAIRE_QR_ITEM_BADOPTION_CS", c.getSystem(), c.getCode(), vs.present());
                    } else {
                        ok = this.txRule(errors, NO_RULE_DATE, res.getTxLink(), ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_BadOption", c.getSystem(), c.getCode(), vs.present(), res.getMessage()) && ok;
                    }
                } else if (res.getSeverity() != null) {
                    super.addValidationMessage(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), res.getMessage(), res.getSeverity(), ValidationMessage.Source.TerminologyEngine, null);
                } else if (res.getMessage() != null) {
                    super.addValidationMessage(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, value.line(), value.col(), stack.getLiteralPath(), res.getMessage(), res.getSeverity() == null ? ValidationMessage.IssueSeverity.INFORMATION : res.getSeverity(), ValidationMessage.Source.TerminologyEngine, null);
                }
            }
            catch (Exception e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_Coding", e.getMessage());
            }
        }
        return ok;
    }

    private ValidationContextCarrier makeValidationContext(List<ValidationMessage> errors, QuestionnaireWithContext qSrc) {
        ValidationContextCarrier vc = new ValidationContextCarrier();
        if (qSrc.container == null) {
            vc.getResources().add(new ValidationContextCarrier.ValidationContextResourceProxy((Resource)qSrc.q));
        } else {
            vc.getResources().add(new ValidationContextCarrier.ValidationContextResourceProxy(errors, qSrc.containerPath, qSrc.container, (ValidationContextCarrier.IValidationContextResourceLoader)this));
        }
        return vc;
    }

    private boolean validateAnswerCode(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean theOpenChoice) {
        Element v = answer.getNamedChild("valueCoding", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, theOpenChoice);
        } else {
            if (qItem.hasAnswerValueSet()) {
                return this.validateAnswerCode(errors, v, stack, qSrc, qItem.getAnswerValueSet(), theOpenChoice);
            }
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptions");
        }
        return true;
    }

    private boolean checkOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type) {
        return this.checkOption(errors, answer, stack, qSrc, qItem, type, qItem.getAnswerConstraint() == Questionnaire.QuestionnaireAnswerConstraint.OPTIONSORSTRING);
    }

    private boolean checkOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type, boolean openChoice) {
        if (type.equals("integer")) {
            return this.checkIntegerOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
        if (type.equals("date")) {
            return this.checkDateOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
        if (type.equals("time")) {
            return this.checkTimeOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
        if (type.equals("string")) {
            return this.checkStringOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
        if (type.equals("Coding")) {
            return this.checkCodingOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
        return true;
    }

    private boolean checkIntegerOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        boolean ok = true;
        Element v = answer.getNamedChild("valueInteger", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<IntegerType> list = new ArrayList<IntegerType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueIntegerType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsInteger", new Object[0]) && ok;
            } else {
                boolean found = false;
                for (IntegerType item : list) {
                    if ((Integer)item.getValue() != Integer.parseInt(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoInteger", v.primitiveValue()) && ok;
                }
            }
        } else {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_IntNoOptions");
        }
        return ok;
    }

    private boolean checkDateOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        boolean ok = true;
        Element v = answer.getNamedChild("valueDate", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<DateType> list = new ArrayList<DateType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueDateType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsDate", new Object[0]) && ok;
            } else {
                boolean found = false;
                for (DateType item : list) {
                    if (!((Date)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoDate", v.primitiveValue()) && ok;
                }
            }
        } else {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_DateNoOptions");
        }
        return ok;
    }

    private boolean checkTimeOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        boolean ok = true;
        Element v = answer.getNamedChild("valueTime", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<TimeType> list = new ArrayList<TimeType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueTimeType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsTime", new Object[0]) && ok;
            } else {
                boolean found = false;
                for (TimeType item : list) {
                    if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoTime", v.primitiveValue()) && ok;
                }
            }
        } else {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_TimeNoOptions");
        }
        return ok;
    }

    private boolean checkStringOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        boolean ok = true;
        Element v = answer.getNamedChild("valueString", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            boolean found = false;
            boolean empty = true;
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                if (components.getValue() == null || !components.hasValueStringType()) continue;
                empty = false;
                found = found || components.getValue().primitiveValue().equals(v.primitiveValue());
            }
            if (!openChoice) {
                ok = empty ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsString", new Object[0]) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoString", v.primitiveValue()) && ok;
            } else {
                found = false;
                for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                    if (components.getValue() == null || !components.hasValueCoding()) continue;
                    Coding c = components.getValueCoding();
                    found = found || c.hasDisplay() && c.getDisplay().equalsIgnoreCase(v.primitiveValue()) || c.hasCode() && c.getCode().equalsIgnoreCase(v.primitiveValue());
                }
                ok = this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), !found, "QUESTIONNAIRE_QR_ITEM_STRING_IN_CODING", v.primitiveValue()) && ok;
            }
        } else {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_StringNoOptions");
        }
        return ok;
    }

    private boolean checkCodingOption(List<ValidationMessage> errors, Element answer, NodeStack stack, QuestionnaireWithContext qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        boolean ok = true;
        Element v = answer.getNamedChild("valueCoding", false);
        String system = v.getNamedChildValue("system", false);
        String code = v.getNamedChildValue("code", false);
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<Coding> list = new ArrayList<Coding>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueCoding());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsCoding", new Object[0]) && ok;
            } else {
                boolean found = false;
                for (Coding item : list) {
                    if (!ObjectUtil.equals((Object)item.getSystem(), (Object)system) || !ObjectUtil.equals((Object)item.getCode(), (Object)code)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoCoding", system, code) && ok;
                }
            }
        } else {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_CodingNoOptions");
        }
        return ok;
    }

    public static class QuestionnaireWithContext {
        private Questionnaire q;
        private Element container;
        private String containerPath;

        public static QuestionnaireWithContext fromQuestionnaire(Questionnaire q) {
            if (q == null) {
                return null;
            }
            QuestionnaireWithContext res = new QuestionnaireWithContext();
            res.q = q;
            return res;
        }

        public static QuestionnaireWithContext fromContainedResource(String path, Element e, Questionnaire q) {
            if (q == null) {
                return null;
            }
            QuestionnaireWithContext res = new QuestionnaireWithContext();
            res.q = q;
            res.container = e;
            res.containerPath = path;
            return res;
        }

        public Questionnaire q() {
            return this.q;
        }
    }

    public class ElementWithIndex {
        private Element element;
        private int index;

        public ElementWithIndex(Element element, int index) {
            this.element = element;
            this.index = index;
        }

        public Element getElement() {
            return this.element;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class QuestionnaireDerivation {
        private Questionnaire questionnaire;
        private QuestionnaireDerivationMode mode;

        protected QuestionnaireDerivation(Questionnaire questionnaire, QuestionnaireDerivationMode mode) {
            this.questionnaire = questionnaire;
            this.mode = mode;
        }

        public Questionnaire getQuestionnaire() {
            return this.questionnaire;
        }

        public QuestionnaireDerivationMode getMode() {
            return this.mode;
        }
    }

    public static enum QuestionnaireDerivationMode {
        EXTENDS,
        COMPLIES;

    }
}

