/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.Decimal;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.elementmodel.ResourceParser;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRLexer;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.BuildExtensions;
import org.hl7.fhir.r5.utils.ResourceUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.sql.Validator;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.r5.utils.validation.IMessagingServices;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidationProfileUsageTracker;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.CheckDisplayOption;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.HL7WorkGroups;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.SIDUtilities;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.UnicodeUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.validation.IDigitalSignatureServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.cli.model.HtmlInMarkdownCheck;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.codesystem.CodingsObserver;
import org.hl7.fhir.validation.instance.PercentageTracker;
import org.hl7.fhir.validation.instance.SpecialExtensions;
import org.hl7.fhir.validation.instance.advisor.BasePolicyAdvisorForFullValidation;
import org.hl7.fhir.validation.instance.type.BundleValidator;
import org.hl7.fhir.validation.instance.type.CodeSystemValidator;
import org.hl7.fhir.validation.instance.type.ConceptMapValidator;
import org.hl7.fhir.validation.instance.type.ImplementationGuideValidator;
import org.hl7.fhir.validation.instance.type.MeasureValidator;
import org.hl7.fhir.validation.instance.type.ObservationValidator;
import org.hl7.fhir.validation.instance.type.QuestionnaireValidator;
import org.hl7.fhir.validation.instance.type.SearchParameterValidator;
import org.hl7.fhir.validation.instance.type.StructureDefinitionValidator;
import org.hl7.fhir.validation.instance.type.StructureMapValidator;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;
import org.hl7.fhir.validation.instance.utils.Base64Util;
import org.hl7.fhir.validation.instance.utils.CanonicalResourceLookupResult;
import org.hl7.fhir.validation.instance.utils.CanonicalTypeSorter;
import org.hl7.fhir.validation.instance.utils.ChildIterator;
import org.hl7.fhir.validation.instance.utils.ElementInfo;
import org.hl7.fhir.validation.instance.utils.EnableWhenEvaluator;
import org.hl7.fhir.validation.instance.utils.FHIRPathExpressionFixer;
import org.hl7.fhir.validation.instance.utils.IndexedElement;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ResolvedReference;
import org.hl7.fhir.validation.instance.utils.ResourceValidationTracker;
import org.hl7.fhir.validation.instance.utils.StructureDefinitionSorterByUrl;
import org.hl7.fhir.validation.instance.utils.UrlUtil;
import org.hl7.fhir.validation.instance.utils.ValidationContext;
import org.w3c.dom.Document;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private static final String EXECUTED_CONSTRAINT_LIST = "validator.executed.invariant.list";
    private static final String EXECUTION_ID = "validator.execution.id";
    private static final String HTML_FRAGMENT_REGEX = "[a-zA-Z]\\w*(((\\s+)(\\S)*)*)";
    private static final boolean STACK_TRACE = false;
    private static final boolean DEBUG_ELEMENT = false;
    private static final boolean SAVE_INTERMEDIARIES = false;
    private static final HashSet<String> NO_TX_SYSTEM_EXEMPT = new HashSet<String>(Arrays.asList("http://loinc.org", "http://unitsofmeasure.org", "http://hl7.org/fhir/sid/icd-9-cm", "http://snomed.info/sct", "http://www.nlm.nih.gov/research/umls/rxnorm"));
    private static final HashSet<String> NO_HTTPS_LIST = new HashSet<String>(Arrays.asList("https://loinc.org", "https://unitsofmeasure.org", "https://snomed.info/sct", "https://www.nlm.nih.gov/research/umls/rxnorm"));
    private static final HashSet<String> EXTENSION_CONTEXT_LIST = new HashSet<String>(Arrays.asList("ElementDefinition.example.value", "ElementDefinition.pattern", "ElementDefinition.fixed"));
    private static final HashSet<String> ID_EXEMPT_LIST = new HashSet<String>(Arrays.asList("id", "base64Binary", "markdown"));
    private static final HashSet<String> HTML_ELEMENTS = new HashSet<String>(Arrays.asList("p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"));
    private static final HashSet<String> HTML_ATTRIBUTES = new HashSet<String>(Arrays.asList("title", "style", "class", "id", "idref", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"));
    private static final HashSet<String> HTML_COMBO_LIST = new HashSet<String>(Arrays.asList("a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap"));
    private static final HashSet<String> HTML_BLOCK_LIST = new HashSet<String>(Arrays.asList("div", "blockquote", "table", "ol", "ul", "p"));
    private static final HashSet<String> RESOURCE_X_POINTS = new HashSet<String>(Arrays.asList("Bundle.entry.resource", "Bundle.entry.response.outcome", "DomainResource.contained", "Parameters.parameter.resource", "Parameters.parameter.part.resource"));
    private FHIRPathEngine fpe;
    private CheckDisplayOption checkDisplay;
    private boolean anyExtensionsAllowed;
    private boolean errorForUnknownProfiles;
    private boolean noInvariantChecks;
    private boolean wantInvariantInMessage;
    private boolean noTerminologyChecks;
    private boolean hintAboutNonMustSupport;
    private boolean showMessagesFromReferences;
    private String validationLanguage;
    private boolean baseOnly;
    private boolean noCheckAggregation;
    private boolean wantCheckSnapshotUnchanged;
    private boolean noUnicodeBiDiControlChars;
    private HtmlInMarkdownCheck htmlInMarkdownCheck;
    private boolean allowComments;
    private boolean allowDoubleQuotesInFHIRPath;
    private List<ImplementationGuide> igs = new ArrayList<ImplementationGuide>();
    private List<String> extensionDomains = new ArrayList<String>();
    private IdStatus resourceIdRule;
    private boolean allowXsiLocation;
    private boolean suppressLoincSnomedMessages;
    private boolean noBindingMsgSuppressed;
    private Map<String, org.hl7.fhir.r5.elementmodel.Element> fetchCache = new HashMap<String, org.hl7.fhir.r5.elementmodel.Element>();
    private HashMap<org.hl7.fhir.r5.elementmodel.Element, ResourceValidationTracker> resourceTracker = new HashMap();
    private IValidationPolicyAdvisor policyAdvisor = new BasePolicyAdvisorForFullValidation(ReferenceValidationPolicy.CHECK_VALID);
    long time = 0L;
    long start = 0L;
    long lastlog = 0L;
    private FHIRPathEngine.IEvaluationContext externalHostServices;
    private boolean noExtensibleWarnings;
    private String serverBase;
    private EnableWhenEvaluator myEnableWhenEvaluator = new EnableWhenEvaluator();
    private String executionId;
    private IValidationProfileUsageTracker tracker;
    private ValidatorHostServices validatorServices;
    private boolean assumeValidRestReferences;
    private boolean securityChecks;
    private ProfileUtilities profileUtilities;
    private boolean crumbTrails;
    private List<BundleValidationRule> bundleValidationRules = new ArrayList<BundleValidationRule>();
    private boolean validateValueSetCodesOnTxServer = true;
    private QuestionnaireMode questionnaireMode;
    private Map<String, CanonicalResourceLookupResult> crLookups = new HashMap<String, CanonicalResourceLookupResult>();
    private boolean logProgress;
    private CodingsObserver codingObserver;
    public List<ValidatedFragment> validatedContent;
    public boolean testMode;
    private boolean example;
    private IDigitalSignatureServices signatureServices;
    private ContextUtilities cu;
    private boolean unknownCodeSystemsCauseErrors;
    private boolean noExperimentalContent;

    public FHIRPathEngine getFHIRPathEngine() {
        return this.fpe;
    }

    public InstanceValidator(@Nonnull IWorkerContext theContext, @Nonnull FHIRPathEngine.IEvaluationContext hostServices, @Nonnull XVerExtensionManager xverManager) {
        super(theContext, xverManager, false);
        this.start = System.currentTimeMillis();
        this.externalHostServices = hostServices;
        this.profileUtilities = new ProfileUtilities(theContext, null, null);
        this.cu = new ContextUtilities(theContext);
        this.fpe = new FHIRPathEngine(this.context);
        this.validatorServices = new ValidatorHostServices();
        this.fpe.setHostServices((FHIRPathEngine.IEvaluationContext)this.validatorServices);
        if (theContext.getVersion().startsWith("3.0") || theContext.getVersion().startsWith("1.0")) {
            this.fpe.setLegacyMode(true);
        }
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe.setDoNotEnforceAsSingletonRule(!VersionUtilities.isR5VerOrLater((String)theContext.getVersion()));
        this.fpe.setAllowDoubleQuotes(this.allowDoubleQuotesInFHIRPath);
        this.codingObserver = new CodingsObserver(theContext, xverManager, this.debug);
    }

    public boolean isNoExtensibleWarnings() {
        return this.noExtensibleWarnings;
    }

    public IResourceValidator setNoExtensibleWarnings(boolean noExtensibleWarnings) {
        this.noExtensibleWarnings = noExtensibleWarnings;
        return this;
    }

    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    public void setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public IResourceValidator setNoInvariantChecks(boolean value) {
        this.noInvariantChecks = value;
        return this;
    }

    public boolean isWantInvariantInMessage() {
        return this.wantInvariantInMessage;
    }

    public IResourceValidator setWantInvariantInMessage(boolean wantInvariantInMessage) {
        this.wantInvariantInMessage = wantInvariantInMessage;
        return this;
    }

    public IValidationPolicyAdvisor getPolicyAdvisor() {
        return this.policyAdvisor;
    }

    public IResourceValidator setPolicyAdvisor(IValidationPolicyAdvisor advisor) {
        if (advisor == null) {
            throw new Error("Cannot set advisor to null");
        }
        this.policyAdvisor = advisor;
        return this;
    }

    public IValidationProfileUsageTracker getTracker() {
        return this.tracker;
    }

    public IResourceValidator setTracker(IValidationProfileUsageTracker value) {
        this.tracker = value;
        return this;
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public void setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean value) {
        this.assumeValidRestReferences = value;
    }

    public boolean isAllowComments() {
        return this.allowComments;
    }

    public void setAllowComments(boolean allowComments) {
        this.allowComments = allowComments;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public void setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
    }

    public boolean isDoImplicitFHIRPathStringConversion() {
        return this.fpe.isDoImplicitStringConversion();
    }

    public void setDoImplicitFHIRPathStringConversion(boolean doImplicitFHIRPathStringConversion) {
        this.fpe.setDoImplicitStringConversion(doImplicitFHIRPathStringConversion);
    }

    private boolean allowUnknownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private boolean isKnownExtension(String url) {
        if (this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("nema.org") || url.startsWith("http://hl7.org/fhir/tools/StructureDefinition/") || url.equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-expression") || url.equals("http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format) throws FHIRException {
        return this.validate(appContext, errors, stream, format, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, stream, format, profiles);
    }

    private StructureDefinition getSpecifiedProfile(String profile) {
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile);
        if (sd == null) {
            throw new FHIRException(this.context.formatMessage("Unable_to_locate_the_profile__in_order_to_validate_against_it", new Object[]{profile}));
        }
        return sd;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, List<StructureDefinition> profiles) throws FHIRException {
        ParserBase parser = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)format);
        ArrayList<StructureDefinition> logicals = new ArrayList<StructureDefinition>();
        for (StructureDefinition sd : profiles) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) continue;
            logicals.add(sd);
        }
        if (logicals.size() > 0 && this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, "Configuration", logicals.size() == 1, logicals.size(), "MULTIPLE_LOGICAL_MODELS", ResourceUtilities.listUrls(logicals))) {
            parser.setLogical((StructureDefinition)logicals.get(0));
        }
        if (parser instanceof XmlParser) {
            ((XmlParser)parser).setAllowXsiLocation(this.allowXsiLocation);
        }
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING);
        if (parser instanceof XmlParser) {
            ((XmlParser)parser).setAllowXsiLocation(this.allowXsiLocation);
        }
        if (parser instanceof JsonParser) {
            ((JsonParser)parser).setAllowComments(this.allowComments);
        }
        parser.setSignatureServices(this.signatureServices);
        long t = System.nanoTime();
        this.validatedContent = null;
        try {
            this.validatedContent = parser.parse(stream);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (this.validatedContent != null && !this.validatedContent.isEmpty()) {
            String url = parser.getImpliedProfile();
            if (url != null) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
                if (sd == null) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, "Payload", false, "Implied profile " + url + " not known to validator", new Object[0]);
                } else {
                    profiles.add(sd);
                }
            }
            for (ValidatedFragment ne : this.validatedContent) {
                if (ne.getElement() != null) {
                    this.validate(appContext, (List<ValidationMessage>)ne.getErrors(), this.validatedContent.size() > 1 ? ne.path() : null, ne.getElement(), profiles);
                }
                errors.addAll(ne.getErrors());
            }
        }
        return this.validatedContent == null || this.validatedContent.isEmpty() ? null : this.validatedContent.get(0).getElement();
    }

    private void saveValidatedContent(ValidatedFragment ne, int index) {
        String tgt = null;
        try {
            tgt = Utilities.path((String[])new String[]{"[tmp]", "validator", "content"});
            Utilities.createDirectory((String)tgt);
            tgt = Utilities.path((String[])new String[]{tgt, "content-" + index + "-" + ne.getFilename()});
            TextFile.bytesToFile((byte[])ne.getContent(), (String)tgt);
        }
        catch (Exception e) {
            System.out.println("Error saving internal content to '" + tgt + "': " + e.getLocalizedMessage());
        }
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource) throws FHIRException {
        return this.validate(appContext, errors, resource, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, resource, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Resource resource, List<StructureDefinition> profiles) throws FHIRException {
        long t = System.nanoTime();
        org.hl7.fhir.r5.elementmodel.Element e = new ResourceParser(this.context).parse(resource);
        this.timeTracker.load(t);
        this.validate(appContext, errors, null, e, profiles);
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, org.w3c.dom.Element element) throws FHIRException {
        return this.validate(appContext, errors, element, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, org.w3c.dom.Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, element, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, org.w3c.dom.Element element, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING);
        long t = System.nanoTime();
        try {
            e = parser.parse(errors, element);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, null, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document) throws FHIRException {
        return this.validate(appContext, errors, document, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, document, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, Document document, List<StructureDefinition> profiles) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element e;
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING);
        long t = System.nanoTime();
        try {
            e = parser.parse(errors, document);
        }
        catch (IOException e1) {
            throw new FHIRException((Throwable)e1);
        }
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, null, e, profiles);
        }
        return e;
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object) throws FHIRException {
        return this.validate(appContext, errors, object, new ArrayList<StructureDefinition>());
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        return this.validate(appContext, errors, object, profiles);
    }

    public org.hl7.fhir.r5.elementmodel.Element validate(Object appContext, List<ValidationMessage> errors, JsonObject object, List<StructureDefinition> profiles) throws FHIRException {
        JsonParser parser = new JsonParser(this.context, new ProfileUtilities(this.context, null, null, this.fpe));
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING);
        long t = System.nanoTime();
        org.hl7.fhir.r5.elementmodel.Element e = parser.parse(errors, object);
        this.timeTracker.load(t);
        if (e != null) {
            this.validate(appContext, errors, null, e, profiles);
        }
        return e;
    }

    public void validate(Object appContext, List<ValidationMessage> errors, String initialPath, org.hl7.fhir.r5.elementmodel.Element element) throws FHIRException {
        this.validate(appContext, errors, initialPath, element, new ArrayList<StructureDefinition>());
    }

    public void validate(Object appContext, List<ValidationMessage> errors, String initialPath, org.hl7.fhir.r5.elementmodel.Element element, String profile) throws FHIRException {
        ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        if (profile != null) {
            profiles.add(this.getSpecifiedProfile(profile));
        }
        this.validate(appContext, errors, initialPath, element, profiles);
    }

    public void validate(Object appContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, List<StructureDefinition> profiles) throws FHIRException {
        this.fetchCache.clear();
        this.fetchCache.put(element.fhirType() + "/" + element.getIdBase(), element);
        this.resourceTracker.clear();
        this.trackedMessages.clear();
        this.messagesToRemove.clear();
        this.executionId = UUID.randomUUID().toString();
        this.baseOnly = profiles.isEmpty();
        InstanceValidator.setParents(element);
        long t = System.nanoTime();
        NodeStack stack = new NodeStack(this.context, null, element, this.validationLanguage);
        if (profiles == null || profiles.isEmpty()) {
            this.validateResource(new ValidationContext(appContext, element), errors, element, element, null, this.resourceIdRule, stack.resetIds(), null, new Base.ValidationMode(Base.ValidationReason.Validation, Base.ProfileSource.BaseDefinition), false, false);
        } else {
            for (int i = 0; i < profiles.size(); ++i) {
                StructureDefinition sd = profiles.get(i);
                if (!sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) continue;
                for (Extension ext : sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
                    StructureDefinition dep = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ext.getValue().primitiveValue(), (Resource)sd);
                    if (dep == null) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), false, "VALIDATION_VAL_PROFILE_DEPENDS_NOT_RESOLVED", ext.getValue().primitiveValue(), sd.getVersionedUrl());
                        continue;
                    }
                    if (profiles.contains(dep)) continue;
                    profiles.add(dep);
                }
            }
            for (StructureDefinition defn : profiles) {
                this.validateResource(new ValidationContext(appContext, element), errors, element, element, defn, this.resourceIdRule, stack.resetIds(), null, new Base.ValidationMode(Base.ValidationReason.Validation, Base.ProfileSource.ConfigProfile), false, false);
            }
        }
        if (this.hintAboutNonMustSupport && !profiles.isEmpty()) {
            this.checkElementUsage(errors, element, stack);
        }
        this.codingObserver.finish(errors, stack);
        errors.removeAll(this.messagesToRemove);
        this.timeTracker.overall(t);
    }

    private void checkElementUsage(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        if (element.getPath() == null || element.getName().equals("id") && !element.getPath().substring(0, element.getPath().length() - 3).contains(".") || element.getName().equals("text") && !element.getPath().substring(0, element.getPath().length() - 5).contains(".")) {
            return;
        }
        String hasFixed = element.getUserString("hasFixed");
        if (element.getPath().contains(".") && (hasFixed == null || !hasFixed.equals("Y"))) {
            String elementUsage = element.getUserString("elementSupported");
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), elementUsage != null && (elementUsage.equals("Y") || elementUsage.equals("NA")), "MustSupport_VAL_MustSupport", element.getName(), element.getProperty().getStructure().getVersionedUrl());
            if (elementUsage == null || !elementUsage.equals("Y")) {
                return;
            }
        }
        if (element.hasChildren() && (hasFixed == null || !hasFixed.equals("Y"))) {
            String prevName = "";
            int elementCount = 0;
            for (org.hl7.fhir.r5.elementmodel.Element ce : element.getChildren()) {
                if (ce.getName().equals(prevName)) {
                    ++elementCount;
                } else {
                    elementCount = 1;
                    prevName = ce.getName();
                }
                this.checkElementUsage(errors, ce, stack.push(ce, elementCount, null, null));
            }
        }
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString((String)v1) : v1.equals(v2);
    }

    private boolean checkAddress(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Address fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use", false), (Element)fixed.getUseElement(), fixedSource, "use", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text", false), (Element)fixed.getTextElement(), fixedSource, "text", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city", false), (Element)fixed.getCityElement(), fixedSource, "city", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state", false), (Element)fixed.getStateElement(), fixedSource, "state", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country", false), (Element)fixed.getCountryElement(), fixedSource, "country", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip", false), (Element)fixed.getPostalCodeElement(), fixedSource, "postalCode", focus, pattern, context) && ok;
        ArrayList lines = new ArrayList();
        focus.getNamedChildren("line", lines);
        if (pattern) {
            boolean lineSizeCheck;
            boolean bl = lineSizeCheck = lines.size() >= fixed.getLine().size();
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lineSizeCheck, "Fixed_Type_Checks_DT_Address_Line", Integer.toString(fixed.getLine().size()), Integer.toString(lines.size()))) {
                for (int i = 0; i < fixed.getLine().size(); ++i) {
                    StringType fixedLine = (StringType)fixed.getLine().get(i);
                    boolean found = false;
                    ArrayList allErrorsFixed = new ArrayList();
                    ArrayList<ValidationMessage> errorsFixed = null;
                    for (int j = 0; j < lines.size() && !found; ++j) {
                        errorsFixed = new ArrayList<ValidationMessage>();
                        this.checkFixedValue(errorsFixed, path + ".line", (org.hl7.fhir.r5.elementmodel.Element)lines.get(j), (Element)fixedLine, fixedSource, "line", focus, pattern, context);
                        if (!this.hasErrors(errorsFixed)) {
                            found = true;
                            continue;
                        }
                        errorsFixed.stream().filter(t -> t.getLevel().ordinal() >= ValidationMessage.IssueSeverity.ERROR.ordinal()).forEach(t -> allErrorsFixed.add(t));
                    }
                    if (found) continue;
                    ok = this.rule(errorsFixed, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "PATTERN_CHECK_STRING", fixedLine.getValue(), fixedSource, allErrorsFixed) && ok;
                }
            } else {
                ok = false;
            }
        } else if (!pattern) {
            boolean lineSizeCheck;
            boolean bl = lineSizeCheck = lines.size() == fixed.getLine().size();
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lineSizeCheck, "Fixed_Type_Checks_DT_Address_Line", Integer.toString(fixed.getLine().size()), Integer.toString(lines.size()))) {
                for (int i = 0; i < lines.size(); ++i) {
                    ok = this.checkFixedValue(errors, path + ".line", (org.hl7.fhir.r5.elementmodel.Element)lines.get(i), (Element)fixed.getLine().get(i), fixedSource, "line", focus, pattern, context) && ok;
                }
            } else {
                ok = false;
            }
        }
        return ok;
    }

    private boolean checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Attachment fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType", false), (Element)fixed.getContentTypeElement(), fixedSource, "contentType", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language", false), (Element)fixed.getLanguageElement(), fixedSource, "language", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data", false), (Element)fixed.getDataElement(), fixedSource, "data", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url", false), (Element)fixed.getUrlElement(), fixedSource, "url", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size", false), (Element)fixed.getSizeElement(), fixedSource, "size", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash", false), (Element)fixed.getHashElement(), fixedSource, "hash", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title", false), (Element)fixed.getTitleElement(), fixedSource, "title", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkCode(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String path, String code, String system, String version, String display, boolean checkDisplay, NodeStack stack) throws TerminologyServiceException {
        boolean ok = true;
        long t = System.nanoTime();
        boolean ss = this.context.supportsSystem(system, this.baseOptions.getFhirVersion());
        this.timeTracker.tx(t, "ss " + system);
        if (ss) {
            t = System.nanoTime();
            ValidationResult s = this.checkCodeOnServer(stack, code, system, version, display, checkDisplay);
            this.timeTracker.tx(t, "vc " + system + "#" + code + " '" + display + "'");
            if (s == null) {
                return true;
            }
            ok = this.processTxIssues(errors, s, element, path, false, null, null) & ok;
            if (s.isOk()) {
                if (s.getMessage() != null && !s.messageIsInIssues()) {
                    this.txWarning(errors, NO_RULE_DATE, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, "Terminology_PassThrough_TX_Message", s.getMessage(), system, code);
                }
                return ok;
            }
            if (!s.messageIsInIssues()) {
                if (s.getErrorClass() != null && s.getErrorClass().isInfrastructure()) {
                    this.txWarning(errors, NO_RULE_DATE, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
                } else if (s.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                    this.txHint(errors, NO_RULE_DATE, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
                } else if (s.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                    this.txWarning(errors, NO_RULE_DATE, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
                } else {
                    return this.txRule(errors, NO_RULE_DATE, s.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, "Terminology_PassThrough_TX_Message", s.getMessage(), system, code) && ok;
                }
            }
            return ok;
        }
        if (system.startsWith("http://build.fhir.org") || system.startsWith("https://build.fhir.org")) {
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_WRONG_BUILD", system, this.suggestSystemForBuild(system));
            return false;
        }
        if (system.startsWith("http://hl7.org/fhir") || system.startsWith("https://hl7.org/fhir") || system.startsWith("http://www.hl7.org/fhir") || system.startsWith("https://www.hl7.org/fhir")) {
            if (SIDUtilities.isknownCodeSystem((String)system)) {
                return ok;
            }
            if (system.startsWith("http://hl7.org/fhir/test")) {
                return ok;
            }
            if (system.endsWith(".html")) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_WRONG_HTML", system, this.suggestSystemForPage(system));
                return false;
            }
            CodeSystem cs = this.getCodeSystem(system);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs != null, "Terminology_TX_System_Unknown", system)) {
                CodeSystem.ConceptDefinitionComponent def = this.getCodeDefinition(cs, code);
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "UNKNOWN_CODESYSTEM", system, code)) {
                    return this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Terminology_TX_Display_Wrong", def.getDisplay()) && ok;
                }
            }
            return false;
        }
        if (this.context.isNoTerminologyServer() && NO_TX_SYSTEM_EXEMPT.contains(system)) {
            this.txWarning(errors, NO_RULE_DATE, null, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, false, "Error_validating_code_running_without_terminology_services", code, system);
            return ok;
        }
        if (this.startsWithButIsNot(system, "http://snomed.info/sct", "http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm")) {
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_Invalid", system);
            return false;
        }
        try {
            String ns;
            CodeSystem cs;
            if (this.context.fetchResourceWithException(ValueSet.class, system, (Resource)element.getProperty().getStructure()) != null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_System_ValueSet", system) && ok;
            }
            boolean done = false;
            if (system.startsWith("https:") && system.length() > 7 && ((cs = this.getCodeSystem(ns = "http:" + system.substring(6))) != null || NO_HTTPS_LIST.contains(system))) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_HTTPS", system);
                done = true;
            }
            if (!this.isAllowExamples() || !Utilities.startsWithInList((String)system, (String[])new String[]{"http://example.org", "https://example.org"})) {
                CodeSystem cs2 = this.context.fetchCodeSystem(system);
                if (cs2 == null) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.UNKNOWN, element.line(), element.col(), path, done, "UNKNOWN_CODESYSTEM", system);
                } else if (this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.UNKNOWN, element.line(), element.col(), path, cs2.getContent() != Enumerations.CodeSystemContentMode.NOTPRESENT, "TERMINOLOGY_TX_SYSTEM_NOT_USABLE", system)) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.UNKNOWN, element.line(), element.col(), path, false, "Error - this should not happen? (Consult GG)", new Object[0]) && ok;
                }
            }
            return ok;
        }
        catch (Exception e) {
            return ok;
        }
    }

    private Object suggestSystemForPage(String system) {
        if (system.contains("/codesystem-")) {
            String s = system.substring(system.indexOf("/codesystem-") + 12);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if (system.contains("/valueset-")) {
            String s = system.substring(system.indexOf("/valueset-") + 8);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        return "{unable to determine intended url}";
    }

    private Object suggestSystemForBuild(String system) {
        if (((String)system).contains("/codesystem-")) {
            String s = ((String)system).substring(((String)system).indexOf("/codesystem-") + 12);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if (((String)system).contains("/valueset-")) {
            String s = ((String)system).substring(((String)system).indexOf("/valueset-") + 8);
            String url = "http://hl7.org/fhir/" + s.replace(".html", "");
            if (this.context.fetchCodeSystem(url) != null) {
                return url;
            }
            return "{unable to determine intended url}";
        }
        if (((String)(system = ((String)system).replace("https://", "http://"))).length() < 22) {
            return "{unable to determine intended url}";
        }
        if (this.context.fetchCodeSystem((String)(system = "http://hl7.org/fhir/" + ((String)system).substring(22).replace(".html", ""))) != null) {
            return system;
        }
        return "{unable to determine intended url}";
    }

    private boolean startsWithButIsNot(String system, String ... uri) {
        for (String s : uri) {
            if (system.equals(s) || !system.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean hasErrors(List<ValidationMessage> errors) {
        if (errors != null) {
            for (ValidationMessage vm : errors) {
                if (vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && vm.getLevel() != ValidationMessage.IssueSeverity.ERROR) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, CodeableConcept fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text", false), (Element)fixed.getTextElement(), fixedSource, "text", focus, pattern, context) && ok;
        ArrayList codings = new ArrayList();
        focus.getNamedChildren("coding", codings);
        if (pattern) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() >= fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) {
                for (int i = 0; i < fixed.getCoding().size(); ++i) {
                    Coding fixedCoding = (Coding)fixed.getCoding().get(i);
                    boolean found = false;
                    ArrayList allErrorsFixed = new ArrayList();
                    for (int j = 0; j < codings.size() && !found; ++j) {
                        ArrayList<ValidationMessage> errorsFixed = new ArrayList<ValidationMessage>();
                        this.checkFixedValue(errorsFixed, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(j), (Element)fixedCoding, fixedSource, "coding", focus, pattern, context);
                        if (!this.hasErrors(errorsFixed)) {
                            found = true;
                            continue;
                        }
                        errorsFixed.stream().filter(t -> t.getLevel().ordinal() >= ValidationMessage.IssueSeverity.ERROR.ordinal()).forEach(t -> allErrorsFixed.add(t));
                    }
                    if (found) continue;
                    ok = fixedCoding.hasUserSelected() ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, pattern ? "TYPE_CHECKS_PATTERN_CC_US" : "TYPE_CHECKS_FIXED_CC_US", fixedCoding.getSystemElement().asStringValue(), fixedCoding.getCodeElement().asStringValue(), fixedCoding.getDisplayElement().asStringValue(), fixedSource, allErrorsFixed, fixedCoding.getUserSelected()) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, pattern ? "TYPE_CHECKS_PATTERN_CC" : "TYPE_CHECKS_FIXED_CC", fixedCoding.getSystemElement().asStringValue(), fixedCoding.getCodeElement().asStringValue(), fixedCoding.getDisplayElement().asStringValue(), fixedSource, allErrorsFixed) && ok;
                }
            } else {
                ok = false;
            }
        } else if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Terminology_TX_Coding_Count", Integer.toString(fixed.getCoding().size()), Integer.toString(codings.size()))) {
            for (int i = 0; i < codings.size(); ++i) {
                ok = this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.r5.elementmodel.Element)codings.get(i), (Element)fixed.getCoding().get(i), fixedSource, "coding", focus, false, context) && ok;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack, BaseValidator.BooleanHolder bh) {
        boolean checkDisp = true;
        BaseValidator.BooleanHolder checked = new BaseValidator.BooleanHolder(false);
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                try {
                    CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)element);
                    if (binding.hasValueSet()) {
                        String vsRef = binding.getValueSet();
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile);
                        Enumerations.BindingStrength strength = binding.getStrength();
                        Extension maxVS = binding.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
                        checkDisp = this.validateBindingCodeableConcept(errors, path, element, profile, stack, bh, checkDisp, checked, cc, vsRef, valueset, strength, maxVS, true, null);
                    } else if (!this.noBindingMsgSuppressed) {
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                    for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : binding.getAdditional()) {
                        Enumerations.BindingStrength strength;
                        ValueSet valueset;
                        StringBuilder b = new StringBuilder();
                        if (!this.isTestableBinding(ab) || !this.isInScope(ab, profile, this.getResource(stack), b)) continue;
                        String vsRef = ab.getValueSet();
                        checkDisp = this.validateBindingCodeableConcept(errors, path, element, profile, stack, bh, checkDisp, checked, cc, vsRef, valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile), strength = this.convertPurposeToStrength(ab.getPurpose()), null, false, b.toString()) && checkDisp;
                    }
                }
                catch (CheckCodeOnServerException e) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getCause().getMessage());
                }
            }
        }
        if (!this.noTerminologyChecks && theElementCntext != null && !checked.ok()) {
            try {
                CodeableConcept cc = ObjectConverter.readAsCodeableConcept((org.hl7.fhir.r5.elementmodel.Element)element);
                if (cc.hasCoding()) {
                    long t = System.nanoTime();
                    ValidationResult vr = this.checkCodeOnServer(stack, null, cc);
                    bh.see(this.processTxIssues(errors, vr, element, path, false, null, null));
                    this.timeTracker.tx(t, "vc " + cc.toString());
                }
            }
            catch (CheckCodeOnServerException e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getCause().getMessage());
            }
        }
        return checkDisp;
    }

    private boolean isInScope(ElementDefinition.ElementDefinitionBindingAdditionalComponent ab, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, StringBuilder b) {
        if (ab.getUsage().isEmpty()) {
            return true;
        }
        boolean ok = true;
        for (UsageContext usage : ab.getUsage()) {
            if (this.isInScope(usage, profile, resource, b)) continue;
            ok = false;
        }
        return ok;
    }

    private boolean isInScope(UsageContext usage, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, StringBuilder b) {
        List<org.hl7.fhir.r5.elementmodel.Element> items;
        if (this.isKnownUsage(usage)) {
            return true;
        }
        if (usage.getCode().hasSystem() && (usage.getCode().getSystem().equals(profile.getUrl()) || usage.getCode().getSystem().equals(profile.getVersionedUrl())) && this.matchesUsage(items = this.findDataValue(resource, usage.getCode().getCode()), usage.getValue())) {
            b.append(this.context.formatMessage("BINDING_ADDITIONAL_USAGE", new Object[]{this.displayCoding(usage.getCode()), this.display(usage.getValue())}));
            return true;
        }
        return false;
    }

    private String displayCoding(Coding value) {
        return value.getCode();
    }

    private String displayCodeableConcept(CodeableConcept value) {
        for (Coding c : value.getCoding()) {
            String s = this.displayCoding(c);
            if (s == null) continue;
            return s;
        }
        return value.getText();
    }

    private String display(DataType value) {
        switch (value.fhirType()) {
            case "Coding": {
                return this.displayCoding((Coding)value);
            }
            case "CodeableConcept": {
                return this.displayCodeableConcept((CodeableConcept)value);
            }
        }
        return value.fhirType();
    }

    private boolean matchesUsage(List<org.hl7.fhir.r5.elementmodel.Element> items, DataType value) {
        for (org.hl7.fhir.r5.elementmodel.Element item : items) {
            if (!this.matchesUsage(item, value)) continue;
            return true;
        }
        return false;
    }

    private String display(List<org.hl7.fhir.r5.elementmodel.Element> items) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (org.hl7.fhir.r5.elementmodel.Element item : items) {
            this.display(b, item);
        }
        return b.toString();
    }

    private void display(CommaSeparatedStringBuilder b, org.hl7.fhir.r5.elementmodel.Element item) {
        if (item.isPrimitive()) {
            b.append(item.primitiveValue());
        } else if (item.fhirType().equals("CodeableConcept")) {
            for (org.hl7.fhir.r5.elementmodel.Element c : item.getChildren("coding")) {
                b.append(c.getNamedChildValue("code"));
            }
        } else {
            b.append(item.toString());
        }
    }

    private boolean matchesUsage(org.hl7.fhir.r5.elementmodel.Element item, DataType value) {
        switch (value.fhirType()) {
            case "CodeableConcept": {
                return this.matchesUsageCodeableConcept(item, (CodeableConcept)value);
            }
            case "Quantity": {
                return false;
            }
            case "Range": {
                return false;
            }
            case "Reference": {
                return false;
            }
        }
        return false;
    }

    private boolean matchesUsageCodeableConcept(org.hl7.fhir.r5.elementmodel.Element item, CodeableConcept value) {
        switch (item.fhirType()) {
            case "CodeableConcept": {
                return this.matchesUsageCodeableConceptCodeableConcept(item, value);
            }
            case "Coding": {
                return this.matchesUsageCodeableConceptCoding(item, value);
            }
        }
        return false;
    }

    private boolean matchesUsageCodeableConceptCoding(org.hl7.fhir.r5.elementmodel.Element item, CodeableConcept value) {
        String system = item.getNamedChildValue("system");
        String version = item.getNamedChildValue("version");
        String code = item.getNamedChildValue("code");
        Iterator iterator = value.getCoding().iterator();
        if (iterator.hasNext()) {
            Coding c = (Coding)iterator.next();
            if (system == null || !system.equals(c.getSystem())) {
                return false;
            }
            if (code == null || !code.equals(c.getCode())) {
                return false;
            }
            return !c.hasVersion() || version != null && version.equals(c.getVersion());
        }
        return false;
    }

    private boolean matchesUsageCodeableConceptCodeableConcept(org.hl7.fhir.r5.elementmodel.Element item, CodeableConcept value) {
        for (org.hl7.fhir.r5.elementmodel.Element code : item.getChildren("coding")) {
            if (!this.matchesUsageCodeableConceptCoding(code, value)) continue;
            return true;
        }
        return false;
    }

    private List<org.hl7.fhir.r5.elementmodel.Element> findDataValue(org.hl7.fhir.r5.elementmodel.Element resource, String code) {
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> items = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        if (resource != null) {
            this.findDataValues(items, resource, code);
        }
        return items;
    }

    private void findDataValues(List<org.hl7.fhir.r5.elementmodel.Element> items, org.hl7.fhir.r5.elementmodel.Element element, String path) {
        if (element.getPath() == null) {
            return;
        }
        if (this.pathMatches(element.getPath(), path)) {
            items.add(element);
        } else if (element.hasChildren() && path.startsWith(element.getPath())) {
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                this.findDataValues(items, child, path);
            }
        }
    }

    private boolean pathMatches(String actualPath, String pathSpec) {
        String[] ps;
        String[] ap = actualPath.split("\\.");
        if (ap.length != (ps = pathSpec.split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < ap.length; ++i) {
            if (this.pathSegmentMatches(ap[i], ps[i])) continue;
            return false;
        }
        return true;
    }

    private boolean pathSegmentMatches(String ap, String ps) {
        if (ps.contains("[")) {
            return ap.equals(ps);
        }
        if (ap.contains("[")) {
            ap = ap.substring(0, ap.indexOf("["));
        }
        return ap.equals(ps);
    }

    private Enumerations.BindingStrength convertPurposeToStrength(ElementDefinition.AdditionalBindingPurposeVS purpose) {
        switch (purpose) {
            case MAXIMUM: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
        }
        return null;
    }

    private boolean isTestableBinding(ElementDefinition.ElementDefinitionBindingAdditionalComponent ab) {
        return ab.hasValueSet() && this.convertPurposeToStrength(ab.getPurpose()) != null;
    }

    private boolean validateBindingCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack, BaseValidator.BooleanHolder bh, boolean checkDisp, BaseValidator.BooleanHolder checked, CodeableConcept cc, String vsRef, ValueSet valueset, Enumerations.BindingStrength strength, Extension maxVS, boolean base, String usageNote) throws CheckCodeOnServerException {
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(vsRef);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(vsRef))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(vsRef));
            } else {
                bh.fail();
            }
        } else {
            BindingContext bc;
            BindingContext bindingContext = bc = base ? BindingContext.BASE : BindingContext.ADDITIONAL;
            if (!cc.hasCoding()) {
                if (strength == Enumerations.BindingStrength.REQUIRED) {
                    bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote)));
                } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                    if (maxVS != null) {
                        bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSetMax", this.describeReference(ToolingExtensions.readStringFromExtension((Extension)maxVS)), valueset.getVersionedUrl()));
                    } else if (!this.noExtensibleWarnings) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Code_ValueSet_Ext", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote));
                    }
                }
            } else {
                long t = System.nanoTime();
                boolean bindingsOk = true;
                if (strength != Enumerations.BindingStrength.EXAMPLE) {
                    if (strength == Enumerations.BindingStrength.REQUIRED) {
                        this.removeTrackedMessagesForLocation(errors, element, path);
                    }
                    boolean atLeastOneSystemIsSupported = false;
                    for (Coding nextCoding : cc.getCoding()) {
                        String nextSystem = nextCoding.getSystem();
                        if (!StringUtils.isNotBlank((CharSequence)nextSystem) || !this.context.supportsSystem(nextSystem, this.baseOptions.getFhirVersion())) continue;
                        atLeastOneSystemIsSupported = true;
                        break;
                    }
                    if (atLeastOneSystemIsSupported || strength != Enumerations.BindingStrength.EXAMPLE) {
                        checked.set(true);
                        ValidationResult vr = this.checkCodeOnServer(stack, valueset, cc);
                        bh.see(this.processTxIssues(errors, vr, element, path, false, vsRef, strength));
                        if (!vr.isOk()) {
                            bindingsOk = false;
                            if (vr.getErrorClass() != null && vr.getErrorClass() == TerminologyServiceErrorClass.NOSERVICE) {
                                if (strength == Enumerations.BindingStrength.REQUIRED || strength == Enumerations.BindingStrength.EXTENSIBLE && maxVS != null) {
                                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_NOSVC_BOUND_REQ", this.describeReference(vsRef));
                                } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_NOSVC_BOUND_EXT", this.describeReference(vsRef));
                                }
                            } else if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                                if (strength == Enumerations.BindingStrength.REQUIRED) {
                                    this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_1_CC", this.describeReference(vsRef), vr.getErrorClass().toString());
                                } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (maxVS != null) {
                                        bh.see(this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)maxVS), cc, stack));
                                    } else if (!this.noExtensibleWarnings) {
                                        this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_2_CC", this.describeReference(vsRef), vr.getErrorClass().toString());
                                    }
                                } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_3_CC", this.describeReference(vsRef), vr.getErrorClass().toString());
                                }
                            } else if ((vr.getErrorClass() == null || vr.getErrorClass() != TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) && vr.getErrorClass() != TerminologyServiceErrorClass.SERVER_ERROR) {
                                if (strength == Enumerations.BindingStrength.REQUIRED) {
                                    bh.see(this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_1_CC", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.ccSummary(cc)));
                                } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                                    if (maxVS != null) {
                                        bh.see(this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)maxVS), cc, stack));
                                    }
                                    if (!this.noExtensibleWarnings) {
                                        this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_2_CC", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.ccSummary(cc));
                                    }
                                } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_3_CC", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.ccSummary(cc));
                                }
                            }
                        } else if (vr.getMessage() != null) {
                            if (vr.getTrimmedMessage() != null) {
                                if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                                    this.txHint(errors, "2023-07-03", vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                                } else {
                                    checkDisp = false;
                                    this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getTrimmedMessage(), new Object[0]);
                                }
                            }
                        } else {
                            if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                                this.removeTrackedMessagesForLocation(errors, element, path);
                            }
                            checkDisp = false;
                        }
                    }
                    if (bindingsOk) {
                        // empty if block
                    }
                    this.timeTracker.tx(t, "vc " + cc.toString());
                }
            }
        }
        return checkDisp;
    }

    private boolean processTxIssues(List<ValidationMessage> errors, ValidationResult vr, org.hl7.fhir.r5.elementmodel.Element element, String path, boolean ignoreCantInfer, String vsurl, Enumerations.BindingStrength bs) {
        boolean ok = true;
        if (vr != null) {
            for (OperationOutcome.OperationOutcomeIssueComponent iss : vr.getIssues()) {
                ValidationMessage vmsg;
                if (iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "not-in-vs") || iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "this-code-not-in-vs") || ignoreCantInfer || iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "cannot-infer")) continue;
                OperationOutcome.OperationOutcomeIssueComponent i = iss.copy();
                if (i.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "not-found")) {
                    String msg = iss.getDetails().getText();
                    boolean isHL7 = msg == null ? false : msg.contains("http://hl7.org/fhir") || msg.contains("http://terminology.hl7.org");
                    OperationOutcome.IssueSeverity notFoundLevel = null;
                    String notFoundNote = null;
                    if (bs == null) {
                        notFoundLevel = OperationOutcome.IssueSeverity.WARNING;
                        notFoundNote = null;
                    } else if (bs == Enumerations.BindingStrength.REQUIRED && isHL7) {
                        notFoundLevel = OperationOutcome.IssueSeverity.ERROR;
                        notFoundNote = "error because this is a required binding to an HL7 code system";
                    } else if (bs == Enumerations.BindingStrength.REQUIRED && this.unknownCodeSystemsCauseErrors) {
                        notFoundLevel = OperationOutcome.IssueSeverity.ERROR;
                        notFoundNote = "error because this is a required binding";
                    } else if (bs == Enumerations.BindingStrength.REQUIRED) {
                        notFoundLevel = OperationOutcome.IssueSeverity.WARNING;
                        notFoundNote = null;
                    } else if (bs == Enumerations.BindingStrength.EXTENSIBLE) {
                        notFoundLevel = OperationOutcome.IssueSeverity.WARNING;
                        notFoundNote = null;
                    } else {
                        notFoundLevel = OperationOutcome.IssueSeverity.WARNING;
                        notFoundNote = null;
                    }
                    if (notFoundLevel != null && i.getSeverity().isHigherThan(notFoundLevel)) {
                        i.setSeverity(notFoundLevel);
                        if (notFoundNote != null) {
                            i.getDetails().setText(i.getDetails().getText() + " (" + notFoundNote + ")");
                        }
                    }
                }
                if (this.baseOptions.isDisplayWarningMode() && i.getSeverity() == OperationOutcome.IssueSeverity.ERROR && i.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "invalid-display")) {
                    i.setSeverity(OperationOutcome.IssueSeverity.WARNING);
                }
                if (!(vmsg = this.txIssue(errors, null, vr.getTxLink(), element.line(), element.col(), path, i)).isError()) continue;
                ok = false;
            }
        }
        return ok;
    }

    public boolean checkBindings(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, ValueSet valueset, Coding nextCoding) {
        boolean ok = true;
        if (StringUtils.isNotBlank((CharSequence)nextCoding.getCode()) && StringUtils.isNotBlank((CharSequence)nextCoding.getSystem()) && this.context.supportsSystem(nextCoding.getSystem(), this.baseOptions.getFhirVersion())) {
            ValidationResult vr = this.checkCodeOnServer(stack, valueset, nextCoding);
            boolean bl = ok = this.processTxIssues(errors, vr, element, path, false, null, null) && ok;
            if (vr.getSeverity() != null && !vr.messageIsInIssues()) {
                if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                } else if (vr.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                    this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                } else {
                    ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]) && ok;
                }
            }
        }
        return ok;
    }

    private boolean checkCDACodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, NodeStack stack, StructureDefinition logical) {
        BaseValidator.BooleanHolder ok = new BaseValidator.BooleanHolder(true);
        if (!this.noTerminologyChecks && theElementCntext != null && theElementCntext.hasBinding()) {
            try {
                CodeableConcept cc = new CodeableConcept();
                ok.see(this.convertCDACodeToCodeableConcept(errors, path, element, logical, cc));
                ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing", path)) {
                    if (binding.hasValueSet()) {
                        String vsRef = binding.getValueSet();
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile);
                        Enumerations.BindingStrength strength = binding.getStrength();
                        Extension vsMax = binding.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
                        this.validateBindingCodeableConcept(errors, path, element, profile, stack, ok, false, new BaseValidator.BooleanHolder(), cc, vsRef, valueset, strength, vsMax, true, null);
                        if (this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, logical.getSnapshot().getElementFirstRep()).contains("Coding")) {
                            ok.see(this.checkTerminologyCoding(errors, path, element, profile, theElementCntext, true, true, stack, logical));
                        }
                    } else if (!this.noBindingMsgSuppressed) {
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                    }
                    for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : binding.getAdditional()) {
                        StringBuilder b = new StringBuilder();
                        if (!this.isTestableBinding(ab) || !this.isInScope(ab, profile, this.getResource(stack), b)) continue;
                        String vsRef = ab.getValueSet();
                        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile);
                        Enumerations.BindingStrength strength = this.convertPurposeToStrength(ab.getPurpose());
                        this.validateBindingCodeableConcept(errors, path, element, profile, stack, ok, false, new BaseValidator.BooleanHolder(), cc, vsRef, valueset, strength, null, false, b.toString());
                    }
                }
            }
            catch (CheckCodeOnServerException e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept", e.getCause().getMessage());
            }
        }
        return ok.ok();
    }

    private boolean checkTerminologyCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack, StructureDefinition logical) {
        boolean ok = false;
        Coding c = this.convertToCoding(element, logical);
        String code = c.getCode();
        String system = c.getSystem();
        String display = c.getDisplay();
        String version = c.getVersion();
        boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, system == null || this.isCodeSystemReferenceValid(system), "Terminology_TX_System_Relative", new Object[0]) && ok;
        if (system != null && code != null && !this.noTerminologyChecks) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(system), "Terminology_TX_System_ValueSet2", system) && ok;
            try {
                if (this.checkCode(errors, element, path, code, system, version, display, checkDisplay, stack)) {
                    if (theElementCntext != null && theElementCntext.hasBinding()) {
                        ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                        if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) {
                            if (binding.hasValueSet()) {
                                String vsRef = binding.getValueSet();
                                ValueSet valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile);
                                Enumerations.BindingStrength strength = binding.getStrength();
                                Extension vsMax = binding.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
                                ok = this.validateBindingTerminologyCoding(errors, path, element, profile, stack, ok, c, code, system, display, vsRef, valueset, strength, vsMax, true, null);
                            } else if (binding.hasValueSet()) {
                                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_CantCheck");
                            } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                            }
                            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : binding.getAdditional()) {
                                Enumerations.BindingStrength strength;
                                ValueSet valueset;
                                StringBuilder b = new StringBuilder();
                                if (!this.isTestableBinding(ab) || !this.isInScope(ab, profile, this.getResource(stack), b)) continue;
                                String vsRef = ab.getValueSet();
                                ok = this.validateBindingTerminologyCoding(errors, path, element, profile, stack, ok, c, code, system, display, vsRef, valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile), strength = this.convertPurposeToStrength(ab.getPurpose()), null, true, b.toString()) && ok;
                            }
                        }
                    }
                } else {
                    ok = false;
                }
            }
            catch (Exception e) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                ok = false;
            }
        }
        return ok;
    }

    private boolean validateBindingTerminologyCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack, boolean ok, Coding c, String code, String system, String display, String vsRef, ValueSet valueset, Enumerations.BindingStrength strength, Extension vsMax, boolean base, String usageNote) {
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(vsRef);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(vsRef))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(vsRef));
            } else {
                ok = false;
            }
        } else {
            BindingContext bc = base ? BindingContext.BASE : BindingContext.ADDITIONAL;
            try {
                long t = System.nanoTime();
                ValidationResult vr = null;
                if (strength != Enumerations.BindingStrength.EXAMPLE) {
                    vr = this.checkCodeOnServer(stack, valueset, c);
                }
                if (strength == Enumerations.BindingStrength.REQUIRED) {
                    this.removeTrackedMessagesForLocation(errors, element, path);
                }
                ok = this.processTxIssues(errors, vr, element, path, false, vsRef, strength) && ok;
                this.timeTracker.tx(t, "vc " + system + "#" + code + " '" + display + "'");
                if (vr != null && !vr.isOk()) {
                    if (vr.IsNoService()) {
                        this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", system + "#" + code);
                    } else if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        if (strength == Enumerations.BindingStrength.REQUIRED) {
                            this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4a", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), vr.getMessage(), system + "#" + code);
                        } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                            if (vsMax != null) {
                                this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)vsMax), c, stack);
                            } else if (!this.noExtensibleWarnings) {
                                this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote));
                            }
                        } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                            this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote));
                        }
                    } else if (strength == Enumerations.BindingStrength.REQUIRED) {
                        ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_4", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code) && ok;
                    } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                        if (vsMax != null) {
                            ok = this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)vsMax), c, stack) && ok;
                        } else {
                            this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_5", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code);
                        }
                    } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                        this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_6", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), vr.getMessage() != null ? " (error message = " + vr.getMessage() + ")" : "", system + "#" + code);
                    }
                } else if (vr != null && vr.getMessage() != null) {
                    if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                        this.txHint(errors, "2023-07-04", vr.getTxLink(), ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), path, false, "TERMINOLOGY_TX_HINT", code, vr.getMessage());
                    } else {
                        this.txWarning(errors, "2023-07-04", vr.getTxLink(), ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), path, false, "TERMINOLOGY_TX_WARNING", code, vr.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
            }
        }
        return ok;
    }

    private Set<String> getUnknownSystems(ValidationResult vr) {
        if (vr == null) {
            return null;
        }
        if (vr.getUnknownSystems() != null && !vr.getUnknownSystems().isEmpty()) {
            return vr.getUnknownSystems();
        }
        if (vr.getSystem() != null) {
            HashSet<String> set = new HashSet<String>();
            set.add(vr.getSystem());
            return set;
        }
        return null;
    }

    private boolean convertCDACodeToCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical, CodeableConcept cc) {
        boolean ok = true;
        cc.setText(element.getNamedChildValue("originalText", false));
        if (element.hasChild("nullFlavor", false)) {
            cc.addExtension("http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor", (DataType)new CodeType(element.getNamedChildValue("nullFlavor", false)));
        }
        if (element.hasChild("code", false) || element.hasChild("codeSystem", false)) {
            Coding c = cc.addCoding();
            String oid = element.getNamedChildValue("codeSystem", false);
            if (oid != null) {
                c.setSystem("urn:oid:" + oid);
                IWorkerContext.OIDSummary urls = this.context.urlsForOid(oid, "CodeSystem");
                if (urls.urlCount() == 1) {
                    c.setSystem(urls.getUrl());
                } else if (urls.urlCount() == 0) {
                    this.warning(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_UNKNOWN_OID", oid);
                } else {
                    String prefUrl = urls.chooseBestUrl();
                    if (prefUrl == null) {
                        this.rule(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_OID_MULTIPLE_MATCHES", oid, urls.describe());
                        ok = false;
                    } else {
                        c.setSystem(prefUrl);
                        this.warning(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_OID_MULTIPLE_MATCHES_CHOSEN", oid, prefUrl, urls.describe());
                    }
                }
            } else {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_NO_CODE", new Object[0]);
            }
            c.setCode(element.getNamedChildValue("code", false));
            c.setVersion(element.getNamedChildValue("codeSystemVersion", false));
            c.setDisplay(element.getNamedChildValue("displayName", false));
        }
        return ok;
    }

    private Coding convertToCoding(org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition logical) {
        Coding res = new Coding();
        for (ElementDefinition ed : logical.getSnapshot().getElement()) {
            if (Utilities.charCount((String)ed.getPath(), (char)'.') != 1) continue;
            List<String> maps = this.getMapping("http://hl7.org/fhir/terminology-pattern", logical, ed);
            for (String m : maps) {
                String name = this.tail(ed.getPath());
                ArrayList list = new ArrayList();
                element.getNamedChildren(name, list);
                if (list.isEmpty()) continue;
                if ("Coding.code".equals(m)) {
                    res.setCode(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if ("Coding.system[fmt:OID]".equals(m)) {
                    String oid = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue();
                    String url = new ContextUtilities(this.context).oid2Uri(oid);
                    if (url != null) {
                        res.setSystem(url);
                        continue;
                    }
                    res.setSystem("urn:oid:" + oid);
                    continue;
                }
                if ("Coding.version".equals(m)) {
                    res.setVersion(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
                    continue;
                }
                if (!"Coding.display".equals(m)) continue;
                res.setDisplay(((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).primitiveValue());
            }
        }
        return res;
    }

    private boolean checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, CodeableConcept cc, NodeStack stack) {
        boolean ok = true;
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl(), (Resource)profile);
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(maxVSUrl);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(maxVSUrl))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl));
            } else {
                ok = false;
            }
        } else {
            try {
                long t = System.nanoTime();
                ValidationResult vr = this.checkCodeOnServer(stack, valueset, cc);
                ok = this.processTxIssues(errors, vr, element, path, false, maxVSUrl, null) && ok;
                this.timeTracker.tx(t, "vc " + cc.toString());
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_7", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.MAXVS, null), vr.getMessage());
                    } else {
                        ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_8", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.MAXVS, null), this.ccSummary(cc)) && ok;
                    }
                }
            }
            catch (CheckCodeOnServerException e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getCause().getMessage());
            }
        }
        return ok;
    }

    private boolean checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, Coding c, NodeStack stack) {
        boolean ok = true;
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl(), (Resource)profile);
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(maxVSUrl);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(maxVSUrl))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl));
            } else {
                ok = false;
            }
        } else {
            try {
                long t = System.nanoTime();
                ValidationResult vr = this.checkCodeOnServer(stack, valueset, c);
                ok = this.processTxIssues(errors, vr, element, path, false, maxVSUrl, null) && ok;
                this.timeTracker.tx(t, "vc " + c.getSystem() + "#" + c.getCode() + " '" + c.getDisplay() + "'");
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.MAXVS, null), vr.getMessage(), c.getSystem() + "#" + c.getCode());
                    } else {
                        ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_10", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.MAXVS, null), c.getSystem(), c.getCode()) && ok;
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
        return ok;
    }

    private boolean checkMaxValueSet(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, String maxVSUrl, String value, NodeStack stack) {
        boolean ok = true;
        ValueSet valueset = this.resolveBindingReference((DomainResource)profile, maxVSUrl, profile.getUrl(), (Resource)profile);
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(maxVSUrl);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(maxVSUrl))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(maxVSUrl));
            } else {
                ok = false;
            }
        } else {
            try {
                long t = System.nanoTime();
                ValidationResult vr = this.checkCodeOnServer(stack, valueset, value, this.baseOptions);
                ok = this.processTxIssues(errors, vr, element, path, false, maxVSUrl, null) && ok;
                this.timeTracker.tx(t, "vc " + value);
                if (!vr.isOk()) {
                    if (vr.getErrorClass() != null && vr.getErrorClass().isInfrastructure()) {
                        this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_9", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.BASE, null), vr.getMessage(), value);
                    } else {
                        ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_11", this.describeReference(maxVSUrl, (CanonicalResource)valueset, BindingContext.BASE, null), vr.getMessage()) && ok;
                    }
                }
            }
            catch (Exception e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_CodeableConcept_Max", e.getMessage());
            }
        }
        return ok;
    }

    private String ccSummary(CodeableConcept cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append(c.getSystem() + "#" + c.getCode());
        }
        return b.toString();
    }

    private boolean checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Coding fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system", false), (Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".version", focus.getNamedChild("version", false), (Element)fixed.getVersionElement(), fixedSource, "version", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code", false), (Element)fixed.getCodeElement(), fixedSource, "code", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display", false), (Element)fixed.getDisplayElement(), fixedSource, "display", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected", false), (Element)fixed.getUserSelectedElement(), fixedSource, "userSelected", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack) {
        if (!inCodeableConcept || theElementCntext.hasBinding()) {
            String code = element.getNamedChildValue("code", false);
            String system = element.getNamedChildValue("system", false);
            if (code != null && system == null) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_SYSTEM_NO_CODE", new Object[0]);
            }
            String version = element.getNamedChildValue("version", false);
            String display = element.getNamedChildValue("display", false);
            return this.checkCodedElement(errors, path, element, profile, theElementCntext, inCodeableConcept, checkDisplay, stack, code, system, version, display);
        }
        return true;
    }

    private boolean checkCodedElement(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept, boolean checkDisplay, NodeStack stack, String theCode, String theSystem, String theVersion, String theDisplay) {
        boolean ok = true;
        BaseValidator.BooleanHolder checked = new BaseValidator.BooleanHolder(false);
        if (theSystem != null && theCode != null && !this.noTerminologyChecks) {
            block11: {
                try {
                    if (theElementCntext == null || !theElementCntext.hasBinding()) break block11;
                    ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
                    if (!this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Terminology_TX_Binding_Missing2", path)) break block11;
                    try {
                        Coding c = ObjectConverter.readAsCoding((org.hl7.fhir.r5.elementmodel.Element)element);
                        if (binding.hasValueSet()) {
                            String vsRef = binding.getValueSet();
                            ValueSet valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile);
                            Enumerations.BindingStrength strength = binding.getStrength();
                            Extension vsMax = binding.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
                            ok = this.validateBindingCodedElement(errors, path, element, profile, stack, theCode, theSystem, ok, checked, c, vsRef, valueset, strength, vsMax, true, null);
                        } else if (!inCodeableConcept && !this.noBindingMsgSuppressed) {
                            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoSource", path);
                        }
                        for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : binding.getAdditional()) {
                            Enumerations.BindingStrength strength;
                            ValueSet valueset;
                            StringBuilder b = new StringBuilder();
                            if (!this.isTestableBinding(ab) || !this.isInScope(ab, profile, this.getResource(stack), b)) continue;
                            String vsRef = ab.getValueSet();
                            ok = this.validateBindingCodedElement(errors, path, element, profile, stack, theCode, theSystem, ok, checked, c, vsRef, valueset = this.resolveBindingReference((DomainResource)profile, vsRef, profile.getUrl(), (Resource)profile), strength = this.convertPurposeToStrength(ab.getPurpose()), null, false, b.toString()) && ok;
                        }
                    }
                    catch (Exception e) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding1", e.getMessage());
                    }
                }
                catch (Exception e) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Error_Coding2", e.getMessage(), e.toString());
                    ok = false;
                }
            }
            if (!checked.ok()) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, theSystem == null || this.isCodeSystemReferenceValid(theSystem), "Terminology_TX_System_Relative", new Object[0]) && ok;
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !this.isValueSet(theSystem), "Terminology_TX_System_ValueSet2", theSystem) && ok;
                if (ok) {
                    ok = this.checkCode(errors, element, path, theCode, theSystem, theVersion, theDisplay, checkDisplay, stack);
                }
            }
        }
        return ok;
    }

    private org.hl7.fhir.r5.elementmodel.Element getResource(NodeStack stack) {
        if (stack.getElement().isResource()) {
            return stack.getElement();
        }
        if (stack.getParent() == null) {
            return null;
        }
        return this.getResource(stack.getParent());
    }

    private boolean validateBindingCodedElement(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack, String theCode, String theSystem, boolean ok, BaseValidator.BooleanHolder checked, Coding c, String vsRef, ValueSet valueset, Enumerations.BindingStrength strength, Extension vsMax, boolean base, String usageNote) {
        if (valueset == null) {
            CodeSystem cs = this.context.fetchCodeSystem(vsRef);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(vsRef))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(vsRef));
            } else {
                ok = false;
            }
        } else {
            BindingContext bc = base ? BindingContext.BASE : BindingContext.ADDITIONAL;
            long t = System.nanoTime();
            ValidationResult vr = null;
            if (strength != Enumerations.BindingStrength.EXAMPLE) {
                checked.set(true);
                vr = this.checkCodeOnServer(stack, valueset, c);
            }
            ok = this.processTxIssues(errors, vr, element, path, strength == Enumerations.BindingStrength.EXTENSIBLE, vsRef, strength) && ok;
            this.timeTracker.tx(t, "vc " + c.getSystem() + "#" + c.getCode() + " '" + c.getDisplay() + "'");
            if (strength == Enumerations.BindingStrength.REQUIRED) {
                this.removeTrackedMessagesForLocation(errors, element, path);
            }
            if (vr != null && !vr.isOk()) {
                if (vr.IsNoService()) {
                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Binding_NoServer", theSystem + "#" + theCode);
                } else if (vr.getErrorClass() != null && !vr.getErrorClass().isInfrastructure()) {
                    if (strength == Enumerations.BindingStrength.REQUIRED) {
                        ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_4a", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), vr.getMessage(), theSystem + "#" + theCode) && ok;
                    } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                        if (vsMax != null) {
                            this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)vsMax), c, stack);
                        } else if (!this.noExtensibleWarnings) {
                            this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_5", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), theSystem + "#" + theCode);
                        }
                    } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                        this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_Confirm_6", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), theSystem + "#" + theCode);
                    }
                } else if (strength == Enumerations.BindingStrength.REQUIRED) {
                    ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_12", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.getErrorMessage(vr.getMessage()), theSystem + "#" + theCode) && ok;
                } else if (strength == Enumerations.BindingStrength.EXTENSIBLE) {
                    if (vsMax != null) {
                        ok = this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringFromExtension((Extension)vsMax), c, stack) && ok;
                    } else if (!this.noExtensibleWarnings) {
                        this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_13", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.getErrorMessage(vr.getMessage()), c.getSystem() + "#" + c.getCode());
                    }
                } else if (strength == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_14", this.describeReference(vsRef, (CanonicalResource)valueset, bc, usageNote), this.getErrorMessage(vr.getMessage()), theSystem + "#" + theCode);
                }
            } else if (vr != null && vr.getMessage() != null) {
                if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                    this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                } else {
                    this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                }
            }
        }
        return ok;
    }

    private boolean isValueSet(String url) {
        try {
            ValueSet vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, url);
            return vs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkContactPoint(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, ContactPoint fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system", false), (Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value", false), (Element)fixed.getValueElement(), fixedSource, "value", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use", false), (Element)fixed.getUseElement(), fixedSource, "use", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period", false), (Element)fixed.getPeriod(), fixedSource, "period", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkExtension(ValidationContext valContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition def, StructureDefinition profile, NodeStack stack, NodeStack containerStack, String extensionUrl, PercentageTracker pct, Base.ValidationMode mode) throws FHIRException {
        StructureDefinition ex;
        boolean ok = true;
        String url = element.getNamedChildValue("url", false);
        String u = url.contains("|") ? url.substring(0, url.indexOf("|")) : url;
        boolean isModifier = element.getName().equals("modifierExtension");
        assert (def.getIsModifier() == isModifier);
        long t = System.nanoTime();
        StructureDefinition structureDefinition = ex = Utilities.isAbsoluteUrl((String)u) ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, u) : null;
        if (ex == null) {
            ex = this.getXverExt(errors, path, element, url);
        }
        if (url.contains("|")) {
            if (ex == null) {
                StructureDefinition structureDefinition2 = ex = Utilities.isAbsoluteUrl((String)url) ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url) : null;
                if (ex == null) {
                    this.warning(errors, "2022-12-17", ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "EXT_VER_URL_NO_MATCH", new Object[0]);
                } else {
                    ok = this.rule(errors, "2022-12-17", ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "EXT_VER_URL_IGNORE", new Object[0]) && ok;
                }
            } else if (url.equals(ex.getUrl())) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "EXT_VER_URL_MISLEADING", new Object[0]);
            } else {
                ok = url.equals(ex.getVersionedUrl()) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "EXT_VER_URL_NOT_ALLOWED", new Object[0]) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "EXT_VER_URL_REVERSION", ex.getVersion()) && ok;
            }
        }
        this.timeTracker.sd(t);
        if (ex == null) {
            if (extensionUrl != null && !this.isAbsolute(url)) {
                if (extensionUrl.equals(profile.getUrl())) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", this.hasExtensionSlice(profile, url), "Extension_EXT_SubExtension_Invalid", url, profile.getVersionedUrl()) && ok;
                }
            } else if (SpecialExtensions.isKnownExtension(url)) {
                ex = SpecialExtensions.getDefinition(url);
            } else if (!BuildExtensions.allConsts().contains(url)) {
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "Extension_EXT_Unknown_NotHere", url)) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.isKnownExtension(url), "Extension_EXT_Unknown", url);
                } else {
                    ok = false;
                }
            }
        }
        if (ex != null) {
            this.trackUsage(ex, valContext, element);
            ok = isModifier ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", def.getIsModifier() == isModifier, "Extension_EXT_Modifier_MismatchY", new Object[0]) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", def.getIsModifier() == isModifier, "Extension_EXT_Modifier_MismatchN", new Object[0]) && ok;
            ok = this.checkExtensionContext(valContext.getAppContext(), errors, resource, container, ex, containerStack, valContext, isModifier) && ok;
            boolean bl = ok = this.checkDefinitionStatus(errors, element, path, ex, (CanonicalResource)profile, this.context.formatMessage("MSG_DEPENDS_ON_EXTENSION", new Object[0])) && ok;
            ok = isModifier ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_Y", url) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !((ElementDefinition)ex.getSnapshot().getElement().get(0)).getIsModifier(), "Extension_EXT_Modifier_N", url) && ok;
            Set<String> allowedTypes = this.listExtensionTypes(ex);
            String actualType = this.getExtensionType(element);
            ok = actualType != null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.contains(actualType), "Extension_EXT_Type", url, allowedTypes.toString(), actualType) && ok : (element.hasChildren("extension") ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.isEmpty(), "Extension_EXT_Simple_WRONG", url) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, allowedTypes.isEmpty(), "Extension_EXT_Simple_ABSENT", url) && ok);
            ok = this.validateElement(valContext, errors, ex, (ElementDefinition)ex.getSnapshot().getElement().get(0), null, null, resource, element, "Extension", stack, false, true, url, pct, mode) && ok;
        }
        return ok;
    }

    private boolean hasExtensionSlice(StructureDefinition profile, String sliceName) {
        for (ElementDefinition ed : profile.getSnapshot().getElement()) {
            if (!ed.getPath().equals("Extension.extension.url") || !ed.hasFixed() || !sliceName.equals(ed.getFixed().primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private String getExtensionType(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element e : element.getChildren()) {
            if (!e.getName().startsWith("value")) continue;
            String tn = e.getName().substring(5);
            String ltn = Utilities.uncapitalize((String)tn);
            if (this.isPrimitiveType(ltn)) {
                return ltn;
            }
            return tn;
        }
        return null;
    }

    private Set<String> listExtensionTypes(StructureDefinition ex) {
        ElementDefinition vd = null;
        for (ElementDefinition ed : ex.getSnapshot().getElement()) {
            if (!ed.getPath().startsWith("Extension.value")) continue;
            vd = ed;
            break;
        }
        HashSet<String> res = new HashSet<String>();
        if (vd != null && !"0".equals(vd.getMax())) {
            for (ElementDefinition.TypeRefComponent tr : vd.getType()) {
                res.add(tr.getWorkingCode());
            }
        }
        if (ex.getUrl().equals("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) {
            res.add("uri");
            res.add("url");
        }
        return res;
    }

    private boolean checkExtensionContext(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, StructureDefinition definition, NodeStack stack, ValidationContext valContext, boolean modifier) {
        String extUrl = definition.getUrl();
        boolean ok = false;
        CommaSeparatedStringBuilder contexts = new CommaSeparatedStringBuilder();
        ArrayList<String> plist = new ArrayList<String>();
        plist.add(this.stripIndexes(stack.getLiteralPath()));
        for (String s : stack.getLogicalPaths()) {
            String p = this.stripIndexes(s);
            if (EXTENSION_CONTEXT_LIST.contains(p)) {
                return true;
            }
            plist.add(p);
        }
        Collections.sort(plist);
        block1: for (StructureDefinition.StructureDefinitionContextComponent ctxt : this.fixContexts(extUrl, definition.getContext())) {
            if (ok) break;
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.ELEMENT) {
                String en = ctxt.getExpression();
                contexts.append("e:" + en);
                String pu = null;
                if (en.contains("#")) {
                    pu = en.substring(0, en.indexOf("#"));
                    en = en.substring(en.indexOf("#") + 1);
                }
                if (Utilities.existsInList((String)en, (String[])new String[]{"Element", "Any"})) {
                    ok = true;
                } else if (en.equals("Resource") && container.isResource()) {
                    ok = true;
                } else if (en.equals("CanonicalResource") && this.containsAny(VersionUtilities.getExtendedCanonicalResourceNames((String)this.context.getVersion()), plist)) {
                    ok = true;
                } else if (this.hasElementName(plist, en) && pu == null) {
                    ok = true;
                }
                if (ok || !this.checkConformsToProfile(appContext, errors, resource, container, stack, extUrl, ctxt.getExpression(), pu)) continue;
                block2: for (String p : plist) {
                    if (ok) continue block1;
                    if (p.equals(en)) {
                        ok = true;
                        continue;
                    }
                    String pn = p;
                    String pt = "";
                    if (p.contains(".")) {
                        pn = p.substring(0, p.indexOf("."));
                        pt = p.substring(p.indexOf("."));
                    }
                    StructureDefinition sd = this.context.fetchTypeDefinition(pn);
                    while (sd != null) {
                        if ((sd.getType() + pt).equals(en)) {
                            ok = true;
                            continue block2;
                        }
                        if (sd.getBaseDefinition() != null) {
                            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), (Resource)sd);
                            continue;
                        }
                        sd = null;
                    }
                }
                continue;
            }
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.EXTENSION) {
                contexts.append("x:" + ctxt.getExpression());
                String ext = null;
                if (stack.getElement().getName().startsWith("value")) {
                    NodeStack estack = stack.getParent();
                    if (estack != null && estack.getElement().fhirType().equals("Extension")) {
                        ext = estack.getElement().getNamedChildValue("url", false);
                    }
                } else {
                    ext = stack.getElement().getNamedChildValue("url", false);
                }
                if (ctxt.getExpression().equals(ext)) {
                    ok = true;
                    continue;
                }
                if (ext == null) continue;
                plist.add(ext);
                continue;
            }
            if (ctxt.getType() == StructureDefinition.ExtensionContextType.FHIRPATH) {
                contexts.append("p:" + ctxt.getExpression());
                List res = this.fpe.evaluate((Object)valContext, (Base)resource, (Base)valContext.getRootResource(), (Base)resource, this.fpe.parse(ctxt.getExpression()));
                if (!res.contains(container)) continue;
                ok = true;
                continue;
            }
            throw new Error(this.context.formatMessage("Unrecognised_extension_context_", new Object[]{ctxt.getTypeElement().asStringValue()}));
        }
        if (!ok) {
            if (definition.hasUserData("XVER_EXT_MARKER")) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, modifier ? "EXTENSION_EXTM_CONTEXT_WRONG_XVER" : "EXTENSION_EXTP_CONTEXT_WRONG_XVER", extUrl, contexts.toString(), ((Object)plist).toString(), definition.getUserString("XVER_VER_MARKER"));
            } else {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, modifier ? "Extension_EXTM_Context_Wrong" : "Extension_EXTP_Context_Wrong", extUrl, contexts.toString(), ((Object)plist).toString(), definition.getUserString("XVER_VER_MARKER"));
            }
            return false;
        }
        if (definition.hasContextInvariant()) {
            for (String s : definition.getContextInvariant()) {
                if (this.fpe.evaluateToBoolean((Object)valContext, (Base)resource, (Base)valContext.getRootResource(), (Base)container, this.fpe.parse((String)s.getValue()))) continue;
                if (definition.hasUserData("XVER_EXT_MARKER")) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Profile_EXT_Not_Here", extUrl, s.getValue());
                    return true;
                }
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, container.line(), container.col(), stack.getLiteralPath(), false, "Profile_EXT_Not_Here", extUrl, s.getValue());
                return false;
            }
        }
        return true;
    }

    private boolean containsAny(Set<String> set, List<String> list) {
        for (String p : list) {
            if (!set.contains(p)) continue;
            return true;
        }
        return false;
    }

    private boolean hasElementName(List<String> plist, String en) {
        String[] ep = en.split("\\.");
        for (String s : plist) {
            int ei;
            if (s.equals(en)) {
                return true;
            }
            String[] sp = s.split("\\.");
            int si = 0;
            boolean mismatch = false;
            for (ei = 0; si < sp.length && ei < ep.length; ++si, ++ei) {
                String ps = sp[si];
                String pe = ep[ei];
                if (ps.equals(pe)) continue;
                if (pe.endsWith("[x]")) {
                    if (ps.equals(pe.substring(0, pe.length() - 3)) && si < sp.length - 1 && sp[si + 1].startsWith("ofType(")) {
                        ++si;
                        continue;
                    }
                    mismatch = true;
                    continue;
                }
                mismatch = true;
            }
            if (mismatch || si != sp.length || ei != ep.length) continue;
            return true;
        }
        return false;
    }

    private boolean checkConformsToProfile(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element container, NodeStack stack, String extUrl, String expression, String pu) {
        if (pu == null) {
            return true;
        }
        if (pu.equals("http://hl7.org/fhir/StructureDefinition/" + resource.fhirType())) {
            return true;
        }
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, pu);
        if (!this.rule(errors, "2023-07-03", ValidationMessage.IssueType.UNKNOWN, container.line(), container.col(), stack.getLiteralPath(), sd != null, "EXTENSION_CONTEXT_UNABLE_TO_FIND_PROFILE", extUrl, expression)) {
            return false;
        }
        if (sd.getType().equals(resource.fhirType())) {
            ArrayList<ValidationMessage> valerrors = new ArrayList<ValidationMessage>();
            Base.ValidationMode mode = new Base.ValidationMode(Base.ValidationReason.Expression, Base.ProfileSource.FromExpression);
            this.validateResource(new ValidationContext(appContext, resource), valerrors, resource, resource, sd, IdStatus.OPTIONAL, new NodeStack(this.context, null, resource, this.validationLanguage), null, mode, false, false);
            boolean ok = true;
            ArrayList<ValidationMessage> record = new ArrayList<ValidationMessage>();
            for (ValidationMessage v : valerrors) {
                boolean bl = ok = ok && !v.getLevel().isError();
                if (!v.getLevel().isError() && !v.isSlicingHint()) continue;
                record.add(v);
            }
            return ok;
        }
        this.warning(errors, "2023-07-03", ValidationMessage.IssueType.UNKNOWN, container.line(), container.col(), stack.getLiteralPath(), false, "EXTENSION_CONTEXT_UNABLE_TO_CHECK_PROFILE", extUrl, expression, pu);
        return true;
    }

    private List<StructureDefinition.StructureDefinitionContextComponent> fixContexts(String extUrl, List<StructureDefinition.StructureDefinitionContextComponent> list) {
        ArrayList<StructureDefinition.StructureDefinitionContextComponent> res = new ArrayList<StructureDefinition.StructureDefinitionContextComponent>();
        for (StructureDefinition.StructureDefinitionContextComponent ctxt : list) {
            res.add(ctxt.copy());
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type".equals(extUrl)) {
            list.get(0).setExpression("ElementDefinition.type");
        }
        if ("http://hl7.org/fhir/StructureDefinition/regex".equals(extUrl)) {
            StructureDefinition.StructureDefinitionContextComponent e = new StructureDefinition.StructureDefinitionContextComponent();
            e.setExpression("ElementDefinition.type");
            e.setType(StructureDefinition.ExtensionContextType.ELEMENT);
            list.add(e);
        }
        if ("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version".equals(extUrl)) {
            list.get(0).setExpression("Element");
        }
        if (!VersionUtilities.isThisOrLater((String)"4.6", (String)this.context.getVersion()) && Utilities.existsInList((String)extUrl, (String[])new String[]{"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited"})) {
            list.get(0).setExpression("Element");
        }
        return list;
    }

    private String stripIndexes(String path) {
        boolean skip = false;
        StringBuilder b = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (skip) {
                if (c != ']') continue;
                skip = false;
                continue;
            }
            if (c == '[') {
                skip = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public boolean checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Element fixed, String fixedSource, String propName, org.hl7.fhir.r5.elementmodel.Element parent, boolean pattern, String context) {
        boolean ok = true;
        if (fixed != null && !fixed.isEmpty() || focus != null) {
            if ((fixed == null || fixed.isEmpty()) && focus != null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, pattern, "Profile_VAL_NotAllowed", focus.getName(), pattern ? "pattern" : "fixed value");
            } else if (fixed != null && !fixed.isEmpty() && focus == null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, parent == null ? -1 : parent.line(), parent == null ? -1 : parent.col(), path, false, "Profile_VAL_MissingElement", propName, fixedSource);
            } else {
                String value = focus.primitiveValue();
                ok = fixed instanceof BooleanType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((BooleanType)fixed).asStringValue(), context) : (fixed instanceof IntegerType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((IntegerType)fixed).asStringValue(), context) : (fixed instanceof DecimalType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((DecimalType)fixed).asStringValue(), context) : (fixed instanceof Base64BinaryType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Base64BinaryType)fixed).asStringValue(), context) : (fixed instanceof InstantType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((InstantType)fixed).asStringValue(), context) : (fixed instanceof CodeType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((CodeType)fixed).getValue(), context) : (fixed instanceof Enumeration ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Enumeration)fixed).asStringValue(), value), "_DT_Fixed_Wrong", value, ((Enumeration)fixed).asStringValue(), context) : (fixed instanceof StringType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((StringType)fixed).getValue(), context) : (fixed instanceof UriType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UriType)fixed).getValue(), context) : (fixed instanceof DateType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateType)fixed).getValue(), context) : (fixed instanceof DateTimeType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "_DT_Fixed_Wrong", value, ((DateTimeType)fixed).getValue(), context) : (fixed instanceof OidType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((OidType)fixed).getValue(), context) : (fixed instanceof UuidType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((UuidType)fixed).getValue(), context) : (fixed instanceof IdType ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "_DT_Fixed_Wrong", value, ((IdType)fixed).getValue(), context) : (fixed instanceof Quantity ? this.checkQuantity(errors, path, focus, (Quantity)fixed, fixedSource, pattern, context) && ok : (fixed instanceof Address ? this.checkAddress(errors, path, focus, (Address)fixed, fixedSource, pattern, context) : (fixed instanceof ContactPoint ? this.checkContactPoint(errors, path, focus, (ContactPoint)fixed, fixedSource, pattern, context) : (fixed instanceof Attachment ? this.checkAttachment(errors, path, focus, (Attachment)fixed, fixedSource, pattern, context) : (fixed instanceof Identifier ? this.checkIdentifier(errors, path, focus, (Identifier)fixed, fixedSource, pattern, context) : (fixed instanceof Coding ? this.checkCoding(errors, path, focus, (Coding)fixed, fixedSource, pattern, context) : (fixed instanceof HumanName ? this.checkHumanName(errors, path, focus, (HumanName)fixed, fixedSource, pattern, context) : (fixed instanceof CodeableConcept ? this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed, fixedSource, pattern, context) : (fixed instanceof Timing ? this.checkTiming(errors, path, focus, (Timing)fixed, fixedSource, pattern, context) : (fixed instanceof Period ? this.checkPeriod(errors, path, focus, (Period)fixed, fixedSource, pattern, context) : (fixed instanceof Range ? this.checkRange(errors, path, focus, (Range)fixed, fixedSource, pattern, context) : (fixed instanceof Ratio ? this.checkRatio(errors, path, focus, (Ratio)fixed, fixedSource, pattern, context) : (fixed instanceof SampledData ? this.checkSampledData(errors, path, focus, (SampledData)fixed, fixedSource, pattern, context) : (fixed instanceof Reference ? this.checkReference(errors, path, focus, (Reference)fixed, fixedSource, pattern, context) : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Internal_INT_Bad_Type", fixed.fhirType()))))))))))))))))))))))))))));
                ArrayList<org.hl7.fhir.r5.elementmodel.Element> extensions = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0 || pattern, "Extension_EXT_Fixed_Banned", new Object[0]) && ok;
                } else if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extension_EXT_Count_Mismatch", Integer.toString(fixed.getExtension().size()), Integer.toString(extensions.size()))) {
                    for (Extension e : fixed.getExtension()) {
                        org.hl7.fhir.r5.elementmodel.Element ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension_EXT_Count_NotFound", e.getUrl())) {
                            ok = this.checkFixedValue(errors, path, ex.getNamedChild("extension", false).getNamedChild("value", false), (Element)e.getValue(), fixedSource, "extension.value", ex.getNamedChild("extension", false), false, context) && ok;
                            continue;
                        }
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            }
        }
        return ok;
    }

    private boolean checkHumanName(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, HumanName fixed, String fixedSource, boolean pattern, String context) {
        int i;
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use", false), (Element)fixed.getUseElement(), fixedSource, "use", focus, pattern, context);
        ok = this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text", false), (Element)fixed.getTextElement(), fixedSource, "text", focus, pattern, context);
        ok = this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period", false), (Element)fixed.getPeriod(), fixedSource, "period", focus, pattern, context);
        ArrayList parts = new ArrayList();
        if (!pattern || fixed.hasFamily()) {
            focus.getNamedChildren("family", parts);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() > 0 == fixed.hasFamily(), "Fixed_Type_Checks_DT_Name_Family", fixed.hasFamily() ? "1" : "0", Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    ok = this.checkFixedValue(errors, path + ".family", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (Element)fixed.getFamilyElement(), fixedSource, "family", focus, pattern, context) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (!pattern || fixed.hasGiven()) {
            focus.getNamedChildren("given", parts);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Fixed_Type_Checks_DT_Name_Given", Integer.toString(fixed.getGiven().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    ok = this.checkFixedValue(errors, path + ".given", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (Element)fixed.getGiven().get(i), fixedSource, "given", focus, pattern, context) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (!pattern || fixed.hasPrefix()) {
            focus.getNamedChildren("prefix", parts);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Fixed_Type_Checks_DT_Name_Prefix", Integer.toString(fixed.getPrefix().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    ok = this.checkFixedValue(errors, path + ".prefix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (Element)fixed.getPrefix().get(i), fixedSource, "prefix", focus, pattern, context) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (!pattern || fixed.hasSuffix()) {
            focus.getNamedChildren("suffix", parts);
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Fixed_Type_Checks_DT_Name_Suffix", Integer.toString(fixed.getSuffix().size()), Integer.toString(parts.size()))) {
                for (i = 0; i < parts.size(); ++i) {
                    ok = this.checkFixedValue(errors, path + ".suffix", (org.hl7.fhir.r5.elementmodel.Element)parts.get(i), (Element)fixed.getSuffix().get(i), fixedSource, "suffix", focus, pattern, context) && ok;
                }
            } else {
                ok = false;
            }
        }
        return ok;
    }

    private boolean checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition context) {
        boolean ok = true;
        String system = element.getNamedChildValue("system", false);
        boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, system == null || this.isIdentifierSystemReferenceValid(system), "Type_Specific_Checks_DT_Identifier_System", new Object[0]) && ok;
        if ("urn:ietf:rfc:3986".equals(system)) {
            String value = element.getNamedChildValue("value", false);
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, value == null || this.isAbsolute(value), "TYPE_SPECIFIC_CHECKS_DT_IDENTIFIER_IETF_SYSTEM_VALUE", value) && ok;
        }
        return ok;
    }

    private boolean checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Identifier fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use", false), (Element)fixed.getUseElement(), fixedSource, "use", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type", false), (Element)fixed.getType(), fixedSource, "type", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system", false), (Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value", false), (Element)fixed.getValueElement(), fixedSource, "value", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period", false), (Element)fixed.getPeriod(), fixedSource, "period", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner", false), (Element)fixed.getAssigner(), fixedSource, "assigner", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkPeriod(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Period fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start", false), (Element)fixed.getStartElement(), fixedSource, "start", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end", false), (Element)fixed.getEndElement(), fixedSource, "end", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkPrimitive(ValidationContext valContext, List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element e, StructureDefinition profile, NodeStack node, NodeStack parentNode, org.hl7.fhir.r5.elementmodel.Element resource) throws FHIRException {
        String regext;
        XhtmlNode xhtml;
        String processed;
        String raw;
        String encoded;
        DateType dt;
        boolean ok = true;
        for (org.hl7.fhir.r5.elementmodel.Element child : e.getChildren()) {
            ok = this.rule(errors, "2024-02-28", ValidationMessage.IssueType.INVALID, child.line(), child.col(), path, !"value".equals(child.getName()), "ILLEGAL_PROPERTY", "value") && ok;
        }
        if (StringUtils.isBlank((CharSequence)e.primitiveValue())) {
            if (e.primitiveValue() == null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_ValueExt", new Object[0]) && ok;
            } else if (e.primitiveValue().length() == 0) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0]) && ok;
            } else if (Utilities.isAllWhitespace((String)e.primitiveValue())) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.hasChildren(), "Type_Specific_Checks_DT_Primitive_WS", new Object[0]);
            }
            if (context.hasBinding()) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, e.line(), e.col(), path, context.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED, "Terminology_TX_Code_ValueSet_MISSING", new Object[0]) && ok;
            }
            boolean bl = ok = this.rule(errors, "2023-06-18", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.getMustHaveValue(), "PRIMITIVE_MUSTHAVEVALUE_MESSAGE", context.getId(), profile.getVersionedUrl()) && ok;
            if (context.hasValueAlternatives()) {
                boolean found = false;
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                for (CanonicalType ct : context.getValueAlternatives()) {
                    found = found || e.hasExtension((String)ct.getValue());
                    b.append((String)ct.getValue());
                }
                ok = this.rulePlural(errors, "2023-06-18", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, found, context.getValueAlternatives().size(), "PRIMITIVE_VALUE_ALTERNATIVES_MESSAGE", context.getId(), profile.getVersionedUrl(), b.toString()) && ok;
            }
            return ok;
        }
        boolean hasBiDiControls = UnicodeUtilities.hasBiDiChars((String)e.primitiveValue());
        if (hasBiDiControls) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, e.line(), e.col(), path, !this.noUnicodeBiDiControlChars, "UNICODE_BIDI_CONTROLS_CHARS_DISALLOWED", UnicodeUtilities.replaceBiDiChars((String)e.primitiveValue()))) {
                String msg = UnicodeUtilities.checkUnicodeWellFormed((String)e.primitiveValue());
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "UNICODE_BIDI_CONTROLS_CHARS_MATCH", msg);
            } else {
                ok = false;
            }
        }
        HashSet<String> badChars = new HashSet<String>();
        for (char ch : e.primitiveValue().toCharArray()) {
            if (ch >= ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
            badChars.add(Integer.toHexString(ch));
        }
        this.warningPlural(errors, "2023-07-26", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, badChars.isEmpty(), badChars.size(), "UNICODE_XML_BAD_CHARS", ((Object)badChars).toString());
        String regex = context.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
        if (regex != null) {
            for (ElementDefinition.TypeRefComponent tr : context.getType()) {
                if (!tr.hasExtension("http://hl7.org/fhir/StructureDefinition/regex")) continue;
                regex = tr.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
                break;
            }
        }
        if (regex != null) {
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches(regex), "Type_Specific_Checks_DT_Primitive_Regex", e.primitiveValue(), regex) && ok;
        }
        if (!"xhtml".equals(type)) {
            if (this.securityChecks) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.containsHtmlTags(e.primitiveValue()), "SECURITY_STRING_CONTENT_ERROR", new Object[0]) && ok;
            } else if (!"markdown".equals(type)) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.containsHtmlTags(e.primitiveValue()), "SECURITY_STRING_CONTENT_WARNING");
            }
        }
        if (type.equals("boolean")) {
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "true".equals(e.primitiveValue()) || "false".equals(e.primitiveValue()), "Type_Specific_Checks_DT_Boolean_Value", new Object[0]) && ok;
        }
        if (type.equals("uri") || type.equals("oid") || type.equals("uuid") || type.equals("url") || type.equals("canonical")) {
            String url = e.primitiveValue();
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !url.startsWith("oid:"), "Type_Specific_Checks_DT_URI_OID", new Object[0]) && ok;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !url.startsWith("uuid:"), "Type_Specific_Checks_DT_URI_UUID", new Object[0]) && ok;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.equals(Utilities.trimWS((String)url).replace(" ", "")) || "http://www.acme.com/identifiers/patient or urn:ietf:rfc:3986 if the Identifier.value itself is a full uri".equals(url), "Type_Specific_Checks_DT_URI_WS", url) && ok;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || url.length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && ok;
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && ok;
            if (type.equals("oid")) {
                boolean bl2 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("urn:oid:"), "Type_Specific_Checks_DT_OID_Start", new Object[0]) && ok;
            }
            if (type.equals("uuid")) {
                boolean bl3 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("urn:uuid:"), "Type_Specific_Checks_DT_UUID_Strat", new Object[0]) && ok;
            }
            if (type.equals("canonical")) {
                boolean bl4 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, url.startsWith("#") || Utilities.isAbsoluteUrl((String)url), "TYPE_SPECIFIC_CHECKS_CANONICAL_ABSOLUTE", url) && ok;
            }
            if (url != null && url.startsWith("urn:uuid:")) {
                String s = url.substring(9);
                if (s.contains("#")) {
                    s = s.substring(0, s.indexOf("#"));
                }
                boolean bl5 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isValidUUID((String)s), "Type_Specific_Checks_DT_UUID_Valid", s) && ok;
            }
            if (url != null && url.startsWith("urn:oid:")) {
                String cc = url.substring(8);
                boolean bl6 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isOid((String)cc) && (cc.lastIndexOf(46) >= 4 || cc.startsWith("1.3")), "Type_Specific_Checks_DT_OID_Valid", cc) && ok;
            }
            if (this.isCanonicalURLElement(e, node)) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isAbsoluteUrl((String)url), node.isContained() ? "TYPE_SPECIFIC_CHECKS_CANONICAL_CONTAINED" : "TYPE_SPECIFIC_CHECKS_CANONICAL_ABSOLUTE", url) && ok;
            } else if (!e.getProperty().getDefinition().getPath().equals("Bundle.entry.fullUrl")) {
                boolean bl7 = ok = this.validateReference(valContext, errors, path, type, context, e, url) && ok;
            }
        }
        if (type.equals("id") && !"Resource.id".equals(context.getBase().getPath()) && !context.getPath().equals("ElementDefinition.id")) {
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, FormatUtilities.isValidId((String)e.primitiveValue()), "Type_Specific_Checks_DT_ID_Valid", e.primitiveValue()) && ok;
        }
        if (type.equalsIgnoreCase("string") && e.hasPrimitiveValue()) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().length() > 0, "Type_Specific_Checks_DT_Primitive_NotEmpty", new Object[0])) {
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || !Utilities.isAllWhitespace((String)e.primitiveValue()), "Type_Specific_Checks_DT_String_WS_ALL", this.prepWSPresentation(e.primitiveValue()))) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || Utilities.trimWS((String)e.primitiveValue()).equals(e.primitiveValue()), "Type_Specific_Checks_DT_String_WS", this.prepWSPresentation(e.primitiveValue()));
                }
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().length() <= 0x100000, "Type_Specific_Checks_DT_String_Length", new Object[0]) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && ok : false;
            } else {
                ok = false;
            }
        }
        if (type.equals("dateTime")) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "Type_Specific_Checks_DT_DateTime_Valid", "'" + e.primitiveValue() + "' doesn't meet format requirements for dateTime") && ok;
            boolean dok = ok;
            if (this.isCoreDefinition(profile) || context.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules") && ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules").contains("tz-for-time")) {
                dok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.primitiveValue()) || this.hasTimeZone(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_TZ", new Object[0]) && dok;
            }
            boolean bl = dok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && dok;
            if (dok) {
                try {
                    dt = new DateTimeType(e.primitiveValue());
                    if (this.isCoreDefinition(profile) || !context.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules") || ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules").contains("year-valid")) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
                    }
                }
                catch (Exception ex) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_DateTime_Valid", ex.getMessage());
                    dok = false;
                }
            }
            boolean bl8 = ok = ok && dok;
        }
        if (type.equals("time")) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)"), "Type_Specific_Checks_DT_Time_Valid", new Object[0]) && ok;
            try {
                TimeType dok = new TimeType(e.primitiveValue());
            }
            catch (Exception ex) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Time_Valid", ex.getMessage());
                ok = false;
            }
        }
        if (type.equals("date")) {
            boolean dok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1]))?)?"), "Type_Specific_Checks_DT_Date_Valid", "'" + e.primitiveValue() + "' doesn't meet format requirements for date");
            boolean bl = dok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && dok;
            if (dok) {
                try {
                    dt = new DateType(e.primitiveValue());
                    if (this.isCoreDefinition(profile) || context.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules") && ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules").contains("year-valid")) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
                    }
                }
                catch (Exception ex) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Date_Valid", ex.getMessage());
                    dok = false;
                }
            }
            boolean bl9 = ok = ok && dok;
        }
        if (type.equals("base64Binary") && StringUtils.isNotBlank((CharSequence)(encoded = e.primitiveValue()))) {
            boolean bok = Base64Util.isValidBase64(encoded);
            if (!bok) {
                String value = encoded.length() < 100 ? encoded : "(snip)";
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Base64_Valid", value) && ok;
            } else {
                boolean wsok;
                boolean bl = wsok = !Base64Util.base64HasWhitespace(encoded);
                if (VersionUtilities.isR5VerOrLater((String)this.context.getVersion())) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, wsok, "TYPE_SPECIFIC_CHECKS_DT_BASE64_NO_WS_ERROR", new Object[0]) && ok;
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, wsok, "TYPE_SPECIFIC_CHECKS_DT_BASE64_NO_WS_WARNING", new Object[0]);
                }
            }
            if (bok && context.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                int size = Base64Util.countBase64DecodedBytes(encoded);
                long def = Long.parseLong(ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/StructureDefinition/maxSize"));
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, e.line(), e.col(), path, (long)size <= def, "TYPE_SPECIFIC_CHECKS_DT_BASE64_TOO_LONG", size, def) && ok;
            }
        }
        if (type.equals("integer") || type.equals("unsignedInt") || type.equals("positiveInt")) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isInteger((String)e.primitiveValue()), "Type_Specific_Checks_DT_Integer_Valid", e.primitiveValue())) {
                Integer v = (int)new Integer(e.getValue());
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueIntegerType() || !context.getMaxValueIntegerType().hasValue() || (Integer)context.getMaxValueIntegerType().getValue() >= v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueIntegerType() ? context.getMaxValueIntegerType() : "") && ok;
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueIntegerType() || !context.getMinValueIntegerType().hasValue() || (Integer)context.getMinValueIntegerType().getValue() <= v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueIntegerType() ? context.getMinValueIntegerType() : "") && ok;
                if (type.equals("unsignedInt")) {
                    boolean bl10 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v >= 0, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]) && ok;
                }
                if (type.equals("positiveInt")) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v > 0, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (type.equals("integer64")) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.isLong((String)e.primitiveValue()), "Type_Specific_Checks_DT_Integer64_Valid", e.primitiveValue())) {
                Long v = (long)new Long(e.getValue());
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxValueInteger64Type() || !context.getMaxValueInteger64Type().hasValue() || (Long)context.getMaxValueInteger64Type().getValue() >= v, "Type_Specific_Checks_DT_Integer_GT", context.hasMaxValueInteger64Type() ? context.getMaxValueInteger64Type() : "") && ok;
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMinValueInteger64Type() || !context.getMinValueInteger64Type().hasValue() || (Long)context.getMinValueInteger64Type().getValue() <= v, "Type_Specific_Checks_DT_Integer_LT", context.hasMinValueInteger64Type() ? context.getMinValueInteger64Type() : "") && ok;
                if (type.equals("unsignedInt")) {
                    boolean bl11 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v >= 0L, "Type_Specific_Checks_DT_Integer_LT0", new Object[0]) && ok;
                }
                if (type.equals("positiveInt")) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, v > 0L, "Type_Specific_Checks_DT_Integer_LT1", new Object[0]) && ok;
                }
            } else {
                ok = false;
            }
        }
        if (type.equals("decimal")) {
            if (e.primitiveValue() != null) {
                Utilities.DecimalStatus ds = Utilities.checkDecimal((String)e.primitiveValue(), (boolean)true, (boolean)false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ds == Utilities.DecimalStatus.OK || ds == Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Valid", e.primitiveValue())) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, e.line(), e.col(), path, ds != Utilities.DecimalStatus.RANGE, "Type_Specific_Checks_DT_Decimal_Range", e.primitiveValue());
                    try {
                        Decimal v = new Decimal(e.getValue());
                        if (context.hasMaxValueDecimalType() && context.getMaxValueDecimalType().hasValue()) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.checkDecimalMaxValue(v, (BigDecimal)context.getMaxValueDecimalType().getValue()), "Type_Specific_Checks_DT_Decimal_GT", context.getMaxValueDecimalType()) && ok;
                        } else if (context.hasMaxValueIntegerType() && context.getMaxValueIntegerType().hasValue()) {
                            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.checkDecimalMaxValue(v, new BigDecimal((Integer)context.getMaxValueIntegerType().getValue())), "Type_Specific_Checks_DT_Decimal_GT", context.getMaxValueIntegerType()) && ok;
                        }
                        if (context.hasMinValueDecimalType() && context.getMinValueDecimalType().hasValue()) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.checkDecimalMinValue(v, (BigDecimal)context.getMinValueDecimalType().getValue()), "Type_Specific_Checks_DT_Decimal_LT", context.getMinValueDecimalType()) && ok;
                        } else if (context.hasMinValueIntegerType() && context.getMinValueIntegerType().hasValue()) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.checkDecimalMinValue(v, new BigDecimal((Integer)context.getMinValueIntegerType().getValue())), "Type_Specific_Checks_DT_Decimal_LT", context.getMinValueIntegerType()) && ok;
                        }
                    }
                    catch (Exception v) {}
                } else {
                    ok = false;
                }
            }
            if (context.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
                int dp = e.primitiveValue().contains(".") ? e.primitiveValue().substring(e.primitiveValue().indexOf(".") + 1).length() : 0;
                int def = Integer.parseInt(ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"));
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, e.line(), e.col(), path, dp <= def, "TYPE_SPECIFIC_CHECKS_DT_DECIMAL_CHARS", dp, def) && ok;
            }
        }
        if (type.equals("instant")) {
            boolean dok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "Type_Specific_Checks_DT_DateTime_Regex", "'" + e.primitiveValue() + "' doesn't meet format requirements for instant)");
            if (dok) {
                try {
                    InstantType dt2 = new InstantType(e.primitiveValue());
                    if (this.isCoreDefinition(profile) || context.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules") && ToolingExtensions.readStringExtension((Element)context, (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules").contains("year-valid")) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "Type_Specific_Checks_DT_DateTime_Reasonable", e.primitiveValue());
                    }
                }
                catch (Exception ex) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_Instant_Valid", ex.getMessage());
                    dok = false;
                }
            }
            boolean bl = ok = ok && dok;
        }
        if (type.equals("code") && e.primitiveValue() != null) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.primitiveValue()), "Type_Specific_Checks_DT_Code_WS", e.primitiveValue()) && ok;
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !context.hasMaxLength() || context.getMaxLength() == 0 || e.primitiveValue().length() <= context.getMaxLength(), "Type_Specific_Checks_DT_Primitive_Length", context.getMaxLength()) && ok;
        }
        if (context.hasBinding() && e.primitiveValue() != null) {
            if ("StructureDefinition.type".equals(context.getPath()) && "http://hl7.org/fhir/StructureDefinition/StructureDefinition".equals(profile.getUrl())) {
                ok = this.checkTypeValue(errors, path, e, parentNode.getElement());
            } else {
                boolean bl = ok = this.checkPrimitiveBinding(valContext, errors, path, type, context, e, profile, node) && ok;
            }
        }
        if (type.equals("markdown") && this.htmlInMarkdownCheck != HtmlInMarkdownCheck.NONE && !(raw = e.primitiveValue()).equals(processed = MarkDownProcessor.preProcess((String)raw))) {
            int i;
            for (i = 0; i < raw.length() && raw.charAt(1) == processed.charAt(i); ++i) {
            }
            if (i < raw.length() - 1) {
                if (!this.warningOrError(this.htmlInMarkdownCheck == HtmlInMarkdownCheck.ERROR, errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_MARKDOWN_HTML", raw.subSequence(i, i + 2))) {
                    ok = this.htmlInMarkdownCheck != HtmlInMarkdownCheck.ERROR && ok;
                }
            } else if (!this.warningOrError(this.htmlInMarkdownCheck == HtmlInMarkdownCheck.ERROR, errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_MARKDOWN_HTML", raw)) {
                boolean bl = ok = this.htmlInMarkdownCheck != HtmlInMarkdownCheck.ERROR && ok;
            }
        }
        if (type.equals("xhtml") && (xhtml = e.getXhtml()) != null) {
            String ns = xhtml.getNsDecl();
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml") && ok;
            ok = this.checkInnerNS(errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes()) && ok;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "XHTML_XHTML_Name_Invalid", xhtml.getName()) && ok;
            ok = this.checkInnerNames(errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes(), false) && ok;
            ok = this.checkUrls(errors, e, path, (List<XhtmlNode>)xhtml.getChildNodes()) && ok;
            ok = this.checkIdRefs(errors, e, path, xhtml, resource, node) && ok;
            ok = this.checkReferences(valContext, errors, e, path, "div", xhtml, resource) && ok;
            boolean bl = ok = this.checkImageSources(valContext, errors, e, path, "div", xhtml, resource) && ok;
        }
        if (context.hasFixed()) {
            boolean bl = ok = this.checkFixedValue(errors, path, e, (Element)context.getFixed(), profile.getVersionedUrl(), context.getSliceName(), null, false, "") && ok;
        }
        if (context.hasPattern()) {
            boolean bl = ok = this.checkFixedValue(errors, path, e, (Element)context.getPattern(), profile.getVersionedUrl(), context.getSliceName(), null, true, "") && ok;
        }
        if (ok && !ID_EXEMPT_LIST.contains(e.fhirType()) && (regext = FHIRPathExpressionFixer.fixRegex(this.getRegexFromType(e.fhirType()))) != null) {
            try {
                boolean matches;
                String pt = e.primitiveValue();
                String ptFmt = null;
                if (e.getProperty().getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format")) {
                    ptFmt = this.convertForDateFormatToExternal(ToolingExtensions.readStringExtension((Element)e.getProperty().getDefinition(), (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format"), pt);
                }
                boolean bl = matches = pt.matches(regext) || ptFmt != null && ptFmt.matches(regext);
                if (!matches) {
                    ok = ptFmt == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, matches, "Type_Specific_Checks_DT_Primitive_Regex_Type", pt, e.fhirType(), regext) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, matches, "TYPE_SPECIFIC_CHECKS_DT_PRIMITIVE_REGEX_TYPE_ALT", pt, ptFmt, e.fhirType(), regext) && ok;
                }
            }
            catch (Throwable ex) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_PRIMITIVE_REGEX_EXCEPTION", regext, e.fhirType(), ex.getMessage()) && ok;
            }
        }
        return ok;
    }

    private String convertForDateFormatToExternal(String fmt, String av) throws FHIRException {
        if ("v3".equals(fmt) || "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]".equals(fmt)) {
            DateTimeType d = new DateTimeType(av);
            return d.getAsV3();
        }
        throw new FHIRException(this.context.formatMessage("Unknown_Date_format_", new Object[]{fmt}));
    }

    private boolean isCoreDefinition(StructureDefinition profile) {
        return profile.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/") && profile.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL;
    }

    private String getRegexFromType(String fhirType) {
        StructureDefinition sd = this.context.fetchTypeDefinition(fhirType);
        if (sd != null) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!ed.getPath().endsWith(".value")) continue;
                String regex = ed.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
                if (regex != null) {
                    return regex;
                }
                for (ElementDefinition.TypeRefComponent td : ed.getType()) {
                    regex = td.getExtensionString("http://hl7.org/fhir/StructureDefinition/regex");
                    if (regex == null) continue;
                    return regex;
                }
            }
        }
        return null;
    }

    private boolean checkTypeValue(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element e, org.hl7.fhir.r5.elementmodel.Element sd) {
        String v = e.primitiveValue();
        if (v == null) {
            return this.rule(errors, "2022-11-02", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "SD_TYPE_MISSING", new Object[0]);
        }
        String url = sd.getChildValue("url");
        String d = sd.getChildValue("derivation");
        String k = sd.getChildValue("kind");
        if (Utilities.isAbsoluteUrl((String)v)) {
            this.warning(errors, "2022-11-02", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, d.equals("constraint") || this.ns(v).equals(this.ns(url)) || this.ns(v).equals(this.ns(url).replace("StructureDefinition/", "")), "SD_TYPE_NOT_MATCH_NS", v, url);
            return this.rule(errors, "2022-11-02", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "logical".equals(k), "SD_TYPE_NOT_LOGICAL", v, k);
        }
        boolean tok = false;
        for (StructureDefinition t : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!t.hasSourcePackage() || !t.getSourcePackage().getId().startsWith("hl7.fhir.r") || !v.equals(t.getType())) continue;
            tok = true;
        }
        if (tok) {
            if (!("http://hl7.org/fhir/StructureDefinition/" + v).equals(url)) {
                return this.rule(errors, "2022-11-02", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "constraint".equals(d), "SD_TYPE_NOT_DERIVED", v);
            }
            return true;
        }
        return this.rule(errors, "2022-11-02", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, tok, "SD_TYPE_NOT_LOCAL", v);
    }

    private String ns(String url) {
        return url.contains("/") ? url.substring(0, url.lastIndexOf("/")) : url;
    }

    private Object prepWSPresentation(String s) {
        if (Utilities.noString((String)s)) {
            return "";
        }
        return Utilities.escapeJson((String)s);
    }

    public boolean validateReference(ValidationContext valContext, List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element e, String url) {
        boolean ok = true;
        if (url.startsWith("#")) {
            valContext.getInternalRefs().add(url.substring(1));
        }
        if (this.fetcher != null && !type.equals("uuid")) {
            ReferenceValidationPolicy rp;
            boolean found;
            try {
                boolean bl = found = this.isDefinitionURL(url) || this.allowExamples && (url.contains("example.org") || url.contains("acme.com")) || url.contains("acme.org") || SpecialExtensions.isKnownExtension(url) || this.isXverUrl(url);
                if (!found) {
                    found = this.fetcher.resolveURL((IResourceValidator)this, (Object)valContext, path, url, type, type.equals("canonical"));
                }
            }
            catch (IOException e1) {
                found = false;
            }
            if (!found) {
                if (type.equals("canonical")) {
                    ReferenceValidationPolicy rp2 = this.policyAdvisor.policyForReference((IResourceValidator)this, (Object)valContext, path, url);
                    if (rp2 == ReferenceValidationPolicy.CHECK_EXISTS || rp2 == ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE", url) && ok;
                    } else {
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE", url);
                    }
                } else if (url.contains("hl7.org") || url.contains("fhir.org")) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_URL_Resolve", url) && ok;
                } else if (url.contains("example.org") || url.contains("acme.com")) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_URL_EXAMPLE", url) && ok;
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_URL_Resolve", url);
                }
            } else if (type.equals("canonical") && ((rp = this.policyAdvisor.policyForReference((IResourceValidator)this, (Object)valContext, path, url)) == ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE || rp == ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS || rp == ReferenceValidationPolicy.CHECK_VALID)) {
                try {
                    CanonicalResource r = null;
                    if (url.startsWith("#")) {
                        r = this.loadContainedResource(errors, path, valContext.getRootResource(), url.substring(1), Resource.class);
                    }
                    if (r == null) {
                        r = this.fetcher.fetchCanonicalResource((IResourceValidator)this, valContext.getAppContext(), url);
                    }
                    if (r == null) {
                        r = this.context.fetchResource(Resource.class, url);
                    }
                    if (r == null) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, rp != ReferenceValidationPolicy.CHECK_VALID, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_RESOLVE_NC", url);
                    } else if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.isCorrectCanonicalType((Resource)r, context), "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_TYPE", url, r.fhirType(), this.listExpectedCanonicalTypes(context))) {
                        if (rp == ReferenceValidationPolicy.CHECK_VALID) {
                            // empty if block
                        }
                        if (!url.contains("|") && r instanceof CanonicalResource && !Utilities.existsInList((String)context.getBase().getPath(), (String[])new String[]{"ImplementationGuide.dependsOn.uri", "ConceptMap.group.source", "ConceptMap.group.target"})) {
                            Set possibleVersions = this.fetcher.fetchCanonicalResourceVersions((IResourceValidator)this, valContext.getAppContext(), url);
                            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, possibleVersions.size() <= 1, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_MULTIPLE_POSSIBLE_VERSIONS", url, r.getVersion(), CommaSeparatedStringBuilder.join((String)", ", (Collection)Utilities.sorted((Collection)possibleVersions)));
                        }
                    } else {
                        ok = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ok;
    }

    private Set<String> listExpectedCanonicalTypes(ElementDefinition context) {
        HashSet<String> res = new HashSet<String>();
        ElementDefinition.TypeRefComponent tr = context.getType("canonical");
        if (tr != null) {
            for (CanonicalType p : tr.getTargetProfile()) {
                String url = (String)p.getValue();
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
                if (sd != null) {
                    res.add(sd.getType());
                    continue;
                }
                if (url == null || !url.startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
                res.add(url.substring("http://hl7.org/fhir/StructureDefinition/".length()));
            }
        }
        return res;
    }

    private boolean isCorrectCanonicalType(Resource r, ElementDefinition context) {
        ElementDefinition.TypeRefComponent tr = context.getType("canonical");
        if (tr != null) {
            for (CanonicalType p : tr.getTargetProfile()) {
                if (!this.isCorrectCanonicalType(r, p)) continue;
                return true;
            }
            if (tr.getTargetProfile().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean isCorrectCanonicalType(Resource r, CanonicalType p) {
        String url = (String)p.getValue();
        String t = null;
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        if (sd != null) {
            t = sd.getType();
        } else if (url.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            t = url.substring("http://hl7.org/fhir/StructureDefinition/".length());
        } else {
            return false;
        }
        return Utilities.existsInList((String)t, (String[])new String[]{"Resource", "CanonicalResource"}) || t.equals(r.fhirType());
    }

    private boolean isCanonicalURLElement(org.hl7.fhir.r5.elementmodel.Element e, NodeStack parent) {
        String path;
        String url;
        if (parent != null && parent.getElement().getName().equals("extension") && this.xverManager.status(url = parent.getElement().getChildValue("url")) == XVerExtensionManager.XVerExtensionStatus.Valid && url.contains("-") && (path = url.substring(url.lastIndexOf("-") + 1)).contains(".")) {
            String type = path.substring(0, path.indexOf(46));
            String tail = path.substring(path.indexOf(46) + 1);
            if ("url".equals(tail) && VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(type)) {
                return true;
            }
        }
        if (e.getProperty() == null || e.getProperty().getDefinition() == null) {
            return false;
        }
        String path2 = e.getProperty().getDefinition().getBase().getPath();
        if (path2 == null) {
            return false;
        }
        String[] p = path2.split("\\.");
        if (p.length != 2) {
            return false;
        }
        if (!"url".equals(p[1])) {
            return false;
        }
        return VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(p[0]);
    }

    private boolean containsHtmlTags(String cnt) {
        int i = cnt.indexOf("<");
        while (i > -1) {
            String s;
            cnt = cnt.substring(i + 1);
            i = cnt.indexOf("<");
            int e = cnt.indexOf(">");
            if (e <= -1 || e >= i || !(s = cnt.substring(0, e)).matches(HTML_FRAGMENT_REGEX)) continue;
            return true;
        }
        return false;
    }

    private boolean isDefinitionURL(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhirpath/System.Boolean", "http://hl7.org/fhirpath/System.String", "http://hl7.org/fhirpath/System.Integer", "http://hl7.org/fhirpath/System.Decimal", "http://hl7.org/fhirpath/System.Date", "http://hl7.org/fhirpath/System.Time", "http://hl7.org/fhirpath/System.DateTime", "http://hl7.org/fhirpath/System.Quantity", "http://hl7.org/fhir/SearchParameter/Resource-filter"});
    }

    private boolean checkInnerNames(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list, boolean inPara) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            if (node.getNodeType() == NodeType.Comment) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !node.getContent().startsWith("DOCTYPE"), "XHTML_XHTML_DOCTYPE_ILLEGAL", new Object[0]) && ok;
            }
            if (node.getNodeType() != NodeType.Element) continue;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, HTML_ELEMENTS.contains(node.getName()), "XHTML_XHTML_Element_Illegal", node.getName()) && ok;
            for (String an : node.getAttributes().keySet()) {
                boolean bok = an.startsWith("xmlns") || HTML_ATTRIBUTES.contains(an) || HTML_COMBO_LIST.contains(node.getName() + "." + an);
                if (bok) continue;
                if ("xml:space".equals(an)) {
                    this.hint(errors, "2024-08-03", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_ATTRIBUTE_XML_SPACE", an, node.getName());
                    continue;
                }
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "XHTML_XHTML_Attribute_Illegal", an, node.getName()) && ok;
            }
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !inPara || !HTML_BLOCK_LIST.contains(node.getName()), "XHTML_XHTML_ELEMENT_ILLEGAL_IN_PARA", node.getName()) && ok;
            ok = this.checkInnerNames(errors, e, path, (List<XhtmlNode>)node.getChildNodes(), inPara || "p".equals(node.getName())) && ok;
        }
        return ok;
    }

    private boolean checkReferences(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, String xpath, XhtmlNode node, org.hl7.fhir.r5.elementmodel.Element resource) {
        boolean ok = true;
        if (node.getNodeType() == NodeType.Element & "a".equals(node.getName()) && node.getAttribute("href") != null) {
            String href = node.getAttribute("href");
            if (this.rule(errors, "2024-07-20", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !Utilities.noString((String)href), "TYPE_SPECIFIC_CHECKS_DT_XHTML_EMPTY_HREF", xpath, Utilities.stripEoln((String)node.allText()))) {
                if (href.startsWith("#") && !href.equals("#")) {
                    String ref = href.substring(1);
                    valContext.getInternalRefs().add(ref);
                    HashSet<String> refs = new HashSet<String>();
                    int count = this.countTargetMatches(resource, ref, true, "$", refs);
                    if (count == 0) {
                        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_XHTML_Resolve", href, xpath, Utilities.stripEoln((String)node.allText()).trim());
                    } else if (count > 1) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_XHTML_MULTIPLE_MATCHES", href, xpath, node.allText(), CommaSeparatedStringBuilder.join((String)", ", refs));
                    }
                } else if (href.contains(":") && Utilities.isAbsoluteUrl((String)href)) {
                    String scheme = href.substring(0, href.indexOf(":"));
                    if (this.rule(errors, "2024-07-20", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.isActiveScheme(scheme), "TYPE_SPECIFIC_CHECKS_DT_XHTML_ACTIVE_HREF", href, xpath, Utilities.stripEoln((String)node.allText()).trim(), scheme)) {
                        if (this.rule(errors, "2024-07-20", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.isLiteralScheme(scheme), "TYPE_SPECIFIC_CHECKS_DT_XHTML_LITERAL_HREF", href, xpath, Utilities.stripEoln((String)node.allText()).trim(), scheme)) {
                            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.isKnownScheme(scheme), "TYPE_SPECIFIC_CHECKS_DT_XHTML_UNKNOWN_HREF", href, xpath, node.allText().trim(), scheme);
                        } else {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                }
            }
        }
        if (node.hasChildren()) {
            for (XhtmlNode child : node.getChildNodes()) {
                this.checkReferences(valContext, errors, e, path, xpath + "/" + child.getName(), child, resource);
            }
        }
        return ok;
    }

    private boolean isActiveScheme(String scheme) {
        return Utilities.existsInList((String)scheme, (String[])new String[]{"javascript", "vbscript"});
    }

    private boolean isLiteralScheme(String scheme) {
        return !Utilities.existsInList((String)scheme, (String[])new String[]{"urn", "cid"});
    }

    private boolean isKnownScheme(String scheme) {
        return Utilities.existsInList((String)scheme, (String[])new String[]{"http", "https", "tel", "mailto", "data"});
    }

    protected int countTargetMatches(org.hl7.fhir.r5.elementmodel.Element element, String fragment, boolean checkBundle, String path, Set<String> refs) {
        int count = 0;
        if (fragment.equals(element.getIdBase())) {
            ++count;
            refs.add(path + "/id");
        }
        if (element.getXhtml() != null) {
            count += this.countTargetMatches(element.getXhtml(), fragment, path, refs);
        }
        if (element.hasChildren()) {
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                count += this.countTargetMatches(child, fragment, false, path + "/" + child.getName(), refs);
            }
        }
        if (count == 0 && checkBundle) {
            for (org.hl7.fhir.r5.elementmodel.Element e = element.getParentForValidator(); e != null; e = e.getParentForValidator()) {
                if (!e.fhirType().equals("Bundle")) continue;
                return this.countTargetMatches(e, fragment, false, path + "/..", refs);
            }
        }
        return count;
    }

    private int countTargetMatches(XhtmlNode node, String fragment, String path, Set<String> refs) {
        int count = 0;
        if (fragment.equals(node.getAttribute("id"))) {
            ++count;
            refs.add(path + "/@id");
        }
        if ("a".equals(node.getName()) && fragment.equals(node.getAttribute("name"))) {
            ++count;
            refs.add(path + "/@name");
        }
        if (node.hasChildren()) {
            for (XhtmlNode child : node.getChildNodes()) {
                count += this.countTargetMatches(child, fragment, path + "/" + child.getName(), refs);
            }
        }
        return count;
    }

    private boolean checkImageSources(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, String xpath, XhtmlNode node, org.hl7.fhir.r5.elementmodel.Element resource) {
        String src;
        boolean ok = true;
        if (node.getNodeType() == NodeType.Element & "img".equals(node.getName()) && node.getAttribute("src") != null && (src = node.getAttribute("src")).startsWith("#")) {
            String ref = src.substring(1);
            valContext.getInternalRefs().add(ref);
            int count = this.countFragmentMatches(resource, ref);
            if (count == 0) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Type_Specific_Checks_DT_XHTML_Resolve_Img", src, xpath);
            } else if (count > 1) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_XHTML_MULTIPLE_MATCHES", src, xpath);
            }
        }
        if (node.hasChildren()) {
            for (XhtmlNode child : node.getChildNodes()) {
                this.checkImageSources(valContext, errors, e, path, path + "/" + child.getName(), child, resource);
            }
        }
        return ok;
    }

    private boolean checkIdRefs(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, XhtmlNode node, org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        boolean ok = true;
        if (node.getNodeType() == NodeType.Element && node.getAttribute("idref") != null) {
            String idref = node.getAttribute("idref");
            int count = this.countFragmentMatches(resource, idref, stack);
            if (count == 0) {
                ok = this.warning(errors, "2023-12-01", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, idref == null, "XHTML_IDREF_NOT_FOUND", idref) && ok;
            } else if (count > 1) {
                boolean bl = ok = this.rule(errors, "2023-12-01", ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, idref == null, "XHTML_IDREF_NOT_MULTIPLE_MATCHES", idref) && ok;
            }
        }
        if (node.hasChildren()) {
            for (XhtmlNode child : node.getChildNodes()) {
                this.checkIdRefs(errors, e, path, child, resource, stack);
            }
        }
        return ok;
    }

    private boolean checkUrls(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            String msg;
            if (node.getNodeType() != NodeType.Element) continue;
            if ("a".equals(node.getName())) {
                msg = UrlUtil.checkValidUrl(node.getAttribute("href"), this.context);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("href"), msg) && ok;
            } else if ("img".equals(node.getName())) {
                msg = UrlUtil.checkValidUrl(node.getAttribute("src"), this.context);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, msg == null, "XHTML_URL_INVALID", node.getAttribute("src"), msg) && ok;
            }
            ok = this.checkUrls(errors, e, path, (List<XhtmlNode>)node.getChildNodes()) && ok;
        }
        return ok;
    }

    private boolean checkInnerNS(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element e, String path, List<XhtmlNode> list) {
        boolean ok = true;
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "XHTML_XHTML_NS_InValid", ns, "http://www.w3.org/1999/xhtml") && ok;
            this.checkInnerNS(errors, e, path, (List<XhtmlNode>)node.getChildNodes());
        }
        return ok;
    }

    private boolean checkPrimitiveBinding(ValidationContext valContext, List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, NodeStack stack) {
        if (!(element.hasPrimitiveValue() && ("code".equals(type) || "string".equals(type) || "uri".equals(type) || "url".equals(type) || "canonical".equals(type)))) {
            return true;
        }
        if (this.noTerminologyChecks) {
            return true;
        }
        boolean ok = true;
        String value = element.primitiveValue();
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet()) {
            ValueSet vs = this.resolveBindingReference((DomainResource)profile, binding.getValueSet(), profile.getUrl(), (Resource)profile);
            if (vs == null) {
                CodeSystem cs = this.context.fetchCodeSystem(binding.getValueSet());
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs == null, "Terminology_TX_ValueSet_NotFound_CS", this.describeReference(binding.getValueSet()))) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(binding.getValueSet()));
                } else {
                    ok = false;
                }
            } else {
                EnumSet validationPolicy = this.policyAdvisor.policyForCodedContent((IResourceValidator)this, (Object)valContext, stack.getLiteralPath(), elementContext, profile, BindingKind.PRIMARY, null, vs, new ArrayList());
                if (!validationPolicy.isEmpty()) {
                    long t = System.nanoTime();
                    ValidationResult vr = null;
                    if (binding.getStrength() != Enumerations.BindingStrength.EXAMPLE) {
                        ValidationOptions options = this.baseOptions.withGuessSystem();
                        if (!validationPolicy.contains(IValidationPolicyAdvisor.CodedContentValidationAction.InvalidCode) && !validationPolicy.contains(IValidationPolicyAdvisor.CodedContentValidationAction.InvalidDisplay)) {
                            options = options.withCheckValueSetOnly();
                        }
                        vr = this.checkCodeOnServer(stack, vs, value, options);
                    }
                    ok = this.processTxIssues(errors, vr, element, path, binding.getStrength() != Enumerations.BindingStrength.REQUIRED, binding.getValueSet(), binding.getStrength()) && ok;
                    this.timeTracker.tx(t, "vc " + value);
                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.removeTrackedMessagesForLocation(errors, element, path);
                    }
                    if (vr != null && !vr.isOk()) {
                        if (vr.IsNoService()) {
                            this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_15", value);
                        } else if (vr.getErrorClass() != null && vr.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                            this.txWarning(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, vr.getMessage(), new Object[0]);
                        } else if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                            ok = this.txRule(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_16", value, this.describeReference(binding.getValueSet(), (CanonicalResource)vs, BindingContext.BASE, null), this.getErrorMessage(vr.getMessage())) && ok;
                        } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                            if (binding.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet")) {
                                ok = this.checkMaxValueSet(errors, path, element, profile, ToolingExtensions.readStringExtension((Element)binding, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"), value, stack) && ok;
                            } else if (!this.noExtensibleWarnings && !this.isOkExtension(value, vs)) {
                                this.txWarningForLaterRemoval(element, errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_17", value, this.describeReference(binding.getValueSet(), (CanonicalResource)vs, BindingContext.BASE, null), this.getErrorMessage(vr.getMessage()));
                            }
                        } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED && this.baseOnly) {
                            this.txHint(errors, NO_RULE_DATE, vr.getTxLink(), ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Terminology_TX_NoValid_18", value, this.describeReference(binding.getValueSet(), (CanonicalResource)vs, BindingContext.BASE, null), this.getErrorMessage(vr.getMessage()));
                        }
                    } else if (vr != null && vr.getMessage() != null) {
                        if (vr.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                            this.txHint(errors, "2023-07-04", vr.getTxLink(), ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), path, false, "TERMINOLOGY_TX_HINT", value, vr.getMessage());
                        } else {
                            this.txWarning(errors, "2023-07-04", vr.getTxLink(), ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), path, false, "TERMINOLOGY_TX_WARNING", value, vr.getMessage());
                        }
                    }
                }
            }
        } else if (!this.noBindingMsgSuppressed) {
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !type.equals("code"), "Terminology_TX_Binding_NoSource2");
        }
        return ok;
    }

    private boolean isOkExtension(String value, ValueSet vs) {
        if ("http://hl7.org/fhir/ValueSet/defined-types".equals(vs.getUrl())) {
            return value.startsWith("http://hl7.org/fhirpath/System.");
        }
        return false;
    }

    private boolean checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Quantity fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value", false), (Element)fixed.getValueElement(), fixedSource, "value", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator", false), (Element)fixed.getComparatorElement(), fixedSource, "comparator", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".unit", focus.getNamedChild("unit", false), (Element)fixed.getUnitElement(), fixedSource, "unit", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system", false), (Element)fixed.getSystemElement(), fixedSource, "system", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code", false), (Element)fixed.getCodeElement(), fixedSource, "code", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition theProfile, ElementDefinition definition, NodeStack theStack) {
        String code;
        boolean ok = true;
        String value = element.hasChild("value", false) ? element.getNamedChild("value", false).getValue() : null;
        String unit = element.hasChild("unit", false) ? element.getNamedChild("unit", false).getValue() : null;
        String system = element.hasChild("system", false) ? element.getNamedChild("system", false).getValue() : null;
        String string = code = element.hasChild("code", false) ? element.getNamedChild("code", false).getValue() : null;
        if (!Utilities.noString((String)value) && definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
            int dp = value.contains(".") ? value.substring(value.indexOf(".") + 1).length() : 0;
            int def = Integer.parseInt(ToolingExtensions.readStringExtension((Element)definition, (String)"http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"));
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, dp <= def, "TYPE_SPECIFIC_CHECKS_DT_DECIMAL_CHARS", dp, def) && ok;
        }
        if (system != null || code != null) {
            boolean bl = ok = this.checkCodedElement(errors, path, element, theProfile, definition, false, false, theStack, code, system, null, unit) && ok;
        }
        if (code != null && "http://unitsofmeasure.org".equals(system)) {
            int b = code.indexOf("{");
            int e = code.indexOf("}");
            if (b >= 0 && e > 0 && b < e) {
                String annotation = code.substring(b, e + 1);
                String annotationValue = code.substring(b + 1, e);
                if (unit == null) {
                    ok = this.bpCheck(errors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, !code.contains("{"), "TYPE_SPECIFIC_CHECKS_DT_QTY_UCUM_ANNOTATIONS_NO_UNIT", annotation) && ok;
                } else if (!unit.toLowerCase().contains(annotationValue.toLowerCase())) {
                    ok = this.bpCheck(errors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, !code.contains("{"), "TYPE_SPECIFIC_CHECKS_DT_QTY_UCUM_ANNOTATIONS_NOT_IN_UNIT", annotation, unit) && ok;
                } else {
                    boolean bl = ok = this.bpCheck(errors, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, !code.contains("{"), "TYPE_SPECIFIC_CHECKS_DT_QTY_UCUM_ANNOTATIONS", annotation, unit) && ok;
                }
            }
        }
        if (definition.hasMinValue() && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)value), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_VALUE_NO_VALUE", new Object[0])) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, definition.getMinValue() instanceof Quantity, "TYPE_SPECIFIC_CHECKS_DT_QTY_NO_QTY", definition.getMinValue().fhirType())) {
                Quantity min = definition.getMinValueQuantity();
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)min.getSystem()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_MIN_NO_SYSTEM", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)system), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_VALUE_NO_SYSTEM", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, system.equals(min.getSystem()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_SYSTEM_MISMATCH", system, min.getSystem()) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)min.getCode()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_MIN_NO_CODE", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)code), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_VALUE_NO_CODE", new Object[0])) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, definition.getMinValueQuantity().hasValue(), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_MIN_NO_VALUE", new Object[0])) {
                        if (code.equals(min.getCode())) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.checkDecimalMinValue(value, min.getValue()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_VALUE_WRONG", value, min.getValue().toString()) && ok;
                        } else if ("http://unitsofmeasure.org".equals(system)) {
                            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.context.getUcumService() != null, "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_NO_UCUM_SVC", new Object[0])) {
                                Decimal v = this.convertUcumValue(value, code, min.getCode());
                                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, v != null, "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_MIN_NO_CONVERT", value, code, min.getCode()) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.checkDecimalMinValue(v, min.getValue()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_VALUE_WRONG_UCUM", value, code, min.getValue().toString(), min.getCode()) && ok : false;
                            }
                        } else {
                            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_QTY_MIN_CODE_MISMATCH", code, min.getCode());
                        }
                    } else {
                        ok = false;
                    }
                }
            } else {
                ok = false;
            }
        }
        if (definition.hasMaxValue() && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)value), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_VALUE_NO_VALUE", new Object[0])) {
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, definition.getMaxValue() instanceof Quantity, "TYPE_SPECIFIC_CHECKS_DT_QTY_NO_QTY", definition.getMaxValue().fhirType())) {
                Quantity max = definition.getMaxValueQuantity();
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)max.getSystem()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_MIN_NO_SYSTEM", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)system), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_VALUE_NO_SYSTEM", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, system.equals(max.getSystem()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_SYSTEM_MISMATCH", system, max.getSystem()) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)max.getCode()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_MIN_NO_CODE", new Object[0]) && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, !Utilities.noString((String)code), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_VALUE_NO_CODE", new Object[0])) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, definition.getMaxValueQuantity().hasValue(), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_MIN_NO_VALUE", new Object[0])) {
                        if (code.equals(max.getCode())) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.checkDecimalMaxValue(value, max.getValue()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_VALUE_WRONG", value, max.getValue().toString()) && ok;
                        } else if ("http://unitsofmeasure.org".equals(system)) {
                            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.context.getUcumService() != null, "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_NO_UCUM_SVC", new Object[0])) {
                                Decimal v = this.convertUcumValue(value, code, max.getCode());
                                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, v != null, "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_MIN_NO_CONVERT", value, code, max.getCode()) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, this.checkDecimalMaxValue(v, max.getValue()), "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_VALUE_WRONG_UCUM", value, code, max.getValue().toString(), max.getCode()) && ok : false;
                            }
                        } else {
                            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, false, "TYPE_SPECIFIC_CHECKS_DT_QTY_MAX_CODE_MISMATCH", code, max.getCode());
                        }
                    } else {
                        ok = false;
                    }
                }
            } else {
                ok = false;
            }
        }
        return ok;
    }

    private Decimal convertUcumValue(String value, String code, String minCode) {
        try {
            Decimal v = new Decimal(value);
            return this.context.getUcumService().convert(v, code, minCode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean checkDecimalMaxValue(Decimal value, BigDecimal min) {
        try {
            Decimal m = new Decimal(min.toString());
            return value.comparesTo(m) <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkDecimalMaxValue(String value, BigDecimal min) {
        try {
            BigDecimal v = new BigDecimal(value);
            return v.compareTo(min) <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkDecimalMinValue(Decimal value, BigDecimal min) {
        try {
            Decimal m = new Decimal(min.toString());
            return value.comparesTo(m) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkDecimalMinValue(String value, BigDecimal min) {
        try {
            BigDecimal v = new BigDecimal(value);
            return v.compareTo(min) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition theProfile, ElementDefinition definition, boolean theInCodeableConcept, boolean theCheckDisplayInContext, NodeStack theStack) {
        boolean ok = true;
        long size = -1L;
        String fetchError = null;
        if (element.hasChild("data", false)) {
            String b64 = element.getChildValue("data");
            boolean bok = Base64Util.isValidBase64(b64);
            if (bok && element.hasChild("size", false)) {
                size = Base64Util.countBase64DecodedBytes(b64);
                String sz = element.getChildValue("size");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, Long.toString(size).equals(sz), "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_CORRECT", sz, size) && ok;
            }
        } else if (element.hasChild("size", false)) {
            String sz = element.getChildValue("size");
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, Utilities.isLong((String)sz), "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_INVALID", sz)) {
                size = Long.parseLong(sz);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size >= 0L, "TYPE_SPECIFIC_CHECKS_DT_ATT_SIZE_INVALID", sz) && ok;
            } else {
                ok = false;
            }
        } else if (element.hasChild("url", false)) {
            String url = element.getChildValue("url");
            if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                try {
                    if (url.startsWith("http://") || url.startsWith("https://")) {
                        if (this.fetcher == null) {
                            fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_NO_FETCHER", new Object[]{url});
                        } else {
                            byte[] cnt = this.fetcher.fetchRaw((IResourceValidator)this, url);
                            size = cnt.length;
                        }
                    } else if (url.startsWith("file:")) {
                        size = ManagedFileAccess.file((String)url.substring(5)).length();
                    } else {
                        fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_UNKNOWN_URL_SCHEME", new Object[]{url});
                    }
                }
                catch (Exception e) {
                    fetchError = this.context.formatMessage("TYPE_SPECIFIC_CHECKS_DT_ATT_URL_ERROR", new Object[]{url, e.getMessage()});
                }
            }
        }
        if (definition.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize") && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size >= 0L, fetchError, new Object[0])) {
            long def = Long.parseLong(ToolingExtensions.readStringExtension((Element)definition, (String)"http://hl7.org/fhir/StructureDefinition/maxSize"));
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, size <= def, "TYPE_SPECIFIC_CHECKS_DT_ATT_TOO_LONG", size, def) && ok;
        }
        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, element.hasChild("data", false) || element.hasChild("url", false) || element.hasChild("contentType", false) || element.hasChild("language", false), "TYPE_SPECIFIC_CHECKS_DT_ATT_NO_CONTENT", new Object[0]);
        return ok;
    }

    private boolean checkRange(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Range fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low", false), (Element)fixed.getLow(), fixedSource, "low", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high", false), (Element)fixed.getHigh(), fixedSource, "high", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkRatio(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Ratio fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator", false), (Element)fixed.getNumerator(), fixedSource, "numerator", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator", false), (Element)fixed.getDenominator(), fixedSource, "denominator", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkReference(ValidationContext valContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack, PercentageTracker pct, Base.ValidationMode vmode) throws FHIRException {
        String refType;
        boolean ok = true;
        Reference reference = ObjectConverter.readAsReference((org.hl7.fhir.r5.elementmodel.Element)element);
        String ref = reference.getReference();
        if (Utilities.noString((String)ref)) {
            if (!path.contains("element.pattern") && Utilities.noString((String)reference.getIdentifier().getSystem()) && Utilities.noString((String)reference.getIdentifier().getValue())) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString((String)element.getNamedChildValue("display", false)), "Reference_REF_NoDisplay", new Object[0]);
            }
            return true;
        }
        if (Utilities.existsInList((String)ref, (String[])new String[]{"http://tools.ietf.org/html/bcp47"})) {
            return true;
        }
        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !this.isSuspiciousReference(ref), "REFERENCE_REF_SUSPICIOUS", ref);
        BaseValidator.BooleanHolder bh = new BaseValidator.BooleanHolder();
        ResolvedReference we = this.localResolve(ref, stack, errors, path, valContext.getRootResource(), valContext.getGroupingResource(), element, bh);
        boolean bl = ok = bh.ok() && ok;
        if (ref.startsWith("#")) {
            valContext.getInternalRefs().add(ref.substring(1));
            refType = "contained";
        } else {
            refType = we == null ? "remote" : "bundled";
        }
        boolean conditional = ref.contains("?") && this.context.getResourceNamesAsSet().contains(ref.substring(0, ref.indexOf("?")));
        ReferenceValidationPolicy pol = refType.equals("contained") || refType.equals("bundled") ? ReferenceValidationPolicy.CHECK_VALID : this.policyAdvisor.policyForReference((IResourceValidator)this, valContext.getAppContext(), path, ref);
        if (conditional) {
            String query = ref.substring(ref.indexOf("?"));
            boolean test = !Utilities.noString((String)query) && query.matches("\\?([_a-zA-Z][_a-zA-Z0-9]*=[^=&]*)(&([_a-zA-Z][_a-zA-Z0-9]*=[^=&]*))*");
            ok = this.rule(errors, "2023-02-20", ValidationMessage.IssueType.INVALID, element.line(), element.col(), path, test, "REFERENCE_REF_QUERY_INVALID", ref) && ok;
        } else if (pol.checkExists()) {
            if (we == null && !refType.equals("contained")) {
                if (this.fetcher == null) {
                    throw new FHIRException(this.context.formatMessage("Resource_resolution_services_not_provided", new Object[0]));
                }
                org.hl7.fhir.r5.elementmodel.Element ext = null;
                if (this.fetchCache.containsKey(ref)) {
                    ext = this.fetchCache.get(ref);
                } else {
                    try {
                        ext = this.fetcher.fetch((IResourceValidator)this, valContext.getAppContext(), ref);
                    }
                    catch (IOException e) {
                        throw new FHIRException((Throwable)e);
                    }
                    if (ext != null) {
                        InstanceValidator.setParents(ext);
                        this.fetchCache.put(ref, ext);
                    }
                }
                we = ext == null ? null : this.makeExternalRef(ext, path);
            }
            boolean rok = this.allowExamples && (ref.contains("example.org") || ref.contains("acme.com")) || we != null || pol == ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS;
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, rok, "Reference_REF_CantResolve", ref) && ok;
        }
        String ft = we != null ? we.getType() : this.tryParse(ref);
        if (reference.hasType()) {
            Object tu = this.isAbsolute(reference.getType()) ? reference.getType() : "http://hl7.org/fhir/StructureDefinition/" + reference.getType();
            ElementDefinition.TypeRefComponent containerType = container.getType("Reference");
            if (!(containerType.hasTargetProfile((String)tu) || containerType.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource") || containerType.getTargetProfile().isEmpty())) {
                boolean matchingResource = false;
                for (Object target : containerType.getTargetProfile()) {
                    StructureDefinition sd = this.resolveProfile(profile, target.asStringValue());
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, element.line(), element.col(), path, sd != null, "Reference_REF_CantResolveProfile", target.asStringValue())) {
                        if (!("http://hl7.org/fhir/StructureDefinition/" + sd.getType()).equals(tu)) continue;
                        matchingResource = true;
                        break;
                    }
                    ok = false;
                }
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, matchingResource, "Reference_REF_WrongTarget", reference.getType(), container.getType("Reference").getTargetProfile()) && ok;
            }
            boolean bl2 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft == null || ft.equals(reference.getType()), "Reference_REF_BadTargetType", reference.getType(), ft) && ok;
        }
        if (we != null && pol.checkType() && this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Reference_REF_NoType", new Object[0])) {
            boolean rok = false;
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            if (type.hasTargetProfile() && !type.hasTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource")) {
                HashSet<String> types = new HashSet<String>();
                ArrayList<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
                for (UriType u : type.getTargetProfile()) {
                    StructureDefinition sd = this.resolveProfile(profile, (String)u.getValue());
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, sd != null, "Reference_REF_CantResolveProfile", u.getValue())) {
                        types.add(sd.getType());
                        if (!ft.equals(sd.getType())) continue;
                        rok = true;
                        profiles.add(sd);
                        continue;
                    }
                    ok = false;
                }
                if (!pol.checkValid()) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() > 0, "Reference_REF_CantMatchType", ref, StringUtils.join((Object[])new Object[]{"; ", type.getTargetProfile()})) && ok;
                } else {
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> badProfiles = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    HashMap<StructureDefinition, ArrayList<ValidationMessage>> goodProfiles = new HashMap<StructureDefinition, ArrayList<ValidationMessage>>();
                    int goodCount = 0;
                    for (StructureDefinition pr : profiles) {
                        ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                        this.validateResource(we.valContext(valContext, pr), profileErrors, we.getResource(), we.getFocus(), pr, IdStatus.OPTIONAL, we.getStack().resetIds(), pct, vmode.withReason(Base.ValidationReason.MatchingSlice), true, false);
                        if (!this.hasErrors(profileErrors)) {
                            ++goodCount;
                            goodProfiles.put(pr, profileErrors);
                            this.trackUsage(pr, valContext, element);
                            continue;
                        }
                        badProfiles.put(pr, profileErrors);
                    }
                    if (goodCount == 1) {
                        if (this.showMessagesFromReferences) {
                            for (ValidationMessage vm : (List)goodProfiles.values().iterator().next()) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                                ok = false;
                            }
                        }
                    } else if (goodProfiles.size() == 0) {
                        if (!this.isShowMessagesFromReferences()) {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.areAllBaseProfiles(profiles), "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile())) && ok;
                            for (StructureDefinition sd : badProfiles.keySet()) {
                                this.slicingHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, false, this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{ref, sd.getVersionedUrl()}), this.errorSummaryForSlicingAsHtml((List)badProfiles.get(sd)), this.errorSummaryForSlicingAsText((List)badProfiles.get(sd)));
                            }
                        } else {
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, profiles.size() == 1, "Reference_REF_CantMatchChoice", ref, this.asList(type.getTargetProfile())) && ok;
                            for (List messages : badProfiles.values()) {
                                for (ValidationMessage vm : messages) {
                                    if (errors.contains(vm)) continue;
                                    errors.add(vm);
                                    ok = false;
                                }
                            }
                        }
                    } else if (!this.isShowMessagesFromReferences()) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(goodProfiles.keySet()));
                        for (StructureDefinition sd : badProfiles.keySet()) {
                            this.slicingHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, false, this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{ref, sd.getVersionedUrl()}), this.errorSummaryForSlicingAsHtml((List)badProfiles.get(sd)), this.errorSummaryForSlicingAsText((List)badProfiles.get(sd)));
                        }
                    } else {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, "Reference_REF_MultipleMatches", ref, this.asListByUrl(goodProfiles.keySet()));
                        for (List messages : goodProfiles.values()) {
                            for (ValidationMessage vm : messages) {
                                if (errors.contains(vm)) continue;
                                errors.add(vm);
                                ok = false;
                            }
                        }
                    }
                }
                boolean bl3 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, rok, "Reference_REF_BadTargetType", ft, ((Object)types).toString()) && ok;
            }
            if (type.hasAggregation() && !this.noCheckAggregation) {
                boolean modeOk = false;
                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                for (Enumeration mode : type.getAggregation()) {
                    b.append(mode.getCode());
                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.CONTAINED) && refType.equals("contained")) {
                        modeOk = true;
                        continue;
                    }
                    if (((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.BUNDLED) && refType.equals("bundled")) {
                        modeOk = true;
                        continue;
                    }
                    if (!((ElementDefinition.AggregationMode)mode.getValue()).equals((Object)ElementDefinition.AggregationMode.REFERENCED) || !refType.equals("bundled") && !refType.equals("remote")) continue;
                    modeOk = true;
                }
                boolean bl4 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, modeOk, "Reference_REF_Aggregation", refType, b.toString()) && ok;
            }
        }
        if (we == null) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            boolean okToRef = !type.hasAggregation() || type.hasAggregation(ElementDefinition.AggregationMode.REFERENCED);
            boolean bl5 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, okToRef, "Reference_REF_NotFound_Bundle", ref) && ok;
        }
        if (we == null && ft != null && this.assumeValidRestReferences) {
            ElementDefinition.TypeRefComponent type = this.getReferenceTypeRef(container.getType());
            HashSet<String> types = new HashSet<String>();
            StructureDefinition sdFT = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + ft);
            boolean rok = false;
            block13: for (CanonicalType tp : type.getTargetProfile()) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)tp.getValue(), (Resource)profile);
                if (sd == null) continue;
                types.add(sd.getType());
                StructureDefinition sdF = sdFT;
                while (sdF != null) {
                    if (sdF.getType().equals(sd.getType())) {
                        rok = true;
                        continue block13;
                    }
                    sdF = sdF.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sdF.getBaseDefinition(), (Resource)sdF) : null;
                }
            }
            boolean bl6 = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, types.isEmpty() || rok, "Reference_REF_BadTargetType2", ft, ref, types) && ok;
        }
        if (pol == ReferenceValidationPolicy.CHECK_VALID) {
            // empty if block
        }
        return ok;
    }

    private boolean isSuspiciousReference(String url) {
        if (!this.assumeValidRestReferences || url == null || Utilities.isAbsoluteUrl((String)url) || url.startsWith("#")) {
            return false;
        }
        String[] parts = url.split("\\/");
        if (parts.length == 2 && this.context.getResourceNames().contains(parts[0]) && Utilities.isValidId((String)parts[1])) {
            return false;
        }
        return parts.length != 4 || !this.context.getResourceNames().contains(parts[0]) || !Utilities.isValidId((String)parts[1]) || !"_history".equals(parts[2]) || !Utilities.isValidId((String)parts[3]);
    }

    private String asListByUrl(Collection<StructureDefinition> coll) {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        list.addAll(coll);
        Collections.sort(list, new StructureDefinitionSorterByUrl());
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (StructureDefinition sd : list) {
            b.append(sd.getUrl());
        }
        return b.toString();
    }

    private String asList(Collection<CanonicalType> coll) {
        ArrayList<CanonicalType> list = new ArrayList<CanonicalType>();
        list.addAll(coll);
        Collections.sort(list, new CanonicalTypeSorter());
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (CanonicalType c : list) {
            b.append((String)c.getValue());
        }
        return b.toString();
    }

    private boolean areAllBaseProfiles(List<StructureDefinition> profiles) {
        for (StructureDefinition sd : profiles) {
            if (sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            return false;
        }
        return true;
    }

    private String errorSummaryForSlicing(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && !vm.isSlicingHint()) continue;
            b.append(vm.getLocation() + ": " + vm.getMessage());
        }
        return b.toString();
    }

    private String errorSummaryForSlicingAsHtml(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : list) {
            if (vm.isSlicingHint()) {
                b.append("<li>" + vm.getLocation() + ": " + vm.getSliceHtml() + "</li>");
                continue;
            }
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
            b.append("<li>" + vm.getLocation() + ": " + vm.getHtml() + "</li>");
        }
        return "<ul>" + b.toString() + "</ul>";
    }

    private boolean isCritical(List<ValidationMessage> list) {
        for (ValidationMessage vm : list) {
            if (!vm.isSlicingHint() || !vm.isCriticalSignpost()) continue;
            return true;
        }
        return false;
    }

    private String[] errorSummaryForSlicingAsText(List<ValidationMessage> list) {
        ArrayList<CallSite> res = new ArrayList<CallSite>();
        for (ValidationMessage vm : list) {
            if (vm.isSlicingHint()) {
                if (vm.sliceText != null) {
                    for (String s : vm.sliceText) {
                        res.add((CallSite)((Object)(vm.getLocation() + ": " + s)));
                    }
                    continue;
                }
                res.add((CallSite)((Object)(vm.getLocation() + ": " + vm.getMessage())));
                continue;
            }
            if (vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
            res.add((CallSite)((Object)(vm.getLocation() + ": " + vm.getHtml())));
        }
        return res.toArray(new String[0]);
    }

    private ElementDefinition.TypeRefComponent getReferenceTypeRef(List<ElementDefinition.TypeRefComponent> types) {
        for (ElementDefinition.TypeRefComponent tr : types) {
            if (!"Reference".equals(tr.getCode())) continue;
            return tr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkResourceType(String type) {
        long t = System.nanoTime();
        try {
            if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
                String string = type;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.timeTracker.sd(t);
        }
    }

    private boolean checkSampledData(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, SampledData fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        boolean bl = ok = this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin", false), (Element)fixed.getOrigin(), fixedSource, "origin", focus, pattern, context) && ok;
        if (VersionUtilities.isR5VerOrLater((String)this.context.getVersion())) {
            ok = this.checkFixedValue(errors, path + ".interval", focus.getNamedChild("period", false), (Element)fixed.getIntervalElement(), fixedSource, "interval", focus, pattern, context) && ok;
            ok = this.checkFixedValue(errors, path + ".intervalUnit", focus.getNamedChild("period", false), (Element)fixed.getIntervalUnitElement(), fixedSource, "intervalUnit", focus, pattern, context) && ok;
        } else {
            ok = this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period", false), (Element)fixed.getIntervalElement(), fixedSource, "period", focus, pattern, context) && ok;
        }
        ok = this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor", false), (Element)fixed.getFactorElement(), fixedSource, "factor", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit", false), (Element)fixed.getLowerLimitElement(), fixedSource, "lowerLimit", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit", false), (Element)fixed.getUpperLimitElement(), fixedSource, "upperLimit", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions", false), (Element)fixed.getDimensionsElement(), fixedSource, "dimensions", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data", false), (Element)fixed.getDataElement(), fixedSource, "data", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkReference(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Reference fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".reference", focus.getNamedChild("reference", false), (Element)fixed.getReferenceElement_(), fixedSource, "reference", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type", false), (Element)fixed.getTypeElement(), fixedSource, "type", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".identifier", focus.getNamedChild("identifier", false), (Element)fixed.getIdentifier(), fixedSource, "identifier", focus, pattern, context) && ok;
        ok = this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display", false), (Element)fixed.getDisplayElement(), fixedSource, "display", focus, pattern, context) && ok;
        return ok;
    }

    private boolean checkTiming(List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element focus, Timing fixed, String fixedSource, boolean pattern, String context) {
        boolean ok = true;
        ok = this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat", false), (Element)fixed.getRepeat(), fixedSource, "value", focus, pattern, context) && ok;
        ArrayList events = new ArrayList();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Bundle_MSG_Event_Count", Integer.toString(fixed.getEvent().size()), Integer.toString(events.size()))) {
            for (int i = 0; i < events.size(); ++i) {
                ok = this.checkFixedValue(errors, path + ".event", (org.hl7.fhir.r5.elementmodel.Element)events.get(i), (Element)fixed.getEvent().get(i), fixedSource, "event", focus, pattern, context) && ok;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(String reference, CanonicalResource target, BindingContext ctxt, String usageNote) {
        if (reference == null && target == null) {
            return "null";
        }
        Object res = null;
        if (reference == null) {
            res = target.getVersionedUrl();
        } else if (target == null) {
            res = reference;
        } else {
            String uref = reference.contains("|") ? reference.substring(0, reference.lastIndexOf("|")) : reference;
            String vref = reference.contains("|") ? reference.substring(reference.lastIndexOf("|") + 1) : null;
            res = uref.equals(target.getUrl()) && (vref == null || vref.equals(target.getVersion())) ? "'" + target.present() + "' (" + target.getVersionedUrl() + ")" : reference + "(which actually refers to '" + target.present() + "' (" + target.getVersionedUrl() + "))";
        }
        switch (ctxt) {
            case ADDITIONAL: {
                return this.context.formatMessage(Utilities.noString((String)usageNote) ? "BINDING_ADDITIONAL_D" : "BINDING_ADDITIONAL_UC", new Object[]{res, usageNote});
            }
            case MAXVS: {
                return this.context.formatMessage("BINDING_MAX", new Object[]{res});
            }
        }
        return res;
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getWorkingCode());
        }
        return b.toString();
    }

    protected ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    public CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(g, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private IndexedElement getContainedById(org.hl7.fhir.r5.elementmodel.Element container, String id) {
        ArrayList contained = new ArrayList();
        container.getNamedChildren("contained", contained);
        for (int i = 0; i < contained.size(); ++i) {
            org.hl7.fhir.r5.elementmodel.Element we = (org.hl7.fhir.r5.elementmodel.Element)contained.get(i);
            if (!id.equals(we.getNamedChildValue("id", false))) continue;
            return new IndexedElement(i, we, null);
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private List<ElementDefinition> getCriteriaForDiscriminator(String path, ElementDefinition element, String discriminator, StructureDefinition profile, boolean removeResolve, StructureDefinition srcProfile) throws FHIRException {
        ArrayList<ElementDefinition> elements = new ArrayList<ElementDefinition>();
        if ("value".equals(discriminator) && element.hasFixed()) {
            elements.add(element);
            return elements;
        }
        boolean dontFollowReference = false;
        if (removeResolve) {
            if (discriminator.equals("resolve()")) {
                elements.add(element);
                return elements;
            }
            if (discriminator.endsWith(".resolve()")) {
                discriminator = discriminator.substring(0, discriminator.length() - 10);
                dontFollowReference = true;
            }
        }
        FHIRPathUtilityClasses.TypedElementDefinition ted = null;
        String fp = FHIRPathExpressionFixer.fixExpr(discriminator, null, this.context.getVersion());
        ExpressionNode expr = null;
        try {
            expr = this.fpe.parse(fp);
        }
        catch (Exception e) {
            throw new FHIRException(this.context.formatMessage("DISCRIMINATOR_BAD_PATH", new Object[]{e.getMessage(), fp}), (Throwable)e);
        }
        long t2 = System.nanoTime();
        ted = this.fpe.evaluateDefinition(expr, profile, new FHIRPathUtilityClasses.TypedElementDefinition(element), srcProfile, dontFollowReference);
        this.timeTracker.sd(t2);
        if (ted != null) {
            elements.add(ted.getElement());
        }
        for (ElementDefinition.TypeRefComponent type : element.getType()) {
            for (CanonicalType p : type.getProfile()) {
                String id = p.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") ? p.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element") : null;
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)p.getValue(), (Resource)profile);
                if (sd == null) {
                    throw new DefinitionException(this.context.formatMessage("SD_ED_TYPE_PROFILE_UNKNOWN", new Object[]{p}));
                }
                profile = sd;
                if (id == null) {
                    element = sd.getSnapshot().getElementFirstRep();
                } else {
                    element = null;
                    for (ElementDefinition t : sd.getSnapshot().getElement()) {
                        if (!id.equals(t.getId())) continue;
                        element = t;
                    }
                    if (element == null) {
                        throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_element__in_profile_", new Object[]{id, p}));
                    }
                }
                expr = this.fpe.parse(fp);
                t2 = System.nanoTime();
                ted = this.fpe.evaluateDefinition(expr, profile, new FHIRPathUtilityClasses.TypedElementDefinition(element), srcProfile, dontFollowReference);
                this.timeTracker.sd(t2);
                if (ted == null) continue;
                elements.add(ted.getElement());
            }
        }
        return elements;
    }

    private org.hl7.fhir.r5.elementmodel.Element getExtensionByUrl(List<org.hl7.fhir.r5.elementmodel.Element> extensions, String urlSimple) {
        for (org.hl7.fhir.r5.elementmodel.Element e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url", false))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    public List<ImplementationGuide> getImplementationGuides() {
        return this.igs;
    }

    private StructureDefinition getProfileForType(String type, List<ElementDefinition.TypeRefComponent> list, Resource src) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            StructureDefinition sdt;
            Object url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + (String)url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)url, src);
            this.timeTracker.sd(t);
            if (sd != null && (sd.getTypeTail().equals(type) || sd.getUrl().equals(type)) && sd.hasSnapshot()) {
                return sd;
            }
            if (sd == null || !sd.getAbstract() && !sd.getUrl().startsWith("http://hl7.org/cda/stds/core")) continue;
            StructureDefinition tt = sdt = this.context.fetchTypeDefinition(type);
            while (tt != null) {
                if (sd.getUrl().equals(tt.getBaseDefinition())) {
                    return sdt;
                }
                tt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, tt.getBaseDefinition());
            }
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getValueForDiscriminator(Object appContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, String discriminator, ElementDefinition criteria, NodeStack stack, BaseValidator.BooleanHolder bh) throws FHIRException, IOException {
        String[] dlist;
        String p = stack.getLiteralPath() + "." + element.getName();
        org.hl7.fhir.r5.elementmodel.Element focus = element;
        for (String d : dlist = discriminator.split("\\.")) {
            if (focus.fhirType().equals("Reference") && d.equals("reference")) {
                String url = focus.getChildValue("reference");
                if (Utilities.noString((String)url)) {
                    throw new FHIRException(this.context.formatMessage("No_reference_resolving_discriminator__from_", new Object[]{discriminator, element.getProperty().getName()}));
                }
                org.hl7.fhir.r5.elementmodel.Element target = this.resolve(appContext, url, stack, errors, p, bh);
                if (target == null) {
                    throw new FHIRException(this.context.formatMessage("Unable_to_find_resource__at__resolving_discriminator__from_", new Object[]{url, d, discriminator, element.getProperty().getName()}));
                }
                focus = target;
                continue;
            }
            if (d.equals("value") && focus.isPrimitive()) {
                return focus;
            }
            List children = focus.getChildren(d);
            if (children.isEmpty()) {
                throw new FHIRException(this.context.formatMessage("Unable_to_find__resolving_discriminator__from_", new Object[]{d, discriminator, element.getProperty().getName()}));
            }
            if (children.size() > 1) {
                throw new FHIRException(this.context.formatMessage("Found__items_for__resolving_discriminator__from_", new Object[]{Integer.toString(children.size()), d, discriminator, element.getProperty().getName()}));
            }
            focus = (org.hl7.fhir.r5.elementmodel.Element)children.get(0);
            p = p + "." + d;
        }
        return focus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeSystem getCodeSystem(String system) {
        long t = System.nanoTime();
        try {
            CodeSystem codeSystem = this.context.fetchCodeSystem(system);
            return codeSystem;
        }
        finally {
            this.timeTracker.tx(t, "cs " + system);
        }
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private boolean isAbsolute(String uri) {
        String protocol = null;
        String tail = null;
        if (uri.contains(":")) {
            protocol = uri.substring(0, uri.indexOf(":"));
            tail = uri.substring(uri.indexOf(":") + 1);
        }
        if (Utilities.isToken(protocol)) {
            if ("file".equals(protocol)) {
                return tail.startsWith("/") || tail.contains(":");
            }
            return true;
        }
        return false;
    }

    private boolean isCodeSystemReferenceValid(String uri) {
        return this.isSystemReferenceValid(uri);
    }

    private boolean isIdentifierSystemReferenceValid(String uri) {
        return this.isSystemReferenceValid(uri) || uri.startsWith("ldap:");
    }

    private boolean isSystemReferenceValid(String uri) {
        return uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:");
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (InstanceValidator.pathEntryHasName(parts[parts.length - 2], "parameter") || InstanceValidator.pathEntryHasName(parts[parts.length - 2], "part"));
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "entry");
    }

    private boolean isBundleOutcome(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("outcome") && InstanceValidator.pathEntryHasName(parts[parts.length - 2], "response");
    }

    private static boolean pathEntryHasName(String thePathEntry, String theName) {
        if (thePathEntry.equals(theName)) {
            return true;
        }
        return thePathEntry.length() >= theName.length() + 3 && thePathEntry.startsWith(theName) && thePathEntry.charAt(theName.length()) == '[';
    }

    public boolean isPrimitiveType(String code) {
        return this.context.isPrimitiveType(code);
    }

    private String getErrorMessage(String message) {
        return message != null ? " (error message = " + message + ")" : "";
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!Utilities.trimWS((String)v).equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Utilities.isWhitespace((int)c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    public ResolvedReference localResolve(String ref, NodeStack stack, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element rootResource, org.hl7.fhir.r5.elementmodel.Element groupingResource, org.hl7.fhir.r5.elementmodel.Element source, BaseValidator.BooleanHolder bh) {
        String type;
        if (ref.startsWith("#")) {
            boolean wasContained = false;
            org.hl7.fhir.r5.elementmodel.Element focus = stack.getElement();
            NodeStack nstack = stack;
            while (focus != null) {
                if (focus.getProperty().isResource()) {
                    IndexedElement res;
                    if (ref.equals("#") && focus.getSpecial() != Element.SpecialElement.CONTAINED && wasContained) {
                        ResolvedReference rr = new ResolvedReference();
                        rr.setResource(focus);
                        rr.setFocus(focus);
                        rr.setExternal(false);
                        rr.setStack(nstack);
                        return rr;
                    }
                    if (focus.getSpecial() == Element.SpecialElement.CONTAINED) {
                        wasContained = true;
                    }
                    if ((res = this.getContainedById(focus, ref.substring(1))) != null) {
                        ResolvedReference rr = new ResolvedReference();
                        rr.setResource(focus);
                        rr.setFocus(res.getMatch());
                        rr.setExternal(false);
                        rr.setStack(nstack.push(res.getMatch(), res.getIndex(), res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
                        rr.getStack().pathComment(res.getMatch().fhirType() + "/" + res.getMatch().getIdBase());
                        return rr;
                    }
                }
                if (focus.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || focus.getSpecial() == Element.SpecialElement.PARAMETER) {
                    return null;
                }
                focus = focus.getParentForValidator();
                nstack = nstack.getParent();
                if (focus == null || nstack != null) continue;
                nstack = new NodeStack(this.context, focus, focus.fhirType(), this.validationLanguage);
            }
            return null;
        }
        String fullUrl = null;
        for (org.hl7.fhir.r5.elementmodel.Element focus = stack.getElement(); focus != null; focus = focus.getParentForValidator()) {
            NodeStack tgt;
            if (focus.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY && fullUrl == null && focus != null && focus.getParentForValidator() != null && focus.getParentForValidator().getName().equals("entry")) {
                type = focus.getParentForValidator().getChildValue("type");
                fullUrl = focus.getParentForValidator().getChildValue("fullUrl");
                if (fullUrl == null) {
                    bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, focus.getParentForValidator().line(), focus.getParentForValidator().col(), focus.getParentForValidator().getPath(), Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || fullUrl != null, "Bundle_BUNDLE_Entry_NoFullUrl", new Object[0]));
                }
            }
            if ("Bundle".equals(focus.getType())) {
                type = focus.getChildValue("type");
                IndexedElement res = this.getFromBundle(focus, ref, fullUrl, errors, path, type, "transaction".equals(type), bh);
                if (res == null) {
                    return null;
                }
                ResolvedReference rr = new ResolvedReference();
                rr.setResource(res.getMatch());
                rr.setFocus(res.getMatch());
                rr.setExternal(false);
                rr.setStack(new NodeStack(this.context, null, res.getMatch(), this.validationLanguage));
                rr.setVia(stack);
                rr.getStack().pathComment(rr.getResource().fhirType() + "/" + rr.getResource().getIdBase());
                return rr;
            }
            if (focus.getSpecial() != Element.SpecialElement.PARAMETER || focus.getParentForValidator() == null || (tgt = this.findInParams(this.findParameters(focus), ref, stack)) == null) continue;
            ResolvedReference rr = new ResolvedReference();
            rr.setResource(tgt.getElement());
            rr.setFocus(tgt.getElement());
            rr.setExternal(false);
            rr.setStack(tgt);
            rr.getStack().pathComment(tgt.getElement().fhirType() + "/" + tgt.getElement().getIdBase());
            return rr;
        }
        if (groupingResource != null && "Bundle".equals(groupingResource.fhirType())) {
            type = groupingResource.getChildValue("type");
            org.hl7.fhir.r5.elementmodel.Element entry = this.getEntryForSource(groupingResource, source);
            fullUrl = entry.getChildValue("fullUrl");
            IndexedElement res = this.getFromBundle(groupingResource, ref, fullUrl, errors, path, type, "transaction".equals(type), bh);
            if (res == null) {
                return null;
            }
            ResolvedReference rr = new ResolvedReference();
            rr.setResource(res.getMatch());
            rr.setFocus(res.getMatch());
            rr.setExternal(false);
            rr.setStack(new NodeStack(this.context, null, rootResource, this.validationLanguage).push(res.getEntry(), res.getIndex(), res.getEntry().getProperty().getDefinition(), res.getEntry().getProperty().getDefinition()).push(res.getMatch(), -1, res.getMatch().getProperty().getDefinition(), res.getMatch().getProperty().getDefinition()));
            rr.getStack().pathComment(rr.getResource().fhirType() + "/" + rr.getResource().getIdBase());
            return rr;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element findParameters(org.hl7.fhir.r5.elementmodel.Element focus) {
        while (focus != null) {
            if ("Parameters".equals(focus.fhirType())) {
                return focus;
            }
            focus = focus.getParentForValidator();
        }
        return null;
    }

    private NodeStack findInParams(org.hl7.fhir.r5.elementmodel.Element params, String ref, NodeStack stack) {
        if (params == null) {
            return null;
        }
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element child : params.getChildren("parameter")) {
            org.hl7.fhir.r5.elementmodel.Element res;
            NodeStack p = stack.push(child, i, child.getProperty().getDefinition(), child.getProperty().getDefinition());
            if (child.hasChild("resource", false) && ((res = child.getNamedChild("resource", false)).fhirType() + "/" + res.getIdBase()).equals(ref)) {
                return p.push(res, -1, res.getProperty().getDefinition(), res.getProperty().getDefinition());
            }
            NodeStack pc = this.findInParamParts(p, child, ref);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private NodeStack findInParamParts(NodeStack pp, org.hl7.fhir.r5.elementmodel.Element param, String ref) {
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element child : param.getChildren("part")) {
            org.hl7.fhir.r5.elementmodel.Element res;
            NodeStack p = pp.push(child, i, child.getProperty().getDefinition(), child.getProperty().getDefinition());
            if (child.hasChild("resource", false) && ((res = child.getNamedChild("resource", false)).fhirType() + "/" + res.getIdBase()).equals(ref)) {
                return p.push(res, -1, res.getProperty().getDefinition(), res.getProperty().getDefinition());
            }
            NodeStack pc = this.findInParamParts(p, child, ref);
            if (pc == null) continue;
            return pc;
        }
        return null;
    }

    private org.hl7.fhir.r5.elementmodel.Element getEntryForSource(org.hl7.fhir.r5.elementmodel.Element bundle, org.hl7.fhir.r5.elementmodel.Element element) {
        ArrayList entries = new ArrayList();
        bundle.getNamedChildren("entry", entries);
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            if (!entry.hasDescendant(element)) continue;
            return entry;
        }
        return null;
    }

    private ResolvedReference makeExternalRef(org.hl7.fhir.r5.elementmodel.Element external, String path) {
        ResolvedReference res = new ResolvedReference();
        res.setResource(external);
        res.setFocus(external);
        res.setExternal(true);
        res.setStack(new NodeStack(this.context, external, path, this.validationLanguage));
        return res;
    }

    private org.hl7.fhir.r5.elementmodel.Element resolve(Object appContext, String ref, NodeStack stack, List<ValidationMessage> errors, String path, BaseValidator.BooleanHolder bh) throws IOException, FHIRException {
        org.hl7.fhir.r5.elementmodel.Element local = this.localResolve(ref, stack, errors, path, null, null, null, bh).getFocus();
        if (local != null) {
            return local;
        }
        if (this.fetcher == null) {
            return null;
        }
        if (this.fetchCache.containsKey(ref)) {
            return this.fetchCache.get(ref);
        }
        org.hl7.fhir.r5.elementmodel.Element res = this.fetcher.fetch((IResourceValidator)this, appContext, ref);
        InstanceValidator.setParents(res);
        this.fetchCache.put(ref, res);
        return res;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String contentReference) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!contentReference.equals("#" + ed.getId())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        long t = System.nanoTime();
        StructureDefinition fr = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, pr, (Resource)profile);
        this.timeTracker.sd(t);
        return fr;
    }

    private ElementDefinition resolveType(String type, List<ElementDefinition.TypeRefComponent> list) {
        for (ElementDefinition.TypeRefComponent tr : list) {
            StructureDefinition sdt;
            Object url = tr.getWorkingCode();
            if (!Utilities.isAbsoluteUrl((String)url)) {
                url = "http://hl7.org/fhir/StructureDefinition/" + (String)url;
            }
            long t = System.nanoTime();
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)url);
            this.timeTracker.sd(t);
            if (sd != null && (sd.getType().equals(type) || sd.getUrl().equals(type)) && sd.hasSnapshot()) {
                return (ElementDefinition)sd.getSnapshot().getElement().get(0);
            }
            if (sd == null || !this.inheritsFrom(sdt = this.context.fetchTypeDefinition(type), sd) || !sdt.hasSnapshot()) continue;
            return (ElementDefinition)sdt.getSnapshot().getElement().get(0);
        }
        return null;
    }

    private boolean inheritsFrom(StructureDefinition sdt, StructureDefinition sd) {
        while (sdt != null) {
            if (sdt == sd) {
                return true;
            }
            sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sdt.getBaseDefinition());
        }
        return false;
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    public void setCheckDisplay(CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    public IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    public void setResourceIdRule(IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    public boolean isAllowXsiLocation() {
        return this.allowXsiLocation;
    }

    public void setAllowXsiLocation(boolean allowXsiLocation) {
        this.allowXsiLocation = allowXsiLocation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sliceMatches(ValidationContext valContext, org.hl7.fhir.r5.elementmodel.Element element, String path, ElementDefinition slicer, List<ElementDefinition> slicerSlices, ElementDefinition ed, StructureDefinition profile, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, NodeStack stack, StructureDefinition srcProfile) throws DefinitionException, FHIRException {
        ValidationContext shc;
        boolean pass;
        if (!slicer.getSlicing().hasDiscriminator()) {
            return false;
        }
        ExpressionNode n = (ExpressionNode)ed.getUserData("slice.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            StringBuilder expression = new StringBuilder("true");
            boolean anyFound = false;
            HashSet<String> discriminators = new HashSet<String>();
            for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent s : slicer.getSlicing().getDiscriminator()) {
                String discriminator = s.getPath();
                discriminators.add(discriminator);
                List<ElementDefinition> criteriaElements = this.getCriteriaForDiscriminator(path, ed, discriminator, profile, s.getType() == ElementDefinition.DiscriminatorType.PROFILE, srcProfile);
                boolean found = false;
                for (ElementDefinition criteriaElement : criteriaElements) {
                    found = true;
                    if ("0".equals(criteriaElement.getMax())) {
                        expression.append(" and " + discriminator + ".empty()");
                    } else if (s.getType() == ElementDefinition.DiscriminatorType.TYPE) {
                        String type = null;
                        if (!criteriaElement.getPath().contains("[") && discriminator.contains("[")) {
                            discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            String lastNode = this.tail(discriminator);
                            type = this.makeTypeForFHIRPath(criteriaElement.getPath()).substring(lastNode.length());
                        } else if (!criteriaElement.hasType() || criteriaElement.getType().size() == 1) {
                            if (discriminator.contains("[")) {
                                discriminator = discriminator.substring(0, discriminator.indexOf(91));
                            }
                            if (criteriaElement.hasType()) {
                                type = this.makeTypeForFHIRPath(((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getWorkingCode());
                            } else {
                                if (criteriaElement.getPath().contains(".")) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", new Object[]{discriminator, ed.getId(), profile.getVersionedUrl()}));
                                type = this.makeTypeForFHIRPath(criteriaElement.getPath());
                            }
                        } else {
                            if (criteriaElement.getType().size() <= 1) throw new DefinitionException(this.context.formatMessage("Discriminator__is_based_on_type_but_slice__in__has_no_types", new Object[]{discriminator, ed.getId(), profile.getVersionedUrl()}));
                            throw new DefinitionException(this.context.formatMessagePlural(Integer.valueOf(criteriaElement.getType().size()), "Discriminator__is_based_on_type_but_slice__in__has_multiple_types", new Object[]{discriminator, ed.getId(), profile.getVersionedUrl(), criteriaElement.typeSummary()}));
                        }
                        if (discriminator.isEmpty()) {
                            expression.append(" and $this is " + type);
                        } else {
                            expression.append(" and " + discriminator + " is " + type);
                        }
                    } else if (s.getType() == ElementDefinition.DiscriminatorType.PROFILE) {
                        List list;
                        if (criteriaElement.getType().size() == 0) {
                            throw new DefinitionException(this.context.formatMessage("Profile_based_discriminators_must_have_a_type__in_profile_", new Object[]{criteriaElement.getId(), profile.getVersionedUrl()}));
                        }
                        if (criteriaElement.getType().size() != 1) {
                            throw new DefinitionException(this.context.formatMessagePlural(Integer.valueOf(criteriaElement.getType().size()), "Profile_based_discriminators_must_have_only_one_type__in_profile", new Object[]{criteriaElement.getId(), profile.getVersionedUrl()}));
                        }
                        List list2 = list = discriminator.endsWith(".resolve()") || discriminator.equals("resolve()") ? ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getTargetProfile() : ((ElementDefinition.TypeRefComponent)criteriaElement.getType().get(0)).getProfile();
                        if (list.size() != 0) {
                            if (list.size() > 1) {
                                CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(" or ");
                                for (CanonicalType c : list) {
                                    b.append(discriminator + ".conformsTo('" + (String)c.getValue() + "')");
                                }
                                expression.append(" and (" + b + ")");
                            } else {
                                expression.append(" and " + discriminator + ".conformsTo('" + (String)((CanonicalType)list.get(0)).getValue() + "')");
                            }
                        }
                    } else if (s.getType() == ElementDefinition.DiscriminatorType.EXISTS) {
                        if (criteriaElement.hasMin() && criteriaElement.getMin() >= 1) {
                            expression.append(" and (" + discriminator + ".exists())");
                        } else {
                            if (!criteriaElement.hasMax() || !criteriaElement.getMax().equals("0")) throw new FHIRException(this.context.formatMessage("Discriminator__is_based_on_element_existence_but_slice__neither_sets_min1_or_max0", new Object[]{discriminator, ed.getId()}));
                            expression.append(" and (" + discriminator + ".exists().not())");
                        }
                    } else {
                        if (s.getType() == ElementDefinition.DiscriminatorType.POSITION) {
                            if (slicer.getSlicing().getDiscriminator().size() != 1) {
                                throw new DefinitionException(this.context.formatMessagePlural(Integer.valueOf(slicer.getSlicing().getDiscriminator().size()), "Could_not_match_discriminator_for_slice_in_profile", new Object[]{discriminators, ed.getId(), profile.getVersionedUrl(), discriminators}));
                            }
                            int offset = 0;
                            for (ElementDefinition ts : slicerSlices) {
                                if (ts == ed) break;
                                if (!ts.getMax().equals(Integer.toString(ts.getMin()))) {
                                    throw new DefinitionException(this.context.formatMessagePlural(Integer.valueOf(slicer.getSlicing().getDiscriminator().size()), "Could_not_match_discriminator_for_slice_in_profile", new Object[]{discriminators, ed.getId(), profile.getVersionedUrl(), discriminators}));
                                }
                                offset += ts.getMin();
                            }
                            int maxPos = ed.getMax().equals("*") ? Integer.MAX_VALUE : offset + Integer.parseInt(ed.getMax());
                            int position = path.endsWith("]") ? Integer.parseInt(path.substring(path.lastIndexOf("[") + 1).replace("]", "")) : 0;
                            if (position < offset) return false;
                            if (position >= maxPos) return false;
                            return true;
                        }
                        if (criteriaElement.hasFixed()) {
                            this.buildFixedExpression(ed, expression, discriminator, criteriaElement);
                        } else if (criteriaElement.hasPattern()) {
                            this.buildPattternExpression(ed, expression, discriminator, criteriaElement);
                        } else if (criteriaElement.hasBinding() && criteriaElement.getBinding().hasStrength() && criteriaElement.getBinding().getStrength().equals((Object)Enumerations.BindingStrength.REQUIRED) && criteriaElement.getBinding().hasValueSet()) {
                            expression.append(" and (" + discriminator + " memberOf '" + criteriaElement.getBinding().getValueSet() + "')");
                        } else {
                            found = false;
                        }
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                anyFound = true;
            }
            if (!anyFound) {
                throw new DefinitionException(this.context.formatMessagePlural(Integer.valueOf(slicer.getSlicing().getDiscriminator().size()), "Could_not_match_discriminator_for_slice_in_profile", new Object[]{discriminators, ed.getId(), profile.getVersionedUrl(), discriminators}));
            }
            try {
                n = this.fpe.parse(FHIRPathExpressionFixer.fixExpr(expression.toString(), null, this.context.getVersion()));
            }
            catch (FHIRLexer.FHIRLexerException e) {
                throw new FHIRException(this.context.formatMessage("Problem_processing_expression__in_profile__path__", new Object[]{expression, profile.getVersionedUrl(), path, e.getMessage()}));
            }
            this.timeTracker.fpe(t);
            ed.setUserData("slice.expression.cache", (Object)n);
        }
        if (pass = this.evaluateSlicingExpression(shc = valContext.forSlicing(), element, path, profile, n)) return pass;
        this.slicingHint(sliceInfo, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.isProfile(slicer), this.context.formatMessage("Does_not_match_slice_", new Object[]{ed.getSliceName(), n.toString().substring(8).trim()}), "discriminator = " + Utilities.escapeXml((String)n.toString()), null);
        Iterator<String> iterator = shc.getSliceRecords().keySet().iterator();
        while (iterator.hasNext()) {
            String url = iterator.next();
            StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.slicingHint(sliceInfo, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, false, this.isProfile(slicer), this.context.formatMessage("Details_for__matching_against_Profile_", new Object[]{stack.getLiteralPath(), sdt == null ? url : sdt.getVersionedUrl()}), this.context.formatMessage("Profile__does_not_match_for__because_of_the_following_profile_issues__", new Object[]{url, stack.getLiteralPath(), this.errorSummaryForSlicingAsHtml(shc.getSliceRecords().get(url))}), this.errorSummaryForSlicingAsText(shc.getSliceRecords().get(url)));
        }
        return pass;
    }

    private String makeTypeForFHIRPath(String type) {
        if (Utilities.isAbsoluteUrl((String)type)) {
            if (type.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                return this.typeTail(type);
            }
            if (type.startsWith("http://hl7.org/cda/stds/core/StructureDefinition/")) {
                Object tt = this.typeTail(type);
                if (((String)tt).contains("-")) {
                    tt = "`" + ((String)tt).replace("-", "_") + "`";
                }
                return "CDA." + (String)tt;
            }
            return this.typeTail(type);
        }
        String ptype = type.substring(0, 1).toLowerCase() + type.substring(1);
        if (this.context.isPrimitiveType(ptype)) {
            return ptype;
        }
        return type;
    }

    private String typeTail(String type) {
        return type.contains("/") ? type.substring(type.lastIndexOf("/") + 1) : type;
    }

    private boolean isBaseDefinition(String url) {
        boolean b = url.startsWith("http://hl7.org/fhir/") && !url.substring(40).contains("/");
        return b;
    }

    private String descSD(String url) {
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
        return sd == null ? url : sd.present();
    }

    private boolean isProfile(ElementDefinition slicer) {
        if (slicer == null || !slicer.hasSlicing()) {
            return false;
        }
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : slicer.getSlicing().getDiscriminator()) {
            if (t.getType() != ElementDefinition.DiscriminatorType.PROFILE) continue;
            return true;
        }
        return false;
    }

    public boolean evaluateSlicingExpression(ValidationContext valContext, org.hl7.fhir.r5.elementmodel.Element element, String path, StructureDefinition profile, ExpressionNode n) throws FHIRException {
        boolean pass;
        try {
            long t = System.nanoTime();
            pass = this.fpe.evaluateToBoolean((Object)valContext.forProfile(profile), (Base)valContext.getResource(), (Base)valContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t);
            String msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            throw new FHIRException(this.context.formatMessage("Problem_evaluating_slicing_expression_for_element_in_profile__path__fhirPath___", new Object[]{profile.getVersionedUrl(), path, n, ex.getMessage()}));
        }
        return pass;
    }

    private void buildPattternExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType pattern = criteriaElement.getPattern();
        if (pattern instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)pattern;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (pattern instanceof Coding) {
            Coding c = (Coding)pattern;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else if (pattern instanceof BooleanType || pattern instanceof IntegerType || pattern instanceof DecimalType) {
            expression.append(" and ");
            this.buildPrimitiveExpression(ed, expression, discriminator, pattern, false);
        } else if (pattern instanceof PrimitiveType) {
            expression.append(" and ");
            this.buildPrimitiveExpression(ed, expression, discriminator, pattern, true);
        } else if (pattern instanceof Identifier) {
            Identifier ii = (Identifier)pattern;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else if (pattern instanceof HumanName) {
            HumanName name = (HumanName)pattern;
            expression.append(" and ");
            this.buildHumanNameExpression(ed, expression, discriminator, name);
        } else if (pattern instanceof Address) {
            Address add = (Address)pattern;
            expression.append(" and ");
            this.buildAddressExpression(ed, expression, discriminator, add);
        } else {
            throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_pattern_type_for_discriminator_for_slice__", new Object[]{discriminator, ed.getId(), pattern.fhirType()}));
        }
    }

    private void buildIdentifierExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Identifier ii) throws DefinitionException {
        if (ii.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (ii.hasSystem()) {
            first = false;
            expression.append("system = '" + ii.getSystem() + "'");
        }
        if (ii.hasValue()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("value = '" + ii.getValue() + "'");
        }
        if (ii.hasUse()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("use = '" + ii.getUse() + "'");
        }
        if (ii.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            this.buildCodeableConceptExpression(ed, expression, "type", ii.getType());
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), ii.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildHumanNameExpression(ElementDefinition ed, StringBuilder expression, String discriminator, HumanName name) throws DefinitionException {
        if (name.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (name.hasUse()) {
            first = false;
            expression.append("use = '" + name.getUse().toCode() + "'");
        }
        if (name.hasText()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("text = '" + name.getText() + "'");
        }
        if (name.hasFamily()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("family = '" + name.getFamily() + "'");
        }
        if (name.hasGiven()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "given"}));
        }
        if (name.hasPrefix()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "prefix"}));
        }
        if (name.hasSuffix()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "suffix"}));
        }
        if (name.hasPeriod()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType(), "period"}));
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), name.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildAddressExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Address add) throws DefinitionException {
        if (add.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_Identifier_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean first = true;
        expression.append(discriminator + ".where(");
        if (add.hasUse()) {
            first = false;
            expression.append("use = '" + add.getUse().toCode() + "'");
        }
        if (add.hasType()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("type = '" + add.getType().toCode() + "'");
        }
        if (add.hasText()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("text = '" + add.getText() + "'");
        }
        if (add.hasCity()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("city = '" + add.getCity() + "'");
        }
        if (add.hasDistrict()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("district = '" + add.getDistrict() + "'");
        }
        if (add.hasState()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("state = '" + add.getState() + "'");
        }
        if (add.hasPostalCode()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("postalCode = '" + add.getPostalCode() + "'");
        }
        if (add.hasCountry()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("country = '" + add.getCountry() + "'");
        }
        if (add.hasLine()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType(), "line"}));
        }
        if (add.hasPeriod()) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType(), "period"}));
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), add.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildCodeableConceptExpression(ElementDefinition ed, StringBuilder expression, String discriminator, CodeableConcept cc) throws DefinitionException {
        if (cc.hasText()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__using_text__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (!cc.hasCoding()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__must_have_at_least_one_coding__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (cc.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        boolean firstCoding = true;
        for (Coding c : cc.getCoding()) {
            if (c.hasExtension()) {
                throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
            }
            if (firstCoding) {
                firstCoding = false;
            } else {
                expression.append(" and ");
            }
            expression.append(discriminator + ".coding.where(");
            boolean first = true;
            if (c.hasSystem()) {
                first = false;
                expression.append("system = '" + c.getSystem() + "'");
            }
            if (c.hasVersion()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("version = '" + c.getVersion() + "'");
            }
            if (c.hasCode()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("code = '" + c.getCode() + "'");
            }
            if (c.hasDisplay()) {
                if (first) {
                    first = false;
                } else {
                    expression.append(" and ");
                }
                expression.append("display = '" + c.getDisplay() + "'");
            }
            if (first) {
                throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), cc.fhirType()}));
            }
            expression.append(").exists()");
        }
    }

    private void buildCodingExpression(ElementDefinition ed, StringBuilder expression, String discriminator, Coding c) throws DefinitionException {
        if (c.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        expression.append(discriminator + ".where(");
        boolean first = true;
        if (c.hasSystem()) {
            first = false;
            expression.append("system = '" + c.getSystem() + "'");
        }
        if (c.hasVersion()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("version = '" + c.getVersion() + "'");
        }
        if (c.hasCode()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("code = '" + c.getCode() + "'");
        }
        if (c.hasDisplay()) {
            if (first) {
                first = false;
            } else {
                expression.append(" and ");
            }
            expression.append("display = '" + c.getDisplay() + "'");
        }
        if (first) {
            throw new DefinitionException(this.context.formatMessage("UNSUPPORTED_IDENTIFIER_PATTERN_NO_PROPERTY_NOT_SUPPORTED_FOR_DISCRIMINATOR_FOR_SLICE", new Object[]{discriminator, ed.getId(), c.fhirType()}));
        }
        expression.append(").exists()");
    }

    private void buildPrimitiveExpression(ElementDefinition ed, StringBuilder expression, String discriminator, DataType p, boolean quotes) throws DefinitionException {
        if (p.hasExtension()) {
            throw new DefinitionException(this.context.formatMessage("Unsupported_CodeableConcept_pattern__extensions_are_not_allowed__for_discriminator_for_slice_", new Object[]{discriminator, ed.getId()}));
        }
        if (quotes) {
            expression.append(discriminator + ".where(value = '" + p.primitiveValue() + "'");
        } else {
            expression.append(discriminator + ".where(value = " + p.primitiveValue());
        }
        expression.append(").exists()");
    }

    private void buildFixedExpression(ElementDefinition ed, StringBuilder expression, String discriminator, ElementDefinition criteriaElement) throws DefinitionException {
        DataType fixed = criteriaElement.getFixed();
        if (fixed instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)fixed;
            expression.append(" and ");
            this.buildCodeableConceptExpression(ed, expression, discriminator, cc);
        } else if (fixed instanceof Identifier) {
            Identifier ii = (Identifier)fixed;
            expression.append(" and ");
            this.buildIdentifierExpression(ed, expression, discriminator, ii);
        } else if (fixed instanceof Coding) {
            Coding c = (Coding)fixed;
            expression.append(" and ");
            this.buildCodingExpression(ed, expression, discriminator, c);
        } else {
            expression.append(" and (");
            if (fixed instanceof StringType) {
                String es = Utilities.escapeJson((String)fixed.primitiveValue());
                expression.append("'" + es + "'");
            } else if (fixed instanceof UriType) {
                expression.append("'" + ((UriType)fixed).asStringValue() + "'");
            } else if (fixed instanceof IntegerType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof DecimalType) {
                expression.append(((IntegerType)fixed).asStringValue());
            } else if (fixed instanceof BooleanType) {
                expression.append(((BooleanType)fixed).asStringValue());
            } else {
                throw new DefinitionException(this.context.formatMessage("Unsupported_fixed_value_type_for_discriminator_for_slice__", new Object[]{discriminator, ed.getId(), fixed.getClass().getName()}));
            }
            expression.append(" in " + discriminator + ")");
        }
    }

    private boolean start(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack, PercentageTracker pct, Base.ValidationMode mode, boolean fromContained) throws FHIRException {
        org.hl7.fhir.r5.elementmodel.Element meta;
        boolean ok = !this.hasErrors(errors);
        this.checkLang(resource, stack);
        if (this.crumbTrails) {
            element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST", defn.getVersionedUrl()));
        }
        boolean pctOwned = false;
        if (pct == null) {
            pctOwned = true;
            pct = new PercentageTracker(resource.countDescendents() + 1, resource.fhirType(), defn.getVersionedUrl(), this.logProgress);
        }
        if ("Bundle".equals(element.fhirType())) {
            if (this.debug) {
                System.out.println("Resolve Bundle Entries " + this.time());
            }
            this.resolveBundleReferences(element, new ArrayList<org.hl7.fhir.r5.elementmodel.Element>());
        }
        boolean bl = ok = this.startInner(valContext, errors, resource, element, defn, stack, valContext.isCheckSpecials(), pct, mode, fromContained) && ok;
        if (pctOwned) {
            pct.done();
        }
        if (defn.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
            for (Extension ext : defn.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
                StructureDefinition sdi = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ext.getValue().primitiveValue());
                if (sdi == null) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), false, "VALIDATION_VAL_PROFILE_DEPENDS_NOT_RESOLVED", ext.getValue().primitiveValue(), defn.getVersionedUrl());
                    continue;
                }
                if (this.crumbTrails) {
                    element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_DEP", sdi.getUrl(), defn.getVersionedUrl()));
                }
                stack.resetIds();
                if (pctOwned) {
                    pct = new PercentageTracker(resource.countDescendents(), resource.fhirType(), sdi.getUrl(), this.logProgress);
                }
                boolean bl2 = ok = this.startInner(valContext, errors, resource, element, sdi, stack, false, pct, mode.withSource(Base.ProfileSource.ProfileDependency), fromContained) && ok;
                if (!pctOwned) continue;
                pct.done();
            }
        }
        if ((meta = element.getNamedChild("meta", false)) != null) {
            ArrayList profiles = new ArrayList();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element profile : profiles) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile.primitiveValue());
                if (!defn.getUrl().equals(profile.primitiveValue())) {
                    VersionUtilities.VersionURLInfo vu = VersionUtilities.parseVersionUrl((String)profile.primitiveValue());
                    if (vu != null) {
                        if (!VersionUtilities.versionsCompatible((String)vu.getVersion(), (String)this.context.getVersion())) {
                            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_OTHER_VERSION", vu.getVersion());
                        } else if (vu.getUrl().equals(defn.getUrl())) {
                            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_THIS_VERSION_OK");
                        } else {
                            StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, vu.getUrl());
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_THIS_VERSION_OTHER", sdt == null ? "null" : sdt.getType()) && ok;
                        }
                    } else {
                        if (sd == null) {
                            if (this.fetcher == null) {
                                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "Validation_VAL_Profile_Unknown", profile.primitiveValue());
                            } else if (!this.fetcher.fetchesCanonicalResource((IResourceValidator)this, profile.primitiveValue())) {
                                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_NOT_POLICY", profile.primitiveValue());
                            } else {
                                sd = this.lookupProfileReference(valContext, errors, element, stack, i, profile, sd);
                            }
                        }
                        if (sd != null) {
                            if (this.crumbTrails) {
                                element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_META", sd.getVersionedUrl()));
                            }
                            stack.resetIds();
                            if (pctOwned) {
                                pct = new PercentageTracker(resource.countDescendents(), resource.fhirType(), sd.getUrl(), this.logProgress);
                            }
                            boolean bl3 = ok = this.startInner(valContext, errors, resource, element, sd, stack, false, pct, mode.withSource(Base.ProfileSource.MetaProfile), fromContained) && ok;
                            if (pctOwned) {
                                pct.done();
                            }
                            if (sd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
                                for (Extension ext : sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile")) {
                                    StructureDefinition sdi = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ext.getValue().primitiveValue());
                                    if (sdi == null) {
                                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_DEPENDS_NOT_RESOLVED", ext.getValue().primitiveValue(), sd.getVersionedUrl());
                                        continue;
                                    }
                                    if (this.crumbTrails) {
                                        element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_DEP", sdi.getUrl(), sd.getVersionedUrl()));
                                    }
                                    stack.resetIds();
                                    if (pctOwned) {
                                        pct = new PercentageTracker(resource.countDescendents(), resource.fhirType(), sdi.getUrl(), this.logProgress);
                                    }
                                    boolean bl4 = ok = this.startInner(valContext, errors, resource, element, sdi, stack, false, pct, mode.withSource(Base.ProfileSource.ProfileDependency), fromContained) && ok;
                                    if (!pctOwned) continue;
                                    pct.done();
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        String rt = element.fhirType();
        for (ImplementationGuide ig : this.igs) {
            for (ImplementationGuide.ImplementationGuideGlobalComponent gl : ig.getGlobal()) {
                if (!rt.equals(gl.getType())) continue;
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, gl.getProfile(), (Resource)ig);
                if (!this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), sd != null, "VALIDATION_VAL_GLOBAL_PROFILE_UNKNOWN", gl.getProfile(), ig.getVersionedUrl())) continue;
                if (this.crumbTrails) {
                    element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_GLOBAL", sd.getVersionedUrl(), ig.getVersionedUrl()));
                }
                stack.resetIds();
                if (pctOwned) {
                    pct = new PercentageTracker(resource.countDescendents(), resource.fhirType(), sd.getVersionedUrl(), this.logProgress);
                }
                boolean bl5 = ok = this.startInner(valContext, errors, resource, element, sd, stack, false, pct, mode.withSource(Base.ProfileSource.GlobalProfile), fromContained) && ok;
                if (!pctOwned) continue;
                pct.done();
            }
        }
        return ok;
    }

    private StructureDefinition lookupProfileReference(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, int i, org.hl7.fhir.r5.elementmodel.Element profile, StructureDefinition sd) {
        String url = profile.primitiveValue();
        CanonicalResourceLookupResult cr = this.crLookups.get(url);
        if (cr != null) {
            if (cr.getError() != null) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_ERROR", url, cr.getError());
            } else {
                sd = (StructureDefinition)cr.getResource();
            }
        } else {
            try {
                sd = (StructureDefinition)this.fetcher.fetchCanonicalResource((IResourceValidator)this, valContext.getAppContext(), url);
                this.crLookups.put(url, new CanonicalResourceLookupResult((CanonicalResource)sd));
            }
            catch (Exception e) {
                this.crLookups.put(url, new CanonicalResourceLookupResult(e.getMessage()));
                if (e.getMessage() != null && e.getMessage().startsWith("java.net.UnknownHostException:")) {
                    try {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_ERROR_NETWORK", profile.primitiveValue(), new URI(url).getHost());
                    }
                    catch (URISyntaxException e1) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_ERROR_NETWORK", profile.primitiveValue(), "??");
                    }
                }
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath() + ".meta.profile[" + i + "]", false, "VALIDATION_VAL_PROFILE_UNKNOWN_ERROR", profile.primitiveValue(), e.getMessage());
            }
            if (sd != null) {
                this.context.cacheResource((Resource)sd);
            }
        }
        return sd;
    }

    private void resolveBundleReferences(org.hl7.fhir.r5.elementmodel.Element element, List<org.hl7.fhir.r5.elementmodel.Element> bundles) {
        if (!element.hasUserData("validator.bundle.resolved")) {
            element.setUserData("validator.bundle.resolved", (Object)true);
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> list = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            list.addAll(bundles);
            list.add(0, element);
            List entries = element.getChildrenByName("entry");
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                String fu = entry.getChildValue("fullUrl");
                org.hl7.fhir.r5.elementmodel.Element r = entry.getNamedChild("resource", false);
                if (r == null) continue;
                this.resolveBundleReferencesInResource(list, r, fu);
            }
        }
    }

    private void resolveBundleReferencesInResource(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element r, String fu) {
        if ("Bundle".equals(r.fhirType())) {
            this.resolveBundleReferences(r, bundles);
        } else {
            for (org.hl7.fhir.r5.elementmodel.Element child : r.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, r, fu, child);
            }
        }
    }

    private void resolveBundleReferencesForElement(List<org.hl7.fhir.r5.elementmodel.Element> bundles, org.hl7.fhir.r5.elementmodel.Element resource, String fu, org.hl7.fhir.r5.elementmodel.Element element) {
        block3: {
            block2: {
                if (!"Reference".equals(element.fhirType())) break block2;
                String ref = element.getChildValue("reference");
                if (Utilities.noString((String)ref)) break block3;
                for (org.hl7.fhir.r5.elementmodel.Element bundle : bundles) {
                    List entries;
                    org.hl7.fhir.r5.elementmodel.Element tgt = this.resolveInBundle(bundle, entries = bundle.getChildren("entry"), ref, fu, resource.fhirType(), resource.getIdBase(), null, null, null, element, false, false);
                    if (tgt == null) continue;
                    element.setUserData("validator.bundle.resolution", (Object)tgt.getNamedChild("resource", false));
                    return;
                }
                break block3;
            }
            for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
                this.resolveBundleReferencesForElement(bundles, resource, fu, child);
            }
        }
    }

    private static void addMessagesReplaceExistingIfMoreSevere(List<ValidationMessage> errors, List<ValidationMessage> newErrors) {
        for (ValidationMessage newError : newErrors) {
            int index = InstanceValidator.indexOfMatchingMessageAndLocation(errors, newError);
            if (index == -1) {
                errors.add(newError);
                continue;
            }
            ValidationMessage existingError = errors.get(index);
            if (newError.getLevel().ordinal() >= existingError.getLevel().ordinal()) continue;
            errors.set(index, newError);
        }
    }

    private static int indexOfMatchingMessageAndLocation(List<ValidationMessage> messages, ValidationMessage message) {
        for (int i = 0; i < messages.size(); ++i) {
            ValidationMessage iMessage = messages.get(i);
            if (message.getMessage() == null || !message.getMessage().equals(iMessage.getMessage()) || message.getLocation() == null || !message.getLocation().equals(iMessage.getLocation())) continue;
            return i;
        }
        return -1;
    }

    public boolean startInner(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, NodeStack stack, boolean checkSpecials, PercentageTracker pct, Base.ValidationMode mode, boolean fromContained) {
        boolean ok = true;
        ResourceValidationTracker resTracker = this.getResourceTracker(element);
        List<ValidationMessage> cachedErrors = resTracker.getOutcomes(defn);
        if (cachedErrors != null) {
            for (ValidationMessage vm : cachedErrors) {
                if (errors.contains(vm)) continue;
                errors.add(vm);
                ok = vm.getLevel() != ValidationMessage.IssueSeverity.ERROR && vm.getLevel() != ValidationMessage.IssueSeverity.FATAL && ok;
            }
            return ok;
        }
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), defn.hasSnapshot(), "Validation_VAL_Profile_NoSnapshot", defn.getVersionedUrl())) {
            ArrayList<ValidationMessage> localErrors = new ArrayList<ValidationMessage>();
            resTracker.startValidating(defn);
            this.trackUsage(defn, valContext, element);
            ok = this.validateElement(valContext, localErrors, defn, (ElementDefinition)defn.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false, true, null, pct, mode) && ok;
            resTracker.storeOutcomes(defn, localErrors);
            InstanceValidator.addMessagesReplaceExistingIfMoreSevere(errors, localErrors);
        } else {
            ok = false;
        }
        if (checkSpecials) {
            ok = this.checkSpecials(valContext, errors, element, stack, checkSpecials, pct, mode, fromContained, ok) && ok;
            ok = this.validateResourceRules(errors, element, stack) && ok;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSpecials(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean checkSpecials, PercentageTracker pct, Base.ValidationMode mode, boolean contained, boolean isOk) {
        boolean ok = true;
        List profiles = this.policyAdvisor.getImpliedProfilesForResource((IResourceValidator)this, valContext.getAppContext(), stack.getLiteralPath(), element.getProperty().getDefinition(), element.getProperty().getStructure(), element, isOk, (IMessagingServices)this, errors);
        for (StructureDefinition sd : profiles) {
            ok = this.startInner(valContext, errors, element, element, sd, stack, false, pct, mode, false) && ok;
        }
        long t = System.nanoTime();
        try {
            if (VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(element.getType())) {
                Base base = element.getExtensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
                String standardsStatus = base != null && base.isPrimitive() ? base.primitiveValue() : null;
                String status = element.getNamedChildValue("status", false);
                if (!Utilities.noString((String)status) && !Utilities.noString((String)standardsStatus) && this.warning(errors, "2023-08-14", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), this.statusCodesConsistent(status, standardsStatus), "VALIDATION_VAL_STATUS_INCONSISTENT", status, standardsStatus)) {
                    this.hint(errors, "2023-08-14", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), this.statusCodesDeeplyConsistent(status, standardsStatus), "VALIDATION_VAL_STATUS_INCONSISTENT_HINT", status, standardsStatus);
                }
                if (this.noExperimentalContent) {
                    String exp = element.getNamedChildValue("experimental");
                    boolean bl = ok = this.rule(errors, "2024-09-17", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), !"true".equals(exp), "VALIDATION_NO_EXPERIMENTAL_CONTENT", new Object[0]) && ok;
                }
                if (this.isHL7Core(element) && !this.isExample()) {
                    boolean bl = ok = this.checkPublisherConsistency(valContext, errors, element, stack, contained) && ok;
                }
            }
            if (element.getType().equals("Bundle")) {
                boolean base = new BundleValidator(this, this.serverBase).validateBundle(errors, element, stack, checkSpecials, valContext, pct, mode) && ok;
                return base;
            }
            if (element.getType().equals("Observation")) {
                boolean base = new ObservationValidator(this).validateObservation(valContext, errors, element, stack, pct, mode) && ok;
                return base;
            }
            if (element.getType().equals("Questionnaire")) {
                boolean base = new QuestionnaireValidator(this, this.myEnableWhenEvaluator, this.fpe, this.questionnaireMode).validateQuestionannaire(errors, element, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("QuestionnaireResponse")) {
                boolean base = new QuestionnaireValidator(this, this.myEnableWhenEvaluator, this.fpe, this.questionnaireMode).validateQuestionannaireResponse(valContext, errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("Measure")) {
                boolean base = new MeasureValidator(this).validateMeasure(valContext, errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("MeasureReport")) {
                boolean base = new MeasureValidator(this).validateMeasureReport(valContext, errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("CapabilityStatement")) {
                boolean base = this.validateCapabilityStatement(errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("CodeSystem")) {
                boolean base = new CodeSystemValidator(this).validateCodeSystem(valContext, errors, element, stack, this.baseOptions.withLanguage(stack.getWorkingLang())) && ok;
                return base;
            }
            if (element.getType().equals("ConceptMap")) {
                boolean base = new ConceptMapValidator(this).validateConceptMap(valContext, errors, element, stack, this.baseOptions.withLanguage(stack.getWorkingLang())) && ok;
                return base;
            }
            if (element.getType().equals("SearchParameter")) {
                boolean base = new SearchParameterValidator(this, this.fpe).validateSearchParameter(errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("StructureDefinition")) {
                boolean base = new StructureDefinitionValidator(this, this.fpe, this.wantCheckSnapshotUnchanged).validateStructureDefinition(errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("StructureMap")) {
                boolean base = new StructureMapValidator(this, this.fpe, this.profileUtilities).validateStructureMap(valContext, errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("ValueSet")) {
                boolean base = new ValueSetValidator(this).validateValueSet(valContext, errors, element, stack) && ok;
                return base;
            }
            if (element.getType().equals("ImplementationGuide")) {
                boolean base = new ImplementationGuideValidator(this.context, this.xverManager, this.debug).validateImplementationGuide(valContext, errors, element, stack) && ok;
                return base;
            }
            if ("http://hl7.org/fhir/uv/sql-on-fhir/StructureDefinition/ViewDefinition".equals(element.getProperty().getStructure().getUrl())) {
                if (element.getNativeObject() != null && element.getNativeObject() instanceof JsonObject) {
                    JsonObject json = (JsonObject)element.getNativeObject();
                    Validator sqlv = new Validator(this.context, this.fpe, new ArrayList(), Validator.TrueFalseOrUnknown.UNKNOWN, Validator.TrueFalseOrUnknown.UNKNOWN, Validator.TrueFalseOrUnknown.UNKNOWN);
                    sqlv.checkViewDefinition(stack.getLiteralPath(), json);
                    errors.addAll(sqlv.getIssues());
                    ok = sqlv.isOk() && ok;
                }
                boolean bl = ok;
                return bl;
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            this.timeTracker.spec(t);
        }
    }

    private boolean checkPublisherConsistency(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean contained) {
        boolean ok = true;
        String pub = element.getNamedChildValue("publisher", false);
        ok = this.rule(errors, "2024-08-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), element.getExtensions("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg").size() <= 1, "VALIDATION_HL7_PUBLISHER_MULTIPLE_WGS", new Object[0]) && ok;
        Base wgT = element.getExtensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        String wg = wgT == null ? null : wgT.primitiveValue();
        String url = element.getNamedChildValue("url");
        if (contained && wg == null) {
            org.hl7.fhir.r5.elementmodel.Element container = valContext.getRootResource();
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) {
                HL7WorkGroups.HL7WorkGroup wgd;
                if (pub != null && (wgd = HL7WorkGroups.find((String)(wg = (wgT = container.getExtensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) == null ? null : wgT.primitiveValue()))) != null) {
                    String rpub = "HL7 International / " + wgd.getName();
                    ok = rpub.equals(pub);
                    if (!ok && wgd.getName2() != null) {
                        ok = ("HL7 International / " + wgd.getName2()).equals(pub);
                        this.warningOrError(pub.contains("/"), errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), ok, "VALIDATION_HL7_PUBLISHER_MISMATCH2", wg, rpub, "HL7 International / " + wgd.getName2(), pub);
                    } else {
                        this.warningOrError(pub.contains("/"), errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), ok, "VALIDATION_HL7_PUBLISHER_MISMATCH", wg, rpub, pub);
                    }
                }
                return ok;
            }
        }
        ArrayList<String> urls = new ArrayList<String>();
        for (org.hl7.fhir.r5.elementmodel.Element c : element.getChildren("contact")) {
            for (org.hl7.fhir.r5.elementmodel.Element t : c.getChildren("telecom")) {
                if (!"url".equals(t.getNamedChildValue("system", false)) || t.getNamedChildValue("value", false) == null) continue;
                urls.add(t.getNamedChildValue("value", false));
            }
        }
        if (this.rule(errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), wg != null || url.contains("http://hl7.org/fhir/sid"), "VALIDATION_HL7_WG_NEEDED", "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg")) {
            if (wg != null) {
                HL7WorkGroups.HL7WorkGroup wgd = HL7WorkGroups.find((String)wg);
                if (this.rule(errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), wgd != null, "VALIDATION_HL7_WG_UNKNOWN", wg)) {
                    String rpub = "HL7 International / " + wgd.getName();
                    if (this.warning(errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), pub != null, "VALIDATION_HL7_PUBLISHER_MISSING", wg, rpub)) {
                        boolean bl = ok = rpub.equals(pub) && ok;
                        if (!ok && wgd.getName2() != null) {
                            ok = ("HL7 International / " + wgd.getName2()).equals(pub) && ok;
                            this.warningOrError(pub.contains("/"), errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), ok, "VALIDATION_HL7_PUBLISHER_MISMATCH2", wg, rpub, "HL7 International / " + wgd.getName2(), pub);
                        } else {
                            this.warningOrError(pub.contains("/"), errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), ok, "VALIDATION_HL7_PUBLISHER_MISMATCH", wg, rpub, pub);
                        }
                    }
                    this.warning(errors, "2023-09-15", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), Utilities.startsWithInList((String)wgd.getLink(), urls), "VALIDATION_HL7_WG_URL", wg, wgd.getLink());
                    return ok;
                }
            } else {
                return ok;
            }
        }
        return ok;
    }

    private boolean statusCodesConsistent(String status, String standardsStatus) {
        switch (standardsStatus) {
            case "draft": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft"});
            }
            case "normative": {
                return Utilities.existsInList((String)status, (String[])new String[]{"active"});
            }
            case "trial-use": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft", "active"});
            }
            case "informative": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft", "active", "retired"});
            }
            case "deprecated": {
                return Utilities.existsInList((String)status, (String[])new String[]{"retired"});
            }
            case "withdrawn": {
                return Utilities.existsInList((String)status, (String[])new String[]{"retired"});
            }
            case "external": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft", "active", "retired"});
            }
        }
        return true;
    }

    private boolean statusCodesDeeplyConsistent(String status, String standardsStatus) {
        switch (standardsStatus) {
            case "draft": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft"});
            }
            case "normative": {
                return Utilities.existsInList((String)status, (String[])new String[]{"active"});
            }
            case "trial-use": {
                return Utilities.existsInList((String)status, (String[])new String[]{"active"});
            }
            case "informative": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft", "active"});
            }
            case "deprecated": {
                return Utilities.existsInList((String)status, (String[])new String[]{"retired"});
            }
            case "withdrawn": {
                return Utilities.existsInList((String)status, (String[])new String[]{"retired"});
            }
            case "external": {
                return Utilities.existsInList((String)status, (String[])new String[]{"draft", "active"});
            }
        }
        return true;
    }

    private ResourceValidationTracker getResourceTracker(org.hl7.fhir.r5.elementmodel.Element element) {
        ResourceValidationTracker res = this.resourceTracker.get(element);
        if (res == null) {
            res = new ResourceValidationTracker();
            this.resourceTracker.put(element, res);
        }
        return res;
    }

    private void checkLang(org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack) {
        String lang = resource.getNamedChildValue("language", false);
        if (!Utilities.noString((String)lang)) {
            stack.setWorkingLang(lang);
        }
    }

    private boolean validateResourceRules(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        org.hl7.fhir.r5.elementmodel.Element meta;
        boolean ok = true;
        String lang = element.getNamedChildValue("language", false);
        org.hl7.fhir.r5.elementmodel.Element text = element.getNamedChild("text", false);
        if (text != null) {
            XhtmlNode xhtml;
            org.hl7.fhir.r5.elementmodel.Element div = text.getNamedChild("div", false);
            if (lang != null && div != null && (xhtml = div.getXhtml()) != null) {
                String l = xhtml.getAttribute("lang");
                String xl = xhtml.getAttribute("xml:lang");
                if (l == null && xl == null) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing1", new Object[0]);
                } else {
                    if (l == null) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing2", new Object[0]);
                    } else if (!l.equals(lang)) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different1", lang, l);
                    }
                    if (xl == null) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Missing3", new Object[0]);
                    } else if (!xl.equals(lang)) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, div.line(), div.col(), stack.getLiteralPath(), false, "Language_XHTML_Lang_Different2", lang, xl);
                    }
                }
            }
        }
        if ((meta = element.getNamedChild("meta", false)) != null) {
            HashSet<CallSite> tags = new HashSet<CallSite>();
            ArrayList list = new ArrayList();
            meta.getNamedChildren("security", list);
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element e : list) {
                String s = e.getNamedChildValue("system", false) + "#" + e.getNamedChildValue("code", false);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, e.line(), e.col(), stack.getLiteralPath() + ".meta.profile[" + Integer.toString(i) + "]", !tags.contains(s), "Meta_RES_Security_Duplicate", s) && ok;
                tags.add((CallSite)((Object)s));
                ++i;
            }
        }
        return ok;
    }

    private boolean validateCapabilityStatement(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element cs, NodeStack stack) {
        boolean ok = true;
        int iRest = 0;
        for (org.hl7.fhir.r5.elementmodel.Element rest : cs.getChildrenByName("rest")) {
            int iResource = 0;
            for (org.hl7.fhir.r5.elementmodel.Element resource : rest.getChildrenByName("resource")) {
                int iSP = 0;
                for (org.hl7.fhir.r5.elementmodel.Element searchParam : resource.getChildrenByName("searchParam")) {
                    SearchParameter sp;
                    String ref = searchParam.getChildValue("definition");
                    String type = searchParam.getChildValue("type");
                    if (!Utilities.noString((String)ref) && (sp = (SearchParameter)this.context.fetchResource(SearchParameter.class, ref)) != null) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, searchParam.line(), searchParam.col(), stack.getLiteralPath() + ".rest[" + iRest + "].resource[" + iResource + "].searchParam[" + iSP + "]", sp.getType().toCode().equals(type), "CapabalityStatement_CS_SP_WrongType", sp.getVersionedUrl(), sp.getType().toCode(), type) && ok;
                    }
                    ++iSP;
                }
                ++iResource;
            }
            ++iRest;
        }
        return ok;
    }

    private boolean validateContains(ValidationContext valContext, List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, IdStatus idstatus, StructureDefinition parentProfile, PercentageTracker pct, Base.ValidationMode mode) throws FHIRException {
        boolean ok = true;
        if (element.isNull()) {
            if (!this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), ToolingExtensions.readBooleanExtension((Element)child, (String)"http://hl7.org/fhir/tools/StructureDefinition/json-nullable"), "ELEMENT_CANNOT_BE_NULL", new Object[0])) {
                ok = false;
            }
        } else {
            Element.SpecialElement special = element.getSpecial();
            ContainedReferenceValidationPolicy containedValidationPolicy = this.policyAdvisor.policyForContained((IResourceValidator)this, (Object)valContext, parentProfile, child, context.fhirType(), context.getId(), special, path, parentProfile.getUrl());
            if (containedValidationPolicy.ignore()) {
                return ok;
            }
            String resourceName = element.getType();
            ElementDefinition.TypeRefComponent typeForResource = null;
            CommaSeparatedStringBuilder bt = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent type : child.getType()) {
                bt.append(type.getCode());
                if (!type.getCode().equals("Resource") && !type.getCode().equals(resourceName)) continue;
                typeForResource = type;
                break;
            }
            stack.pathComment(resourceName + "/" + element.getIdBase());
            if (typeForResource == null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type", resourceName, bt.toString()) && ok;
            } else if (this.isValidResourceType(resourceName, typeForResource)) {
                if (containedValidationPolicy.checkValid()) {
                    ValidationContext hc = null;
                    if (special == Element.SpecialElement.BUNDLE_ENTRY || special == Element.SpecialElement.BUNDLE_OUTCOME || special == Element.SpecialElement.BUNDLE_ISSUES || special == Element.SpecialElement.PARAMETER) {
                        resource = element;
                        assert (Utilities.existsInList((String)valContext.getResource().fhirType(), (String[])new String[]{"Bundle", "Parameters"})) : "Containing Resource is " + valContext.getResource().fhirType() + ", expected Bundle or Parameters at " + stack.getLiteralPath();
                        hc = valContext.forEntry(element, valContext.getResource());
                    } else {
                        hc = valContext.forContained(element);
                    }
                    stack.resetIds();
                    if (special != null) {
                        switch (special) {
                            case BUNDLE_ENTRY: 
                            case BUNDLE_OUTCOME: 
                            case PARAMETER: {
                                idstatus = IdStatus.OPTIONAL;
                                break;
                            }
                            case CONTAINED: {
                                stack.setContained(true);
                                idstatus = IdStatus.REQUIRED;
                                break;
                            }
                        }
                    }
                    this.checkSpecials(valContext, errors, element, stack, ok, pct, mode, true, ok);
                    if (typeForResource.getProfile().size() == 1) {
                        long t = System.nanoTime();
                        StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, ((CanonicalType)typeForResource.getProfile().get(0)).asStringValue(), (Resource)parentProfile);
                        this.timeTracker.sd(t);
                        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "Bundle_BUNDLE_Entry_NoProfile_EXPL", special == null ? "??" : special.toHuman(), resourceName, ((CanonicalType)typeForResource.getProfile().get(0)).asStringValue())) {
                            this.trackUsage(profile, valContext, element);
                            ok = this.validateResource(hc, errors, resource, element, profile, idstatus, stack, pct, mode, false, special == Element.SpecialElement.CONTAINED) && ok;
                        } else {
                            ok = false;
                        }
                    } else if (typeForResource.getProfile().isEmpty()) {
                        long t = System.nanoTime();
                        StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
                        this.timeTracker.sd(t);
                        this.trackUsage(profile, valContext, element);
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "Bundle_BUNDLE_Entry_NoProfile_TYPE", special == null ? "??" : special.toHuman(), resourceName) ? this.validateResource(hc, errors, resource, element, profile, idstatus, stack, pct, mode, false, special == Element.SpecialElement.CONTAINED) && ok : false;
                    } else {
                        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
                        CommaSeparatedStringBuilder bm = new CommaSeparatedStringBuilder();
                        ArrayList<ArrayList<ValidationMessage>> errorsList = new ArrayList<ArrayList<ValidationMessage>>();
                        int matched = 0;
                        for (CanonicalType u : typeForResource.getProfile()) {
                            b.append(u.asStringValue());
                            long t = System.nanoTime();
                            StructureDefinition profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, u.asStringValue());
                            this.timeTracker.sd(t);
                            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "Bundle_BUNDLE_Entry_NoProfile_TYPE", special == null ? "??" : special.toHuman(), u.asStringValue())) {
                                this.trackUsage(profile, valContext, element);
                                ArrayList<ValidationMessage> perrors = new ArrayList<ValidationMessage>();
                                errorsList.add(perrors);
                                if (!this.validateResource(hc, perrors, resource, element, profile, idstatus, stack, pct, mode, false, special == Element.SpecialElement.CONTAINED)) continue;
                                bm.append(u.asStringValue());
                                ++matched;
                                continue;
                            }
                            ok = false;
                        }
                        if (this.rule(errors, "2023-09-07", ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), matched > 0, "BUNDLE_BUNDLE_ENTRY_MULTIPLE_PROFILES_NO_MATCH", "", special.toHuman(), typeForResource.getCode(), b.toString())) {
                            this.hint(errors, "2023-09-07", ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), matched == 1, "BUNDLE_BUNDLE_ENTRY_MULTIPLE_PROFILES_MULTIPLE_MATCHES", "", special.toHuman(), typeForResource.getCode(), bm.toString());
                        } else {
                            ok = false;
                            for (int i = 0; i < typeForResource.getProfile().size(); ++i) {
                                this.hint(errors, "2023-09-07", ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), matched > 0, "BUNDLE_BUNDLE_ENTRY_MULTIPLE_PROFILES_NO_MATCH_REASON", "", special.toHuman(), ((CanonicalType)typeForResource.getProfile().get(i)).asStringValue(), this.summariseErrors((List)errorsList.get(i)));
                            }
                        }
                    }
                }
            } else {
                ArrayList<String> types = new ArrayList<String>();
                for (UriType u : typeForResource.getProfile()) {
                    StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)u.getValue(), (Resource)parentProfile);
                    if (sd == null || types.contains(sd.getType())) continue;
                    types.add(sd.getType());
                }
                ok = types.size() == 1 ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, "Bundle_BUNDLE_Entry_Type2", resourceName, types.get(0)) && ok : this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), false, types.size(), "Bundle_BUNDLE_Entry_Type3", resourceName, types) && ok;
            }
        }
        return ok;
    }

    private String summariseErrors(List<ValidationMessage> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(", ", " and ");
        for (ValidationMessage vm : list) {
            if (!vm.isError()) continue;
            b.append(vm.getMessage());
        }
        return b.toString();
    }

    private boolean isValidResourceType(String type, ElementDefinition.TypeRefComponent def) {
        if (!def.hasProfile() && def.getCode().equals("Resource")) {
            return true;
        }
        if (def.getCode().equals(type)) {
            return true;
        }
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        for (UriType u : def.getProfile()) {
            StructureDefinition sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, (String)u.getValue());
            if (sdt == null) continue;
            list.add(sdt);
        }
        StructureDefinition sdt = this.context.fetchTypeDefinition(type);
        while (sdt != null) {
            if (def.getWorkingCode().equals("Resource")) {
                for (StructureDefinition sd : list) {
                    if (sd.getUrl().equals(sdt.getUrl())) {
                        return true;
                    }
                    if (!sd.getType().equals(sdt.getType())) continue;
                    return true;
                }
            }
            sdt = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sdt.getBaseDefinition(), (Resource)sdt);
        }
        return false;
    }

    private boolean validateElement(ValidationContext valContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, String extensionUrl, PercentageTracker pct, Base.ValidationMode mode) throws FHIRException {
        ProfileUtilities.SourcedChildDefinitions childDefinitions;
        boolean ok = true;
        pct.seeElement(element);
        String id = element.getChildValue("id");
        if (!Utilities.noString((String)id)) {
            if (stack.getIds().containsKey(id) && stack.getIds().get(id) != element) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), stack.getLiteralPath(), false, "DUPLICATE_ID", id) && ok;
            }
            if (!stack.isResetPoint()) {
                stack.getIds().put(id, element);
            }
        }
        if (definition.getPath().equals("StructureDefinition.snapshot")) {
            stack.resetIds();
        }
        Base.ValidationInfo vi = element.addDefinition(profile, definition, mode);
        if (definition.getFixed() != null) {
            boolean bl = ok = this.checkFixedValue(errors, stack.getLiteralPath(), element, (Element)definition.getFixed(), profile.getVersionedUrl(), definition.getSliceName(), null, false, "") && ok;
        }
        if (definition.getPattern() != null) {
            boolean bl = ok = this.checkFixedValue(errors, stack.getLiteralPath(), element, (Element)definition.getPattern(), profile.getVersionedUrl(), definition.getSliceName(), null, true, "") && ok;
        }
        if ((childDefinitions = this.profileUtilities.getChildMap(profile, definition)).getList().isEmpty()) {
            if (actualType == null) {
                vi.setValid(false);
                return false;
            }
            childDefinitions = this.getActualTypeChildren(valContext, element, actualType);
        } else if (definition.getType().size() > 1) {
            if (actualType == null) {
                vi.setValid(false);
                return false;
            }
            ProfileUtilities.SourcedChildDefinitions typeChildDefinitions = this.getActualTypeChildren(valContext, element, actualType);
            childDefinitions = this.mergeChildLists(childDefinitions, typeChildDefinitions, definition.getPath(), actualType);
        }
        List<ElementInfo> children = this.listChildren(element, stack);
        BaseValidator.BooleanHolder bh = new BaseValidator.BooleanHolder();
        List<String> problematicPaths = this.assignChildren(valContext, errors, profile, resource, stack, childDefinitions, children, bh);
        ok = bh.ok() && ok;
        for (ElementInfo ei : children) {
            ei.getElement().addSliceDefinition(profile, ei.getDefinition(), ei.getSlice());
        }
        ok = this.checkCardinalities(errors, profile, element, stack, childDefinitions, children, problematicPaths) && ok;
        for (ElementInfo ei : children) {
            ok = this.checkChild(valContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl, pct, mode) && ok;
        }
        ok = this.checkInvariants(valContext, errors, profile, definition, resource, element, stack, false) & ok;
        vi.setValid(ok);
        if (!definition.getPath().contains(".") && profile.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-profile-style") && "cda".equals(ToolingExtensions.readStringExtension((DomainResource)profile, (String)"http://hl7.org/fhir/tools/StructureDefinition/type-profile-style"))) {
            List templates = element.getChildren("templateId");
            for (org.hl7.fhir.r5.elementmodel.Element t : templates) {
                String tid = t.hasChild("extension", false) ? "urn:hl7ii:" + t.getChildValue("root") + ":" + t.getChildValue("extension") : "urn:oid:" + t.getChildValue("root");
                StructureDefinition sd = this.cu.fetchProfileByIdentifier(tid);
                if (sd == null) {
                    this.hint(errors, "2023-10-20", ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, t.hasChild("extension", false) ? "CDA_UNKNOWN_TEMPLATE_EXT" : "CDA_UNKNOWN_TEMPLATE", t.getChildValue("root"), t.getChildValue("extension"));
                    continue;
                }
                ElementDefinition ed = sd.getSnapshot().getElementFirstRep();
                if (element.hasValidated(sd, ed)) continue;
                element.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, element.line(), element.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST", sd.getVersionedUrl()));
                ok = this.validateElement(valContext, errors, sd, ed, null, null, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, extensionUrl, pct, mode) && ok;
            }
        }
        return ok;
    }

    private ProfileUtilities.SourcedChildDefinitions mergeChildLists(ProfileUtilities.SourcedChildDefinitions source, ProfileUtilities.SourcedChildDefinitions additional, String masterPath, String typePath) {
        ProfileUtilities.SourcedChildDefinitions res = new ProfileUtilities.SourcedChildDefinitions(additional.getSource(), new ArrayList());
        res.getList().addAll(source.getList());
        for (ElementDefinition ed : additional.getList()) {
            boolean inMaster = false;
            for (ElementDefinition t : source.getList()) {
                String tp = masterPath + ed.getPath().substring(typePath.length());
                if (!t.getPath().equals(tp)) continue;
                inMaster = true;
            }
            if (inMaster) continue;
            res.getList().add(ed);
        }
        return res;
    }

    public ProfileUtilities.SourcedChildDefinitions getActualTypeChildren(ValidationContext valContext, org.hl7.fhir.r5.elementmodel.Element element, String actualType) {
        StructureDefinition dt = null;
        dt = this.isAbsolute(actualType) ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, actualType) : (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + actualType);
        if (dt == null) {
            throw new DefinitionException(this.context.formatMessage("Unable_to_resolve_actual_type_", new Object[]{actualType}));
        }
        this.trackUsage(dt, valContext, element);
        ProfileUtilities.SourcedChildDefinitions childDefinitions = this.profileUtilities.getChildMap(dt, (ElementDefinition)dt.getSnapshot().getElement().get(0));
        return childDefinitions;
    }

    public boolean checkChild(ValidationContext valContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei, String extensionUrl, PercentageTracker pct, Base.ValidationMode mode) throws FHIRException, DefinitionException {
        boolean ok = true;
        if (this.debug && ei.definition != null && ei.slice != null) {
            System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against both " + ei.definition.getId() + " and " + ei.slice.getId());
        }
        if (ei.definition != null) {
            if (this.debug) {
                System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against defn " + ei.definition.getId() + " from " + profile.getVersionedUrl() + this.time());
            }
            boolean bl = ok = this.checkChildByDefinition(valContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl, ei.definition, false, pct, mode) && ok;
        }
        if (ei.slice != null) {
            if (this.debug) {
                System.out.println(Utilities.padLeft((String)"", (char)' ', (int)stack.depth()) + "Check " + ei.getPath() + " against slice " + ei.slice.getId() + this.time());
            }
            ok = this.checkChildByDefinition(valContext, errors, profile, definition, resource, element, actualType, stack, inCodeableConcept, checkDisplayInContext, ei, extensionUrl, ei.slice, true, pct, mode) && ok;
        }
        return ok;
    }

    private String time() {
        long t = System.currentTimeMillis();
        String s = " " + (t - this.start) + "ms";
        this.start = t;
        return s;
    }

    public boolean checkChildByDefinition(ValidationContext valContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept, boolean checkDisplayInContext, ElementInfo ei, String extensionUrl, ElementDefinition checkDefn, boolean isSlice, PercentageTracker pct, Base.ValidationMode mode) {
        String prefix;
        boolean isCDAChoice;
        boolean ok = true;
        ArrayList<Object> profiles = new ArrayList<Object>();
        String type = null;
        String typeName = null;
        ElementDefinition typeDefn = null;
        this.checkMustSupport(profile, ei);
        long s = System.currentTimeMillis();
        boolean hasType = checkDefn.getType().size() > 0;
        boolean isAbstract = hasType && Utilities.existsInList((String)((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode(), (String[])new String[]{"Element", "BackboneElement"});
        boolean isChoice = checkDefn.getType().size() > 1 || hasType && "*".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode());
        boolean bl = isCDAChoice = profile.getUrl().startsWith("http://hl7.org/cda/stds/core") && ei.getElement().getExplicitType() != null;
        if (hasType && !isChoice && !isAbstract && !isCDAChoice) {
            String stype;
            StructureDefinition sdt;
            typeName = type = ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode();
            if (Utilities.isAbsoluteUrl((String)type) && (sdt = this.context.fetchTypeDefinition(type)) != null) {
                typeName = sdt.getTypeName();
            }
            if ((stype = ei.getElement().fhirType()) == null || !stype.equals(type)) {
                if (checkDefn.isChoice()) {
                    if (extensionUrl != null && !this.isAbsolute(extensionUrl)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), ei.getPath(), false, "Extension_PROF_Type", profile.getVersionedUrl(), type, stype) && ok;
                    } else if (!this.isAbstractType(type) && !"Extension".equals(profile.getType())) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), ei.getPath(), stype.equals(typeName), "Extension_PROF_Type", profile.getVersionedUrl(), type, stype) && ok;
                    }
                } else if (!this.isAbstractType(type)) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), ei.getPath(), stype.equals(typeName) || Utilities.existsInList((String)type, (String[])new String[]{"string", "id"}) && Utilities.existsInList((String)stype, (String[])new String[]{"string", "id"}), "Extension_PROF_Type", profile.getVersionedUrl(), type, stype) && ok;
                } else if (!this.isResource(type)) {
                    typeName = type = stype;
                }
            }
            if (((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
                for (CanonicalType p : ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile()) {
                    profiles.add((String)p.getValue());
                }
            }
        } else if (checkDefn.getType().size() == 1 && "*".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode())) {
            prefix = this.tail(checkDefn.getPath());
            assert (prefix.endsWith("[x]"));
            typeName = type = ei.getName().substring(prefix.length() - 3);
            if (this.isPrimitiveType(type)) {
                typeName = type = Utilities.uncapitalize((String)type);
            }
            if (((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
                for (CanonicalType p : ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile()) {
                    profiles.add((String)p.getValue());
                }
            }
        } else if (checkDefn.getType().size() > 1 || isCDAChoice) {
            prefix = this.tail(checkDefn.getPath());
            assert (this.typesAreAllReference(checkDefn.getType()) || isCDAChoice || checkDefn.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR) || prefix.endsWith("[x]") || this.isResourceAndTypes(checkDefn)) : "Multiple Types allowed, but name is wrong @ " + checkDefn.getPath() + ": " + checkDefn.typeSummaryVB();
            if (isCDAChoice) {
                typeName = type = ei.getElement().getExplicitType();
            } else if (checkDefn.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                typeName = type = ei.getElement().getType();
            } else if (ei.getElement().isResource()) {
                typeName = type = ei.getElement().fhirType();
            } else {
                prefix = prefix.substring(0, prefix.length() - 3);
                for (ElementDefinition.TypeRefComponent t : checkDefn.getType()) {
                    if (!(prefix + Utilities.capitalize((String)t.getWorkingCode())).equals(ei.getName())) continue;
                    typeName = type = t.getWorkingCode();
                    if (!t.hasProfile() || type.equals("Reference")) continue;
                    profiles.add((String)((CanonicalType)t.getProfile().get(0)).getValue());
                }
            }
            if (type == null) {
                ElementDefinition.TypeRefComponent trc = (ElementDefinition.TypeRefComponent)checkDefn.getType().get(0);
                if (trc.getWorkingCode().equals("Reference")) {
                    typeName = type = "Reference";
                } else {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "Validation_VAL_Profile_NoType", ei.getName(), this.describeTypes(checkDefn.getType())) && ok;
                }
            }
        } else if (checkDefn.getContentReference() != null) {
            typeDefn = this.resolveNameReference(profile.getSnapshot(), checkDefn.getContentReference());
        } else if (checkDefn.getType().size() == 1 && ("Element".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode()) || "BackboneElement".equals(((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getWorkingCode())) && ((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).hasProfile()) {
            CanonicalType pu = (CanonicalType)((ElementDefinition.TypeRefComponent)checkDefn.getType().get(0)).getProfile().get(0);
            if (pu.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element")) {
                profiles.add((String)pu.getValue() + "#" + pu.getExtensionString("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"));
            } else {
                profiles.add((String)pu.getValue());
            }
        }
        if (type != null && type.startsWith("@")) {
            checkDefn = this.findElement(profile, type.substring(1));
            if (isSlice) {
                ei.slice = ei.definition;
            } else {
                ei.definition = ei.definition;
            }
            typeName = type = null;
        }
        NodeStack localStack = stack.push(ei.getElement(), "*".equals(ei.getDefinition().getBase().getMax()) && ei.count == -1 ? 0 : ei.count, checkDefn, type == null ? typeDefn : this.resolveType(type, checkDefn.getType()));
        if (this.debug) {
            System.out.println("  check " + localStack.getLiteralPath() + " against " + ei.getDefinition().getId() + " in profile " + profile.getVersionedUrl() + this.time());
        }
        EnumSet actionSet = this.policyAdvisor.policyForElement((IResourceValidator)this, valContext.getAppContext(), profile, ei.getDefinition(), localStack.getLiteralPath());
        String localStackLiteralPath = localStack.getLiteralPath();
        String eiPath = ei.getPath();
        if (!eiPath.equals(localStackLiteralPath)) assert (eiPath.equals(localStackLiteralPath)) : "ei.path: " + ei.getPath() + "  -  localStack.getLiteralPath: " + localStackLiteralPath;
        boolean thisIsCodeableConcept = false;
        String thisExtension = null;
        boolean checkDisplay = true;
        if (actionSet.contains(IValidationPolicyAdvisor.ElementValidationAction.Invariants)) {
            ok = this.checkInvariants(valContext, errors, profile, typeDefn != null ? typeDefn : checkDefn, resource, ei.getElement(), localStack, false) && ok;
        }
        boolean checkBindings = actionSet.contains(IValidationPolicyAdvisor.ElementValidationAction.Bindings);
        ei.getElement().markValidation(profile, checkDefn);
        boolean elementValidated = false;
        if (type != null) {
            String style;
            StructureDefinition defn;
            if (this.isPrimitiveType(type)) {
                ok = this.checkPrimitive(valContext, errors, ei.getPath(), type, checkDefn, ei.getElement(), profile, localStack, stack, valContext.getRootResource()) && ok;
            } else {
                if (checkDefn.hasFixed()) {
                    boolean bl2 = ok = this.checkFixedValue(errors, ei.getPath(), ei.getElement(), (Element)checkDefn.getFixed(), profile.getVersionedUrl(), checkDefn.getSliceName(), null, false, "") && ok;
                }
                if (checkDefn.hasPattern()) {
                    boolean bl3 = ok = this.checkFixedValue(errors, ei.getPath(), ei.getElement(), (Element)checkDefn.getPattern(), profile.getVersionedUrl(), checkDefn.getSliceName(), null, true, "") && ok;
                }
            }
            if (type.equals("Identifier")) {
                ok = this.checkIdentifier(errors, ei.getPath(), ei.getElement(), checkDefn) && ok;
            } else if (type.equals("Coding")) {
                ok = (this.checkCoding(checkBindings ? errors : new ArrayList<ValidationMessage>(), ei.getPath(), ei.getElement(), profile, checkDefn, inCodeableConcept, checkDisplayInContext, localStack) || !checkBindings) && ok;
            } else if (type.equals("Quantity")) {
                ok = this.checkQuantity(errors, ei.getPath(), ei.getElement(), profile, checkDefn, localStack) && ok;
            } else if (type.equals("Attachment")) {
                ok = this.checkAttachment(errors, ei.getPath(), ei.getElement(), profile, checkDefn, inCodeableConcept, checkDisplayInContext, localStack) && ok;
            } else if (type.equals("CodeableConcept")) {
                BaseValidator.BooleanHolder bh = new BaseValidator.BooleanHolder();
                checkDisplay = this.checkCodeableConcept(checkBindings ? errors : new ArrayList<ValidationMessage>(), ei.getPath(), ei.getElement(), profile, checkDefn, localStack, bh);
                ok = (bh.ok() || !checkBindings) & ok;
                thisIsCodeableConcept = true;
            } else if (type.equals("Reference")) {
                ok = this.checkReference(valContext, errors, ei.getPath(), ei.getElement(), profile, checkDefn, actualType, localStack, pct, mode) && ok;
            } else if (type.equals("Extension")) {
                org.hl7.fhir.r5.elementmodel.Element eurl = ei.getElement().getNamedChild("url", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.getPath(), eurl != null, "Extension_EXT_Url_NotFound", new Object[0])) {
                    String url;
                    thisExtension = url = eurl.primitiveValue();
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.getPath(), !Utilities.noString((String)url), "Extension_EXT_Url_NotFound", new Object[0]) ? (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.getPath(), extensionUrl != null || Utilities.isAbsoluteUrl((String)url), "Extension_EXT_URL_Absolute", new Object[0]) ? this.checkExtension(valContext, errors, ei.getPath(), resource, element, ei.getElement(), checkDefn, profile, localStack, stack, extensionUrl, pct, mode) && ok : false) : false;
                } else {
                    ok = false;
                }
            } else if (type.equals("Resource") || this.isResource(type)) {
                ok = this.validateContains(valContext, errors, ei.getPath(), checkDefn, definition, resource, ei.getElement(), localStack, this.idStatusForEntry(element, ei), profile, pct, mode) && ok;
                elementValidated = true;
            } else if (Utilities.isAbsoluteUrl((String)type) && (defn = this.context.fetchTypeDefinition(type)) != null && defn.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style") && "CDA".equals(style = ToolingExtensions.readStringExtension((DomainResource)defn, (String)"http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) && !ei.getElement().hasChild("nullFlavor", false)) {
                if (this.cdaTypeIs(defn, "CS")) {
                    ok = this.checkCDACodeSimple(valContext, errors, ei.getPath(), ei.getElement(), profile, checkDefn, localStack, defn) && ok;
                } else if (this.cdaTypeIs(defn, "CV") || this.cdaTypeIs(defn, "PQ")) {
                    ok = this.checkCDACoding(errors, ei.getPath(), this.cdaTypeIs(defn, "PQ"), ei.getElement(), profile, checkDefn, localStack, defn, inCodeableConcept, checkDisplayInContext) && ok;
                } else if (this.cdaTypeIs(defn, "CD") || this.cdaTypeIs(defn, "CE")) {
                    ok = this.checkCDACodeableConcept(errors, ei.getPath(), ei.getElement(), profile, checkDefn, localStack, defn) && ok;
                    thisIsCodeableConcept = true;
                }
            }
        } else {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), localStack.getLiteralPath(), checkDefn != null, "Validation_VAL_Content_Unknown", ei.getName()) ? this.validateElement(valContext, errors, profile, checkDefn, null, null, resource, ei.getElement(), type, localStack, false, true, null, pct, mode) && ok : false;
        }
        StructureDefinition p = null;
        String tail = null;
        if (profiles.isEmpty()) {
            if (type != null) {
                p = this.getProfileForType(type, checkDefn.getType(), (Resource)profile);
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_NoType", type) && ok;
            }
        } else if (profiles.size() == 1) {
            String url = (String)profiles.get(0);
            if (url.contains("#")) {
                tail = url.substring(url.indexOf("#") + 1);
                url = url.substring(0, url.indexOf("#"));
            }
            p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url, (Resource)profile);
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", profiles.get(0)) && ok;
        } else {
            elementValidated = true;
            HashMap<String, ArrayList<ValidationMessage>> goodProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
            HashMap<String, ArrayList<ValidationMessage>> badProfiles = new HashMap<String, ArrayList<ValidationMessage>>();
            Iterator<Object> iterator = profiles.iterator();
            while (iterator.hasNext()) {
                String typeProfile;
                String url = typeProfile = (String)iterator.next();
                tail = null;
                if (url.contains("#")) {
                    tail = url.substring(url.indexOf("#") + 1);
                    url = url.substring(0, url.indexOf("#"));
                }
                p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, typeProfile);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), p != null, "Validation_VAL_Unknown_Profile", typeProfile)) {
                    ArrayList<ValidationMessage> profileErrors = new ArrayList<ValidationMessage>();
                    this.validateElement(valContext, profileErrors, p, this.getElementByTail(p, tail), profile, checkDefn, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode);
                    if (this.hasErrors(profileErrors)) {
                        badProfiles.put(typeProfile, profileErrors);
                        continue;
                    }
                    goodProfiles.put(typeProfile, profileErrors);
                    continue;
                }
                ok = false;
            }
            if (goodProfiles.size() == 1) {
                errors.addAll((Collection)goodProfiles.values().iterator().next());
            } else if (goodProfiles.size() == 0) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NoMatch", StringUtils.join((Object[])new Object[]{"; ", profiles})) && ok;
                for (String m : badProfiles.keySet()) {
                    p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, m);
                    for (ValidationMessage message : (List)badProfiles.get(m)) {
                        message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (String)(p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                        errors.add(message);
                    }
                }
            } else {
                this.warningPlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.getPath(), false, goodProfiles.size(), "Validation_VAL_Profile_MultipleMatches", ResourceUtilities.listStrings(goodProfiles.keySet()));
                for (String m : goodProfiles.keySet()) {
                    p = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, m);
                    for (ValidationMessage message : (List)goodProfiles.get(m)) {
                        message.setMessage(message.getMessage() + " (validating against " + p.getUrl() + (String)(p.hasVersion() ? "|" + p.getVersion() : "") + " [" + p.getName() + "])");
                        errors.add(message);
                    }
                }
            }
        }
        if (p != null) {
            String nextPath;
            int index;
            this.trackUsage(p, valContext, element);
            if (!elementValidated) {
                if (ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || ei.getElement().getSpecial() == Element.SpecialElement.PARAMETER) {
                    ok = this.validateElement(valContext, errors, p, this.getElementByTail(p, tail), profile, checkDefn, ei.getElement(), ei.getElement(), type, localStack.resetIds(), thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode) && ok;
                } else {
                    boolean bl4 = ok = this.validateElement(valContext, errors, p, this.getElementByTail(p, tail), profile, checkDefn, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode) && ok;
                }
            }
            if ((index = profile.getSnapshot().getElement().indexOf(checkDefn)) < profile.getSnapshot().getElement().size() - 1 && !(nextPath = ((ElementDefinition)profile.getSnapshot().getElement().get(index + 1)).getPath()).equals(checkDefn.getPath()) && nextPath.startsWith(checkDefn.getPath())) {
                ok = ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY || ei.getElement().getSpecial() == Element.SpecialElement.BUNDLE_OUTCOME || ei.getElement().getSpecial() == Element.SpecialElement.PARAMETER ? this.validateElement(valContext.forEntry(ei.getElement(), null), errors, profile, checkDefn, null, null, ei.getElement(), ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode) && ok : (ei.getElement().getSpecial() == Element.SpecialElement.CONTAINED ? this.validateElement(valContext.forContained(ei.getElement()), errors, profile, checkDefn, null, null, ei.getElement(), ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode) && ok : this.validateElement(valContext, errors, profile, checkDefn, null, null, resource, ei.getElement(), type, localStack, thisIsCodeableConcept, checkDisplay, thisExtension, pct, mode) && ok);
            }
        }
        return ok;
    }

    private boolean cdaTypeIs(StructureDefinition defn, String type) {
        return ("http://hl7.org/cda/stds/core/StructureDefinition/" + type).equals(defn.getUrl());
    }

    private boolean checkCDACoding(List<ValidationMessage> errors, String path, boolean isPQ, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition checkDefn, NodeStack stack, StructureDefinition defn, boolean inCodeableConcept, boolean checkDisplay) {
        String oid;
        boolean ok = true;
        Object system = null;
        String code = element.getNamedChildValue(isPQ ? "unit" : "code", false);
        String string = oid = isPQ ? "2.16.840.1.113883.6.8" : element.getNamedChildValue("codeSystem", false);
        if (oid != null) {
            IWorkerContext.OIDSummary urls = this.context.urlsForOid(oid, "CodeSystem");
            system = "urn:oid:" + oid;
            if (urls.urlCount() == 1) {
                system = urls.getUrl();
            } else if (urls.urlCount() == 0) {
                this.warning(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_UNKNOWN_OID", oid);
            } else {
                String prefUrl = urls.chooseBestUrl();
                if (prefUrl == null) {
                    this.rule(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_OID_MULTIPLE_MATCHES", oid, urls.describe());
                    ok = false;
                } else {
                    system = prefUrl;
                    this.warning(errors, "2023-10-11", ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "TERMINOLOGY_TX_OID_MULTIPLE_MATCHES_CHOSEN", oid, prefUrl, urls.describe());
                }
            }
        } else {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, code == null, "TERMINOLOGY_TX_SYSTEM_NO_CODE", new Object[0]);
        }
        String version = element.getNamedChildValue("codeSystemVersion", false);
        String display = element.getNamedChildValue("displayName", false);
        return this.checkCodedElement(errors, path, element, profile, checkDefn, inCodeableConcept, checkDisplay, stack, code, (String)system, version, display) && ok;
    }

    private boolean checkCDACodeSimple(ValidationContext valContext, List<ValidationMessage> errors, String path, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition profile, ElementDefinition checkDefn, NodeStack stack, StructureDefinition defn) {
        if (element.hasChild("code", false)) {
            return this.checkPrimitiveBinding(valContext, errors, path, "code", checkDefn, element.getNamedChild("code", false), profile, stack);
        }
        return false;
    }

    private boolean isAbstractType(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && sd.getAbstract();
    }

    private boolean isResourceAndTypes(ElementDefinition ed) {
        if (!RESOURCE_X_POINTS.contains(ed.getBase().getPath())) {
            return false;
        }
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            if (this.isResource(tr.getCode())) continue;
            return false;
        }
        return true;
    }

    private boolean isResource(String type) {
        StructureDefinition sd = this.context.fetchTypeDefinition(type);
        return sd != null && sd.getKind().equals((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
    }

    private void trackUsage(StructureDefinition profile, ValidationContext valContext, org.hl7.fhir.r5.elementmodel.Element element) {
        if (this.tracker != null) {
            this.tracker.recordProfileUsage(profile, valContext.getAppContext(), element);
        }
    }

    private boolean hasMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent m : defn.getMapping()) {
            if (!url.equals(m.getUri())) continue;
            id = m.getIdentity();
            break;
        }
        if (id != null) {
            for (StructureDefinition.StructureDefinitionMappingComponent m : elem.getMapping()) {
                if (!id.equals(m.getIdentity())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getMapping(String url, StructureDefinition defn, ElementDefinition elem) {
        ArrayList<String> res = new ArrayList<String>();
        String id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent m : defn.getMapping()) {
            if (!url.equals(m.getUri())) continue;
            id = m.getIdentity();
            break;
        }
        if (id != null) {
            for (StructureDefinition.StructureDefinitionMappingComponent m : elem.getMapping()) {
                if (!id.equals(m.getIdentity())) continue;
                res.add(m.getMap());
            }
        }
        return res;
    }

    public void checkMustSupport(StructureDefinition profile, ElementInfo ei) {
        String usesMustSupport = profile.getUserString("usesMustSupport");
        if (usesMustSupport == null) {
            usesMustSupport = "N";
            for (ElementDefinition pe : profile.getSnapshot().getElement()) {
                if (!pe.getMustSupport()) continue;
                usesMustSupport = "Y";
                break;
            }
            profile.setUserData("usesMustSupport", (Object)usesMustSupport);
        }
        String elementSupported = ei.getElement().getUserString("elementSupported");
        String fixedValue = ei.getElement().getUserString("hasFixed");
        if ((elementSupported == null || !elementSupported.equals("Y")) && ei.definition.getMustSupport()) {
            if (ei.definition.getMustSupport()) {
                ei.getElement().setUserData("elementSupported", (Object)"Y");
            }
        } else if (elementSupported == null && !usesMustSupport.equals("Y")) {
            ei.getElement().setUserData("elementSupported", (Object)"NA");
        }
        if (fixedValue == null && (ei.definition.hasFixed() || ei.definition.hasPattern())) {
            ei.getElement().setUserData("hasFixed", (Object)"Y");
        }
    }

    public boolean checkCardinalities(List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, ProfileUtilities.SourcedChildDefinitions childDefinitions, List<ElementInfo> children, List<String> problematicPaths) throws DefinitionException {
        boolean ok = true;
        for (ElementDefinition ed : childDefinitions.getList()) {
            if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XHTML) || ed.hasRepresentation(ElementDefinition.PropertyRepresentation.XMLTEXT)) continue;
            int count = 0;
            List slices = null;
            if (ed.hasSlicing()) {
                slices = this.profileUtilities.getSliceList(profile, ed);
            }
            block1: for (ElementInfo ei : children) {
                if (ei.definition == ed) {
                    ++count;
                    continue;
                }
                if (slices == null) continue;
                for (ElementDefinition sed : slices) {
                    if (ei.definition != sed) continue;
                    ++count;
                    continue block1;
                }
            }
            if (ed.getMin() > 0) {
                if (problematicPaths.contains(ed.getPath())) {
                    this.hintPlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), count, "Validation_VAL_Profile_NoCheckMin", profile.getVersionedUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), Integer.toString(ed.getMin()));
                } else if (count < ed.getMin()) {
                    if (this.isObservationMagicValue(profile, ed)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, "VALIDATION_VAL_PROFILE_MINIMUM_MAGIC", ed.getSliceName(), this.getFixedLOINCCode(ed, profile), profile.getVersionedUrl()) && ok;
                    } else if (ed.hasSliceName()) {
                        ok = this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, ed.getMin(), "Validation_VAL_Profile_Minimum_SLICE", profile.getVersionedUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), count) && ok;
                    } else {
                        boolean bl = ok = this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, count, "Validation_VAL_Profile_Minimum", profile.getVersionedUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), ed.getMin()) && ok;
                    }
                }
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            if (problematicPaths.contains(ed.getPath())) {
                this.hintPlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTSUPPORTED, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), count, "Validation_VAL_Profile_NoCheckMax", profile.getVersionedUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), ed.getMax());
                continue;
            }
            if (count <= Integer.parseInt(ed.getMax())) continue;
            ok = this.rulePlural(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), false, count, "Validation_VAL_Profile_Maximum", profile.getVersionedUrl(), ed.getPath(), ed.getId(), ed.getSliceName(), ed.getLabel(), stack.getLiteralPath(), ed.getMax(), Integer.toString(count)) && ok;
        }
        return ok;
    }

    private String getFixedLOINCCode(ElementDefinition ed, StructureDefinition profile) {
        if (ed.hasFixedCoding() && "http://loinc.org".equals(ed.getFixedCoding().getSystem())) {
            return ed.getFixedCoding().getCode();
        }
        ProfileUtilities.SourcedChildDefinitions children = this.profileUtilities.getChildMap(profile, ed);
        if (children != null) {
            for (ElementDefinition t : children.getList()) {
                if (!t.getPath().endsWith(".code") || !t.hasFixed()) continue;
                return t.getFixed().primitiveValue();
            }
        }
        return "??";
    }

    private boolean isObservationMagicValue(StructureDefinition profile, ElementDefinition ed) {
        return profile.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/") && ed.hasSliceName() && ed.getPath().equals("Observation.code.coding");
    }

    public List<String> assignChildren(ValidationContext valContext, List<ValidationMessage> errors, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, NodeStack stack, ProfileUtilities.SourcedChildDefinitions childDefinitions, List<ElementInfo> children, BaseValidator.BooleanHolder bh) throws DefinitionException {
        ElementDefinition slicer = null;
        ArrayList<ElementDefinition> slicerSlices = null;
        boolean unsupportedSlicing = false;
        ArrayList<String> problematicPaths = new ArrayList<String>();
        String slicingPath = null;
        int sliceOffset = 0;
        for (int i = 0; i < childDefinitions.getList().size(); ++i) {
            ElementDefinition ed = (ElementDefinition)childDefinitions.getList().get(i);
            boolean childUnsupportedSlicing = false;
            boolean process = true;
            if (ed.hasSlicing() && !ed.getSlicing().getOrdered()) {
                slicingPath = ed.getPath();
            } else if (!(slicingPath != null && ed.getPath().equals(slicingPath) || slicingPath == null || ed.getPath().startsWith(slicingPath))) {
                slicingPath = null;
            }
            if (ed.hasSlicing()) {
                if (slicer != null && slicer.getPath().equals(ed.getPath())) {
                    String errorContext = "profile " + profile.getVersionedUrl();
                    if (resource.hasChild("id", false) && !resource.getChildValue("id").isEmpty()) {
                        errorContext = errorContext + "; instance " + resource.getChildValue("id");
                    }
                    throw new DefinitionException(this.context.formatMessage("Slice_encountered_midway_through_set_path___id___", new Object[]{slicer.getPath(), slicer.getId(), errorContext}));
                }
                slicer = ed;
                process = false;
                sliceOffset = i;
                slicerSlices = new ArrayList<ElementDefinition>();
                for (int j = i + 1; j < childDefinitions.getList().size(); ++j) {
                    if (!ed.getPath().equals(((ElementDefinition)childDefinitions.getList().get(j)).getPath())) continue;
                    slicerSlices.add((ElementDefinition)childDefinitions.getList().get(j));
                }
            } else if (slicer != null && !slicer.getPath().equals(ed.getPath())) {
                slicer = null;
                slicerSlices = null;
            }
            for (ElementInfo ei : children) {
                if (ei.sliceInfo == null) {
                    ei.sliceInfo = new ArrayList<ValidationMessage>();
                }
                unsupportedSlicing = this.matchSlice(valContext, errors, ei.sliceInfo, profile, stack, slicer, slicerSlices, unsupportedSlicing, problematicPaths, sliceOffset, i, ed, childUnsupportedSlicing, ei, bh);
            }
        }
        int last = -1;
        ElementInfo lastei = null;
        int lastSlice = -1;
        for (ElementInfo ei : children) {
            Object sliceInfo = "";
            if (slicer != null) {
                sliceInfo = " (slice: " + slicer.getPath() + ")";
            }
            if (!unsupportedSlicing) {
                if (ei.additionalSlice && ei.definition != null) {
                    if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPEN) || ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.OPENATEND)) {
                        if (!this.ignoreSlicingHint(ei.definition, profile)) {
                            this.slicingHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, ei.line(), ei.col(), ei.getPath(), false, this.isProfile(slicer) || this.isCritical(ei.sliceInfo), this.context.formatMessage("This_element_does_not_match_any_known_slice_", new Object[]{profile == null ? "" : "defined in the profile " + profile.getVersionedUrl()}), this.context.formatMessage("This_element_does_not_match_any_known_slice_", new Object[]{profile == null ? "" : this.context.formatMessage("defined_in_the_profile", new Object[0]) + " " + profile.getVersionedUrl()}) + this.errorSummaryForSlicingAsHtml(ei.sliceInfo), this.errorSummaryForSlicingAsText(ei.sliceInfo), ei.sliceInfo, "This_element_does_not_match_any_known_slice_");
                        }
                    } else if (ei.definition.getSlicing().getRules().equals((Object)ElementDefinition.SlicingRules.CLOSED)) {
                        bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), false, "Validation_VAL_Profile_NotSlice", profile == null ? "" : " defined in the profile " + profile.getVersionedUrl(), this.errorSummaryForSlicing(ei.sliceInfo)));
                    }
                } else if (!childDefinitions.getSource().getAbstract()) {
                    bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTSUPPORTED, ei.line(), ei.col(), ei.getPath(), ei.definition != null, "Validation_VAL_Profile_NotAllowed", profile.getVersionedUrl()));
                }
            }
            boolean isXmlAttr = false;
            if (ei.definition != null) {
                for (Enumeration r : ei.definition.getRepresentation()) {
                    if (r.getValue() != ElementDefinition.PropertyRepresentation.XMLATTR) continue;
                    isXmlAttr = true;
                    break;
                }
            }
            if (!ToolingExtensions.readBoolExtension((DomainResource)profile, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order")) {
                boolean bok = ei.definition == null || ei.index >= last || isXmlAttr || ei.getElement().isIgnorePropertyOrder();
                bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), bok, "Validation_VAL_Profile_OutOfOrder", profile.getVersionedUrl(), ei.getName(), lastei == null ? "(null)" : lastei.getName()));
            }
            if (ei.slice != null && ei.index == last && ei.slice.getSlicing().getOrdered()) {
                bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), ei.definition == null || ei.sliceindex >= lastSlice || isXmlAttr, "Validation_VAL_Profile_SliceOrder", profile.getVersionedUrl(), ei.getName()));
            }
            if (ei.definition == null || !isXmlAttr) {
                last = ei.index;
                lastei = ei;
            }
            if (ei.slice != null) {
                lastSlice = ei.sliceindex;
                continue;
            }
            lastSlice = -1;
        }
        return problematicPaths;
    }

    private boolean ignoreSlicingHint(ElementDefinition definition, StructureDefinition profile) {
        return profile.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/") && "Observation.code.coding".equals(definition.getPath());
    }

    public List<ElementInfo> listChildren(org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(this, stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        return children;
    }

    public boolean checkInvariants(ValidationContext valContext, List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack, boolean onlyNonInherited) throws FHIRException {
        return this.checkInvariants(valContext, errors, stack.getLiteralPath(), profile, definition, null, null, resource, element, onlyNonInherited);
    }

    public boolean matchSlice(ValidationContext valContext, List<ValidationMessage> errors, List<ValidationMessage> sliceInfo, StructureDefinition profile, NodeStack stack, ElementDefinition slicer, List<ElementDefinition> slicerSlices, boolean unsupportedSlicing, List<String> problematicPaths, int sliceOffset, int i, ElementDefinition ed, boolean childUnsupportedSlicing, ElementInfo ei, BaseValidator.BooleanHolder bh) {
        boolean match = false;
        if (slicer == null || slicer == ed) {
            match = this.nameMatches(ei.getName(), this.tail(ed.getPath()));
        } else if (this.nameMatches(ei.getName(), this.tail(ed.getPath()))) {
            try {
                match = this.sliceMatches(valContext, ei.getElement(), ei.getPath(), slicer, slicerSlices, ed, profile, errors, sliceInfo, stack, profile);
                if (match) {
                    ei.slice = slicer;
                    ei.additionalSlice = false;
                } else if (ei.slice == null) {
                    ei.additionalSlice = true;
                }
            }
            catch (FHIRException e) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.PROCESSING, ei.line(), ei.col(), ei.getPath(), false, "SLICING_CANNOT_BE_EVALUATED", e.getMessage());
                bh.fail();
                unsupportedSlicing = true;
                childUnsupportedSlicing = true;
            }
        }
        if (match) {
            boolean isOk;
            boolean update = true;
            boolean bl = isOk = ei.definition == null || ei.definition == slicer || ei.definition.getPath().endsWith("[x]") && ed.getPath().startsWith(ei.definition.getPath().replace("[x]", ""));
            if (!isOk) {
                String matchingName;
                String existingName = ei.definition == null || !ei.definition.hasSliceName() ? null : ei.definition.getSliceName();
                String string = matchingName = ed.hasSliceName() ? ed.getSliceName() : null;
                if (existingName != null && matchingName != null) {
                    if (matchingName.startsWith(existingName + "/")) {
                        isOk = true;
                    } else if (existingName.startsWith(matchingName + "/")) {
                        update = false;
                        isOk = true;
                    }
                }
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = profile.getVersionedUrl();
            objectArray[1] = ei.definition == null || !ei.definition.hasSliceName() ? "" : ei.definition.getSliceName();
            Object object = objectArray[2] = ed.hasSliceName() ? ed.getSliceName() : "";
            if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.getPath(), isOk, "Validation_VAL_Profile_MatchMultiple", objectArray)) {
                if (update) {
                    ei.definition = ed;
                    if (ei.slice == null) {
                        ei.index = i;
                    } else {
                        ei.index = sliceOffset;
                        ei.sliceindex = i - (sliceOffset + 1);
                    }
                }
            } else {
                bh.fail();
            }
        } else if (childUnsupportedSlicing) {
            problematicPaths.add(ed.getPath());
        }
        return unsupportedSlicing;
    }

    private String slicingSummary(ElementDefinition.ElementDefinitionSlicingComponent slicing) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean first = true;
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : slicing.getDiscriminator()) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(t.getType().toCode());
            b.append(":");
            b.append(t.getPath());
        }
        b.append(']');
        b.append(slicing.getOrdered() ? ";ordered" : "");
        b.append(slicing.getRules().toString());
        return b.toString();
    }

    private ElementDefinition getElementByTail(StructureDefinition p, String tail) throws DefinitionException {
        if (tail == null) {
            return (ElementDefinition)p.getSnapshot().getElement().get(0);
        }
        for (ElementDefinition t : p.getSnapshot().getElement()) {
            if (!tail.equals(t.getId())) continue;
            return t;
        }
        throw new DefinitionException(this.context.formatMessage("Unable_to_find_element_with_id_", new Object[]{tail}));
    }

    private IdStatus idStatusForEntry(org.hl7.fhir.r5.elementmodel.Element ep, ElementInfo ei) {
        if (ei.getDefinition().hasExtension("http://hl7.org/fhir/tools/StructureDefinition/id-expectation")) {
            return IdStatus.fromCode((String)ToolingExtensions.readStringExtension((Element)ei.getDefinition(), (String)"http://hl7.org/fhir/tools/StructureDefinition/id-expectation"));
        }
        if (this.isBundleEntry(ei.getPath())) {
            org.hl7.fhir.r5.elementmodel.Element req = ep.getNamedChild("request", false);
            org.hl7.fhir.r5.elementmodel.Element resp = ep.getNamedChild("response", false);
            org.hl7.fhir.r5.elementmodel.Element fullUrl = ep.getNamedChild("fullUrl", false);
            org.hl7.fhir.r5.elementmodel.Element method = null;
            org.hl7.fhir.r5.elementmodel.Element url = null;
            if (req != null) {
                method = req.getNamedChild("method", false);
                url = req.getNamedChild("url", false);
            }
            if (resp != null) {
                return IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IdStatus.REQUIRED;
                }
                if (fullUrl.primitiveValue().startsWith("urn:uuid:") || fullUrl.primitiveValue().startsWith("urn:oid:")) {
                    return IdStatus.OPTIONAL;
                }
                return IdStatus.REQUIRED;
            }
            String s = method.primitiveValue();
            if (s.equals("PUT")) {
                if (url == null) {
                    return IdStatus.REQUIRED;
                }
                return IdStatus.OPTIONAL;
            }
            if (s.equals("POST")) {
                return IdStatus.OPTIONAL;
            }
            return IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.getPath()) || this.isBundleOutcome(ei.getPath())) {
            return IdStatus.OPTIONAL;
        }
        return IdStatus.REQUIRED;
    }

    private boolean checkInvariants(ValidationContext valContext, List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, boolean onlyNonInherited) throws FHIRException, FHIRException {
        if (this.noInvariantChecks) {
            return true;
        }
        boolean ok = true;
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            HashMap<String, ArrayList> invMap;
            if (!inv.hasExpression() || onlyNonInherited && inv.hasSource() && (this.isInheritedProfile(profile, inv.getSource()) || this.isInheritedProfile(ed.getType(), inv.getSource()))) continue;
            HashMap<String, ArrayList> hashMap = invMap = this.executionId.equals(element.getUserString(EXECUTION_ID)) ? (HashMap<String, ArrayList>)element.getUserData(EXECUTED_CONSTRAINT_LIST) : null;
            if (invMap == null) {
                invMap = new HashMap<String, ArrayList>();
                element.setUserData(EXECUTED_CONSTRAINT_LIST, invMap);
                element.setUserData(EXECUTION_ID, (Object)this.executionId);
            }
            ArrayList invErrors = null;
            String key = FHIRPathExpressionFixer.fixExpr(inv.getExpression(), inv.getKey(), this.context.getVersion());
            if (!invMap.keySet().contains(key)) {
                invErrors = new ArrayList();
                invMap.put(key, invErrors);
                ok = this.checkInvariant(valContext, invErrors, path, profile, resource, element, inv) && ok;
            } else {
                invErrors = (ArrayList)invMap.get(key);
            }
            errors.addAll(invErrors);
        }
        return ok;
    }

    private boolean isInheritedProfile(List<ElementDefinition.TypeRefComponent> types, String source) {
        for (ElementDefinition.TypeRefComponent type : types) {
            for (CanonicalType c : type.getProfile()) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, c.asStringValue());
                if (sd == null) continue;
                if (sd.getUrl().equals(source)) {
                    return true;
                }
                if (!this.isInheritedProfile(sd, source)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInheritedProfile(StructureDefinition profile, String source) {
        if (source.equals(profile.getUrl())) {
            return false;
        }
        while (profile != null) {
            if ((profile = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, profile.getBaseDefinition(), (Resource)profile)) == null || !source.equals(profile.getUrl())) continue;
            return true;
        }
        return false;
    }

    public boolean checkInvariant(ValidationContext valContext, List<ValidationMessage> errors, String path, StructureDefinition profile, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition.ElementDefinitionConstraintComponent inv) throws FHIRException {
        Object msg;
        boolean invOK;
        if (this.IsExemptInvariant(path, element, inv)) {
            return true;
        }
        boolean ok = true;
        if ("dom-3".equals(inv.getKey())) {
            return true;
        }
        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
        if (n == null) {
            long t = System.nanoTime();
            try {
                String expr = FHIRPathExpressionFixer.fixExpr(inv.getExpression(), inv.getKey(), this.context.getVersion());
                n = this.fpe.parse(expr);
            }
            catch (FHIRException e) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, false, "Problem_processing_expression__in_profile__path__", inv.getExpression(), profile.getVersionedUrl(), path, e.getMessage()) && ok;
                return false;
            }
            this.timeTracker.fpe(t);
            inv.setUserData("validator.expression.cache", (Object)n);
        }
        valContext.setProfile(profile);
        try {
            long t = System.nanoTime();
            invOK = this.fpe.evaluateToBoolean((Object)valContext, (Base)resource, (Base)valContext.getRootResource(), (Base)element, n);
            this.timeTracker.fpe(t);
            msg = this.fpe.forLog();
        }
        catch (Exception ex) {
            invOK = false;
            msg = ex.getClass().getName() + ": " + ex.getMessage();
            ex.printStackTrace();
        }
        if (!invOK) {
            if (this.wantInvariantInMessage) {
                msg = (String)msg + " (inv = " + n.toString() + ")";
            }
            if (!Utilities.noString((String)msg)) {
                msg = (String)msg + " (log: " + (String)msg + ")";
            }
            msg = inv.hasSource() ? this.context.formatMessage("INV_FAILED_SOURCE", new Object[]{inv.getKey() + ": '" + inv.getHuman() + "'", inv.getSource()}) + (String)msg : this.context.formatMessage("INV_FAILED", new Object[]{inv.getKey() + ": '" + inv.getHuman() + "'"}) + (String)msg;
            String invId = (inv.hasSource() ? inv.getSource() : profile.getUrl()) + "#" + inv.getKey();
            if (inv.hasExtension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice") && ToolingExtensions.readBooleanExtension((Element)inv, (String)"http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").booleanValue()) {
                msg = (String)msg + " (Best Practice Recommendation)";
                if (this.bpWarnings == BestPracticeWarningLevel.Hint) {
                    this.hintInv(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, invOK, (String)msg, invId);
                } else if (this.bpWarnings == BestPracticeWarningLevel.Warning) {
                    this.warningInv(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, invOK, (String)msg, invId, new Object[0]);
                } else if (this.bpWarnings == BestPracticeWarningLevel.Error) {
                    ok = this.ruleInv(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, invOK, (String)msg, invId, new Object[0]) && ok;
                }
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                ok = this.ruleInv(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, invOK, (String)msg, invId, new Object[0]) && ok;
            } else if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.WARNING) {
                this.warningInv(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, invOK, (String)msg, invId, new Object[0]);
            }
        }
        return ok;
    }

    private boolean IsExemptInvariant(String path, org.hl7.fhir.r5.elementmodel.Element element, ElementDefinition.ElementDefinitionConstraintComponent inv) {
        if ("eld-24".equals(inv.getKey())) {
            String p = element.getNamedChildValue("path", false);
            return p != null && (p.endsWith("xtension.url") || p.endsWith(".id"));
        }
        return false;
    }

    private boolean validateResource(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element resource, org.hl7.fhir.r5.elementmodel.Element element, StructureDefinition defn, IdStatus idstatus, NodeStack stack, PercentageTracker pct, Base.ValidationMode mode, boolean forReference, boolean fromContained) throws FHIRException {
        NodeStack first;
        boolean ok = true;
        assert (stack != null);
        assert (resource != null);
        boolean rok = true;
        String resourceName = element.getType();
        if (defn == null) {
            long t = System.nanoTime();
            defn = element.getProperty().getStructure();
            if (defn == null) {
                defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
            }
            this.timeTracker.sd(t);
            rok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), defn != null, "Validation_VAL_Profile_NoDefinition", resourceName);
            boolean bl = ok = rok && ok;
        }
        if (!this.typeMatchesDefn(resourceName, defn) && resourceName.equals("Bundle") && (first = this.getFirstEntry(stack)) != null && this.typeMatchesDefn(first.getElement().getType(), defn)) {
            element = first.getElement();
            stack = first;
            resourceName = element.getType();
            idstatus = IdStatus.OPTIONAL;
        }
        if (rok) {
            if (element.getProperty().getStructure().getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
                org.hl7.fhir.r5.elementmodel.Element eid;
                if (idstatus == IdStatus.REQUIRED && element.getNamedChild("id", false) == null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Missing", new Object[0]) && ok;
                } else if (idstatus == IdStatus.PROHIBITED && element.getNamedChild("id", false) != null) {
                    boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource_RES_ID_Prohibited", new Object[0]) && ok;
                }
                if (element.getNamedChild("id", false) != null && (eid = element.getNamedChild("id", false)).getProperty() != null && eid.getProperty().getDefinition() != null && eid.getProperty().getDefinition().getBase().getPath().equals("Resource.id")) {
                    NodeStack ns = stack.push(eid, -1, eid.getProperty().getDefinition(), null);
                    if (eid.primitiveValue() != null && eid.primitiveValue().length() > 64) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, eid.line(), eid.col(), ns.getLiteralPath(), false, "Resource_RES_ID_Malformed_Length", eid.primitiveValue().length()) && ok;
                    } else {
                        boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, eid.line(), eid.col(), ns.getLiteralPath(), FormatUtilities.isValidId((String)eid.primitiveValue()), "Resource_RES_ID_Malformed_Chars", eid.primitiveValue()) && ok;
                    }
                }
            }
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), this.checkResourceName(defn, resourceName, element.getFormat()), "Validation_VAL_Profile_WrongType", defn.getType(), resourceName, defn.getVersionedUrl()) ? this.start(valContext, errors, element, element, defn, stack, pct, mode, fromContained) && ok : false;
            if (!forReference) {
                boolean bl = ok = this.checkContainedReferences(valContext, errors, element, stack) && ok;
            }
        }
        if (this.testMode && ok == this.hasErrors(errors)) {
            throw new Error("ok is wrong. ok = " + ok + ", errors = " + this.errorIds(stack.getLiteralPath(), ok, errors));
        }
        return ok;
    }

    private boolean checkContainedReferences(ValidationContext valContext, List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element element, NodeStack stack) {
        boolean ok = true;
        Set baseRefs = (Set)element.getUserData("internal.references");
        List containedList = element.getChildrenByName("contained");
        if (!containedList.isEmpty()) {
            boolean allDone = true;
            for (org.hl7.fhir.r5.elementmodel.Element contained : containedList) {
                allDone = allDone && contained.hasUserData("internal.references");
            }
            if (allDone) {
                int i = 0;
                for (org.hl7.fhir.r5.elementmodel.Element contained : containedList) {
                    ok = this.checkContainedReferences(errors, stack, ok, baseRefs, containedList, i, contained);
                    ++i;
                }
            }
        }
        return ok;
    }

    private boolean checkContainedReferences(List<ValidationMessage> errors, NodeStack stack, boolean ok, Set<String> baseRefs, List<org.hl7.fhir.r5.elementmodel.Element> containedList, int i, org.hl7.fhir.r5.elementmodel.Element contained) {
        NodeStack n = stack.push(contained, i, null, null);
        boolean found = this.isReferencedFromBase(contained, baseRefs, containedList, new ArrayList<org.hl7.fhir.r5.elementmodel.Element>());
        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, n, found, "CONTAINED_ORPHAN_DOM3", contained.getIdBase()) && ok;
        return ok;
    }

    private boolean isReferencedFromBase(org.hl7.fhir.r5.elementmodel.Element contained, Set<String> baseRefs, List<org.hl7.fhir.r5.elementmodel.Element> containedList, List<org.hl7.fhir.r5.elementmodel.Element> ignoreList) {
        String id = contained.getIdBase();
        if (baseRefs.contains(id)) {
            return true;
        }
        Set irefs = (Set)contained.getUserData("internal.references");
        if (irefs.contains("")) {
            return true;
        }
        for (org.hl7.fhir.r5.elementmodel.Element c : containedList) {
            if (c == contained || ignoreList.contains(c)) continue;
            Set refs = (Set)c.getUserData("internal.references");
            ArrayList<org.hl7.fhir.r5.elementmodel.Element> ignoreList2 = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
            ignoreList2.addAll(ignoreList);
            ignoreList2.add(c);
            if (refs == null || !refs.contains(id) || !this.isReferencedFromBase(c, baseRefs, containedList, ignoreList2)) continue;
            return true;
        }
        return false;
    }

    private boolean checkResourceName(StructureDefinition defn, String resourceName, Manager.FhirFormat format) {
        String xn;
        if (resourceName.equals(defn.getType())) {
            return true;
        }
        if (resourceName.equals(defn.getTypeTail())) {
            return true;
        }
        return format == Manager.FhirFormat.XML && resourceName.equals(xn = ToolingExtensions.readStringExtension((DomainResource)defn, (String)"http://hl7.org/fhir/tools/StructureDefinition/xml-name"));
    }

    private String errorIds(String path, boolean ok, List<ValidationMessage> errors) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ValidationMessage vm : errors) {
            if (!vm.isError()) continue;
            b.append(vm.getMessageId());
        }
        String s = b.toString();
        return s;
    }

    private boolean typeMatchesDefn(String name, StructureDefinition defn) {
        if (defn.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            return name.equals(defn.getType()) || name.equals(defn.getName()) || name.equals(defn.getId());
        }
        return name.matches(defn.getType());
    }

    private NodeStack getFirstEntry(NodeStack bundle) {
        ArrayList list = new ArrayList();
        bundle.getElement().getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.elementmodel.Element resource = ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getNamedChild("resource", false);
        if (resource == null) {
            return null;
        }
        NodeStack entry = bundle.push((org.hl7.fhir.r5.elementmodel.Element)list.get(0), 0, ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition(), ((org.hl7.fhir.r5.elementmodel.Element)list.get(0)).getProperty().getDefinition());
        return entry.push(resource, -1, resource.getProperty().getDefinition(), this.context.fetchTypeDefinition(resource.fhirType()).getSnapshot().getElementFirstRep());
    }

    private boolean valueMatchesCriteria(org.hl7.fhir.r5.elementmodel.Element value, ElementDefinition criteria, StructureDefinition profile) throws FHIRException {
        if (criteria.hasFixed()) {
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            this.checkFixedValue(msgs, "{virtual}", value, (Element)criteria.getFixed(), profile.getVersionedUrl(), "value", null, false, "");
            return msgs.size() == 0;
        }
        if (criteria.hasBinding() && criteria.getBinding().getStrength() == Enumerations.BindingStrength.REQUIRED && criteria.getBinding().hasValueSet()) {
            throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__slice_matching_by_value_set_not_done", new Object[0]));
        }
        throw new FHIRException(this.context.formatMessage("Unable_to_resolve_slice_matching__no_fixed_value_or_required_value_set", new Object[0]));
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= this.thisYear() + 80;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int thisYear() {
        return Calendar.getInstance().get(1);
    }

    public long timeNoTX() {
        return (this.timeTracker.getOverall() - this.timeTracker.getTxTime()) / 1000000L;
    }

    public String reportTimes() {
        String s = String.format("Times (ms): overall = %d:4, tx = %d, sd = %d, load = %d, fpe = %d, spec = %d", this.timeTracker.getOverall() / 1000000L, this.timeTracker.getTxTime() / 1000000L, this.timeTracker.getSdTime() / 1000000L, this.timeTracker.getLoadTime() / 1000000L, this.timeTracker.getFpeTime() / 1000000L, this.timeTracker.getSpecTime() / 1000000L);
        this.timeTracker.reset();
        return s;
    }

    public boolean isNoBindingMsgSuppressed() {
        return this.noBindingMsgSuppressed;
    }

    public IResourceValidator setNoBindingMsgSuppressed(boolean noBindingMsgSuppressed) {
        this.noBindingMsgSuppressed = noBindingMsgSuppressed;
        return this;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public IResourceValidator setNoTerminologyChecks(boolean noTerminologyChecks) {
        this.noTerminologyChecks = noTerminologyChecks;
        return this;
    }

    public void checkAllInvariants() {
        for (StructureDefinition sd : new ContextUtilities(this.context).allStructures()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!inv.hasExpression()) continue;
                    try {
                        ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
                        if (n == null) {
                            n = this.fpe.parse(FHIRPathExpressionFixer.fixExpr(inv.getExpression(), inv.getKey(), this.context.getVersion()));
                            inv.setUserData("validator.expression.cache", (Object)n);
                        }
                        this.fpe.check(null, sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE ? sd.getType() : "DomainResource", ed.getPath(), n);
                    }
                    catch (Exception e) {
                        System.out.println("Error processing structure [" + sd.getId() + "] path " + ed.getPath() + ":" + inv.getKey() + " ('" + inv.getExpression() + "'): " + e.getMessage());
                    }
                }
            }
        }
    }

    public FHIRPathEngine.IEvaluationContext getExternalHostServices() {
        return this.externalHostServices;
    }

    public String getValidationLanguage() {
        return this.validationLanguage;
    }

    public void setValidationLanguage(String validationLanguage) {
        this.validationLanguage = validationLanguage;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history") && parts.length >= 4) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    public ValidationResult checkCodeOnServer(NodeStack stack, ValueSet vs, String value, ValidationOptions options) {
        String lang = this.getValidationOptionsLanguage(stack);
        return this.checkForInactive(this.filterOutSpecials(stack.getLiteralPath(), vs, this.context.validateCode(options.withLanguage(lang), value, vs)), (DataType)new CodeType(value));
    }

    public String getValidationOptionsLanguage(NodeStack stack) {
        if (stack.getWorkingLang() != null) {
            return stack.getWorkingLang();
        }
        if (this.validationLanguage != null) {
            return this.validationLanguage;
        }
        if (this.context.getLocale() != null) {
            return this.context.getLocale().toLanguageTag();
        }
        return Locale.US.toLanguageTag();
    }

    public ValidationResult checkCodeOnServer(NodeStack stack, String code, String system, String version, String display, boolean checkDisplay) {
        String lang = this.getValidationOptionsLanguage(stack);
        this.codingObserver.seeCode(stack, system, version, code, display);
        return this.checkForInactive(this.filterOutSpecials(stack.getLiteralPath(), null, this.context.validateCode(this.baseOptions.withLanguage(lang), system, version, code, checkDisplay ? display : null)), (DataType)new Coding(system, version, code, display));
    }

    public ValidationResult checkCodeOnServer(NodeStack stack, ValueSet valueset, Coding c) {
        this.codingObserver.seeCode(stack, c);
        String lang = this.getValidationOptionsLanguage(stack);
        return this.checkForInactive(this.filterOutSpecials(stack.getLiteralPath(), valueset, this.context.validateCode(this.baseOptions.withLanguage(lang), c, valueset)), (DataType)c);
    }

    public ValidationResult checkCodeOnServer(NodeStack stack, ValueSet valueset, CodeableConcept cc) throws CheckCodeOnServerException {
        this.codingObserver.seeCode(stack, cc);
        try {
            String lang = this.getValidationOptionsLanguage(stack);
            return this.checkForInactive(this.filterOutSpecials(stack.getLiteralPath(), valueset, this.context.validateCode(this.baseOptions.withLanguage(lang), cc, valueset)), (DataType)cc);
        }
        catch (Exception e) {
            throw new CheckCodeOnServerException(e);
        }
    }

    private ValidationResult filterOutSpecials(String path, ValueSet vs, ValidationResult vr) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : vr.getIssues()) {
            if (!iss.hasDetails() || !iss.getDetails().hasText() || !iss.getDetails().getText().startsWith("Unable to resolve system - value set expansion has no matches for code 'http://hl7.org/fhirpath/System")) continue;
            return new ValidationResult("http://hl7.org/fhirpath/System", null, null, null);
        }
        return vr;
    }

    private ValidationResult checkForInactive(ValidationResult res, DataType coded) {
        if (res == null) {
            return null;
        }
        if (!res.isInactive()) {
            return res;
        }
        for (OperationOutcome.OperationOutcomeIssueComponent iss : res.getIssues()) {
            if (!iss.getDetails().getText().contains("not active")) continue;
            return res;
        }
        OperationOutcome.IssueSeverity lvl = OperationOutcome.IssueSeverity.INFORMATION;
        String status = "not active";
        if (res.getStatus() != null) {
            status = res.getStatus();
        }
        String code = res.getCode();
        OperationOutcome.OperationOutcomeIssueComponent op = new OperationOutcome.OperationOutcomeIssueComponent(lvl, OperationOutcome.IssueType.INVALID);
        String msgId = null;
        msgId = code != null ? (res.isOk() ? "STATUS_CODE_WARNING_CODE" : "STATUS_CODE_HINT_CODE") : (res.isOk() ? "STATUS_CODE_WARNING" : "STATUS_CODE_HINT");
        op.getDetails().setText(this.context.formatMessage(msgId, new Object[]{status, code}));
        if (res.getServer() != null) {
            op.addExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-server", (DataType)new UrlType(res.getServer()));
        }
        if (coded instanceof CodeType) {
            op.addExpression(coded.fhirType());
            op.addLocation(coded.fhirType());
        } else if (coded instanceof Coding) {
            op.addExpression(coded.fhirType() + ".code");
            op.addLocation(coded.fhirType() + ".code");
        } else if (coded instanceof CodeableConcept) {
            CodeableConcept cc = (CodeableConcept)coded;
            if (cc.getCoding().size() == 1) {
                op.addExpression(coded.fhirType() + ".coding[0].code");
                op.addLocation(coded.fhirType() + ".coding[0].code");
            } else {
                op.addExpression(coded.fhirType());
                op.addLocation(coded.fhirType());
            }
        }
        res.getIssues().add(op);
        return res;
    }

    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    public void setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
    }

    public List<BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    public boolean isValidateValueSetCodesOnTxServer() {
        return this.validateValueSetCodesOnTxServer;
    }

    public void setValidateValueSetCodesOnTxServer(boolean value) {
        this.validateValueSetCodesOnTxServer = value;
    }

    public boolean isNoCheckAggregation() {
        return this.noCheckAggregation;
    }

    public void setNoCheckAggregation(boolean noCheckAggregation) {
        this.noCheckAggregation = noCheckAggregation;
    }

    public boolean isAllowDoubleQuotesInFHIRPath() {
        return this.allowDoubleQuotesInFHIRPath;
    }

    public void setAllowDoubleQuotesInFHIRPath(boolean allowDoubleQuotesInFHIRPath) {
        this.allowDoubleQuotesInFHIRPath = allowDoubleQuotesInFHIRPath;
    }

    public static org.hl7.fhir.r5.elementmodel.Element setParents(org.hl7.fhir.r5.elementmodel.Element element) {
        if (element != null && !element.hasParentForValidator()) {
            element.setParentForValidator(null);
            InstanceValidator.setParentsInner(element);
        }
        return element;
    }

    public static Base setParentsBase(Base element) {
        if (element instanceof org.hl7.fhir.r5.elementmodel.Element) {
            InstanceValidator.setParents((org.hl7.fhir.r5.elementmodel.Element)element);
        }
        return element;
    }

    public static void setParentsInner(org.hl7.fhir.r5.elementmodel.Element element) {
        for (org.hl7.fhir.r5.elementmodel.Element child : element.getChildren()) {
            child.setParentForValidator(element);
            InstanceValidator.setParentsInner(child);
        }
    }

    public void setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
    }

    public QuestionnaireMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public boolean isWantCheckSnapshotUnchanged() {
        return this.wantCheckSnapshotUnchanged;
    }

    public void setWantCheckSnapshotUnchanged(boolean wantCheckSnapshotUnchanged) {
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
    }

    public ValidationOptions getBaseOptions() {
        return this.baseOptions;
    }

    public void setBaseOptions(ValidationOptions baseOptions) {
        this.baseOptions = baseOptions;
    }

    public boolean isNoUnicodeBiDiControlChars() {
        return this.noUnicodeBiDiControlChars;
    }

    public void setNoUnicodeBiDiControlChars(boolean noUnicodeBiDiControlChars) {
        this.noUnicodeBiDiControlChars = noUnicodeBiDiControlChars;
    }

    public HtmlInMarkdownCheck getHtmlInMarkdownCheck() {
        return this.htmlInMarkdownCheck;
    }

    public void setHtmlInMarkdownCheck(HtmlInMarkdownCheck htmlInMarkdownCheck) {
        this.htmlInMarkdownCheck = htmlInMarkdownCheck;
    }

    public Coding getJurisdiction() {
        return this.jurisdiction;
    }

    public IResourceValidator setJurisdiction(Coding jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public void setLogProgress(boolean logProgress) {
        this.logProgress = logProgress;
    }

    public boolean isDisplayWarnings() {
        return this.baseOptions.isDisplayWarningMode();
    }

    public void setDisplayWarnings(boolean displayWarnings) {
        this.baseOptions.setDisplayWarningMode(displayWarnings);
    }

    public boolean isCheckIPSCodes() {
        return this.codingObserver.isCheckIPSCodes();
    }

    public void setCheckIPSCodes(boolean checkIPSCodes) {
        this.codingObserver.setCheckIPSCodes(checkIPSCodes);
    }

    @Override
    public InstanceValidator setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        if (forPublication) {
            this.warnOnDraftOrExperimental = true;
        }
        return this;
    }

    public boolean isWarnOnDraftOrExperimental() {
        return this.warnOnDraftOrExperimental;
    }

    public InstanceValidator setWarnOnDraftOrExperimental(boolean warnOnDraftOrExperimental) {
        this.warnOnDraftOrExperimental = warnOnDraftOrExperimental;
        return this;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public boolean isExample() {
        return this.example;
    }

    public IResourceValidator setExample(boolean example) {
        this.example = example;
        return this;
    }

    public IDigitalSignatureServices getSignatureServices() {
        return this.signatureServices;
    }

    public void setSignatureServices(IDigitalSignatureServices signatureServices) {
        this.signatureServices = signatureServices;
    }

    public IResourceValidator setBestPracticeWarningLevel(BestPracticeWarningLevel value) {
        this.bpWarnings = value == null ? BestPracticeWarningLevel.Warning : value;
        return this;
    }

    public IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    public IResourceValidator setFetcher(IValidatorResourceFetcher value) {
        this.fetcher = value;
        return this;
    }

    public boolean isUnknownCodeSystemsCauseErrors() {
        return this.unknownCodeSystemsCauseErrors;
    }

    public void setUnknownCodeSystemsCauseErrors(boolean unknownCodeSystemsCauseErrors) {
        this.unknownCodeSystemsCauseErrors = unknownCodeSystemsCauseErrors;
    }

    public boolean isNoExperimentalContent() {
        return this.noExperimentalContent;
    }

    public void setNoExperimentalContent(boolean noExperimentalContent) {
        this.noExperimentalContent = noExperimentalContent;
    }

    public void resetTimes() {
        this.timeTracker.reset();
    }

    static class CheckCodeOnServerException
    extends Exception {
        public CheckCodeOnServerException(Exception e) {
            super(e);
        }
    }

    private class ValidatorHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private ValidatorHostServices() {
        }

        public List<Base> resolveConstant(FHIRPathEngine engine, Object appContext, String name, boolean beforeContext, boolean explicitConstant) throws PathEngineException {
            ValidationContext c = (ValidationContext)appContext;
            if ("profile".equals(name) && explicitConstant) {
                ArrayList<Base> b = new ArrayList<Base>();
                if (c.getProfile() != null) {
                    b.add((Base)c.getProfile());
                }
                return b;
            }
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstant(engine, c.getAppContext(), name, beforeContext, explicitConstant);
            }
            return new ArrayList<Base>();
        }

        public TypeDetails resolveConstantType(FHIRPathEngine engine, Object appContext, String name, boolean explicitConstant) throws PathEngineException {
            if (appContext instanceof StructureMapValidator.VariableSet) {
                StructureMapValidator.VariableSet vars = (StructureMapValidator.VariableSet)appContext;
                StructureMapValidator.VariableDefn v = vars.getVariable(name.substring(1));
                if (v != null && v.hasTypeInfo()) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{v.getWorkingType()});
                }
                return null;
            }
            ValidationContext c = (ValidationContext)appContext;
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.resolveConstantType(engine, c.getAppContext(), name, explicitConstant);
            }
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.this.externalHostServices.log(argument, focus);
            }
            return false;
        }

        public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine engine, String functionName) {
            switch (functionName) {
                case "slice": {
                    return new FHIRPathUtilityClasses.FunctionDetails("Returns the given slice as defined in the given structure definition. If in an invariant, First parameter can be %profile - current profile", 2, 2);
                }
                case "getResourceKey": {
                    return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource", 0, 0);
                }
                case "getReferenceKey": {
                    return new FHIRPathUtilityClasses.FunctionDetails("Unique Key for resource that is the target of the reference", 0, 1);
                }
            }
            return null;
        }

        public TypeDetails checkFunction(FHIRPathEngine engine, Object appContext, String functionName, TypeDetails focus, List<TypeDetails> parameters) throws PathEngineException {
            switch (functionName) {
                case "slice": {
                    return focus;
                }
                case "getResourceKey": {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"string"});
                }
                case "getReferenceKey": {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[]{"string"});
                }
            }
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicescheckFunction", new Object[0]));
        }

        public List<Base> executeFunction(FHIRPathEngine engine, Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
            switch (functionName) {
                case "slice": {
                    return this.executeSlice(engine, appContext, focus, parameters);
                }
                case "getResourceKey": {
                    return this.executeResourceKey(focus);
                }
                case "getReferenceKey": {
                    return this.executeReferenceKey(null, focus, parameters);
                }
            }
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesexecuteFunction", new Object[0]));
        }

        private List<Base> executeResourceKey(List<Base> focus) {
            ArrayList<Base> base = new ArrayList<Base>();
            if (focus.size() == 1) {
                Base res = focus.get(0);
                base.add((Base)new StringType(res.fhirType() + "/" + res.getIdBase()));
            }
            return base;
        }

        private List<Base> executeReferenceKey(Base rootResource, List<Base> focus, List<List<Base>> parameters) {
            ArrayList<Base> base = new ArrayList<Base>();
            if (focus.size() == 1) {
                Base res = focus.get(0);
                String ref = null;
                if (res.fhirType().equals("Reference")) {
                    ref = this.getRef(res);
                } else if (res.isPrimitive()) {
                    ref = res.primitiveValue();
                } else {
                    throw new FHIRException("Unable to generate a reference key based on a " + res.fhirType());
                }
                base.add((Base)new StringType(ref));
            }
            return base;
        }

        private String getRef(Base res) {
            Property prop = res.getChildByName("reference");
            if (prop != null && prop.getValues().size() == 1) {
                return ((Base)prop.getValues().get(0)).primitiveValue();
            }
            return null;
        }

        private List<Base> executeSlice(FHIRPathEngine engine, Object appContext, List<Base> focus, List<List<Base>> parameters) {
            ValidationContext c = (ValidationContext)appContext;
            ArrayList<Base> res = new ArrayList<Base>();
            if (parameters.size() != 2 && !(appContext instanceof ValidationContext)) {
                return res;
            }
            StructureDefinition sd = null;
            if (parameters.get(0).size() > 1) {
                return res;
            }
            if (parameters.get(0).size() == 1) {
                Base b = parameters.get(0).get(0);
                if (b.isPrimitive()) {
                    sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, b.primitiveValue());
                } else if (b instanceof StructureDefinition) {
                    sd = (StructureDefinition)b;
                }
            } else {
                sd = c.getProfile();
            }
            if (parameters.get(1).size() != 1) {
                return res;
            }
            String name = parameters.get(1).get(0).primitiveValue();
            if (!Utilities.noString((String)name)) {
                for (Base b : focus) {
                    org.hl7.fhir.r5.elementmodel.Element e;
                    if (!(b instanceof org.hl7.fhir.r5.elementmodel.Element) || !(e = (org.hl7.fhir.r5.elementmodel.Element)b).hasSlice(sd, name)) continue;
                    res.add((Base)e);
                }
            }
            return res;
        }

        public Base resolveReference(FHIRPathEngine engine, Object appContext, String url, Base refContext) throws FHIRException {
            Base res;
            ValidationContext c = (ValidationContext)appContext;
            if (refContext != null && refContext.hasUserData("validator.bundle.resolution")) {
                return (Base)refContext.getUserData("validator.bundle.resolution");
            }
            if (c.getAppContext() instanceof org.hl7.fhir.r5.elementmodel.Element) {
                for (org.hl7.fhir.r5.elementmodel.Element element = (org.hl7.fhir.r5.elementmodel.Element)c.getAppContext(); element != null; element = element.getParentForValidator()) {
                    Base res2 = InstanceValidator.this.resolveInBundle(url, element);
                    if (res2 == null) continue;
                    return res2;
                }
            }
            if ((res = InstanceValidator.this.resolveInBundle(url, c.getResource())) != null) {
                return res;
            }
            for (org.hl7.fhir.r5.elementmodel.Element element = c.getRootResource(); element != null; element = element.getParentForValidator()) {
                res = InstanceValidator.this.resolveInBundle(url, element);
                if (res == null) continue;
                return res;
            }
            if (InstanceValidator.this.externalHostServices != null) {
                return InstanceValidator.setParentsBase(InstanceValidator.this.externalHostServices.resolveReference(engine, c.getAppContext(), url, refContext));
            }
            if (InstanceValidator.this.fetcher != null) {
                try {
                    return InstanceValidator.setParents(InstanceValidator.this.fetcher.fetch((IResourceValidator)InstanceValidator.this, c.getAppContext(), url));
                }
                catch (IOException e) {
                    throw new FHIRException((Throwable)e);
                }
            }
            throw new Error(InstanceValidator.this.context.formatMessage("Not_done_yet__resolve__locally_2", new Object[]{url}));
        }

        public boolean conformsToProfile(FHIRPathEngine engine, Object appContext, Base item, String url) throws FHIRException {
            org.hl7.fhir.r5.elementmodel.Element e;
            ValidationContext ctxt = (ValidationContext)appContext;
            StructureDefinition sd = (StructureDefinition)InstanceValidator.this.context.fetchResource(StructureDefinition.class, url);
            if (sd == null) {
                throw new FHIRException(InstanceValidator.this.context.formatMessage("Unable_to_resolve_", new Object[]{url}));
            }
            InstanceValidator self = InstanceValidator.this;
            ArrayList<ValidationMessage> valerrors = new ArrayList<ValidationMessage>();
            Base.ValidationMode mode = new Base.ValidationMode(Base.ValidationReason.Expression, Base.ProfileSource.FromExpression);
            if (item instanceof Resource) {
                try {
                    e = new ObjectConverter(InstanceValidator.this.context).convert((Resource)item);
                    InstanceValidator.setParents(e);
                    self.validateResource(new ValidationContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, null, e, InstanceValidator.this.validationLanguage), null, mode, false, false);
                }
                catch (IOException e1) {
                    throw new FHIRException((Throwable)e1);
                }
            } else if (item instanceof org.hl7.fhir.r5.elementmodel.Element) {
                e = (org.hl7.fhir.r5.elementmodel.Element)item;
                if (e.getSpecial() == Element.SpecialElement.CONTAINED) {
                    self.validateResource(new ValidationContext(ctxt.getAppContext(), e, ctxt.getRootResource(), ctxt.getGroupingResource()), valerrors, e, e, sd, IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, null, e, InstanceValidator.this.validationLanguage), null, mode, false, false);
                } else if (e.getSpecial() != null) {
                    self.validateResource(new ValidationContext(ctxt.getAppContext(), e, e, ctxt.getRootResource()), valerrors, e, e, sd, IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, null, e, InstanceValidator.this.validationLanguage), null, mode, false, false);
                } else {
                    self.validateResource(new ValidationContext(ctxt.getAppContext(), e), valerrors, e, e, sd, IdStatus.OPTIONAL, new NodeStack(InstanceValidator.this.context, null, e, InstanceValidator.this.validationLanguage), null, mode, false, false);
                }
            } else {
                throw new NotImplementedException(InstanceValidator.this.context.formatMessage("Not_done_yet_ValidatorHostServicesconformsToProfile_when_item_is_not_an_element", new Object[0]));
            }
            boolean ok = true;
            ArrayList<ValidationMessage> record = new ArrayList<ValidationMessage>();
            for (ValidationMessage v : valerrors) {
                boolean bl = ok = ok && !v.getLevel().isError();
                if (!v.getLevel().isError() && !v.isSlicingHint()) continue;
                record.add(v);
            }
            if (!ok && !record.isEmpty()) {
                ctxt.sliceNotes(url, record);
            }
            return ok;
        }

        public ValueSet resolveValueSet(FHIRPathEngine engine, Object appContext, String url) {
            ValidationContext c = (ValidationContext)appContext;
            if (c.getProfile() != null && url.startsWith("#")) {
                for (Resource r : c.getProfile().getContained()) {
                    if (!r.getId().equals(url.substring(1))) continue;
                    if (r instanceof ValueSet) {
                        return (ValueSet)r;
                    }
                    throw new FHIRException(InstanceValidator.this.context.formatMessage("Reference__refers_to_a__not_a_ValueSet", new Object[]{url, r.fhirType()}));
                }
                return null;
            }
            return (ValueSet)InstanceValidator.this.context.findTxResource(ValueSet.class, url);
        }

        public boolean paramIsType(String name, int index) {
            return false;
        }
    }

    public static enum BindingContext {
        BASE,
        MAXVS,
        ADDITIONAL;

    }
}

