/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.PercentageTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ObservationValidator
extends BaseValidator {
    public ObservationValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateObservation(ValidationContext valContext, List<ValidationMessage> errors, Element element, NodeStack stack, PercentageTracker pct, Base.ValidationMode mode) {
        boolean ok = true;
        ok = this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject", false) != null, "All_observations_should_have_a_subject", new Object[0]) && ok;
        ArrayList performers = new ArrayList();
        element.getNamedChildren("performer", performers);
        ok = this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), performers.size() > 0, "All_observations_should_have_a_performer", new Object[0]) && ok;
        ok = this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime", false) != null || element.getNamedChild("effectivePeriod", false) != null || element.getNamedChild("effectiveTiming", false) != null || element.getNamedChild("effectiveInstant", false) != null, "All_observations_should_have_an_effectiveDateTime_or_an_effectivePeriod", element.getProperty().typeSummary()) && ok;
        return ok;
    }
}

