/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.context.SystemOutLoggingService;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.spreadsheets.CodeSystemSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.ConceptMapSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.StructureDefinitionSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.ValueSetSpreadsheetGenerator;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.SystemExitManager;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.JsonLangFileProducer;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.i18n.PoGetTextProducer;
import org.hl7.fhir.utilities.i18n.XLIFFProducer;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.IgLoader;
import org.hl7.fhir.validation.ResourceChecker;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.ValidationRecord;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.model.FileInfo;
import org.hl7.fhir.validation.cli.model.ValidatedFragments;
import org.hl7.fhir.validation.cli.model.ValidationOutcome;
import org.hl7.fhir.validation.cli.model.ValidationRequest;
import org.hl7.fhir.validation.cli.model.ValidationResponse;
import org.hl7.fhir.validation.cli.model.ValidationTime;
import org.hl7.fhir.validation.cli.renderers.CSVRenderer;
import org.hl7.fhir.validation.cli.renderers.CompactRenderer;
import org.hl7.fhir.validation.cli.renderers.DefaultRenderer;
import org.hl7.fhir.validation.cli.renderers.ESLintCompactRenderer;
import org.hl7.fhir.validation.cli.renderers.NativeRenderer;
import org.hl7.fhir.validation.cli.renderers.ValidationOutputRenderer;
import org.hl7.fhir.validation.cli.services.HTMLOutputGenerator;
import org.hl7.fhir.validation.cli.services.PassiveExpiringSessionCache;
import org.hl7.fhir.validation.cli.services.SessionCache;
import org.hl7.fhir.validation.cli.services.StandAloneValidatorFetcher;
import org.hl7.fhir.validation.cli.services.ValidatorWatchMode;
import org.hl7.fhir.validation.cli.utils.Common;
import org.hl7.fhir.validation.cli.utils.EngineMode;
import org.hl7.fhir.validation.cli.utils.VersionSourceInformation;

public class ValidationService {
    private final SessionCache sessionCache;
    private String runDate;
    private final Map<String, ValidationEngine> baseEngines = new ConcurrentHashMap<String, ValidationEngine>();
    private int cp;
    private int cs;

    public void putBaseEngine(String key, CliContext cliContext) throws IOException, URISyntaxException {
        if (cliContext.getSv() == null) {
            throw new IllegalArgumentException("Cannot create a base engine without an explicit version");
        }
        String definitions = VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        ValidationEngine baseEngine = this.buildValidationEngine(cliContext, definitions, new TimeTracker());
        this.baseEngines.put(key, baseEngine);
    }

    public ValidationEngine getBaseEngine(String key) {
        return this.baseEngines.get(key);
    }

    public Set<String> getBaseEngineKeys() {
        return this.baseEngines.keySet();
    }

    public boolean hasBaseEngineForKey(String key) {
        return this.baseEngines.containsKey(key);
    }

    public ValidationService() {
        this.sessionCache = new PassiveExpiringSessionCache();
        this.runDate = new SimpleDateFormat("hh:mm:ss", new Locale("en", "US")).format(new Date());
    }

    public ValidationService(SessionCache cache) {
        this.sessionCache = cache;
    }

    public ValidationResponse validateSources(ValidationRequest request) throws Exception {
        TimeTracker timeTracker = new TimeTracker();
        String sessionId = this.initializeValidator(request.getCliContext(), null, timeTracker, request.sessionId);
        ValidationEngine validationEngine = this.sessionCache.fetchSessionValidatorEngine(sessionId);
        validationEngine.setLanguage(request.getCliContext().getLang());
        validationEngine.setLocale(request.getCliContext().getLocale());
        if (request.getCliContext().getProfiles().size() > 0) {
            System.out.println("  .. validate " + request.listSourceFiles() + " against " + request.getCliContext().getProfiles().toString());
        } else {
            System.out.println("  .. validate " + request.listSourceFiles());
        }
        ValidationResponse response = new ValidationResponse().setSessionId(sessionId).setValidationTimes(new HashMap<String, ValidationTime>());
        for (FileInfo fileToValidate : request.getFilesToValidate()) {
            Manager.FhirFormat format;
            if (fileToValidate.getFileType() == null && (format = ResourceChecker.checkIsResource(validationEngine.getContext(), false, fileToValidate.getFileContent().getBytes(), fileToValidate.getFileName(), false)) != null) {
                fileToValidate.setFileType(format.getExtension());
            }
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            if (fileToValidate.getFileType() == null) {
                ValidationOutcome outcome = this.getValidationOutcomeForUnknownFileFormat(new FileInfo(fileToValidate.getFileName(), fileToValidate.getFileContent(), null));
                response.addOutcome(outcome);
                continue;
            }
            ValidatedFragments validatedFragments = validationEngine.validateAsFragments(fileToValidate.getFileContent().getBytes(), Manager.FhirFormat.getFhirFormat((String)fileToValidate.getFileType()), request.getCliContext().getProfiles(), messages);
            List<ValidationOutcome> validationOutcomes = this.getValidationOutcomesFromValidatedFragments(fileToValidate, validatedFragments);
            for (ValidationOutcome validationOutcome : validationOutcomes) {
                response.addOutcome(validationOutcome);
            }
            if (!request.getCliContext().isShowTimes()) continue;
            response.getValidationTimes().put(fileToValidate.getFileName(), validatedFragments.getValidationTime());
        }
        System.out.println("  Max Memory: " + Runtime.getRuntime().maxMemory());
        return response;
    }

    private List<ValidationOutcome> getValidationOutcomesFromValidatedFragments(FileInfo fileToValidate, ValidatedFragments validatedFragments) {
        LinkedList<ValidationOutcome> outcomes = new LinkedList<ValidationOutcome>();
        if (validatedFragments.getValidatedFragments().size() == 1 && !validatedFragments.getValidatedFragments().get(0).isDerivedContent()) {
            ValidatedFragment validatedFragment = validatedFragments.getValidatedFragments().get(0);
            ValidationOutcome outcome = new ValidationOutcome();
            FileInfo fileInfo = new FileInfo(fileToValidate.getFileName(), new String(validatedFragment.getContent()), validatedFragment.getExtension());
            outcome.setMessages(validatedFragment.getErrors());
            outcome.setFileInfo(fileInfo);
            outcomes.add(outcome);
        } else {
            for (ValidatedFragment validatedFragment : validatedFragments.getValidatedFragments()) {
                ValidationOutcome outcome = new ValidationOutcome();
                FileInfo fileInfo = new FileInfo(validatedFragment.getFilename(), new String(validatedFragment.getContent()), validatedFragment.getExtension());
                outcome.setMessages(validatedFragment.getErrors());
                outcome.setFileInfo(fileInfo);
                outcomes.add(outcome);
            }
        }
        return outcomes;
    }

    private ValidationOutcome getValidationOutcomeForUnknownFileFormat(FileInfo fileInfo) {
        ValidationOutcome outcome = new ValidationOutcome();
        ArrayList<ValidationMessage> errorList = new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage().setType(ValidationMessage.IssueType.EXCEPTION).setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("Unable to infer format from file. Please check that your file is in a valid FHIR format."));
            }
        };
        outcome.setMessages((List<ValidationMessage>)errorList);
        outcome.setFileInfo(fileInfo);
        return outcome;
    }

    public VersionSourceInformation scanForVersions(CliContext cliContext) throws IOException {
        VersionSourceInformation versions = new VersionSourceInformation();
        IgLoader igLoader = new IgLoader(new FilesystemPackageCacheManager.Builder().build(), new SimpleWorkerContext.SimpleWorkerContextBuilder().fromNothing(), null);
        for (String src : cliContext.getIgs()) {
            igLoader.scanForIgVersion(src, cliContext.isRecursive(), versions);
        }
        igLoader.scanForVersions(cliContext.getSources(), versions);
        return versions;
    }

    public void validateSources(CliContext cliContext, ValidationEngine validator, ValidatorWatchMode watch, int watchScanDelay, int watchSettleTime) throws Exception {
        if (cliContext.getProfiles().size() > 0) {
            System.out.println("  Profiles: " + cliContext.getProfiles());
        }
        IgLoader igLoader = new IgLoader(validator.getPcm(), validator.getContext(), validator.getVersion());
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        int ec = 0;
        boolean first = true;
        do {
            long start = System.currentTimeMillis();
            Resource r = validator.validate(cliContext.getSources(), cliContext.getProfiles(), refs, records, igLoader, watch == ValidatorWatchMode.ALL, watchSettleTime, first);
            first = false;
            boolean statusNeeded = false;
            if (r != null) {
                statusNeeded = true;
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                System.out.println("Done. " + validator.getContext().clock().report() + ". Memory = " + Utilities.describeSize((long)(mbean.getHeapMemoryUsage().getUsed() + mbean.getNonHeapMemoryUsage().getUsed())));
                System.out.println();
                PrintStream dst = null;
                ValidationOutputRenderer renderer = this.makeValidationOutputRenderer(cliContext);
                renderer.setCrumbTrails(validator.isCrumbTrails());
                renderer.setRunDate(this.runDate);
                if (renderer.isSingleFile()) {
                    dst = cliContext.getOutput() == null ? System.out : new PrintStream(ManagedFileAccess.outStream((String)cliContext.getOutput()));
                    renderer.setOutput(dst);
                } else {
                    File dir = ManagedFileAccess.file((String)cliContext.getOutput());
                    if (!dir.isDirectory()) {
                        throw new Error("The output location " + dir.getAbsolutePath() + " must be an existing directory for the output style " + renderer.getStyleCode());
                    }
                    renderer.setFolder(dir);
                }
                if (r instanceof Bundle) {
                    if (renderer.handlesBundleDirectly()) {
                        renderer.render((Bundle)r);
                    } else {
                        renderer.start(((Bundle)r).getEntry().size() > 1);
                        for (Bundle.BundleEntryComponent e : ((Bundle)r).getEntry()) {
                            OperationOutcome op = (OperationOutcome)e.getResource();
                            ec += this.countErrors(op);
                            renderer.render(op);
                        }
                        renderer.finish();
                    }
                } else if (r == null) {
                    ++ec;
                    System.out.println("No output from validation - nothing to validate");
                } else {
                    renderer.start(false);
                    OperationOutcome op = (OperationOutcome)r;
                    ec = this.countErrors(op);
                    renderer.render((OperationOutcome)r);
                    renderer.finish();
                }
                if (cliContext.getOutput() != null && dst != null) {
                    dst.close();
                }
                if (cliContext.getHtmlOutput() != null) {
                    String html = new HTMLOutputGenerator(records).generate(System.currentTimeMillis() - start);
                    TextFile.stringToFile((String)html, (String)cliContext.getHtmlOutput());
                    System.out.println("HTML Summary in " + cliContext.getHtmlOutput());
                }
            }
            if (watch == ValidatorWatchMode.NONE) continue;
            if (statusNeeded) {
                System.out.println("Watching for changes (" + Integer.toString(watchScanDelay) + "ms cycle)");
            }
            Thread.sleep(watchScanDelay);
        } while (watch != ValidatorWatchMode.NONE);
        if (ec > 0) {
            SystemExitManager.setError((int)1);
        }
    }

    private int countErrors(OperationOutcome oo) {
        int error = 0;
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            if (issue.getSeverity() != OperationOutcome.IssueSeverity.FATAL && issue.getSeverity() != OperationOutcome.IssueSeverity.ERROR) continue;
            ++error;
        }
        return error;
    }

    private ValidationOutputRenderer makeValidationOutputRenderer(CliContext cliContext) {
        String style = cliContext.getOutputStyle();
        if (Utilities.noString((String)style)) {
            if (cliContext.getOutput() == null) {
                return new DefaultRenderer();
            }
            if (cliContext.getOutput().endsWith(".json")) {
                return new NativeRenderer(Manager.FhirFormat.JSON);
            }
            return new NativeRenderer(Manager.FhirFormat.XML);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"eslint-compact"})) {
            return new ESLintCompactRenderer();
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"compact-split"})) {
            return new CompactRenderer(true);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"compact"})) {
            return new CompactRenderer(false);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"csv"})) {
            return new CSVRenderer();
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"xml"})) {
            return new NativeRenderer(Manager.FhirFormat.XML);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"json"})) {
            return new NativeRenderer(Manager.FhirFormat.JSON);
        }
        System.out.println("Unknown output style '" + style + "'");
        return new DefaultRenderer();
    }

    public void convertSources(CliContext cliContext, ValidationEngine validator) throws Exception {
        if (!(cliContext.getOutput() == null ^ cliContext.getOutputSuffix() == null)) {
            throw new Exception("Convert requires one of {-output, -outputSuffix} parameter to be set");
        }
        List<String> sources = cliContext.getSources();
        if (sources.size() == 1 && cliContext.getOutput() != null) {
            System.out.println(" ...convert");
            validator.convert(sources.get(0), cliContext.getOutput());
        } else {
            if (cliContext.getOutputSuffix() == null) {
                throw new Exception("Converting multiple/wildcard sources requires a -outputSuffix parameter to be set");
            }
            for (int i = 0; i < sources.size(); ++i) {
                String output = sources.get(i) + "." + cliContext.getOutputSuffix();
                validator.convert(sources.get(i), output);
                System.out.println(" ...convert [" + i + "] (" + sources.get(i) + " to " + output + ")");
            }
        }
    }

    public void evaluateFhirpath(CliContext cliContext, ValidationEngine validator) throws Exception {
        System.out.println(" ...evaluating " + cliContext.getFhirpath());
        System.out.println(validator.evaluateFhirPath(cliContext.getSources().get(0), cliContext.getFhirpath()));
    }

    public void generateSnapshot(CliContext cliContext, ValidationEngine validator) throws Exception {
        if (!(cliContext.getOutput() == null ^ cliContext.getOutputSuffix() == null)) {
            throw new Exception("Snapshot generation requires one of {-output, -outputSuffix} parameter to be set");
        }
        List<String> sources = cliContext.getSources();
        if (sources.size() == 1 && cliContext.getOutput() != null) {
            StructureDefinition r = validator.snapshot(sources.get(0), cliContext.getSv());
            System.out.println(" ...generated snapshot successfully");
            validator.handleOutput((Resource)r, cliContext.getOutput(), cliContext.getSv());
        } else {
            if (cliContext.getOutputSuffix() == null) {
                throw new Exception("Snapshot generation for multiple/wildcard sources requires a -outputSuffix parameter to be set");
            }
            for (int i = 0; i < sources.size(); ++i) {
                StructureDefinition r = validator.snapshot(sources.get(i), cliContext.getSv());
                String output = sources.get(i) + "." + cliContext.getOutputSuffix();
                validator.handleOutput((Resource)r, output, cliContext.getSv());
                System.out.println(" ...generated snapshot [" + i + "] successfully (" + sources.get(i) + " to " + output + ")");
            }
        }
    }

    public void generateNarrative(CliContext cliContext, ValidationEngine validator) throws Exception {
        Resource r = validator.generate(cliContext.getSources().get(0), cliContext.getSv());
        System.out.println(" ...generated narrative successfully");
        if (cliContext.getOutput() != null) {
            validator.handleOutput(r, cliContext.getOutput(), cliContext.getSv());
        }
    }

    public void transform(CliContext cliContext, ValidationEngine validator) throws Exception {
        if (cliContext.getSources().size() > 1) {
            throw new Exception("Can only have one source when doing a transform (found " + cliContext.getSources() + ")");
        }
        if (cliContext.getTxServer() == null) {
            throw new Exception("Must provide a terminology server when doing a transform");
        }
        if (cliContext.getMap() == null) {
            throw new Exception("Must provide a map when doing a transform");
        }
        try {
            ContextUtilities cu = new ContextUtilities((IWorkerContext)validator.getContext());
            List structures = cu.allStructures();
            for (StructureDefinition sd : structures) {
                if (sd.hasSnapshot()) continue;
                cu.generateSnapshot(sd);
            }
            validator.setMapLog(cliContext.getMapLog());
            Element r = validator.transform(cliContext.getSources().get(0), cliContext.getMap());
            System.out.println(" ...success");
            if (cliContext.getOutput() != null) {
                FileOutputStream s = ManagedFileAccess.outStream((String)cliContext.getOutput());
                if (cliContext.getOutput() != null && cliContext.getOutput().endsWith(".json")) {
                    new JsonParser((IWorkerContext)validator.getContext()).compose(r, (OutputStream)s, IParser.OutputStyle.PRETTY, null);
                } else {
                    new XmlParser((IWorkerContext)validator.getContext()).compose(r, (OutputStream)s, IParser.OutputStyle.PRETTY, null);
                }
                s.close();
            }
        }
        catch (Exception e) {
            System.out.println(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void compile(CliContext cliContext, ValidationEngine validator) throws Exception {
        if (cliContext.getSources().size() > 0) {
            throw new Exception("Cannot specify sources when compling transform (found " + cliContext.getSources() + ")");
        }
        if (cliContext.getMap() == null) {
            throw new Exception("Must provide a map when compiling a transform");
        }
        if (cliContext.getOutput() == null) {
            throw new Exception("Must provide an output name when compiling a transform");
        }
        try {
            ContextUtilities cu = new ContextUtilities((IWorkerContext)validator.getContext());
            List structures = cu.allStructures();
            for (StructureDefinition sd : structures) {
                if (sd.hasSnapshot()) continue;
                cu.generateSnapshot(sd);
            }
            validator.setMapLog(cliContext.getMapLog());
            StructureMap map = validator.compile(cliContext.getMap());
            if (map == null) {
                throw new Exception("Unable to locate map " + cliContext.getMap());
            }
            validator.handleOutput((Resource)map, cliContext.getOutput(), validator.getVersion());
            System.out.println(" ...success");
        }
        catch (Exception e) {
            System.out.println(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void transformVersion(CliContext cliContext, ValidationEngine validator) throws Exception {
        if (cliContext.getSources().size() > 1) {
            throw new Exception("Can only have one source when converting versions (found " + cliContext.getSources() + ")");
        }
        if (cliContext.getTargetVer() == null) {
            throw new Exception("Must provide a map when converting versions");
        }
        if (cliContext.getOutput() == null) {
            throw new Exception("Must nominate an output when converting versions");
        }
        try {
            if (cliContext.getMapLog() != null) {
                validator.setMapLog(cliContext.getMapLog());
            }
            byte[] r = validator.transformVersion(cliContext.getSources().get(0), cliContext.getTargetVer(), cliContext.getOutput().endsWith(".json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML, cliContext.getCanDoNative());
            System.out.println(" ...success");
            TextFile.bytesToFile((byte[])r, (String)cliContext.getOutput());
        }
        catch (Exception e) {
            System.out.println(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ValidationEngine initializeValidator(CliContext cliContext, String definitions, TimeTracker tt) throws Exception {
        return this.sessionCache.fetchSessionValidatorEngine(this.initializeValidator(cliContext, definitions, tt, null));
    }

    public String initializeValidator(CliContext cliContext, String definitions, TimeTracker tt, String sessionId) throws Exception {
        tt.milestone();
        if (!this.sessionCache.sessionExists(sessionId)) {
            if (sessionId != null) {
                System.out.println("No such cached session exists for session id " + sessionId + ", re-instantiating validator.");
            }
            this.sessionCache.cleanUp();
            if (cliContext.getSv() == null) {
                String sv = this.determineVersion(cliContext);
                cliContext.setSv(sv);
            }
            String engineDefinitions = definitions != null ? definitions : VersionUtilities.packageForVersion((String)cliContext.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)cliContext.getSv());
            ValidationEngine validationEngine = this.getValidationEngineFromCliContext(cliContext, engineDefinitions, tt);
            sessionId = this.sessionCache.cacheSession(validationEngine);
            System.out.println("Cached new session. Cache size = " + this.sessionCache.getSessionIds().size());
        } else {
            System.out.println("Cached session exists for session id " + sessionId + ", returning stored validator session id. Cache size = " + this.sessionCache.getSessionIds().size());
        }
        return sessionId;
    }

    private ValidationEngine getValidationEngineFromCliContext(CliContext cliContext, String definitions, TimeTracker tt) throws Exception {
        ValidationEngine validationEngine;
        if (cliContext.getBaseEngine() != null && this.hasBaseEngineForKey(cliContext.getBaseEngine())) {
            validationEngine = new ValidationEngine(this.getBaseEngine(cliContext.getBaseEngine()));
        } else {
            if (definitions == null) {
                throw new IllegalArgumentException("Cannot create a validator engine (definitions == null)");
            }
            validationEngine = this.buildValidationEngine(cliContext, definitions, tt);
        }
        return validationEngine;
    }

    protected ValidationEngine.ValidationEngineBuilder getValidationEngineBuilder() {
        return new ValidationEngine.ValidationEngineBuilder();
    }

    @Nonnull
    protected ValidationEngine buildValidationEngine(CliContext cliContext, String definitions, TimeTracker timeTracker) throws IOException, URISyntaxException {
        System.out.print("  Load FHIR v" + cliContext.getSv() + " from " + definitions);
        ValidationEngine validationEngine = this.getValidationEngineBuilder().withTHO(false).withVersion(cliContext.getSv()).withTimeTracker(timeTracker).withUserAgent(Common.getValidatorUserAgent()).fromSource(definitions);
        System.out.println(" - " + validationEngine.getContext().countAllCaches() + " resources (" + timeTracker.milestone() + ")");
        this.loadIgsAndExtensions(validationEngine, cliContext, timeTracker);
        if (validationEngine.getContext().getTxCache() == null) {
            System.out.println("  No Terminology Cache");
        } else {
            System.out.println("  Terminology Cache at " + validationEngine.getContext().getTxCache().getFolder());
        }
        System.out.print("  Get set... ");
        validationEngine.setQuestionnaireMode(cliContext.getQuestionnaireMode());
        validationEngine.setLevel(cliContext.getLevel());
        validationEngine.setDoNative(cliContext.isDoNative());
        validationEngine.setHintAboutNonMustSupport(cliContext.isHintAboutNonMustSupport());
        for (String s : cliContext.getExtensions()) {
            if ("any".equals(s)) {
                validationEngine.setAnyExtensionsAllowed(true);
                continue;
            }
            validationEngine.getExtensionDomains().add(s);
        }
        validationEngine.setLanguage(cliContext.getLang());
        validationEngine.setLocale(cliContext.getLocale());
        validationEngine.setSnomedExtension(cliContext.getSnomedCTCode());
        validationEngine.setAssumeValidRestReferences(cliContext.isAssumeValidRestReferences());
        validationEngine.setShowMessagesFromReferences(cliContext.isShowMessagesFromReferences());
        validationEngine.setDoImplicitFHIRPathStringConversion(cliContext.isDoImplicitFHIRPathStringConversion());
        validationEngine.setHtmlInMarkdownCheck(cliContext.getHtmlInMarkdownCheck());
        validationEngine.setAllowDoubleQuotesInFHIRPath(cliContext.isAllowDoubleQuotesInFHIRPath());
        validationEngine.setNoExtensibleBindingMessages(cliContext.isNoExtensibleBindingMessages());
        validationEngine.setNoUnicodeBiDiControlChars(cliContext.isNoUnicodeBiDiControlChars());
        validationEngine.setNoInvariantChecks(cliContext.isNoInvariants());
        validationEngine.setDisplayWarnings(cliContext.isDisplayWarnings());
        validationEngine.setBestPracticeLevel(cliContext.getBestPracticeLevel());
        validationEngine.setCheckIPSCodes(cliContext.isCheckIPSCodes());
        validationEngine.setWantInvariantInMessage(cliContext.isWantInvariantsInMessages());
        validationEngine.setSecurityChecks(cliContext.isSecurityChecks());
        validationEngine.setCrumbTrails(cliContext.isCrumbTrails());
        validationEngine.setForPublication(cliContext.isForPublication());
        validationEngine.setShowTimes(cliContext.isShowTimes());
        validationEngine.setAllowExampleUrls(cliContext.isAllowExampleUrls());
        if (!cliContext.isDisableDefaultResourceFetcher()) {
            StandAloneValidatorFetcher fetcher = new StandAloneValidatorFetcher(validationEngine.getPcm(), (IWorkerContext)validationEngine.getContext(), validationEngine);
            validationEngine.setFetcher(fetcher);
            validationEngine.getContext().setLocator((IWorkerContextManager.ICanonicalResourceLocator)fetcher);
            validationEngine.setPolicyAdvisor(fetcher);
        }
        validationEngine.getBundleValidationRules().addAll(cliContext.getBundleValidationRules());
        validationEngine.setJurisdiction(CodeSystemUtilities.readCoding((String)cliContext.getJurisdiction()));
        TerminologyCache.setNoCaching((boolean)cliContext.isNoInternalCaching());
        validationEngine.prepare();
        System.out.println(" go (" + timeTracker.milestone() + ")");
        return validationEngine;
    }

    protected void loadIgsAndExtensions(ValidationEngine validationEngine, CliContext cliContext, TimeTracker timeTracker) throws IOException, URISyntaxException {
        FhirPublication ver = FhirPublication.fromCode((String)cliContext.getSv());
        IgLoader igLoader = new IgLoader(validationEngine.getPcm(), validationEngine.getContext(), validationEngine.getVersion(), validationEngine.isDebug());
        igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), "hl7.terminology", false);
        if (!VersionUtilities.isR5Ver((String)validationEngine.getContext().getVersion())) {
            igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), "hl7.fhir.uv.extensions", false);
        }
        System.out.print("  Terminology server " + cliContext.getTxServer());
        String txver = validationEngine.setTerminologyServer(cliContext.getTxServer(), cliContext.getTxLog(), ver, !cliContext.getNoEcosystem());
        System.out.println(" - Version " + txver + " (" + timeTracker.milestone() + ")");
        validationEngine.setDebug(cliContext.isDoDebug());
        validationEngine.getContext().setLogger((ILoggingService)new SystemOutLoggingService(cliContext.isDoDebug()));
        for (String src : cliContext.getIgs()) {
            igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), src, cliContext.isRecursive());
        }
        System.out.println("  Package Summary: " + validationEngine.getContext().loadedPackageSummary());
    }

    public String determineVersion(CliContext cliContext) throws IOException {
        if (cliContext.getMode() != EngineMode.VALIDATION && cliContext.getMode() != EngineMode.INSTALL) {
            return "5.0";
        }
        System.out.println("Scanning for versions (no -version parameter):");
        VersionSourceInformation versions = this.scanForVersions(cliContext);
        for (String s : versions.getReport()) {
            if (s.equals("(nothing found)")) continue;
            System.out.println("  " + s);
        }
        if (versions.isEmpty()) {
            System.out.println("  No Version Info found: Using Default version R5");
            return "5.0.0";
        }
        if (versions.size() == 1) {
            System.out.println("-> use version " + versions.version());
            return versions.version();
        }
        throw new IllegalArgumentException("-> Multiple versions found. Specify a particular version using the -version parameter");
    }

    public void generateSpreadsheet(CliContext cliContext, ValidationEngine validator) throws Exception {
        CanonicalResource cr = validator.loadCanonicalResource(cliContext.getSources().get(0), cliContext.getSv());
        boolean ok = true;
        if (cr instanceof StructureDefinition) {
            new StructureDefinitionSpreadsheetGenerator((IWorkerContext)validator.getContext(), false, false).renderStructureDefinition((StructureDefinition)cr, false).finish((OutputStream)ManagedFileAccess.outStream((String)cliContext.getOutput()));
        } else if (cr instanceof CodeSystem) {
            new CodeSystemSpreadsheetGenerator((IWorkerContext)validator.getContext()).renderCodeSystem((CodeSystem)cr).finish((OutputStream)ManagedFileAccess.outStream((String)cliContext.getOutput()));
        } else if (cr instanceof ValueSet) {
            new ValueSetSpreadsheetGenerator((IWorkerContext)validator.getContext()).renderValueSet((ValueSet)cr).finish((OutputStream)ManagedFileAccess.outStream((String)cliContext.getOutput()));
        } else if (cr instanceof ConceptMap) {
            new ConceptMapSpreadsheetGenerator((IWorkerContext)validator.getContext()).renderConceptMap((ConceptMap)cr).finish((OutputStream)ManagedFileAccess.outStream((String)cliContext.getOutput()));
        } else {
            ok = false;
            System.out.println(" ...Unable to generate spreadsheet for " + cliContext.getSources().get(0) + ": no way to generate a spreadsheet for a " + cr.fhirType());
        }
        if (ok) {
            System.out.println(" ...generated spreadsheet successfully");
        }
    }

    public void transformLang(CliContext cliContext, ValidationEngine validator) throws IOException {
        switch (cliContext.getLangTransform()) {
            case "extract": {
                this.transformLangExtract(cliContext, validator);
                break;
            }
            case "inject": {
                this.transformLangInject(cliContext, validator);
                break;
            }
            default: {
                System.out.println(" ...Unknown lang transform mode " + cliContext.getLangTransform());
            }
        }
    }

    private void transformLangExtract(CliContext cliContext, ValidationEngine validator) throws IOException {
        String dst = cliContext.getOutput();
        Utilities.createDirectory((String)dst);
        PoGetTextProducer po = new PoGetTextProducer(dst, ".", false);
        XLIFFProducer xliff = new XLIFFProducer(dst, ".", false);
        JsonLangFileProducer jl = new JsonLangFileProducer(dst, ".", false);
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        ValidatorUtils.parseSources(cliContext.getSources(), refs, validator.getContext());
        for (ValidatorUtils.SourceFile ref : refs) {
            System.out.println("  Extract Translations from " + ref);
            Content cnt = validator.getIgLoader().loadContent(ref.getRef(), "translate", false, true);
            Element e = Manager.parseSingle((IWorkerContext)validator.getContext(), (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
            LanguageFileProducer.LanguageProducerSession ps = po.startSession(e.fhirType() + "-" + e.getIdBase(), cliContext.getSrcLang());
            LanguageFileProducer.LanguageProducerLanguageSession psl = ps.forLang(cliContext.getTgtLang());
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
            ps = xliff.startSession(e.fhirType() + "-" + e.getIdBase(), cliContext.getSrcLang());
            psl = ps.forLang(cliContext.getTgtLang());
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
            ps = jl.startSession(e.fhirType() + "-" + e.getIdBase(), cliContext.getSrcLang());
            psl = ps.forLang(cliContext.getTgtLang());
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
        }
        System.out.println("Done - produced " + (po.fileCount() + xliff.fileCount()) + " files in " + dst);
    }

    private void transformLangInject(CliContext cliContext, ValidationEngine validator) throws IOException {
        String dst = cliContext.getOutput();
        Utilities.createDirectory((String)dst);
        ArrayList<LanguageFileProducer.TranslationUnit> translations = new ArrayList<LanguageFileProducer.TranslationUnit>();
        for (String input : cliContext.getInputs()) {
            this.loadTranslationSource(translations, input);
        }
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        ValidatorUtils.parseSources(cliContext.getSources(), refs, validator.getContext());
        int t = 0;
        for (ValidatorUtils.SourceFile ref : refs) {
            System.out.println("  Inject Translations into " + ref);
            Content cnt = validator.getIgLoader().loadContent(ref.getRef(), "translate", false, true);
            Element e = Manager.parseSingle((IWorkerContext)validator.getContext(), (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
            t += new LanguageUtils((IWorkerContext)validator.getContext()).importFromTranslations(e, translations);
            Manager.compose((IWorkerContext)validator.getContext(), (Element)e, (OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{dst, ManagedFileAccess.file((String)ref.getRef()).getName()})), (Manager.FhirFormat)cnt.getCntType(), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        }
        System.out.println("Done - imported " + t + " translations into " + refs.size() + " in " + dst);
    }

    private void loadTranslationSource(List<LanguageFileProducer.TranslationUnit> translations, String input) throws IOException {
        File f = ManagedFileAccess.file((String)input);
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File fd : f.listFiles()) {
                    this.loadTranslationSource(translations, fd.getAbsolutePath());
                }
            } else if (f.getName().endsWith(".po")) {
                try {
                    translations.addAll(new PoGetTextProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    System.out.println("Error reading PO File " + f.getAbsolutePath() + ": " + e.getMessage());
                }
            } else if (f.getName().endsWith(".xliff")) {
                try {
                    translations.addAll(new XLIFFProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    System.out.println("Error reading XLIFF File " + f.getAbsolutePath() + ": " + e.getMessage());
                }
            } else {
                try {
                    translations.addAll(new PoGetTextProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    try {
                        translations.addAll(new XLIFFProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                    }
                    catch (Exception e2) {
                        System.out.println("Error reading File " + f.getAbsolutePath() + " as XLIFF: " + e2.getMessage());
                        System.out.println("Error reading File " + f.getAbsolutePath() + " as PO: " + e.getMessage());
                    }
                }
            }
        } else {
            System.out.println("Input not found: " + input);
        }
    }

    public void install(CliContext cliContext, ValidationEngine validator) throws FHIRException, IOException {
        this.cp = 0;
        this.cs = 0;
        System.out.println("Generating Snapshots");
        for (String ig : cliContext.getIgs()) {
            this.processIG(validator, ig);
        }
        System.out.println("Installed/Processed " + this.cp + " packages, generated " + this.cs + " snapshots");
    }

    private void processIG(ValidationEngine validator, String ig) throws FHIRException, IOException {
        validator.loadPackage(ig, null);
        NpmPackage npm = validator.getPcm().loadPackage(ig);
        if (!npm.isCore()) {
            for (String d : npm.dependencies()) {
                this.processIG(validator, d);
            }
            System.out.println("Processing " + ig);
            ++this.cp;
            for (String d : npm.listResources(new String[]{"StructureDefinition"})) {
                String filename = npm.getFilePath(d);
                Resource res = validator.loadResource(TextFile.fileToBytes((String)filename), filename);
                if (!(res instanceof StructureDefinition)) {
                    throw new FHIRException("Require a StructureDefinition for generating a snapshot");
                }
                StructureDefinition sd = (StructureDefinition)res;
                if (sd.hasSnapshot()) continue;
                StructureDefinition base = (StructureDefinition)validator.getContext().fetchResource(StructureDefinition.class, sd.getBaseDefinition());
                ++this.cs;
                new ProfileUtilities((IWorkerContext)validator.getContext(), new ArrayList(), null).setAutoFixSliceNames(true).generateSnapshot(base, sd, sd.getUrl(), null, sd.getName());
                validator.handleOutput((Resource)sd, filename, validator.getVersion());
            }
        }
    }
}

