/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.r5.test.utils.TestingUtilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.special.TxTestSetup;

public class TxTestData {
    private final JsonObject manifest;
    private final JsonObject externals;
    private final List<Object[]> testData;

    private TxTestData(List<Object[]> testData, JsonObject manifest, JsonObject externals) throws IOException {
        this.testData = testData;
        this.manifest = manifest;
        this.externals = externals;
    }

    public static TxTestData loadTestDataFromDefaultClassPath() throws IOException {
        String contents = TestingUtilities.loadTestResource((String[])new String[]{"tx", "test-cases.json"});
        String externalSource = TestingUtilities.loadTestResource((String[])new String[]{"tx", "messages-tx.fhir.org.json"});
        JsonObject externals = JsonParser.parseObject((String)externalSource);
        HashMap<CallSite, TxTestSetup> examples = new HashMap<CallSite, TxTestSetup>();
        JsonObject manifest = JsonParser.parseObject((String)contents);
        for (JsonObject suite : manifest.getJsonObjects("suites")) {
            if ("tx.fhir.org".equals(suite.asString("mode"))) continue;
            String sn = suite.asString("name");
            for (JsonObject test : suite.getJsonObjects("tests")) {
                String tn = test.asString("name");
                examples.put((CallSite)((Object)(sn + "." + tn)), new TxTestSetup(suite, test));
            }
        }
        ArrayList names = new ArrayList(examples.size());
        names.addAll(examples.keySet());
        Collections.sort(names);
        ArrayList<Object[]> testData = new ArrayList<Object[]>(examples.size());
        for (String id : names) {
            testData.add(new Object[]{id, examples.get(id)});
        }
        return new TxTestData(testData, manifest, externals);
    }

    public JsonObject getManifest() {
        return this.manifest;
    }

    public JsonObject getExternals() {
        return this.externals;
    }

    public List<Object[]> getTestData() {
        return this.testData;
    }
}

