/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ImplementationGuideValidator
extends BaseValidator {
    public ImplementationGuideValidator(IWorkerContext context, XVerExtensionManager xverManager, boolean debug) {
        super(context, xverManager, debug);
    }

    public boolean validateImplementationGuide(ValidationContext valContext, List<ValidationMessage> errors, Element ig, NodeStack stack) {
        boolean ok = true;
        String fver = ig.getNamedChildValue("fhirVersion");
        List dependencies = ig.getChildrenByName("dependsOn");
        int i = 0;
        for (Element dependency : dependencies) {
            ok = this.checkDependency(errors, ig, stack.push(dependency, i, null, null), dependency, fver) && ok;
            ++i;
        }
        return ok;
    }

    private boolean checkDependency(List<ValidationMessage> errors, Element ig, NodeStack stack, Element dependency, String fver) {
        boolean ok = true;
        String url = dependency.getNamedChildValue("url");
        String packageId = dependency.getNamedChildValue("packageId");
        String version = dependency.getNamedChildValue("version");
        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), url == null || url.contains("/ImplementationGuide/"), "IG_DEPENDENCY_DIRECT", url) && ok;
        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId == null || packageId.matches("^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$"), "IG_DEPENDENCY_INVALID_PACKAGEID", packageId) && ok;
        try {
            FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
            if (url != null && packageId != null) {
                String pid = pcm.getPackageId(url);
                String canonical = pcm.getPackageUrl(packageId);
                ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), pid == null || pid.equals(packageId), "IG_DEPENDENCY_CLASH_PACKAGEID", url, pid, packageId) && ok;
                boolean bl = ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), canonical == null || canonical.equals(url), "IG_DEPENDENCY_CLASH_CANONICAL", packageId, canonical, url) && ok;
            }
            if (packageId == null && ok) {
                packageId = pcm.getPackageId(url);
            }
            if (ok && this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), packageId != null, "IG_DEPENDENCY_NO_PACKAGE", new Object[0]) && this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_NO_VERSION", new Object[0])) {
                String pver;
                ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), (packageId + "#" + version).matches("^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$"), "IG_DEPENDENCY_INVALID_PACKAGE_VERSION", version) && ok;
                NpmPackage npm = pcm.loadPackage(packageId, version);
                if (this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), npm != null, "IG_DEPENDENCY_PACKAGE_UNKNOWN", packageId + "#" + version) && !VersionUtilities.versionsMatch((String)(pver = npm.fhirVersion()), (String)fver)) {
                    if ("hl7.fhir.uv.extensions".equals(packageId)) {
                        ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_ERROR", fver, packageId + "#" + version, pver, "hl7.fhir.uv.extensions." + VersionUtilities.getNameForVersion((String)fver).toLowerCase()) && ok;
                    } else {
                        this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), false, "IG_DEPENDENCY_VERSION_WARNING", fver, packageId + "#" + version, pver);
                    }
                }
            }
        }
        catch (Exception e) {
            this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, dependency.line(), dependency.col(), stack.getLiteralPath(), version != null, "IG_DEPENDENCY_EXCEPTION", e.getMessage());
        }
        return ok;
    }
}

