/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.codesystem.GeneralCodeSystemChecker;
import org.hl7.fhir.validation.codesystem.SnomedCTChecker;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ValueSetValidator
extends BaseValidator {
    private static final int TOO_MANY_CODES_TO_VALIDATE = 1000;

    private CodeSystemChecker getSystemValidator(String system, List<ValidationMessage> errors) {
        if (system == null) {
            return new GeneralCodeSystemChecker(this.context, this.xverManager, this.debug, errors);
        }
        switch (system) {
            case "http://snomed.info/sct": {
                return new SnomedCTChecker(this.context, this.xverManager, this.debug, errors);
            }
        }
        return new GeneralCodeSystemChecker(this.context, this.xverManager, this.debug, errors);
    }

    public ValueSetValidator(InstanceValidator parent) {
        super(parent);
    }

    public boolean validateValueSet(ValidationContext valContext, List<ValidationMessage> errors, Element vs, NodeStack stack) {
        boolean ok = true;
        if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            List composes = vs.getChildrenByName("compose");
            int cc = 0;
            for (Element compose : composes) {
                ok = this.validateValueSetCompose(valContext, errors, compose, stack.push(compose, composes.size() > 1 ? cc : -1, null, null), vs.getNamedChildValue("url", false), "retired".equals(vs.getNamedChildValue("url", false)), vs) & ok;
                ++cc;
            }
        }
        if (!stack.isContained()) {
            ok = this.checkShareableValueSet(errors, vs, stack) && ok;
        }
        return ok;
    }

    private boolean checkShareableValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(vs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("url", false), "VALUESET_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("version", false), "VALUESET_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("title", false), "VALUESET_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("name", false), "VALUESET_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("status", false), "VALUESET_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("experimental", false), "VALUESET_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("description", false), "VALUESET_SHAREABLE_MISSING_HL7", "description") && ok;
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("url", false), "VALUESET_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("version", false), "VALUESET_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("title", false), "VALUESET_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("name", false), "VALUESET_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("status", false), "VALUESET_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("experimental", false), "VALUESET_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("description", false), "VALUESET_SHAREABLE_MISSING", "description");
        }
        return true;
    }

    private boolean validateValueSetCompose(ValidationContext valContext, List<ValidationMessage> errors, Element compose, NodeStack stack, String vsid, boolean retired, Element vsSrc) {
        boolean ok = true;
        List includes = compose.getChildrenByName("include");
        int ci = 0;
        for (Element include : includes) {
            ok = this.validateValueSetInclude(valContext, errors, include, stack.push(include, ci, null, null), vsid, retired, vsSrc) && ok;
            ++ci;
        }
        List excludes = compose.getChildrenByName("exclude");
        int ce = 0;
        for (Element exclude : excludes) {
            ok = this.validateValueSetInclude(valContext, errors, exclude, stack.push(exclude, ce, null, null), vsid, retired, vsSrc) && ok;
            ++ce;
        }
        return ok;
    }

    private boolean validateValueSetInclude(ValidationContext valContext, List<ValidationMessage> errors, Element include, NodeStack stack, String vsid, boolean retired, Element vsSrc) {
        boolean ok = true;
        String system = include.getChildValue("system");
        String version = include.getChildValue("version");
        List valuesets = include.getChildrenByName("valueSet");
        int i = 0;
        for (Object ve : valuesets) {
            String v = ve.getValue();
            ValueSet vs = (ValueSet)this.context.findTxResource(ValueSet.class, v);
            if (vs == null) {
                NodeStack ns = stack.push((Element)ve, i, ve.getProperty().getDefinition(), ve.getProperty().getDefinition());
                Resource rs = this.context.fetchResource(Resource.class, v);
                if (rs != null) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_INVALID_TYPE", v, rs.fhirType());
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_UNKNOWN", v);
                }
            }
            ++i;
        }
        if (valuesets.size() > 1) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, stack, false, "VALUESET_IMPORT_UNION_INTERSECTION", new Object[0]);
        }
        if (system != null) {
            CodeSystem cs;
            this.rule(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, Utilities.isAbsoluteUrl((String)system), system.startsWith("#") ? "VALUESET_INCLUDE_SYSTEM_ABSOLUTE_FRAG" : "VALUESET_INCLUDE_SYSTEM_ABSOLUTE", system);
            if (system.startsWith("#")) {
                cs = new ArrayList();
                for (Element contained : vsSrc.getChildrenByName("contained")) {
                    if (!("#" + contained.getIdBase()).equals(system)) continue;
                    ok = false;
                    if (!this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, "CodeSystem".equals(contained.fhirType()), "VALUESET_INCLUDE_CS_NOT_CS", system, contained.fhirType()) || version != null && !version.equals(contained.getChildValue("version"))) continue;
                    cs.add(contained);
                }
                if (cs.isEmpty()) {
                    ok = this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_NOT_FOUND" : "VALUESET_INCLUDE_CSVER_NOT_FOUND", system, version) && ok;
                } else {
                    boolean bl = ok = this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, cs.size() == 1, version == null ? "VALUESET_INCLUDE_CS_MULTI_FOUND" : "VALUESET_INCLUDE_CSVER_MULTI_FOUND", system, version) && ok;
                }
            }
            if (version == null && (cs = this.context.fetchCodeSystem(system)) != null && !CodeSystemUtilities.isExemptFromMultipleVersionChecking((String)system)) {
                Set possibleVersions = this.fetcher.fetchCanonicalResourceVersions(null, valContext.getAppContext(), system);
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, stack, possibleVersions.size() <= 1, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_MULTIPLE_POSSIBLE_VERSIONS", system, cs.getVersion(), CommaSeparatedStringBuilder.join((String)", ", (Collection)Utilities.sorted((Collection)possibleVersions)));
            }
        }
        List concepts = include.getChildrenByName("concept");
        List filters = include.getChildrenByName("filter");
        CodeSystemChecker slv = this.getSystemValidator(system, errors);
        CodeSystem cs = null;
        if (!Utilities.noString((String)system)) {
            cs = this.context.fetchCodeSystem(system, version);
            if (cs != null) {
                switch (cs.getContent()) {
                    case EXAMPLE: {
                        this.warning(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, cs.getContent().toCode(), version);
                        break;
                    }
                    case FRAGMENT: {
                        this.hint(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, cs.getContent().toCode(), version);
                        break;
                    }
                    case SUPPLEMENT: {
                        ok = this.rule(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_SUPPLEMENT" : "VALUESET_INCLUDE_CSVER_SUPPLEMENT", system, cs.getSupplements(), version) && ok;
                        break;
                    }
                }
            }
            boolean systemOk = true;
            int cc = 0;
            ArrayList<VSCodingValidationRequest> batch = new ArrayList<VSCodingValidationRequest>();
            boolean first = true;
            for (Element concept : concepts) {
                if (first) {
                    systemOk = this.validateValueSetIncludeConcept(errors, concept, stack, stack.push(concept, cc, null, null), system, version, slv);
                    first = false;
                } else if (systemOk) {
                    batch.add(this.prepareValidateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version, slv));
                }
                ++cc;
            }
            if (((InstanceValidator)this.parent).isValidateValueSetCodesOnTxServer() && batch.size() > 0 & !this.context.isNoTerminologyServer()) {
                if (batch.size() > 1000) {
                    ok = this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_TOO_MANY_CODES", batch.size()) && ok;
                } else {
                    long t = System.currentTimeMillis();
                    if (this.parent.isDebug()) {
                        System.out.println("  : Validate " + batch.size() + " codes from " + system + " for " + vsid);
                    }
                    try {
                        this.context.validateCodeBatch(ValidationOptions.defaults(), batch, null);
                        if (this.parent.isDebug()) {
                            System.out.println("  :   .. " + (System.currentTimeMillis() - t) + "ms");
                        }
                        for (VSCodingValidationRequest cv : batch) {
                            if (version == null) {
                                this.warningOrHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, cv.getCoding().getCode());
                                continue;
                            }
                            this.warningOrHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, cv.getCoding().getCode());
                        }
                    }
                    catch (Exception e) {
                        VSCodingValidationRequest cv;
                        ok = false;
                        cv = (VSCodingValidationRequest)((Object)batch.get(0));
                        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, cv.getStack().getLiteralPath(), false, e.getMessage(), new Object[0]);
                    }
                }
            }
            int cf = 0;
            for (Element filter : filters) {
                ok = this.validateValueSetIncludeFilter(errors, filter, stack.push(filter, cf, null, null), system, version, cs, slv) & ok;
                ++cf;
            }
            slv.finish(include, stack);
        } else {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, filters.size() == 0 && concepts.size() == 0, "VALUESET_NO_SYSTEM_WARNING", new Object[0]);
        }
        return ok;
    }

    private boolean validateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stackInc, NodeStack stack, String system, String version, CodeSystemChecker slv) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        if (version == null) {
            ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null), null);
            if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                if (this.isExampleUrl(system)) {
                    if (this.isAllowExamples()) {
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_HINT", system);
                    } else {
                        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_ERROR", system);
                    }
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING", system, vv.getMessage());
                }
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, code);
            if (vv.getMessage() != null) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, false, vv.getMessage(), new Object[0]);
            }
        } else {
            ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null).setVersion(version), null);
            if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING_VER", system + "#" + version, vv.getMessage());
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, code);
            if (vv.getMessage() != null) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, false, vv.getMessage(), new Object[0]);
            }
        }
        return true;
    }

    private VSCodingValidationRequest prepareValidateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version, CodeSystemChecker slv) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        Coding c = new Coding(system, code, null);
        if (version != null) {
            c.setVersion(version);
        }
        return new VSCodingValidationRequest(stack, c);
    }

    private boolean validateValueSetIncludeFilter(List<ValidationMessage> errors, Element filter, NodeStack stack, String system, String version, CodeSystem cs, CodeSystemChecker slv) {
        boolean ok = true;
        String property = filter.getChildValue("property");
        String op = filter.getChildValue("op");
        String value = filter.getChildValue("value");
        if (property != null) {
            PropertyValidationRules rules;
            ArrayList<String> knownNames = new ArrayList<String>();
            knownNames.add("concept");
            knownNames.add("code");
            knownNames.add("status");
            knownNames.add("inactive");
            knownNames.add("effectiveDate");
            knownNames.add("deprecationDate");
            knownNames.add("retirementDate");
            knownNames.add("notSelectable");
            if (cs == null || cs.hasHierarchyMeaning()) {
                knownNames.add("parent");
                knownNames.add("child");
                knownNames.add("partOf");
            }
            knownNames.add("synonym");
            knownNames.add("comment");
            knownNames.add("itemWeight");
            if (cs != null) {
                for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                    this.addName(knownNames, f.getCode());
                }
                for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                    this.addName(knownNames, p.getCode());
                }
            }
            for (String s : this.getSystemKnownNames(system)) {
                this.addName(knownNames, s);
            }
            boolean pok = false;
            pok = cs == null ? this.hint(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, knownNames.contains(property), "VALUESET_UNKNOWN_FILTER_PROPERTY_NO_CS", property, system, CommaSeparatedStringBuilder.join((String)",", knownNames)) : this.warning(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, knownNames.contains(property), "VALUESET_UNKNOWN_FILTER_PROPERTY", property, system, CommaSeparatedStringBuilder.join((String)",", knownNames));
            if (pok && (rules = this.rulesForFilter(system, cs, property)) != null) {
                if (!rules.getOps().isEmpty()) {
                    boolean bl = ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, this.opInSet(op, rules.getOps()), "VALUESET_BAD_FILTER_OP", op, property, CommaSeparatedStringBuilder.join((String)",", rules.getOps())) && ok;
                }
                if ("exists".equals(op)) {
                    ok = this.checkFilterValue(errors, stack, system, version, ok, property, value, PropertyFilterType.Boolean) && ok;
                } else if (rules.isRepeating()) {
                    for (String v : value.split("\\,")) {
                        ok = this.checkFilterValue(errors, stack, system, version, ok, property, v, rules.getType()) && ok;
                    }
                } else {
                    ok = this.checkFilterValue(errors, stack, system, version, ok, property, value, rules.getType()) && ok;
                }
            }
        }
        return ok;
    }

    private boolean opInSet(String op, EnumSet<PropertyOperation> ops) {
        switch (op) {
            case "=": {
                return ops.contains((Object)PropertyOperation.Equals);
            }
            case "is-a": {
                return ops.contains((Object)PropertyOperation.IsA);
            }
            case "descendent-of": {
                return ops.contains((Object)PropertyOperation.DescendentOf);
            }
            case "is-not-a": {
                return ops.contains((Object)PropertyOperation.IsNotA);
            }
            case "regex": {
                return ops.contains((Object)PropertyOperation.RegEx);
            }
            case "in": {
                return ops.contains((Object)PropertyOperation.In);
            }
            case "not-in": {
                return ops.contains((Object)PropertyOperation.NotIn);
            }
            case "generalizes": {
                return ops.contains((Object)PropertyOperation.Generalizes);
            }
            case "child-of": {
                return ops.contains((Object)PropertyOperation.ChildOf);
            }
            case "descendent-leaf": {
                return ops.contains((Object)PropertyOperation.DescendentLeaf);
            }
            case "exists": {
                return ops.contains((Object)PropertyOperation.Exists);
            }
        }
        return false;
    }

    private boolean checkFilterValue(List<ValidationMessage> errors, NodeStack stack, String system, String version, boolean ok, String property, String value, PropertyFilterType type) {
        if (type != null) {
            switch (type) {
                case Boolean: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, Utilities.existsInList((String)value, (String[])new String[]{"true", "false"}), "VALUESET_BAD_FILTER_VALUE_BOOLEAN", property, value) && ok;
                    break;
                }
                case Code: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, value.trim().equals(value), "VALUESET_BAD_FILTER_VALUE_CODE", property, value) && ok;
                    break;
                }
                case DateTime: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), value.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "VALUESET_BAD_FILTER_VALUE_DATETIME", property, value) && ok;
                    break;
                }
                case Decimal: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), Utilities.isDecimal((String)value, (boolean)true), "VALUESET_BAD_FILTER_VALUE_DECIMAL", property, value) && ok;
                    break;
                }
                case Integer: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), Utilities.isInteger((String)value), "VALUESET_BAD_FILTER_VALUE_INTEGER", property, value) && ok;
                    break;
                }
                case ValidCode: {
                    ValidationResult vr = this.context.validateCode(this.baseOptions, system, version, value, null);
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), vr.isOk(), "VALUESET_BAD_FILTER_VALUE_VALID_CODE", property, value, system, vr.getMessage()) && ok;
                    break;
                }
                case Coding: {
                    Coding code = Coding.fromLiteral((String)value);
                    if (code == null) {
                        ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_BAD_FILTER_VALUE_CODED", property, value) && ok;
                        break;
                    }
                    ValidationResult vr = this.context.validateCode(this.baseOptions, code, null);
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, vr.isOk(), "VALUESET_BAD_FILTER_VALUE_CODED_INVALID", property, value, vr.getMessage()) && ok;
                    break;
                }
            }
        }
        return ok;
    }

    private PropertyValidationRules rulesForFilter(String system, CodeSystem cs, String property) {
        EnumSet<PropertyOperation> ops = EnumSet.noneOf(PropertyOperation.class);
        if (cs != null) {
            for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                if (!property.equals(f.getCode())) continue;
                for (Enumeration op : f.getOperator()) {
                    ops.add(this.toOp((Enumeration<Enumerations.FilterOperator>)op));
                }
            }
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                if (!property.equals(p.getCode()) || p.getType() == null) continue;
                switch (p.getType()) {
                    case BOOLEAN: {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
                    }
                    case CODE: {
                        return new PropertyValidationRules(false, PropertyFilterType.ValidCode, ops);
                    }
                    case CODING: {
                        return new PropertyValidationRules(false, PropertyFilterType.Coding, ops);
                    }
                    case DATETIME: {
                        return new PropertyValidationRules(false, PropertyFilterType.DateTime, ops);
                    }
                    case DECIMAL: {
                        return new PropertyValidationRules(false, PropertyFilterType.Decimal, ops);
                    }
                    case INTEGER: {
                        return new PropertyValidationRules(false, PropertyFilterType.Integer, ops);
                    }
                    case STRING: {
                        return null;
                    }
                }
            }
        }
        switch (property) {
            case "concept": {
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.In, PropertyOperation.IsA, PropertyOperation.DescendentOf, PropertyOperation.DescendentLeaf, PropertyOperation.IsNotA, PropertyOperation.NotIn));
            }
            case "code": {
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.RegEx));
            }
            case "status": {
                return new PropertyValidationRules(false, PropertyFilterType.Code, ops);
            }
            case "inactive": {
                return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
            }
            case "effectiveDate": {
                return new PropertyValidationRules(false, PropertyFilterType.DateTime, ops);
            }
            case "deprecationDate": {
                return new PropertyValidationRules(false, PropertyFilterType.DateTime, ops);
            }
            case "retirementDate": {
                return new PropertyValidationRules(false, PropertyFilterType.DateTime, ops);
            }
            case "notSelectable": {
                return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
            }
            case "parent": {
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, ops);
            }
            case "child": {
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, ops);
            }
            case "partOf": {
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, ops);
            }
            case "synonym": {
                return new PropertyValidationRules(false, PropertyFilterType.Code, ops);
            }
            case "comment": {
                return null;
            }
            case "itemWeight": {
                return new PropertyValidationRules(false, PropertyFilterType.Decimal, ops);
            }
        }
        switch (system) {
            case "http://loinc.org": {
                if (Utilities.existsInList((String)property, (String[])new String[]{"copyright", "STATUS", "CLASS", "CONSUMER_NAME", "ORDER_OBS", "DOCUMENT_SECTION"})) {
                    return new PropertyValidationRules(false, PropertyFilterType.Code, new PropertyOperation[0]);
                }
                if ("CLASSTYPE".equals(property)) {
                    return new PropertyValidationRules(false, PropertyFilterType.Integer, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.In));
                }
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.In));
            }
            case "http://snomed.info/sct": {
                switch (property) {
                    case "constraint": {
                        return null;
                    }
                    case "expressions": {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.In));
                    }
                }
                return new PropertyValidationRules(false, PropertyFilterType.ValidCode, this.addToOps(ops, PropertyOperation.Equals, PropertyOperation.In));
            }
            case "http://www.nlm.nih.gov/research/umls/rxnorm": {
                return new PropertyValidationRules(false, PropertyFilterType.Code, ops);
            }
            case "http://unitsofmeasure.org": {
                return new PropertyValidationRules(false, PropertyFilterType.Code, ops);
            }
            case "http://www.ama-assn.org/go/cpt": {
                switch (property) {
                    case "modifier": {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
                    }
                    case "kind": {
                        return new PropertyValidationRules(true, PropertyFilterType.Code, ops);
                    }
                    case "modified": {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
                    }
                    case "code": {
                        return null;
                    }
                    case "telemedicine": {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
                    }
                    case "orthopox": {
                        return new PropertyValidationRules(false, PropertyFilterType.Boolean, ops);
                    }
                }
            }
        }
        if (ops != null) {
            return new PropertyValidationRules(false, null, ops);
        }
        return null;
    }

    private EnumSet<PropertyOperation> addToOps(EnumSet<PropertyOperation> set, PropertyOperation ... ops) {
        for (PropertyOperation op : ops) {
            set.add(op);
        }
        return set;
    }

    private PropertyOperation toOp(Enumeration<Enumerations.FilterOperator> op) {
        switch ((Enumerations.FilterOperator)op.getValue()) {
            case CHILDOF: {
                return PropertyOperation.ChildOf;
            }
            case DESCENDENTLEAF: {
                return PropertyOperation.DescendentLeaf;
            }
            case DESCENDENTOF: {
                return PropertyOperation.DescendentOf;
            }
            case EQUAL: {
                return PropertyOperation.Equals;
            }
            case EXISTS: {
                return PropertyOperation.Exists;
            }
            case GENERALIZES: {
                return PropertyOperation.Generalizes;
            }
            case IN: {
                return PropertyOperation.In;
            }
            case ISA: {
                return PropertyOperation.IsA;
            }
            case ISNOTA: {
                return PropertyOperation.IsNotA;
            }
            case NOTIN: {
                return PropertyOperation.NotIn;
            }
            case REGEX: {
                return PropertyOperation.RegEx;
            }
        }
        return null;
    }

    private void addName(List<String> knownNames, String code) {
        if (code != null && !knownNames.contains(code)) {
            knownNames.add(code);
        }
    }

    private String[] getSystemKnownNames(String system) {
        switch (system) {
            case "http://loinc.org": {
                return new String[]{"parent", "ancestor", "copyright", "STATUS", "COMPONENT", "PROPERTY", "TIME_ASPCT", "SYSTEM", "SCALE_TYP", "METHOD_TYP", "CLASS", "CONSUMER_NAME", "CLASSTYPE", "ORDER_OBS", "DOCUMENT_SECTION"};
            }
            case "http://snomed.info/sct": {
                return new String[]{"constraint", "expressions", "410662002", "42752001", "47429007", "116676008", "116686009", "118168003", "118169006", "118170007", "118171006", "127489000", "131195008", "246075003", "246090004", "246093002", "246112005", "246454002", "246456000", "246501002", "246513007", "246514001", "255234002", "260507000", "260686004", "260870009", "263502005", "272741003", "288556008", "363589002", "363698007", "363699004", "363700003", "363701004", "363702006", "363703001", "363704007", "363705008", "363709002", "363710007", "363713009", "363714003", "370129005", "370130000", "370131001", "370132008", "370133003", "370134009", "370135005", "371881003", "405813007", "405814001", "405815000", "405816004", "408729009", "408730004", "408731000", "408732007", "410675002", "411116001", "418775008", "419066007", "424226004", "424244007", "424361007", "424876005", "425391005", "609096000", "704319004", "704320005", "704321009", "704322002", "704323007", "704324001", "704325000", "704326004", "704327008", "704346009", "704347000", "704647008", "718497002", "719715003", "719722006", "726542003", "726633004", "732943007", "732945000", "732947008", "733722007", "733725009", "733928003", "733930001", "733931002", "733932009", "733933004", "734136001", "734137005", "736472000", "736473005", "736474004", "736475003", "736476002", "736518005", "738774007", "762705008", "762706009", "762949000", "762951001", "763032000", "766939001", "774081006", "774158006", "774159003", "774160008", "774163005", "827081001", "836358009", "840560000", "860779006", "860781008", "1003703000", "1003735000", "1142135004", "1142136003", "1142137007", "1142138002", "1142139005", "1142140007", "1142141006", "1142142004", "1142143009", "1148793005", "1148965004", "1148967007", "1148968002", "1148969005", "1149366004", "1149367008", "1230370004", "320091000221107"};
            }
            case "http://www.nlm.nih.gov/research/umls/rxnorm": {
                return new String[]{"STY", "SAB", "TTY", "SY", "SIB", "RN", "PAR", "CHD", "RB", "RO", "IN", "PIN", "MIN", "BN", "SCD", "SBD", "GPCK", "BPCK", "SCDC", "SCDF", "SCDFP", "SCDG", "SCDGP", "SBDC", "SBDF", "SBDFP", "SBDG", "DF", "DFG"};
            }
            case "http://unitsofmeasure.org": {
                return new String[]{"property", "canonical"};
            }
            case "http://www.ama-assn.org/go/cpt": {
                return new String[]{"modifier", "kind", "modified", "code", "telemedicine", "orthopox"};
            }
            case "urn:ietf:bcp:47": {
                return new String[]{"language", "region", "script", "variant", "extension", "ext-lang", "private-use"};
            }
        }
        return new String[0];
    }

    public class VSCodingValidationRequest
    extends CodingValidationRequest {
        private NodeStack stack;

        public VSCodingValidationRequest(NodeStack stack, Coding code) {
            super(code);
            this.stack = stack;
        }

        public NodeStack getStack() {
            return this.stack;
        }
    }

    public static enum PropertyFilterType {
        Boolean,
        Integer,
        Decimal,
        Code,
        DateTime,
        ValidCode,
        Coding;

    }

    public class PropertyValidationRules {
        boolean repeating;
        PropertyFilterType type;
        EnumSet<PropertyOperation> ops;

        protected PropertyValidationRules(boolean repeating, PropertyFilterType type, PropertyOperation ... ops) {
            this.repeating = repeating;
            this.type = type;
            this.ops = EnumSet.noneOf(PropertyOperation.class);
            for (PropertyOperation op : ops) {
                this.ops.add(op);
            }
        }

        public PropertyValidationRules(boolean repeating, PropertyFilterType type, EnumSet<PropertyOperation> ops) {
            this.repeating = repeating;
            this.type = type;
            this.ops = ops;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public PropertyFilterType getType() {
            return this.type;
        }

        public EnumSet<PropertyOperation> getOps() {
            return this.ops;
        }
    }

    public static enum PropertyOperation {
        Equals,
        IsA,
        DescendentOf,
        IsNotA,
        RegEx,
        In,
        NotIn,
        Generalizes,
        ChildOf,
        DescendentLeaf,
        Exists;


        public String toString() {
            switch (this) {
                case ChildOf: {
                    return "child-of";
                }
                case DescendentLeaf: {
                    return "descendent-leaf";
                }
                case DescendentOf: {
                    return "descendent-of";
                }
                case Equals: {
                    return "=";
                }
                case Exists: {
                    return "exists";
                }
                case Generalizes: {
                    return "generalizes";
                }
                case In: {
                    return "in";
                }
                case IsA: {
                    return "is-a";
                }
                case IsNotA: {
                    return "is-not-a";
                }
                case NotIn: {
                    return "not-in";
                }
                case RegEx: {
                    return "regex";
                }
            }
            return "?";
        }
    }
}

