/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ipa;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.instance.InstanceValidator;

public class IPAValidator {
    private String address;
    private String token;
    private String urn;
    private InstanceValidator validator;

    public IPAValidator(String address, String token, String urn, InstanceValidator validator) {
        this.address = address;
        this.token = token;
        this.urn = urn;
        this.validator = validator;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public InstanceValidator getValidator() {
        return this.validator;
    }

    public void setValidator(InstanceValidator validator) {
        this.validator = validator;
    }

    public void validate() {
        List<Element> patients = this.searchPatients();
        if (patients.size() > 0) {
            // empty if block
        }
    }

    private List<Element> searchPatients() {
        ValidationNode vn = new ValidationNode("Patient Search");
        this.log("Searching Patients");
        Element bundle = this.makeRequest(vn, "/Patient");
        ArrayList<Element> list = new ArrayList<Element>();
        if (bundle != null) {
            this.checkSelfLink(vn, bundle, null);
            List entries = bundle.getChildren("entry");
            int i = 0;
            for (Element entry : entries) {
                Element resource = entry.getNamedChild("resource", false);
                if (resource == null || !resource.fhirType().equals("Patient")) continue;
                this.validator.validate((Object)this, vn.getIssues(), "Bundle.entry[" + i + "].resource", resource, "http://hl7.org/fhir/uv/ipa/StructureDefinition/ipa-patient");
                list.add(resource);
            }
        }
        if (list.size() > 1) {
            vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, "patient.search", "Multiple Patients found; check that this is an expected outcome", ValidationMessage.IssueSeverity.WARNING));
        } else if (list.size() == 0) {
            vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, "patient.search", "No Patients found, unable to continue", ValidationMessage.IssueSeverity.ERROR));
        }
        return list;
    }

    private void checkSelfLink(ValidationNode vn, Element bundle, Map<String, String> params) {
        Element sl = null;
        for (Element e : bundle.getChildren("link")) {
            if (!"self".equals(e.getNamedChildValue("relation", false))) continue;
            sl = e.getNamedChild("url", false);
        }
        if (sl == null) {
            vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, vn.getName(), "Self link not found in search result", ValidationMessage.IssueSeverity.ERROR));
        } else if (params != null) {
            // empty if block
        }
    }

    private Element makeRequest(ValidationNode vn, String url) {
        try {
            SimpleHTTPClient http = new SimpleHTTPClient();
            SimpleHTTPClient.HTTPResult result = http.get(url, "application/fhir+json");
            if (result.getCode() >= 300) {
                vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, "http.request", "HTTP Return code is " + result.getCode() + " " + result.getMessage(), ValidationMessage.IssueSeverity.FATAL));
                return null;
            }
            if (result.getContent() == null || result.getContent().length == 0) {
                vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, "http.request", "No Content Returned", ValidationMessage.IssueSeverity.FATAL));
                return null;
            }
            return ((ValidatedFragment)new JsonParser(this.validator.getContext()).parse((InputStream)new ByteArrayInputStream(result.getContent())).get(0)).getElement();
        }
        catch (Exception e) {
            vn.getIssues().add(new ValidationMessage(ValidationMessage.Source.IPAValidator, ValidationMessage.IssueType.EXCEPTION, "http.request", e.getMessage(), ValidationMessage.IssueSeverity.FATAL));
            return null;
        }
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public class ValidationNode {
        public ValidationNode(String string) {
        }

        public List<ValidationMessage> getIssues() {
            return null;
        }

        public String getName() {
            return null;
        }
    }
}

