/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor5;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.context.SystemOutLoggingService;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.CheckDisplayOption;
import org.hl7.fhir.r5.utils.validation.constants.CodedContentValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.SIDUtilities;
import org.hl7.fhir.utilities.SimpleHTTPClient;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.IgLoader;
import org.hl7.fhir.validation.TransformSupportServices;
import org.hl7.fhir.validation.ValidationRecord;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.VersionConvertor;
import org.hl7.fhir.validation.cli.model.HtmlInMarkdownCheck;
import org.hl7.fhir.validation.cli.model.ValidatedFragments;
import org.hl7.fhir.validation.cli.model.ValidationTime;
import org.hl7.fhir.validation.cli.services.IPackageInstaller;
import org.hl7.fhir.validation.cli.utils.ProfileLoader;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.cli.utils.SchemaValidator;
import org.hl7.fhir.validation.cli.utils.ValidationLevel;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.ValidationContext;
import org.xml.sax.SAXException;

public class ValidationEngine
implements IValidatorResourceFetcher,
IValidationPolicyAdvisor,
IPackageInstaller,
IWorkerContextManager.IPackageLoadingTracker {
    private SimpleWorkerContext context;
    private Map<String, ByteProvider> binaries = new HashMap<String, ByteProvider>();
    private boolean doNative;
    private boolean noInvariantChecks;
    private boolean displayWarnings;
    private boolean wantInvariantInMessage;
    private boolean hintAboutNonMustSupport;
    private boolean anyExtensionsAllowed = false;
    private String version;
    private String language;
    private FilesystemPackageCacheManager pcm;
    private PrintWriter mapLog;
    private boolean debug = false;
    private IValidatorResourceFetcher fetcher;
    private IValidationPolicyAdvisor policyAdvisor;
    private IWorkerContextManager.ICanonicalResourceLocator locator;
    private boolean assumeValidRestReferences;
    private boolean noExtensibleBindingMessages;
    private boolean noUnicodeBiDiControlChars;
    private boolean securityChecks;
    private boolean crumbTrails;
    private boolean forPublication;
    private boolean allowExampleUrls;
    private boolean showMessagesFromReferences;
    private boolean doImplicitFHIRPathStringConversion;
    private HtmlInMarkdownCheck htmlInMarkdownCheck;
    private boolean allowDoubleQuotesInFHIRPath;
    private boolean checkIPSCodes;
    private BestPracticeWarningLevel bestPracticeLevel;
    private Locale locale;
    private List<ImplementationGuide> igs = new ArrayList<ImplementationGuide>();
    private List<String> extensionDomains = new ArrayList<String>();
    private boolean showTimes;
    private List<BundleValidationRule> bundleValidationRules = new ArrayList<BundleValidationRule>();
    private QuestionnaireMode questionnaireMode;
    private ValidationLevel level = ValidationLevel.HINTS;
    private FHIRPathEngine fhirPathEngine;
    private IgLoader igLoader;
    private Coding jurisdiction;
    private ContextUtilities cu = null;
    private Map<String, BaseValidator.ValidationControl> validationControl = new HashMap<String, BaseValidator.ValidationControl>();
    private Map<String, Boolean> resolvedUrls = new HashMap<String, Boolean>();

    public ValidationEngine(ValidationEngine other) throws FHIRException, IOException {
        this.context = new SimpleWorkerContext(other.context);
        this.binaries.putAll(other.binaries);
        this.doNative = other.doNative;
        this.noInvariantChecks = other.noInvariantChecks;
        this.wantInvariantInMessage = other.wantInvariantInMessage;
        this.hintAboutNonMustSupport = other.hintAboutNonMustSupport;
        this.anyExtensionsAllowed = other.anyExtensionsAllowed;
        this.version = other.version;
        this.language = other.language;
        this.pcm = other.pcm;
        this.mapLog = other.mapLog;
        this.debug = other.debug;
        this.fetcher = other.fetcher;
        this.policyAdvisor = other.policyAdvisor;
        this.locator = other.locator;
        this.assumeValidRestReferences = other.assumeValidRestReferences;
        this.noExtensibleBindingMessages = other.noExtensibleBindingMessages;
        this.noUnicodeBiDiControlChars = other.noUnicodeBiDiControlChars;
        this.securityChecks = other.securityChecks;
        this.crumbTrails = other.crumbTrails;
        this.forPublication = other.forPublication;
        this.allowExampleUrls = other.allowExampleUrls;
        this.showMessagesFromReferences = other.showMessagesFromReferences;
        this.doImplicitFHIRPathStringConversion = other.doImplicitFHIRPathStringConversion;
        this.htmlInMarkdownCheck = other.htmlInMarkdownCheck;
        this.allowDoubleQuotesInFHIRPath = other.allowDoubleQuotesInFHIRPath;
        this.checkIPSCodes = other.checkIPSCodes;
        this.locale = other.locale;
        this.igs.addAll(other.igs);
        this.extensionDomains.addAll(other.extensionDomains);
        this.showTimes = other.showTimes;
        this.bundleValidationRules.addAll(other.bundleValidationRules);
        this.questionnaireMode = other.questionnaireMode;
        this.level = other.level;
        this.fhirPathEngine = other.fhirPathEngine;
        this.igLoader = other.igLoader;
        this.jurisdiction = other.jurisdiction;
    }

    private ValidationEngine() {
    }

    private void loadCoreDefinitions(String src, boolean recursive, String terminologyCachePath, String userAgent, TimeTracker tt, ILoggingService loggingService) throws FHIRException, IOException {
        NpmPackage npm = this.getPcm().loadPackage(src, null);
        if (npm != null) {
            this.version = npm.fhirVersion();
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder().withLoggingService(loggingService);
            if (terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(terminologyCachePath);
            }
            if (userAgent != null) {
                contextBuilder.withUserAgent(userAgent);
            }
            this.context = contextBuilder.fromPackage(npm, (IContextResourceLoader)ValidatorUtils.loaderForVersion(this.version), false);
        } else {
            Map<String, ByteProvider> source = this.igLoader.loadIgSource(src, recursive, true);
            if (this.version == null) {
                this.version = this.getVersionFromPack(source);
            }
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder();
            if (terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(terminologyCachePath);
            }
            if (userAgent != null) {
                contextBuilder.withUserAgent(userAgent);
            }
            this.context = contextBuilder.fromDefinitions(source, (IContextResourceLoader)ValidatorUtils.loaderForVersion(this.version), new PackageInformation(src, this.version, new Date()));
            ValidatorUtils.grabNatives(this.getBinaries(), source, "http://hl7.org/fhir");
        }
        try {
            ClassLoader classLoader = ValidationEngine.class.getClassLoader();
            InputStream ue = classLoader.getResourceAsStream("ucum-essence.xml");
            this.context.setUcumService((UcumService)new UcumEssenceService(ue));
        }
        catch (Exception e) {
            throw new FHIRException("Error loading UCUM from embedded ucum-essence.xml: " + e.getMessage(), (Throwable)e);
        }
        this.initContext(tt);
    }

    protected void initContext(TimeTracker tt) throws IOException {
        this.context.setCanNoTS(true);
        this.context.setCacheId(UUID.randomUUID().toString());
        this.context.setAllowLoadingDuplicates(true);
        this.context.setExpansionProfile(this.makeExpProfile());
        if (tt != null) {
            this.context.setClock(tt);
        }
        NpmPackage npmX = this.getPcm().loadPackage("hl7.fhir.xver-extensions", "0.1.0");
        this.context.loadFromPackage(npmX, null);
        this.fhirPathEngine = new FHIRPathEngine((IWorkerContext)this.context);
        this.fhirPathEngine.setAllowDoubleQuotes(false);
    }

    private String getVersionFromPack(Map<String, ByteProvider> source) throws FileNotFoundException, IOException {
        if (source.containsKey("version.info")) {
            IniFile vi = new IniFile((InputStream)new ByteArrayInputStream(this.removeBom(source.get("version.info").getBytes())));
            return vi.getStringProperty("FHIR", "version");
        }
        throw new Error("Missing version.info?");
    }

    private byte[] removeBom(byte[] bs) {
        if (bs.length > 3 && bs[0] == -17 && bs[1] == -69 && bs[2] == -65) {
            return Arrays.copyOfRange(bs, 3, bs.length);
        }
        return bs;
    }

    private Parameters makeExpProfile() {
        Parameters ep = new Parameters();
        ep.addParameter("profile-url", "http://hl7.org/fhir/ExpansionProfile/dc8fd4bc-091a-424a-8a3b-6198ef146891");
        return ep;
    }

    public String connectToTSServer(String url, String log, FhirPublication version) throws URISyntaxException, IOException, FHIRException {
        return this.connectToTSServer(url, log, null, version);
    }

    public String connectToTSServer(String url, String log, String txCachePath, FhirPublication version) throws URISyntaxException, IOException, FHIRException {
        this.context.setTlogging(false);
        if (url == null) {
            this.context.setCanRunWithoutTerminology(true);
            this.context.setNoTerminologyServer(true);
            return "n/a: No Terminology Server";
        }
        try {
            return this.context.connectToTSServer(TerminologyClientFactory.makeClient((String)"Tx-Server", (String)url, (String)this.context.getUserAgent(), (FhirPublication)version), log);
        }
        catch (Exception e) {
            if (this.context.isCanRunWithoutTerminology()) {
                return "n/a: Running without Terminology Server (error: " + e.getMessage() + ")";
            }
            throw e;
        }
    }

    public void loadProfile(String src) throws FHIRException, IOException {
        if (this.context.hasResource(StructureDefinition.class, src)) {
            return;
        }
        if (this.context.hasResource(ImplementationGuide.class, src)) {
            return;
        }
        byte[] source = ProfileLoader.loadProfileSource(src);
        Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])source);
        Resource r = FormatUtilities.makeParser((Manager.FhirFormat)fmt).parse(source);
        this.context.cacheResource(r);
    }

    public OperationOutcome validate(Manager.FhirFormat format, InputStream stream, List<String> profiles) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator(format);
        validator.validate(null, messages, stream, format, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public List<StructureDefinition> asSdList(List<String> profiles) throws Error {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        if (profiles != null) {
            for (String p : profiles) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
                if (sd == null) {
                    throw new Error("Unable to resolve profile " + p);
                }
                list.add(sd);
            }
        }
        return list;
    }

    public OperationOutcome validate(String source, List<String> profiles, IValidationEngineLoader loader, boolean all) throws FHIRException, IOException, InterruptedException {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        l.add(source);
        return (OperationOutcome)this.validate(l, profiles, refs, null, loader, all, 0, true);
    }

    public Resource validate(List<String> sources, List<String> profiles, List<ValidatorUtils.SourceFile> refs, List<ValidationRecord> record, IValidationEngineLoader loader, boolean all, int delay, boolean first) throws FHIRException, IOException, InterruptedException {
        boolean asBundle = ValidatorUtils.parseSources(sources, refs, this.context);
        Bundle results = new Bundle();
        results.setType(Bundle.BundleType.COLLECTION);
        boolean found = false;
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess()) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        if (!first && delay != 0) {
            Thread.sleep(delay);
        }
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess() && !all || ref.isKnownToBeMissing()) continue;
            ref.setCnt(this.igLoader.loadContent(ref.getRef(), "validate", false, first));
            if (loader == null || ref.getCnt() == null) continue;
            try {
                loader.load(ref.getCnt());
            }
            catch (Throwable t) {
                if (!this.debug) continue;
                System.out.println("Error during round 1 scanning: " + t.getMessage());
            }
        }
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess() && !all || ref.getCnt() == null) continue;
            TimeTracker.Session tts = this.context.clock().start("validation");
            this.context.clock().milestone();
            System.out.println("  Validate " + ref.getRef());
            try {
                OperationOutcome outcome = this.validate(ref.getRef(), ref.getCnt().getFocus(), ref.getCnt().getCntType(), profiles, record);
                ToolingExtensions.addStringExtension((DomainResource)outcome, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file", (String)ref.getRef());
                System.out.println(" " + this.context.clock().milestone());
                results.addEntry().setResource((Resource)outcome);
                tts.end();
            }
            catch (Exception e) {
                System.out.println("Validation Infrastructure fail validating " + ref + ": " + e.getMessage());
                tts.end();
                throw new FHIRException((Throwable)e);
            }
            ref.setProcess(false);
        }
        if (asBundle) {
            return results;
        }
        return results.getEntryFirstRep().getResource();
    }

    public ValidatedFragments validateAsFragments(byte[] source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationMessage> messages) throws FHIRException, IOException, EOperationOutcome {
        InstanceValidator validator = this.getValidator(cntType);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return new ValidatedFragments(validator.validatedContent, ValidationTime.fromTimeTracker(validator.timeTracker));
    }

    public OperationOutcome validate(byte[] source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationMessage> messages) throws FHIRException, IOException, EOperationOutcome {
        InstanceValidator validator = this.getValidator(cntType);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public OperationOutcome validate(String location, ByteProvider source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationRecord> record) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            SchemaValidator.validateSchema(location, cntType, messages);
        }
        InstanceValidator validator = this.getValidator(cntType);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source.getBytes()), cntType, this.asSdList(profiles));
        if (this.showTimes) {
            System.out.println(location + ": " + validator.reportTimes());
        }
        if (record != null) {
            boolean found = false;
            for (ValidationRecord t : record) {
                if (!t.getLocation().equals(location)) continue;
                found = true;
                t.setMessages(messages);
            }
            if (!found) {
                record.add(new ValidationRecord(location, messages));
            }
        }
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles, IdStatus resourceIdRule, boolean anyExtensionsAllowed, BestPracticeWarningLevel bpWarnings, CheckDisplayOption displayOption) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            SchemaValidator.validateSchema(location, cntType, messages);
        }
        InstanceValidator validator = this.getValidator(cntType);
        validator.setResourceIdRule(resourceIdRule);
        validator.setBestPracticeWarningLevel(bpWarnings);
        validator.setCheckDisplay(displayOption);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public Element transform(String source, String map) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        return this.transform(cnt.getFocus(), cnt.getCntType(), map);
    }

    public StructureMap compile(String mapUri) throws FHIRException, IOException {
        StructureMap map = (StructureMap)this.context.fetchResource(StructureMap.class, mapUri);
        return map;
    }

    public Element transform(ByteProvider source, Manager.FhirFormat cntType, String mapUri) throws FHIRException, IOException {
        ArrayList<Base> outputs = new ArrayList<Base>();
        StructureMapUtilities scu = new StructureMapUtilities((IWorkerContext)this.context, (ITransformerServices)new TransformSupportServices(outputs, this.mapLog, this.context));
        StructureMap map = (StructureMap)this.context.fetchResource(StructureMap.class, mapUri);
        if (map == null) {
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        Element resource = this.getTargetResourceFromStructureMap(map);
        StructureDefinition sourceSD = this.getSourceResourceFromStructureMap(map);
        ParserBase parser = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)cntType);
        if (sourceSD.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            parser.setLogical(sourceSD);
        }
        Element src = parser.parseSingle((InputStream)new ByteArrayInputStream(source.getBytes()), null);
        scu.transform(null, (Base)src, map, (Base)resource);
        resource.populatePaths(null);
        return resource;
    }

    private Element getTargetResourceFromStructureMap(StructureMap map) {
        String targetTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        if (targetTypeUrl == null) {
            throw new FHIRException("Unable to determine resource URL for target type");
        }
        StructureDefinition structureDefinition = null;
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase(targetTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            throw new FHIRException("Unable to find StructureDefinition for target type ('" + targetTypeUrl + "')");
        }
        return Manager.build((IWorkerContext)this.getContext(), structureDefinition);
    }

    private StructureDefinition getSourceResourceFromStructureMap(StructureMap map) {
        StructureMap.StructureMapGroupComponent g = (StructureMap.StructureMapGroupComponent)map.getGroup().get(0);
        String type = null;
        for (Object inp : g.getInput()) {
            if (inp.getMode() != StructureMap.StructureMapInputMode.SOURCE) continue;
            if (type != null) {
                throw new DefinitionException("This engine does not support multiple source inputs");
            }
            type = inp.getType();
        }
        String sourceTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.SOURCE || !component.getAlias().equalsIgnoreCase(type)) continue;
            sourceTypeUrl = component.getUrl();
            break;
        }
        StructureDefinition structureDefinition = null;
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase(sourceTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            throw new FHIRException("Unable to find StructureDefinition for source type ('" + sourceTypeUrl + "')");
        }
        return structureDefinition;
    }

    public Resource generate(String source, String version) throws FHIRException, IOException, EOperationOutcome {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), source);
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE);
        this.genResource(res, rc);
        return res;
    }

    public void genResource(Resource res, RenderingContext rc) throws IOException, EOperationOutcome {
        if (res instanceof Bundle) {
            Bundle bnd = (Bundle)res;
            for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                if (!be.hasResource()) continue;
                this.genResource(be.getResource(), rc);
            }
        } else {
            RendererFactory.factory((Resource)res, (RenderingContext)rc).render((DomainResource)res);
        }
    }

    public void convert(String source, String output) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Element e = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        Manager.compose((IWorkerContext)this.context, (Element)e, (OutputStream)new FileOutputStream(output), (Manager.FhirFormat)(output.endsWith(".json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
    }

    public String evaluateFhirPath(String source, String expression) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        FHIRPathEngine fpe = this.getValidator(null).getFHIRPathEngine();
        Element e = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        ExpressionNode exp = fpe.parse(expression);
        return fpe.evaluateToString((Object)new ValidationContext(this.context, e), (Base)e, (Base)e, (Base)e, exp);
    }

    public StructureDefinition snapshot(String source, String version) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), Utilities.getFileNameForName((String)source));
        if (!(res instanceof StructureDefinition)) {
            throw new FHIRException("Require a StructureDefinition for generating a snapshot");
        }
        StructureDefinition sd = (StructureDefinition)res;
        StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(base, sd, sd.getUrl(), null, sd.getName());
        return sd;
    }

    public CanonicalResource loadCanonicalResource(String source, String version) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), Utilities.getFileNameForName((String)source));
        if (!(res instanceof CanonicalResource)) {
            throw new FHIRException("Require a CanonicalResource");
        }
        return (CanonicalResource)res;
    }

    public void seeResource(Resource r) throws FHIRException {
        this.context.cacheResource(r);
    }

    public void dropResource(String type, String id) {
        this.context.dropResource(type, id);
    }

    public InstanceValidator getValidator(Manager.FhirFormat format) throws FHIRException, IOException {
        InstanceValidator validator = new InstanceValidator((IWorkerContext)this.context, null, null);
        validator.setHintAboutNonMustSupport(this.hintAboutNonMustSupport);
        validator.setAnyExtensionsAllowed(this.anyExtensionsAllowed);
        validator.getExtensionDomains().clear();
        validator.getExtensionDomains().addAll(this.extensionDomains);
        validator.setNoInvariantChecks(this.isNoInvariantChecks());
        validator.setWantInvariantInMessage(this.isWantInvariantInMessage());
        validator.setValidationLanguage(this.language);
        validator.setDisplayWarnings(this.isDisplayWarnings());
        if (this.language != null) {
            validator.getContext().setValidationMessageLanguage(Locale.forLanguageTag(this.language));
        }
        validator.setAssumeValidRestReferences(this.assumeValidRestReferences);
        validator.setNoExtensibleWarnings(this.noExtensibleBindingMessages);
        validator.setSecurityChecks(this.securityChecks);
        validator.setCrumbTrails(this.crumbTrails);
        validator.setForPublication(this.forPublication);
        validator.setAllowExamples(this.allowExampleUrls);
        validator.setShowMessagesFromReferences(this.showMessagesFromReferences);
        validator.getContext().setLocale(this.locale);
        validator.setFetcher(this);
        validator.getImplementationGuides().addAll(this.igs);
        validator.getBundleValidationRules().addAll(this.bundleValidationRules);
        validator.getValidationControl().putAll(this.validationControl);
        validator.setQuestionnaireMode(this.questionnaireMode);
        validator.setLevel(this.level);
        validator.setHtmlInMarkdownCheck(this.htmlInMarkdownCheck);
        validator.setBestPracticeWarningLevel(this.bestPracticeLevel);
        validator.setAllowDoubleQuotesInFHIRPath(this.allowDoubleQuotesInFHIRPath);
        validator.setNoUnicodeBiDiControlChars(this.noUnicodeBiDiControlChars);
        validator.setDoImplicitFHIRPathStringConversion(this.doImplicitFHIRPathStringConversion);
        validator.setCheckIPSCodes(this.checkIPSCodes);
        if (format == Manager.FhirFormat.SHC) {
            this.igLoader.loadIg(this.getIgs(), this.getBinaries(), "hl7.fhir.uv.shc-vaccination#0.6.2", true);
        }
        validator.setJurisdiction(this.jurisdiction);
        validator.setLogProgress(true);
        return validator;
    }

    public void prepare() {
        for (StructureDefinition sd : new ContextUtilities((IWorkerContext)this.context).allStructures()) {
            try {
                this.makeSnapshot(sd);
            }
            catch (Exception e) {
                System.out.println("Process Note: Unable to generate snapshot for " + sd.present() + ": " + e.getMessage());
                if (!this.context.getLogger().isDebugLogging()) continue;
                e.printStackTrace();
            }
        }
    }

    private void makeSnapshot(StructureDefinition sd) throws DefinitionException, FHIRException {
        if (sd.hasSnapshot()) {
            return;
        }
        StructureDefinition sdb = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        if (sdb != null) {
            this.makeSnapshot(sdb);
            new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(sdb, sd, sd.getUrl(), null, sd.getName());
        }
    }

    public void handleOutput(Resource r, String output, String version) throws FHIRException, IOException {
        if (output.startsWith("http://")) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            this.handleOutputToStream(r, output, bs, version);
            SimpleHTTPClient http = new SimpleHTTPClient();
            SimpleHTTPClient.HTTPResult res = http.post(output, "application/fhir+xml", bs.toByteArray(), "application/fhir+xml");
            res.checkThrowException();
        } else {
            FileOutputStream s = new FileOutputStream(output);
            this.handleOutputToStream(r, output, s, version);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOutputToStream(Resource r, String fn, OutputStream s, String version) throws FHIRException, IOException {
        if (fn.endsWith(".html") || fn.endsWith(".htm") && r instanceof DomainResource) {
            new XhtmlComposer(false, true).compose(s, ((DomainResource)r).getText().getDiv());
        } else if (VersionUtilities.isR3Ver((String)version)) {
            org.hl7.fhir.dstu3.model.Resource res = VersionConvertorFactory_30_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu3.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.dstu3.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map") && !fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)org.hl7.fhir.dstu3.utils.StructureMapUtilities.render((org.hl7.fhir.dstu3.model.StructureMap)((org.hl7.fhir.dstu3.model.StructureMap)res)), (OutputStream)s, (boolean)false);
            }
        } else if (VersionUtilities.isR4Ver((String)version)) {
            org.hl7.fhir.r4.model.Resource res = VersionConvertorFactory_40_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r4.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map") && !fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)org.hl7.fhir.r4.utils.StructureMapUtilities.render((org.hl7.fhir.r4.model.StructureMap)((org.hl7.fhir.r4.model.StructureMap)res)), (OutputStream)s, (boolean)false);
            }
        } else if (VersionUtilities.isR2BVer((String)version)) {
            org.hl7.fhir.dstu2016may.model.Resource res = VersionConvertorFactory_14_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2016may.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else if (VersionUtilities.isR2Ver((String)version)) {
            org.hl7.fhir.dstu2.model.Resource res = VersionConvertorFactory_10_50.convertResource((Resource)r, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else {
            if (!VersionUtilities.isR5Plus((String)version)) throw new FHIRException("Encountered unsupported configured version " + version + " loading " + fn);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.r5.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r5.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map") && !fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                TextFile.stringToStream((String)StructureMapUtilities.render((StructureMap)((StructureMap)r)), (OutputStream)s, (boolean)false);
            }
        }
        s.close();
    }

    public byte[] transformVersion(String source, String targetVer, Manager.FhirFormat format, Boolean canDoNative) throws FHIRException, IOException, Exception {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Element src = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        if (canDoNative == null && src.hasChild("url", false) || canDoNative != null && canDoNative.booleanValue()) {
            try {
                if (VersionUtilities.isR2Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR2(targetVer, cnt, format);
                }
                if (VersionUtilities.isR2BVer((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR2b(targetVer, cnt, format);
                }
                if (VersionUtilities.isR3Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR3(targetVer, cnt, format);
                }
                if (VersionUtilities.isR4Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR4(targetVer, cnt, format);
                }
                if (VersionUtilities.isR4BVer((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR4b(targetVer, cnt, format);
                }
                if (VersionUtilities.isR5Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR5(targetVer, cnt, format);
                }
                throw new FHIRException("Source version not supported yet: " + this.version);
            }
            catch (Exception e) {
                System.out.println("Conversion failed using Java convertor: " + e.getMessage());
            }
        }
        System.out.println("Loading hl7.fhir.xver.r4");
        this.igLoader.loadIg(this.getIgs(), this.getBinaries(), "hl7.fhir.xver.r4", false);
        String type = src.fhirType();
        String url = this.getMapId(type, targetVer);
        ArrayList<Base> outputs = new ArrayList<Base>();
        StructureMapUtilities scu = new StructureMapUtilities((IWorkerContext)this.context, (ITransformerServices)new TransformSupportServices(outputs, this.mapLog, this.context));
        StructureMap map = (StructureMap)this.context.fetchResource(StructureMap.class, url);
        if (map == null) {
            throw new Error("Unable to find map " + url + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        Element resource = this.getTargetResourceFromStructureMap(map);
        scu.transform(null, (Base)src, map, (Base)resource);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)resource, (OutputStream)bs, (Manager.FhirFormat)format, (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        return bs.toByteArray();
    }

    private String getMapId(String type, String targetVer) {
        if (VersionUtilities.isR2Ver((String)this.version)) {
            if (VersionUtilities.isR3Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "2to3";
            }
        } else if (VersionUtilities.isR3Ver((String)this.version)) {
            if (VersionUtilities.isR2Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to2";
            }
            if (VersionUtilities.isR4Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to4";
            }
        } else if (VersionUtilities.isR4Ver((String)this.version)) {
            if (VersionUtilities.isR3Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "4to3";
            }
            if (VersionUtilities.isR5Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "4to5";
            }
        } else if (VersionUtilities.isR5Ver((String)this.version) && VersionUtilities.isR4Ver((String)targetVer)) {
            return "http://hl7.org/fhir/StructureMap/" + type + "5to4";
        }
        throw new FHIRException("Source/Target version not supported: " + this.version + " -> " + targetVer);
    }

    public String setTerminologyServer(String src, String log, FhirPublication version) throws FHIRException, URISyntaxException, IOException {
        return this.connectToTSServer(src, log, version);
    }

    public ValidationEngine setMapLog(String mapLog) throws FileNotFoundException {
        if (mapLog != null) {
            this.mapLog = new PrintWriter(mapLog);
        }
        return this;
    }

    public ValidationEngine setSnomedExtension(String sct) {
        this.getContext().getExpansionParameters().addParameter("system-version", "http://snomed.info/sct|http://snomed.info/sct/" + sct);
        return this;
    }

    public FilesystemPackageCacheManager getPcm() throws IOException {
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager.Builder().build();
        }
        return this.pcm;
    }

    public byte[] fetchRaw(IResourceValidator validator, String source) throws IOException {
        SimpleHTTPClient http = new SimpleHTTPClient();
        SimpleHTTPClient.HTTPResult res = http.get(source);
        res.checkThrowException();
        return res.getContent();
    }

    @Override
    public boolean packageExists(String id, String ver) throws IOException, FHIRException {
        return this.getPcm().packageExists(id, ver);
    }

    @Override
    public void loadPackage(String id, String ver) throws IOException, FHIRException {
        this.igLoader.loadIg(this.getIgs(), this.getBinaries(), id + (String)(ver == null ? "" : "#" + ver), true);
    }

    public Element fetch(IResourceValidator validator, Object appContext, String url) throws FHIRException, IOException {
        Resource resource = this.context.fetchResource(Resource.class, url);
        if (resource != null) {
            return new ObjectConverter((IWorkerContext)this.context).convert(resource);
        }
        if (this.fetcher != null) {
            return this.fetcher.fetch(validator, appContext, url);
        }
        return null;
    }

    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url) {
        Resource resource = this.context.fetchResource(StructureDefinition.class, url);
        if (resource != null) {
            return ReferenceValidationPolicy.CHECK_VALID;
        }
        if (!url.contains("hl7.org") && !url.contains("fhir.org")) {
            return ReferenceValidationPolicy.IGNORE;
        }
        if (this.policyAdvisor != null) {
            return this.policyAdvisor.policyForReference(validator, appContext, path, url);
        }
        return ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE;
    }

    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        return ContainedReferenceValidationPolicy.CHECK_VALID;
    }

    public CodedContentValidationPolicy policyForCodedContent(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, BindingKind kind, ValueSet valueSet, List<String> systems) {
        return CodedContentValidationPolicy.VALUESET;
    }

    public boolean resolveURL(IResourceValidator validator, Object appContext, String path, String url, String type, boolean canonical) throws FHIRException {
        if (this.resolvedUrls.containsKey(type + "|" + url)) {
            return this.resolvedUrls.get(type + "|" + url);
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (this.context.fetchResource(Resource.class, url) != null) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (SIDUtilities.isKnownSID((String)url) || Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/w5", "http://hl7.org/fhir/fivews", "http://hl7.org/fhir/workflow", "http://hl7.org/fhir/ConsentPolicy/opt-out", "http://hl7.org/fhir/ConsentPolicy/opt-in"})) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (Utilities.existsInList((String)url, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://snomed.info/sct"})) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (this.context.getNSUrlMap().containsKey(url)) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (url.contains("example.org") || url.contains("acme.com")) {
            this.resolvedUrls.put(type + "|" + url, false);
            return false;
        }
        if (url.contains("*") && !url.contains("?")) {
            List maps;
            if (this.cu == null) {
                this.cu = new ContextUtilities((IWorkerContext)this.context);
            }
            if (!(maps = this.cu.listMaps(url)).isEmpty()) {
                return true;
            }
        }
        if (this.fetcher != null) {
            try {
                boolean ok = this.fetcher.resolveURL(validator, appContext, path, url, type, canonical);
                this.resolvedUrls.put(type + "|" + url, ok);
                return ok;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.resolvedUrls.put(type + "|" + url, false);
                return false;
            }
        }
        this.resolvedUrls.put(type + "|" + url, false);
        return false;
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator validator, String url) throws URISyntaxException {
        Resource res = this.context.fetchResource(Resource.class, url);
        if (res != null) {
            if (res instanceof CanonicalResource) {
                return (CanonicalResource)res;
            }
            return null;
        }
        return this.fetcher != null ? this.fetcher.fetchCanonicalResource(validator, url) : null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return this.fetcher != null && this.fetcher.fetchesCanonicalResource(validator, url);
    }

    public void packageLoaded(String pid, String version) {
        this.resolvedUrls.clear();
    }

    public Resource loadResource(byte[] content, String fn) throws FHIRException, IOException {
        return this.igLoader.loadResourceByVersion(this.version, content, fn);
    }

    public SimpleWorkerContext getContext() {
        return this.context;
    }

    public ValidationEngine setContext(SimpleWorkerContext context) {
        this.context = context;
        return this;
    }

    public Map<String, ByteProvider> getBinaries() {
        return this.binaries;
    }

    public ValidationEngine setBinaries(Map<String, ByteProvider> binaries) {
        this.binaries = binaries;
        return this;
    }

    public boolean isDoNative() {
        return this.doNative;
    }

    public ValidationEngine setDoNative(boolean doNative) {
        this.doNative = doNative;
        return this;
    }

    public boolean isNoInvariantChecks() {
        return this.noInvariantChecks;
    }

    public ValidationEngine setNoInvariantChecks(boolean noInvariantChecks) {
        this.noInvariantChecks = noInvariantChecks;
        return this;
    }

    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    public ValidationEngine setDisplayWarnings(boolean displayWarnings) {
        this.displayWarnings = displayWarnings;
        return this;
    }

    public boolean isWantInvariantInMessage() {
        return this.wantInvariantInMessage;
    }

    public ValidationEngine setWantInvariantInMessage(boolean wantInvariantInMessage) {
        this.wantInvariantInMessage = wantInvariantInMessage;
        return this;
    }

    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    public ValidationEngine setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
        return this;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    public ValidationEngine setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ValidationEngine setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public ValidationEngine setLanguage(String language) {
        this.language = language;
        return this;
    }

    public ValidationEngine setPcm(FilesystemPackageCacheManager pcm) {
        this.pcm = pcm;
        return this;
    }

    public PrintWriter getMapLog() {
        return this.mapLog;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ValidationEngine setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    public ValidationEngine setFetcher(IValidatorResourceFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    public IValidationPolicyAdvisor getPolicyAdvisor() {
        return this.policyAdvisor;
    }

    public ValidationEngine setPolicyAdvisor(IValidationPolicyAdvisor policyAdvisor) {
        this.policyAdvisor = policyAdvisor;
        return this;
    }

    public IWorkerContextManager.ICanonicalResourceLocator getLocator() {
        return this.locator;
    }

    public ValidationEngine setLocator(IWorkerContextManager.ICanonicalResourceLocator locator) {
        this.locator = locator;
        return this;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public ValidationEngine setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
        return this;
    }

    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    public ValidationEngine setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    public boolean isNoUnicodeBiDiControlChars() {
        return this.noUnicodeBiDiControlChars;
    }

    public ValidationEngine setNoUnicodeBiDiControlChars(boolean noUnicodeBiDiControlChars) {
        this.noUnicodeBiDiControlChars = noUnicodeBiDiControlChars;
        return this;
    }

    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    public ValidationEngine setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
        return this;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public ValidationEngine setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
        return this;
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public ValidationEngine setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        return this;
    }

    public boolean isAllowExampleUrls() {
        return this.allowExampleUrls;
    }

    public ValidationEngine setAllowExampleUrls(boolean allowExampleUrls) {
        this.allowExampleUrls = allowExampleUrls;
        return this;
    }

    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    public ValidationEngine setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
        return this;
    }

    public boolean isDoImplicitFHIRPathStringConversion() {
        return this.doImplicitFHIRPathStringConversion;
    }

    public ValidationEngine setDoImplicitFHIRPathStringConversion(boolean doImplicitFHIRPathStringConversion) {
        this.doImplicitFHIRPathStringConversion = doImplicitFHIRPathStringConversion;
        return this;
    }

    public HtmlInMarkdownCheck getHtmlInMarkdownCheck() {
        return this.htmlInMarkdownCheck;
    }

    public ValidationEngine setHtmlInMarkdownCheck(HtmlInMarkdownCheck htmlInMarkdownCheck) {
        this.htmlInMarkdownCheck = htmlInMarkdownCheck;
        return this;
    }

    public boolean isAllowDoubleQuotesInFHIRPath() {
        return this.allowDoubleQuotesInFHIRPath;
    }

    public ValidationEngine setAllowDoubleQuotesInFHIRPath(boolean allowDoubleQuotesInFHIRPath) {
        this.allowDoubleQuotesInFHIRPath = allowDoubleQuotesInFHIRPath;
        return this;
    }

    public boolean isCheckIPSCodes() {
        return this.checkIPSCodes;
    }

    public ValidationEngine setCheckIPSCodes(boolean checkIPSCodes) {
        this.checkIPSCodes = checkIPSCodes;
        return this;
    }

    public BestPracticeWarningLevel getBestPracticeLevel() {
        return this.bestPracticeLevel;
    }

    public ValidationEngine setBestPracticeLevel(BestPracticeWarningLevel bestPracticeLevel) {
        this.bestPracticeLevel = bestPracticeLevel;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ValidationEngine setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public List<ImplementationGuide> getIgs() {
        return this.igs;
    }

    public ValidationEngine setIgs(List<ImplementationGuide> igs) {
        this.igs = igs;
        return this;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    public ValidationEngine setExtensionDomains(List<String> extensionDomains) {
        this.extensionDomains = extensionDomains;
        return this;
    }

    public boolean isShowTimes() {
        return this.showTimes;
    }

    public ValidationEngine setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
        return this;
    }

    public List<BundleValidationRule> getBundleValidationRules() {
        return this.bundleValidationRules;
    }

    public ValidationEngine setBundleValidationRules(List<BundleValidationRule> bundleValidationRules) {
        this.bundleValidationRules = bundleValidationRules;
        return this;
    }

    public QuestionnaireMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    public ValidationEngine setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    public ValidationLevel getLevel() {
        return this.level;
    }

    public ValidationEngine setLevel(ValidationLevel level) {
        this.level = level;
        return this;
    }

    public FHIRPathEngine getFhirPathEngine() {
        return this.fhirPathEngine;
    }

    public ValidationEngine setFhirPathEngine(FHIRPathEngine fhirPathEngine) {
        this.fhirPathEngine = fhirPathEngine;
        return this;
    }

    public IgLoader getIgLoader() {
        return this.igLoader;
    }

    public ValidationEngine setIgLoader(IgLoader igLoader) {
        this.igLoader = igLoader;
        return this;
    }

    public Coding getJurisdiction() {
        return this.jurisdiction;
    }

    public ValidationEngine setJurisdiction(Coding jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    public Map<String, BaseValidator.ValidationControl> getValidationControl() {
        return this.validationControl;
    }

    public ValidationEngine setValidationControl(Map<String, BaseValidator.ValidationControl> validationControl) {
        this.validationControl = validationControl;
        return this;
    }

    public static class ValidationEngineBuilder {
        private final String terminologyCachePath;
        private final String userAgent;
        private final String version;
        private final String txServer;
        private final String txLog;
        private final FhirPublication txVersion;
        private final TimeTracker timeTracker;
        private final boolean canRunWithoutTerminologyServer;
        private final ILoggingService loggingService;
        private boolean THO = true;

        public ValidationEngineBuilder() {
            this.terminologyCachePath = null;
            this.userAgent = null;
            this.version = null;
            this.txServer = null;
            this.txLog = null;
            this.txVersion = null;
            this.timeTracker = null;
            this.canRunWithoutTerminologyServer = false;
            this.loggingService = new SystemOutLoggingService();
        }

        public ValidationEngineBuilder(String terminologyCachePath, String userAgent, String version, String txServer, String txLog, FhirPublication txVersion, TimeTracker timeTracker, boolean canRunWithoutTerminologyServer, ILoggingService loggingService, boolean THO) {
            this.terminologyCachePath = terminologyCachePath;
            this.userAgent = userAgent;
            this.version = version;
            this.txServer = txServer;
            this.txLog = txLog;
            this.txVersion = txVersion;
            this.timeTracker = timeTracker;
            this.canRunWithoutTerminologyServer = canRunWithoutTerminologyServer;
            this.loggingService = loggingService;
            this.THO = THO;
        }

        public ValidationEngineBuilder withTxServer(String txServer, String txLog, FhirPublication txVersion) {
            return new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, txServer, txLog, txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withNoTerminologyServer() {
            return new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, null, null, this.txVersion, this.timeTracker, true, this.loggingService, this.THO);
        }

        public ValidationEngine fromNothing() throws IOException {
            ValidationEngine engine = new ValidationEngine();
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder().withLoggingService(this.loggingService);
            if (this.terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(this.terminologyCachePath);
            }
            engine.setContext(contextBuilder.build());
            engine.initContext(this.timeTracker);
            engine.setIgLoader(new IgLoader(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug()));
            this.loadTx(engine);
            if (VersionUtilities.isR5Plus((String)this.version)) {
                engine.loadPackage("hl7.fhir.uv.extensions", null);
            }
            return engine;
        }

        public ValidationEngine fromSource(String src) throws IOException, URISyntaxException {
            ValidationEngine engine = new ValidationEngine();
            engine.loadCoreDefinitions(src, false, this.terminologyCachePath, this.userAgent, this.timeTracker, this.loggingService);
            engine.getContext().setCanRunWithoutTerminology(this.canRunWithoutTerminologyServer);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            if (this.txServer != null) {
                engine.setTerminologyServer(this.txServer, this.txLog, this.txVersion);
            }
            engine.setVersion(this.version);
            engine.setIgLoader(new IgLoader(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug()));
            if (this.THO) {
                this.loadTx(engine);
            }
            if (VersionUtilities.isR5Plus((String)this.version)) {
                engine.loadPackage("hl7.fhir.uv.extensions", "1.0.0");
            }
            return engine;
        }

        private void loadTx(ValidationEngine engine) throws FHIRException, IOException {
            String pid = null;
            if (VersionUtilities.isR3Ver((String)this.version)) {
                pid = "hl7.terminology.r3";
            }
            if (VersionUtilities.isR4Ver((String)this.version)) {
                pid = "hl7.terminology.r4";
            }
            if (VersionUtilities.isR4BVer((String)this.version)) {
                pid = "hl7.terminology.r4";
            }
            if (VersionUtilities.isR5Plus((String)this.version)) {
                pid = "hl7.terminology.r5";
            }
            if (pid != null) {
                engine.loadPackage(pid, "5.0.0");
            }
        }

        public ValidationEngineBuilder withTerminologyCachePath(String terminologyCachePath) {
            return this.terminologyCachePath == terminologyCachePath ? this : new ValidationEngineBuilder(terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withUserAgent(String userAgent) {
            return this.userAgent == userAgent ? this : new ValidationEngineBuilder(this.terminologyCachePath, userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withVersion(String version) {
            return this.version == version ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, version, this.txServer, this.txLog, this.txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withTimeTracker(TimeTracker timeTracker) {
            return this.timeTracker == timeTracker ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withCanRunWithoutTerminologyServer(boolean canRunWithoutTerminologyServer) {
            return this.canRunWithoutTerminologyServer == canRunWithoutTerminologyServer ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.timeTracker, canRunWithoutTerminologyServer, this.loggingService, this.THO);
        }

        public ValidationEngineBuilder withLoggingService(ILoggingService loggingService) {
            return this.loggingService == loggingService ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, loggingService, this.THO);
        }

        public ValidationEngineBuilder withTHO(boolean THO) {
            return this.THO == THO ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, THO);
        }
    }

    public static interface IValidationEngineLoader {
        public void load(Content var1) throws FHIRException, IOException;
    }
}

