/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;

public class TxTesterSorters {
    public static void sortParameters(Parameters po) {
        Collections.sort(po.getParameter(), new ParameterSorter());
        for (Parameters.ParametersParameterComponent p : po.getParameter()) {
            String pv;
            if (p.getResource() != null && p.getResource() instanceof OperationOutcome) {
                Collections.sort(((OperationOutcome)p.getResource()).getIssue(), new OperationIssueSorter());
            }
            if (!"message".equals(p.getName()) || !p.hasValuePrimitive() || !(pv = p.getValue().primitiveValue()).contains("; ")) continue;
            ArrayList<String> bits = new ArrayList<String>();
            for (String s : pv.split("\\; ")) {
                bits.add(s);
            }
            Collections.sort(bits);
            p.setValue((DataType)new StringType(CommaSeparatedStringBuilder.join((String)"; ", bits)));
        }
    }

    public static void sortOperationOutcome(OperationOutcome oo) {
        Collections.sort(oo.getIssue(), new OperationIssueSorter());
    }

    public static void sortValueSet(ValueSet vs) {
        Collections.sort(vs.getExtension(), new ExtensionSorter());
        if (vs.hasExpansion()) {
            Collections.sort(vs.getExpansion().getParameter(), new ExpParameterSorter());
            Collections.sort(vs.getExpansion().getProperty(), new PropertyDefnSorter());
            Collections.sort(vs.getExpansion().getExtension(), new ExtensionSorter());
            Collections.sort(vs.getExpansion().getContains(), new ContainsSorter());
            for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
                TxTesterSorters.sortContainsFeatures(cc);
            }
        }
    }

    public static void sortContainsFeatures(ValueSet.ValueSetExpansionContainsComponent cc) {
        Collections.sort(cc.getContains(), new ContainsSorter());
        Collections.sort(cc.getExtension(), new ExtensionSorter());
        Collections.sort(cc.getDesignation(), new DesignationSorter());
        Collections.sort(cc.getProperty(), new PropertyValueSorter());
        for (ValueSet.ValueSetExpansionContainsComponent c : cc.getContains()) {
            TxTesterSorters.sortContainsFeatures(c);
        }
    }

    public static class ParameterSorter
    implements Comparator<Parameters.ParametersParameterComponent> {
        @Override
        public int compare(Parameters.ParametersParameterComponent o1, Parameters.ParametersParameterComponent o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            Collections.sort(o1.getPart(), new ParameterSorter());
            Collections.sort(o2.getPart(), new ParameterSorter());
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class ExpParameterSorter
    implements Comparator<ValueSet.ValueSetExpansionParameterComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionParameterComponent o1, ValueSet.ValueSetExpansionParameterComponent o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            int res = o1.getName().compareTo(o2.getName());
            if (res == 0) {
                res = o1.getValue().primitiveValue().compareTo(o2.getValue().primitiveValue());
            }
            return res;
        }
    }

    public static class ContainsSorter
    implements Comparator<ValueSet.ValueSetExpansionContainsComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionContainsComponent o1, ValueSet.ValueSetExpansionContainsComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class PropertyValueSorter
    implements Comparator<ValueSet.ConceptPropertyComponent> {
        @Override
        public int compare(ValueSet.ConceptPropertyComponent o1, ValueSet.ConceptPropertyComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class ExtensionSorter
    implements Comparator<Extension> {
        @Override
        public int compare(Extension o1, Extension o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }

    public static class PropertyDefnSorter
    implements Comparator<ValueSet.ValueSetExpansionPropertyComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionPropertyComponent o1, ValueSet.ValueSetExpansionPropertyComponent o2) {
            int i = o1.getUri() == null || o2.getUri() == null ? (o1.getUri() == null && o2.getUri() == null ? 0 : (o1.getUri() == null ? -1 : 1)) : o1.getUri().compareTo(o2.getUri());
            if (i == 0) {
                return o1.getCode().compareTo(o2.getCode());
            }
            return i;
        }
    }

    public static class DesignationSorter
    implements Comparator<ValueSet.ConceptReferenceDesignationComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceDesignationComponent o1, ValueSet.ConceptReferenceDesignationComponent o2) {
            if (o1.hasLanguage() && o2.hasLanguage()) {
                return o1.getLanguage().compareTo(o2.getLanguage());
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }

    public static class OperationIssueSorter
    implements Comparator<OperationOutcome.OperationOutcomeIssueComponent> {
        @Override
        public int compare(OperationOutcome.OperationOutcomeIssueComponent o1, OperationOutcome.OperationOutcomeIssueComponent o2) {
            String s2;
            String s1 = o1.hasSeverity() ? o1.getSeverity().toCode() : "";
            int ret = s1.compareTo(s2 = o2.hasSeverity() ? o2.getSeverity().toCode() : "");
            if (ret == 0 && (ret = (s1 = o1.hasCode() ? o1.getCode().toCode() : "").compareTo(s2 = o2.hasCode() ? o2.getCode().toCode() : "")) == 0 && (ret = (s1 = o1.hasExpressionOrLocation() ? ((StringType)o1.getExpressionOrLocation().get(0)).primitiveValue() : "").compareTo(s2 = o2.hasExpressionOrLocation() ? ((StringType)o2.getExpressionOrLocation().get(0)).primitiveValue() : "")) == 0) {
                s1 = o1.getDetails().hasText() ? o1.getDetails().getText() : "";
                s2 = o2.getDetails().hasText() ? o2.getDetails().getText() : "";
                ret = s1.compareTo(s2);
            }
            return ret;
        }
    }
}

