/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class ResolvedReference {
    private Element resource;
    private Element focus;
    private boolean external;
    private NodeStack stack;

    public ResolvedReference setResource(Element resource) {
        this.resource = resource;
        return this;
    }

    public Element getResource() {
        return this.resource;
    }

    public ResolvedReference setFocus(Element focus) {
        this.focus = focus;
        return this;
    }

    public boolean isExternal() {
        return this.external;
    }

    public ResolvedReference setExternal(boolean external) {
        this.external = external;
        return this;
    }

    public ResolvedReference setStack(NodeStack stack) {
        this.stack = stack;
        return this;
    }

    public NodeStack getStack() {
        return this.stack;
    }

    public String getType() {
        return this.focus.fhirType();
    }

    public Element getFocus() {
        return this.focus;
    }

    public ValidationContext valContext(ValidationContext valContext, StructureDefinition profile) {
        if (this.external) {
            return valContext.forRemoteReference(profile, this.resource);
        }
        return valContext.forLocalReference(profile, this.resource);
    }
}

