/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class CodeSystemValidator
extends BaseValidator {
    public CodeSystemValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateCodeSystem(List<ValidationMessage> errors, Element cs, NodeStack stack, ValidationOptions options) {
        boolean ok = true;
        String url = cs.getNamedChildValue("url", false);
        String content = cs.getNamedChildValue("content", false);
        String caseSensitive = cs.getNamedChildValue("caseSensitive", false);
        String hierarchyMeaning = cs.getNamedChildValue("hierarchyMeaning", false);
        String supp = cs.getNamedChildValue("supplements", false);
        int count = this.countConcepts(cs);
        this.metaChecks(errors, cs, stack, url, content, caseSensitive, hierarchyMeaning, !Utilities.noString((String)supp), count, supp);
        String vsu = cs.getNamedChildValue("valueSet", false);
        if (!Utilities.noString((String)vsu)) {
            ValueSet vs;
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "complete".equals(content), "CODESYSTEM_CS_NO_VS_NOTCOMPLETE", new Object[0]);
            try {
                vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, vsu);
            }
            catch (FHIRException e) {
                vs = null;
            }
            if (vs != null) {
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.hasCompose(), "CodeSystem_CS_VS_Invalid", url, vsu)) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().size() == 1, "CodeSystem_CS_VS_Invalid", url, vsu)) {
                        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem().equals(url), "CodeSystem_CS_VS_WrongSystem", url, vsu, ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem())) {
                            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasValueSet() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasConcept() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasFilter(), "CodeSystem_CS_VS_IncludeDetails", url, vsu) && ok;
                            if (vs.hasExpansion()) {
                                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getExpansion().getContains().size() == count, "CODESYSTEM_CS_VS_EXP_MISMATCH", url, vsu, count, vs.getExpansion().getContains().size()) && ok;
                            }
                        } else {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            }
        }
        if (supp != null) {
            if (this.context.supportsSystem(supp, options.getFhirVersion())) {
                List concepts = cs.getChildrenByName("concept");
                int ce = 0;
                for (Element concept : concepts) {
                    NodeStack nstack = stack.push(concept, ce, null, null);
                    if (ce == 0) {
                        this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, !"not-present".equals(content), "CODESYSTEM_CS_COUNT_NO_CONTENT_ALLOWED", new Object[0]);
                    }
                    ok = this.validateSupplementConcept(errors, concept, nstack, supp, options) && ok;
                    ++ce;
                }
            } else if (cs.hasChildren("concept")) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "CODESYSTEM_CS_SUPP_CANT_CHECK", supp);
            }
        }
        if (!stack.isContained()) {
            ok = this.checkShareableCodeSystem(errors, cs, stack) && ok;
        }
        return ok;
    }

    private boolean checkShareableCodeSystem(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(cs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CODESYSTEM_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "description") && ok;
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("content", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "content") && ok;
                if (!"supplement".equals(cs.getChildValue("content"))) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("caseSensitive", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "caseSensitive") && ok;
                }
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CODESYSTEM_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CODESYSTEM_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CODESYSTEM_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CODESYSTEM_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CODESYSTEM_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CODESYSTEM_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CODESYSTEM_SHAREABLE_MISSING", "description");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("content", false), "CODESYSTEM_SHAREABLE_MISSING", "content");
            if (!"supplement".equals(cs.getChildValue("content"))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("caseSensitive", false), "CODESYSTEM_SHAREABLE_MISSING", "caseSensitive");
            }
        }
        return true;
    }

    private void metaChecks(List<ValidationMessage> errors, Element cs, NodeStack stack, String url, String content, String caseSensitive, String hierarchyMeaning, boolean isSupplement, int count, String supp) {
        List concepts;
        int statedCount;
        if (isSupplement) {
            NodeStack s;
            if (!"supplement".equals(content)) {
                s = stack.push(cs.getNamedChild("content", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL_WRONG", new Object[0]);
            }
            if (!Utilities.noString((String)caseSensitive)) {
                s = stack.push(cs.getNamedChild("caseSensitive", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL", "caseSensitive");
            }
            if (!Utilities.noString((String)hierarchyMeaning)) {
                s = stack.push(cs.getNamedChild("hierarchyMeaning", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL", "hierarchyMeaning");
            }
        } else {
            Element c;
            NodeStack s;
            boolean isHL7;
            boolean bl = isHL7 = url != null && (url.contains("hl7.org") || url.contains("fhir.org"));
            if (Utilities.noString((String)content)) {
                s = stack;
                c = cs.getNamedChild("content", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHALL", "content");
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "content");
                }
            } else if ("supplement".equals(content)) {
                s = stack.push(cs.getNamedChild("content", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL_MISSING", new Object[0]);
            }
            if (Utilities.noString((String)caseSensitive)) {
                s = stack;
                c = cs.getNamedChild("caseSensitive", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHOULD", "caseSensitive");
                } else {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "caseSensitive");
                }
            }
            if (Utilities.noString((String)hierarchyMeaning) && this.hasHeirarchy(cs)) {
                s = stack;
                c = cs.getNamedChild("hierarchyMeaning", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHOULD", "hierarchyMeaning");
                } else {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "hierarchyMeaning");
                }
            }
        }
        if (cs.hasChild("count", false) && (statedCount = Utilities.parseInt((String)cs.getNamedChildValue("count", false), (int)-1)) > -1 && content != null) {
            NodeStack nstack = stack.push(cs.getNamedChild("count", false), -1, null, null);
            switch (content) {
                case "complete": {
                    this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count == statedCount, "CODESYSTEM_CS_COUNT_COMPLETE_WRONG", count, statedCount);
                    break;
                }
                case "example": 
                case "fragment": {
                    this.warning(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count < statedCount, "CODESYSTEM_CS_COUNT_FRAGMENT_WRONG", count, statedCount);
                    break;
                }
                case "not-present": {
                    if (!cs.hasChildren("concept")) break;
                    this.hint(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, stack.push(cs.getNamedChild("concept", false), -1, null, null), statedCount > 0, "CODESYSTEM_CS_COUNT_NOTPRESENT_ZERO", statedCount);
                    break;
                }
                case "supplement": {
                    CodeSystem css = this.context.fetchCodeSystem(supp);
                    if (css == null) break;
                    this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count == css.getCount(), "CODESYSTEM_CS_COUNT_SUPPLEMENT_WRONG", css.getCount(), statedCount);
                    break;
                }
            }
        }
        if ("not-present".equals(content) && (concepts = cs.getChildrenByName("concept")).size() > 0) {
            this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, stack.push((Element)concepts.get(0), 0, null, null), false, "CODESYSTEM_CS_COUNT_NO_CONTENT_ALLOWED", new Object[0]);
        }
    }

    private boolean hasHeirarchy(Element cs) {
        for (Element c : cs.getChildren("concept")) {
            if (!c.hasChildren("concept")) continue;
            return true;
        }
        return false;
    }

    private boolean validateSupplementConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String supp, ValidationOptions options) {
        String code = concept.getChildValue("code");
        if (!Utilities.noString((String)code)) {
            ValidationResult res = this.context.validateCode(options, this.systemFromCanonical(supp), this.versionFromCanonical(supp), code, null);
            return this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), res.isOk(), "CODESYSTEM_CS_SUPP_INVALID_CODE", supp, code);
        }
        return true;
    }

    private int countConcepts(Element cs) {
        List concepts = cs.getChildrenByName("concept");
        int res = concepts.size();
        for (Element concept : concepts) {
            res += this.countConcepts(concept);
        }
        return res;
    }
}

