/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.PrintWriter;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.ConceptMapEngine;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;

public class TransformSupportServices
implements ITransformerServices {
    private final PrintWriter mapLog;
    private final SimpleWorkerContext context;
    private List<Base> outputs;

    public TransformSupportServices(List<Base> outputs, PrintWriter mapLog, SimpleWorkerContext context) {
        this.outputs = outputs;
        this.mapLog = mapLog;
        this.context = context;
    }

    public void log(String message) {
        if (this.mapLog != null) {
            this.mapLog.println(message);
        }
        System.out.println(message);
    }

    public Base createType(Object appInfo, String name) throws FHIRException {
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, name);
        return Manager.build((IWorkerContext)this.context, (StructureDefinition)sd);
    }

    public Base createResource(Object appInfo, Base res, boolean atRootofTransform) {
        if (atRootofTransform) {
            this.outputs.add(res);
        }
        return res;
    }

    public Coding translate(Object appInfo, Coding source, String conceptMapUrl) throws FHIRException {
        ConceptMapEngine cme = new ConceptMapEngine(this.context);
        return cme.translate(source, conceptMapUrl);
    }

    public Base resolveReference(Object appContext, String url) throws FHIRException {
        throw new FHIRException("resolveReference is not supported yet");
    }

    public List<Base> performSearch(Object appContext, String url) throws FHIRException {
        throw new FHIRException("performSearch is not supported yet");
    }
}

