/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SnomedCTChecker
extends CodeSystemChecker {
    private boolean noTag = false;
    private boolean hasTag = false;

    public SnomedCTChecker(IWorkerContext context, XVerExtensionManager xverManager, boolean debug, List<ValidationMessage> errors) {
        super(context, xverManager, debug, errors);
    }

    @Override
    public void checkConcept(String code, String display) {
        super.checkConcept(code, display);
        if (!Utilities.noString((String)display)) {
            boolean tagged;
            boolean bl = tagged = display.endsWith(")") && display.indexOf("(") > display.length() - 20;
            if (tagged) {
                this.hasTag = true;
            } else {
                this.noTag = true;
            }
        }
    }

    @Override
    public void finish(Element inc, NodeStack stack) {
        super.finish(inc, stack);
        this.hint((List<ValidationMessage>)this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, inc.line(), inc.col(), stack.getLiteralPath(), !this.noTag || !this.hasTag, "VALUESET_CONCEPT_DISPLAY_SCT_TAG_MIXED");
    }
}

