/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.PrintStream;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.tasks.ValidationEngineTask;
import org.hl7.fhir.validation.cli.utils.EngineMode;

public class SpreadsheetTask
extends ValidationEngineTask {
    @Override
    public String getName() {
        return "spreadsheet";
    }

    @Override
    public String getDisplayName() {
        return "Spreadsheet";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return cliContext.getMode() == EngineMode.SPREADSHEET;
    }

    @Override
    public void printHelp(PrintStream out) {
    }

    @Override
    public void executeTask(ValidationService validationService, ValidationEngine validationEngine, CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        validationService.generateSpreadsheet(cliContext, validationEngine);
    }
}

