/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.testexecutor;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.hl7.fhir.utilities.tests.TestConfig;
import org.hl7.fhir.utilities.tests.execution.CliTestSummary;
import org.hl7.fhir.utilities.tests.execution.ModuleTestExecutor;
import org.hl7.fhir.utilities.tests.execution.junit4.JUnit4TestExecutor;
import org.hl7.fhir.utilities.tests.execution.junit5.JUnit5ModuleTestExecutor;
import org.hl7.fhir.validation.testexecutor.TestModules;
import org.hl7.fhir.validation.testexecutor.TxCacheResourceExtractor;

public class TestExecutor {
    private final List<ModuleTestExecutor> jUnit4TestExecutors;
    private final List<ModuleTestExecutor> jUnit5TestExecutors;
    public static final String TX_CACHE = "txCache";
    private static String SUMMARY_TEMPLATE = "Tests run: %d, Failures: %d, Errors: %d, Skipped: %d";
    private static final String DOT_PLACEHOLDER = new String(new char[53]).replace("\u0000", ".");
    private static final int MAX_NAME_LENGTH = 50;

    public TestExecutor(String[] moduleNamesArg) {
        this(TestExecutor.getjUnit4TestExecutors(moduleNamesArg), TestExecutor.getjUnit5TestExecutors(moduleNamesArg));
    }

    protected TestExecutor(List<ModuleTestExecutor> jUnit4TestExecutors, List<ModuleTestExecutor> jUnit5TestExecutors) {
        this.jUnit4TestExecutors = jUnit4TestExecutors;
        this.jUnit5TestExecutors = jUnit5TestExecutors;
    }

    private String getModuleResultLine(String moduleName, CliTestSummary moduleTestSummary) {
        return this.getModuleNameAndSpacer(moduleName) + " " + this.getModuleResultString(moduleTestSummary);
    }

    private String getModuleNameAndSpacer(String moduleName) {
        return moduleName.length() < 50 ? moduleName + " " + DOT_PLACEHOLDER.substring(moduleName.length() + 1) : moduleName.substring(0, 50) + "...";
    }

    private String getModuleResultString(CliTestSummary cliTestSummary) {
        if (cliTestSummary.getTestsFoundCount() == 0L) {
            return "NO TESTS";
        }
        return cliTestSummary.getTestsFailedCount() == 0L && cliTestSummary.getTestsAbortedCount() == 0L ? "PASSED" : "FAILED";
    }

    public static boolean pathExistsAsDirectory(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    public void executeTests(String classNameFilterArg, String txCacheDirectoryPath, String testCasesDirectoryPath) {
        long start = System.currentTimeMillis();
        List<ModuleTestExecutor> jUnit4TestExecutors = this.getJUnit4TestExecutors();
        TestConfig.getInstance().setRebuildCache(true);
        this.setUpDirectories(txCacheDirectoryPath, testCasesDirectoryPath);
        List<ModuleTestExecutor> jUnit5TestExecutors = this.getJUnit5TestExecutors();
        long testsFoundCount = 0L;
        long testsFailedCount = 0L;
        long testsAbortedCount = 0L;
        long testsSkippedCount = 0L;
        HashMap<String, CliTestSummary> moduleResultMap = new HashMap<String, CliTestSummary>();
        List orderedModuleTestExecutors = Stream.concat(jUnit5TestExecutors.stream(), jUnit4TestExecutors.stream()).collect(Collectors.toList());
        for (ModuleTestExecutor moduleTestExecutor : orderedModuleTestExecutors) {
            CliTestSummary testExecutionSummary = moduleTestExecutor.executeTests(System.out, classNameFilterArg);
            testsFoundCount += testExecutionSummary.getTestsFoundCount();
            testsFailedCount += testExecutionSummary.getTestsFailedCount();
            testsAbortedCount += testExecutionSummary.getTestsAbortedCount();
            testsSkippedCount += testExecutionSummary.getTestsSkippedCount();
            moduleResultMap.put(moduleTestExecutor.getModuleName(), testExecutionSummary);
        }
        System.out.println("\n\nAll Tests completed.");
        for (ModuleTestExecutor moduleTestExecutor : orderedModuleTestExecutors) {
            ModuleTestExecutor.printSummmary((PrintStream)System.out, (CliTestSummary)((CliTestSummary)moduleResultMap.get(moduleTestExecutor.getModuleName())), (String)moduleTestExecutor.getModuleName());
        }
        System.out.println("\nModule Results:\n");
        for (ModuleTestExecutor moduleTestExecutor : orderedModuleTestExecutors) {
            System.out.println(this.getModuleResultLine(moduleTestExecutor.getModuleName(), (CliTestSummary)moduleResultMap.get(moduleTestExecutor.getModuleName())));
        }
        System.out.println();
        System.out.println(String.format(SUMMARY_TEMPLATE, testsFoundCount, testsFailedCount, testsAbortedCount, testsSkippedCount));
        System.out.println("\nCompleted in " + (System.currentTimeMillis() - start) + "ms");
    }

    protected void setUpDirectories(String txCacheDirectoryPath, String testCasesDirectoryPath) {
        if (testCasesDirectoryPath == null || !TestExecutor.pathExistsAsDirectory(testCasesDirectoryPath)) {
            throw new RuntimeException("fhir-test-cases directory does not exist: " + testCasesDirectoryPath);
        }
        TestConfig.getInstance().setFhirTestCasesDirectory(testCasesDirectoryPath);
        try {
            String txCacheDirectory = TestExecutor.getOrCreateTxCacheDirectory(txCacheDirectoryPath);
            if (!TestExecutor.pathExistsAsDirectory(testCasesDirectoryPath)) {
                throw new RuntimeException("txCache directory does not exist: " + txCacheDirectory);
            }
            TestConfig.getInstance().setTxCacheDirectory(txCacheDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temporary resource directory.", e);
        }
    }

    private static String getOrCreateTxCacheDirectory(String txCacheDirectoryParam) throws IOException {
        String txCacheDirectory;
        if (txCacheDirectoryParam != null) {
            txCacheDirectory = txCacheDirectoryParam;
        } else {
            txCacheDirectory = Files.createTempDirectory("validator-test-tx-cache", new FileAttribute[0]).toFile().getAbsolutePath();
            TxCacheResourceExtractor.extractTxCacheResources(txCacheDirectory);
        }
        return txCacheDirectory;
    }

    @Nonnull
    public static List<ModuleTestExecutor> getjUnit5TestExecutors(String[] moduleNamesArg) {
        String[] moduleNames = moduleNamesArg == null ? TestModules.JUNIT5_MODULE_NAMES : moduleNamesArg;
        return Arrays.stream(moduleNames).map(moduleName -> JUnit5ModuleTestExecutor.getStandardModuleTestExecutor((String)moduleName)).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ModuleTestExecutor> getjUnit4TestExecutors(String[] moduleNamesArg) {
        List<ModuleTestExecutor> jUnit4TestExecutors = Arrays.asList(new JUnit4TestExecutor("org.hl7.fhir.validation", TestModules.JUNIT4_CLASSNAMES));
        if (moduleNamesArg == null) {
            return jUnit4TestExecutors;
        }
        return Arrays.stream(moduleNamesArg).anyMatch(moduleName -> "org.hl7.fhir.validation".equals(moduleName)) ? jUnit4TestExecutors : Arrays.asList(new ModuleTestExecutor[0]);
    }

    public List<ModuleTestExecutor> getJUnit4TestExecutors() {
        return this.jUnit4TestExecutors;
    }

    public List<ModuleTestExecutor> getJUnit5TestExecutors() {
        return this.jUnit5TestExecutors;
    }
}

