/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class ValueSetValidator
extends BaseValidator {
    private InstanceValidator parent;

    private SystemLevelValidator getSystemValidator(String system, List<ValidationMessage> errors, Element inc, NodeStack stack) {
        if (system == null) {
            return new GeneralValidator(errors, inc, stack);
        }
        switch (system) {
            case "http://snomed.info/sct": {
                return new SnomedCTValidator(errors, inc, stack);
            }
        }
        return new GeneralValidator(errors, inc, stack);
    }

    public ValueSetValidator(IWorkerContext context, boolean debug, TimeTracker timeTracker, InstanceValidator parent, XVerExtensionManager xverManager, Coding jurisdiction, boolean allowExamples) {
        super(context, xverManager, debug);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.timeTracker = timeTracker;
        this.parent = parent;
        this.jurisdiction = jurisdiction;
        this.allowExamples = allowExamples;
    }

    public boolean validateValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        boolean ok = true;
        if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            List composes = vs.getChildrenByName("compose");
            int cc = 0;
            for (Element compose : composes) {
                ok = this.validateValueSetCompose(errors, compose, stack.push(compose, cc, null, null), vs.getNamedChildValue("url"), "retired".equals(vs.getNamedChildValue("url"))) & ok;
                ++cc;
            }
        }
        if (!stack.isContained()) {
            ok = this.checkShareableValueSet(errors, vs, stack) && ok;
        }
        return ok;
    }

    private boolean checkShareableValueSet(List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(vs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("url"), "VALUESET_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("version"), "VALUESET_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("title"), "VALUESET_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("name"), "VALUESET_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("status"), "VALUESET_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("experimental"), "VALUESET_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("description"), "VALUESET_SHAREABLE_MISSING_HL7", "description") && ok;
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("url"), "VALUESET_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("version"), "VALUESET_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("title"), "VALUESET_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("name"), "VALUESET_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("status"), "VALUESET_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("experimental"), "VALUESET_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, vs.line(), vs.col(), stack.getLiteralPath(), vs.hasChild("description"), "VALUESET_SHAREABLE_MISSING", "description");
        }
        return true;
    }

    private boolean validateValueSetCompose(List<ValidationMessage> errors, Element compose, NodeStack stack, String vsid, boolean retired) {
        boolean ok = true;
        List includes = compose.getChildrenByName("include");
        int ci = 0;
        for (Element include : includes) {
            ok = this.validateValueSetInclude(errors, include, stack.push(include, ci, null, null), vsid, retired) && ok;
            ++ci;
        }
        List excludes = compose.getChildrenByName("exclude");
        int ce = 0;
        for (Element exclude : excludes) {
            ok = this.validateValueSetInclude(errors, exclude, stack.push(exclude, ce, null, null), vsid, retired) && ok;
            ++ce;
        }
        return ok;
    }

    private boolean validateValueSetInclude(List<ValidationMessage> errors, Element include, NodeStack stack, String vsid, boolean retired) {
        boolean ok = true;
        String system = include.getChildValue("system");
        String version = include.getChildValue("version");
        List valuesets = include.getChildrenByName("valueSet");
        int i = 0;
        for (Element ve : valuesets) {
            String v = ve.getValue();
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, v);
            if (vs == null) {
                NodeStack ns = stack.push(ve, i, ve.getProperty().getDefinition(), ve.getProperty().getDefinition());
                Resource rs = this.context.fetchResource(Resource.class, v);
                if (rs != null) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_INVALID_TYPE", v, rs.fhirType());
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_UNKNOWN", v);
                }
            }
            ++i;
        }
        if (valuesets.size() > 1) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, stack.getLiteralPath(), false, "VALUESET_IMPORT_UNION_INTERSECTION", new Object[0]);
        }
        List concepts = include.getChildrenByName("concept");
        List filters = include.getChildrenByName("filter");
        SystemLevelValidator slv = this.getSystemValidator(system, errors, include, stack);
        if (!Utilities.noString((String)system)) {
            boolean systemOk = true;
            int cc = 0;
            ArrayList<VSCodingValidationRequest> batch = new ArrayList<VSCodingValidationRequest>();
            boolean first = true;
            for (Element concept : concepts) {
                if (first) {
                    systemOk = this.validateValueSetIncludeConcept(errors, concept, stack, stack.push(concept, cc, null, null), system, version, slv);
                    first = false;
                } else if (systemOk) {
                    batch.add(this.prepareValidateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version, slv));
                }
                ++cc;
            }
            if (this.parent.isValidateValueSetCodesOnTxServer() && batch.size() > 0 & !this.context.isNoTerminologyServer()) {
                long t = System.currentTimeMillis();
                if (this.parent.isDebug()) {
                    System.out.println("  : Validate " + batch.size() + " codes from " + system + " for " + vsid);
                }
                try {
                    this.context.validateCodeBatch(ValidationOptions.defaults(), batch, null);
                    if (this.parent.isDebug()) {
                        System.out.println("  :   .. " + (System.currentTimeMillis() - t) + "ms");
                    }
                    for (VSCodingValidationRequest cv : batch) {
                        if (version == null) {
                            ok = this.warningOrHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, cv.getCoding().getCode()) && ok;
                            continue;
                        }
                        ok = this.warningOrHint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack().getLiteralPath(), cv.getResult().isOk(), !retired, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, cv.getCoding().getCode()) && ok;
                    }
                }
                catch (Exception e) {
                    VSCodingValidationRequest cv;
                    ok = false;
                    cv = (VSCodingValidationRequest)((Object)batch.get(0));
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, cv.getStack().getLiteralPath(), false, e.getMessage(), new Object[0]);
                }
            }
            int cf = 0;
            for (Element filter : filters) {
                if (systemOk && !this.validateValueSetIncludeFilter(errors, include, stack.push(filter, cf, null, null), system, version, slv)) {
                    systemOk = false;
                }
                ++cf;
            }
            slv.finish();
        } else {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), filters.size() == 0 && concepts.size() == 0, "VALUESET_NO_SYSTEM_WARNING", new Object[0]);
        }
        return ok;
    }

    private boolean validateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stackInc, NodeStack stack, String system, String version, SystemLevelValidator slv) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        if (version == null) {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null), null);
            if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                if (this.isExampleUrl(system)) {
                    if (this.isAllowExamples()) {
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_HINT", system);
                    } else {
                        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_ERROR", system);
                    }
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING", system, vv.getMessage());
                }
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, code);
            if (vv.getMessage() != null) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, vv.getMessage(), new Object[0]);
            }
        } else {
            IWorkerContext.ValidationResult vv = this.context.validateCode(ValidationOptions.defaults(), new Coding(system, code, null).setVersion(version), null);
            if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING_VER", system + "#" + version, vv.getMessage());
                return false;
            }
            boolean ok = vv.isOk();
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, code);
            if (vv.getMessage() != null) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, vv.getMessage(), new Object[0]);
            }
        }
        return true;
    }

    private VSCodingValidationRequest prepareValidateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version, SystemLevelValidator slv) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        Coding c = new Coding(system, code, null);
        if (version != null) {
            c.setVersion(version);
        }
        return new VSCodingValidationRequest(stack, c);
    }

    private boolean validateValueSetIncludeFilter(List<ValidationMessage> errors, Element filter, NodeStack push, String system, String version, SystemLevelValidator slv) {
        return true;
    }

    public class VSCodingValidationRequest
    extends IWorkerContext.CodingValidationRequest {
        private NodeStack stack;

        public VSCodingValidationRequest(NodeStack stack, Coding code) {
            super(code);
            this.stack = stack;
        }

        public NodeStack getStack() {
            return this.stack;
        }
    }

    public class GeneralValidator
    extends SystemLevelValidator {
        protected GeneralValidator(List<ValidationMessage> errors, Element inc, NodeStack stack) {
            super(errors, inc, stack);
        }
    }

    public class SnomedCTValidator
    extends SystemLevelValidator {
        private boolean noTag;
        private boolean hasTag;

        protected SnomedCTValidator(List<ValidationMessage> errors, Element inc, NodeStack stack) {
            super(errors, inc, stack);
            this.noTag = false;
            this.hasTag = false;
        }

        @Override
        public void checkConcept(String code, String display) {
            super.checkConcept(code, display);
            if (!Utilities.noString((String)display)) {
                boolean tagged;
                boolean bl = tagged = display.endsWith(")") && display.indexOf("(") > display.length() - 20;
                if (tagged) {
                    this.hasTag = true;
                } else {
                    this.noTag = true;
                }
            }
        }

        @Override
        public void finish() {
            ValueSetValidator.this.hint((List<ValidationMessage>)this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, this.inc.line(), this.inc.col(), this.stack.getLiteralPath(), !this.noTag || !this.hasTag, "VALUESET_CONCEPT_DISPLAY_SCT_TAG_MIXED");
        }
    }

    public class SystemLevelValidator {
        protected List<ValidationMessage> errors;
        protected Element inc;
        protected NodeStack stack;
        private boolean noDisplay = false;
        private boolean hasDisplay = false;

        protected SystemLevelValidator(List<ValidationMessage> errors, Element inc, NodeStack stack) {
            this.errors = errors;
            this.inc = inc;
            this.stack = stack;
        }

        public void checkConcept(String code, String display) {
            if (Utilities.noString((String)display)) {
                this.noDisplay = true;
            } else {
                this.hasDisplay = true;
            }
        }

        public void finish() {
            ValueSetValidator.this.hint((List<ValidationMessage>)this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, this.inc.line(), this.inc.col(), this.stack.getLiteralPath(), !this.noDisplay || !this.hasDisplay, "VALUESET_CONCEPT_DISPLAY_PRESENCE_MIXED");
        }
    }
}

